# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of OTR (order-to-trade) limits and other limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool or TGE. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The PowerBot service is available at the following REST endpoints:  | Instance                | Base URL for REST Endpoints                                           | |-------------------------|-----------------------------------------------------------------------| | Test (EPEX)             | https://staging.powerbot-trading.com/playground/epex/v2/api           | | Test (Nord Pool)        | https://staging.powerbot-trading.com/playground/nordpool/v2/api       | | Test (HUPX)             | https://staging.powerbot-trading.com/playground/hupx/v2/api           | | Test (BSP Southpool)    | https://staging.powerbot-trading.com/playground/southpool/v2/api      | | Test (TGE)              | https://staging.powerbot-trading.com/playground/tge/v2/api            | | Test (IBEX)             | https://staging.powerbot-trading.com/playground/ibex/v2/api           | | Test (CROPEX)           | https://staging.powerbot-trading.com/playground/cropex/v2/api         | | Staging, Production     | Provided on request                                                   |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at https://github.com/powerbot-trading.  # noqa: E501

    The version of the OpenAPI document: 2.3.0
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from powerbot_client.configuration import Configuration


class Contract(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'product': 'str',
        'contract_id': 'str',
        'sequence_number': 'int',
        'type': 'ContractType',
        'state': 'str',
        'active_since': 'datetime',
        'name': 'str',
        'del_units': 'float',
        'revision_no': 'int',
        'delivery_start': 'datetime',
        'delivery_end': 'datetime',
        'best_bid_price': 'float',
        'best_bid_quantity': 'float',
        'best_ask_price': 'float',
        'best_ask_quantity': 'float',
        'last_price': 'float',
        'last_quantity': 'float',
        'total_quantity': 'float',
        'auction_price': 'float',
        'high': 'float',
        'low': 'float',
        'last_trade_time': 'datetime',
        'signals': 'list[Signal]',
        'vwap': 'float',
        'avwa': 'float',
        'bvwa': 'float',
        'exchange_otr': 'float',
        'tenant_otr': 'float',
        'trading_start': 'datetime',
        'trading_end': 'datetime',
        'portfolio_information': 'list[PortfolioInformation]'
    }

    attribute_map = {
        'product': 'product',
        'contract_id': 'contract_id',
        'sequence_number': 'sequence_number',
        'type': 'type',
        'state': 'state',
        'active_since': 'active_since',
        'name': 'name',
        'del_units': 'delUnits',
        'revision_no': 'revision_no',
        'delivery_start': 'delivery_start',
        'delivery_end': 'delivery_end',
        'best_bid_price': 'best_bid_price',
        'best_bid_quantity': 'best_bid_quantity',
        'best_ask_price': 'best_ask_price',
        'best_ask_quantity': 'best_ask_quantity',
        'last_price': 'last_price',
        'last_quantity': 'last_quantity',
        'total_quantity': 'total_quantity',
        'auction_price': 'auction_price',
        'high': 'high',
        'low': 'low',
        'last_trade_time': 'last_trade_time',
        'signals': 'signals',
        'vwap': 'vwap',
        'avwa': 'avwa',
        'bvwa': 'bvwa',
        'exchange_otr': 'exchange_otr',
        'tenant_otr': 'tenant_otr',
        'trading_start': 'trading_start',
        'trading_end': 'trading_end',
        'portfolio_information': 'portfolio_information'
    }

    def __init__(self, product=None, contract_id=None, sequence_number=None, type=None, state=None, active_since=None, name=None, del_units=None, revision_no=None, delivery_start=None, delivery_end=None, best_bid_price=None, best_bid_quantity=None, best_ask_price=None, best_ask_quantity=None, last_price=None, last_quantity=None, total_quantity=None, auction_price=None, high=None, low=None, last_trade_time=None, signals=None, vwap=None, avwa=None, bvwa=None, exchange_otr=None, tenant_otr=None, trading_start=None, trading_end=None, portfolio_information=None, local_vars_configuration=None):  # noqa: E501
        """Contract - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._product = None
        self._contract_id = None
        self._sequence_number = None
        self._type = None
        self._state = None
        self._active_since = None
        self._name = None
        self._del_units = None
        self._revision_no = None
        self._delivery_start = None
        self._delivery_end = None
        self._best_bid_price = None
        self._best_bid_quantity = None
        self._best_ask_price = None
        self._best_ask_quantity = None
        self._last_price = None
        self._last_quantity = None
        self._total_quantity = None
        self._auction_price = None
        self._high = None
        self._low = None
        self._last_trade_time = None
        self._signals = None
        self._vwap = None
        self._avwa = None
        self._bvwa = None
        self._exchange_otr = None
        self._tenant_otr = None
        self._trading_start = None
        self._trading_end = None
        self._portfolio_information = None
        self.discriminator = None

        if product is not None:
            self.product = product
        if contract_id is not None:
            self.contract_id = contract_id
        if sequence_number is not None:
            self.sequence_number = sequence_number
        if type is not None:
            self.type = type
        if state is not None:
            self.state = state
        if active_since is not None:
            self.active_since = active_since
        if name is not None:
            self.name = name
        if del_units is not None:
            self.del_units = del_units
        if revision_no is not None:
            self.revision_no = revision_no
        if delivery_start is not None:
            self.delivery_start = delivery_start
        if delivery_end is not None:
            self.delivery_end = delivery_end
        if best_bid_price is not None:
            self.best_bid_price = best_bid_price
        if best_bid_quantity is not None:
            self.best_bid_quantity = best_bid_quantity
        if best_ask_price is not None:
            self.best_ask_price = best_ask_price
        if best_ask_quantity is not None:
            self.best_ask_quantity = best_ask_quantity
        if last_price is not None:
            self.last_price = last_price
        if last_quantity is not None:
            self.last_quantity = last_quantity
        if total_quantity is not None:
            self.total_quantity = total_quantity
        if auction_price is not None:
            self.auction_price = auction_price
        if high is not None:
            self.high = high
        if low is not None:
            self.low = low
        if last_trade_time is not None:
            self.last_trade_time = last_trade_time
        if signals is not None:
            self.signals = signals
        if vwap is not None:
            self.vwap = vwap
        if avwa is not None:
            self.avwa = avwa
        if bvwa is not None:
            self.bvwa = bvwa
        if exchange_otr is not None:
            self.exchange_otr = exchange_otr
        if tenant_otr is not None:
            self.tenant_otr = tenant_otr
        if trading_start is not None:
            self.trading_start = trading_start
        if trading_end is not None:
            self.trading_end = trading_end
        if portfolio_information is not None:
            self.portfolio_information = portfolio_information

    @property
    def product(self):
        """Gets the product of this Contract.  # noqa: E501

        the contract's product  # noqa: E501

        :return: The product of this Contract.  # noqa: E501
        :rtype: str
        """
        return self._product

    @product.setter
    def product(self, product):
        """Sets the product of this Contract.

        the contract's product  # noqa: E501

        :param product: The product of this Contract.  # noqa: E501
        :type product: str
        """

        self._product = product

    @property
    def contract_id(self):
        """Gets the contract_id of this Contract.  # noqa: E501

        The contract's unique id  # noqa: E501

        :return: The contract_id of this Contract.  # noqa: E501
        :rtype: str
        """
        return self._contract_id

    @contract_id.setter
    def contract_id(self, contract_id):
        """Sets the contract_id of this Contract.

        The contract's unique id  # noqa: E501

        :param contract_id: The contract_id of this Contract.  # noqa: E501
        :type contract_id: str
        """

        self._contract_id = contract_id

    @property
    def sequence_number(self):
        """Gets the sequence_number of this Contract.  # noqa: E501


        :return: The sequence_number of this Contract.  # noqa: E501
        :rtype: int
        """
        return self._sequence_number

    @sequence_number.setter
    def sequence_number(self, sequence_number):
        """Sets the sequence_number of this Contract.


        :param sequence_number: The sequence_number of this Contract.  # noqa: E501
        :type sequence_number: int
        """

        self._sequence_number = sequence_number

    @property
    def type(self):
        """Gets the type of this Contract.  # noqa: E501


        :return: The type of this Contract.  # noqa: E501
        :rtype: ContractType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Contract.


        :param type: The type of this Contract.  # noqa: E501
        :type type: ContractType
        """

        self._type = type

    @property
    def state(self):
        """Gets the state of this Contract.  # noqa: E501

        State of the contract  # noqa: E501

        :return: The state of this Contract.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this Contract.

        State of the contract  # noqa: E501

        :param state: The state of this Contract.  # noqa: E501
        :type state: str
        """
        allowed_values = ["ACTI", "IACT"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and state not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}"  # noqa: E501
                .format(state, allowed_values)
            )

        self._state = state

    @property
    def active_since(self):
        """Gets the active_since of this Contract.  # noqa: E501

        The timestamp (UTC) since when the contract has been observed as active for trading in the corresponding delivery area. Is reset to current time after a system or market outage or after the market was hibernated. Can be used to determine potential low liquidity situations after activation of new contracts or market outages.  # noqa: E501

        :return: The active_since of this Contract.  # noqa: E501
        :rtype: datetime
        """
        return self._active_since

    @active_since.setter
    def active_since(self, active_since):
        """Sets the active_since of this Contract.

        The timestamp (UTC) since when the contract has been observed as active for trading in the corresponding delivery area. Is reset to current time after a system or market outage or after the market was hibernated. Can be used to determine potential low liquidity situations after activation of new contracts or market outages.  # noqa: E501

        :param active_since: The active_since of this Contract.  # noqa: E501
        :type active_since: datetime
        """

        self._active_since = active_since

    @property
    def name(self):
        """Gets the name of this Contract.  # noqa: E501

        The name of the contract  # noqa: E501

        :return: The name of this Contract.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Contract.

        The name of the contract  # noqa: E501

        :param name: The name of this Contract.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def del_units(self):
        """Gets the del_units of this Contract.  # noqa: E501

        Delivery unit of the respective product. In case of product with type User-Defined Delivery Period this attribute is stored only with contract.  # noqa: E501

        :return: The del_units of this Contract.  # noqa: E501
        :rtype: float
        """
        return self._del_units

    @del_units.setter
    def del_units(self, del_units):
        """Sets the del_units of this Contract.

        Delivery unit of the respective product. In case of product with type User-Defined Delivery Period this attribute is stored only with contract.  # noqa: E501

        :param del_units: The del_units of this Contract.  # noqa: E501
        :type del_units: float
        """

        self._del_units = del_units

    @property
    def revision_no(self):
        """Gets the revision_no of this Contract.  # noqa: E501

        A running number starting at 0; Every time the contract changes (i.e. a trade is made), this number increments.  # noqa: E501

        :return: The revision_no of this Contract.  # noqa: E501
        :rtype: int
        """
        return self._revision_no

    @revision_no.setter
    def revision_no(self, revision_no):
        """Sets the revision_no of this Contract.

        A running number starting at 0; Every time the contract changes (i.e. a trade is made), this number increments.  # noqa: E501

        :param revision_no: The revision_no of this Contract.  # noqa: E501
        :type revision_no: int
        """

        self._revision_no = revision_no

    @property
    def delivery_start(self):
        """Gets the delivery_start of this Contract.  # noqa: E501

        The delivery start time (UTC) of the contract  # noqa: E501

        :return: The delivery_start of this Contract.  # noqa: E501
        :rtype: datetime
        """
        return self._delivery_start

    @delivery_start.setter
    def delivery_start(self, delivery_start):
        """Sets the delivery_start of this Contract.

        The delivery start time (UTC) of the contract  # noqa: E501

        :param delivery_start: The delivery_start of this Contract.  # noqa: E501
        :type delivery_start: datetime
        """

        self._delivery_start = delivery_start

    @property
    def delivery_end(self):
        """Gets the delivery_end of this Contract.  # noqa: E501

        The delivery end time (UTC) of the contract  # noqa: E501

        :return: The delivery_end of this Contract.  # noqa: E501
        :rtype: datetime
        """
        return self._delivery_end

    @delivery_end.setter
    def delivery_end(self, delivery_end):
        """Sets the delivery_end of this Contract.

        The delivery end time (UTC) of the contract  # noqa: E501

        :param delivery_end: The delivery_end of this Contract.  # noqa: E501
        :type delivery_end: datetime
        """

        self._delivery_end = delivery_end

    @property
    def best_bid_price(self):
        """Gets the best_bid_price of this Contract.  # noqa: E501

        The best bid's price in the orderbook's currency (i.e. EUR)  # noqa: E501

        :return: The best_bid_price of this Contract.  # noqa: E501
        :rtype: float
        """
        return self._best_bid_price

    @best_bid_price.setter
    def best_bid_price(self, best_bid_price):
        """Sets the best_bid_price of this Contract.

        The best bid's price in the orderbook's currency (i.e. EUR)  # noqa: E501

        :param best_bid_price: The best_bid_price of this Contract.  # noqa: E501
        :type best_bid_price: float
        """

        self._best_bid_price = best_bid_price

    @property
    def best_bid_quantity(self):
        """Gets the best_bid_quantity of this Contract.  # noqa: E501

        The best bid's quantity in the orderbook's quantity unit (i.e. MW)  # noqa: E501

        :return: The best_bid_quantity of this Contract.  # noqa: E501
        :rtype: float
        """
        return self._best_bid_quantity

    @best_bid_quantity.setter
    def best_bid_quantity(self, best_bid_quantity):
        """Sets the best_bid_quantity of this Contract.

        The best bid's quantity in the orderbook's quantity unit (i.e. MW)  # noqa: E501

        :param best_bid_quantity: The best_bid_quantity of this Contract.  # noqa: E501
        :type best_bid_quantity: float
        """

        self._best_bid_quantity = best_bid_quantity

    @property
    def best_ask_price(self):
        """Gets the best_ask_price of this Contract.  # noqa: E501

        The best asks's price in the orderbook's currency (i.e. EUR)  # noqa: E501

        :return: The best_ask_price of this Contract.  # noqa: E501
        :rtype: float
        """
        return self._best_ask_price

    @best_ask_price.setter
    def best_ask_price(self, best_ask_price):
        """Sets the best_ask_price of this Contract.

        The best asks's price in the orderbook's currency (i.e. EUR)  # noqa: E501

        :param best_ask_price: The best_ask_price of this Contract.  # noqa: E501
        :type best_ask_price: float
        """

        self._best_ask_price = best_ask_price

    @property
    def best_ask_quantity(self):
        """Gets the best_ask_quantity of this Contract.  # noqa: E501

        The best asks's quantity in the orderbook's quantity unit (i.e. MW)  # noqa: E501

        :return: The best_ask_quantity of this Contract.  # noqa: E501
        :rtype: float
        """
        return self._best_ask_quantity

    @best_ask_quantity.setter
    def best_ask_quantity(self, best_ask_quantity):
        """Sets the best_ask_quantity of this Contract.

        The best asks's quantity in the orderbook's quantity unit (i.e. MW)  # noqa: E501

        :param best_ask_quantity: The best_ask_quantity of this Contract.  # noqa: E501
        :type best_ask_quantity: float
        """

        self._best_ask_quantity = best_ask_quantity

    @property
    def last_price(self):
        """Gets the last_price of this Contract.  # noqa: E501

        The price of the last trade (in the orderbook's currency)  # noqa: E501

        :return: The last_price of this Contract.  # noqa: E501
        :rtype: float
        """
        return self._last_price

    @last_price.setter
    def last_price(self, last_price):
        """Sets the last_price of this Contract.

        The price of the last trade (in the orderbook's currency)  # noqa: E501

        :param last_price: The last_price of this Contract.  # noqa: E501
        :type last_price: float
        """

        self._last_price = last_price

    @property
    def last_quantity(self):
        """Gets the last_quantity of this Contract.  # noqa: E501

        The quantity of the last trade (in the orderbook's quantity unit)  # noqa: E501

        :return: The last_quantity of this Contract.  # noqa: E501
        :rtype: float
        """
        return self._last_quantity

    @last_quantity.setter
    def last_quantity(self, last_quantity):
        """Sets the last_quantity of this Contract.

        The quantity of the last trade (in the orderbook's quantity unit)  # noqa: E501

        :param last_quantity: The last_quantity of this Contract.  # noqa: E501
        :type last_quantity: float
        """

        self._last_quantity = last_quantity

    @property
    def total_quantity(self):
        """Gets the total_quantity of this Contract.  # noqa: E501

        The total volume of all trades (in the orderbook's quantity unit)  # noqa: E501

        :return: The total_quantity of this Contract.  # noqa: E501
        :rtype: float
        """
        return self._total_quantity

    @total_quantity.setter
    def total_quantity(self, total_quantity):
        """Sets the total_quantity of this Contract.

        The total volume of all trades (in the orderbook's quantity unit)  # noqa: E501

        :param total_quantity: The total_quantity of this Contract.  # noqa: E501
        :type total_quantity: float
        """

        self._total_quantity = total_quantity

    @property
    def auction_price(self):
        """Gets the auction_price of this Contract.  # noqa: E501

        The day-ahead auction price of this contract (only available on Nord Pool)  # noqa: E501

        :return: The auction_price of this Contract.  # noqa: E501
        :rtype: float
        """
        return self._auction_price

    @auction_price.setter
    def auction_price(self, auction_price):
        """Sets the auction_price of this Contract.

        The day-ahead auction price of this contract (only available on Nord Pool)  # noqa: E501

        :param auction_price: The auction_price of this Contract.  # noqa: E501
        :type auction_price: float
        """

        self._auction_price = auction_price

    @property
    def high(self):
        """Gets the high of this Contract.  # noqa: E501

        Highest traded price since the start of the trading period.  # noqa: E501

        :return: The high of this Contract.  # noqa: E501
        :rtype: float
        """
        return self._high

    @high.setter
    def high(self, high):
        """Sets the high of this Contract.

        Highest traded price since the start of the trading period.  # noqa: E501

        :param high: The high of this Contract.  # noqa: E501
        :type high: float
        """

        self._high = high

    @property
    def low(self):
        """Gets the low of this Contract.  # noqa: E501

        Lowest traded price since the start of the trading period  # noqa: E501

        :return: The low of this Contract.  # noqa: E501
        :rtype: float
        """
        return self._low

    @low.setter
    def low(self, low):
        """Sets the low of this Contract.

        Lowest traded price since the start of the trading period  # noqa: E501

        :param low: The low of this Contract.  # noqa: E501
        :type low: float
        """

        self._low = low

    @property
    def last_trade_time(self):
        """Gets the last_trade_time of this Contract.  # noqa: E501


        :return: The last_trade_time of this Contract.  # noqa: E501
        :rtype: datetime
        """
        return self._last_trade_time

    @last_trade_time.setter
    def last_trade_time(self, last_trade_time):
        """Sets the last_trade_time of this Contract.


        :param last_trade_time: The last_trade_time of this Contract.  # noqa: E501
        :type last_trade_time: datetime
        """

        self._last_trade_time = last_trade_time

    @property
    def signals(self):
        """Gets the signals of this Contract.  # noqa: E501

        The signals applicable for the contract  # noqa: E501

        :return: The signals of this Contract.  # noqa: E501
        :rtype: list[Signal]
        """
        return self._signals

    @signals.setter
    def signals(self, signals):
        """Sets the signals of this Contract.

        The signals applicable for the contract  # noqa: E501

        :param signals: The signals of this Contract.  # noqa: E501
        :type signals: list[Signal]
        """

        self._signals = signals

    @property
    def vwap(self):
        """Gets the vwap of this Contract.  # noqa: E501

        The volume weighted average price  # noqa: E501

        :return: The vwap of this Contract.  # noqa: E501
        :rtype: float
        """
        return self._vwap

    @vwap.setter
    def vwap(self, vwap):
        """Sets the vwap of this Contract.

        The volume weighted average price  # noqa: E501

        :param vwap: The vwap of this Contract.  # noqa: E501
        :type vwap: float
        """

        self._vwap = vwap

    @property
    def avwa(self):
        """Gets the avwa of this Contract.  # noqa: E501

        Ask volume weighted average price  # noqa: E501

        :return: The avwa of this Contract.  # noqa: E501
        :rtype: float
        """
        return self._avwa

    @avwa.setter
    def avwa(self, avwa):
        """Sets the avwa of this Contract.

        Ask volume weighted average price  # noqa: E501

        :param avwa: The avwa of this Contract.  # noqa: E501
        :type avwa: float
        """

        self._avwa = avwa

    @property
    def bvwa(self):
        """Gets the bvwa of this Contract.  # noqa: E501

        Bid volume weighted average price  # noqa: E501

        :return: The bvwa of this Contract.  # noqa: E501
        :rtype: float
        """
        return self._bvwa

    @bvwa.setter
    def bvwa(self, bvwa):
        """Sets the bvwa of this Contract.

        Bid volume weighted average price  # noqa: E501

        :param bvwa: The bvwa of this Contract.  # noqa: E501
        :type bvwa: float
        """

        self._bvwa = bvwa

    @property
    def exchange_otr(self):
        """Gets the exchange_otr of this Contract.  # noqa: E501

        DEPRECATED: use exchange_otr from portfolio_information instead The OTR for this contract  # noqa: E501

        :return: The exchange_otr of this Contract.  # noqa: E501
        :rtype: float
        """
        return self._exchange_otr

    @exchange_otr.setter
    def exchange_otr(self, exchange_otr):
        """Sets the exchange_otr of this Contract.

        DEPRECATED: use exchange_otr from portfolio_information instead The OTR for this contract  # noqa: E501

        :param exchange_otr: The exchange_otr of this Contract.  # noqa: E501
        :type exchange_otr: float
        """

        self._exchange_otr = exchange_otr

    @property
    def tenant_otr(self):
        """Gets the tenant_otr of this Contract.  # noqa: E501

        DEPRECATED: use tenant_otr from portfolio_information instead The OTR for this contract for your tenant  # noqa: E501

        :return: The tenant_otr of this Contract.  # noqa: E501
        :rtype: float
        """
        return self._tenant_otr

    @tenant_otr.setter
    def tenant_otr(self, tenant_otr):
        """Sets the tenant_otr of this Contract.

        DEPRECATED: use tenant_otr from portfolio_information instead The OTR for this contract for your tenant  # noqa: E501

        :param tenant_otr: The tenant_otr of this Contract.  # noqa: E501
        :type tenant_otr: float
        """

        self._tenant_otr = tenant_otr

    @property
    def trading_start(self):
        """Gets the trading_start of this Contract.  # noqa: E501

        The trading start time (UTC) of the contract (only available when the contract is active)  # noqa: E501

        :return: The trading_start of this Contract.  # noqa: E501
        :rtype: datetime
        """
        return self._trading_start

    @trading_start.setter
    def trading_start(self, trading_start):
        """Sets the trading_start of this Contract.

        The trading start time (UTC) of the contract (only available when the contract is active)  # noqa: E501

        :param trading_start: The trading_start of this Contract.  # noqa: E501
        :type trading_start: datetime
        """

        self._trading_start = trading_start

    @property
    def trading_end(self):
        """Gets the trading_end of this Contract.  # noqa: E501

        The trading end time (UTC) of the contract (only available when the contract is active)  # noqa: E501

        :return: The trading_end of this Contract.  # noqa: E501
        :rtype: datetime
        """
        return self._trading_end

    @trading_end.setter
    def trading_end(self, trading_end):
        """Sets the trading_end of this Contract.

        The trading end time (UTC) of the contract (only available when the contract is active)  # noqa: E501

        :param trading_end: The trading_end of this Contract.  # noqa: E501
        :type trading_end: datetime
        """

        self._trading_end = trading_end

    @property
    def portfolio_information(self):
        """Gets the portfolio_information of this Contract.  # noqa: E501


        :return: The portfolio_information of this Contract.  # noqa: E501
        :rtype: list[PortfolioInformation]
        """
        return self._portfolio_information

    @portfolio_information.setter
    def portfolio_information(self, portfolio_information):
        """Sets the portfolio_information of this Contract.


        :param portfolio_information: The portfolio_information of this Contract.  # noqa: E501
        :type portfolio_information: list[PortfolioInformation]
        """

        self._portfolio_information = portfolio_information

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Contract):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Contract):
            return True

        return self.to_dict() != other.to_dict()
