# coding= utf-8

ERROR = 1
EXCEPTION = 2
GET_NOT_FOUND = 3
POST_NOT_FOUND = 4
PATCH_NOT_FOUND = 5
PUT_NOT_FOUND = 6
DELETE_NOT_FOUND = 7
API_CALL_EXCEPTION = 8
MISSING_REQUEST_ARGUMENT = 9
INVALID_REQUEST_ARGUMENT = 10
ARGUMENT_LOWER_THEN_MINIMUM = 11
ARGUMENT_HIGHER_THEN_MAXIMUM = 12
HTTP_METHOD_NOT_ALLOWED = 13
USERNAME_ALREADY_TAKEN = 14
INVALID_PASSWORD = 15
ERROR_USER_REGISTER = 16
ERROR_USER_SEQUENCE = 17
ERROR_RETRIEVE_SESSION = 18
ERROR_USER_POSTREGISTER = 19
WRONG_USERNAME_OR_PASSWORD = 20
UNAUTHORIZED_REQUEST = 21
USER_IS_NOT_ACTIVE = 22
LOGOUT_ERROR = 23
MISSING_OPTION = 24
PRE_LOGIN_ERROR = 25
POST_LOGIN_ERROR = 26
SAVE_HASH_PARAMS_ERROR = 27
GET_HASH_PARAMS_ERROR = 28
SAVE_MAIL_QUEUE_ERROR = 29
PRE_LOGOUT_ERROR = 30
POST_LOGOUT_ERROR = 31
ERROR_USER_PRE_REGISTER = 32
CHECK_USER_ERROR = 33
MESSAGE_NOT_FOUND = 34
USER_NOT_FOUND = 35
FORGOT_REQUEST_ERROR = 36
CHANGE_PASSWORD_ERROR = 37
NOT_ALLOWED_FROM_REMOTE = 38
OPTION_MISMATCH = 39
PRE_CHECK_USER_ERROR = 40
POST_CHECK_USER_ERROR = 41
MISSING_ROLE = 42
WRONG_ROLE_TYPE = 43
INVALID_ROLE = 44
ROLE_NOT_ALLOWED = 45
MISSING_GACCESS_CONFIGURATION = 46
ERROR_READ_GACCESS_CONFIGURATION = 47
ERROR_VERIFY_GOOGLE_ACCESS_TOKEN = 48
ERROR_GET_GOOGLE_USER = 49
ERROR_AUTHORIZE_GOOGLE_USER = 50
FACEBOOK_LIBRARY_NOT_INSTALLED = 51
FACEBOOK_USER_INVALID = 52
ERROR_GET_FACEBOOK_USER = 53
ERROR_AUTHORIZE_FACEBOOK_USER = 54

lmap = {}
lmap[ERROR] = 'Error'
lmap[EXCEPTION] = 'Exception'
lmap[GET_NOT_FOUND] = 'GET requested resource not found'
lmap[POST_NOT_FOUND] = 'POST requested resource not found'
lmap[PATCH_NOT_FOUND] = 'PATCH requested resource not found'
lmap[PUT_NOT_FOUND] = 'PUT requested resource not found'
lmap[DELETE_NOT_FOUND] = 'DELETE requested resource not found'
lmap[API_CALL_EXCEPTION] = 'Call Error'
lmap[MISSING_REQUEST_ARGUMENT] = "Missing request argument"
lmap[INVALID_REQUEST_ARGUMENT] = "Invalid request argument"
lmap[ARGUMENT_LOWER_THEN_MINIMUM] = "Argument is lower then minimum limit"
lmap[ARGUMENT_HIGHER_THEN_MAXIMUM] = "Argument is higher then maximum limit"
lmap[HTTP_METHOD_NOT_ALLOWED] = "Not allowed"
lmap[USERNAME_ALREADY_TAKEN] = "Username already taken"
lmap[INVALID_PASSWORD] = "Invalid password"
lmap[ERROR_USER_REGISTER] = "Error registering user"
lmap[ERROR_USER_SEQUENCE] = "Error making user sequence"
lmap[ERROR_RETRIEVE_SESSION] = "Error getting a new token"
lmap[ERROR_USER_POSTREGISTER] = "Post-register error"
lmap[WRONG_USERNAME_OR_PASSWORD] = "Wrong username or password"
lmap[UNAUTHORIZED_REQUEST] = "Unauthorized request"
lmap[USER_IS_NOT_ACTIVE] = "User is not active"
lmap[LOGOUT_ERROR] = "Error logging out"
lmap[MISSING_OPTION] = 'Missing option'
lmap[PRE_LOGIN_ERROR] = 'Pre login error'
lmap[POST_LOGIN_ERROR] = 'Post login error'
lmap[SAVE_HASH_PARAMS_ERROR] = 'Save hash data error'
lmap[GET_HASH_PARAMS_ERROR] = 'Get hash data error'
lmap[SAVE_MAIL_QUEUE_ERROR] = 'Error save mail queue'
lmap[PRE_LOGOUT_ERROR] = 'Pre logout error'
lmap[POST_LOGOUT_ERROR] = 'Post logout error'
lmap[ERROR_USER_PRE_REGISTER] = 'Pre register error'
lmap[CHECK_USER_ERROR] = 'Check user error'
lmap[MESSAGE_NOT_FOUND] = 'Message not found'
lmap[USER_NOT_FOUND] = 'User not found'
lmap[FORGOT_REQUEST_ERROR] = 'Forgot request error'
lmap[CHANGE_PASSWORD_ERROR] = 'Change password error'
lmap[NOT_ALLOWED_FROM_REMOTE] = 'Not allowed from remote'
lmap[OPTION_MISMATCH] = 'Option do not exists'
lmap[PRE_CHECK_USER_ERROR] = 'Pre check user error'
lmap[POST_CHECK_USER_ERROR] = 'Post check user error'
lmap[MISSING_ROLE] = 'Role is missing'
lmap[WRONG_ROLE_TYPE] = 'Role is with wrong type'
lmap[ROLE_NOT_ALLOWED] = 'Role not allowed'
lmap[MISSING_GACCESS_CONFIGURATION] = 'Missing configuration'
lmap[ERROR_READ_GACCESS_CONFIGURATION] = 'Error get configuration'
lmap[ERROR_VERIFY_GOOGLE_ACCESS_TOKEN] = 'Verify token error'
lmap[ERROR_GET_GOOGLE_USER] = 'Error get user info'
lmap[ERROR_AUTHORIZE_GOOGLE_USER] = 'Error authorize google user'
lmap[FACEBOOK_LIBRARY_NOT_INSTALLED] = 'Facebook library error'
lmap[FACEBOOK_USER_INVALID] = 'Facebook user error'
lmap[ERROR_GET_FACEBOOK_USER] = 'Error get user info'
lmap[ERROR_AUTHORIZE_FACEBOOK_USER] = 'Error authorize facebook user'

lrev = {}
for k in lmap:
    lrev[lmap[k]] = k

