# Generated by Django 2.2 on 2022-02-28 09:09

import cms.models.fields
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import filer.fields.file
import filer.fields.image
import giant_plugins.utils


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('cms', '0022_auto_20180620_1551'),
        ('filer', '0012_file_mime_type'),
        migrations.swappable_dependency(settings.FILER_IMAGE_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='PageCardBlock',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='page_card_pagecardblock', serialize=False, to='cms.CMSPlugin')),
                ('layout', models.CharField(choices=[('stacked', 'Stacked'), ('left_right', 'Left/Right')], default='left_right', max_length=255)),
                ('title', giant_plugins.utils.RichTextField(blank=True)),
                ('theme', models.CharField(choices=[('full-width', 'Full width'), ('content-width', 'Content width')], default='content-width', max_length=50)),
                ('background_colour', models.CharField(choices=[('dark', 'Dark'), ('light', 'Light')], default='light', max_length=30)),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='PageCard',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='page_card_pagecard', serialize=False, to='cms.CMSPlugin')),
                ('external_url', models.URLField(blank=True, help_text='Overrides the internal link if set')),
                ('title', models.CharField(max_length=255)),
                ('summary', models.CharField(blank=True, help_text='Limited to 140 characters', max_length=140)),
                ('cta_text', models.CharField(default='Read more', max_length=50)),
                ('file', filer.fields.file.FilerFileField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='page_card_pagecard_files', to='filer.File', verbose_name='File')),
                ('image', filer.fields.image.FilerImageField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.FILER_IMAGE_MODEL)),
                ('internal_link', cms.models.fields.PageField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='cms.Page')),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin', models.Model),
        ),
    ]
