package dyliss.biopax.pattern.miner;

import org.biopax.paxtools.pattern.Pattern;
import dyliss.biopax.pattern.SpaimPatternBox;
import org.biopax.paxtools.pattern.miner.AbstractSIFMiner;

import dyliss.biopax.pattern.SpaimSIFEnum;

/**
 * Miner for the chemical-affects-protein pattern.
 * @author Ozgun Babur
 */
public class ChemicalAffectsThroughBindingMiner extends AbstractSIFMiner
{
	/**
	 * Constructor that sets name and description.
	 */
	public ChemicalAffectsThroughBindingMiner()
	{
		super(SpaimSIFEnum.CHEMICAL_AFFECTS, "-through-binding", "In this case the chemical appears in" +
			" the same complex with the protein.");
	}

	/**
	 * Constructs the pattern.
	 * @return pattern
	 */
	@Override
	public Pattern constructPattern()
	{
		return SpaimPatternBox.chemicalAffectsProteinThroughBinding(blacklist);
	}

	@Override
	public String getSourceLabel()
	{
		return "SMR";
	}

	@Override
	public String getTargetLabel()
	{
		return "ER";
	}

	@Override
	public String[] getMediatorLabels()
	{
		return new String[]{"Complex"};
	}

	@Override
	public String[] getSourcePELabels()
	{
		return new String[]{"SPE1", "PE1", "Complex"};
	}

	@Override
	public String[] getTargetPELabels()
	{
		return new String[]{"SPE2", "PE2", "Complex"};
	}
}
