package dyliss.biopax.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

import org.apache.commons.lang.StringEscapeUtils;
import org.biopax.paxtools.model.BioPAXElement;
import dyliss.biopax.util.LogUtils;
public class GPaxNode {
	
  //biopax uri
	private  String simpleuri;
	// for graphml generation
	private Integer numid;
	public String getSimpleuri() {
		return simpleuri;
	}

	public void setSimpleuri(String simpleuri) {
		this.simpleuri = simpleuri;
	}

	
	//if true exported to ouput
	private Boolean export=false;
	public Boolean getExport() {
		return export;
	}

	public void setExport(Boolean export) {
		this.export = export;
	}

	private String safeLabel;
	private String label;
	private String description;
	private String shape;
	private String color;
	private String group;
	private String debug;
	private String srctype;

	private Integer input;
	private String biopaxType;
	private String spaimCaseFlat;//needed for velocity
	private String patternTagFlat;	//needed for velocity
	


	
	
	// for biopax parsing
	private String pk;
	private Map<String, String> map;
	private BioPAXElement element;
	private Set<String> spaimCase = new HashSet<String>();
	private Set<String> patternTag = new HashSet<String>();
	
	
	//for db 
	private String dbid;
	private String reversible;

	
	
	//for velocity only
	public void defaultVal() {
		 
		if(pk==null) {
			pk="";
		}
		if(dbid==null) {
			dbid="";
		}
		if(reversible==null) {
			reversible="";
		}
		if(patternTagFlat==null) {
			patternTagFlat="";
		}
		if(debug==null) {
			debug="";
		}
		if(spaimCaseFlat==null) {
			spaimCaseFlat="";
		}
		if(biopaxType==null) {
			biopaxType="";
		}
		if(input==null) {
			input=0;
		}
		if(group==null) {
			group="";
		}
		if(srctype==null) {
			srctype="";
		}
		if(simpleuri==null) {
			simpleuri="";
		}
		if(safeLabel==null) {
			safeLabel="";
		}
		if(label==null) {
			label="";
		}
		if(description==null) {
			description="";
		}
		if(shape==null) {
			shape="";
		}
		if(color==null) {
			color="";
		}
		if(group==null) {
			group="";
		}
		if(simpleuri==null) {
			simpleuri="";
		}
	 
 		 
		
	}
	
	

	public String getReversible() {
		return reversible;
	}

	public void setReversible(String reversible) {
		this.reversible = reversible;
	}

	public String getColor() {
		return color;
	}

	public void setColor(String color) {
		this.color = color;
	}
	
	public String getBiopaxType() {
		return biopaxType;
	}

	public void setBiopaxType(String biopaxType) {
		this.biopaxType = biopaxType;
	}

	public Integer getInput() {
		return input;
	}

	public void setInput(Integer input) {
		this.input = input;
	}

	public String getShape() {
		return shape;
	}

	public void setShape(String shape) {
		this.shape = shape;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}



	public String getLabel() {
		return label;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	public String getGroup() {
		return group;
	}

	public void setGroup(String group) {
		this.group = group;
	}
	public Integer getNumid() {
		return numid;
	}

	public void setNumid(Integer numid) {
		this.numid = numid;
	}

	public String getSafeLabel() {
		//if(this.label==null){this.label="";}
		if (safeLabel == null) {
			this.setSafeLabel(StringEscapeUtils.escapeXml(this.label));
		}
		return safeLabel;
	}

	public void setSafeLabel(String safeLabel) {
		this.safeLabel = safeLabel;
	}

	public Set<String> getSpaimCase() {
		return spaimCase;
	}

	
	public  String  getSpaimCaseFlat() {
		String str="";
		String sep = "_";
		int size = spaimCase.size();
		 
		int i=0;
		for(String s:spaimCase){
			i++;
			if(i>=size){
				sep="";
			}
			str+=s+sep;
		}
		return str;
	}
	
	public void setSpaimCase(Set<String> spaimCase) {
		this.spaimCase = spaimCase;
	}

	public String  getPatternFlat() {
	 
		String str="";
		String sep = "_";
		int size = patternTag.size();
		 
		int i=0;
		for(String s:patternTag){
			i++;
			if(i>=size){
				sep="";
			}
			str+=s+sep;
		}
		return str;
	}
	
	public Set<String> getPatternTag() {
		return patternTag;
	}

	public String getSafeDescription() {
		return StringEscapeUtils.escapeXml(this.getDescription());
	}

	public void setPatternTag(Set<String> patternTag) {
		this.patternTag = patternTag;
	}

	public BioPAXElement getElement() {
		return element;
	}

	public void setElement(BioPAXElement element) {
		this.element = element;
		this.setBiopaxType(element.getClass().getSimpleName());
	}
 
	//V2 : multiple uri for same mol in reactome biopax (10/2017) !!!
	//PK uses only class and label 
	
	
	//fm 20 2020
	
	
	public String pkFirstPart() {
		return label;
	}
	public String pkSecondPart() {
		return this.getElement().getClass().getSimpleName();
	}
  
  
	public String getPk() {
		
       		
		if (pk == null) {
				
			pk= pkSecondPart();
			
			if(pkFirstPart() == null){
					LogUtils.warn("@@WARNING: unconsistent PK, : no uri and label  defined, using random id for safe generation"); 
					pk = randomKey()+"|"+pk ;
			}
			
			if (pkFirstPart() != null) {
				pk = pkFirstPart()+"|"+pk ;
			} 
		}
		return pk;
	}
	
	
	//FM 02 2020
	private String randomKey() {
		UUID uuid = UUID.randomUUID();
		int variant = uuid.variant();
		return ""+variant;
	}

	public static  String  simpleURI(String uri) {
	
		String st=  uri;
		if(st!=null){
			st = st.replace("http://www.reactome.org/biopax", "R");
			 
		}else{
			
		}
	
		return st;
	}

	public String getDbid() {
		return dbid;
	}

	public void setDbid(String dbid) {
		this.dbid = dbid;
	}
	
	public void setPk(String pk) {
		this.pk = pk;
	}

	@Override
	public String toString() {
		return "SpaimNode [" + (simpleuri != null ? "simpleuri=" + simpleuri + ", " : "")
				+ (numid != null ? "numid=" + numid + ", " : "") + (export != null ? "export=" + export + ", " : "")
				+ (safeLabel != null ? "safeLabel=" + safeLabel + ", " : "")
				+ (label != null ? "label=" + label + ", " : "")
				+ (description != null ? "description=" + description + ", " : "")
				+ (shape != null ? "shape=" + shape + ", " : "") + (color != null ? "color=" + color + ", " : "")
				+ (group != null ? "group=" + group + ", " : "") + (debug != null ? "debug=" + debug + ", " : "")
				+ (srctype != null ? "srctype=" + srctype + ", " : "") + (input != null ? "input=" + input + ", " : "")
				+ (biopaxType != null ? "biopaxType=" + biopaxType + ", " : "")
				+ (spaimCaseFlat != null ? "spaimCaseFlat=" + spaimCaseFlat + ", " : "")
				+ (patternTagFlat != null ? "patternTagFlat=" + patternTagFlat + ", " : "")
				+ (pk != null ? "pk=" + pk + ", " : "") + (map != null ? "map=" + map + ", " : "")
				+ (element != null ? "element=" + element + ", " : "")
				+ (spaimCase != null ? "spaimCase=" + spaimCase + ", " : "")
				+ (patternTag != null ? "patternTag=" + patternTag + ", " : "")
				+ (dbid != null ? "dbid=" + dbid + ", " : "") + (reversible != null ? "reversible=" + reversible : "")
				+ "]";
	}

	private String toString(Collection<?> collection, int maxLen) {
		StringBuilder builder = new StringBuilder();
		builder.append("[");
		int i = 0;
		for (Iterator<?> iterator = collection.iterator(); iterator.hasNext() && i < maxLen; i++) {
			if (i > 0)
				builder.append(", ");
			builder.append(iterator.next());
		}
		builder.append("]");
		return builder.toString();
	}

	public GPaxNode() {
		super();
		this.map = new HashMap<String, String>();
	}

	public Map<String, String> getMap() {
		return map;
	}

	public void setMap(Map<String, String> map) {
		this.map = map;
	}

	public String getDebug() {
		return debug;
	}

	public void setDebug(String debug) {
		this.debug = debug;
	}

	public String getSrctype() {
		return srctype;
	}

	public void setSrctype(String srctype) {
		this.srctype = srctype;
	}

}
