package dyliss.biopax.db;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import dyliss.biopax.util.LogUtils;
import edu.uci.ics.jung.graph.util.Pair;
/*
 * 
 * warning generic signal spaim is not PK !!!!
 * SELECT * FROM `generic_signal_spaim` WHERE `signal_id` LIKE 'XN000055258' LIMIT 0, 30 ;
 * 
 * signal_id 	molecule_id 	role_id 	
XN000055258 	G010718 	p
XN000055258 	MO000016627 	m
XN000055258 	MO000034149 	m
XN000055258 	MO000034151 	m
 */

//edge


public class GenericSignalSpaim  extends DBTuple {

	public static   String TABLE_NAME = "generic_signal_spaim";
	String signal_id;
	String molecule_id;
	String role_id;
	private Pair<String> nodes = null;
	/*
	public Object getReaction() {
		return reaction;
	}
	public void setReaction(Object reaction) {
		this.reaction = reaction;
	}*/
	//Object reaction;
	 
	public Pair<String> getNodes() {
		return nodes;
	}
	public void setNodes(Pair<String> nodes) {
		this.nodes = nodes;
	} 
	public String getSignal_id() {
		return signal_id;
	}
	public GenericSignalSpaim(String signal_id, String molecule_id, String role_id) {
		super();
		this.signal_id = signal_id;
		this.molecule_id = molecule_id;
		this.role_id = role_id;
		this.nodes= this.nodes();
	}
	 public static void main(String[] args) {
		 GenericSignalSpaim g = new GenericSignalSpaim("EXPRESSION_OF_G010498_FOR_MO000088340", "MO000088340", "p");
		  g.nodes();
		 
	}
	public Pair<String> nodes() {
		//this.signal_id
		//EXPRESSION_OF_G010498_FOR_MO000088340
		   Pattern pattern = Pattern.compile("EXPRESSION_OF_([^_]*)_FOR_([^_]*)");
	        Matcher matcher = pattern.matcher(this.signal_id);
	        Pair p =null;
	        while(matcher.find()) {
	             String g1 = matcher.group(1);
	             String g2 = matcher.group(2);
	             LogUtils.info(g1);
	             LogUtils.info(g2);
		         if(g1!=null && g2!=null){
		        	   p = new Pair<String>(g1, g2);
		         }
	   		    
	        }
	        
	        if(p==null){
	        	//GenericSignalSpaim [signal_id=XN000055258, molecule_id=G010718, role_id=p]
	        
	        	p = new Pair<String>(this.molecule_id, this.signal_id);
	        	
	        }
		 return p;
	}
	
	@Override
	public String toString() {
		return String.format("GenericSignalSpaim [signal_id=%s, molecule_id=%s, role_id=%s]", esc(signal_id), esc(molecule_id),
				esc(role_id));
	}
	public void setSignal_id(String signal_id) {
		this.signal_id = signal_id;
	}
	public String getMolecule_id() {
		return molecule_id;
	}
	public void setMolecule_id(String molecule_id) {
		this.molecule_id = molecule_id;
	}
	public String getRole_id() {
		return role_id;
	}
	public void setRole_id(String role_id) {
		this.role_id = role_id;
	}
	@Override
	public String insertQuery() {
 /*
  * example 
  * INSERT INTO `generic_signal_spaim` (`signal_id`, `molecule_id`, `role_id`) VALUES
('EXPRESSION_OF_G000001_FOR_MO000028934', 'G000001', 'a');
  */
		String sql=String.format("insert into "+TABLE_NAME+" (signal_id,molecule_id,role_id,debug) values ('%s', '%s', '%s', '%s') ;" 
				, esc(signal_id), esc(molecule_id), esc(role_id), esc(debug));
		return sql;
	}
	@Override
	public String createTableQuery() {
		String sql="";
		sql+=" DROP TABLE IF EXISTS `"+TABLE_NAME+"`;";
		sql+=" CREATE TABLE IF NOT EXISTS `"+TABLE_NAME+"` (";
		sql+=" `signal_id` char(250) NOT NULL DEFAULT '',";
		sql+="  `molecule_id` char(250) NOT NULL DEFAULT '',";
		sql+="  `role_id` char(1) NOT NULL DEFAULT '',";
		sql+="  `debug` text,"; 
		sql+="  PRIMARY KEY (`signal_id`,`molecule_id`,`role_id`),";
		sql+="  KEY `molecule_id` (`molecule_id`),";
		sql+="  KEY `role_id` (`role_id`)";
		sql+=") ENGINE=MyISAM DEFAULT CHARSET=latin1;";
		
		return sql;
	}
 
	
}
