package dyliss.biopax.db;

public class GenericSignal extends DBTuple  {

	public static   String TABLE_NAME = "generic_signal";

	String signal_id;
	
	String equilibrium_id;
	
	public GenericSignal(String signal_id, String equilibrium_id, String source_db, String source_id) {
		super();
		this.signal_id = signal_id;
		this.equilibrium_id = equilibrium_id;
		this.source_db = source_db;
		this.source_id = source_id;
	}

	@Override
	public String toString() {
		return String.format("GenericSignal [signal_id=%s, equilibrium_id=%s, source_db=%s, source_id=%s]", esc(signal_id),
				esc(equilibrium_id), esc(source_db), esc(source_id));
	}

	public String getSignal_id() {
		return signal_id;
	}

	public void setSignal_id(String signal_id) {
		this.signal_id = signal_id;
	}

	public String getEquilibrium_id() {
		return equilibrium_id;
	}

	public void setEquilibrium_id(String equilibrium_id) {
		this.equilibrium_id = equilibrium_id;
	}

	public String getSource_db() {
		return source_db;
	}

	public void setSource_db(String source_db) {
		this.source_db = source_db;
	}

	public String getSource_id() {
		return source_id;
	}

	public void setSource_id(String source_id) {
		this.source_id = source_id;
	}

	String source_db;

	String source_id;

	@Override
	public String insertQuery() {
 /*
  * example 
INSERT INTO `generic_signal` (`signal_id`, `equilibrium_id`, `source_db`, `source_id`, `debug` ) VALUES
('XN000052807', 'r', 'Transpath', 'XN000052807','');

  */
		String sql=String.format("INSERT INTO `"+TABLE_NAME+"` (`signal_id`, `equilibrium_id`, `source_db`, `source_id`, `debug`) VALUES"+
"('%s', '%s', '%s', '%s', '%s');" , esc(signal_id), esc(equilibrium_id), esc(source_db),esc(source_id), esc(debug));
		return sql;
	}
	@Override
	public String createTableQuery() {
		String sql="";
 
		sql+="DROP TABLE IF EXISTS `"+TABLE_NAME+"`;";
		sql+="CREATE TABLE IF NOT EXISTS `"+TABLE_NAME+"` (";
		sql+="  `signal_id` char(250) NOT NULL DEFAULT '',";
		sql+="  `equilibrium_id` char(1) DEFAULT NULL,";
		sql+="  `source_db` char(250) DEFAULT NULL,";
		sql+="  `source_id` char(250) DEFAULT NULL,";
		sql+="  `debug` text,"; 
		sql+="  PRIMARY KEY (`signal_id`),";
		sql+="  KEY `equilibrium_id` (`equilibrium_id`)";
	    sql+=") ENGINE=MyISAM DEFAULT CHARSET=latin1;";
 
		return sql;
	}

 
}
