package dyliss.biopax.db;

import org.apache.commons.lang.StringEscapeUtils;

public class DBMolecule extends DBTuple {
	
 
	  public static   String TABLE_NAME = "transpath_molecule";
	  
	    private String molecule_id  ;
	    private String type_of_molecule ;
	    private String name;
      
	  	private String uri ;
	  	private String datasource ;
	  	private String biopaxtype;
	  	
	      
	public String getBiopaxtype() {
			return biopaxtype;
		}
		public void setBiopaxtype(String biopaxtype) {
			this.biopaxtype = biopaxtype;
		}
	public String getUri() {
		return uri;
	}
	public void setUri(String uri) {
		this.uri = uri;
	}
	public String getDatasource() {
		return datasource;
	}
	public void setDatasource(String datasource) {
		this.datasource = datasource;
	}
	public DBMolecule(String molecule_id, String type_of_molecule, String name) {
		super();
		this.molecule_id = molecule_id;
		this.type_of_molecule = type_of_molecule;
		this.name = name;
	 
	}
	@Override
	public String toString() {
		return String.format("TranspathMolecule [molecule_id=%s, type_of_molecule=%s, name=%s]", molecule_id,
				type_of_molecule, name);
	}
	public String getMolecule_id() {
		return molecule_id;
	}
	public void setMolecule_id(String molecule_id) {
		this.molecule_id = molecule_id;
	}
	public String getType_of_molecule() {
		return type_of_molecule;
	}
	public void setType_of_molecule(String type_of_molecule) {
		this.type_of_molecule = type_of_molecule;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	
	@Override
	public String insertQuery() {
 /*
  * example 
 INSERT INTO `transpath_molecule` (`molecule_id`, `type_of_molecule`, `name`) VALUES
('MO000069114', 'm', 'carbonic anhydrase 2(m.s.)');
  */
		String sql=String.format("INSERT INTO `"+TABLE_NAME+"` (`molecule_id`, `type_of_molecule`, `name`, `debug`, `uri`, `datasource`, `biopaxtype`) VALUES "+
"('%s', '%s', '%s', '%s', '%s', '%s', '%s');" , esc(molecule_id), esc(type_of_molecule), esc(name), esc(debug), esc(uri), esc(datasource), esc(biopaxtype));
		return sql;
	}
	@Override
	public String createTableQuery() {
		String sql="";
 
		sql+="DROP TABLE IF EXISTS `"+TABLE_NAME+"`;";
		sql+="CREATE TABLE IF NOT EXISTS `"+TABLE_NAME+"` (";
		sql+="  `molecule_id` char(250) NOT NULL DEFAULT '',";
		sql+="  `type_of_molecule` char(1) DEFAULT NULL,";
		sql+="  `name` text,"; 
		sql+="  `debug` text,";
		sql+="  `uri` char(250),";
		sql+="  `datasource` char(250),";
		sql+="  `biopaxtype` char(250),"; 
		sql+="  PRIMARY KEY (`molecule_id`)";
		sql+=") ENGINE=MyISAM DEFAULT CHARSET=latin1;";
		
		return sql;
	}
      

	 
	 
}
