package dyliss.biopax.app;


 


import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.velocity.VelocityContext;
 
import dyliss.biopax.TemplateManager;
import dyliss.biopax.graph.SpaimEdge;
import dyliss.biopax.graph.SpaimNode;
import dyliss.biopax.util.LogUtils;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.util.Pair;
 

public class VizGraphmlWriter {
 
	private static final String SHAPE = "Ellipse";
	private static final String COLOR = "silver";
	
	
	
	
	public   void writeNodeIDFile(
		 
			DirectedSparseMultigraph<SpaimNode, SpaimEdge> jg,
			String idfile 
			)
			throws IOException, Exception {
		
		
		PrintWriter writer = new PrintWriter(idfile, "UTF-8");
 
		Collection<SpaimNode> vl = jg.getVertices();
		int vct=0;
		for(SpaimNode v:vl){
			vct++;
			v.setNumid(vct);
			String line =v.getNumid()+"\t"+v.getPk()+"\t"+v.getBiopaxType()+"\t"+v.getLabel()+"\t"+v.getDescription();
			writer.println(line);
			 
		}

		 
 
		writer.close();
		
	}
	
	public   void writeEdgeIDFile(
			 
			DirectedSparseMultigraph<SpaimNode, SpaimEdge> jg,
			String idfile 
			)
			throws IOException, Exception {
		
		
		PrintWriter writer = new PrintWriter(idfile, "UTF-8");
 
		Collection<SpaimNode> vl = jg.getVertices();
		int vct=0;
		for(SpaimNode v:vl){
			vct++;
			v.setNumid(vct);
		 
		
			 
		}
		Collection<SpaimEdge> edges = jg.getEdges();
		if(edges.size()>0){
			int cte=0;
			for(SpaimEdge e:edges){
				cte++;
				Pair<SpaimNode> ep = jg.getEndpoints(e);
				SpaimNode f = ep.getFirst();
				SpaimNode s = ep.getSecond();
 
				e.setSource(""+f.getNumid());
				e.setTarget(""+s.getNumid());
		 
				String line =f.getNumid()+"\t"+s.getNumid();
				writer.println(line);
			}

		}
		 
 
		writer.close();
		
	}
	
	public   void writeGraphToGraphmlFile(
			String graphname, 
			DirectedSparseMultigraph<SpaimNode, SpaimEdge> jg,
			String graphmlfile,
			File templateF 
			)
			throws IOException, Exception {
		
		 LogUtils.info("templateF:"+templateF.getAbsolutePath());
		PrintWriter writer = new PrintWriter(graphmlfile, "UTF-8");
 
		Collection<SpaimNode> vl = jg.getVertices();
		int vct=0;
		for(SpaimNode v:vl){
			vct++;
			v.setNumid(vct);
		    v.setSafeLabel(StringEscapeUtils.escapeXml(v.getLabel() ));
		    
		    v.setDebug(StringEscapeUtils.escapeXml(v.getDebug()));
		    String shape = shapeFromBiopaxType(v); 
		    v.setShape(shape);
		    String color = colorFromBiopaxType(v);
		    v.setColor(color);
		    //v.setInput(0);
		    v.setGroup(StringEscapeUtils.escapeXml(v.getGroup()));
		}
		Collection<SpaimEdge> edges = jg.getEdges();
		if(edges.size()>0){
			int cte=0;
			for(SpaimEdge e:edges){
				cte++;
				Pair<SpaimNode> ep = jg.getEndpoints(e);
				SpaimNode f = ep.getFirst();
				SpaimNode s = ep.getSecond();
					
				String interaction = e.getPk();
				e.setInteraction(StringEscapeUtils.escapeXml(interaction)+"");
				e.setNumid(cte);
				e.setSource(""+f.getNumid());
				e.setTarget(""+s.getNumid());
			    e.setDebug(StringEscapeUtils.escapeXml(e.getDebug()));
				//writer.println(f.getID()+"\t"+x+"\t"+s.getID());

			}

		}
		
		
		HashMap<String, Object> context = new HashMap<String, Object>();
		TemplateManager ct = TemplateManager.getInstance();
		ct.setTemplateDir(templateF.getParent());
		ct.init();
		String templateFile=templateF.getName();
		
		context.put("graphname",graphname);
		 
		
		context.put("edges",jg.getEdges());
		context.put("nodes",jg.getVertices());
		
		
		VelocityContext vcontext = new VelocityContext();
		for(String k:context.keySet()){
			   vcontext.put(k,  context.get(k));
		}
		String output=ct.evaluateFromTemplate(   templateFile,   vcontext);
		writer.print(output);
	//	LogUtils.info(output);
		//
 
		writer.close();
		
	}
	
	
	
	
	private static String shapeFromBiopaxType(SpaimNode v) {
		String shape=SHAPE;
		  
		 
				 shape="Ellipse";
				 if(v.getDebug()==null){
					 return shape;
				 }
				 if(v.getDebug().contains("ProteinImpl")){
					 shape="Rectangle"; 
				 }
				 else if(v.getDebug().contains("ComplexAssemblyImpl")){
					 shape="Parallelogram"; 
				 }
				 else if(v.getDebug().contains("ComplexImpl")){
					 shape="Octagon"; 
				 }
				 else if(v.getDebug().contains("SmallMoleculeImpl")){
					 shape="Triangle"; 
				 }
				 else if(v.getDebug().contains("DnaImpl")){
					 shape="Round Rectangle"; 
				 }
				 else if(v.getDebug().contains("RnaImpl")){
					 shape="Round Rectangle"; 
				 }
				
		 
		     if (v.getDebug().contains("Interaction") ){
			 
				 shape="Rectangle" ;
				 
				 if (v.getDebug().contains("Control") ){
					   
					   shape="Diamond" ;
				 }
		 }
		 
		     /*else{
			 shape="V";
		 }*/
		 
		 
		 
		return shape;
	}
	
	private static String colorFromBiopaxType(SpaimNode v) {
		String color=COLOR;
		  
		  	 
				 color="FireBrick";
				 if(v.getDebug()==null){
					 return color;
				 }
				 if(v.getDebug().contains("ProteinImpl")){
					 color="LimeGreen"; 
				 }
				 else if(v.getDebug().contains("ComplexImpl")){
					 color="LightGreen"; 
				 }
				 else if(v.getDebug().contains("SmallMoleculeImpl")){
					 color="SpringGreen"; 
				 }
				 else if(v.getDebug().contains("DnaImpl")){
					 color="SeaGreen"; 
				 }
				 else if(v.getDebug().contains("RnaImpl")){
					 color="YellowGreen"; 
				 }
				
				
		  
		  if(v.getDebug().contains("EntityReference")){
			 color="CornflowerBlue"; 
		 }
		 else if (v.getDebug().contains("Interaction") ){
			 
			 color="LightSalmon" ;
			 
			 if (v.getDebug().contains("Control") ){
				   
				   color="Coral" ;
			 }
		 }
		 else{
			 color="red";
		 }
		 
		 
		 
		return color;
	}
	
	
}
