package dyliss.biopax.app;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;

import bsh.ParseException;
import bsh.Parser;
import bsh.EvalError;
import bsh.Interpreter;

import org.biopax.paxtools.model.level3.SequenceEntity;
import org.biopax.paxtools.model.level3.SequenceEntityReference;
import org.biopax.paxtools.pattern.Pattern;


public class ScriptReader {
   
	public static void parseBsh(String script) throws ParseException {
	    StringReader reader = new StringReader(script);

	    Parser parser = new Parser(reader);
	    while (!parser.Line()) {
	        parser.popNode();
	    }
	}
	public static void test() throws EvalError, FileNotFoundException, IOException {

		
		String sourceFile = "data/test-data/pattern.txt";

		
		
	ArrayList<Pattern> patternList = evaluateCustomPatternList(sourceFile); 
	  
	  
	  int idx=0;
	 for(Pattern pa:patternList) {
		 idx++;
		  System.out.println(idx+"="+pa);
	 }
	}
	private static ArrayList<Pattern> evaluateCustomPatternList(String sourceFile)
			throws EvalError, FileNotFoundException, IOException {
		Interpreter i = new Interpreter();  // Construct an interpreter
	
		//i.set("foo", 5);                    // Set variables
		i.set("rdate", new Date() ); 
	
		i.eval("import org.biopax.paxtools.pattern.Pattern;"
				+ " import  java.util.ArrayList;"
				+"import dyliss.biopax.app.BoxWrapper;"
				+"import org.biopax.paxtools.model.level3.*;" 
				+"import org.biopax.paxtools.pattern.*;" 
				+"import org.biopax.paxtools.pattern.constraint.*;" 
				 +"import org.biopax.paxtools.pattern.util.*; " 
 			 
				 +  ""); 
	 
		i.set("patternList", new ArrayList<Pattern> () ); 
 
		Date rdate = (Date)i.get("rdate");    

	  
		i.source(sourceFile);
		  
	 	i.eval("pl=plist()" );
		ArrayList<Pattern> patternList=new ArrayList<Pattern> ();
	    patternList = ( ArrayList<Pattern>) i.get("patternList");
		return patternList;
	}
public static void main(String[] args) throws FileNotFoundException, EvalError, IOException {
	test();
	 
	
	 
}
 
 
  




	 


	}
