package dyliss.biopax.app;
import org.biopax.paxtools.pattern.Constraint;
import org.biopax.paxtools.pattern.MappedConst;
import org.biopax.paxtools.pattern.Pattern;
import org.biopax.paxtools.pattern.constraint.ConversionSide;
import org.biopax.paxtools.pattern.constraint.Empty;
import org.biopax.paxtools.pattern.constraint.ModificationChangeConstraint;
import org.biopax.paxtools.pattern.constraint.NOT;
import org.biopax.paxtools.pattern.constraint.OR;
import org.biopax.paxtools.pattern.constraint.Participant;
import org.biopax.paxtools.pattern.constraint.Size;
import org.biopax.paxtools.pattern.constraint.Type;
import org.biopax.paxtools.pattern.util.Blacklist;
import org.biopax.paxtools.pattern.util.RelType;

import static dyliss.biopax.pattern.ConBox.controlToConv;
import static dyliss.biopax.pattern.ConBox.equal;
import static dyliss.biopax.pattern.ConBox.erToPE;
import static dyliss.biopax.pattern.ConBox.linkToComplex;
import static dyliss.biopax.pattern.ConBox.linkToSpecific;
import static dyliss.biopax.pattern.ConBox.linkedER;
import static dyliss.biopax.pattern.ConBox.participantER;
import static dyliss.biopax.pattern.ConBox.peToControl;
import static dyliss.biopax.pattern.ConBox.peToER;

import org.biopax.paxtools.model.level3.*;

import dyliss.biopax.pattern.ConBox.*;

public class BoxWrapper {
	
	private Pattern pattern;

	public Pattern getPattern() {
		return pattern;
	}

	
	
	public void setPattern(Pattern pattern) {
		this.pattern = pattern;
	}

	public BoxWrapper(Pattern p) {
		this.pattern=p;
	}

	public static void main(String[] args) {
		
		Pattern p = new Pattern(SequenceEntityReference.class, "TF ER");
		
		BoxWrapper a = new BoxWrapper(p);
	
		  a.add( dyliss.biopax.pattern.ConBox.linkedER(true),"TF ER","TF generic ER");
		 
	}
	
	public void add(Constraint c,String mb1,String mb2,String mb3){
		  pattern.add( c,mb1,mb2,mb3);	 
	}
	public void add(Constraint c,String mb1,String mb2){
		  pattern.add( c,mb1,mb2);	 
	}
	public void add(Constraint c,String mb1){
		  pattern.add( c,mb1);	 
	}
	
	public MappedConst conversionMC(){
		return dyliss.biopax.pattern.SpaimPatternBox.conversionMC();
	}
	
	
	 
	

	  public Constraint size(Constraint c, int sz,String mc){
		 
 		  org.biopax.paxtools.pattern.constraint.Size.Type t=Size.Type.EQUAL;
 
		if(  mc==null || mc.toUpperCase().contains("EQUAL")   ) {
			 t=Size.Type.EQUAL;
		}
		else if(   mc.toUpperCase().contains("GREATER")   ) {
			 t=Size.Type.GREATER;
		}
		else if(   mc.toUpperCase().contains("LESS")   ) {
			 t=Size.Type.LESS;
		}
		Size s = new Size(c, sz, t);
		return s;
	}		
	
	 
  public Constraint modificationChangeConstraint(String mc,String lb){
	    	  ModificationChangeConstraint.Type  t = null;
	  		  
	  		if(  mc==null || mc.toUpperCase().contains("ANY")   ) {
	  			t= ModificationChangeConstraint.Type.ANY;
	  		}else if(mc.toUpperCase().contains("LOSS") ) {
	  			t=ModificationChangeConstraint.Type.LOSS;
	  		}
	  		 else if(mc.toUpperCase().contains("GAIN") ) {
	  			t=ModificationChangeConstraint.Type.GAIN;
	  		}
	  		ModificationChangeConstraint p = new ModificationChangeConstraint(t,lb);
	  		return p;
	  	}		  
	
	public Constraint participant(String tp,Boolean b){
		RelType  t = null;
		  
		if(  tp==null || tp.toUpperCase().contains("INPUT")   ) {
			t= RelType.INPUT;
		}else {
			t=RelType.OUTPUT;
		}
		Participant p = new Participant(t,b);
		return p;
	}
	
	public Constraint conversionSide(String tp){
		  org.biopax.paxtools.pattern.constraint.ConversionSide.Type t = null;
		  
		if(  tp==null || tp.toUpperCase().contains("OTHER_SIDE")   ) {
			t= ConversionSide.Type.OTHER_SIDE;
		}else {
			t=ConversionSide.Type.SAME_SIDE;
		}
		ConversionSide c = new ConversionSide(t);
		return c;
	}
	
	
	public Constraint not(Constraint con){
 		return new   NOT(  con);
	}
 
	public Constraint or(MappedConst con,MappedConst con2){
	 
		return new OR(  con,  con2);
		}
 
 
	public Constraint empty(Constraint con){
		return new Empty(con);
 	}
	public Constraint compToER(){
		return dyliss.biopax.pattern.ConBox.compToER();
	}
	public Constraint controlToConv(){
		return dyliss.biopax.pattern.ConBox.controlToConv();
	}
	public Constraint controlToInter(){
		return dyliss.biopax.pattern.ConBox.controlToInter();
	}
	public Constraint controlToTempReac(){
		return dyliss.biopax.pattern.ConBox.controlToTempReac();
	}
	 
	public Constraint controllerPE(){
		return dyliss.biopax.pattern.ConBox.controllerPE();
	}
	public Constraint convToControl(){
		return dyliss.biopax.pattern.ConBox.convToControl();
	}
	public Constraint differentialActivity(Boolean b){
		return dyliss.biopax.pattern.ConBox.differentialActivity(b);
	}
	public Constraint equal(Boolean b){
		return dyliss.biopax.pattern.ConBox.equal(b);
	}
	 
	public Constraint erToPE(){
		return dyliss.biopax.pattern.ConBox.erToPE();
	}
	public Constraint hasDifferentCompartments(){
		return dyliss.biopax.pattern.ConBox.hasDifferentCompartments();
	}
	public Constraint interToPE(){
		return dyliss.biopax.pattern.ConBox.interToPE();
	}
	public Constraint isBait(){
		return dyliss.biopax.pattern.ConBox.isBait();
	}
	public Constraint isPrey(){
		return dyliss.biopax.pattern.ConBox.isPrey();
	}
	public Constraint left(){
		return dyliss.biopax.pattern.ConBox.left();
	}
	public Constraint linkToComplex(){
		return dyliss.biopax.pattern.ConBox.linkToComplex();
	}
	public Constraint linkToSimple(Blacklist bl){
		
		return dyliss.biopax.pattern.ConBox.linkToSimple(bl);
	}
	
	public Constraint linkToSpecific(){
		return dyliss.biopax.pattern.ConBox.linkToSpecific();
	}
	
	public Constraint notGeneric(){
		return dyliss.biopax.pattern.ConBox.notGeneric();
	}
	
	public Constraint linkedER(Boolean b){
		return dyliss.biopax.pattern.ConBox.linkedER(b);
	}
	
	public Constraint participant(){
		return dyliss.biopax.pattern.ConBox.participant();
	}
	
	public Constraint participantER(){
		return dyliss.biopax.pattern.ConBox.participantER();
	}
	
	public Constraint participatesInConv(){
		return dyliss.biopax.pattern.ConBox.participatesInConv();
	}
	
	public Constraint peToControl(){
		return dyliss.biopax.pattern.ConBox.peToControl();
	}
	
	public Constraint peToER(){
		return dyliss.biopax.pattern.ConBox.peToER();
	}
	
	public Constraint peToInter(){
		return dyliss.biopax.pattern.ConBox.peToInter();
	}
	
	public Constraint product(){
		return dyliss.biopax.pattern.ConBox.product();
	}
	
	public Constraint right(){
		return dyliss.biopax.pattern.ConBox.right();
	}
	
	public Constraint simplePEToConv(RelType rt){
 		return dyliss.biopax.pattern.ConBox.simplePEToConv(rt);
	}
	
	public Type type(Class cls){
		Type t = new Type(cls);
		return t;
	}



	public MappedConst mappedConst(Constraint c, int i) {
		MappedConst mc=new MappedConst(c,i);
		 
		return mc;
	}
	
 
}
