import math
from collections import Counter
from copy import deepcopy

class MnemonicTfIdf(object):
    idf = {}
    # derived using groundtruth by Andriesse, Bao, and Plohmann
    # all_histograms_x86 = Counter({'num_functions': 572387, 'mov': 511833, 'ret': 500172, 'push': 452213, 'add': 423033, 'call': 414348, 'sub': 380594, 'pop': 370950, 'jmp': 270366, 'cmp': 242071, 'je': 235712, 'lea': 207601, 'test': 207200, 'jne': 189321, 'xor': 169864, 'movzx': 91671, 'leave': 70744, 'and': 70236, 'nop': 65414, 'inc': 64094, 'shl': 48804, 'jle': 48688, 'or': 42761, 'ja': 38606, 'sar': 37170, 'jb': 34838, 'jbe': 34209, 'jl': 34110, 'imul': 32911, 'jae': 31808, 'dec': 31575, 'jg': 29916, 'shr': 27972, 'jge': 27333, 'fstp': 26961, 'fld': 22244, 'movsd': 21956, 'sete': 21729, 'setne': 20976, 'js': 18670, 'movsx': 16361, 'sbb': 13209, 'jns': 13139, 'neg': 13012, 'cmovne': 11240, 'cdq': 10162, 'cmove': 9813, 'fldz': 8900, 'fmul': 7975, 'not': 7944, 'mulsd': 7897, 'addsd': 6613, 'fxch': 6562, 'idiv': 6468, 'xorps': 6422, 'ucomisd': 5855, 'subsd': 5532, 'fadd': 5396, 'fst': 5214, 'movapd': 5213, 'fucomip': 5203, 'bt': 5030, 'movss': 5030, 'xorpd': 4854, 'faddp': 4800, 'adc': 4784, 'fild': 4194, 'jp': 3873, 'setg': 3828, 'divsd': 3794, 'fmulp': 3596, 'fucomi': 3580, 'fld1': 3346, 'rep movsd': 3194, 'setb': 3092, 'div': 3020, 'cmovb': 2966, 'movaps': 2903, 'cmova': 2754, 'seta': 2754, 'fsub': 2741, 'cvtss2sd': 2741, 'mul': 2599, 'cvtsi2sd': 2497, 'jnp': 2473, 'fnstcw': 2470, 'movd': 2442, 'fchs': 2341, 'fldcw': 2290, 'cmovg': 2264, 'fsubp': 2233, 'shld': 2210, 'fdiv': 2199, 'fistp': 2124, 'rep stosd': 2092, 'fsubr': 2074, 'cmovle': 1971, 'cvttsd2si': 1963, 'cvtsd2ss': 1944, 'cmovae': 1830, 'cmovl': 1666, 'cmovns': 1604, 'cmovs': 1551, 'setl': 1521, 'fdivp': 1521, 'int3': 1502, 'andpd': 1488, 'shrd': 1478, 'fsubrp': 1438, 'cmovge': 1431, 'orpd': 1384, 'fdivr': 1348, 'addss': 1331, 'cmovbe': 1313, 'setle': 1305, 'movupd': 1282, 'movups': 1233, 'fabs': 1221, 'mulss': 1214, 'repne scasb': 1162, 'setbe': 1136, 'rep movsb': 1118, 'fdivrp': 1107, 'sqrtsd': 1088, 'setge': 1057, 'movlpd': 1028, 'ucomiss': 1018, 'setae': 960, 'mulpd': 956, 'movlhps': 922, 'fsqrt': 813, 'cmovno': 772, 'addpd': 771, 'movdqu': 751, 'cwde': 748, 'divss': 708, 'subss': 694, 'shufpd': 692, 'rol': 688, 'cvtsi2ss': 612, 'movdqa': 537, 'repe cmpsb': 527, 'setp': 522, 'andnpd': 522, 'fcmovbe': 521, 'subpd': 508, 'pshufd': 489, 'cmpltsd': 457, 'sets': 451, 'minsd': 445, 'unpcklpd': 438, 'fcmovnbe': 424, 'maxsd': 408, 'rep stosb': 404, 'fnstsw': 389, 'stmxcsr': 367, 'stosd': 360, 'pxor': 341, 'setnp': 333, 'ud2': 321, 'por': 310, 'bswap': 291, 'xchg': 289, 'setns': 275, 'wait': 271, 'paddd': 266, 'cld': 265, 'movq': 264, 'cmovo': 264, 'punpckldq': 254, 'cvttss2si': 252, 'ror': 250, 'movhpd': 247, 'cmpneqsd': 224, 'hlt': 206, 'bsr': 195, 'rcr': 193, 'pushfd': 184, 'andps': 177, 'fimul': 163, 'shufps': 156, 'movsb': 153, 'movsw': 148, 'divpd': 145, 'pand': 144, 'std': 139, 'cmpeqsd': 133, 'seto': 132, 'bts': 118, 'clc': 118, 'pcmpeqd': 116, 'cvtps2pd': 113, 'fidiv': 107, 'fist': 107, 'fcomp': 106, 'fucompp': 105, 'fiadd': 105, 'mulps': 103, 'lock xadd': 101, 'stosb': 100, 'movhlps': 100, 'maxss': 99, 'fidivr': 97, 'ldmxcsr': 96, 'sqrtss': 95, 'pslldq': 94, 'pandn': 94, 'stosw': 93, 'frndint': 92, 'fcmovne': 83, 'addps': 79, 'fnclex': 77, 'unpcklps': 76, 'fcmove': 70, 'orps': 70, 'loop': 63, 'popal': 61, 'andnps': 60, 'popfd': 57, 'pushal': 56, 'psrad': 55, 'cmpltss': 48, 'lock cmpxchg': 47, 'psllq': 47, 'cmplesd': 47, 'unpckhpd': 46, 'punpcklbw': 45, 'paddq': 44, 'cmpnlesd': 44, 'pslld': 43, 'punpcklwd': 42, 'lodsb': 41, 'cmovp': 41, 'movlps': 39, 'minpd': 39, 'maxpd': 37, 'fxam': 36, 'pshufhw': 36, 'cvtpd2ps': 35, 'psubd': 34, 'pshuflw': 34, 'cbw': 33, 'minss': 33, 'ljmp': 31, 'cpuid': 30, 'psrlq': 30, 'pmuludq': 30, 'psrld': 28, 'lodsd': 27, 'fcmovb': 27, 'int': 26, 'cmpltpd': 26, 'fldpi': 25, 'pcmpgtd': 24, 'fisubr': 23, 'packuswb': 23, 'retf': 22, 'fucomp': 19, 'psrldq': 19, 'fisub': 19, 'cmpneqss': 19, 'cvttps2dq': 19, 'fcom': 18, 'fcompp': 18, 'subps': 17, 'jecxz': 16, 'divps': 15, 'xlatb': 14, 'punpcklqdq': 12, 'punpckhbw': 12, 'rdtsc': 11, 'repe cmpsd': 9, 'cmpnlepd': 9, 'fcmovnb': 8, 'cmpnless': 8, 'f2xm1': 8, 'fscale': 8, 'lodsw': 7, 'paddb': 7, 'insb': 6, 'outsb': 6, 'cmpeqss': 6, 'pcmpeqw': 6, 'pmulld': 6, 'in': 5, 'repne scasw': 5, 'lcall': 5, 'das': 5, 'outsd': 5, 'cmpneqpd': 5, 'cmpnltsd': 5, 'psubusb': 5, 'pcmpeqb': 5, 'fninit': 4, 'psraw': 4, 'pause': 4, 'lock inc': 3, 'lock dec': 3, 'arpl': 3, 'rcl': 3, 'loopne': 3, 'comisd': 3, 'maxps': 3, 'paddw': 3, 'pextrw': 3, 'btr': 2, 'sahf': 2, 'sti': 2, 'lock xchg': 2, 'pshufb': 2, 'outsw': 2, 'aas': 2, 'aaa': 2, 'jo': 2, 'xcryptcbc': 2, 'repne scasd': 2, 'bound': 2, 'cmpneqps': 2, 'psubusw': 2, 'pmaxub': 2, 'psllw': 2, 'pcmpgtb': 2, 'cvtdq2ps': 2, 'lock or': 2, 'pinsrw': 2, 'mfence': 2, 'cmpsd': 2, 'sal': 1, 'fisttp': 1, 'fcomip': 1, 'lahf': 1, 'pushf': 1, 'scasb': 1, 'cli': 1, 'jcxz': 1, 'repe cmpsw': 1, 'emms': 1, 'aeskeygenassist': 1, 'aesenc': 1, 'aesenclast': 1, 'pcmpeqq': 1, 'psubq': 1, 'aam': 1, 'lock bts': 1, 'repne movsd': 1, 'repne movsb': 1, 'repne stosd': 1, 'repne stosb': 1, 'les': 1, 'sldt': 1, 'fbstp': 1, 'rep movsw': 1, 'cmovnp': 1, 'lock add': 1, 'lock sub': 1})
    # all_histograms_x64 = Counter({'num_functions': 542822, 'mov': 477831, 'ret': 445568, 'call': 377492, 'push': 369944, 'pop': 323101, 'add': 317721, 'sub': 299270, 'jmp': 286751, 'cmp': 226990, 'je': 222952, 'test': 202138, 'xor': 194796, 'lea': 189520, 'jne': 180164, 'movzx': 90750, 'nop': 86672, 'movsxd': 83369, 'and': 62323, 'inc': 58805, 'shl': 53526, 'jle': 48907, 'or': 40966, 'leave': 39261, 'ja': 37600, 'dec': 34033, 'sar': 33707, 'shr': 32676, 'jb': 32671, 'movsd': 32183, 'jl': 31845, 'jae': 31477, 'jbe': 31477, 'imul': 31134, 'movabs': 30275, 'jg': 29521, 'jge': 26152, 'sete': 21347, 'setne': 19565, 'cdqe': 19150, 'js': 19061, 'mulsd': 15938, 'movsx': 15902, 'cmovne': 15163, 'xorps': 14001, 'cmove': 13750, 'addsd': 13636, 'not': 12319, 'jns': 11984, 'movapd': 11263, 'ucomisd': 11193, 'neg': 10266, 'movss': 9929, 'movups': 9808, 'subsd': 9541, 'pxor': 9005, 'movaps': 8936, 'cdq': 7844, 'bt': 7742, 'divsd': 7623, 'cvtsi2sd': 6825, 'sbb': 6685, 'xorpd': 6542, 'idiv': 6373, 'repne scasb': 6186, 'cvtss2sd': 5508, 'cmovg': 4297, 'cvttsd2si': 3944, 'jp': 3909, 'cvtsd2ss': 3860, 'cmovl': 3749, 'setg': 3521, 'movq': 3385, 'cmovb': 3348, 'setb': 3343, 'cmova': 3082, 'div': 2821, 'addss': 2653, 'andpd': 2430, 'cmovs': 2418, 'mulss': 2409, 'jnp': 2375, 'seta': 2331, 'cmovle': 2248, 'int3': 2242, 'ucomiss': 2142, 'movupd': 2069, 'sqrtsd': 1973, 'cmovge': 1678, 'cmovns': 1622, 'cmovae': 1621, 'divss': 1457, 'cmovbe': 1436, 'cvtsi2ss': 1414, 'subss': 1364, 'setl': 1258, 'cqo': 1217, 'movd': 1208, 'repe cmpsb': 1157, 'movdqa': 1132, 'mul': 1129, 'bts': 1088, 'addpd': 1051, 'setbe': 1040, 'rep movsb': 1011, 'mulpd': 1005, 'movdqu': 1003, 'ud2': 985, 'adc': 966, 'setle': 918, 'rep stosq': 872, 'pshufd': 868, 'movlhps': 867, 'setge': 846, 'setae': 843, 'subpd': 767, 'seto': 765, 'rol': 755, 'btr': 746, 'maxsd': 734, 'minsd': 700, 'andnpd': 685, 'rep stosd': 684, 'fld': 661, 'shufpd': 648, 'rep movsd': 636, 'fstp': 622, 'orpd': 614, 'cmpltsd': 599, 'andps': 588, 'lock dec': 576, 'unpcklpd': 547, 'setp': 533, 'movlpd': 515, 'cvttss2si': 509, 'cwde': 503, 'rep movsq': 457, 'punpckldq': 418, 'ror': 397, 'syscall': 359, 'cmovno': 357, 'setnp': 353, 'bswap': 342, 'cvtdq2pd': 329, 'paddd': 322, 'punpcklqdq': 307, 'rep stosb': 303, 'lock cmpxchg': 296, 'shufps': 247, 'cmovo': 245, 'cmpxchg': 238, 'fldz': 232, 'faddp': 228, 'cmpneqsd': 218, 'movhpd': 218, 'fmul': 215, 'setns': 207, 'hlt': 205, 'lock inc': 201, 'maxss': 197, 'comisd': 194, 'pand': 181, 'sqrtss': 171, 'pslldq': 169, 'xchg': 158, 'divpd': 150, 'orps': 146, 'cvtps2pd': 141, 'andnps': 138, 'cmpeqsd': 134, 'bsr': 131, 'fmulp': 128, 'por': 126, 'mulps': 123, 'pcmpeqd': 114, 'movhlps': 112, 'punpcklwd': 106, 'cmpnltsd': 100, 'unpcklps': 100, 'psrldq': 98, 'addps': 95, 'paddq': 93, 'pandn': 88, 'lock or': 87, 'fxch': 87, 'movnti': 84, 'cmplesd': 83, 'punpcklbw': 78, 'movlps': 74, 'lock xadd': 72, 'minss': 71, 'sets': 70, 'fild': 68, 'cmpltss': 68, 'punpckhdq': 67, 'psubd': 60, 'psrad': 57, 'repne scasd': 51, 'prefetchnta': 50, 'lock add': 49, 'cmpnlesd': 49, 'cvtpd2ps': 47, 'shld': 45, 'pcmpeqb': 44, 'punpckhwd': 42, 'pmovmskb': 42, 'pcmpgtd': 41, 'fucomip': 40, 'pslld': 35, 'punpckhbw': 34, 'unpckhpd': 34, 'psrlq': 32, 'cld': 32, 'fdivp': 31, 'fadd': 31, 'psubq': 30, 'shrd': 30, 'fucomi': 29, 'cmovp': 29, 'pshuflw': 29, 'pshufhw': 29, 'btc': 29, 'fld1': 28, 'psllq': 28, 'bsf': 27, 'psrld': 26, 'packuswb': 25, 'fabs': 24, 'cpuid': 23, 'fdivrp': 21, 'maxpd': 21, 'int': 21, 'movhps': 20, 'pmuludq': 20, 'fsubrp': 19, 'cmpltpd': 19, 'subps': 19, 'divps': 19, 'cmpneqss': 19, 'minpd': 19, 'cmpnless': 18, 'stmxcsr': 18, 'ldmxcsr': 18, 'fsubp': 17, 'fchs': 17, 'pcmpgtb': 17, 'cbw': 17, 'cvttpd2dq': 17, 'pinsrw': 17, 'cmpnltss': 16, 'cvtpd2dq': 16, 'pushfq': 15, 'popfq': 15, 'pminub': 15, 'psubb': 13, 'lock sub': 12, 'pcmpgtw': 10, 'paddb': 10, 'fsqrt': 9, 'fnstcw': 9, 'palignr': 9, 'fdiv': 8, 'fsub': 8, 'fsubr': 8, 'sfence': 8, 'fxam': 8, 'wait': 8, 'fnstsw': 8, 'fnclex': 8, 'fprem': 8, 'cvtsd2si': 8, 'pmulld': 8, 'fdivr': 7, 'fcmovnbe': 7, 'pcmpistri': 7, 'cmpneqpd': 6, 'cmpeqss': 6, 'pcmpeqw': 6, 'psrlw': 6, 'pause': 6, 'vmovdqa': 6, 'vmovdqu': 6, 'psubusb': 5, 'pmaxub': 5, 'prefetcht0': 5, 'cmpneqps': 4, 'psraw': 4, 'mfence': 4, 'vzeroupper': 4, 'repe cmpsd': 3, 'maxps': 3, 'cvtdq2ps': 3, 'pextrw': 3, 'fldenv': 3, 'pshufb': 3, 'vpxor': 3, 'vmovntdq': 3, 'movntdq': 3, 'comiss': 3, 'lock bts': 2, 'fcmovbe': 2, 'psubusw': 2, 'outsb': 2, 'outsd': 2, 'insd': 2, 'jo': 2, 'fst': 2, 'psllw': 2, 'fnstenv': 2, 'jrcxz': 2, 'rdtsc': 2, 'prefetchw': 2, 'vpcmpgtb': 2, 'vpandn': 2, 'vpand': 2, 'vpor': 2, 'vpcmpeqb': 2, 'vpsubb': 2, 'vpmovmskb': 2, 'vpcmpistri': 2, 'lfence': 2, 'ptest': 2, 'cmovnp': 1, 'insb': 1, 'outsw': 1, 'vpminsb': 1, 'vpminsd': 1, 'cvttps2dq': 1, 'fscale': 1, 'fldcw': 1, 'tzcnt': 1, 'lock and': 1, 'popcnt': 1, 'vmovd': 1, 'vpshufb': 1, 'vmovq': 1, 'vinserti128': 1})
    # msvc specific, using groundtruth by Bao and Plohmann
    all_histograms_x86 = Counter({'num_functions': 129538, 'ret': 107683, 'mov': 106382, 'push': 101507, 'pop': 93246, 'call': 90833, 'add': 75808, 'jmp': 70397, 'cmp': 70245, 'je': 64126, 'jne': 60986, 'test': 58090, 'xor': 56252, 'lea': 50181, 'sub': 48433, 'inc': 29640, 'and': 28883, 'or': 19398, 'movzx': 18699, 'jle': 16280, 'dec': 15928, 'jl': 14663, 'leave': 12343, 'jge': 11945, 'jg': 9261, 'jb': 9202, 'shl': 8954, 'sbb': 8001, 'ja': 7944, 'neg': 7654, 'jae': 6880, 'jbe': 6870, 'shr': 6600, 'sar': 5880, 'movsx': 5462, 'js': 5252, 'imul': 5098, 'jns': 5082, 'setne': 4494, 'cdq': 4281, 'sete': 4021, 'nop': 3381, 'rep movsd': 1839, 'not': 1664, 'idiv': 1515, 'int3': 1502, 'adc': 1325, 'div': 1179, 'rep stosd': 838, 'rep movsb': 771, 'fstp': 755, 'setg': 713, 'fld': 667, 'setl': 496, 'mul': 474, 'setge': 450, 'movsd': 430, 'fldz': 413, 'setle': 401, 'stmxcsr': 367, 'fnstsw': 365, 'stosd': 360, 'rol': 332, 'fnstcw': 321, 'fild': 303, 'xchg': 280, 'wait': 271, 'shld': 241, 'cld': 239, 'cmove': 234, 'cmovne': 223, 'ror': 201, 'rep stosb': 200, 'rcr': 193, 'xorps': 186, 'movdqu': 184, 'jp': 173, 'shrd': 172, 'movq': 171, 'movlpd': 168, 'repne scasb': 156, 'movsb': 153, 'movsw': 148, 'fst': 148, 'pushfd': 141, 'fldcw': 141, 'std': 139, 'movdqa': 139, 'sets': 130, 'setns': 129, 'bts': 118, 'clc': 118, 'bt': 114, 'fadd': 108, 'fcomp': 106, 'fucompp': 105, 'stosb': 100, 'pxor': 100, 'cwde': 98, 'ldmxcsr': 96, 'stosw': 93, 'lock xadd': 91, 'fnclex': 77, 'cmova': 70, 'fmul': 69, 'jnp': 64, 'fchs': 63, 'loop': 63, 'fld1': 63, 'popal': 61, 'fistp': 61, 'cmovb': 61, 'pushal': 56, 'movd': 52, 'fxch': 44, 'lodsb': 41, 'fdiv': 37, 'fmulp': 36, 'fsub': 33, 'paddd': 33, 'ljmp': 31, 'fdivp': 30, 'xorpd': 29, 'cpuid': 28, 'lock cmpxchg': 28, 'lodsd': 27, 'cmovae': 27, 'setb': 26, 'fdivrp': 26, 'int': 26, 'fldpi': 25, 'psubd': 24, 'fsubp': 22, 'retf': 22, 'cvttsd2si': 21, 'faddp': 20, 'movapd': 19, 'frndint': 19, 'fucomp': 19, 'psrldq': 19, 'fabs': 19, 'psrlq': 18, 'psllq': 18, 'cmovl': 18, 'fcom': 18, 'fcompp': 18, 'repe cmpsb': 17, 'cmovbe': 17, 'andpd': 17, 'ucomisd': 17, 'bswap': 17, 'jecxz': 16, 'cmovns': 16, 'pshufd': 16, 'popfd': 14, 'cmovg': 14, 'xlatb': 14, 'fsubr': 14, 'seto': 13, 'cbw': 12, 'fxam': 12, 'rdtsc': 11, 'cmovge': 11, 'cmovs': 11, 'pslld': 11, 'fdivr': 10, 'addsd': 10, 'repe cmpsd': 9, 'cmpnlepd': 9, 'psrld': 9, 'subsd': 9, 'pand': 8, 'cmpltpd': 8, 'orpd': 8, 'f2xm1': 8, 'fscale': 8, 'lodsw': 7, 'cmovle': 6, 'hlt': 6, 'insb': 6, 'outsb': 6, 'fidiv': 6, 'pmulld': 6, 'in': 5, 'repne scasw': 5, 'lcall': 5, 'das': 5, 'outsd': 5, 'fninit': 4, 'seta': 4, 'punpckldq': 4, 'arpl': 3, 'rcl': 3, 'loopne': 3, 'comisd': 3, 'lock inc': 2, 'lock dec': 2, 'btr': 2, 'sahf': 2, 'sti': 2, 'lock xchg': 2, 'pshufb': 2, 'outsw': 2, 'aas': 2, 'aaa': 2, 'jo': 2, 'xcryptcbc': 2, 'cvtsi2sd': 2, 'repne scasd': 2, 'bound': 2, 'cmpsd': 2, 'sal': 1, 'fisttp': 1, 'fcomip': 1, 'fucomip': 1, 'lahf': 1, 'pushf': 1, 'scasb': 1, 'cli': 1, 'jcxz': 1, 'repe cmpsw': 1, 'emms': 1, 'por': 1, 'setae': 1, 'pslldq': 1, 'aeskeygenassist': 1, 'aesenc': 1, 'aesenclast': 1, 'paddq': 1, 'pcmpeqq': 1, 'punpcklqdq': 1, 'psubq': 1, 'aam': 1, 'lock bts': 1, 'movups': 1, 'repne movsd': 1, 'repne movsb': 1, 'repne stosd': 1, 'repne stosb': 1, 'les': 1, 'sldt': 1, 'fimul': 1, 'fiadd': 1, 'fbstp': 1, 'rep movsw': 1})
    all_histograms_x64 = Counter({'num_functions': 106192, 'mov': 86807, 'ret': 81053, 'sub': 74410, 'add': 74329, 'call': 70083, 'jmp': 66833, 'cmp': 55737, 'xor': 53815, 'lea': 53661, 'je': 51419, 'test': 50093, 'jne': 49506, 'push': 45546, 'pop': 44960, 'inc': 25204, 'movzx': 23127, 'movsxd': 22975, 'or': 18761, 'and': 18466, 'dec': 17530, 'nop': 17467, 'jle': 15478, 'jl': 12598, 'jge': 11000, 'jg': 8178, 'shl': 7005, 'jae': 6419, 'imul': 6393, 'jb': 6359, 'not': 6213, 'sar': 5901, 'shr': 5792, 'ja': 5711, 'js': 5236, 'repne scasb': 5180, 'movsx': 4911, 'cmove': 4713, 'cmovne': 4609, 'cdqe': 4576, 'jns': 4120, 'jbe': 3947, 'neg': 3609, 'sete': 3540, 'cdq': 3396, 'setne': 3283, 'sbb': 2567, 'int3': 2242, 'cmovl': 1938, 'cmovg': 1827, 'movabs': 1307, 'bt': 1186, 'bts': 1087, 'idiv': 1078, 'cmovs': 908, 'movsd': 860, 'div': 854, 'movaps': 839, 'btr': 746, 'rep movsb': 663, 'repe cmpsb': 629, 'cmova': 546, 'cmovb': 432, 'movups': 415, 'setg': 362, 'movd': 362, 'setl': 341, 'movdqa': 338, 'lock dec': 336, 'cmovle': 324, 'setge': 319, 'cvtdq2pd': 318, 'xorpd': 290, 'movapd': 281, 'rep stosd': 279, 'mulsd': 269, 'rol': 256, 'mul': 236, 'cmovge': 231, 'seta': 229, 'addsd': 214, 'lock inc': 196, 'comisd': 194, 'ror': 189, 'subsd': 189, 'setb': 185, 'movdqu': 152, 'setns': 137, 'xchg': 128, 'divsd': 124, 'cmovae': 123, 'movq': 119, 'pxor': 115, 'cvttsd2si': 114, 'adc': 110, 'rep stosb': 103, 'setle': 85, 'cqo': 84, 'ucomisd': 83, 'movnti': 82, 'lock or': 82, 'setbe': 79, 'cvtsi2sd': 75, 'jp': 69, 'cmovbe': 60, 'lock xadd': 60, 'cmovns': 58, 'movss': 54, 'repne scasd': 51, 'setae': 50, 'paddd': 48, 'cmovo': 46, 'lock add': 44, 'cwde': 44, 'prefetchnta': 41, 'bswap': 39, 'sets': 39, 'psrldq': 36, 'andpd': 33, 'pand': 32, 'psubd': 32, 'lock cmpxchg': 30, 'btc': 29, 'xorps': 28, 'psrlq': 24, 'psubq': 24, 'por': 24, 'int': 21, 'sqrtsd': 20, 'cvtps2pd': 20, 'cpuid': 16, 'stmxcsr': 16, 'ldmxcsr': 16, 'cvttpd2dq': 16, 'cvtpd2dq': 16, 'orpd': 16, 'pshufd': 16, 'cvtsd2ss': 12, 'pslld': 12, 'unpcklps': 9, 'rep movsd': 9, 'fld': 8, 'fxam': 8, 'wait': 8, 'fnstsw': 8, 'fnclex': 8, 'fprem': 8, 'fstp': 8, 'movlpd': 8, 'cvtsd2si': 8, 'psrld': 8, 'pmulld': 8, 'jnp': 6, 'rep movsq': 6, 'punpckldq': 4, 'rep stosq': 4, 'repe cmpsd': 3, 'comiss': 3, 'lock bts': 2})


    def __init__(self, bitness=32):
        counts = deepcopy(self.all_histograms_x86) if bitness == 32 else deepcopy(self.all_histograms_x64)
        num_documents = counts.pop("num_functions")
        for term, term_count in counts.items():
            self.idf[term] = self._calculateIdf(num_documents, term_count) if term_count else self._calculateIdf(num_documents, 1)

    def getTfIdfFromBlocks(self, blocks):
        term_counts = Counter()
        for _, block in blocks.items():
            for ins in block:
                term_counts[str(ins[2])] += 1
        return self.tfidf(term_counts)


    def tfidf(self, term_counts):
        score = 0
        sum_term_counts = sum(term_counts.values())
        max_count = max(term_counts.values())
        for term, term_count in term_counts.items():
            score += self._calculateTf(sum_term_counts, term_count, max_count) * self.getFrequency(term)
        return score

    def _calculateTf(self, num_terms, term_count, max_term_count=0):
        # raw count
        return term_count
        # term frequency
        # return term_count / num_terms if num_terms else 0
        # double normal 0.5
        # return 0.5 + 0.5 * (term_count / max_term_count) if max_term_count else 0.5
        # log normal
        # return math.log(1 + term_count)
        # binary
        # return 1 if term_count else 0

    def _calculateIdf(self, num_documents, value_count):
        # idf probabilistic
        return math.log(1.0 * (num_documents - value_count) / value_count)
        # smooth
        # return math.log(num_documents / (1 + value_count)) + 1
        # idf
        # return math.log(num_documents / (value_count))

    def getFrequency(self, term):
        # if we don't have that word in our collection, use the least observed frequency
        return self.idf[term] if term in self.idf else max(self.idf.values())
