import jieba.posseg as pseg
import jieba
import math,time
from gensim.models import word2vec
from pathlib import Path
from nltk.tokenize import word_tokenize
import multiprocessing



def dict_info():
    desc = """
    【大连理工大学情感本体库】
     七大情绪分类，依次是哀、恶、好、惊、惧、乐、怒；对应的情绪词表依次：
    DUTIR_Ais = {"泣血捶膺", "望断白云", "日暮途穷", "身微力薄"...}
    DUTIR_Wus = {"饰非遂过", "恶语", "毁害", "恶籍盈指", "脾气爆躁", "淫贱", "凌乱"...}
    DUTIR_Haos =  {"打破砂锅璺到底", "多彩", "披沙拣金", "见机行事", "精神饱满"...}
    DUTIR_Jings = {"骇人视听", "拍案惊奇", "悬念", "无翼而飞", "原来", "冷门"...}
    DUTIR_Jus ={"山摇地动", "月黑风高", "流血", "老鼠偷猫饭－心惊肉跳", "一发千钧"...}
    DUTIR_Les ={"含哺鼓腹", "欢呼鼓舞", "莺歌蝶舞", "将伯之助", "逸兴横飞", "舒畅"...}
    DUTIR_Nus = {"怨气满腹", "面有愠色", "愤愤", "直眉瞪眼", "负气斗狠", "挑眼"...}
    
    【知网Hownet词典】
    含正负形容词、否定词、副词等词表，对应的词表依次:
    HOWNET_deny = {"不", "不是", "不能", "不可"...}
    HOWNET_extreme = {"百分之百", "倍加", "备至", "不得了"...}
    HOWNET_ish = {"点点滴滴", "多多少少", "怪", "好生", "还", "或多或少"...}
    HOWNET_more = {"大不了", "多", "更", "比较", "更加", "更进一步", "更为", "还", "还要"...}
    HOWNET_neg = {"压坏", "鲁莽的", "被控犯罪", "银根紧", "警惕的", "残缺", "致污物", "柔弱"...}
    HOWNET_pos = {"无误", "感激不尽", "受大众欢迎", "敬礼",  "文雅", "一尘不染", "高精度", "兴盛"...}
    HOWNET_very = {"不为过", "超", "超额", "超外差", "超微结构", "超物质", "出头"...}
    
    【金融情绪词典】
    正式文本与非正式文本的金融领域中文情绪词典
    姚加权,冯绪,王赞钧,纪荣嵘,张维.语调、情绪及市场影响:基于金融情绪词典[J].管理科学学报,2021,24(05):26-46.
    #正式-肯定情绪词典
    FORMAL_pos_words = ['100强', '3A级', '50强', 'AAA级', 'AAA企业', ...]
    #正式-否定情绪词典
    FORMAL_neg_words = ['安于现状', '暗藏', '暗淡', '暗黑', '暗流', '暗箱操作','黯淡',...]
    #非正式-肯定情绪词典
    UNFORMAL_pos_words = ['爱心','安定','安全','安然无恙','安泰','霸主','百里挑一','百炼成钢','拜服',...]
    #非正式-否定情绪词典
    UNFORMAL_neg_words = ['哀鸿遍野','肮脏','罢免','白痴','败笔','败诉','半信半疑','包袱','保守','抱怨',...]
    
    
    【停用词表】
    中英文停用词表，依次
    STOPWORDS_zh = {"经", "得", "则甚", "跟", "好", "具体地说"...}
    STOPWORDS_en = {'a', 'about', 'above', 'across', 'after'...}
    
    【中文副词/连词】
    副词ADV、连词CONJ
    ADV_words = ['都', '全', '单', '共', '光'...}
    CONJ_words = ['乃', '乍', '与', '无', '且'...}
    """
    print(desc)

#大连理工大学情感本体库, 七大情绪分类，依次是哀、恶、好、惊、惧、乐、怒
#哀
DUTIR_Ais = {"泣血捶膺", "望断白云", "日暮途穷", "身微力薄", "丢面子", "苦海茫茫", "记挂", "无形之罪", "情话", "归心如箭", "大旱云霓", "丧明之痛", "沮丧", "殉葬", "内忧外患", "枉费心力", "水深火热", "疮痍", "头破血出", "嚎啕大哭", "秦庭之哭", "道尽途殚", "苦命", "粗茶淡饭", "落难", "福无双至", "啥也不说了", "血泪", "钢针刺胸口－心痛", "神醉心往", "抚今悼昔", "令原之戚", "乐极生哀", "肝胆胡越", "赤地千里", "千灾百难", "昌亭旅食", "弱不胜衣", "哀戚", "声泪俱下", "莽莽苍苍", "伤逝", "凌虐", "怀念", "获兔烹狗", "追述", "形影自守", "伤兵", "辛酸", "唤起", "垂暮之年", "亡国之社", "怀想", "一场春梦", "裘敝金尽", "残局", "失声", "雅司病", "岁在龙虵", "泡影", "手足异处", "文通残锦", "荒芜", "豪竹哀丝", "患难", "無語", "凋零", "愁眉啼妆", "无私有弊", "泣不可仰", "计出无聊", "乌踆兔走", "魂颠梦倒", "煎胶续弦", "千里迢迢", "驾鹤成仙", "灰朦朦", "神焦鬼烂", "泣涕如雨", "食不糊口", "风吹日晒", "嗒然", "手不应心", "无计奈何", "坠毁", "家烦宅乱", "凄恻", "哀天叫地", "失却", "桑落瓦解", "偎乾就湿", "昊天不吊", "渴求", "镂脂翦楮", "可叹", "片甲不存", "追忆", "面无表情", "噬脐何及", "愁云", "负荆请罪", "感今惟昔", "云烟过眼", "力竭声嘶", "扑空", "引日成岁", "室如县罄", "苦涩", "咳声叹气", "断梗飘蓬", "白搭", "枉用心机", "家散人亡", "身先朝露", "骨瘦如豺", "悲哽", "炎症", "涕泣", "强弩之极", "生前", "水火无情", "释生取义", "诲尔谆谆，听我藐藐", "瓦解冰消", "瘦瘠", "露餐风宿", "死声咷气", "意懒心灰", "太阿倒持", "爱别离苦", "引决自裁", "带减腰围", "败於垂成", "清瘦", "亏本", "亡矢遗镞", "辞别", "飘茵堕溷", "日落西山", "天崩地塌", "砸饭碗", "去日苦多", "投闲置散", "陟岵陟屺", "河东三箧", "驿寄梅花", "寸步千里", "凶终隙末", "一败涂地", "灰身泯智", "饥寒交迫", "一木难支", "五内俱焚", "悲歌易水", "悻悻", "今月古月", "雾惨云愁", "与世长辞", "形单影只", "千回百转", "连明连夜", "钟鸣漏尽", "鸿爪雪泥", "如今", "阮囊羞涩", "孤俦寡匹", "创伤", "钟漏并歇", "惜老怜贫", "节哀顺变", "感旧之哀", "视丹如绿", "鹤唳猿声", "不可究诘", "倚门倚闾", "落漠", "舍弃", "灰心丧意", "报废", "朝齑暮盐", "哀鸿遍野", "枯朽之馀", "苦处", "出局", "糠豆不赡", "偏生", "风中之烛", "寒心", "负屈", "哀哀切切", "啼哭", "十眠九坐", "幽明永隔", "伤神", "门可张罗", "枯木死灰", "没奈何", "挂肚牵肠", "寝苫枕块", "釜中生鱼", "行不得也哥哥", "悲恸", "明日黄花", "大材小用", "缺憾", "深切", "残破不全", "幻灭", "贫贱", "痴情碰冷遇－伤透了心肝", "羊肠鸟道", "凄惶", "未成一篑", "龙驭上宾", "鹤骨鸡肤", "恨相见晚", "哀辞", "沦肌浃髓", "悲观地", "花残月缺", "春树暮云", "冤气", "鸿隐凤伏", "凭吊", "曾经沧海", "无何有之乡", "想儿", "迫不得已", "黯然伤神", "凄寒", "白头如新", "悱恻缠绵", "寸木岑楼", "搥胸顿足", "哀鸿", "心力交瘁", "灰身粉骨", "千辛万苦", "众寡不敌", "孤苦零丁", "糠菜半年粮", "蓬户柴门", "道尽涂殚", "自责", "朝不保夕", "舌敝唇焦", "志哀", "形影相对", "心如槁木", "於呼哀哉", "众口嗷嗷", "顾全", "伤心", "悲酸", "食少事烦", "茕茕孑立", "万箭攒心", "令人遗憾", "怀才不遇", "跌脚搥胸", "边鄙", "凄楚", "坐失良机", "抚景伤情", "眷眷", "苍老", "万不得已", "叹息", "人去楼空", "心寒", "只言片语", "人琴俱亡", "赔不是", "狐死首丘", "寒泉之思", "谢罪", "铜驼荆棘", "巢毁卵破", "裁处", "饥肠辘辘", "计日以俟", "优患余生", "足茧手胝", "荒漠", "一败如水", "百业萧条", "辙乱旗靡", "溃逃", "百身莫赎", "离乡别土", "呜呼", "心痛", "撒科打诨", "如之奈何", "头童齿豁", "孤悬浮寄", "赔罪", "挖耳当招", "号哭", "泛萍浮梗", "赘食太仓", "零星", "悼亡", "无语", "適得其反", "火坑", "玄酒瓠腑", "玉关人老", "病号", "论高寡合", "顾念", "樵苏不爨", "五鬼闹判　", "龙去鼎湖", "生不逢辰", "计无由出", "文章憎命", "沧海遗珠", "血吸虫病", "颠沛流离", "尽付东流", "兵败如山倒", "家徒四壁", "散伙", "肚里泪下", "长歌当哭", "流离颠沛", "凄凉", "寂寥", "生变", "鸮啼鬼啸", "追悔莫及", "白驹空谷", "又弱一个", "离乡背井", "食不餬口", "依人篱下", "若敖鬼馁", "愧怍", "计穷虑尽", "流移失所", "伤痕", "回忆", "郁郁寡欢", "心如刀割", "伤怀", "上天无路，入地无门", "痴想", "啼天哭地", "云树遥隔", "火山汤海", "孤苦仃俜", "问心有愧", "舟中敌国", "巴巴", "不名一文", "三差两错", "屠门大嚼", "珠泪偷弹", "乐尽悲来", "爱莫之助", "重担", "久客思归", "无以塞责", "不遂", "未达一间", "悲剧", "逆子", "失悔", "破国亡宗", "买王得羊", "苒弱", "祸近池鱼", "国步艰难", "孤单", "天晓得", "板栗连壳吞下肚－千针万刺痛在心", "为国捐躯", "致哀", "嚎天喊地", "重温旧梦", "神嚎鬼哭", "望洋兴叹", "事与原违", "吃后悔药", "牵念", "金尽裘敝", "鬼哭狼嚎", "宝山空回", "手泽之遗", "抱恨终生", "追寻", "驷之过蠙", "回禄", "垂头丧气", "灰身灭智", "颓垣断堑", "分文不名", "既有今日，何必当初", "身名俱败", "惜别", "雨断云销", "依违", "驰念", "萧条", "负薪之忧　", "孤孤单单", "闭口无言", "归正邱首", "如到宝山空手回", "得不偿失", "无人之地", "惦念", "不得其所", "念旧", "不堪其忧", "食不下咽", "含悲", "风刀霜剑", "对口相声", "延颈举踵", "孤军深入", "兰因絮果", "单忧极瘁", "忧惧", "乐极哀来", "丧乱", "孤立无援", "流年不利", "眼晕", "顾影自怜", "家反宅乱", "抚髀兴叹", "深望", "音容宛在", "拉饥荒", "牵肠割肚", "哀乐", "关切", "号啕", "企望", "殉职", "鹑衣百结", "祝发空门", "望峰息心", "悔悟", "悲苦", "遥遥无期", "社稷为墟", "不中", "零落", "抱头大哭", "不测", "荒凉", "破碎", "落落难合", "梗迹蓬飘", "槁木死灰", "冻害", "破琴绝弦", "扼腕", "默哀", "缅怀", "大醇小疵", "末日", "何去何从", "流落失所", "痛苦", "白璧微瑕", "人生如寄", "千疮百痍", "贫病交迫", "师老兵疲", "家业凋零", "一草一木", "无济于事", "孤鸾照镜", "磨砖成镜", "长亭短亭", "后事", "回想", "灾荒", "二佛涅槃", "离鸾别凤", "冤沉海底", "断线风筝", "毁车杀马", "悲观主义", "毁方瓦合", "呼天号地", "萧瑟", "长才短驭", "心如死灰", "形孤影寡", "奢望", "不逞", "桑梓之念", "渺茫", "鬼哭天愁", "散戏", "月缺花残", "式微", "得不偿丧", "珠零玉落", "影只形孤", "孤形吊影", "清减", "抽咽", "少壮不努力，老大徒伤悲", "伤悲", "哀叹", "飘萍断梗", "回肠百转", "失恋", "哀声叹气", "奠祭", "立足之地", "山木自寇", "暮想朝思", "鸾孤凤寡", "坐失机宜", "鸿消鲤息", "回头", "神驰力困", "心如刀搅", "灾难", "哭丧着脸", "绠短汲深", "寸阴若岁", "云开雾释", "啼饥号寒", "跼天促地", "如蹈汤火", "慰唁", "惭凫企鹤", "亲痛仇快", "流落他乡", "含汙忍垢", "吴市吹箫", "蹉跎日月", "不是滋味儿", "sigh", "孤魂野鬼", "魂不著体", "计穷虑极", "鹿走苏台", "无计可奈", "吞声忍泪", "饮泣吞声", "觉人觉世", "水中捉月", "途穷日暮", "弹尽粮绝", "忧戚", "俟河之清", "哭嚎", "转蓬", "伤悼", "食藿悬鹑", "超度", "灰心丧气", "形容憔悴", "有嘴没舌", "心低意沮", "悲泣", "赤白痢", "日薄西山", "颓垣废井", "孤独", "聊以自慰", "忧思", "自悔", "切切", "抱恨黄泉", "废然", "龙头锯角", "补偿", "沦陷", "道殣相属", "无影无踪", "心如寒灰", "人弃我取", "褐衣不完", "师老民困", "半截入土", "不忘故旧", "炎凉", "不幸", "弃甲负弩", "强死强活　", "风行雨散", "片接寸附", "伤筋动骨", "家破人亡", "孤立无助", "剖心泣血", "大海捞针", "丧钟", "朝思暮想", "升天", "懈气", "悲歌击筑", "死声淘气", "鸟哭猿啼", "李广不侯", "众叛亲离", "清苦", "不足", "惨不忍言", "剥落", "痫入骨髓", "吞声", "疾不可为", "狐死兔泣", "昙花一现", "破败", "裁撤", "万念俱灰", "摈弃", "惨境", "道殣相枕", "龙潜凤采", "没落子", "踽踽凉凉", "住院", "戚然", "怨离惜别", "门殚户尽", "丧家", "哀哀欲绝", "江河日下", "悲悯", "乐昌之镜", "寒酸", "四壁萧然", "前尘影事", "自馁", "龙门点额", "水底捞针", "猿鹤虫沙", "神郁气悴", "饥馑荐臻", "苍凉", "黄连水里泡竹笋－苦透了", "并日而食", "荡析离居", "哭哭啼啼", "铜驼草莽", "哀矜", "苦主", "离情别绪", "人为刀组", "衡石程书", "凋败", "雨零星乱", "望尘莫及", "浩叹", "悔读南华", "骨肉未寒", "猿啼鹤唳", "非意相干", "呼天抢地", "眼巴巴", "战火", "悲观失望", "雨恨云愁", "身首异地", "难受", "黄钟毁弃，瓦釜雷鸣", "瓦解冰泮", "穷醋大", "伫结之情", "丧失", "枉费心思", "心慵意懒", "兔走乌飞", "世殊事异", "咫尺千里", "凄怨", "同归于尽", "背乡离井", "枯鱼病鹤", "孤鸿寡鹄", "命蹇时乖", "黄钟毁弃", "李广未封", "活天冤枉", "散失", "月明千里", "虎视", "东窗事犯", "锐挫望绝", "道别", "风雨飘摇", "折戟沉沙", "泪眼", "穷措大", "遇人不淑", "火上弄冰", "俏皮话", "悲悼", "别离", "付之东流", "身无完肤", "哑巴吃黄连－有苦说不出", "双凫一雁", "讷口少言", "泪如雨下", "低潮", "冷清", "辗转思念", "岁不我与", "心灰意败", "虚空", "倒悬之危", "伤俘", "病入膏肓", "丧亡", "荒寂", "短命", "枕冷衾寒", "七零八落", "汲汲顾影", "英雄无用武之地", "引咎自责", "牙龈", "悲辛", "鱼网鸿离", "玉减香销", "查无实据", "逝将去汝", "石沉大海", "摧折", "哀悯", "离群索居", "赍志以殁", "贫寒", "嘘唏不已", "活受罪", "椒焚桂折", "亡国奴", "逝世", "不可挽回", "低落", "无妄之忧", "独木不成林", "家道壁立", "萧疏", "悔改", "乞穷俭相", "憔悴", "枯形灰心", "飞蛾扑火", "鸿雁哀鸣", "三日新妇", "强弩末矢", "负屈含冤", "吃了黄连对人说－诉苦", "如堕五里雾中", "功亏一篑", "额蹙心痛", "神号鬼哭", "灾患", "不是滋味", "流离失所", "呻吟", "身故", "气息奄奄", "形影自吊", "悉眉苦脸", "人地生疏　", "低回", "尸居余气", "青衫司马", "惙怛伤悴", "倦鸟之还", "怀恋", "断代", "认输", "清冷", "泪如泉涌", "杼柚空虚", "无能为役", "攻苦食俭", "同病相怜", "长叹", "九仞一篑", "脸青鼻肿", "一无所有", "睹物思人", "飘茵落溷", "玉碎香销", "哀子", "伤疤", "人为", "牵萝莫补", "悲声载道", "豪管哀弦", "垂危", "丧礼", "无容身之地", "空荡荡", "攻苦茹酸", "左思右想", "分心挂腹", "艰苦", "千愁万恨", "伤心蒿目", "鳏鱼渴凤", "轹釜待炊", "孤立寡与", "未竟之志", "哀悼", "身败名隳", "水月镜花", "火热水深", "陷落", "红颜薄命", "挫败", "无如之奈", "饮血崩心", "眼泪", "气馁", "寡不胜众", "枉费工夫", "人老珠黄", "天夺之年", "反吟伏吟", "人心不古", "劫数", "转喉触讳", "家道中落", "髀肉复生", "苦口", "嗳声叹气", "惨淡", "寂廖", "音信杳无", "自崖而反　", "叹惋", "抱愧", "焦黄", "有志无时", "颓垣废址", "拊心泣血", "孤苦", "不敢越雷池一步", "心疼", "依依惜别", "抱歉", "萧森", "星离云散", "回肠九转", "思恋", "悔其少作", "悼辞", "两手空空", "北风之恋", "悲惨", "无能为力", "鸿爪留泥", "怜悯", "荆棘铜驼", "骏骨牵盐", "核讹诈政策", "重孝", "招架不住", "悲鸣", "败阵", "惨重", "龙胡之痛", "挥泪", "时乖命蹇", "枯骨之馀", "驿使梅花", "嗟悔", "千疮百孔", "开吊", "残花败柳", "泪人儿", "火烧旗杆－长叹", "落花流水", "龙蟠凤逸", "三好两歹", "魏鹊无枝", "死不瞑目", "殉难", "巴巴儿地", "文君新寡", "兔死狐悲", "前功尽灭", "困境", "悔恨", "首当其冲", "顿足捩耳", "十病九痛", "孤苦伶仃", "孤零零", "末路", "龙盘凤逸", "引咎", "呜呼哀哉", "大厦将倾，一木难支", "血流成河", "好景不长", "怀道迷邦", "面有愧色", "衰亡", "暮虢朝虞", "乞哀告怜", "孤臣孽子", "朽木死灰", "清癯", "势穷力竭", "巴望", "追想", "无可奈何", "死告活央", "如饥如渴", "丧偶", "云消雾散", "为山止篑", "铭肤镂骨", "哀毁骨立", "百孔千疮", "裁汰", "怀土之情", "乐极则忧", "肝胆楚越", "跷足抗首", "血友病", "补正", "黎庶涂炭", "无从下手", "惨剧", "截镫留鞭", "橘化为枳", "满目凄凉", "荏苒", "魂劳梦断", "亏折", "鹄形鸟面", "顾景惭形", "一场空", "死别生离", "洒洒潇潇", "跌脚槌胸", "抱屈衔冤", "嚎天动地", "错怪", "衔冤负屈", "发人深省", "销魂", "穷途之哭", "血泪盈襟", "引领而望", "清尘浊水", "泻肚", "崔莺莺送郎－说不出的伤心", "悼心失图", "涕泪交集", "长吁短叹", "安土重迁", "生病", "撑船的竹蒿－提起泪流", "一念之差", "渴盼", "鹤归华表", "丢盔抛甲", "零圭断璧", "驷之过隙", "洒泪", "殡仪馆", "噫呜流涕", "凶耗", "多愁善感", "瓦解冰销", "不行", "断送", "椎心泣血", "履穿踵决", "过屠门而大嚼", "短暂", "终身大事", "六月飞霜", "泪珠", "棋输先著", "先烈", "沦丧", "强颜欢笑", "拜扫", "归心似箭", "治丝而棼", "痛哭", "伤心疾首", "战乱", "哀号", "雁影分飞", "千难万难", "渴念", "霜露之感", "汗血盐车", "夭折", "关门大吉", "离别", "竹篮子打水一场空", "孤兒寡妇", "逼仄", "拨开皮肉种红豆－入骨相思", "白云亲舍", "桑榆暮景", "郁结", "追叙", "零丁", "拂意", "触目兴叹", "刻骨铭心", "惨不忍闻", "局天扣地", "寡不敌众", "敲髓洒膏", "自卑", "天崩地坍", "鸿飞雪爪", "水底捞月", "蓬头历齿", "情绪低落", "岛瘦郊寒", "泥牛入海", "漫天烽火", "大水冲了龙王庙　", "孤哀子", "痘疮", "疏远", "黄锺毁弃", "含垢忍污", "魂驰梦想", "损兵折将", "自惭形秽", "风木之思", "拒虎进狼", "破落", "再衰三竭", "枉费心计", "安息", "巧妇难无火之炊", "李广难封", "抚时感事", "玉楼赴召", "拔十得五", "瓦器蚌盘", "口燥唇干", "水中捞月", "倦尾赤色", "对不住", "龙阳泣鱼", "豕分蛇断", "不名一钱", "腹背之毛", "没世无闻", "相思", "身世", "得不补失", "不佞", "鼓盆之戚", "玉碎", "翘足引领", "乞怜", "饥寒交凑", "气不过", "人生若寄", "孤雌寡鹤", "切肤之痛", "寂寞", "冻疮", "惦记", "失望", "乐极悲生", "悲咽", "司马青衫", "长念卻虑", "残生", "断金零粉", "哭泣", "罗雀掘鼠", "千岁鹤归", "爱莫能助", "昊天罔极", "龙御上宾", "多灾多难", "道尽途穷", "鹤唳华亭", "送命", "黄粱一梦", "槐南一梦", "扪心自问", "秋水伊人", "伤口", "金瓶落井", "家业调令", "冻伤", "无倚无靠", "兔葵燕麦", "惨笑", "势穷力蹙", "无从措手", "山崩川竭", "每逢佳节倍思亲", "内视反听", "不景气", "不可企及", "钳口不言", "彩云易散", "乐极则悲", "天粟马角", "残破", "对口疮", "悲从中来", "晓风残月", "半壁江山", "悼念", "哀思如潮", "杞国之忧", "还珠买椟", "悲戚", "拜拜", "纪念", "魂销目断", "望尘不及", "惨雨酸风", "室如悬罄", "无肠可断", "不遑", "泣不成声", "驿路梅花", "离合悲欢", "不堪回首", "低沉", "堕云雾中", "龟冷支床", "无依无靠", "千头万绪", "产褥热", "十步九回头", "悔不该", "冷冷清清", "回黄转绿", "大势已去", "弃甲丢盔", "肠断", "身无立锥", "局地扣天", "计穷智极", "家翻宅乱", "圆寂", "材大难用", "片甲不还", "涂炭", "有负众望", "潸然泪下", "人琴俱逝", "断肠", "无所依归", "连明达夜", "差彊人意", "分崩离析", "干啼湿哭", "吕安题凤", "杞国忧天", "垂暮", "炙肤皲足", "兰摧玉折", "难于上天", "无可柰何", "追怀", "栋折榱崩", "凄风苦雨", "河蟹", "箪食瓢饮", "半文盲", "再衰三涸", "三病四痛", "长吁短气", "饮冰茹檗", "岁在龙蛇", "不外", "形影相随", "哀告", "泄气", "幽咽", "愧赧", "二竖之顽", "陋巷箪瓢", "彩凤随鸦", "枯蓬断草", "昼吟宵哭", "跋前踬后", "忽略", "殡葬", "眷恋", "惨绝人寰", "丧服", "全军覆没", "痛心", "树倒猢狲散", "跼天蹐地", "鼻酸", "气断声吞", "忧伤", "如蹈水火", "瘭疽", "聊以卒岁", "身后", "散亡", "薄命", "苦水", "咽峡炎", "霜露之病", "计穷途拙", "天末凉风", "触景商情", "血枯病", "枯枿朽株", "惨痛", "抑郁寡欢", "人命危浅", "荜门闺窦", "卖兒贴妇", "片瓦无存", "十生九死", "道歉", "付诸东流", "月盈则食", "亡国", "孤身只影", "东劳西燕", "札人忧天", "寸田尺宅", "悲凄", "抱恨终天", "牛衣对泣", "发人深醒", "可惜", "可乘之隙", "孤寡", "天安门事件", "悲天悯人", "枯鱼衔索", "歉疚", "风流云散", "家贫如洗", "驾鹤西游", "山穷水尽", "落莫", "哀感中年", "哀思", "离乡别井", "坠落", "伸冤", "死心", "败谢", "门衰祚薄", "吊祭", "浇漓", "难乎为继", "着凉", "歇菜", "殡殓", "吃教", "狼号鬼哭", "节节败退", "交臂相失", "揪心", "凄婉", "情感", "霜露之悲", "三灾六难", "五日京兆", "存十一於千百", "哭鼻子", "柴毁骨立", "喟叹", "灰色", "朝不谋夕", "环堵萧然", "计无所施", "毁于一旦", "落花有意，流水无情", "物是人非", "蹉跎", "凄迷", "咫尺天涯", "海怀霞想", "亏蚀", "船到江心补漏迟", "哭天抹泪", "蕉萃", "痛楚", "连理分枝", "延颈鹤望", "偕生之疾", "人琴两亡", "乐昌分镜", "长逝", "七死八活", "化为乌有", "秕子", "悲愁", "门闾之望", "身无寸缕", "一日三秋", "对着墙壁流眼泪－独自伤心", "山穷水绝", "叹气", "推延", "山穷水断", "会少离多", "不消", "即鹿无虞", "当面错过", "人百其身", "风雨晦冥", "南柯一梦", "借酒消愁", "流民", "悲伤", "一朝天子一朝臣", "险阻艰难", "死於非命", "风雨飘零", "停云落月", "千头万序", "沉沦", "愀然", "病笃", "马齿徒长", "低声下气", "鬼烂神焦", "今是昔非", "肉痛", "怨悔", "瓮牖桑枢", "逐北", "悲不自胜", "世风日下", "汗颜无地", "疏忽", "席薪枕塊", "酸辛", "入神", "懊悔", "悔不当初", "不是味儿", "遇害", "悱恻", "鸿泥雪爪", "龟厌不告", "树倒根摧", "错爱", "丧事", "闭门思过", "物伤其类", "热泪盈眶", "凋敝", "连宵彻曙", "骨化形销", "颤巍巍", "上坟", "两瞽相扶", "望风破胆", "防不胜防", "伤风", "卷席而葬", "途遥日暮", "落月屋梁", "分道扬镳", "叹老嗟卑", "手足重茧", "鳏寡惸独", "迟迟吾行", "无情无彩", "涕零如雨", "情凄意切", "清贫", "节哀", "时乖运蹇", "饥寒交切", "身不由主", "镂冰雕朽", "责躬罪己", "寸步难移", "衰微", "落魄江湖", "请罪", "眼拙", "盼望", "告吹", "国将不国", "抱憾", "门单户薄", "变迁", "雨零星散", "一贫如洗", "芝焚蕙叹", "来日大难", "悲壮", "妻离子散", "门堪罗雀", "易子析骸", "马前泼水", "追悼", "昼度夜思", "陪了夫人又折兵", "思慕", "生疏", "梗泛萍漂", "天愁地惨", "期盼", "念念不忘", "风景不殊", "头破血淋", "怃然", "哑巴亏", "赍志而殁", "流离颠疐", "怀宝迷邦", "国破家亡", "流水落花", "谏尸谤屠", "水尽山穷", "云飞雨散", "適居其反", "乐往哀来", "散落", "天崩地解", "无人问津", "名落孙山", "伤员", "不忍", "泣数行下", "歉仄", "伤亡", "狼嚎鬼叫", "穷光蛋", "云悲海思", "事与愿违", "梦魂萦绕", "衰替", "惨绿愁红", "饭糗茹草", "投閒置散", "杞人之忧", "彩风随鸦", "有口难分", "血肿", "泪汪汪", "千山万水", "六尺之孤", "衰退", "畏威怀德", "一头跌在菜刀上－切肤之痛", "败局", "面黄肌瘦", "望穿秋水", "孤鸾寡鹤", "海桑陵谷", "海难", "痛心入骨", "鸾分凤离", "陷身囹圄", "悼心疾首", "地坼天崩", "失掉", "骥服盐车", "弱势", "悲痛", "孤寂", "步履维艰", "死败涂地", "身不遇时", "情至意尽", "跑墒", "前度刘郎", "饿殍遍野", "精力枯竭", "食荼卧棘", "上吊", "陨越", "计过自讼", "无如之何", "惨然", "晚节不终", "痛切", "火头", "孤负", "呕心抽肠", "跌脚捶胸", "惨苦", "背悔", "无可奈何花落去", "披麻戴孝", "流落天涯", "翘企", "冢木已拱", "千条万缕", "音容笑貌", "计无复之", "人天永隔", "等米下锅", "无补于事", "希图", "沦亡", "舍不得", "离婚", "付之一炬", "触景生情", "风木含悲", "枯鱼之肆", "脸黄肌瘦", "遇难", "室迩人远", "形只影单", "一命呜呼", "十室九空", "哀鸣", "天荆地棘", "踽踽独行", "哀叫", "林寒涧肃", "单丝不成线", "棘没铜驼", "百巧千穷", "三好两歉", "木梗之患", "衰败", "单鹄寡凫", "失约", "望眼欲穿", "潜蛟困凤", "云愁雨怨", "师不宿饱", "鸾凤分飞", "陨获", "乘兴而来", "疚愧", "玉石俱焚", "拽布披麻", "广种薄收", "人民城郭", "拜忏", "家无担石", "人生哲学", "鲽离鹣背", "残存", "思念", "海底捞针", "回顾", "榱崩栋折", "形影相附", "销神流志", "势穷力屈", "代马望北", "罐子里头点蜡烛－暗中流泪", "红豆", "牵萝补屋", "清寒", "千虑一失", "赤贫如洗", "浮湛连蹇", "黄蜂叮屁股－有痛说不出口", "形影相依", "心若死灰", "切记", "抚今痛昔", "一蹶不振", "自咎", "买牛得羊－大失所望", "不胜其苦", "烧伤", "身心交瘁", "哀莫大于心死", "雨歇云收", "悲怆", "贬值", "百辞莫辩", "饮泣", "生离死别", "吞风饮雨", "大惑不解", "炮灰", "盛筵难再", "青蝇吊客", "哀毁瘠立", "分香卖履", "无奈", "恹恹", "胶着", "黯然", "云泥殊路", "孤犊触乳", "新亭对泣", "黯然神伤", "悲愁垂涕", "心如刀绞", "拽布拖麻", "心如刀锯", "计日以待", "败绩", "停闭", "皱纹", "黾穴鸲巢", "拭目而待", "祸福无门", "怀旧", "淹溺", "泪如秋夜雨－一点一声愁", "浪迹萍踪", "离乡背土", "别鹤孤鸾", "纳履踵决", "山高水低", "失精落彩", "千金一掷", "风木之悲", "流水无情", "盼念", "命薄缘慳", "毁不危身", "前思后想", "连明彻夜", "消耗", "心虚", "城门失火，殃及池鱼", "喟然", "金钗换酒", "灰心", "泡汤", "哀哀父母", "叫苦不迭", "拜辞", "痛定思痛", "白骨露野", "流汗浃背", "海水桑田", "祸从天降", "空落落", "美中不足", "残喘", "报丧", "交臂失之", "凄惨", "黄钟长弃", "泰山梁木", "肘行膝步", "凄怆", "凄切", "痛失", "恻隐之心", "流离颠顿", "断气", "世态炎凉", "废书而叹", "覆盆之冤", "千里莼羹", "萧飒", "大失所望", "回船转舵", "镂冰炊砾", "悔恨交加", "清夜扪心", "抱疚", "傻眼", "漫长", "孤悬客寄", "衰落", "悔之不及", "殉情", "入地无门", "泪迸肠绝", "及溺呼船", "有气无烟", "于心何忍", "零丁孤苦", "驰思", "代马依风", "失欢", "血案", "六亲无靠", "失误", "劳筋苦骨", "冷窗冻壁", "伶仃孤苦", "若有所丧", "劳形苦心", "事与心违", "向日", "霜凋夏绿", "鞫为茂草", "凄寂", "乐极悲来", "恨事", "向隅而泣", "对不起", "辞行", "怀揣冰棍－凉透心", "釜底游鱼", "带孝", "惨不忍睹", "破灭", "泪液", "殒灭", "龙蟠凤翥", "早知今日，悔不当初", "丢盔卸甲", "浩劫", "依依不舍", "傫如丧狗", "无精汀采", "含冤", "残兵败将", "兔死狐悲－物伤其类", "引人深思", "万箭穿心", "叨在知己", "家无儋石", "两败俱伤", "无情无绪", "挽联", "泪花", "桑榆之光，礼无远照", "三好二怯", "以狸饵鼠", "倒霉", "镜里观花", "爽然", "贬谪", "打击", "携泰山以超北海", "颓垣败壁", "冤枉路", "采凤随鸦", "乌飞兔走", "只鸡絮酒", "无用武之地", "犁地淹死牛－伤透了", "强颜为笑", "狐兔之悲", "少吃无穿", "另楚寒巫", "十米九糠", "遍体鳞伤", "梦想颠倒", "四面楚歌", "暴卒", "千回百折", "马足车尘", "悲痛欲绝", "创巨痛深", "松口", "行号卧泣", "雷害", "苦难", "拊膺顿足", "颠沛", "无根无蒂", "擂天倒地", "不复堪命", "路叟之忧", "山亏一篑", "摧毁", "卸任", "挂记", "活地狱", "梦魂颠倒", "哀荣", "无人之境", "割席", "泰山其颓", "隐痛", "朝生暮死", "失去", "停学", "三迭阳关", "十室九匮", "饥冻交切", "嗟悔无及", "无所用之", "孤掌难鸣", "流亡", "哀痛欲绝", "凶信", "斗酒只鸡", "疮痍满目", "申冤", "遭家不造", "寒心销志", "跌弹斑鸠", "举目无亲", "自省", "得不酬失", "瓮声甕气", "鹄形菜色", "珠沉璧碎", "伤号", "败仗", "凄清", "痛惜", "想念", "啜泣", "马角乌头", "人亡物在", "连昏达曙", "孤单单", "积劳成疾", "司马牛之叹", "离鸾别鹤", "命苦", "黯然销魂", "千条万端", "回首", "潦原浸天", "镜分鸾凤", "殒命", "鬼泣神号", "飘樊落溷", "凄苦", "朝闻夕死", "鱼烂而亡", "身不由己", "风吹浪打", "汗流浃背", "失意", "来鸿去燕", "天年不测", "道大莫容", "背井离乡", "云愁海思", "行号巷哭", "鬼抓狼嚎", "微乎其微", "抱委屈", "珠沉玉磒", "心灰意懒", "千绪万端", "哀痛", "琴断朱弦", "败落", "困苦", "含冤负屈", "申雪", "无处可逃", "煎豆摘瓜", "遗憾", "受害", "故宫禾黍", "挂虑", "卑辞重币　", "残年", "形孤影只", "磨难", "百身何赎", "哽咽", "哀婉", "汗流浃踵", "风雨晦暝", "力不能支", "天年不齐", "凤靡鸾吪", "弃家荡产", "无何有乡", "反省", "孤立", "飘零", "灰躯糜骨", "莼鲈之思", "玉碎珠沉", "寄人篱下", "室徒四壁", "垂怜", "退思补过", "悄然", "啼泣", "玉减香消", "情歌", "违乡负俗", "怏怏", "半衰期", "树倒猢猻散", "叫苦连天", "哀感天地", "珠沉玉碎", "反躬自省", "道尽涂穷", "鳏寡孤独", "落空", "呼天叩地", "奔丧", "寸草不生", "玩儿完", "心心念念", "二旬九食", "劳燕分飞", "白费", "忧悒", "烽火连天", "耿耿于心", "悲切", "槁形灰心", "道殣相望", "飞蛾投火", "历历在目", "东播西流", "吹篪乞食", "室如悬磬", "连天烽火", "弃养", "心酸", "中馈犹虚", "神号鬼泣", "穷途末路", "哀伤", "变心", "痛不欲生", "钢刀吞肚里－割心肠", "愧对", "穷竭", "离多会少", "死棋", "报应", "天年不遂", "鳏寡孤惸", "动容", "风中秉烛", "话旧", "江流日下", "孤行吊影", "望尘靡及", "断线鹞子", "弱小", "遇险", "顿足捶胸", "鹤发鸡皮", "呜咽", "哀怜", "铸成大错", "挂席为门", "艰辛", "琵琶胡语", "渺无音信", "无米之炊", "白蜡明经", "恸哭", "弃甲曳兵", "无家可奔", "庞眉皓发", "国殇", "心碎", "殡车", "飞蛾赴烛", "奔走呼号", "潸潸", "漠漠", "归正首丘", "食不充肠", "颓垣败井", "风雨凄凄", "魂不着体", "霜露之思", "感今怀昔", "枉费脣舌", "守候", "横祸非灾", "心为形役", "坎坷", "有愧", "尸骨未寒", "筚门圭窦", "神牵鬼制", "只鸾单凤", "哀鸿遍地", "赍志以没", "痛处", "鸿爪春泥", "失明", "望岫息心", "枯木生花", "谢世", "饥寒交至", "悬悬在念", "无火之炊", "烛泪", "内疚", "别无长物", "坎坷不平", "离鸾别鹄", "落选", "亡国灭种", "病容", "抱憾终身", "凋落", "蹙国丧师", "戎行", "豆剖瓜分", "珠投璧抵", "光身子钻刺蓬－有刺又痛", "天各一方", "被难", "云树之思", "慷慨激烈", "抚今追昔", "井底捞月", "凄然泪下", "无服之殇", "鸦片战争", "死去活来", "刳精鉥心", "为德不终", "魂牵梦系", "无如奈何", "无家可归", "兼葭秋水", "高不可攀", "扣壶长吟", "泣下沾襟", "乌鸦命－人人憎", "鞠为茂草", "桂折兰摧", "露宿风餐", "三求四告", "穷目", "中心藏之", "沿门托钵", "功败垂成", "斯文扫地", "涕泗滂沱", "前功尽弃", "消息", "残败", "欲哭无泪", "愧悔", "饿殍枕藉", "抚今思昔", "伤感", "火烧乌龟－心里痛", "哀泣", "鹄面鸠形", "三长四短", "赔话", "后悔无及", "悔罪", "云开雾散", "即景生情", "悲哀", "难过", "悲歌", "割肚牵肠", "人生观", "顿足搓手", "丧命", "切切在心", "单相思", "前不巴村，后不巴店", "苦味", "失散", "乐尽哀生", "家败人亡", "过不去", "天壤王郎", "海底捞月", "饿莩遍野", "昼想夜梦", "计日而俟", "窘困", "十里长亭　", "抚躬自问", "尸横遍野", "片甲不回", "荒弃", "牺惶", "孤儿寡妇", "无了根蒂", "告负", "失宠", "毁不灭性", "兔缺乌沈", "衷曲", "失陷", "劳身焦思", "人面桃花", "桑榆之光，理无远照", "变故", "祈盼", "内室反听", "重创", "食不充饥", "悬肠挂肚", "门可罗雀", "牵肠萦心", "如泣如诉", "鸡皮鹤发", "眼睁睁", "自怨自艾", "闻声相思", "哀哀", "痛哭流涕", "涕泗滂沲", "沉迷", "狼艰狈蹶", "急痛攻心", "丧葬", "如此而已", "没没无闻", "断粮", "安厝", "风吹雨打", "才高运蹇", "泪痕", "荒无人烟", "牵肠挂肚", "倾家荡产", "漏尽锺鸣", "自身难保", "补苴", "伤害", "穷山恶水", "食不充口", "牵挂", "哀启", "转筋", "于心有愧", "肝肠寸断", "枯槁", "沉痛", "鸿飞霜降", "鼠入牛角", "向隅", "衰老", "千愁万绪", "飞蛾赴焰", "穷苦", "割爱", "流离琐尾", "汗青头白", "停业", "枉费", "失身", "后继乏人", "潸然", "力不胜任", "回天乏术", "苦痛", "念兹在兹", "装殓", "疾苦", "街号巷哭", "人亡家破", "苦头", "漏尽钟鸣", "叩心泣血", "没世穷年", "孤舟独桨", "棘地荆天", "困处", "锐挫气索", "灾害", "岁月如流", "眷念", "魂销肠断", "入殓", "惋惜", "池鱼之祸", "雨散风流", "面目全非", "火中取栗", "捶胸顿足", "朝不虑夕", "愧悔无地", "连宵达旦", "九霄云外", "差点儿", "黄杨厄闰", "如丧考妣", "侯门似海", "心灰意冷", "目眢心忳", "惦挂", "魂牵梦萦", "分钗断带", "化为泡影", "兴叹", "挂念", "想望风采", "葬送", "啜菽饮水", "伤心惨目", "夭逝", "家破人离", "补救", "抚心自问", "没落", "亡可奈何", "烧毁", "草衣木食", "三长两短", "食不果腹", "铭心镂骨", "悲号", "铭记不忘", "慷慨悲歌", "鸾只凤单", "抢地呼天", "霞思云想", "急转直下", "愧疚", "负荆", "悲郁", "葬身", "落寞", "泣如雨下", "春露秋霜", "满目疮痍", "踣地呼天", "白首空归", "荒落", "寡妇死了儿－哭得好伤心", "千难万苦", "寥寂", "失时落势", "见羹见墙", "鹤困鸡群", "魂不负体", "泪水", "昌亭之客", "后悔", "靦颜人世", "铭心刻骨", "无辜", "毒物", "负疚", "悲凉", "质伛影曲", "堕溷飘茵", "自疚", "呜呼噫嘻", "赔礼", "逝者如斯", "千思万虑", "溘先朝露", "关门闭户", "鸿断鱼沈", "遭遇", "流徙", "为人作嫁", "泄劲", "热孝", "卖履分香", "艰危", "哀切", "首足异处", "梦幻泡影", "绝望", "哀嚎", "流落", "离索", "听天由命", "三旬九食", "病故", "数米而炊", "奔忙", "兵败将亡", "人地生疏", "牙周病", "体无完肤", "血癌", "咬口生姜喝口醋－忍着酸辣", "灰心短气", "七捞八攘", "望云之情", "力尽筋疲", "血流漂杵", "歉意", "痛心疾首", "牵衣肘见", "片甲不留", "乐昌破镜", "无家无室", "鸾孤凤只", "天壤王朗", "伶仃", "希冀", "毒瘤", "伶俜", "丁忧", "养子不成才－大失所望", "感今思昔", "哀艳", "噩耗", "后悔莫及", "忏悔", "前瞻后顾", "客死他乡", "火尽灰冷", "葬身鱼腹", "包赔", "祸及池鱼", "茕茕孑立，形影相吊", "一言半语", "愧痛", "朝生夕死", "心如刀剉", "灰飞烟灭", "飘籓坠溷"}
#恶
DUTIR_Wus = {"饰非遂过", "恶语", "毁害", "恶籍盈指", "脾气爆躁", "淫贱", "凌乱", "败德辱行", "隋珠弹雀", "自相矛盾", "过气", "垂涎三尺", "拈酸吃醋", "穷愁", "辱国丧师", "马后炮", "孤行一意", "习染", "蛋白质", "格格不纳", "雨霾风障", "停滞", "板板六十四", "悖入悖出", "霞思天想", "怨女旷夫", "文山会海", "落马", "十羊九牧", "冷谈", "井管拘墟", "妄语", "惹祸", "重婚", "驳回", "雨泣云愁", "狐群狗党", "声色犬马", "追根穷源", "罪在不赦", "德薄", "傲慢", "头会箕敛", "人心惟危", "现世", "话中有话", "簸弄", "怆然", "拆东补西", "数白论黄", "昏庸", "刳脂剔膏", "介意", "早退", "粗劣", "连篇累帙", "猥词", "马耳东风", "心术不正", "膏脣岐舌", "土崩鱼烂", "淫辞", "刻毒", "自由放任", "道边苦李", "严苛", "文不对题", "焚尸扬灰", "死无对证", "取悦", "荒谬", "嘴硬", "女巫", "野草闲花", "不韪", "无耻", "耍手段", "月露之体", "难驯服", "顾盼自雄", "无天於上，无地於下", "贵不期骄", "压良为贱", "蹦跶", "蚍蜉带盆", "狗仗人势", "鱼质龙文", "坍台", "蹩脚", "驽马恋栈", "疲劳", "杂糅", "请君入瓮", "浑俗和光", "投鼠忌器", "挑字眼儿", "侈糜", "疲惫", "乱坠天花", "诺诺连声", "楚囚对泣", "独行独断", "破家危国", "拥挤", "饰非养过", "拾人涕唾", "惺惺作态", "尾巴主义", "三十六策，走为上计", "漫无边际", "刚愎", "夹枪带棒", "赶尽杀绝", "狡兔死，良狗烹", "飞谋钓谤", "狂三诈四", "饭坑酒囊", "渔翁之利", "溽暑", "弊端", "解衣抱火", "一日万几", "却步", "贱人", "进退双难", "絮叨", "啰啰唆唆", "自是", "沉郁", "缠磨", "面墙而立", "迁延时日", "唠叨", "大腹便便", "鼓脑争头", "失慎", "油煎火燎", "含混", "倒灶", "倒爷", "佹形僪状", "精神不振", "恬不知羞", "攻其一点，不及其余", "罪莫大焉", "弄假成真", "攀龙附骥", "雕虫篆刻", "一偏", "争长论短", "来者不善", "忧心如捣", "狐埋狐搰", "惆怅", "咒骂", "疑团莫释", "吵嚷", "孤恩负德", "讳恶不悛", "无情无义", "招风揽火", "惯犯", "卖人情", "老古董", "没治", "装怯作勇", "佻巧", "枉辔学步", "偷税", "哄抬", "弃甲投戈", "花里胡哨", "坐误", "始作俑者", "言三语四", "天诛地灭", "言行不一", "华而不实", "溜号", "胡拉乱扯", "死有余责", "逐客令", "刮垢磨光", "犯难", "强凫变鹤", "苛杂", "瞒哄", "戒除", "东拼西凑", "贪如虎狼", "隐晦曲折", "冷峻", "串供", "雨淋日炙", "妖魔鬼怪", "老太太吃炒胡豆－咬牙切齿", "如狼牧羊", "缄口藏舌", "逢迎", "与时沉浮", "百口莫辩", "愚不可及", "缺陷", "窝主", "苛政", "寓公", "玩忽职守", "拒人千里", "飞贼", "鬻宠擅权", "抱头鼠窜", "稀碎", "祸水", "磕头碰脑", "大手大脚", "进退失据", "饫甘餍肥", "金本位制", "孤行几见", "倡情冶思", "矫枉过正", "残杀", "有眼如盲", "不看了了", "歪道", "暴内陵外", "见弹求鸮", "进退维谷", "鳄鱼眼泪", "乱套", "苞苴竿牍", "无下箸处", "诽谤", "强而后可", "奴性", "率然", "七拼八凑", "倚势挟权", "乌焉成马", "从犯", "担雪填河", "鱼龙曼衍", "备位充数", "呱嗒", "卖乖", "投膏止火", "轰堂大笑", "蠢货", "多一事不如省一事", "奸臣", "害人不浅", "不人道", "渊鱼丛爵", "党徒", "蠢事", "斗绝一隅", "非笑", "笼络", "疏阔", "打退堂鼓", "右军习气", "藏垢纳污", "目空一世", "论黄数白", "膏脣贩舌", "SJB", "心烦虑乱", "冒昧", "无休无了", "陋规", "行同狗彘", "烂污", "虚假", "迟延", "招是惹非", "张眉努眼", "囊中羞涩", "背恩忘义", "冶容诲淫", "爱博而情不专", "一知半解　", "替古人担忧", "杀风景", "小心眼", "顺口开河", "苟活", "脱漏", "主要矛盾", "气短", "腐败堕落", "少条失教", "酩酊大醉", "土豪劣绅", "穷困", "吃不上", "分星拨两", "文婪武嬉", "轻诺寡信", "井中视星", "老八辈子", "无动於衷", "抠唆", "离本徼末", "批缪", "仰攀", "猥陋", "千叮万嘱", "罗掘俱穷", "盲人摸象", "熬磨", "随声吠影", "驳难", "含糊其辞", "抛脸", "闹情绪", "宣扬", "人莫予毒", "没意思", "素口骂人", "闪烁其辞", "追欢买笑", "转斗千里", "长蛇封豕", "凑和", "屡次三番", "谄笑胁肩", "巴结", "拘礼", "疵品", "少见多怪", "焦渴", "鼠辈", "粗心", "拆散", "蹠犬噬尧", "低质", "盲目", "责有攸归", "东倒西歪", "黑白混淆", "降心顺俗", "胆小如豆", "浪酒閒茶", "浊骨凡胎", "见貌辨色", "怪话", "碎骨粉尸", "黄齑淡饭", "不识一丁", "鉴貌辨色", "训斥", "以指浇沸", "黄粱梦", "大缪不然", "呼天叫地", "扑朔迷离", "无可辩驳", "雾里看花", "质疑", "矫情", "酒甕饭囊", "暗事", "北辕适楚", "够受的", "硗薄", "坎井之蛙", "析交离亲", "信口雌黄", "闲言冷语", "指责", "俯仰由人", "哩溜歪斜", "苦闷", "助长", "课嘴撩牙", "足尺加二", "苦不唧", "紧巴", "卤莽灭裂", "没颠没倒", "多有微词", "糜烂", "救燎助薪", "非议", "绷着脸", "乘兴而来，败兴而归", "婢膝奴颜", "人不知，鬼不觉", "撩云拨雨", "媚外", "蠢话", "颓败", "屦贱踊贵", "套话", "蒿目时艰", "炫弄", "无耻之尤", "骨董", "悔之无及", "目中无人", "格不相入", "半涂而废", "重蹈覆辙", "老巢", "以蠡测海　", "找岔子", "安故重迁", "背义负信", "沾风惹草", "愁容", "这山望着那山高", "失记", "靖言庸回", "花花搭搭", "罪尤", "贼头鬼脑", "按部就班", "桑间之音", "抓破脸", "指斥", "卖身投靠", "零碎", "不顺心", "明修栈道，暗度陈仓", "装样子", "惹事招非", "荷荷", "臆测", "坏东西", "鸮鸟生翼", "豕突狼奔", "阻绝", "强食弱肉", "郁郁不乐", "榆木疙瘩", "迷头认影", "大骂", "鹘仑吞枣", "欺罔视听", "板着面孔", "拥篲救火", "墙高基下", "惑人耳目", "挥霍", "深仇宿怨", "捉弄", "腐朽", "横拖倒扯", "贵远鄙近", "老江湖", "不经之谈", "翻手云覆手雨", "招是生非", "寒蝉僵鸟", "脸皮厚", "讬于空言", "窝点", "松松垮垮", "问道于盲", "玉惨花愁", "偷东摸西", "模棱两可", "丧家之犬", "无名之师", "狗腿子", "大胆", "不巧", "招摇过市", "借刀杀人", "老朽", "恣心纵欲", "贪汙狼藉", "犯愁", "引类呼朋", "拐子", "差错", "败军之将", "愁惨", "管见", "半上落下", "妖雾", "深文傅会", "搓手顿足", "议论纷纷", "毛羽未丰", "穷阎漏屋", "怨天尤人", "得薄能鲜", "失事", "乳臭末干", "反唇相稽", "虚无飘渺", "昏昧", "醋劲", "膏脣拭舌", "龙蛇混杂", "毁弃", "重男轻女", "如狼似虎", "举一废百", "之乎者也", "进退惟咎", "屈从", "看不上眼", "跋涉", "东拉西扯", "转脸", "外侮", "目无馀子", "难说话", "瓦查尿溺", "牛头马面", "横眉冷目", "阴毒", "狼顾鸱张", "后果", "谈优务劣", "叫真儿", "隐晦", "使性谤气", "不成话", "痴心妄想", "因陋就寡", "心辣手狠", "披头散发", "阴魂不散", "众难群移", "乌压压", "流落风尘", "屏障", "沽誉买直", "秽行", "反革命", "管窥筐举", "欺天罔人", "神眉鬼眼", "拔葵去织", "视财如命", "无所不至", "根深蒂固", "白白", "爱之欲其生，恶之欲其死", "掳掠", "胁肩低首", "胡作胡为", "荏弱", "生硬", "厥词", "罪恶滔天", "逐宕失返", "没轻没重", "灰秃秃", "依流平进", "吵闹", "一掷百万", "凭陵", "银样镴枪头", "神志委靡", "目无下尘", "匿影藏形", "撅坑撅堑", "皮毛", "决疣溃痈", "悔之晚矣", "郁然", "索然无味", "摆架子", "傲视", "大国主义", "启人疑窦", "诡谲", "讹脱", "贼子乱臣", "望秋先零", "惹是生非", "裹乱", "颓势", "螳臂当车", "银样蜡枪头", "墨迹未干", "门户之见", "离奇", "流金烁石", "蠢如鹿豕", "凌侮", "蛊惑人心", "地方主义", "空虚", "弓影杯蛇", "指皁为白", "自相鱼肉", "土棍", "金貂换酒", "无毒不丈夫", "陈规陋习　", "蹙蹙靡骋", "窒息", "罪该万死", "动辄得咎", "望风而靡", "包藏奸心", "先天不足", "祸首", "劣中之劣", "精神病", "饰垢掩疵", "肆无忌惮", "下不了台", "行将就木", "目挑心招", "伺瑕抵蠙", "不义之财", "城狐社鼠", "同谋", "穷兵黩武", "狡猾", "各执一词", "畏缩不前", "匹夫", "沾沾自满", "追根寻底", "赔本", "僬侥", "连章累牍", "暗笑", "东奔西走", "作言造语", "斗鸡走狗", "跳踉", "不凉不酸", "焦虑", "找碴", "不识泰山", "郐下无讥", "见事生风", "最差", "栽赃", "半吊子", "断章取义", "蒙蔽", "污泥浊水", "丢人现眼", "寡闻少见", "一面之词", "为德不卒", "奇形怪状", "无地自容", "发牢骚", "虚掷光阴", "皮脸", "遮三瞒四", "愚傻", "生疑", "哄抢", "探头探脑", "显形", "情敌", "巧立名目", "同床异梦", "河门海口", "阿世取容", "沉疴", "矢口", "骑鹤上扬州", "冒功", "凌弱暴寡", "呜呼哀哉", "小崽子", "余桃啖君", "错误百出", "露骨", "六畜不安", "扫灭", "草芥", "上赶着", "挤对", "声色货利", "朋比为奸", "怪雨盲风", "曲直", "青蝇染白", "骗取", "饭桶", "轻忽", "饭来张口", "战云", "事端", "弄巧成拙", "怕事", "惹祸招灾", "不着边际", "市井小人", "卷土重来", "黔驴技孤", "胡说", "宴安鸩素毒", "晋惠闻蛙", "逞能", "窥伺", "现行犯", "耀武扬威", "摘句寻章", "酸不溜丢", "一纸空文", "守钱虏", "可乘之机", "察察为明", "未形之患", "忧患", "阴谋", "三头两面", "野性", "泰山鸿毛", "狗彘不若", "搜章擿句", "冷害", "内忧", "草率", "屠杀", "屡教不改", "橡茹藿歠", "豕窜狼逋", "横眉怒视", "自食其言", "浑噩", "无孔不入", "狂悖", "无精打彩", "咏月嘲风", "无故", "麻痹大意", "多此一举", "脏乱差", "横行逆施", "金屋藏娇", "指东说西", "多心", "八面玲珑", "狂奴故态", "狡赖", "尺寸之功", "喋喋不休", "弇陋", "合不来", "苍蝇药不死人－恶心", "魔王", "别有用心", "亡命", "独霸", "无知妄作", "置身事外", "手重", "一棍子打死", "笨手笨脚", "图财害命", "抄用", "随俗沉浮", "违心", "包打天下", "勾结", "寄人檐下", "套汇", "众说纷纭", "子虚乌有", "臭嘴", "于今为烈", "以白为黑", "抓乖弄俏", "可恨", "损公肥私", "山中无好汉，猢猻称霸王", "昭然若揭", "落花流水", "私情", "泥塑木雕", "虐待", "见风转篷", "棺材老板咬牙－恨不死人", "杼柚之空", "心眼儿", "任纵", "狐媚", "迫降", "敷衍塞责", "傲睨一世", "错认颜标", "痛击", "纰漏", "风餐露宿", "投阱下石", "泥古不化", "主观", "札手舞脚", "党邪丑1", "实证主义", "上无片瓦,下无插针之地", "卖乖弄俏", "瑕疵", "逐逐眈眈", "腹心之患", "磨洋工", "找事", "狂人", "言者谆谆，听者藐藐", "天翻地覆", "帏薄不修", "游骑无归", "狐鸣枭噪", "萎靡", "三般两样", "牵强附会", "掇弄", "路人皆知", "负才傲物", "贫嘴贱舌", "张牙舞爪", "枭蛇鬼怪", "屋下作屋", "拉三扯四", "苟且", "鼠牙雀角", "矜才使气", "委靡", "有头无尾", "闷倦", "进退唯谷", "启衅", "耳软心活", "拉拉杂杂", "垄断", "暗弱", "唯我独尊", "祸稔恶积", "抢嘴", "白丁俗客", "作嫁衣裳", "觊觎", "乱了营", "目不识丁", "送人情", "无聊", "莫辨楮叶", "打小算盘", "伍子胥过韶关－一夜愁白了头", "糊涂虫", "至死不悟", "暗淡", "惹草拈花", "冬箑夏裘", "刀光血影", "以汤止沸", "不恤", "不识大体", "搔头弄姿", "莫测高深", "刺激", "弃置", "狂蜂浪蝶", "抗尘走俗", "手无缚鸡之力", "贼巢", "侧足", "燥热", "强文浉醋", "疵点", "褪套儿", "游闲公子", "油滑", "牵就", "搜索肾胃", "为虎作张", "太公钓鱼，原者上钩", "草间求活", "抛头露面　", "狗偷鼠窃", "谬误", "不治之症", "得计", "果于自信", "陷身", "极重不反", "狡黠", "蓄谋", "花不棱登", "好戴高帽", "迷迷蒙蒙", "植党营私", "举措失当", "下三烂", "懒汉", "附骥", "粗重", "假球", "反裘伤皮", "血债累累", "忧心", "高鸟尽良弓藏", "狗彘不如", "借故", "闲花埜草", "不啻", "骨肉相残", "坠茵落溷", "二心两意", "雕镂藻绘", "万恶", "趁火打劫", "好自矜夸", "刁诈", "迂阔", "咎由自取", "侵凌", "降志辱身", "谢绝", "不胜其烦", "奸宄", "死求白赖", "见钱眼开", "分斤拨两", "原形毕露", "幼稚", "不知进退", "贪污犯", "稀里糊涂", "毒品", "旗号", "放毒", "拉关系", "报雠雪恨", "附影附声", "一簧两舌", "腥气", "剖腹藏珠", "问长问短", "伴食中书", "韩寿分香", "无所不为", "颠三倒四", "装佯", "掩鼻而过", "跋扈自恣", "老顽固", "我吐", "无耻之徒", "桀骜不逊", "私心", "鸠占鹊巢", "区闻陬见", "衅端", "岸然道貌", "圆谎", "神气活现", "歪歪扭扭", "另眼看待", "阔绰", "遗老遗少", "无功而禄", "冒名顶替", "啧有烦言", "朝不谋夕", "佛头著粪", "道听耳食", "傲睨自若", "忧形于色", "损上益下", "仇人", "鄙视", "见豕负涂", "颓丧", "泼悍", "悬驼就石", "敲冰求火", "污浊", "险恶", "土阶茅屋", "狂气", "抛头露面", "肥肠满脑", "败化伤风", "暴力行为", "锋芒毕露", "倒持泰阿", "焦脣敝舌", "天悬地隔", "破产", "心高气傲", "鄙薄", "摇头摆尾", "邪祟", "黑帮", "棒打鸳鸯", "不逞之徒", "官场", "说客", "萎靡不振", "油光水滑", "半疑半信", "反裘负刍", "丧权辱国", "为非作歹", "乖僻", "趋附", "幽忧", "朽木难彫", "吞声忍气", "称大", "招是搬非", "固执已见", "憾事", "搀兑", "羞与为伍", "虚张声势", "胡说八道", "受累", "备位充数　", "心胸狭隘", "中魔", "套购", "不冷不热", "油嘴花脣", "淫书", "粗率", "坏蛋", "强聒不舍", "哗世动俗", "喝倒彩", "傲一天和尚撞一天钟", "费工夫", "放浪江湖", "支吾其词", "斥骂", "悍然不顾", "狐鸣篝火", "罪过", "束手坐视", "抟沙嚼蜡", "含混不清", "帮闲", "萧索", "违强陵弱", "骄奢淫佚", "不稳平衡", "口不择言", "伺瑕导蠙", "负德孤恩", "将信将疑", "主犯", "闲言碎语", "转嫁", "疑心生暗鬼", "训诫", "入垄", "累卵", "进退两难", "徒托生言", "人祸", "一之谓甚", "鹊巢鸠居", "痴话", "怙恶不悛", "恶气", "忤逆", "数短论长", "无涵养", "淫秽", "违规", "物以类聚　", "疑团", "播穅眯目", "逃学", "刁恶", "人心浮动", "批颊", "斗而铸锥", "怂恿", "浪迹浮踪", "沽名卖直", "荒唐", "小家子气", "饱以老拳", "偏心眼", "尘嚣", "披毛求瑕", "黠棍", "拖拉", "死声活气", "戏剧化", "误场", "不坚定", "越扶越醉", "四平八稳", "邪魔外道", "同类相妒", "反感", "不道德", "好事", "自用则小", "查封", "私货", "拔本塞原", "驳杂", "恨入骨髓", "酒肉朋友", "憋得慌", "肉食者鄙", "焚花之论", "愚眉肉眼", "夙嫌", "淡饭黄齑", "嫌好道恶", "劫狱", "玉毁椟中", "瞎炮", "白日做梦", "摆样子", "歧视", "喝叱", "独夫", "急功近利", "欺哄", "灭口", "不共戴天", "私枭", "鬼计多端", "藏头露尾", "追脏", "冷语冰人", "毫不客气", "变节", "怨偶", "顽敌", "无背无侧", "拣佛烧香", "强辩", "诃佛诋巫", "露影藏形", "看轻", "浮滑", "理亏|", "隔屋撺椽", "浑头浑脑", "亡不旋跬", "白衣苍狗", "穿窬之盗", "虎头蛇尾", "无的放失", "应付", "被告", "越俎代庖", "不堪入目", "打扰", "蒙骗", "履丝曳缟", "懵懵懂懂", "自作孽", "郁郁", "强龙不压地头蛇", "预谋", "贪婪", "佞幸", "戕贼", "完蛋", "收揽", "叫化子过瘾－讨厌", "弹空说嘴", "心病", "冷箭", "左建外易", "任性", "天花乱坠", "党邪丑正", "冗赘", "曲意奉承", "想入非非", "浑浑沈沈", "连篇絫牍", "措大", "隔壁撺椽", "卖官鬻爵", "大错特错", "泄露天机", "久假不归", "纠合", "霸王", "奸佞", "空乏", "看不上", "如芒刺背", "没什么了不起", "赔帐", "同流合污", "欲望难填", "小恩小惠", "昏天暗地", "背信", "混噩", "为害", "陷入", "剜肉做疮", "不伏烧埋", "入寇", "毒贩", "讳莫如深", "头破血流", "桀骜难驯", "流气", "执迷不返", "怪形怪状", "瞎子摸象", "老油子", "拆台", "巧语花言", "愚蠢", "空泛", "心血来潮", "今朝有酒今朝醉", "三花脸", "独行其是", "束手就困", "猪头", "各抒已见", "蓄意", "游戏人世", "巧立名色", "迷离倘恍", "阻梗", "枯燥", "析律舞文", "诘屈磝碻", "一着不慎，满盘皆输", "哈巴狗", "语无诠次", "混水捞鱼", "欺天罔地", "凶狂", "丑角", "多嘴献浅", "谬种", "顾前不顾后", "疑神疑鬼", "七颠八倒", "食玉炊桂", "拿腔做势", "乱蓬蓬", "暴虐无道", "蝉腹龟肠", "闷沉沉", "规求元度", "粗枝大叶", "危害", "蜀犬吠日", "无情", "孤行已见", "暗昧之事", "偏见", "高阳酒徒", "极权", "渎神", "驴鸣狗吠", "灌夫骂坐", "未必", "低俗", "不足为据", "剜肉补疮", "魔爪", "落荒", "嫌怨", "辩驳", "胆大妄为", "乱臣贼子", "指天画他", "恶声恶气", "头痒搔跟", "庸医杀人", "恶恶实实", "过桥抽板", "遭罪", "期期艾艾", "老饕", "贪夫狥财", "祸在旦夕", "下作", "谎话", "骄侈暴佚", "弃好背盟", "痛斥", "用管窥天", "天下大乱", "猫噬鹦鹉", "庸庸碌碌", "贪贿", "白忙", "斗脣合舌", "超载", "屈打成招", "关门打狗", "谩藏诲盗", "铩羽", "骄纵", "渣滓", "妄想", "斜路", "望文生训", "吵吵", "指李推张", "分毫不值", "买笑追欢", "寡断", "鄙夷", "足不履影", "毛糙", "相判云泥", "已决犯", "迷金醉纸", "蚂蚁缘槐", "贿货公行", "胡诌乱扯", "送往劳来", "荒诞不经", "粗野", "固守", "进锐退速", "叛徒", "强求", "无赖", "河决鱼烂", "鸱目虎吻", "貌合行离", "磨烦", "谑而不虐", "股匪", "名不符实", "排场", "催迫", "血口", "明火执仗", "抱残守阙", "同床各梦", "耍花枪", "抉瑕摘釁", "歹徒", "冤死", "不好", "重负", "闹灾", "嗤笑", "浅斟低唱", "赃贿狼籍", "不务正业", "无证据", "偏疼", "说地谈天", "白日做梦－胡思乱想", "无所顾忌", "不透明", "好战", "搜根剔齿", "繁难", "惝恍", "措心积虑", "土鳖", "愚陋", "束手缚脚", "劝百讽一", "大开方便之门", "饮鸩解渴", "勾搭", "黄色音乐", "忌讳", "偏激", "背理", "令人讨厌", "先意承颜", "脚高步低", "怙终不悔", "私吞", "胡行乱为", "半疯儿", "不择手段", "招权纳赂", "无方之民", "鼓舌掀簧", "官僚主义", "劣马", "江山易改，秉性难移", "举步维艰", "拘文牵义", "豪绅", "劝降", "东扶西例", "落落穆穆", "铺张浪费", "避凉附炎", "阴鸷", "郁热", "捐本逐末", "嘴皮子", "束手自毙", "鱼目间珠", "难听", "卑鄙", "强占", "张口结舌", "貌似真实的", "躁动", "闹意见", "紧巴巴", "不自量", "牛角尖", "放辟邪侈", "有名无实", "得寸进尺", "辱门败户", "挖墙脚", "挢抂过正", "散毒", "东家效颦", "瓮牖绳枢", "集矢之的", "喜怒无常", "违背", "老鼠过街,人人喊打", "涩滞", "胡搅蛮缠", "乌七八糟", "轻易", "无独有偶", "绷脸", "大意", "沐猴衣冠", "鬻驽窃价", "拙口钝腮", "一文不值", "馋鬼", "牵掣", "坑蒙", "彫虫篆刻", "狂顶", "秋荼密网", "引狗入寨", "顽梗", "拉不下脸来", "摆款儿", "找茬", "保不住", "耍滑头", "二五眼", "偏信则暗", "孤傲", "听任", "瓮里醯鸡", "要命", "偏偏", "贫嘴滑舌", "结结巴巴", "毒犯", "割据", "迷惘", "骄佚奢淫", "狂恣", "肆言詈辱", "望风而逃", "魔头", "鼻孔辽天", "八面光", "说风凉话", "胆小如鼷", "不知天高地厚", "鸡飞狗叫", "幽囚", "闲神野鬼", "兀傲", "攀附", "忧心悄悄", "食而不化", "败类", "多余", "微文深诋", "阴影", "臧否人物", "圈拢", "焚林竭泽", "一丝不挂", "心口不一", "罪名", "翻悔", "受罪", "泥古非今", "凌辱", "庞然大物", "不辨龙蛇", "抄袭", "嗤之以鼻", "过错", "贪夫殉财", "自炫", "怨言", "分赃", "恶作剧", "崽子", "偏狭", "等外", "漆身吞炭", "诡衔窃辔", "矜功自伐", "野人", "谬种流传", "阿谀取容", "慢腾腾", "隐患", "缘木求鱼", "私党", "四体不勤，五谷不分", "阶段分化", "不耕而食，不蚕而衣", "无稽之谈", "不洁", "狼烟大话", "愁闷", "三从四德", "喧天", "哭笑不得", "告密", "曲解", "枪替", "曲意迎合", "依附", "令人恶心", "短气", "荒漠", "流弊", "周章", "闹闹哄哄", "不足为外人道", "志广才疏", "轻狂", "见异思迁", "为渊驱鱼，为丛驱爵", "乱虐并生", "枉矫过激", "头上著头", "若隐若现", "依赖", "口如悬河", "霸持", "崎岖不平", "犹犹豫豫", "世弊", "干名采誉", "说三道四", "以意为之", "逼良为娼", "自言自语", "唾骂", "偷嘴", "依仗", "一钱不值", "诱使", "啰里啰唆", "横挑鼻子竖挑眼", "歹心", "低微", "好不容易", "因循守旧", "独断专行", "疑虑", "神经", "抨弹", "俗不可医", "半信半疑", "贪多务得", "余毒", "捉班做势", "聒耳", "孤行己见", "酸臭", "孤高自诩", "装神弄鬼", "消极浪漫主义", "雷声大雨点小", "杆子", "微贱", "喽罗", "形同路人", "漠不相关", "以耳代目", "不成器", "欺公罔法", "吝惜", "明抢暗偷", "冷冷", "空论", "众口难调", "地狱变相", "矫情造作", "抵罪", "强梁", "惯匪", "任其自便", "粗制滥造", "逃避", "贬斥", "屈枉", "弄鬼妆幺", "知其一，不知其二", "耍弄", "植党自私", "岂有此理", "草薙禽狝", "不问青红皂白", "私通", "无实效", "唱筹量沙", "调嘴弄舌", "看风使舵", "自以为是", "偏差", "危机", "痞子", "跳梁小丑", "贼窝", "同恶相恤", "尸位误国", "耍嘴皮子", "傻头傻脑", "名誉扫地", "头疼", "黑市", "谄笑", "覆雨翻云", "得过且过", "凿空之论", "买通", "门外汉", "蠢材", "袍笏登场", "杂种", "惟我独尊", "感情用事", "无功受禄", "倔头强脑", "刻薄", "燠热", "缺乏幽默", "怙顽不悛", "利令志惛", "禽息鸟视", "抑制", "不分皂白", "隔靴爬痒", "不在其位，不谋其政", "忘乎其形", "携贰", "情面", "以力服人", "不过尔尔", "文化大革命", "轻薄无知", "化公为私", "切齿腐心", "朽迈", "委琐", "讳疾忌医", "倚势凌人", "逆产", "白发千丈", "保残守缺", "不是", "张冠李戴", "大民族主义", "太随便", "钓名沽誉", "傲世轻物", "食古如鲠", "说白道绿", "捉生替死", "劳民费财", "顺手牵羊", "闹性子", "模模糊糊", "死乞白赖", "禁锢", "走马看花", "花腔", "土龙刍狗", "杜口木舌", "歉然", "不怀好意", "不清不楚", "千头百绪", "腻人", "怨声载道", "脏话", "马瘦毛长", "腥膻", "放僻邪侈", "厚古薄今", "唯唯诺诺", "秽语", "狗急跳墙", "黎丘丈人", "岂非", "胆小怕事", "罪大恶极", "违宪", "不雅", "盲人扪烛", "釁稔恶盈", "争权夺利", "憋屈", "焦脣乾舌", "疑窦", "煨乾避湿", "敷衍搪塞", "就着猪肉吃油条－腻透了", "有闻必录", "不拔一毛", "怄气", "吃心", "徙宅忘妻", "肋脦", "称王称霸", "对牛鼓簧", "代越庖俎", "白日见鬼", "老牛破车", "添醋加油", "死脑筋", "亟疾苛察", "紧张", "引颈受戮", "拨弄", "文痞", "不咸不淡", "奸滑", "喜新厌旧", "削木为吏", "吕武操莽", "凝滞", "余子碌碌", "清算", "压制", "营私罔利", "俾昼作夜", "溢言虚美", "上刑", "长夜难明", "没精打采", "罪恶", "鱼龙曼延", "没头没脸", "简陋", "消损白日", "不分青白", "阻塞", "角户分门", "朽木粪墙", "吹箫乞食", "龟玉毁椟", "松垮", "互相推诿", "RY", "戕害", "呆怔", "绵力薄材", "路柳墙花", "弱肉强食", "痛恨", "搜肠刮肚", "迷魂夺魄", "堆砌", "上慢下暴", "诪张变眩", "弄眉挤眼", "矮人看场", "令人费解", "辱没", "乱纷纷", "投石下井", "抬杠", "发痴", "妄为", "强硬", "栽跟头", "胡子拉碴", "冷若冰霜", "闹架", "枉道事人", "私娼", "连篇絫幅", "玄而又玄", "侵犯", "窄狭", "偎红倚翠", "打死老虎", "死于非命", "以指挠沸", "刿鉥肝肾", "扭曲", "干瞪眼", "挑牙料脣", "不分青红皂白", "半半拉拉", "迟迟", "百里之才", "软骨头", "蛮横无理", "冤苦", "辣手", "揶揄", "异端", "河水不犯井水", "十恶不赦", "不同戴天", "天地诛灭", "视同秦越", "邯郸匍匐", "狐朋狗友", "凶相毕露", "味同嚼蜡", "因公行私", "虚诈", "使坏", "土皇帝", "侵略战争", "迷迷荡荡", "野马无缰", "分情破爱", "酷热", "狗盗鸡啼", "神经过敏", "龙鬼蛇神", "话长说短", "徒劳", "愚昧", "一味", "数黄道黑", "莫此为甚", "祝不胜诅", "粗疏", "凶手", "人欲横流", "挹斗扬箕", "失算", "鱼龙混杂", "老蚕作茧", "狐虎之威", "向火乞儿", "斗方名士", "下水", "不渝", "顾头不顾尾", "指亲托故", "鼠凭社贵", "不可救药", "赤身露体", "傲睨得志", "破费", "截趾適履", "不当", "惨绝人寰", "骑上扬州鹤", "蓬乱", "丢三拉四", "不晓世务", "缺心眼", "沧海一粟", "张扬", "膀阔腰圆", "海阔天高", "冤抑", "嗒丧", "贪吏猾胥", "孽障", "街谈巷议", "油乎乎", "故弄玄虚", "黑哨", "散言碎语", "半间不界", "功成骨枯", "积重难返", "羊狠狼贪", "哗众取宠", "发狂", "离间", "兴风作浪", "回寒倒冷", "悠忽", "燋金烁石", "摆普儿", "窄小", "横三竖四", "妒羡", "跳梁", "牵连", "花招", "民生凋敝", "瘦弱", "狼吃幞头", "贼臣逆子", "不衫不履", "橛守成规", "愣头儿青", "不定", "欺生", "兽行", "劣根性", "乱臣", "缠绵悱恻", "鼓脣摇舌", "疲乏", "味如嚼蜡", "面有难色", "花哨", "溜门", "逐名趋势", "足不窥户", "左道旁门", "雕虫小事", "多情善感", "移天易日", "怒喝", "蜕化变质", "如丘而止", "闷气", "旷费", "道貌岸然", "重沓", "谨小慎微", "背本趋末", "怨气", "睁眼瞎子", "深闭固拒", "问号", "打鸡骂狗", "骚动", "足高气扬", "附凤攀龙", "黠慧", "优柔", "阔少", "脚踏两只船", "失手", "不避斧钺", "撒泼", "奚落", "混混沌沌", "狰狞", "奸猾", "人云亦云", "炮舰外交", "冒失", "帷薄不修", "凹凸不平", "黩武穷兵", "忘其所以", "东偷西摸", "断烂朝报", "无助", "一叶蔽目，不见泰山", "没皮没脸", "三六九等", "叫真", "闭眼睛捉麻雀", "官僚", "阿意取容", "斗殴", "勾通", "视如土芥", "声名狼藉", "煽风点火", "心绪不宁", "紊乱", "毫无价值", "贿赂", "坏处", "鼠腹蜗肠", "拉帮结派", "败俗伤风", "名义上", "分文不值", "朝令夕改", "焦愁", "人情世故", "暧暧", "偷合苟从", "扫兴", "抱薪救焚", "取笑", "歧路亡羊", "差误", "斤斤", "冠履倒易", "谋反", "乞讨", "西风", "人心似铁", "肆言如狂", "龙多乃旱", "独断独行", "将无作有", "黑道", "智者见智，仁者见仁", "倒运", "靡靡之乐", "业障", "臭肉来蝇", "歪缠", "茫茫然", "节外生枝", "流里流气", "大杂烩", "舞文饰智", "背信弃义", "一把死拿", "耍贫嘴", "老谋深算", "好色之徒", "狼顾鸱跱", "眩惑", "观望不前", "中伤", "亡命之徒", "怪癖", "百约百叛", "投其所好", "燋头烂额", "花心", "心不应口", "扯白", "谗言", "谗口嗷嗷", "五谷不分", "手段", "应接不暇", "潮乎乎", "转战千里", "有口难言", "彪壮", "富贵骄人", "平毁", "贻误", "软磨", "保不定", "愚暗", "歧途", "进退维亟", "谩上不谩下", "落魄", "火上加油", "不攻自破", "狐媚魇道", "没受过教育", "问诸水滨", "蠢人", "魑魅", "捏把汗", "鼹腹易盈", "事大主义", "评理", "鲁斤燕削", "瑕玷", "兵连祸结", "老大难", "惟利是趋", "下等", "阶级异己分子", "遇事生风", "无妄之灾", "败子", "杂凑", "书生之见", "招是揽非", "怅惘", "鬼魅", "叱责", "闻风远扬", "当面鼓，对面锣", "幌子", "杀人越货", "挖苦", "酒鬼", "瓦影龟鱼", "妖言", "讨厌", "头痛医头，脚痛医脚", "怀才之遇", "图谋", "烦乱", "奉承", "犯罪", "株连", "夹生", "等因奉此", "一国三公", "戒条", "逐近弃远", "挟长挟贵", "戛釜撞甕", "脱班", "轻浮", "高车驷马", "随遇而安", "静言庸违", "晦涩", "贵远贱近", "遗臭万年", "闷闷不乐", "假相", "虚骄恃气", "欺蒙", "引起反感", "贸首之雠", "堂皇冠冕", "脏乎乎", "暴利", "狼吞虎咽", "望空捉影", "束手无术", "呆子", "恩将仇报", "暗无天日", "罄竹难书", "只顾自身利益", "不识不知", "憋着一肚子气", "骄蹇", "踵接肩摩", "泥腿", "不识局面", "昏沉", "莽撞", "狗尾貂续", "钩心斗角", "搀和", "龌龊", "偏向", "坑害", "自视", "专制", "横科暴敛", "衒玉贾石", "海盗", "爱财如命", "疯了", "妖媚", "三翻四覆", "弟子孩儿", "奇想天开", "空疏", "抱屈", "半身不遂", "辣词儿", "入室操戈", "无风作浪", "仇隙", "乱来", "神权", "叨教", "逆天暴物", "目无法纪", "矜功伐能", "揭破", "撒野", "西化", "浪蝶游蜂", "寸指测渊", "揭底", "各从其志", "横冲直闯", "低能", "无计可施", "杞人忧天", "讨好", "瓮天蠡海", "群氓", "作法自毙", "阴湿", "受辱", "斗筲", "偏僻", "衰颓", "蓬户瓮牖", "蔽塞", "芜劣", "日月无光", "八面圆通", "私见", "噬脐莫及", "隐讳", "满脸横肉", "依草附木", "驳斥", "熟视无睹", "跅弢不羁", "不自量力", "予取予求", "土牛木马", "倔强倨傲", "狼吞虎噬", "挟权倚势", "奢华", "腹有鳞甲", "新愁旧恨", "开了锁的猴子－得意忘形", "笼络人心", "飞谋荐谤", "攀鳞附翼", "跑肚", "无所施其技", "繁文缛节　", "消极防御", "三分鼎足", "首恶", "卖嘴", "忽悠", "如意算盘", "外道", "低级", "猬辞", "差事", "不问皁白", "仙山琼阁", "拔了萝卜地皮宽", "黑地昏天", "损失", "狗拿耗子", "乱腾腾", "失之毫釐，差之千里", "凌轹", "狎昵", "敲门砖", "好高鹜远", "枯燥无味", "调三窝四", "骄生惯养", "狂妄", "掩饰", "冥室椟棺", "削足适履", "残虐", "罪恶如山", "各人自扫门前雪，莫管他人瓦上霜", "施暴", "推委", "夺人所好", "数米而炊", "聚敛无厌", "怀恨在心", "指鸡骂狗", "七手八脚", "毒化", "土壤细流", "抠字眼儿", "鬼头滑脑", "不过", "诬蔑", "茹柔吐刚", "烈火烹油", "合眼摸象", "诬罔", "屯毛不辨", "巧言如簧", "游手好闲", "小人", "指手画脚", "懊恼", "伪君子", "指雁为羹", "两头和番", "嗜血", "袭人故智", "皮里春秋", "以升量石", "不直一文", "千夫所指", "逍遥法外", "现话", "小题大做", "朝梁暮周", "擅权", "弥天大谎", "焚书坑儒", "连篇累幅", "深文巧诋", "空洞无聊", "惨无人道", "穷棒子", "恚恨", "失脚", "酷刑", "恶意", "艰难", "高不輳低不就", "歪风邪气", "强词夺理", "有文无行", "玄虚", "毁伤", "违天悖人", "劣势", "小家子相", "严重", "窥间伺隙", "毒泷恶雾", "守旧", "仗势", "名重识暗", "醉舞狂歌", "不起眼", "偷偷", "裙带", "醴酒不设", "离弃", "走狗", "谣言", "蓬散", "惯纵", "蟊贼", "进退无途", "咬牙恨齿", "何足为奇", "耳视目食", "孬种", "枘凿方圆", "霸道横行", "恋酒贪花", "披麻救火", "鱼烂土崩", "喋血", "开心", "损人利己", "帮倒忙", "大打出手", "嘴快", "怪里怪气", "偷盗", "冤有头，债有主", "冷板凳", "逛荡", "怨望", "舌剑唇枪", "斗气", "不值一哂", "倚强凌弱", "鼠窃狗盗", "白华之怨", "及时行乐", "假门假氏", "不相闻问杜门谢客", "劳役", "困顿", "官情纸薄", "变性", "差池", "闲磕牙", "挢揉造作", "言不由衷", "闭门造车", "陈套", "朋比作奸", "据高临下", "昂头天外", "褫其华衮，示人本相", "枉尺直寻", "鬼吒狼嚎", "细瘦", "死有余僇", "遁天妄行", "繁琐", "迟钝", "愁怀", "蔽美扬恶", "道德败坏", "打马虎眼", "视为寇雠", "找碴儿", "乞降", "徒然", "顺我者生，逆我者死", "经纬万端", "浅学", "钩深图远", "任人宰割", "吞声饮泣", "装门面", "问柳评花", "追欢作乐", "认死理儿", "花言巧语", "远水不解近渴", "威迫利诱", "妄言", "攻讦", "横无忌惮", "谄媚", "一暴十寒", "盗猎", "鲁鱼帝虎", "投隙抵巇", "寝关曝纊", "不劣方头", "昏头昏脑", "上赶", "彷徨", "不速之客", "赃汙狼藉", "不稼不穑", "窑子", "遂迷不寤", "土鸡瓦犬", "桀骜", "拉拉扯扯", "淫言狎语", "落水狗", "舛误", "弛缓", "发疯", "饥附饱扬", "无所作为", "以蠡测海", "追根究蒂", "毒草", "讥诮", "不辞而别", "饮鸩止渴", "虚谈高议", "衅发萧墙", "以火救火", "疯狂", "硬生生", "公报私仇", "不毛之地", "摇头幌脑", "背盟败约", "群居终日，盲不及义", "牛头不对马嘴", "不道", "切齿痛恨", "卸责", "鬻声钓世", "勒派", "损人", "离心离德", "大逆无道", "油腻", "败兴", "淡而无味", "犹豫不决", "靡衣偷食", "肮里肮脏", "穷途潦倒", "纲纪废弛", "金融寡头", "靡靡之音", "呆板", "骄横", "衣冠禽兽", "假意", "骄慢", "嫉贤傲士", "开锣喝道", "懵里懵懂", "无孔不钻", "横财", "遗弃", "胡来", "恶臭", "郑人买履", "有眼无瞳", "不甘", "模糊", "昏聩", "率兽食人", "外遇", "鼓舌", "心烦", "牛鬼蛇神", "借端", "蒙哄", "欺公误国", "羊质虎皮", "贼喊捉贼", "负薪救火", "道西说东", "忧虑", "赃私狼籍", "困惑", "沆瀣一气", "迷离徜恍", "推波作浪", "现钟不打", "夹棍", "你死我活", "磨折", "惊群动众", "惶惑", "浓烈", "杀伤", "傲贤慢士", "急急巴巴", "独霸一方", "推枯折腐", "松散", "误事", "费劲", "艰难险阻", "一无是处", "失窃", "逃税", "江淹梦笔", "心猿意马", "溃兵游勇", "花枪", "浅见寡闻", "明知故问", "穷寇", "呆头呆脑", "杀鸡取卵", "伏低做小", "谋陷", "只看见树木，不看见森林", "睥睨", "漫天要价", "漏税", "腾云驾雾", "彫虫小技", "活罪", "婆婆妈妈", "厌气", "插嘴", "越权", "颠覆", "恣行无忌", "横徵暴敛", "草木愚夫", "诈奸不及", "吃不来", "恣纵", "余孽", "跋前疐后", "无纪律", "下风", "幽愤", "玩弄", "非难", "不见得", "羊肠小道", "意马心猿", "张大其事", "上钩", "南郭处士", "窝赃", "俗气", "衣来伸手，饭来张口", "腹诽心谤", "凡才浅识", "浮皮潦草", "暴烈", "人间地狱", "偷梁换柱", "瞎胡闹", "见风使船", "雕虫小技", "空洞无物", "唯吾独尊", "恣意妄为", "认头", "江山好改，本性难移", "死气白赖", "不满", "逆来顺受", "攻击", "死气沉沉", "HJ", "鸡肋", "田里的蚯蚓－满肚疑", "无任之禄", "陪衬", "问柳寻花", "皮囊", "异味", "乱首垢面", "扰乱", "不以为耻", "差之毫氂，失之千里", "瓦全", "鬼魅伎俩", "狼突豕窜", "凶残", "河东狮吼", "诡诈", "权门", "出毛病", "徒乱人意", "买上嘱下", "骗人", "凡夫俗子", "狗行狼心", "设心处虑", "愁眉不展", "喧噪", "适得其反", "不识人间有羞耻事", "怕痛怕痒", "自高其功", "大吆小喝", "坐视成败", "佞笑", "负义忘恩", "阻碍", "拗口", "夹生饭", "委罪", "杀人放火", "长安少年", "送去迎来", "方枘圆凿", "狐假虎咸", "没劲", "盗印", "本末倒置", "讬诸空言", "放泼撒豪", "胡枝扯叶", "赃污狼籍", "酒色财气", "和稀泥", "皮笑肉不笑", "东捞西摸", "厌恶", "侵越", "无效", "知法犯法", "严厉", "荼毒", "楞手楞脚", "窃位素餐", "反复无常", "不打自招", "暴君政治", "弹丸之地", "后台", "姑息养奸", "柔茹寡断", "欺压", "几不欲生", "衒玉求售", "跌跤", "迂夫子", "千人所指", "多虑", "以偏概全", "兽心人面", "空中楼阁", "千夫诺诺，不如一士谔谔", "弦外之音", "投畀豺虎", "明争暗斗", "厌世", "令人生厌", "待兔守株", "大不了", "变质", "浮华", "东抄西袭", "刁赖", "因袭陈规", "花拳绣腿", "迷花沾草", "空文", "进退为难", "论长道短", "没查没利", "舐皮论骨", "声气相通", "身单力薄", "跋扈飞扬", "揭箧担囊", "微不足道", "照猫画虎", "青蝇点璧", "烦心", "好笑", "挑三拨四", "纳贿", "一鳞半爪", "磨磨蹭蹭", "众寡悬殊", "懦弱", "罢官", "过时", "朽腐", "狗口里生不出象牙", "极武穷兵", "天昏地黑", "无足重轻", "咬人狗儿不露齿", "冰炭", "粗话", "夙仇", "兔角牛翼", "厚味腊毒", "声色贷利", "令人窒息", "贪而无信", "狐疑", "气盛", "昏头转向", "看人眉睫", "摧残", "受过", "贫苦", "愁眉苦脸", "精神溜号", "流窜", "望风而遁", "起绉", "满腹狐疑", "架谎凿空", "烟幕", "模糊不清", "冷冰冰", "博而不精", "老相", "奴才", "背思忘义", "要面子", "非礼", "贪声逐色", "沉痼", "郁气", "卑鄙无耻", "酸刻", "买爵贩官", "枉墨矫绳", "及宾有鱼", "舍近即远", "横拦竖挡", "赃秽狼藉", "狡滑", "拜物教", "艳情", "束缚", "狗续金貂", "驴唇不对马嘴", "视同陌路", "明来暗往", "偏失", "孤豚腐鼠", "谋财害命", "邋里邋遢", "崎岖", "心狠手毒", "兜售", "造谣", "敲骨剥髓", "寸量铢称", "一己之私", "不孝", "灯红酒绿", "失道寡助", "狗尾续貂", "游戏人间", "调停两用", "土豪", "狗屁不通", "刺儿话", "悍妇", "束手旁观", "糟瘟", "深恶痛绝", "娇痴", "闭门羹", "款学寡闻", "乡利倍义", "不见棺材不落泪", "刿心鉥肾", "居功自傲", "顽皮", "丑陋", "死样活气", "豺狼", "纠集", "脏污", "傻叉", "事务主义", "骑鹤维扬", "掉三寸舌", "挂名", "爬行", "蜂目豺声", "漠视", "亡猿灾木", "浮笔浪墨", "枭心鹤貌", "涣散", "头痛治头，足痛治足", "吞声饮气", "不怎么样", "涉世不深", "娼妇", "投隙抵罅", "固执", "诅骂", "淆惑视听", "卖俏迎奸", "烦言", "背约", "流寇主义", "乌云", "放荡不羁", "詹言曲说", "自诩", "重厚少文", "逼不得已", "恭维", "欺软怕硬", "死有余辜", "谎报", "史弟阋于墙", "村学究语", "吃不住", "鲁莽灭裂", "咄咄书空", "水火不相容", "滥调", "闯祸", "短针攻疽", "短浅", "天下本无事，庸人自扰之", "怨恨", "叠床架屋", "贵壮贱弱", "私了", "肆扰", "各持己见", "令人厌恶", "水至清则无鱼", "明推暗就", "走过场", "郑人争年", "剜肉医疮", "不廉", "虚诳", "束之高阁", "惟利是图", "狭窄", "千思万想", "絮语", "难闻", "疑虑重重", "不知轻重", "推卸", "雾鳞云爪", "失言", "低档", "搪塞", "耍花招", "泼剌", "慢慢吞吞", "因陋守旧", "有限如盲", "粗暴", "杜口结舌", "道微德薄", "利令智昏", "虚浮", "抱蔓摘瓜", "跑辙", "贪欲无艺", "整冠纳履", "求全责备", "非刑", "飞流短长", "举鼎绝膑", "先入之见", "病房", "冥顽不化", "贪欢逐乐", "榆木脑袋", "鄙吝复萌", "追根查源", "面从腹诽", "私图", "贼头鼠脑", "假冒", "蜗名微利", "偷摸", "抉目悬门", "一言堂", "格於成例", "鼠肝虫臂", "酒食征逐　", "喜新厌故", "昧己瞒心", "乱哄哄", "贫嘴恶舌", "暗送秋波", "亏待", "逾墙钻蠙", "谷贱伤农", "行奸卖俏", "败国丧家", "杀生", "爱则加诸膝，恶则坠诸渊", "鸡零狗碎", "鼠心狼肺", "装点门面", "世事纷扰", "_ass", "欲壑难填", "冷笑", "摆门面", "薄唇轻言", "冒牌", "弄鬼掉猴", "祖龙之虐", "江山易改，禀性难移", "文人相轻", "拖人落水", "历历落落", "附骥尾", "喧宾夺主", "好自为之", "学步邯郸", "贪赃枉法", "没有礼貌", "错处", "炽燥", "焚薮而田", "怨尤", "肆意妄为", "拍马", "眼不见，心不烦", "夫子", "赖皮", "扶东倒西", "怒叱", "随俗浮沈", "滴里嘟噜", "饰智矜愚", "犯戒", "怪诞不经", "难以沟通", "逼迫", "黔驴技穷", "唉声叹气", "放火", "拖累", "粗莽", "作浪兴风", "项背相望", "投鼠之忌", "不经之说", "病恹恹", "无补", "低眉折腰", "死地", "无方", "倚门傍户", "捏造", "帝国主义", "钩章棘句", "买静求安", "奇离古怪", "倚财仗势", "孤陋寡闻", "厌腻", "含含混混", "徒读父书", "以眼还眼，以牙还牙", "泥名失实", "傲睨万物", "骄奢淫泆", "乏味", "肮脏", "厄运", "欺人之谈", "侏儒观戏", "逃跑", "兔死犬饥", "视如寇仇", "骄奢放逸", "侵扰", "枉费心机", "三反四覆", "啰啰嗦嗦", "什么的", "龙生九子", "三言讹虎", "做假", "乌龟", "酒地花天", "妒火", "闹笑话", "众盲摸象", "没里没外", "蛊惑", "损人益己", "疏忽", "雕心雁爪", "狰狞面目", "地方民族主义", "偎慵堕懒", "颠倒黑白", "失节", "忐忑", "通风报讯", "动作迟顿", "奢侈", "醉酒妇人", "风雨如晦", "凶蛮", "据为己有", "昏暗", "插脚", "掐尖落钞", "树同拔异", "捉风捕影", "盗劫", "班门弄斧", "发腻", "同伙", "已意逆志", "忽视", "迷失", "可鄙", "土鸡瓦狗", "娇惯", "含血潠人", "没见过世面", "分文不直", "泼妇", "顽皮赖肉", "予取予夺", "不公", "詈夷为跖", "搬唇递舌", "借口", "老气横秋", "有心眼", "公敌", "取闹", "争斗", "魔鬼", "自卖自夸", "下品", "无钱吃酒，妒人面赤", "卖狗皮膏药", "捉风捕月", "傲慢少礼", "愚拙", "愚痴", "懒虫", "混混噩噩", "溃败", "枯涩", "软禁", "毛毛躁躁", "东猎西渔", "退步", "油嘴", "惯家", "隔皮断货", "衡阳雁断", "昏昏欲睡", "狠命", "郁悒", "挑茶斡刺", "封豨修蛇", "杀戮", "独断", "见异思迂", "见事风生", "任情", "貌是情非", "独立王国", "威吓", "闲荡", "蓬头垢面", "器小易盈", "充斥", "勉强", "骄气", "度量小", "浇淳散朴", "入主出奴", "不可教训", "吐珠於泽，谁能不含", "视如粪土", "狭小", "拙劣", "同气相求", "狗傍人势", "迷糊", "尺布斗栗", "搬口弄舌", "芟荑", "神魂颠倒", "惘然若失", "眉目不清", "虚费词说", "衣架饭囊", "回光反照", "落荒而逃", "含血噀人", "私刑", "薄情", "造谤生事", "巧言令色", "叱问", "以售其奸", "刁滑", "未知万一", "狗党狐群", "不知所云", "计功谋利", "一窍不通", "支使", "好行小慧", "牟利", "作弊", "阿Q", "挟冤记仇", "愚氓", "出逃", "头眩目昏", "照本宣科", "过河拆桥", "无计所奈", "遂非文过", "儿女情长", "败材伤锦", "贯盈恶稔", "和事老", "显摆", "不详", "焦脣乾肺", "叱骂", "所费不赀", "暮翠朝红", "油头滑脸", "横行直撞", "一塌糊涂", "拉后腿", "周规折矩", "掩耳偷铃", "忧心如薰", "勇而无谋", "恶煞煞", "急公好义", "耸人听闻", "怪罪", "过桥拆桥", "恣肆", "贪名逐利", "傲岸", "无所不用其极", "万马齐喑", "阿时趋俗", "放饭流歠", "怠慢", "猫哭老鼠", "半途而废", "覆辙", "神奸巨猾", "嘴敞", "木石心肠", "鹰犬", "虚应故事", "痞棍", "妨功害能", "随俗沈浮", "妄图", "私窝子", "鹰鼻鹞眼", "高不成低不就", "糖衣炮弹", "嘻皮涎脸", "唾面自干", "夸大", "寡言少语", "恶棍", "灰沉沉", "天高皇帝远", "搬弄是非", "红眼病", "老生常谈", "凛如霜雪", "三灾八难", "紧行无好步", "豺狼横道", "效率很差", "烦琐", "敲膏吸髓", "学识浅薄", "坐吃山空", "怜新厌旧", "叵测", "差之毫釐，谬以千里", "不敷", "拈酸泼醋", "焦眉愁眼", "江湖骗子", "空洞洞", "挟细拿粗", "绕圈子", "招风惹雨", "性情急躁", "不成样子", "没头没脑", "饱食终日", "索垢寻疵", "斗嘴", "臭哄哄", "添乱", "下贱", "自作自受", "惹是非", "图作不轨", "蹊田夺牛", "南郭先生", "多端寡要", "被发文身", "赏罚不信", "当道", "残损", "闲话", "戳脊梁骨", "蔑称", "诟骂", "不测之罪", "吵架", "潦草", "逐流忘返", "淘气", "鸡犬昇天", "小子", "勒逼", "同恶相济", "篡位", "贪婪无厌", "芜鄙", "风鬟雨鬓", "傻里瓜唧", "小肚鸡肠", "本性难移", "呆住", "教唆犯", "郎当", "坐立不安", "错会", "重活", "散乱", "JR", "欺人", "朝歌暮弦", "看财奴", "钟鸣鼎食", "蒙昧", "鱼肉百姓", "暗箭", "阳奉阴违", "炫惑", "指山说磨", "不死不活", "凌上虐下", "蒙事", "一个心眼", "课语讹言", "高视阔步", "肥头大耳", "贸贸然", "左右两难", "倒戈卸甲", "大吹大擂", "吸血鬼", "昏愦", "呆若木鸡", "打情骂俏", "阻隔", "瞧不上", "封豕长蛇", "见风使舵", "索贿", "有天无日", "足高气强", "愚弄", "无能", "吃老本", "鲸吞蛇噬", "拔本塞源", "行径", "光棍", "讪笑", "弄神弄鬼", "党棍", "相持不下", "望洋而叹", "干号", "沉溺", "贪欲无厌", "黑枪", "以水救水", "傲头傲脑", "苟安", "小算盘", "柱小倾大", "乱离", "郁积", "不了", "老好人", "方底圆盖", "搔首弄姿", "杀妻求将", "尴尬", "方巾气", "玩兵黩武", "阴阳怪气", "心烦意冗", "东敲西逼", "离愁", "歹毒", "贫穷", "疑惑", "贪图", "秋风过耳", "一唱一和", "笨蛋", "引狼自卫", "列强", "为蛇添足", "拆烂污", "诱致", "倨傲", "姑妄言之", "自恃", "贼眼", "负才使气", "打家劫舍", "曲意奉迎", "道学先生", "猪朋狗友", "嫉恨", "大而笨拙", "戎首", "纸老虎", "理亏", "闹事", "不齿于人", "蹈常袭故", "鹰扬虎噬", "水性杨花", "弛懈", "贪官污吏", "漫天大谎", "堕落", "元奸巨恶", "怠工", "窜端匿迹", "蹈其覆辙", "假公营私", "沽名吊誉", "货赂公行", "伤风败俗", "造次", "私心杂念", "反动", "乱世", "SM", "土石方", "如弃敝屣", "晕头转向", "论调", "百口难辨", "梦中说梦", "责怪", "吞声饮恨", "威重令行", "鬼鬼祟祟", "沽誉钓名", "惯窃", "潮呼呼", "逐物不还", "迁就", "俭不中礼", "室人交谪", "好佚恶劳", "淫词秽语", "虚与委蛇", "淫靡", "气粗", "潜窃阳剽", "东窗计", "拌嘴", "戏子", "缺乏", "贿选", "娇贵", "无能之辈", "劣株", "避重就轻", "闹闹嚷嚷", "糊糊涂涂", "撒刁", "挑剔", "毫无用处", "置之死地而后快", "诳语", "邪财", "抱病", "利已", "獐头鼠目", "专横", "沾沾自衒", "漂亮话", "东施效颦", "争吵", "恶湿居下", "煎水作冰", "繁乱", "虚有其表", "大杀风景", "低效", "自作主张", "口惠", "贩交买名", "姘头", "败柳残花", "潜逃", "倚门卖笑", "罢手", "阴谋不轨", "躲懒", "看不开", "逾分", "附会", "指使", "抢夺", "腻味", "嘴快舌长", "入不敷出", "破烂不堪", "如堕烟海", "吴下阿蒙", "浅易", "吃力", "望尘奔北", "移花接木", "狂嫖滥赌", "数落", "争名于朝，夺利于世", "不足轻重", "嫉恶如仇", "恬不知愧", "炙手可热", "暗算", "潮湿", "穷凶恶极", "蜗行牛步", "不识闲儿", "刀头舔蜜", "心术", "罪有应得", "丢三落四", "玄秘", "百无一成", "主谋", "费力", "食言而肥", "厚颜无耻", "飞言醋语", "亡国大夫", "通风讨信", "嗔怪", "漫天过海", "破卵倾巢", "纵欲", "诛灭", "有眼不识泰山", "勾心斗角", "遵养晦时", "古板", "气充志骄", "冗长", "梼昧", "叛逆", "颇有微词", "意气用事", "以小人之心，度君子之腹", "怒骂", "偏废", "二心", "迁思回虑", "乳臭未乾", "怪声怪气", "闲工夫", "单一", "诈唬", "名利", "高自位置", "假正经", "拘挛补衲", "一成不变", "上行下效", "不容置喙", "不符", "嘲谑", "爱毛反裘", "急于", "没心没肺", "兵痞", "落俗套", "慢慢腾腾", "诱秦诓楚", "犹豫不前", "蔫头耷脑", "利己主义", "惹事生非", "附逆", "错乱", "授人以柄", "轻描淡写", "残毒", "龟缩", "荡检逾闲", "胸无大志", "拖泥带水", "沉渣", "下策", "油腔滑调", "沉吟", "一隅", "横赋暴敛", "寇仇", "坐井观天", "头昏脑眩", "破玩意兒", "妄断", "弄权", "急性子", "各为其主", "不教而诛", "披毛索厣", "虚掷", "死皮赖脸", "气忍声吞", "东冲西撞", "死顽固", "卑谄足恭", "暗里", "推聋妆哑", "乐祸幸灾", "蠢笨", "玩岁愒月", "谄谀", "避实就虚", "哄弄", "浅陋", "海水群飞", "杀人如麻", "狂朋恠友", "钝口拙腮", "姨太太", "骗术", "角弓反张", "恣意", "迂执", "鼓舌摇脣", "高下在口", "记仇", "面目可憎", "孤雏腐鼠", "着三不着两", "鼠齧蠹蚀", "口头掸", "敌特", "毒害", "三天打鱼两天晒网", "阴云", "悍然", "狼羊同饲", "阉割", "缠手", "惰性", "挤眉弄眼", "厚脸皮", "带水拖泥", "无理", "拿乔", "恶煞", "骂骂咧咧", "名不副实", "困扰", "不拘小节", "姗姗来迟", "嗲声嗲气", "今日有酒今日醉", "认贼作父", "讹谬", "坐地分脏", "调笑", "冠冕堂皇", "恐吓", "浮花浪蕊", "心地狭窄", "赃私狼藉", "仇视", "忧郁", "漫骂", "想当然", "卧不安席", "伥鬼", "毒赋賸敛", "庸医", "头上安头", "蹙国百里", "贪污腐化", "失势", "不胜衣", "狗口里吐不出象牙", "不以为意", "母夜叉", "蠢蠢欲动", "痴人说梦", "党羽", "骑扬州鹤", "不肖", "丑婆子", "阿世媚俗", "哓哓", "破绽百出", "暴躁", "肤浅", "杂念", "闳侈不经", "贪小失大", "责难", "蔫不唧儿", "仇恨", "坏水", "换汤不换药", "听天任命", "三光政策", "强脣劣嘴", "赏同罚异", "逞性妄为", "尾大不掉", "拿腔作势", "负材矜地", "厚颜", "拘囿", "蓬头散发", "洗垢求瘢", "瓮天之见", "掉书袋", "招权纳赇", "担雪塞井", "贪生恶死", "失败", "执迷不反", "剿说", "政荒民弊", "零七八碎", "袒裼裸裎", "望风希旨", "赖帐", "文身剪发", "沽名干誉", "胡诌乱说", "才疏意广", "祸事", "蜕皮", "活剥生吞", "邪道", "老派", "丑态百出", "自吹自擂", "壮志未酬", "衮衮诸公", "鹿死不择荫", "抓乖卖俏", "中山狼", "夸功自大", "颐指气使", "轻于鸿毛", "滔滔不绝", "得罪", "造孽", "东烘先生", "珊珊来迟", "小看", "买菜求益", "徒劳无益", "缺失", "垂涎欲滴", "糊弄局", "暴行", "扯臊", "有隙可乘", "酒色之徒", "招摇", "群魔乱舞", "宽纵", "六朝金粉", "中邪", "故步自封", "打掩护", "无名小辈", "目迷五色", "迟疑不决", "饕口馋舌", "复蹈前辄", "一浆十饼", "世界主义", "残害", "贼人胆虚", "拥挤不堪", "摄威擅势", "妖术", "东闪西躲", "宠爱", "变卦", "千人一面", "通风报信", "浮石沈木", "落拓不羁", "呶呶不休", "邪门歪道", "鼻孔撩天", "无洞掘蟹", "短视", "毫厘千里", "暴举", "烈火轰雷", "挂一漏万", "钻山塞海", "窜逃", "差劲", "赃官", "冷落", "操切", "随风逐浪", "愚懦", "失范", "养虎为患", "攀龙讬凤", "山河易改，本性难移", "痛责", "文字狱", "浮礼", "秽迹", "背公向私", "缪说", "贪污", "庸人自扰", "狗仗官势", "竭蹶", "漏泄春光", "无根之木，无源之水", "别风淮雨", "贪官蠹役", "横逆", "目光如鼠", "歧出", "含恨", "好为人师", "邪魔歪道", "两头白面", "逼勒", "监守自盗", "混说", "失守", "焦炙", "悬羊头，卖狗肉", "猥琐", "塞耳盗锺", "剌戾", "蛇欲吞象", "包子", "恶念", "投石下并", "吞吞吐吐", "铺张扬厉", "贪功起釁", "今是昨非", "权重秩卑", "蜗舍荆扉", "咄咄逼人", "过失", "瞎扯", "鹊巢鸠主", "贻害", "迷迷糊糊", "桀骜自恃", "当断不断，反受其乱", "穷乏", "吃嘴", "通病", "束手待死", "妄求", "浪蝶狂蜂", "顺风转舵", "临渴掘井", "枷脰械手", "下游", "畜生", "失机", "千呼万唤　", "厚貌深情", "貌似公正", "胸中鳞甲", "废话", "听人穿鼻", "鬼祟", "酷烈", "河东狮子吼", "三天打鱼，两天晒网", "没两下子", "篡夺", "求乞", "没样儿", "狗屁", "一丘之貉", "明火执械", "贪生", "无关紧要", "踏故習常", "无恒", "歪门邪道", "面是背非", "媚俗", "碌碌无为", "不是话", "方头不律", "行为不检", "嫌疑", "榨取", "认死理", "单薄", "无事生事", "回嘴", "横行天下", "半死半生", "寅吃卯粮", "不羁", "好歹不分", "鹊巢鸠据", "七舌八嘴", "趑趄不前", "文弛武玩", "口坠天花", "鸠佔鹊巢", "烦躁", "气焰", "坐享其成", "漏脯充饥", "帮派", "随心所欲", "弓影浮杯", "狂吠", "豪取智笼", "千言万语", "凶神恶煞", "鼓吻奋爪", "尔虞我诈", "鬼话连篇", "混事", "替古人耽忧", "收买", "雕虫小艺", "论长说短", "坏人", "失禁", "寡头", "平铺直序", "疲沓", "吐刚茹柔", "灰蒙蒙", "好高骛远", "忍受", "怨懑", "喷粪", "罚不当罪", "说嘴", "兔子尾巴长不了", "潜踪", "劳师动众", "豪侈", "为鬼为蜮", "造恶不悛", "无实质", "拒人于千里之外", "呱哒", "洒狗血", "吹大法螺", "残品", "佞人", "越级", "嬉笑怒骂", "旅进旅退", "不合时宜", "放浪", "贪赃坏法", "妖里妖气", "贿赂公行", "剥皮抽筋", "后门", "馋涎欲滴", "人前背后", "脚气病", "微词", "参辰卯酉", "强权政治", "别是", "不兴", "狡焉思启", "帮虎吃食", "招灾", "无诚意", "苦脸", "幽暗", "深根蟠结", "闭塞", "勾当", "党阀", "屏弃", "爽然若失", "舍近求远", "视同路人", "抢亲", "孤芳自赏", "轻佻", "烦厌", "憎称", "坐而论道", "迷魂淫魄", "赔了夫人又折兵", "投降", "内顾之忧", "揭穿", "蛇蝎心肠", "空谈快意", "不问是非情由", "鱼烂瓦解", "鼠偷狗盗", "深雠大恨", "怨怪", "狼奔鼠偷", "攘攘", "魑魅魍魉", "稂莠", "癫狂", "骑墙", "迷而不反", "欺公罔上", "破陋", "望风希指", "抟空捕影", "零敲碎打", "进犯", "执文害意", "无风起浪", "不得已", "土龙沐猴", "凤狂龙躁", "顽梗不化", "装蒜", "恶人", "数典忘祖", "恬不知耻", "一失足成千古恨", "胡言", "迂腐腾腾", "聪明反被聪明误", "一无所长", "差失", "焦眉皱眼", "强权", "推天抢地", "难堪", "卖好", "娇气", "师出无名", "钻火得冰", "吃亏", "青蝇点素", "潢池弄兵", "訾议", "牵累", "长恶不悛", "桀傲不恭", "问道於盲", "剽悍", "抵触", "短见", "求全", "没礼貌", "搀行夺市", "杀机", "怕硬欺软", "猫鼠同处", "欺善怕恶", "敌寇", "鱼烂取亡", "少言寡语", "苛责", "打家截舍", "谬想天开", "鼠穴寻羊", "欺世盗名", "小报告", "穿凿附会", "横蛮", "奚幸", "鸡毛蒜皮", "兴讹造讪", "谋害", "冒名项替", "百无一用", "机关用尽", "食言", "歪心邪意", "百弊丛生", "保护伞", "虚倩假意", "木心石腹", "寸长尺短", "窃贼", "散灰扃户", "陈规陋习", "顽父嚚母", "积怨", "贪欲", "害人虫", "栽诬", "渔人之利", "专擅", "赘言", "回护", "失察", "陈腐不堪", "胆敢", "寄生", "公报私雠", "仳离", "烂人", "次等", "没心眼儿", "放虎自卫", "不足挂齿", "扯淡", "鱼目混珎", "胡说白道", "粗浮", "沾沾自好", "丧气", "鸟样", "吃瘪", "寸草不留", "叛变", "初出茅庐", "主使", "文恬武嬉", "熊包", "苦恼", "博土买驴", "焚琴煮鹤", "靠不住", "恣睢", "予智予雄", "其貌不扬", "冷言冷语", "肉麻", "鹊巢鸠占", "忘恩负义", "自讨没趣", "装腔作势", "狭隘", "千里馈粮", "反目无情", "疙里疙瘩", "徒托空言", "口头上", "不便", "花花公子", "狡辩", "左右为难", "邪魔", "苟且偷安", "挂羊头，卖狗肉", "诬害", "交头接耳", "与世沈浮", "恃强凌弱", "缺德", "勇略", "捞摸", "欲速则不达", "作俑", "叛国", "兜兜搭搭", "听而不闻", "索寞", "土包子", "死心眼儿", "分斤掰两", "归罪", "东横西倒", "满城风雨", "势治", "急巴巴", "迷离徜仿", "阿斗", "幸臣", "野蛮", "再三再四", "野心", "主少国疑", "政客", "冠上加冠", "构陷", "累赘", "桀贪骜诈", "坏植散群", "随波逐尘", "衰朽", "官气", "独吞", "朝歌暮宴", "自恋", "使乖弄巧", "望尘奔溃", "溃乱", "无可如何", "妒火中烧", "漫无目标", "沙场", "揭短", "尔诈我虞", "不起眼儿", "违禁", "混混儿", "失神", "冰炭不相容", "佯为不知", "僻陋", "以暴易暴", "衣食不周", "畏首畏尾", "前怕狼，后怕虎", "出尔反尔", "时不我与", "细大不捐", "坐而待弊", "两头三绪", "追欢卖笑", "不法", "无所错手足", "迷信", "奴颜婢膝", "煞费苦心", "明哲保身", "老奸巨猾", "偏斜", "红不棱登", "吆三喝四", "作威作福", "目光短浅", "砸锅", "为好成歉", "死死", "附骥名彰", "巧偷豪夺", "呆笨", "不知头脑", "插足", "过屠大嚼", "调词架讼", "劣迹", "赘述", "拿班做势", "娇纵", "亥豕相望", "狂傲", "祸盈恶稔", "贼骨头", "横暴", "祸胎", "风花雪月", "裹足不前", "迂论", "一塌胡涂", "肉头", "说怪话", "奴颜媚骨", "解衣包火", "颓然", "涸辙之鲋", "现形", "自命清高", "缺乏教养", "枘凿冰炭", "地主", "天差地远", "TMD", "首鼠两端", "诛锄异己", "说是谈非", "咬文嚼字", "毁坏", "撮弄", "捧场", "奸邪", "现钟弗打", "灭迹", "若明若暗", "暴戾", "闹腾", "剽取", "七老八十", "两面三刀", "不识好歹", "鼠齧虫穿", "其势汹汹", "耍赖", "悠谬", "射影含沙", "怨怼", "爱理不理", "放刁", "束手就擒", "无恶不为", "八面见光", "为富不仁", "未能免俗", "智尽能索", "附翼攀鳞", "伐异党同", "横祸", "劳师糜饷", "贪脏", "妨碍", "吠影吠声", "致死不悟", "窘态", "推东主西", "不力", "矜夸", "狠毒", "贩黄", "差三错四", "剥夺", "刿心刳肺", "昏君", "诛求不已", "傍人篱落", "若要人不知，除非己莫为", "喧闹", "朽败", "捞本", "收拢", "不屑于", "藏掖", "论甘忌辛", "过分", "迂拙", "不伦不类", "怙才骄物", "起事", "秽乱", "不舞之鹤", "挪用", "饰非文过", "卜昼卜夜", "悖逆", "玩时贪日", "与虎谋皮", "陨灭", "殴打", "污毒", "明珠暗投", "鼓脣弄舌", "没计奈何", "反眼不识", "陈陈相因", "生番", "黑乎乎", "查抄", "视若儿戏", "卑之无甚高论", "欠周到", "干巴巴", "幕后", "掇臀捧屁", "盘踞", "卑污", "惊肉生髀", "桑中之喜", "饿死事小，失节事大", "偷偷摸摸", "配不上", "庖代", "妖孽", "舍本逐末", "滑头滑脑", "矮墩墩", "阿附", "罪恶昭彰", "自鸣得意", "失之毫釐，谬以千里", "魔障", "苟合", "靡不有初，鲜克有终", "蛮荒", "迂儒", "嘀里嘟噜", "猢狲入袋", "利己", "东支西吾", "评头品足", "色厉内荏", "碰撞", "笑面虎", "儇薄", "雌老虎", "零零碎碎", "离乱", "诉苦", "离散", "以血洗血", "辩难", "铁公鸡一毛不拔", "冠鸡佩猳", "沙文主义", "野心勃勃", "杂霸", "流言惑众", "束手听命", "弃妇", "压榨", "朽坏", "狗盗鸡鸣", "助桀为虐", "bc", "江山好改，秉性难移", "大权旁落", "恨不能", "摇头稾脑", "敢是", "重义轻生", "夹七夹八", "不轨", "加油加醋", "作呕", "压抑", "失策", "忧愁", "计较锱铢", "窃案", "效颦", "难上难", "浪费", "鸡犬不安", "忙乱", "狼心狗行", "逾淮之橘", "贵耳贱目", "拔苗助长", "自讨苦吃", "浅见", "心急如焚", "乱作胡为", "机关算尽", "惴惴不安", "妆模作样", "鞅鞅不乐", "鸟入樊笼", "陨雹飞霜", "黄口稚子", "授人口实", "对立", "迟滞", "开柙出虎", "得陇望蜀", "愁眉", "麻痺不仁", "顿生疑窦", "残酷无情", "管窥蠡测", "行尸走肉", "冤仇", "懊恨", "帏箔不修", "自制", "流言蜚语", "长袖善舞", "生涩", "鄙贱", "吹大气", "刍荛之见", "口是心非", "惟日为岁", "指东划西", "负恩背义", "卑躬屈膝", "逼人太甚", "河东狮子", "昏乱", "摆阔", "粗手笨脚", "贪财好贿", "贪色", "凿空取办", "坑坑洼洼", "民怨盈涂", "臆造", "智小言大", "屋漏偏遭连夜雨", "庇荫", "谈空说有", "把头", "固执己见", "心不在焉", "恣情纵欲", "腐恶", "兔死狗烹", "苍黄", "耳边风", "遮人耳目", "灰不溜丢", "偷工减料", "草草了事", "讽刺", "起火打劫", "鸡鸣狗吠", "胯下蒲伏", "光蛋", "邪魔怪道", "万民涂炭", "天旋地转", "拿捏", "猪猡", "乱头粗服", "心乱如麻", "懈怠", "乱糟糟", "惘然", "叛离", "玩狎", "笔诛墨伐", "迁延羁留", "惑世盗名", "深文曲折", "一窝蜂", "强行", "草草收兵", "儿戏", "迂见", "引绳批根", "以管窥天", "顽钝", "重浊", "含沙射影", "催命", "撩蜂吃螫", "没精塌彩", "无病呻吟", "孤行", "钓名要誉", "吮痈舐痔", "外患", "挑三豁四", "少气无力", "非分", "敌伪", "瓜蔓抄", "不要脸", "骑鹤扬州", "荒淫", "空头支票", "民怨", "刮野扫地", "鼓腹而游", "版版六十四", "无事生非", "拉大旗作虎皮", "示弱", "钻冰求火", "辟谣", "丢份", "扬言", "侵吞", "轻薄", "陋习", "东涂西抹", "阴霾", "虚度", "闻风远遁", "口舌", "滋长", "理屈", "贪大求全", "寻死觅活", "偷鸡摸狗", "诬赖", "帷幕不修", "长长短短", "驴鸣犬吠", "小丑", "神机鬼械", "有恃毋恐", "暗弱无断", "随近逐便", "残货", "金枷玉锁", "诪张为幻", "戏剧性", "束椽为柱", "避忌", "中冓之言", "灰头土脸儿", "滚蛋", "絮聒", "大煞风景", "粉饰", "疖子", "萧墙之危", "违反", "夸大其辞", "桀骜不驯", "贫骨头", "了不长进", "鬻良杂苦", "退却", "杂沓", "面目狰狞", "仇外", "佻达", "挖空心思", "晦气", "世仇", "巧舌如簧", "拾人唾涕", "糟改", "绵里藏针", "刻骨崩心", "知人论世", "俗下文字", "私奔", "沦落", "心怀叵测", "面誉背非", "打骂", "不可一世", "头焦额烂", "异说", "不知薡蕫", "裙带关系", "敝屣", "走内线", "徇私舞弊", "极恶穷凶", "游蜂浪蝶", "花样", "鸷击狼噬", "嬉皮笑脸", "略识之无", "穷乡僻壤", "口诵心维", "私利", "呼天唤地", "封官许愿", "容克地主", "头晕目眩", "浮石沉木", "随声附和", "背后", "残渣余孽", "麟角凤距", "故态复还", "分金掰两", "寡情", "摆谱儿", "造言捏词", "妒贤疾能", "灰茫茫", "桃色", "迎奸卖俏", "备不住", "屋下架屋", "不值一顾", "妇姑勃谿", "拿人", "剥削", "金迷纸醉", "遗恨", "抓辫子", "抱恨", "暗地", "熏天赫地", "顽固", "系缚", "陈词滥调", "臆说", "财迷", "元凶", "兴妖作乱", "衰弱", "挟天子以令诸侯", "狐奔鼠窜", "冤结", "顾虑重重", "形影相吊", "鹦鹉学舌", "下三滥", "装疯卖傻", "胡猜乱想", "狗心狗行", "猪八戒吃人参果，全不知滋味", "依然故我", "梭天摸地", "口血未干", "埋头顾影", "直勾勾", "袒护", "抛荒", "无中生有", "板荡", "坐冷板凳", "恶浪", "不因人热", "虚饰", "自取其咎", "倖灾乐祸", "难于登天", "无口才", "心浮气盛", "外方内员", "见弹求鹗", "马大哈", "赃物", "群起而攻之", "穷途", "解决", "拾人唾余", "同恶相求", "哗世取名", "头痛额热", "置之不顾", "进退路穷", "妖言惑众", "嗾使", "乳声乳气", "鼓噪而起", "经验不足", "一文如命", "姘居", "赤舌烧城", "矜功伐善", "亡国之声", "轻世傲物", "连帙累牍", "狗熊", "贪生怕死", "闭目塞听", "蝇营狗苟", "一得之愚", "八砖学士", "图谋不轨", "附骥攀鳞", "白痴", "企图", "旁骛", "冷酷", "盗寇", "声讨", "费解", "惟所欲为", "清官难断家务事", "废人", "斗筲之人", "谈过其实", "坐监", "神经质", "出轨", "蚍蜉撼树", "贵少贱老", "耍钱", "欺人以方", "钟鼎人家", "逐影寻声", "泡病号", "负隅顽抗", "强奸", "作伪", "混淆黑白", "摇尾求食", "浊世", "神经病", "捞取", "雕虫末伎", "卑下", "偷合苟容", "蛮悍", "漠不关心", "生拉硬拽", "想不开", "望风而走", "累块积苏", "唾面自乾", "骨腾肉飞", "多一事不如少一事", "流言飞文", "波折", "混世魔王", "误杀", "大错而特错", "引狼入室", "暧昧不明", "纸上谈兵", "油嘴花唇", "拘板", "随声趋和", "落套", "假眉三道", "疑心", "翻版", "莽莽撞撞", "忧烦", "霸王别姬", "前嫌", "吹擂", "肤皮潦草", "黑言诳语", "规行矩步", "狼嗥鬼叫", "富贵浮云", "麻痹", "鸡飞狗跳", "乱语胡言", "敌人", "黏糊", "心胸狭窄", "退坡", "焦金流石", "油水", "存心积虑", "不落边际", "窝气", "不清不白", "成事不足，败事有余", "附肤落毛", "丧心病狂", "罢课", "弃义倍信", "低首下心", "圈套", "掠影浮光", "不仁", "空幻", "闹得慌", "背包袱", "亏欠", "不学无术", "驴头不对马嘴", "迎合", "无恶不作", "卖主求荣", "片面", "殒越", "亡国之音", "九关虎豹", "赃盈恶贯", "妄取", "惹祸招愆", "一问三不知", "指手划脚", "弹冠相庆", "杀人越贷", "说不过去", "恨之入骨", "呆愣愣", "一鼻孔出气", "冠履倒置", "不名誉", "怨嗟", "认奴作郎", "没骨头", "外彊中乾", "心浮气粗", "愚民", "龙生九种", "缓慢", "存心", "雕虫刻篆", "坐地虎", "使嘴使舌", "不僧不俗", "攻其一点，不及其馀", "追根求源", "拿三搬四", "过敏", "欺大压小", "老辣", "言过其实", "仗气使酒", "千叮咛，万嘱咐", "开门延盗", "仗势欺人", "摇唇鼓舌", "豆重榆瞑", "半推半就", "徒有其名", "煞有介事", "赤佬", "爪牙", "披毛索黡", "老粗", "黑钱", "缠扰", "冤狱", "狗苟蝇营", "差之毫釐，失之千里", "望尘拜伏", "忿恨", "萧然", "黩武", "涎脸餳眼", "敷衍", "有声无气", "埋没", "跑江湖", "不成体统", "官迷", "倒持干戈", "冷遇", "祸患", "因公假私", "是非", "不问不界", "凭白无故", "讨流溯源", "歪八竖八", "私话", "暧昧", "结核杆菌", "毁方投圆", "作对", "鬼话", "大舌头", "钻穴逾墙", "难耐", "胡作非为", "投机倒把", "不稂不莠", "搜索枯肠", "细弱", "凌夷", "捣乱", "沉冤", "窜扰", "没教养", "先入为主", "神不知，鬼不觉", "狡计", "遭灾", "安之若命", "多行不义必自毖", "上之所好，下必甚焉", "诳时惑众", "沽名钓誉", "故家乔木", "陵弱暴寡", "执傲", "违天逆理", "不齿", "威刑肃物", "光秃秃", "难相处", "漆黑一团", "始乱终弃", "清查", "逆耳", "横拖倒拽", "造谣惑众", "横眉竖眼", "幽怨", "狼心狗肺", "钟鼎之家", "交困", "引经据典", "刺刺不休", "哄笑", "土司制度", "以规为瑱", "毁誉", "亡猿祸木", "恨不得", "干瘪瘪", "落井下石", "胡乱", "恶俗", "有勇无谋", "只见树木，不见森林", "反常", "横拖竖拉", "故弄虚玄", "进退维艰", "涝害", "淫棍", "违抗", "隐约其辞", "牢笼", "粗浅", "追趋逐耆", "卑鄙龌龊", "又哭又闹", "浮夸", "谣诼", "自相残害", "威风扫地", "三分像人，七分像鬼", "顽皮赖骨", "涎着脸", "效尤", "囚首垢面", "勉为其难", "唱反调", "沾花惹草", "生吞蜈蚣－百爪挠心", "欲加之罪，何患无辞", "哑子吃黄连", "空谈", "井底虾蟆", "枯体灰心", "痴呆呆", "暗害", "夷灭", "扒皮", "忍垢偷生", "心怀鬼胎", "平庸", "胆大包天", "自贻伊戚", "有气无力", "莫衷一是", "揭批", "阿谀", "浑浑沌沌", "追懽卖笑", "狐埋狐扬", "粗鄙", "八股", "钻天打洞", "黏皮着骨", "毛手毛脚", "污秽", "无端端", "狂言", "摆弄", "够呛", "即即世世", "兵荒马乱", "多病", "附庸", "排挤", "官话", "言而无信", "拐带", "不辨菽麦", "蹈袭", "好行小惠", "右派", "德音莫违", "谤毁", "异口同声", "窳惰", "为渊驱鱼，为丛驱雀", "同业相仇", "迷天大谎", "盗贼", "翘尾巴", "心狠", "假托", "被发左衽", "凶虐", "视若无睹", "攀高结贵", "攻守同盟", "如风过耳", "失职", "郁郁累累", "埋怨", "不知所错", "寸长尺技", "贫嘴薄舌", "荆天棘地", "愚夫蠢妇", "饶舌", "权贵", "镌空妄实", "窟窿", "引狼拒虎", "惹是招非", "憋拗", "贱目贵耳", "邮包掉进水田－半信半疑", "向壁虚造", "怠惰", "低智", "束马县车", "爨桂炊玉", "犯嘀咕", "左书右息", "虚夸", "涎眉邓眼", "荒瘠", "刺激性毒剂", "贪名爱利", "连篇累牍", "扁桃体炎", "谎言", "三纸无驴", "花天酒地", "粗蛮", "竖子", "卖官贩爵", "陪绑", "罪人", "口惠而实不至", "青皮", "醋坛子", "熬煎", "言不及义", "狗盗鼠窃", "麻木不仁", "东游西逛", "攀炎附热", "风言醋语", "胸中无数", "愚钝", "放辟淫侈", "马牛襟裾", "痛诉", "乡愿", "知荣守辱", "插翅难飞", "小抄儿", "借公行私", "惨毒", "低人一等", "发愁", "欺世罔俗", "下不来台", "偏食", "萧规曹随", "阻挠", "盗骗", "囚犯", "俚俗", "烦愁", "纷扰", "多嘴多舌", "争宠", "列风淫雨", "捉影捕风", "肆意", "偏护", "焚琴鬻鹤", "招风惹草", "争嘴", "实验主义", "残虐不仁", "铺张", "残暴", "争多论少", "无意义", "东冲西决", "流言飞语", "孔席墨突", "墨守陈规", "毛头毛脑", "守财奴", "两面光", "坐卧不宁", "过甚", "流离", "志骄气盈", "贫气", "绣花枕头", "偏执", "挟制", "淫邪", "枝附叶连", "屯积居奇", "随便", "有嘴没心", "青楼", "六趣轮回", "恫吓", "难以", "乘伪行诈", "自取其祸", "伤言扎语", "误会", "滋事", "臭皮囊", "遮盖", "喧扰", "东磕西撞", "东摇西摆", "胆小鬼", "恃才傲物", "敲诈勒索", "寒微", "钩爪锯牙", "瞽言妄举", "穷形尽相", "听信", "头昏眼花", "撇嘴", "一仍旧贯", "吹拍", "蓬户筚门", "狂荡", "不学无识", "吃货", "斗挹箕扬", "人浮于事", "错讹", "靡费", "舞文弄墨", "猪突豨勇", "不根之论", "变态", "颓靡", "乱烘烘", "险毒", "羽毛未丰", "本本主义", "引虎自卫", "辜恩背义", "虚悬", "临事而惧", "托病", "死板", "忍辱偷生", "油头粉面", "蒙头转向", "违心之论", "碍眼", "死不足惜", "目光凶狠", "开门揖盗", "要不得", "蟪蛄不知春秋", "两肩荷口", "任其自流", "乌集之众", "说谎", "狐鸣篝中", "伪善", "死一般", "手头紧", "破罐破摔", "再犯", "亢心憍气", "挑毛拣刺", "爆烈", "恍惚", "嚣闹", "狼狈不堪", "冠屦倒施", "错漏", "嘴脸", "黑心", "折本", "暗地里", "蹉跎", "邻女詈人", "索然乏味", "狐鸣狗盗", "凡俗", "吉网罗钳", "恶毒", "度日如年", "瞒天昧地", "鲁钝", "各人自扫门前雪，莫管他家瓦上霜", "百无聊赖", "无凭无据", "狗逮老鼠", "闹玄虚", "有理无情", "貂狗相属", "桀骜不恭", "狼狈为奸", "杂牌", "灯蛾扑火", "耍无赖", "视而不见，听而不闻", "痴子", "血腥", "失密", "药店飞龙", "粗活", "流天澈地", "嗜血成性", "灾殃", "衒玉自售", "不间不界", "离谱", "偷闲", "枯寂", "束蒲为脯", "碍手碍脚", "口耳相传", "犯疑心病", "穿窬", "一哄而起", "不堪入耳", "淫言诐行", "不屑一顾", "千刀万剐", "行若狗彘", "浞訾栗斯", "桀纣", "挑拨离间", "以古非今", "轻蔑", "方以类聚", "不情之请", "谄上抑下", "忘恩背义", "包打听", "暗室亏心", "伤生", "私下里", "愧恨", "吃不开", "故甚其词", "悠悠荡荡", "张眉努目", "拿架子", "造谣中伤", "欺辱", "滑稽", "如坐针毡", "不食之地", "粗腿病", "成性", "口不应心", "锋芒逼人", "腐朽没落", "指瑕造隙", "烂摊子", "鹤膝蜂腰", "小气鬼", "病包儿", "势利", "滞销", "刳胎杀夭", "德薄才疏", "互相残杀", "恶直丑正", "寒蝉仗马", "假惺惺", "懵懂", "喧杂", "笑面夜叉", "冗员", "抢白", "保守", "唯利是求", "顽抗", "诛求无厌", "斜楞", "游谈无根", "强弩之末", "没羞", "深奸巨猾", "龙蟠虬结", "党恶佑奸", "寡味", "暗箭伤人", "吸毒", "贱货", "心眼多", "民贼", "扰民", "体罚", "乌有先生", "鱼烂河决", "遁天倍情", "捉摸不定", "生杀予夺", "交战国", "横行不法", "驽马恋栈豆", "赏罚不当", "迷茫", "干涉", "胡闹", "阴险", "饭囊酒甕", "卑俗", "风尘仆仆", "忍心", "累牍连篇", "面谀背毁", "愚蒙", "绊脚石", "劈两分星", "哄然", "不省人事", "夙世冤业", "杀人盈野", "法盲", "一口吸尽西江水", "土里土气", "嫌疑犯", "刁悍", "脱轨", "迷迷怔怔", "大摇大摆", "累累", "郁结", "桀傲不驯", "放纵", "作怪", "喧哗", "肠肥脑满", "受贿", "奇装异服", "鸿鳦满纸", "肆虐", "貌是心非", "蠹虫", "背不住", "退缩", "暴取豪夺", "厌烦", "鸡飞蛋打", "问舍求田", "内讧", "闲花野草", "象牙之塔", "兴味素然", "目光如豆", "游戏翰墨", "随珠弹雀", "下药", "妄人", "寻章摘句", "悭吝", "欺上瞒下", "无味", "虚言", "倒三颠四", "不知就里", "响马", "刁钻古怪", "各行其是", "冒充", "有天没日", "粥少僧多", "色迷迷", "楞眉横眼", "丢三忘四", "好色", "头子", "送旧迎新", "流俗", "算计", "敬而远之", "沉滞", "混为一谈", "顾虑", "唯唯连声", "说是道非", "鱼目混珍", "火龙黼黻", "连累", "为虎添翼", "欺良压善", "好吃懒做", "捣蛋", "造谣生事", "死灰复燃", "国贼", "不知甘苦", "该死", "降心相从", "贻害无穷", "狐疑不决", "乱七八糟", "顾而言他", "颠来倒去", "凭几据杖", "淫辞秽语", "食日万钱", "足趼舌敝", "干燥", "淫乱", "不闻不问", "开小差", "播弄", "狐假鸱张", "嘴长", "人渣", "洪灾", "水土不服", "自我解嘲", "无理取闹", "不到黄河心不死", "傻呵呵", "衰萎", "驯化", "淫亵", "慢藏诲盗", "忘本", "朽木粪土", "浮语虚词", "昏黑", "错综复杂", "放刁把滥", "邪门", "淡而不厌", "说教", "孟浪", "贪得无厌", "名缰利锁", "三智五猜", "索然", "鞭挞", "抱残守缺", "反诬", "蔫不出溜", "擅自为谋", "酷吏", "反派", "痴傻", "右倾机会主义", "倚官仗势", "蒙昧无知", "自不量力", "等不及", "口角春风", "赖账", "恢诡谲怪", "垂头丧气", "朝三暮四", "吠形吠声", "乱乎", "蠹众木折", "南腔北调", "做手脚", "玩物丧志", "自高自大", "尤而效之", "违条舞法", "牵缠", "因小失大", "为蛇画足", "粗拙", "罢黜", "黄色文学", "规行矩止", "臭味相投", "胰见", "欺负", "顽皮贼骨", "蹈人旧辙", "没有学问", "懒散", "失闪", "耍花腔", "懦夫", "摘瓜抱蔓", "拿粗挟细", "交际花", "血海深仇", "不克", "沾染", "心浮", "见小闇大", "横行霸道", "截鹤续凫", "赌棍", "横加指责", "漫无目的", "哑口无言", "挟持", "神不知鬼不觉", "腐臭", "异想天开", "唾壶击缺", "卑劣", "油嘴滑舌", "卖男鬻女", "口口声声", "使性子", "谲诈", "不更事", "勾连", "揠苗助长", "胡子拉茬", "毁损", "碎尸万段", "小己得失", "左思右想", "案犯", "詀言詀语", "杞天之虑", "污染", "视如敝屣", "鲁鱼陶阴", "懒到极点", "拖欠", "抓耳挠腮", "凌杂", "嘲笑", "别扭", "耻骂", "文化买办", "胡说乱道", "苛待", "侵夺", "反侧", "贪心不足", "逆水行舟", "诬枉", "贵不召骄", "敲榨勒索", "凑合", "负德背义", "跅弛不羁", "执迷不醒", "犯傻", "岔子", "小性儿", "乖剌", "剽袭", "糖弹", "一人得道，鸡犬升天", "高谈阔论", "蔫儿坏", "妙手空空", "猜忌", "江郎才尽", "桀敖不驯", "挑肥拣瘦", "怙过不悛", "焦心", "嚣杂", "恶贯已盈", "撒酒疯", "专断", "寝食不安", "罪恶深重", "辗转反侧", "旁门小道", "庸人", "打落水狗", "愁眉苦眼", "裙屐少年", "一帮", "羼杂", "迷离扑朔", "毛病", "浑蛋", "役使", "敲竹槓", "喝斥", "违天悖理", "续貂", "起褶子", "七拱八翘", "阴郁", "火上浇油", "勾引", "诮呵", "大模大样", "浮荡", "臆断", "佛口蛇心", "以人废言", "凶年恶岁", "恶魔", "以己度人", "不护细行", "啁哳", "钓誉沽名", "鬼子", "缺点", "胡诌乱道", "裒敛无厌", "一事无成", "奉头鼠窜", "不修边幅", "次品", "龙血玄黄", "进道若踡", "人声嘈杂", "世俗", "便便", "树敌", "延误", "实用主义", "畏葸不前", "蛇蝎", "暴敛横征", "看低", "陷阱", "行不从径", "丰墙峭阯", "装糊涂", "东张西望", "杨花水性", "空穴来风", "效颦学步", "罪状", "帝王", "桀黠", "扫帚星", "瓜李之嫌", "负地矜才", "令人发指", "厌恨", "不像话", "跑跑颠颠", "松散散", "作死", "求田问舍", "横三顺四", "豪夺巧取", "锯牙钩爪", "斤斤计较", "不端", "行不副言", "遂迷忘反", "煞气", "剥肤及髓", "暮气", "不知疼痒", "径行直遂", "狼奔豕突", "打击报复", "奸人", "拙口笨腮", "没精打彩", "头痛灸头，脚痛灸脚", "大爷", "上梁不正下梁歪", "疑念", "费时", "花街柳巷", "为虺弗摧", "侵占", "黑幕", "东扯西拉", "低下", "官样文章", "动摇", "进退失图", "冗词赘句", "牗中窥日", "施威", "湮没", "避面尹邢", "囫囵吞枣", "盗匪", "人心隔肚皮", "势不两立", "朝中有人好做官　", "疲困", "歹人", "无精嗒彩", "通奸", "楞头楞脑", "浑沦吞枣", "随世沈浮", "以身试法", "喧嚣一时", "颠倒是非", "逾墙窥蠙", "陶陶兀兀", "抑郁", "良莠不齐", "砭庸针俗", "可耻", "朝不某夕", "刁顽", "糜费", "有我无人", "卖狗悬羊", "掠取", "一哄而散", "过头", "迫害", "染缸", "陶犬瓦鸡", "海中捞月", "不可告人", "江山易改，本性难移", "布鼓雷门", "日月交食", "酒食徵逐", "拈斤播两", "暗藏", "罢免", "风烛残年", "不暇", "好大喜功", "疱代", "邪念", "淫猥", "疯话", "雪上加霜", "非我族类，其心必异", "无其奈何", "束手束足", "白党", "置之不理", "击排冒没", "人心不足蛇吞象", "毒打", "刿心刳腹", "剿袭", "袭人故技", "狼蟲虎豹", "招摇撞骗", "调脣弄舌", "逃窜", "敷衍了事", "艰难竭蹶", "食古不化", "聊以解嘲", "宿弊", "糟蹋", "坏人当道", "文侩", "问鼎", "离格", "托陈取消派", "掠夺", "势不俱栖", "喧嚷", "出疆载质", "孱头", "启宠纳侮", "日削月朘", "浮生若梦", "糟粕", "抵制", "靡靡之声", "鼠腥蜗肠", "上不得台盘", "卖友", "假手", "委过于人", "为非作恶", "可怜虫", "反面无情", "愦乱", "寡见少闻", "弄粉调脂", "反唇相讥", "文奸济恶", "强作解人", "心劳日拙", "害群之马", "疲软", "粗笨", "挤挤插插", "买铁思金", "苛求", "祸起萧墙", "肢解", "挑毛病", "一掷千金", "MPJ", "责问", "百星不如一月", "斥责", "弊病", "辜恩负义", "妇人醇酒", "故技重施", "吃里爬外　", "疲塌", "嫌贫爱富", "浆酒藿肉", "作歹为非", "成心", "长篇累牍", "洗劫", "靡有孑遗", "恶劣", "敲冰索火", "营蝇斐锦", "庸耳俗目", "信口胡言", "大眼看小眼", "没出息", "冷嘲热讽", "悠缪", "单调", "沉吟不决", "江洋大盗", "指鹿作马", "嚼舌", "亦步亦趋", "作辍无常", "狎妓", "重气轻生", "公私交困", "粤犬吠雪", "背义负恩", "下流", "骚货", "做戏", "呶呶", "形锁骨立", "草菅人命", "赘疣", "无动於中", "狼子野心", "怵心刿目", "阴冷", "闷郁", "怅恨", "党同妒异", "死有余罪", "盘马弯弓", "面誉背毁", "没眉没眼", "马贼", "受穷", "攀诬", "掉舌", "急于求成", "傲物", "旁门邪道", "宠儿", "重规叠矩", "天理难容", "下车作威", "鬼蜮", "毒蛇猛兽", "黄齑白饭", "臭烘烘", "耻笑", "障人眼目", "视若兒戏", "五内如焚", "小动作", "头昏眼暗", "点头哈腰", "黑漆皮灯", "豺狐之心", "吝啬鬼", "妄称", "溜之大吉", "贼臣乱子", "鹿皮苍璧", "区区", "烦神", "猥鄙", "笔伐", "坐待", "惟命是听", "心如火焚", "自恃其才", "束手就殪", "落网", "夸耀", "撩蜂剔蝎", "傲视轻物", "絮絮叨叨", "搅局", "垫背", "窜改", "数米量柴", "病夫", "破绽", "过谦", "目指气使", "黔突暖席", "市侩", "食品污染", "浮收勒折", "恶霸", "揩油", "鲜衣良马", "龙江虎浪", "无所事事", "不堪造就", "操之过切", "鸡蛋里挑骨头", "爱发牢骚", "搜刮", "高谈大论", "飞蛾赴火", "使心作倖", "送往迎来", "烹犬藏弓", "不管不顾", "徒宅忘妻", "钻冰取火", "狼子兽心", "冤头", "褊狭", "目无尊长", "文抄公", "训戒", "鼠屎汙羹", "溜须拍马", "怅然若失", "纳粹", "费尽心机", "崇本抑末", "教条主义", "竖子成名", "折辱", "暗杀", "囚首丧面", "混账", "自取灭亡", "勉勉强强", "操戈同室", "油嘴狗舌", "虚伪", "耍奸", "引水入墙", "发呆", "狼籍", "寡廉鲜耻", "拂逆", "骑鹤望扬州", "鼻孔朝天", "灰烟瘴气", "抓瞎", "撒娇撤痴", "助纣为虐", "硬撅撅", "践踏", "使性摜气", "不知好歹", "扒高踩低", "冬扇夏炉", "澡垢索疵", "黄口小兒", "生吞活剥", "木然", "洗垢求瑕", "吞舟漏网", "撮盐入火", "墨吏", "敛怨求媚", "成败论人", "妆聋做哑", "反其道而行之", "轻举妄动", "文武差事", "反社会", "凶器", "智者千虑，必有一失", "涎言涎语", "鼠首偾事", "疑忌", "变种", "瘟神", "一手遮天", "揭发", "怕死贪生", "大张旗鼓", "引鬼上门", "傻笑", "谗佞", "胶柱鼓瑟", "项庄舞剑，意在沛公", "薄幸", "鄙俚浅陋", "焦思苦虑", "扇风点火", "盲人说象", "不郎不秀", "窳败", "虎狼", "受罚", "天地诛戮", "鼓吹", "朝歌夜弦", "安坐待毙", "榆木圪垯", "假撇清", "奴化", "损害", "欺天诳地", "强加", "失信", "多事之秋", "鲜衣怒马", "心狠手辣", "东一榔头，西一棒杨", "质量差", "凛若秋霜", "债台高筑", "假充", "设心积虑", "霸气", "色情", "昏昏默默", "貌似强大", "不觉技痒", "不管三七二十一", "闲人", "为恶不悛", "淫雨", "塞责", "诲奸导淫", "胡言乱语", "淫威", "淤积", "文过遂非", "罪加一等", "板滞", "毕其功于一役", "坐收渔利", "毛遂堕井", "肇祸", "五脊六兽", "从权", "降格以求", "吭哧", "肃杀", "眉来眼去", "敲竹杠", "盲干", "诅咒", "茅室蓬户", "拉长个脸", "丑态毕露", "无行", "仿冒", "高不凑低不就", "目睫之论", "娼妓", "土匪", "春蚕自缚", "骨软肉酥", "自专", "细作", "主观唯心主义", "群龙无首", "闹剧", "反咬", "敌对", "讹误", "逐影吠声", "责备", "寡欢", "阿谀奉承", "自相残杀", "眉眼高低", "横徵苛役", "玷辱", "黄色", "软化", "进退无路", "愣头愣脑", "迷雾", "摇头晃脑", "惯技", "坐食", "与世沉浮", "胆小如鼠", "徘徊歧路", "束手就禽", "骚乱", "冒进", "漫漶", "口蜜腹剑", "侵害", "邪僻", "逆道乱常", "粗俗", "倔强", "催逼", "榆瞑豆重", "荼毒生灵", "空喊", "无足轻重", "贼溜溜", "大兴土木", "狐疑未决", "道听途说", "乌天黑地", "羝羊触藩", "僵化", "寡淡", "规求无度", "附骥攀鸿", "苦境", "犹豫", "朽木不可雕", "粗服乱头", "批判", "篡改", "鬼瞰其室", "闲杂人员", "女流", "扬玲打鼓", "豺虎肆虐", "浮云蔽日", "涂脂抹粉", "灰容土貌", "搀杂", "赌钱", "党邪陷正", "束手无策", "蛮干", "三头两日", "侈谈", "神伤", "厌倦", "好丹非素", "被动", "没有好脸", "缺心眼儿", "避讳", "大大咧咧", "使心用腹", "马齿徒增", "敌意", "货贿公行", "坐食山空", "瓦釜雷鸣", "肉了叭叽", "寸蹄尺缣", "没有教养", "欠完善", "侯服玉食", "不今不古", "绕脖子", "东诓西骗", "倚仗", "刚愎自用", "臃肿", "轻世肆志", "纷繁", "颂古非今", "丑类", "鸡胸龟背", "旷课", "证龟成鳖", "民穷财尽", "怪僻", "肤泛", "泼油救火", "冷酷无情", "任达不拘", "市惠", "装假", "横行直走", "垂涎", "糟糕", "出言不逊", "赃货狼藉", "丑事", "浑水摸鱼", "失之交臂", "原始积累", "文身断发", "黯淡", "求和", "身败名裂", "癞皮狗", "文过其实", "无间可伺", "鼠肚鸡肠", "不求甚解", "秽亵", "矫揉造作", "断章截句", "刳胎焚夭", "引诱", "走卒", "天方夜谭", "教猱升木", "相提并论", "等而下之", "抢掠", "车殆马烦", "鼠胆", "鸡鹜争食", "適情任欲", "造化小儿", "横生枝节", "匪首", "狗党狐朋", "凶悍", "口尚乳臭", "迂拘", "嫌隙", "优柔寡断", "粗心大意", "大题小做", "抠心挖肚", "说白道黑", "发热", "抽风", "滑不唧溜", "不对茬儿", "天之僇民", "挑衅", "粗鲁", "死灰槁木", "爱搭不理", "霸占", "胡扯", "犯红眼病", "勒索", "碌碌无奇", "眼光短浅", "异己分子", "有眼无珠", "一波三折", "权势", "不可捉摸", "授柄於人", "拉近乎", "藩篱", "舛错", "标榜", "腾腾兀兀", "背弃", "辽东豕", "轻飘", "卖俏行奸", "破戒", "心窄", "转死沟渠", "皮相", "淮王鸡狗", "弄虚作假", "玩岁愒时", "愚直", "褎如充耳", "推托", "风雨飘飖", "嗔斥", "污点", "卑微", "丑恶", "冷淡", "埋汰", "高高在上", "诓骗", "坐以待毙", "柳圣花神", "费事", "纨绔子弟", "拜赐之师", "转弯抹角", "附赘悬肬", "浅尝", "内耗", "治罪", "摇旗打鼓", "惑乱", "有口无心", "臊气", "泄露", "劳而无功", "毫釐千里", "剔蝎撩蜂", "寡了叭叽", "徒劳无功", "无吸引力", "蠢头蠢脑", "出乖露丑", "行为不端", "进谗", "隐衷", "指鹿为马", "扼杀", "不了了之", "指东话西", "望文生义", "简慢", "傻比", "只许州官放火，不许百姓点灯", "语言无味", "条条框框", "鸡争鹅斗", "失宜", "张公吃酒李公醉", "泛滥成灾", "不成材", "炫玉贾石", "闲职", "鱼惊鸟散", "上下其手", "蹉跎自误", "鱼目混珠", "加膝坠泉", "浮收勒索", "投井下石", "见笑大方", "嫌恶", "首鼠模棱", "有伤风化", "好逸恶劳", "外强中瘠", "诱胁", "尖言冷语", "掩耳盗铃", "地头蛇", "结伙", "鹑衣", "江郎才掩", "肆意横行", "操刀伤锦", "诪张", "私下", "劣质", "宵小", "妄谈祸福", "吵子", "没法奈何", "扫地以尽", "流寇", "说长道短", "结党营私", "不手药", "阴损", "怀疑", "铁心木肠", "穷极无聊", "养痈贻患", "起意", "灰头土面", "侵蚀作用", "柔弱", "遗毒", "错觉", "心余力绌", "黏皮带骨", "大声疾呼", "公子哥儿", "滑天下之大稽", "自己打自己的嘴巴", "四海鼎沸", "渎职", "爱富嫌贫", "心焦", "恹恹", "贱骨头", "元恶大憝", "次货", "白忙活儿", "钱可通神", "蚀本", "西洋景", "糗大了", "愚妄", "不切实际", "尸禄素飡", "泥古", "空话", "悖谬", "朋党之争", "拿班作势", "强横霸道", "扶墙摸壁", "舞文巧诋", "怨仇", "昂首望天", "朋党比周", "浇薄", "臭不可闻", "容忍", "俯首听命", "险峭", "豺狼成性", "对付", "乱作一团", "仇敌", "锱铢较量", "南辕北辙", "率尔", "大惊小怪", "嘴贫", "可憎", "抱粗腿", "掩人耳目", "疏懒", "玩花样", "觖望", "臭名远扬", "唯唯否否", "伐性之斧", "体无完皮", "憎恨", "愁苦", "小丑跳梁", "冷宫", "捅娄子", "雕虫薄技", "赏不当功", "鼓馁旗靡", "积弊", "不值一钱", "窥豹一斑", "碌碌无能", "诛除", "乏力", "急功近名", "假面具", "空空洞洞", "拖天扫地", "行贿", "吃错药", "帷灯匣剑", "无作不为", "皮之不存，毛将焉附", "居高不下", "偷闲躲静", "闭关自守", "惟利是命", "一笑置之", "失礼", "唠唠叨叨", "沸沸扬扬", "忘恩失义", "口轻舌薄", "千篇一律", "目无王法", "承颜候色", "胡里胡涂", "情绪", "贪求", "玩故習常", "无名小卒", "差若毫釐，谬以千里", "施绯拖绿", "一叶蔽目", "度日如岁", "终天之恨", "鸨母", "趋炎附势", "视同兒戏", "黑店", "称臣", "淫词亵语", "懈劲", "侵袭", "窃窃私语", "酣歌恆舞", "退化", "意在言外", "抱火卧薪", "贼头狗脑", "老调", "不知颠倒", "不够", "谩不经意", "扰扰", "瞎说", "焦灼", "救火投薪", "智昏菽麦", "藐小", "蒙混", "焦枯", "理屈词穷", "病病歪歪", "管窥所及", "刺眼", "卑琐", "十恶五逆", "塌台", "佶屈聱牙", "我行我素", "啮噬", "刓方为圆", "充数", "蛮勇", "丑诋", "讬凤攀龙", "臭架子", "悖晦", "见不得人", "两难", "无度", "官倒", "自以为得计", "愚儒", "械斗", "舞弊", "求道于盲", "嘴笨", "偏私", "杼柚其空", "堵得慌", "说黄道黑", "马耳春风", "费神", "买好", "饭囊", "三心两意", "前挽后推", "傻子", "势如冰炭", "桃代李僵", "望风捕影", "抠搜", "挖肉补疮", "枯株朽木", "囤积居奇", "扣槃扪烛", "晃悠悠", "捕影系风", "损毁", "最坏", "封己守残", "猥劣", "吃不服", "病急乱投医", "漫不加意", "贪财恋色", "卖弄", "函矢相攻", "不宜", "窜犯", "骄泰淫泆", "自食其果", "耽误", "味道不好", "当断不断", "寒腹短识", "缪错", "强盗挂念珠", "憎恶", "后患", "闲事", "躁言丑句", "闲言淡语", "惯偷", "无所施其伎", "揭箧探囊", "得逞", "淡妆浓抹", "唾弃", "从风而服", "墨突不黔", "失实", "夙世怨家", "守缺抱残", "忘情负义", "芥蒂", "赃污狼藉", "含牙带角", "洗垢球瘢", "出口伤人", "深恶痛疾", "贪心", "一无所知", "机心械肠", "弩钝", "败退", "推波助澜", "三日打鱼，两日晒网", "位卑言高", "官偪民反", "水底摸月", "转辗反侧", "鼓脣咋舌", "肉欲", "戒律", "漫天叫价", "诡雅异俗", "鼠雀之牙", "小绺", "肆行", "怨苦", "横加", "贬抑", "爱小", "得鱼忘筌", "使羊将狼", "噪音", "顽固不化", "贪求无已", "炎热", "脏乱", "怪诞", "破裂", "上援下推", "驴脣马觜", "土偶蒙金", "讪牙闲嗑", "玉卮无当", "穷酸", "大而无当", "断炊", "阿谀顺旨", "大胆泼辣", "束手就毙", "棘手", "造言惑众", "肇事", "心如铁石", "竹篮打水", "妄自尊大", "嫌憎", "虚情假意", "探头缩脑", "懈弛", "甜言蜜语", "罪责", "杂草丛生", "窝憋", "兴如嚼蜡", "利欲熏心", "死板板", "水中捞月", "挑脣料嘴", "病态", "丑话", "诡计多端", "奇货可居", "散兵游勇", "后顾之忧", "杀人如草", "帮凶", "追欢取乐", "大呼小喝", "河清海竭", "含含糊糊", "翻云覆雨", "便秘", "哀怨", "拙涩", "骄傲", "杂质", "狐裘蒙茸", "花着", "硁砭之愚", "奥援有灵", "扪参历井", "强人所难", "阴晦", "窝心", "颓废主义", "策动", "帮闲钻懒", "借题发挥", "点火", "犯贱", "傥荡", "使酒骂座", "阴狠", "山上无老虎，猴子称大王", "顾左右而言他", "山重水复", "BS", "随声是非", "破鞋", "酒肉兄弟", "不知深浅", "鹰视狼步", "愁眉锁眼", "烽鼓不息", "随风转舵", "天道宁论", "妄言妄听", "派头", "徒拥虚名", "油头滑脑", "风言风语", "口角", "长安居大不易", "淆乱", "倚酒三分醉", "鬼蜮技俩", "重财轻义", "口说无凭", "昂首天外", "丧尽天良", "迂腐", "枉口诳舌", "挟势弄权", "拿大", "称霸", "谴谪", "鼠目麞头", "情妇", "粪土不如", "诈骗", "念念有词", "横僿不文", "挑三拣四", "复杂", "鼠窃狗偷", "多疑", "铜臭", "鸿鹄将至", "不登大雅", "战争贩子", "盲人瞎马", "事不关己", "没味", "消磨岁月", "伪劣", "独弦哀歌", "诗书发冢", "自居", "自大", "昏头晕脑", "假公济私", "张眼露睛", "教条", "无风扬波", "莫予毒也", "烦忧", "心黑手辣", "虎着脸", "负才任气", "鲜廉寡耻", "翻翻覆覆", "枉法", "喋喋", "骑鹤更扬州", "运斧般门", "枷锁", "黄毛丫头", "托故", "添枝增叶", "贻人口实", "粗陋", "讬公报私", "辱命", "作法自弊", "鬼物", "生灵涂炭", "不敬", "言外之意", "当头棒喝", "缺乏绅士风度", "故态复萌", "井底鸣蛙", "愁肠百结", "秉性剌戾", "作舍道边", "扁平足", "侵权", "穷凶极恶", "损人肥己", "喉长气短", "偏颇", "两意三心", "土得掉渣", "小心眼儿", "古里古怪", "瞒天过海", "装聋作哑", "邪行", "谄上欺下", "高姿态", "根蟠节错", "凶毒", "尾大难掉", "摈斥", "妖怪", "腐化堕落", "糟朽", "偷香窃玉", "思妇病母", "凶险", "尸禄素餐", "抉目胥门", "贵壮贱老", "反悔", "钻故纸堆", "守阙抱残", "坐观成败", "韩寿偷香", "乳臭未干", "操心", "违拗", "骚乱性", "含垢纳污", "黑金", "妖风", "骗子", "买上告下", "恼恨", "唯利是图", "骄侈淫虐", "木雕泥塑", "坏分子", "居利思义", "参错", "掩眼捕雀", "血气方刚", "奸细", "冷血动物", "掩耳盗钟", "一筹莫展", "油头滑面", "泯没", "抓茬儿", "狗肺狼心", "掉队", "天才论", "伤风败化", "背恩负义", "欺瞒夹账", "猜疑", "含糊", "怨怒", "搬脣弄舌", "得势", "连编累牍", "投机取巧", "没头脑", "妖艳", "东扶西倒", "说短论长", "离本趣末", "背公营私", "步人后尘", "饥不择食", "惩办主义", "作茧自缚", "奸妇", "沾泥带水", "戏弄", "卖笑追欢", "斤斤较量", "战祸", "有加无已", "贵人多忘事", "恼人", "挥金如土", "昏天黑地", "一毛不拔", "憋气", "妥首帖耳", "不快", "酒囊饭袋", "困迫", "杜口裹足", "絮烦", "社鼠城狐", "判若两人", "威迫", "奸徒", "横冲直撞", "死守", "瞎抓", "腻歪", "报复主义", "率由旧章", "尖酸刻薄", "混淆是非", "荒废", "荒淫无度", "郢书燕说", "踌躇不前", "不以为然", "惟利是求", "事不关己，高高挂起", "疲敝", "偏乡僻壤", "居心", "应名儿", "攀高接贵", "阳解阴毒", "贪财好色", "周折", "鹰瞵虎攫", "强文假醋", "事故", "贻笑大方", "强横", "贪贿无艺", "乱点鸳鸯", "委过", "巩固", "苛刻", "添枝加叶", "装腔", "骄兵必败", "冷心冷面", "浆酒霍肉", "膏粱子弟", "涸辙枯鱼", "繁冗", "肥马轻裘", "巴儿狗", "进退首鼠", "饰非拒谏", "渎货无厌", "负材任气", "ZE", "固步自封", "多许少与", "雨愁烟恨", "说是弄非", "误国殃民", "百无一能", "不识东家", "渔人得利", "鸡飞狗走", "糟心", "木头木脑", "记恨", "杀人如蒿", "俯仰随人", "失着", "不得劲", "骂天咒地", "贪墨", "遭劫", "扫墓", "逾闲荡检", "谗口铄金", "好胜", "凡偶近器", "放虎归山", "视为兒戏", "恭惟", "百思不解", "拣精拣肥", "闹哄", "鼓眼努睛", "心绪如麻", "寂天寞地", "鱼鲁帝虎", "烂醉如泥", "禽兽不如", "哭穷", "平铺直叙", "语近词冗", "崇洋", "败坏", "腿子", "癣疥之疾", "白字", "胡思乱想", "添盐着醋", "别生枝节", "先意承指", "算帐", "生造", "苟延残喘", "丧天害理", "槛花笼鹤", "恶语中伤", "凤毛鸡胆", "人为刀俎，我为鱼肉", "左顾右盼", "淆惑", "海市蜃楼", "浊质凡姿", "掩耳盗锺", "拉杂", "有声没气", "出圈儿", "追根问底", "枉直同贯", "杂乱", "脾气暴", "娇生惯养", "挂羊头卖狗肉", "屈节", "贪小", "面是心非", "贵人多忘", "诱拐", "唯命是从", "捣毁", "固执成见", "慢悠悠", "冤大头", "推谢", "弄嘴弄舌", "傻里傻气", "冷眼", "作乱", "豺狼当道", "偷安", "贰臣", "食不厌精，脍不厌细", "呜鼓而攻攻之", "虚荣心", "骄矜", "失序", "长材小试", "过甚其辞", "营私作弊", "抑郁不平", "低贱", "故步自画", "铁血政策", "酒池肉林", "虚度年华", "诡言浮说", "乌合之众", "落落寡合", "瓮尽杯乾", "牛蹄之涔", "唇枪舌剑", "物欲", "烈日当空", "甜嘴蜜舌", "逐末弃本", "蔽聪塞明", "歪曲", "扯腿", "倒行逆施", "恃勇轻敌", "天低吴楚，眼空无物", "寸步难行", "束手束脚", "只字不提", "三期贤佞", "百无一是", "破烂", "贪夫殉利", "践规踏矩", "老态龙钟", "见风是雨", "打破", "有头没脑", "敌酋", "仰人鼻息", "犯规", "众口铄金", "leecher", "自顾不暇", "旁门左道", "落伍", "呼昼作夜", "直愣愣", "不文不武", "掉价", "假装神圣", "刑辱", "冥思苦索", "夏虫不可以语冰", "直情径行", "多凶少吉", "臭棋", "滞呆", "骨鲠", "灾星", "碌碌", "一无所能", "掣肘", "狗续侯冠", "徒劳往返", "高慢", "灭门绝户", "埳井之蛙", "偷袭", "添油加醋", "播糠眯目", "媚世", "鸡犬升天", "扬扬得意", "未可厚非", "狐假虎威", "侜张为幻", "昂贵", "轻言肆口", "败诉", "不可胜言", "噪叫", "旁门外道", "摇头摆脑", "敏感", "助人下石", "密谋", "人多势众", "死而无侮", "格格不入", "超经济剥削", "倒果为因", "附膻逐腥", "毫末之差", "凶恶", "析言破律", "佛头着粪", "祟论宏议", "打躬作揖", "撒赖", "平淡无味", "得用", "如坠五里雾中", "切齿", "百般刁难", "添油炽薪", "披毛求疵", "冗杂", "搬斤播两", "不干不净", "保皇", "左袒", "陷于", "急攻尽利", "蚕食", "心术不端", "狂乱", "庸才", "冤屈", "揭露", "魔怔", "积郁", "做鬼做神", "意气洋洋", "噪嚷", "窝囊废", "难人", "柔筋脆骨", "空想", "乱兵", "投间抵隙", "近视", "把戏", "乘虚而入", "哄骗", "挑三嫌四", "自相水火", "漏洞百出", "报复", "坐愁行叹", "讹诈", "侵略", "小视", "自傲", "诱导", "没脸", "不整齐", "皮相之谈", "偷安旦夕", "淫辞邪说", "邪心", "兔头麞脑", "燕雀安知鸿鹄之志", "语无伦次", "屈辱", "是非口舌", "鲍鱼之肆", "违误", "太平无象", "谬论", "志大才疏", "舍近务远", "木讷", "篡权", "迷昏汤", "大话", "顾影弄姿", "飞语", "心潮", "英雄气短", "千仇万恨", "JJWW", "打蔫儿", "此地无银三百两", "斥逐", "极重难返", "执性", "不成", "讨价还价", "玩世不恭", "一头儿沉", "下脚货", "冤孽", "养痈遗患", "要死要活", "假造", "气包子", "敬小慎微", "卑猥", "胡思乱量", "肓干", "进退触籓", "作恶多端", "刺杀", "原形", "酒后之勇", "偷懒", "虐政", "貌离神合", "发傻", "拉下脸来", "凶犯", "逐臭之夫", "毁钟为铎", "死模活样", "有始无终", "没精没彩", "淘神", "横抢硬夺", "颦蹙", "打草惊蛇", "骨瘦如柴", "营营苟苟", "敌国通舟", "轩然大波", "割裂", "靖言庸违", "杀人如蓺", "伎俩", "外厉内荏", "浮光掠影", "争名夺利", "污辱", "贪生畏死", "丑行", "梁上君子", "束马悬车", "云心水性", "盛名之下，其实难副", "背恩弃义", "吃大锅饭", "画地为牢", "奉行故事", "豆萁燃豆", "智者千虑，或有一失", "未受过教育", "蛀蚀", "坏话", "见神见鬼", "哓哓不休", "锱铢必较", "改窜", "卖妻鬻子", "贪戾无厌", "屈膝", "背运", "撩火加油", "无动于衷", "煽惑", "浮艳", "烦扰", "虚礼", "流毒", "愁眉紧锁", "扒手", "书生气十足", "乌烟瘴气", "沉冤莫白", "烦闷", "打岔", "套交情", "东躲西藏", "责罚", "心眼小", "察见渊鱼", "过街老鼠", "朝梁暮晋", "胡诌", "妖物", "钻牛角尖", "刺痒", "风雨如磐", "滥官污吏", "倒胃口", "赤贫", "主观主义", "交恶", "一步一鬼", "老赶", "锋芒不露", "委靡不振", "呕像", "缩手缩脚", "寄生虫", "狗头鼠脑", "虚造", "呼牛作马", "放僻淫佚", "阿飞", "坏法乱纪", "浊浪", "无特色", "蛀齿", "钻营", "诘曲聱牙", "五斗折腰", "找茬儿", "拱手让人", "好肉剜疮", "不为人知", "撒谎", "龟毛兔角", "拾人牙慧", "遗祸", "浑身解数", "摇摆", "贪嘴", "停辛贮苦", "窃国", "鲍鱼之次", "误导", "侮蔑", "数黑论黄", "老虎屁股摸不得", "计出无奈", "沉闷", "婊子", "疾首蹙额", "以怨报德", "参差不齐", "一钱如命", "要挟", "刻舟求剑", "顺风使帆", "诞罔不经", "殷忧", "生事", "封建", "鬼头鬼脑", "逍遥自娱", "同室操戈", "惟口起羞", "血流如注", "没有头脑", "末学肤受", "灾祸", "安于", "打掉牙往肚子里吞－有苦显不出来", "进退无所", "元龙高卧", "头昏脑闷", "顶嘴", "不知高下", "横徵暴赋", "矮子", "嗓子不好", "刺目", "游戏笔墨", "地煞", "难忍", "卖俏", "宿怨", "无道德观念", "孔方兄", "词不达意", "饰情矫行", "草野", "衣衫不整", "拘牵", "讨便宜", "土牛石田", "里通外国", "不知死活", "城下之盟", "死硬", "强告化", "越轨", "责骂", "夏虫疑冰", "一知半解", "人穷智短", "顾犬补牢", "转死沟壑", "不知痛痒", "无所重轻", "西晒", "吹求", "鄙夷不屑", "市井之徒", "触犯", "权欲熏心", "投卵击石", "无节制", "斗而铸兵", "村俗", "鸢肩豺目", "骂天扯地", "苟合取容", "逐臭", "迷而不返", "打谎", "一本正经", "诬告", "作壁上观", "死硬派", "纠缠", "随风使舵", "庸懦无能", "百舍重趼", "弱智", "买空卖空", "唐突", "贴金", "冰山难靠", "邪路", "狗头军师", "高不成，低不就", "溽热", "糟烂", "巴人下里", "金口玉言", "乖张", "废话连篇", "嫌忌", "不堪", "谩天谩地", "好人", "老调重弹", "荒疏", "志满气骄", "三尸五鬼", "认贼为子", "不足齿数", "损伤", "袖手旁观", "浑浑噩噩", "附势趋炎", "伤化败俗", "信口开河", "奇丑无比", "漫不经心", "不平等条约", "添枝接叶", "上窜下跳", "沽激虚名", "委屈求全", "饾饤堆砌", "男盗女娼", "天之戮民", "苦战", "赃贿狼藉", "病床", "神头鬼脸", "吝啬", "坠溷飘茵", "脏字", "炮制", "乱伦", "焦虑不安", "败家", "猫腻", "弱点", "腐旧", "索然寡味", "假道学", "隔靴抓痒", "骇状殊形", "进退无依", "古董", "罢工", "令人厌倦", "按图所骏", "欠缺", "失之千里，差若毫釐", "漫不经意", "摆份儿", "吞剥", "借古讽今", "痈疽", "宗派", "打家截道", "拿腔作调", "文过饰非", "荒淫无耻", "兔崽子", "纵容", "托派", "背叛", "毫无意义", "专横跋扈", "狗崽子", "漏洩春光", "祝鮀之佞", "天下乌鸦一般黑", "爱面子", "暗昧", "丧师辱国", "豪干暴取", "率尔操觚", "卖空买空", "闲扯", "诬陷", "怪模怪样", "愚昧无知", "B4", "忍心害理", "铁公鸡", "嘀咕", "欲盖弥彰", "瞎吹", "不可逾越", "谪居", "本位主义", "折磨", "以致", "扯皮", "王八蛋", "驴脣不对马嘴", "松懈", "榆枋之见", "好酒贪杯", "奸诈", "低眉顺眼", "径情直遂", "无的放矢", "弄鬼", "去住两难", "半痴不癫", "暴徒", "欺凌", "鄙吝", "一触即溃", "假誉驰声", "按图索骥", "罪当万死", "鱼龙漫衍", "淫心匿行", "倒打一瓦", "挑刺儿", "病殃殃", "冲撞", "敌视", "看不顺眼", "奸商", "撇弃", "观眉说眼", "骑鹤上维扬", "草鸡", "托庇", "遮丑", "道旁苦李", "攀龙附凤", "祸心", "打手", "刺儿头", "赏罚无章", "凶气", "媚骨", "迟到", "不敏", "豆萁相煎", "歪斜", "破门而入", "拖人下水", "为所欲为", "盗窃", "陈腐", "败俗伤化", "借交报仇", "吹毛求疵", "自满", "申饬", "凿骨捣髓", "煮豆燃萁", "泥沙俱下", "刚戾自用", "狠心", "耍笑", "作难", "搅乱", "口似悬河", "看人行事", "下第", "大头小尾", "阴谋诡计", "祸不旋踵", "王八", "乖戾", "坐视不救", "流言混话", "虚报", "直言贾祸", "嫉妒", "怒斥", "騃童钝夫", "乐嗟苦咄", "打入冷宫", "簧鼓", "犯禁", "笨拙", "捧头鼠窜", "追查", "拙笨", "见钱眼红", "阿尊事贵", "黑暗", "五毒惧全", "反裘负当", "丰墙墝下", "贪墨败度", "冷噤", "谩天昧地", "虚谎", "欺人太甚", "吹胡子瞪眼", "豺狼当路", "水泄不通", "逐末舍本", "恶紫夺朱", "剩菜残羹", "矮子看戏", "讬之空言", "呼牛呼马", "险诈", "人言啧啧", "逊色", "LM", "古怪", "困窘", "私相授受", "现行", "煽诱", "视若路人", "弃旧怜新", "怨府", "狼贪鼠窃", "名存实亡", "泥猪疥狗", "风言影语", "分肥", "壁垒森严", "划一不二", "武断", "痴呆", "孱弱", "独是独非", "不得要领", "病案", "放恣", "藏奸", "吵扰", "bt", "烦冗", "俛首帖耳", "惜指失掌", "放任", "揭不开锅", "高睨大谈", "大谬不然", "胁迫", "伪书", "受气", "无稽", "匪徒", "讥笑", "遭难", "使酒骂坐", "轻看", "跋扈", "愚鲁", "敲骨榨髓", "奢靡", "阔气", "弥天大罪", "斜睨", "盘根错节", "嚣浮", "失利", "歪不横楞", "狗东西", "人为财死，鸟为食亡", "忍气吞声", "马上房子", "幸灾乐祸", "倒彩", "敲骨吸髓", "玩时愒日", "高谈虚论", "先意承志", "逞性", "罪恶多端", "下气怡声", "不济事", "露马脚", "弃甲倒戈", "混作一谈", "病歪歪", "年久失修", "手脚不干净", "慢吞吞", "邹缨齐紫", "假虎张威", "无所措手", "碰钉子", "不堪一击", "狐鸣鱼书", "剽窃", "鶗鴂彫卉", "东食西宿", "走后门", "横蛮无理", "挑么挑六", "枉曲直凑", "忌恨", "消极", "看不起", "权诈", "欺骗", "倦怠", "高自标置", "山颓木坏", "担心", "手眼通天", "鹊巢鸠踞", "视若草芥", "视如草芥", "杯羹之让", "不成才", "鸠居鹊巢", "隔靴搔痒", "暮色苍茫", "蜻蜓点水", "不值一笑", "无关痛痒", "混帐", "推聋作哑", "屠戮", "禽兽", "虚荣", "何所不至", "入海算沙", "洞烛其奸", "繁芜", "身心交病", "泼冷水", "淫言媟语", "败笔", "心烦意乱", "做鬼", "以邻为壑", "串通", "芜杂", "闻噎废食", "无般不识", "死无葬身之地", "急敛暴徵", "不痛不痒", "汉奸", "傻乎乎", "见识短浅", "人心叵测", "厚此薄彼", "纸醉金迷", "胆小", "焦躁", "匪祸", "为法自弊", "甚嚣尘上", "齿冷", "结驷联骑", "异己", "瘫痪", "夹枪带棍", "疑问", "驽钝", "盲从", "怪谲", "日坐愁城", "受骗", "轻生", "附赘县疣", "装相", "调三惑四", "矫饰", "背道而驰", "妄说", "扯谎", "倾覆", "讹赖", "匪帮", "拮据", "毒魔狠怪", "一误再误", "消沉", "繁杂", "闻风破胆", "闻风而逃", "心里堵得慌", "梧鼠五技", "对牛弹琴", "无天无日", "别嘴", "混水摸鱼", "偷生", "急就章", "惜力", "誓不两立", "学识谫陋", "气闷", "脆而不坚", "招权纳贿", "不择生冷", "志骄意满", "忘义", "邋遢", "受屈", "不可理喻", "令人困倦", "妒忌心", "外宽内深", "轻世做物", "叫苦", "造言生事", "猖獗", "同归於尽", "明枪暗箭", "惹草沾花", "二三其德", "瓦影鱼", "奸贼", "辱身败名", "无所適从", "恋酒迷花", "相煎何急", "橡皮图章", "不朗不秀", "假模假式", "附赘悬疣", "投机主义", "目空一切", "论短道长", "忽忽不乐", "故作高深", "偏心", "三翻四复", "失张冒势", "虚华", "八卦", "卖富差贫", "涩苦", "病根", "招风", "笑里藏刀", "舌敝耳聋", "人人得而诛之", "伪装", "唱独角戏", "狐狸精", "恶声", "背兴", "闲书", "缺乏才智", "异端邪说", "讹以滋讹", "口诛笔伐", "诡计", "何所不有", "稀松", "鼠窜狗盗", "懊丧", "吞没", "竹篮子打水", "小题大作", "板脸", "自暴自弃", "朝更暮改", "负俗之累", "鄙俗", "失时", "沉吟不语", "上楼去梯", "潦倒", "樗栎庸材　", "夜郎自大", "擅自", "诛求无已", "抉目吴门", "韩卢逐块", "闹脾气", "狐狸尾巴", "高傲", "狗咬吕洞宾", "破口大骂", "俯首帖耳", "阻力", "频仍", "无故呻吟", "寒伧", "助桀为恶", "冷风", "乖谬", "倒持太阿", "徒子徒孙", "曲意逢迎", "欲盖而彰", "没趣", "败火", "黝黯", "欺瞒", "逼宫", "窝工", "搞鬼", "散漫", "有失身分", "乔文假醋", "舛讹", "怨天怨地", "放任自流", "背时", "笼统", "鬻鸡为凤", "误伤", "贼头贼脑", "头昏目眩", "舐糠及米", "吞云吐雾", "打问号", "鼓动", "夜叉", "不才", "诱惑", "苛捐杂税", "国耻", "械系", "反裘负薪", "臭名昭彰", "踵迹相接", "低三下四", "大煞风趣", "两道三科", "嘴尖", "朝秦暮楚", "挑三检四", "可同患，难处安", "调唆", "犯忌", "妖妄", "黑话", "浇醇散朴", "狞笑", "招事惹非", "失足", "暴殄天物", "忧闷", "亡国之器", "冷嘲热骂", "循规蹈矩", "祸乱", "浑然无知", "泛泛而谈", "暴虐", "好高务远", "死眉瞪眼", "输理", "元恶", "劫掠", "碌碌寡合", "编派", "窃据", "横抢武夺", "歪打正着", "短处", "团伙", "鼠窜", "应声虫", "强压", "论资排辈", "忌妒", "夫子自道", "做作", "平白无故", "置若罔闻", "藐视", "重赏之下，必有勇夫", "小鞋", "夸夸其谈", "南箕北斗", "诛求无度", "不得其死", "泥古拘方", "莫名其妙", "淫荡", "贼眉贼眼", "姑宽", "妒意", "坐守", "同敝相济", "难受", "兔丝燕麦", "落架", "失口", "入侵", "滋蔓", "朽木", "讬公行私", "镜里采花", "颓风", "右军習气", "奴颜卑膝", "知白守黑", "诞妄不经", "诘屈聱牙", "碎瓦穨垣", "浮躁", "进退狼狈", "嚣张", "枉然", "奔突", "傻B", "手黑", "铁石心肠", "呵斥", "无地可容", "营私植党", "拿腔拿调", "令人作呕", "护短", "戴盆望天", "头痛", "无所用心", "耍子", "战争狂", "随波逐流", "申讨", "舍本求末", "不良", "榷酒征茶", "造茧自缚", "瞎话", "散伤丑害", "人头畜鸣", "胆大如斗", "质问", "不慎", "纷杂", "愚顽", "罅隙", "助桀为暴", "狗追耗子", "一犬吠形，百犬吠声", "狠吞虎咽", "谩辞譁说", "隐瞒", "含糊不清", "狼突鸱张", "偏枯", "负面", "惟命是从", "停辛伫苦", "趾高气扬", "多藏厚亡", "游手偷闲", "贫瘠", "狡狯", "浊流", "极情纵欲", "诱饵", "一盘散沙", "缩头缩脑", "黄口孺子", "耍心眼儿", "吹嘘", "诱奸", "敌国", "乖脣蜜舌", "一锹掘个井", "不识时变", "违犯", "妖冶", "挤占", "进退惟谷", "难吃", "头重脚轻", "恶名", "屈节辱命", "吃醋", "何所不为", "糊涂", "方头不劣", "捕风捉影", "俗不可耐", "管窥之见", "说情", "与世浮沉", "鬼混", "局骗", "意气", "神奸巨蠹", "头昏脑胀", "言不顾行", "调拨", "关碍", "豪夺", "凶暴", "破旧", "逆流", "不义", "烟霞痼疾", "重赏之下，必有死夫", "罢教", "煨乾就湿", "克扣", "呼么喝六", "庇护", "从井救人", "荒谬绝伦", "披靡", "哀梨蒸食", "唾壶敲缺", "浅嚐辄止", "刮地皮", "逐浪随波", "无空不入", "夏虫语冰", "头出头没", "画饼充饥", "遇事生端", "零乱", "侯门如海", "败将", "人穷志短", "粗犷", "冤愤", "鬼胎", "引虎拒狼", "离格儿", "臭气冲天", "挟冰求温", "错杂", "摘埴索涂", "迟误", "LJ", "包藏祸心", "肤见謭识", "口中雌黄", "盗卖", "迷迷茫茫", "小瞧", "头痛脑热", "迁延过时", "钻懒帮閒", "兵火", "烹狗藏弓", "雕心鹰爪", "土崩瓦解", "卑躬屈节", "骂街", "履舄交错", "放诞", "逐影随波", "腻烦", "人言籍籍", "脚气", "糯米粥里拌芡粉－愁上加愁", "踌躇不决", "掉以轻心", "凑热闹儿", "龙首豕足", "坟头上的乌鸦－人人憎", "进退迍邅", "虚文", "私仇", "炮筒子", "私生子", "愁肠", "滥竽充数", "搬脣递舌", "冷眼旁观", "酒食征逐", "冢中枯骨", "偷媚取容", "守株待兔", "贪天之功", "漏网之鱼", "困难重重", "专欲难成", "兽性", "魂摇魄乱", "无视", "加塞儿", "怡声下气", "买笑寻欢", "臭不可当", "装b", "迷天大罪", "唯利是视", "险阻", "坐井窥天", "钻天觅缝", "啬刻", "召之即来，挥之即去", "垂帘听政", "行尸走骨", "另起炉灶", "笨口拙舌", "拔葵啖枣", "顺口", "腥臊", "黑漆皮灯笼", "退有后言", "赏罚不明", "搬弄", "离本依末", "虚构", "疑云", "卖国求荣", "嫌长道短", "视同儿戏", "忧心如焚", "另眼看戏", "弊政", "厭齑暮盐", "冷血", "炮凤烹龙", "桀犬吠尧", "老不晓事", "手高眼低", "负约", "离经叛道", "愚民政策", "误入歧途", "鹊巢鸠佔", "有哭有闹", "奉迎", "析辨诡词", "流言风语", "负心", "辱国殃民", "负隅", "不由分说", "中饱私囊", "婆娘", "加膝坠渊", "笨头笨脑", "亵渎", "报仇雪恨", "违法乱纪", "乱麻麻", "假劣", "虚名", "苗而不秀", "深恶痛嫉", "狡焉思逞", "傍人篱壁", "一曝十寒", "不明不白", "跅幪不羁", "遭受", "祸从口出", "灰暗", "孤傲不群", "卖官鬻狱", "东窗消息", "油嘴油舌", "狗续貂尾", "头脑发热", "脱天漏网", "无父无君", "悬断是非", "扒窃", "附炎趋热", "骨鲠在喉", "阻遏", "滥竿充数", "蔫不溜", "舍本事末", "幽禁", "倭寇", "拘执", "食前方丈", "孽根", "致使", "图穷匕见", "歪风", "繁复", "下场", "包庇", "神譁鬼叫", "贪官", "傍人门户", "拗不过", "难看", "摇手触禁", "毒计", "SL", "冲犯", "一无长物", "暴民", "好容易", "三头二面", "辱国殄民", "低劣", "二缶锺惑", "狼藉", "扬扬自得", "克伐怨欲", "混淆不清", "谤书", "半路出家", "兽困则噬", "帷箔不修", "日中必熭", "死求百赖", "秕糠", "翻天", "旁敲侧击", "损人利已", "失检", "振振有词", "恶性", "淫朋狎友", "同美相妒", "寻弊索瑕", "贻笑大方　", "肝心涂地", "追踪", "麻木", "胡支扯叶", "无关大局", "躁急", "妨害", "吞言咽理", "便宜行事", "经心", "家贼", "耳报神", "抉目东门", "内难", "担雪填井", "暴君", "借酒浇愁", "各不相谋", "灭绝人性", "掉魂", "卖兒鬻女", "干枯", "不识之无", "白丁", "淫心", "松气", "没可奈何", "党同伐异", "腥臭", "故技重演", "搬石砸脚", "诬栽", "尸位素餐", "寒碜", "拙嘴笨舌", "雉头狐腋", "鹯视狼顾", "罅漏", "饭囊衣架", "浪子", "右倾", "兴妖作怪", "无人过问", "神经兮兮", "溜边", "把持", "泼辣", "粗拉", "胁从", "平板", "至毒", "放诞风流", "口耳之学", "臭名", "名过其实", "冷漠", "有声无实", "曾参杀人", "不知所为", "蜃景", "无拳无勇", "傲睨一切", "害人", "轻薄无行", "从心所欲", "荒淫无道", "言之无物", "调戏", "厌弃", "毛躁", "鬼迷心窍", "误点", "龙睁虎眼", "官官相护", "满脸愁雾", "据图刎首", "胯下之辱", "聚敛", "拾陈蹈故", "穷鸟入怀", "无风生浪", "似是而非", "拘泥", "村气", "咫尺之功", "求全之毁", "连篇累册", "饱暖思淫欲", "重气轻命", "睚眦之怨", "唇干口燥", "旧凋重弹", "远水不救近火", "小道儿消息", "鹰击毛挚", "谬妄无稽", "推脱", "唯所欲为", "粉饰太平", "脑中无数", "乳臭", "暴客", "内外交困", "贼眉鼠眼", "有气没力", "崇洋媚外", "馋猫", "摈除", "假门假事", "虚无缥缈", "欺人自欺", "外巧内嫉", "高自标树", "抱令守律", "犯急", "前科", "絮絮", "坐戒垂堂", "饱暖生淫欲", "无毛大虫", "胡搅", "逞凶", "寻花问柳", "乞食", "财迷心窍", "米珠薪桂", "无志", "挑弄", "放荡", "暮气沉沉", "毛举细故", "鸿都买第", "臭名昭著", "夸嘴", "切齿拊心", "毛子", "诋毁", "损之又损", "凌虐", "蛀虫", "是非颠倒", "鸡鸣狗盗", "灾年", "物欲横流", "性格内向", "吃偏饭", "不分皁白", "头会箕赋", "綦谿利跂", "题名道姓", "折足覆餗", "撞骗", "协私罔上", "闷葫芦", "科盲", "风云不测", "怨毒", "不容", "一潭死水", "惹祸招殃", "鸟声兽心", "嫌厌", "酷虐", "公然", "官逼民反", "食生不化", "雨后送伞", "多嘴", "如牛负重", "嘻笑怒骂", "油头滑脑", "虚话", "骂得狗血喷头", "贪荣慕利", "鹤背扬州", "欠妥", "观场矮人", "鼠类", "造作", "经济拮据", "徇情枉法", "茫无头绪", "口头禅", "蠢动", "毫不留情", "劣迹昭著", "谋图不轨", "虱处裈中", "行浊言清", "乱七八遭", "仗恃", "沸反盈天", "可恶", "自行其是", "趋奉", "求生害仁", "滥用", "挑食", "刀俎", "靡靡", "鹰瞵虎视", "献媚", "支离破碎", "抟香弄粉", "谋私", "杀人不见血", "呼群结党", "浮泛", "丧家之狗", "形同虚设", "妄动", "姑息", "马捉老鼠", "笑话", "冒名接脚", "声嘶力竭", "糟报", "浅显", "兵戎相见", "草寇", "打破醋坛子", "零零散散", "一隅之见", "老奸巨滑", "焦头烂额", "蛇吞象", "软裘快马", "不适", "败事有馀，成事不足", "竖子成名　", "偷鸡盗狗", "微辞", "河清难俟", "外宽内忌", "不识时务", "虚妄", "空洞", "板面孔", "犬儒", "憋闷", "愆尤", "韩卢逐逡", "同尘合汙", "居心不良", "玩日愒时", "才疏学浅", "臭气熏天", "拜金", "煮鹤烧琴", "谤议", "漏网", "马虎", "罪情", "政以贿成", "贫贱骄人", "刁蛮", "杀人灭口", "舞文弄法", "一推六二五", "市井无赖", "随方逐圆", "狂妄自大", "逐末忘本", "闪失", "勒抑", "土专家", "闷热", "不见天日", "以貌取人", "探囊胠箧", "鲁莽", "挥霍无度", "纷乱", "诘屈謷牙", "沉寂", "无恶不造", "耍滑", "黑手", "死有余诛", "有钱使得鬼推磨", "骑虎难下", "人模人样", "搅和", "告朔饩羊", "黑窝", "弊害", "铁幕", "澜倒波随", "惨杀", "猥辞", "长篇大论", "豢养", "劣等", "买笑迎欢", "迟疑", "享乐", "捣鬼", "铁蹄", "支离", "不知所从", "囊空如洗", "斗升之水", "为难", "曲学阿世", "乱杂", "减师半德", "瞒上欺下", "鹘突", "妄下雌黄", "天昏地暗", "铜臭满身", "赔累", "奸恶", "令人疲倦", "搓手顿脚", "无所措手足", "轻信", "杀鸡焉用牛刀", "狐裘蒙戎", "敌探", "狂躁", "草行露宿", "横恩滥赏", "食肉寝皮", "偏袒", "百般奉承", "进退触篱", "嘻皮笑脸", "官官相为", "冥顽不灵", "大放厥词", "霸道", "颓放", "鬼怪", "弃旧迎新", "癞子", "含牙戴角", "卷逃", "愁绪", "租心浮气", "头疼脑热", "枉物难消", "进退无据", "吹牛", "积毁销骨", "红眼", "各自为政", "怯弱", "自命不凡", "伪造", "胸无点墨", "凭空", "愁容满面", "投敌", "不甘心", "无目的", "玩火自焚", "忘乎所以", "醉生梦死", "拖延", "眼馋肚饱", "强制性", "愁绪如麻", "杀价", "坐于涂炭", "卖官卖爵", "邯郸学步", "琵琶旧语", "久束湿薪", "抱怨", "追究", "青面獠牙", "吞舟是漏", "钻皮出羽", "将虾钓鳖", "献疑", "琐碎", "为丛驱雀", "扣帽子", "抽抽儿", "坚额健舌", "白痴般", "蛀心虫", "浊重", "飞短流长", "瞎闹", "同恶共济", "凶狠", "食物中毒", "拐弯抹角", "超员", "妒忌", "拍马屁", "不识抬举", "霸王风月", "一口吃个胖子", "屁话", "狗走狐淫", "促狭", "借面吊丧", "挑唆", "飞扬跋扈", "有一套", "末流", "不三不四", "sb", "淫乐", "乖刺", "拿糖作醋", "问官答花", "低头哈腰", "鲸吞虎噬", "受苦", "难处", "不易", "谗害", "梗顽不化", "以冰致蝇", "刿鉥心腑", "随风倒", "三人成虎", "浮浅", "进退跋疐", "染指垂涎", "闹嚷嚷", "奸险", "笨伯", "马糊", "乌集之交", "唇焦舌敝", "鼠窜狼奔", "泄密", "帷灯箧剑", "鸠夺鹊巢", "渗入", "泥足巨人", "攫取", "连篇累帧", "曳裾王门", "诲淫诲盗", "麻烦", "元恶大奸", "谮下谩上", "赃款", "助天为虐", "摇尾乞怜", "软弱", "赃官污吏", "望风承旨", "东一榔头，西一棒槌", "卑贱", "贱视", "烦腻", "抛费", "浮报", "揉磨", "酒绿灯红", "呆傻", "乱民", "获陇望蜀", "暴虎冯河", "强不知以为知", "巧言花语", "差役", "出言无状", "犯法", "抢占", "柙虎樊熊", "咂嘴弄舌", "犹豫不定", "醋劲儿", "媚态", "以强凌弱", "作假", "玉粒桂薪", "胁肩谄笑", "无所不用其极度", "怙终不悛", "淫画", "雉伏鼠窜", "赖学", "抠门儿", "不直一钱", "手软", "外强中干", "抵赖", "海匪", "逼婚", "泥车瓦马", "贬责", "思凡", "行百里者半九十", "迁臣逐客", "靡衣媮食", "讹传", "灵牙利齿", "御用", "口耳相承", "将无做有", "将就", "不开化", "眼高手低", "醉死梦生", "无所忌惮", "妒嫉", "恫心疾首", "盲翁扪籥", "反目", "怜新弃旧", "自私", "戴高帽兒", "黄杨厄闻", "笔伐口诛", "傲慢不逊", "顶撞", "灰头灰脸", "哈哈儿", "单弱", "货赂大行", "滋生", "安于现状", "失学", "姘妇", "篡国", "灰头土脸", "可笑", "憨子", "碍事", "前愆", "滑头", "跋扈恣睢", "诡诞", "安富尊容", "朽木不雕", "立锥之地", "一孔之见", "三旨相公", "没什么了不得", "身名俱灭", "毒刑", "凶横", "不值一提", "罪恶昭著", "迷宫般", "有头无脑", "无了无休", "射利沽名", "狗血喷头", "不周", "地保", "投章摘句", "潜藏", "势焰", "讹以传讹", "执而不化", "低能儿", "庸俗", "闭关锁国", "顽劣", "歪理", "讨是寻非", "江淹才尽", "裘马轻肥", "不足为凭", "独裁者", "钓名欺世", "心如蛇蝎", "罢了", "蛆虫", "生搬硬套", "挑精拣肥", "头昏目晕", "稀糟", "闷棍", "营私", "别别扭扭", "乐新厌旧", "策划", "自私自利", "不肖子孙", "头面人物", "抹杀", "狐裘羔袖", "赤口毒舌", "眼皮子薄", "鼠臂虮肝", "排斥异己", "倒因为果", "嫁祸", "鲜衣美食", "守株待免", "恶衣恶食", "褊急", "浅尝辄止", "官官相卫", "胶鬲之困", "忧心忡忡", "狂暴", "例行公事", "管见所及", "招花惹草", "祸根", "明火持杖", "食子徇君", "披枷带锁", "不避汤火", "应卯", "作贼心虚", "柔茹刚吐", "道东说西", "贪位慕禄", "见风使帆", "犬牙交错", "错别字", "蠢蠢", "徒负虚名", "泽吻磨牙", "污七八糟", "户天胡帝", "鲁鱼亥豕", "阴黑", "乐极生悲", "奇谈怪论", "闲散", "雕虫小巧", "尘垢", "不知所以", "打肿脸充胖子", "背山起楼", "故伎重演", "败国亡家", "透顶", "穷忙", "钻隙逾墙", "兄弟阋墙", "困心横虑", "自投罗网", "多变", "假大空", "杨花心性", "刻板", "嘈杂", "旧恨新仇", "鬼瞰高明", "结仇", "教唆", "发酸", "过当", "鼠雀之辈", "溺爱", "握风捕影", "恶疾", "方便之门", "泛滥", "冷言热语", "脚镣", "余党", "啰里啰嗦", "酸文假醋", "扫荡", "使性傍气", "穷期", "闲杂", "佻薄", "荒诞派", "无教养", "自负", "尖酸", "贪吃", "违害就利", "不知羞耻", "杂乱无章", "尖刻", "猥贱", "吃不消", "寡言", "不足道", "成见", "附声吠影", "瘪三", "留难", "指山卖磨", "指桑骂槐", "贪惏无餍", "蛇头", "穿凿", "瞧不起", "过度", "诟病", "不耐烦", "救经引足", "樊笼", "牛马襟裾", "明火执杖", "抛弃", "目无三尺", "走投无路", "恶骂", "外强中乾", "目空馀子", "平淡无奇", "舞爪张牙", "受挫", "蚍蜉撼大树", "鬓乱钗横", "无根据", "疑心病", "非法", "野调无腔", "涎脸涎皮", "唱对台戏", "聊以塞责", "忍无可忍", "狡兔三窟", "腐蚀", "射鱼指天", "刺耳", "衣绣昼行", "贩毒", "扯后腿", "不仁不义", "众矢之的", "坐而待毙", "违条犯法", "平心而论", "怪异", "背地里", "言清行浊", "呼幺喝六", "尖嘴猴腮", "无礼", "九尾狐", "非分之想", "妄念", "进退两端", "壁上观", "食而不知其味", "左支右绌", "依违两可", "将天就地", "痴愚", "玉石不分", "无所畏忌", "哗世取宠", "牟取", "渔翁得利", "不识起倒", "哩哩啦啦", "怨詈", "跌份", "视如陌路", "迂气", "长恶靡悛", "夙怨", "扣盘扪烛", "旷日持久", "祸枣灾梨", "拱手听命", "偷天换日", "利锁名缰", "习气", "踌躇", "大逆不道", "孤僻", "穷奢极欲", "轻嘴薄舌", "重逆无道", "大言不惭", "软绵绵", "不了不当", "谬以千里", "罪行", "惨无天日", "鹤短凫长", "淆杂", "威信扫地", "东游西荡", "弱不禁风", "徘徊", "清规戒律", "作践", "言行相诡", "听风是雨", "负恩忘义", "一无可取", "欺侮", "鸡肠狗肚", "前言不搭后语", "冗官", "画地而趋", "末学肤受　", "老脸", "抖搂", "逾次超秩", "卖李钻核", "低卑", "如有所失", "低头", "一言难尽", "伪军", "小气", "表里为奸", "袍哥", "见利忘义", "恶狠狠", "窃据要津", "驴年马月", "易子而食", "鸡犬不宁", "讪脸", "淫风", "处心积虑", "哩哩罗罗", "奴颜婢睐", "其实难副", "啰唆", "贪杯", "鸮鸣鼠暴", "内幕", "罪孽深重", "利灾乐祸", "荧惑", "天打雷劈", "夸夸而谈", "黑心肠", "瞻前顾后", "不知利害", "蛇蝎为心", "嫉贪如雠", "诛戮", "傻劲儿", "诛求", "夸大其词", "犯上作乱", "不是味儿", "老狐狸", "赌博", "舆台", "叛卖", "两面派", "复辟", "打死虎", "漏洞", "费精神", "科头跣足", "心有余而力不足", "吆五喝六", "小黠大痴", "挈瓶之知", "蜗角虚名", "窑宅之所", "现成饭", "蒙在鼓里", "欺三瞒四", "识羞", "不见经传", "黔驴之技", "喙长三尺", "洋鬼子", "泯灭", "十死不问", "不对", "背倍弃义", "圆滑", "害兽", "调三斡四", "降本流末", "彻头彻尾", "阿党比周", "昏昏噩噩", "糟踏", "骄躁", "猖狂", "说闲话", "徒讬空言", "鼠腹鸡肠", "敛财", "丢盔弃甲", "贬黜", "盗用", "火上添油", "嘴甜心苦", "霸主", "东闯西踱", "卖友求荣", "夸诞", "迂谈阔论", "牵鬼上剑", "娄子", "往蹇来连", "一傅众修", "外祸", "排外", "深仇大恨", "贪求无厌", "秽气", "忘形", "恶醉强酒", "簧舌", "浮皮蹭痒", "对头", "狐裘尨茸", "调嘴学舌", "贪猥无厌", "捏弄", "聚讼纷纭", "雁过拔毛", "倚老卖老", "橡饭菁羹", "自作聪明", "徒有虚名", "舒头探脑", "兔角龟毛", "附庸风雅", "白眼相看", "虐杀", "不妥", "发横", "失当", "为虎作伥", "西崽", "顾忌", "放浪形骸", "人身攻击", "人头攒动", "诘诎聱牙", "未风先雨", "吵人", "见噎废食", "剜肉生疮", "言归正传", "焦眉苦脸", "呆小症", "假仁假义", "骄奢淫逸", "德性", "贸然", "无病自灸", "冤钱", "迂缓", "阿其所好", "喏喏连声", "挺胸凸肚", "暗娼", "不过如此", "仇怨", "附会穿凿", "作奸犯科", "堵心", "收成弃败", "烦恼", "乳臭未除", "替罪羊", "刖趾適屦", "蜕化", "衔冤", "冥顽", "轻率", "日暮穷途", "擿埴索途", "背义忘恩", "枉口拔舌", "尖嘴薄舌", "土气", "六亲不认", "懒洋洋", "墨守成规", "惑世诬民", "越境", "扎眼", "铢施两较", "丑闻", "用尽心机", "谄山傲下", "言而无情", "邪恶", "无精打采", "儿皇帝", "机心", "高自标誉", "捉襟见肘", "推三推四", "歇斯底里", "豪横", "头晕", "馋嘴", "擢发难数", "目论", "不近情理", "倒打一耙", "马腹逃鞭", "阿权膴仕", "蝇蝇", "强暴", "毁谤", "鬼魔", "吃寡醋", "不置褒贬", "嗫嚅小兒", "祸国殃民", "烦嚣", "吵吵闹闹", "失和", "超支", "懒惰", "亏负", "多嫌", "曲学诐行", "质非文是", "肤末支离", "傲慢无礼", "就事论事", "嗜杀成性", "摇尾乞伶", "慢慢悠悠", "谋杀", "胡言汉语", "指东画西", "千刀万剁", "松垮垮", "鼠盗狗窃", "大肆", "脏心烂肺", "倒持戈矛", "荒诞无稽", "凿空投隙", "诛尽杀绝", "卑陋", "独夫民贼", "老于世故", "邪曲", "伤教败俗", "谩骂", "身废名裂", "内乱", "出格", "失德", "搀假", "避而不谈", "一无所成", "安于故俗，溺于旧闻", "地区霸权主义", "头稍自领", "含血喷人", "此一时，彼一时", "串骗", "胡作乱为", "着忙", "糊里糊涂", "潢池盗弄", "阿谀谄媚", "大相径庭", "不辨菽粟", "存在主义", "靦颜事仇", "齐东野语", "惟利是视", "浅薄", "眄视指使", "丧德", "滞钝", "拆东墙补西墙", "孽种", "网漏吞舟", "百依百顺", "罪魁祸首", "耐烦", "生气", "贪夫徇财", "枉己正人", "病象", "屯街塞巷", "吃不准", "蒲柳之姿", "若有所失", "荆棘载途", "乡壁虚造", "失眠", "取巧", "偷声细气", "嫁祸于人", "饕风虐雪", "魔掌", "埋天怨地", "因缘为市", "巧言偏辞", "鹿驯豕暴", "狗眼看人", "多言多语", "马马虎虎", "小里小气", "断章取意", "疑义", "迷离惝恍", "权臣", "疙疙瘩瘩", "败军", "鄙俚", "朝梁暮陈", "通同作弊", "黄雀伺蝉", "渺小", "稀烂", "玩忽", "抵排", "悖言乱辞", "败露", "迂远", "夹带", "乘风转舵", "迂回曲折", "倾轧", "狎亵", "顺风使舵", "娇养", "呵佛骂祖", "官腔", "伐功矜能", "官报私仇", "钻穴逾隙", "狐唱枭和", "见风转舵", "失迷", "尊古卑今", "死性", "刻木为吏", "博士买驴", "陈规", "轻重倒置", "辱骂", "卖国贼", "臭乎乎", "坐地自划", "气焰熏天", "迷人眼目", "唱高调", "有限不识泰山", "受制", "贼心", "发怔", "鸣冤叫屈", "伤天害理", "浮头滑脑", "病虫害", "焚林而狩", "抱瓮出灌", "阙疑", "过府冲州", "心中无数", "姑妄听之", "横遮竖挡", "傲气", "寻欢作乐", "曲意承迎", "烦杂", "称薪而爨", "危言耸听", "酒囊饭包", "难上加难", "靡然顺风", "管中窥豹", "笨重", "粪土", "泼皮", "余食赘行", "拍马溜须", "摆布", "天下箸处", "旁摇阴煽", "托马斯主义", "饱其私囊", "目无余子", "迟缓", "饭来开口", "败絮", "未成熟", "不逊", "狞恶", "洗荡", "忍耐", "淫逸", "小圈子", "为渊驱鱼", "暗箭难防", "闹哄哄", "不近人情", "横行无忌", "八婆", "过甚其词", "瞧不上眼", "玄乎", "激进", "上天无路", "扇动", "无法无天", "玄奥", "半封建", "冬烘", "不扬", "见财起意", "不足取", "蛮不讲理", "牵扯", "如坐云雾", "煮鹤焚琴", "穷奢极侈", "螳螂捕蝉，黄雀在后", "偷窃", "俗套", "白眼", "空耗", "庞杂", "疙瘩", "孤恩负义", "卸磨杀驴", "逞性子", "村夫俗子", "单文孤证", "智小谋大", "鸠形鹄面", "妒贤嫉能", "贪墨成风", "贼去关门", "有失偏颇", "嘟嘟囔囔", "饰非掩过", "怨入骨髓", "任其自然", "偏听偏信", "故技", "玉食锦衣", "绑匪", "实繁有徒", "不问三七二十一", "不入时宜", "九阍虎豹", "背债", "等闲视之", "两脚书橱", "少不更事", "子虚", "惶惶不安", "威胁", "养尊处优", "免开尊口", "暴力", "结驷连骑", "罪孽", "狡诈", "千人诺诺，不如一士谔谔", "长舌妇", "无价值", "居心叵测", "束教管闻", "文身翦发", "草包", "胡诌八扯", "以耳为目", "吐丝自缚", "虚设", "乱子", "凛若冰霜", "剑戟森森", "闭气", "小辫子", "推三阻四", "吃独食", "挑拨", "思归其雌", "丑化", "钻牛角尖儿", "游蜂戏蝶", "巧作名目", "杂七杂八", "敲诈", "摧眉折腰", "曝露", "怀鬼胎", "叶公好龙", "老一套", "古奥", "轻视", "外心", "胡言乱道", "汹汹", "知情不举", "无常", "丑剧", "质次价高", "痴肥", "明抢", "鬼怕恶人", "旁若无人", "恣无忌惮", "老汉啃甘蔗－咬牙切齿", "碍足碍手", "瓦解", "沾沾自喜", "雕虫末技", "心眼儿小", "泛泛", "郁郁不得志", "腥风血雨", "牵强", "怅然", "言不尽意", "失态", "牖中窥日", "皱巴", "洗垢索瘢", "胫大於股", "静言令色", "因果报应", "杀人不眨眼", "周旋", "不好过", "大呼小叫", "两面二舌", "窝囊", "京京", "嫌好道歉", "罢职", "毒谋", "败北", "浑抡吞枣", "委国听令", "前倨后恭", "私欲", "人情冷暖", "鬼计百端", "屈理", "装模作样", "桎梏", "辜负", "论黄数黑", "驽马铅刀", "搅扰", "鸮心鸝舌", "蹉跌", "逃票", "断鹤续凫", "恶习", "超生", "貌合心离", "桃李之馈", "随人作计", "歉收", "抟沙作饭", "破财", "秽闻", "赌咒", "侵入", "丑史", "有口无行", "不悦", "噪聒", "诡诞不经", "政出多门", "下陵上替", "铸木镂冰", "随波逐浪", "四分五裂", "故纸堆", "骈枝", "哜哜嘈嘈", "毁约", "血口喷人", "大做文章", "忍辱含垢", "不待见", "面谩腹诽", "惹火烧身", "违天害理", "苦心经营", "一意孤行", "瞒骗", "坏事", "神短气浮", "侵渔", "虚骄", "狮子大开口", "凶年", "辞不达意", "两头三面", "邋邋遢遢", "狡焉思肆", "烂账", "温吞", "胆大心粗", "貌合神离", "HC", "可疑", "贵古贱今", "鬼蜮伎俩", "目使颐令", "十转九空", "窃取", "放肆", "兵强则灭", "闲逛", "造作矫揉", "亏心", "狐朋狗党", "草率收兵", "口沸目赤", "赔钱", "不合理", "欠佳", "懊糟", "叨叨", "软弱无力", "轻贱", "寡情薄意", "轻慢", "不着调", "捏一把汗", "杜门却扫", "见死不救", "长他人志气，灭自己威风", "析辩诡辞", "系风捕影", "利诱", "鄙陋", "沉沧", "劣种", "明目张胆", "画蛇添足", "焚林而畋", "骄傲自满", "同恶相党", "左右袒", "进退狐疑", "贫困", "结怨", "戴高帽子", "愚味", "屠夫", "死乞百赖", "亏空", "吃无名醋", "六道轮回", "猫鼠同乳", "非人", "钻心", "溜之乎也", "怪圈", "撺掇", "自欺欺人", "仁柔寡断", "绞尽脑汁", "奔走钻营", "剜肉成疮", "假冒伪劣", "表面化", "暴政", "以其昏昏，使人昭昭", "锋芒必露", "起疑", "空头", "进道若退", "枯本竭源", "猥亵", "文牍主义", "诈败佯输", "判若云泥", "执拗", "无可救药", "天华乱坠", "游荡", "卖不掉", "违纪", "一手包办", "鸠僭鹊巢", "黄口小儿", "自寻烦恼", "烦文缛礼", "头梢自领", "道路以目", "予取予携", "讨人嫌", "劳民伤财", "庸碌", "薄弱", "批评", "胶柱调瑟", "牵丝攀藤", "名高难副", "浮漂", "单见浅闻", "三风十愆", "花花世界", "吃劲", "拒谏饰非", "予取于求", "暗沉沉", "没用", "顾小失大", "临阵脱逃", "耳食之谈", "心硬", "毒素", "夤缘", "井底之蛙", "望门投止", "狷急", "浮光略影", "先意承旨", "帮腔", "室怒市色", "窃夺", "看不惯", "愁肠寸断", "刁钻", "抨击", "漠然", "穷极潦倒", "撒村骂街", "繁重", "荆棘满途", "枉口嚼舌", "一朝权在手，便把令来行", "酒病花愁", "骑鹤上扬", "筑室道谋", "拈轻怕重", "马勃牛溲", "不经之语", "奸笑", "道傍苦李", "逃兵", "蒙难", "胁肩低眉", "狼餐虎噬", "望梅阁老", "如蚁附膻", "废旧", "逼供", "雄心豹胆", "诞谩不经", "阴凝冰坚", "酣歌醉舞", "暗锤打人", "夷平", "蠕蠕", "沽名要誉", "掩目捕雀", "害处", "没理", "点金成铁", "匪盗", "日食万钱", "枘圆凿方", "无知", "三心二意", "盛气凌人", "息事宁人", "疏放", "背本就末", "妖魔", "进寸退尺", "两两三三", "闲愁万种", "随风倒舵", "独裁", "不阴不阳", "大权独揽", "闹别扭", "泼妇骂街", "无情少面", "地主阶级", "九世之仇", "不安于室", "力不从心", "肆言谩骂", "每况愈下", "荒诞", "因循坐误", "薏苡明珠", "暴戾恣睢", "罪不容诛", "轻薄无礼", "豪迈不群", "故作玄虚", "放刁撒泼", "沽名", "侮慢", "轻侮", "偏安", "阴私", "引车卖浆", "倔头倔脑", "喽啰", "鼠目寸光", "暮夜无知", "锁链", "噩运", "漏卮", "NND", "拘谨", "沐猴而冠", "荆室蓬户", "骂大街", "蚕食鲸吞", "涉嫌", "东掩西遮", "操之过急", "阴贼", "追根溯源", "俨乎其然", "脱误", "风流罪过", "败叶", "不得善终", "惨无人理", "贫嘴", "小觑", "报仇雪耻", "说嘴打嘴", "赤裸裸", "契船求剑", "误解", "葊陋", "鹤怨猿惊", "人面兽心", "二奶", "言而不信", "愚夫愚妇", "买椟还珠", "死沉沉", "讨嫌", "跑龙套", "迷途", "语病", "黑不溜秋", "作态", "庸言庸行", "起哄", "卖法市恩", "窃窃私议", "弃车走林", "外感内伤", "金玉其外，败絮其中", "私自", "鼠迹狐踪", "势利眼", "调皮", "紧箍咒", "村话", "隔岸观火", "调嘴调舌", "谰言", "狂朋怪侣", "疯疯癫癫", "扩张", "裘弊金尽", "烧包", "云泥之别", "漠然置之", "依样画葫芦", "蛮横", "大院深宅", "专权", "癞蛤蟆想吃天鹅肉", "猎取", "距人千里", "蔑视", "疯癫癫", "乘人之危", "泥猪瓦狗", "极恶不赦", "有脚书橱", "狡计多端", "郊寒岛瘦", "掺和", "干干巴巴", "翻黄倒皁", "婚外", "玩岁愒日", "人面狗心", "乜斜缠帐", "视远步高", "恶兆", "生疏", "作奸犯罪", "挑动", "进退无门", "勒诈", "哭闹", "封豨脩蛇", "厮混", "莫须有", "颓唐", "挤轧", "同流合汙", "干扰", "顽固派", "偷情", "主文谲谏", "灾病", "轩鹤冠猴", "一物不知", "轻言寡信", "干巴", "师心自用", "贪花恋酒", "心毒", "苛政猛于虎", "变相", "见溺不救", "恶居下流", "恶感", "诞幻不经", "涎皮涎脸", "宰割", "得步进步", "阿谀逢迎", "民不堪命", "驱使", "丑态", "不辩菽麦", "囚徒", "靠天吃饭", "神头鬼面", "栽脏", "强逼", "奴役", "喷有烦言", "束手待毙", "浮词", "批驳", "贪吃懒做", "过激", "叛逃", "私念", "置疑", "体规画圆", "过犹不及", "狼猛蜂毒", "渔霸", "早衰", "死心眼", "柔肠百结", "不得人心", "板着脸", "卖国求利", "窳劣", "现臭", "不劳而获", "涸泽而渔", "瞒心昧己", "槃木朽株", "进退无措", "拖后腿", "呆气", "拐卖", "攘夺", "亡不旋踵", "深文周纳", "醋意", "玄妙", "跷蹊", "蠹弊", "恶浊", "截胫剖心", "罢休", "讥讽", "居大不易", "现成话", "急死", "嫉贤妒能", "虚弱", "欠拍", "伴食宰相", "狼狈", "小时了了，大未必佳", "逃之夭夭", "失之毫釐，差以千里", "楞头呆脑", "含糊其词", "骂名", "唯命是听", "趁人之危", "像煞有介事", "居功自持", "不胜其任", "举棋不定", "穷困潦倒", "纤弱", "非驴非马", "曲曲折折", "泥猪癞狗", "苦乐不均", "兴师动众", "虚词诡说", "贼脏", "谄词令色", "眼馋", "抱薪救火", "好好先生", "眉来语去", "地痞", "疲顿", "乏货", "鸢肩羔膝", "熬心", "醋心", "招降纳叛", "望尘僄声", "贬低", "愚笨", "责斥", "漫天开价", "伪政权", "大人先生", "滞后", "闲篇", "拙嘴笨腮", "私弊", "含垢藏疾", "呵叱", "逾墙钻穴", "流氓", "爱管闲事", "毒手", "丑八怪", "损人害己", "焚林而田", "不脩边幅", "败家子", "张狂", "气味", "匹夫之勇", "今仇古恨", "越凫楚乙", "充耳不闻", "不值一文", "惯贼", "失迎", "贼赃", "人贩子", "讪皮讪脸", "横事", "繁缛", "恶心", "视而不见", "听之任之", "锦衣玉食", "与世俯仰", "食之无味，弃之可惜", "大吹法螺", "痛恶", "滔天", "司马昭之心", "耿耿于怀", "背谬", "BD", "滑泥扬波", "顾盼自豪", "妒能害贤", "无所适从", "不如意事常八九", "伧俗", "墙倒众人推", "皱巴巴", "不济", "晕船", "话柄", "镜花水月", "混蛋", "疲倦", "顺我者昌，逆我者亡", "鄙弃", "保不齐", "不通水火", "嬉皮士", "超重", "耽搁", "炫耀", "顾后瞻前", "叛乱", "抢劫", "背离", "呆钝", "发飙", "得意忘形", "染病", "杀害", "二流", "不及", "降颜屈体", "空话连篇", "拉交情", "蹭蹬", "阴差阳错", "破约", "鹊垒巢鸠", "淫糜", "罪愆", "世故", "盖不由己", "怀着鬼胎", "声色狗马", "烦燥", "娇滴滴", "介怀", "懒怠", "烟鬼", "失效", "坐失事机", "酸涩", "碎嘴子", "骨瘦形销", "无所不作", "干瘪", "货色", "离谱儿", "钻穴逾垣", "吊儿郎当", "不知高低", "诱发", "营私舞弊", "不尴不尬", "未足轻重", "误国殄民", "顺水人情", "包办代替", "崩溃", "昧心", "妇人之仁", "毒辣", "变色龙", "流言", "底下人", "盲用", "毙命", "没有勇气", "鸟尽弓藏", "文人无行", "众口纷纭", "失业", "东鳞西爪", "前不见古人，后不见来者", "悠悠忽忽", "坐吃山崩"}
#好
DUTIR_Haos = {"打破砂锅璺到底", "多彩", "披沙拣金", "见机行事", "精神饱满", "连更星夜", "比肩", "巴巴结结", "驷马高车", "精到", "盛赞", "喷薄欲出", "金言", "驷马高门", "忠厚", "富丽堂皇", "金碧辉映", "圆通", "填阬满谷", "镂金铺翠", "视民如伤", "君子一言，快马一鞭", "参天两地", "滋养", "伯埙仲篪", "优待", "推选", "屏气", "名学", "长枕大被", "研精殚思", "确凿", "崭齐", "卓然不群", "慷慨赴义", "渔利", "大直若屈", "马不停蹄", "鸾舆凤驾", "目光如炬", "可以信赖", "霞姿月韵", "强记", "逗趣", "矫健", "龙章秀骨", "屈高就下　", "春秋鼎盛", "嵬目鸿耳", "脆亮", "如胶如漆", "用心用意", "效忠", "相信", "全智全能", "谈若悬河", "弹冠结绶", "兵在精而不在多", "鹘入鸦群", "休休有容", "莹澈", "颊上三毫", "豪放", "救难", "雍容雅步", "肥腴", "说一是一", "七贞九烈", "并进", "鸿篇巨制", "相恋", "锵金铿玉", "比屋可封", "鹰觑鹘望", "攻苦食啖", "超卓", "不法常可", "不露圭角", "铿锵", "人定胜天", "断蛟刺虎", "雷令风行", "铜盘重肉", "舍身", "改柯易叶", "玉尺量才", "豁达", "民为邦国", "如虎傅翼", "容光焕发", "必由之路", "精奇", "帮同", "三台八座", "治学", "无偿", "丝思发怨", "披星戴月", "胡天胡地", "无所不可", "独辟蹊径", "不亢不卑", "尽心", "取信", "谈不容口", "有威信", "救人须救彻", "程门立雪", "把兄弟", "百折不挠", "慎重", "气度", "整整齐齐", "关爱", "龙吟虎啸", "富国强兵", "扣人心弦", "泰斗", "言出法随", "铁板歌喉", "有理有据", "雪亮", "颖慧", "挺秀", "浓郁", "生气勃勃", "雄豪", "彪炳千古", "心细如发", "风姿绰约", "钟爱", "手急眼快", "珍视", "还我河山", "青眼相加", "俛拾仰取", "文子文孙", "稚嫩", "福禄双全", "高尚", "历演不衰", "鸾音鹤信", "兔起凫举", "对症下药", "天作之合", "雄赳赳", "先导", "笃学", "茂盛", "名节", "皑皑", "黛蓝", "崧生岳降", "多姿多彩", "浩然之气", "食箪浆壶", "语重心沉", "天字第一号", "伏帖", "欢迎", "衣锦还乡", "清脆", "洋洋大观", "奋身不顾", "举世闻名", "强兵富国", "正义", "躬先士卒", "任用", "神抶电击", "瑶林琼树", "深根宁极", "亲切", "朴陋", "改弦更张", "经明行修", "斩关夺隘", "戛戛独造", "十载寒窗", "皎皎", "豪举", "寒花晚节", "博洽多闻", "神清气茂", "倾肠倒肚", "群雄", "远走高飞", "壮伟", "谦谦君子", "弃世", "含冤受屈", "年高望重", "简明", "打动", "回味无穷", "栉沐风雨", "徙薪曲突", "酌古参今", "幽美", "悠久", "及锋而试", "深明大义", "井底下的邮包－深信", "交口称誉　", "赞扬", "赞许", "虔心", "楚楚可人", "翻越", "献策", "眼明手快", "草木知威", "水滴石穿", "雄材大略", "逐鹿中原", "安如泰山", "攻无不克，战无不胜", "刚劲", "无一不知", "吞炭漆身", "达官显贵", "佯攻", "孝道", "破获", "纯洁性", "只争朝夕", "称意", "爱惜羽毛", "创造力", "高士", "跃跃欲试", "女中丈夫", "犀角烛怪", "宝珠市饼", "名不虚立", "冻浦鱼惊", "推襟送抱", "标新领异", "安危与共", "融融", "日旰忘餐", "高敞", "鹿车共挽", "踔厉", "无胫而至", "统帅", "春光明媚", "河山带砺", "千里之志", "豪气", "风流人物", "嘉肴", "高才远识", "坚劲", "壮志凌云", "质朴", "崔巍", "大放厥辞", "风华绝代", "善终", "才誇八斗", "悉心", "仙女", "亮晶晶", "简便", "器宇不凡", "工整", "白衣公卿", "过都历塊", "鲁连蹈海", "如入无人之境", "应典", "手不停挥", "儒雅", "一夫当关，万夫莫开", "因敌取资", "驯顺", "席不暇暖", "健谈", "远愁近虑", "化腐成奇", "鲜灵", "道地", "显亲扬名", "胆粗气壮", "圣贤", "益虫", "乌鸟私情", "响应", "勤苦", "言之凿凿", "民生在勤", "分毫不差", "一树百获", "书功竹帛", "能说会道", "夸饰", "出身高贵", "徐徐", "抖擞", "戴月披星", "百败不折", "元帅", "口诵心惟", "信托", "戴罪立功", "要言不烦", "娓娓", "与国", "耐用", "先人后已", "宋才潘面", "别具只眼", "见多识广", "偌大", "美言", "伟大", "安安静静", "无价之宝", "显身手", "实实在在", "天之骄子", "说一是一，说二是二", "不简单", "绝妙", "丰功硕德", "须眉交白", "连枝比翼", "心弦", "敬畏", "眉目勿画", "破除", "腹心", "早朝晏罢", "眼明心亮", "岂但", "不遗余力", "入迷", "魁梧", "敬贤礼士", "精明强干", "达人", "心照神交", "犀燃烛照", "豪情满怀", "膏腴", "补情", "澎湃", "闺英闱秀", "独擅", "不下于", "清贵", "牢固", "满腹诗书", "逷听远闻", "胆略兼人", "珠宝", "活泛", "璧坐玑驰", "所向克捷", "直诚", "桂酒椒浆", "疾风知劲草", "帮困", "非常热心", "文质彬彬", "食不重肉", "亲自", "杵臼之交", "无容置疑", "国手", "清正廉洁", "气候", "龙盘凤舞", "五体投诚", "正直无私", "硕果", "浸沉", "霞蔚云蒸", "粗豪", "金榜题名", "驱霆策电", "才气横溢", "敬慕", "芊芊", "宏朗", "含商咀徵", "国富民安", "焕发", "妩媚", "令人羡慕", "能掐会算", "无相无作", "国富兵强", "沉勇", "湖光山色", "止於至善", "朗朗上口", "胆识", "甜蜜蜜", "宽以待人", "胆大泼天", "其实", "庄静", "超擢", "稀珍", "正理平治", "粗犷", "确当", "风雅", "如履如临", "清风亮节", "典重", "骁勇", "知鱼之乐", "逸韵", "心甘情原", "整齐划一", "瑶林玉树", "大智如愚", "入理切情", "坚韧不拔", "十日所视，十手所指", "衷心", "水碧山绿", "连更晓夜", "俊秀", "宏才大略", "宾来如归", "杜渐防萌", "新生", "表白", "峥嵘", "纫佩", "进退可度", "谨严", "奥博", "置之度外", "景星凤皇", "大步流星", "迎头痛击", "一马当先", "友谊", "开口见胆", "柔润", "屁股蹲儿", "捐献", "如饥似渴", "报答", "达权通变", "强直自遂", "见世面", "健康", "有方", "心有灵犀一点通", "辉光日新", "报效", "谏诤", "果熟蒂落", "铁郭金城", "满怀豪情", "青出於蓝", "夕惕若厉", "芝兰玉树", "以沫相濡", "身当矢石", "竭诚", "不畏强暴", "钢铁长城", "高瞻远瞩", "握云拿雾", "富强", "耐心", "功力", "不媿下学", "柳绿花红", "方兴未已", "鲁阳回日", "归心", "雅爱", "一民同俗", "上辈", "血性汉子", "河汾门下", "苗条", "风恬月朗", "很有意义", "歌诵", "讲究", "畅行", "公尔忘私", "深根固柢", "拔萃出类", "晚食当肉", "受听", "能征惯战", "刚毅不讷", "使贤任能", "荡漾", "龙飞凤舞", "心慕手追", "不容置辩", "便利", "东箭南金", "一举两得", "一丝不苟", "公而忘私", "援助", "弃瑕录用", "痴长", "没齿难忘", "深情", "俐齿伶牙", "偕老", "抱负不凡", "靡坚不摧", "论议风生", "孜孜不怠", "袅袅婷婷", "日月入怀", "工致", "伸张", "无所不容", "鞠躬尽瘁", "解救", "鼎新", "讲理", "节用裕民", "接引", "迅速", "百花争艳", "怜贫惜老", "嫡母", "计深虑远", "承情", "救黥医劓", "初生牛犊般", "精明", "显贵", "身经百战", "动人心弦", "任重道远", "马革裹尸", "琼浆玉液", "歌功颂德", "探骊得珠", "温暖如春", "轻财贵义", "与物无忤", "无可置疑", "滔滔不竭", "铁狱铜笼", "甜美", "俏丽", "砥砺名节", "如虎生翼", "穷则思变", "劝和", "矢志不移", "兵来将挡，水来土掩", "郁郁沉沉", "精于", "老子婆娑", "千古不朽", "宝座", "经典", "奕奕", "爱憎分明", "诚恳", "风清月朗", "义气", "敬贤爱士", "娃娃拿到新玩具－爱不释手", "机灵鬼", "健实", "戛戛", "人和", "节约", "大胆包身", "才高八斗", "丹凤朝阳", "貔虎", "日升月恒", "忧国忧民", "格古通今", "任怨任劳", "谨饬", "百卉千葩", "温淑", "会来事", "涵容", "补天浴日", "端庄", "甘言美语", "胖子", "大无畏", "目不暇接", "破案", "握雾拏云", "得中", "撒手锏", "形胜之地", "素净", "金钗十二", "建功立业", "树德务滋", "奇光异彩", "浩大", "转赠", "风驰电掣", "巨匠", "精灵", "高着", "心地纯良", "名手", "抛掷", "瓜垢磨痕", "聪睿", "叹羡", "夸父逐日", "巨子", "红炉", "上策", "龙蟠虎伏", "历久不衰", "敬老尊贤", "渊图远算", "岳家", "目击道存", "公私两济", "饱学", "至友", "井然有序", "苍葱", "慈和", "恢宏", "删繁就简", "四海升平", "璀璨", "行侠好义", "粗衣粝食", "奋发蹈厉", "回乾就湿", "解语花", "悔罪自新", "芳馨", "过五关，斩六将", "春秋笔法", "必要", "琳琅触目", "风靡", "左铅右椠", "条入叶贯", "倾肝沥胆", "斩钉切铁", "慈怜", "单枪匹马", "见精识精", "率先", "人缘儿", "工稳", "刊心刻骨", "耳听八方", "尤异", "飒爽", "勇猛", "感谢", "誓死不贰", "恭敬", "遵奉", "良宵", "宝眷", "险峰", "清爽", "山容海纳", "百听不厌", "文君新醮", "踔绝之能", "柳莺花燕", "玉洁松贞", "锦囊妙计", "喜爱", "百步穿杨", "脱手弹丸", "通才硕学", "琴心剑胆", "货真价实", "良种", "鱼水相投", "秀色", "虎劲", "人丁兴旺", "祭奠", "腰缠万贯", "一刻千金", "骁悍", "扬威曜武", "敲金击石", "淳风", "娇弱", "断齑画粥", "追云逐电", "趣味盎然", "挺而走险", "水月观音", "养生送死", "巨人", "腾声飞实", "去伪存真", "呈递", "废私立公", "和盘托出", "为民请命", "原始要终", "齐心协力", "宽人大度", "向明而治", "浆水不交", "燎如观火", "有学问", "国尔忘家", "福至心灵", "助兴", "青云独步", "水木清华", "纰缪", "国故", "贵姓", "破崖绝角", "严明", "并重", "万顷之陂", "甘霖", "兼善天下", "贤妻良母", "功效", "书香门第", "分毫析厘", "骏足", "简质", "隽永", "尽力而为", "后浪推前浪", "红领巾", "再接再厉", "思贤如渴", "暗送秋波", "原汁原味", "乾净利索", "儒商", "治国安邦", "有朝气", "鲜妍", "众好众恶", "劝诱", "进贤达能", "云屯席卷", "赫赫有名", "鹡鸰在原", "奋勇", "欣欣然", "沥血披心", "献可替否", "订交", "亲密无间", "一语道破", "雄飞雌伏", "奔走相告", "舍间", "独步天下", "龙翔凤跃", "雨帘云栋", "纳降", "崇敬", "从良", "师出有名", "桃夭李艳", "貔貅", "起开", "呕心镂骨", "奉献", "屏气凝神", "悃幅无华", "恪守不渝", "澹泊寡欲", "舍己从人", "五体投地", "蒲柳", "毫不利己", "勤朴", "称赏", "栉比鳞臻", "高义薄云天", "死不旋踵", "生财有道", "才望", "逢山开路，遇水搭桥", "有识", "轻死重气", "仁爱", "言语流利", "家弦户诵", "谈吐风生", "剖毫析芒", "正兒巴经", "洁浊扬清", "鹭朋鸥侣", "励精图治", "莫逆", "别有见地", "敬若神明", "高才", "相庄如宾", "轻财重士", "缓急", "颖悟", "数得着", "事必躬亲", "爱称", "稀罕", "较德焯勤", "心驰神往", "划一", "金波玉液", "救危排险", "火眼金睛", "救济", "以直报怨", "力图", "阶级斗争", "情调", "霞明玉映", "计斗负才", "利息秋毫", "小不点儿", "著称", "雅量高致", "忘啜废枕", "试金石", "帖服", "壮士断腕", "百花齐放，百家争鸣", "见危授命", "待月西厢", "抬举", "坦坦荡荡", "旋律优美", "情真词切", "驰名当世", "十战十胜", "束身自好", "壮硕", "进旅退旅", "战鹰", "伶牙俐齿", "雷惊电绕", "婉丽", "明丽", "遇水架桥", "轻身重义", "涅而不淄", "冲锋陷阵", "经久耐用", "鼋鸣鳖应", "郁葱", "凉丝丝", "雷霆万钧", "面折廷争", "彪柄", "给面子", "圣地", "执法不阿", "解衣推食", "折节读书", "枕戈待旦", "琼浆", "天赋", "刚决", "宽厚", "丁香", "应付裕如", "妻梅子鹤", "气性", "攻陷", "窈窕", "击碎唾壶", "复旧如新", "海涵地负", "旺健", "昂昂自若", "安澜", "天上麒麟", "龙腾豹变", "含宫咀徵", "洞如观火", "廉洁奉公", "开山祖师", "尊称", "情意", "心明眼亮", "真真实实", "汗马功劳", "拙荆", "厚恩", "料敌制胜", "浩淼", "强识博闻", "活气", "面不改色", "领异标新", "一以贯之", "温良谦恭让", "求教", "洞见症结", "革新", "不忘故剑", "龙肝豹胎", "壮行", "鹤发童颜", "好说歹说", "三阳开泰", "朱脣玉面", "的真", "十发十中", "表里如一", "宽慰", "佳句", "老师宿儒", "造就", "聘请", "犀利", "请缨", "远垂不朽", "锦绣江山", "文献之家", "清平世界", "价值千金", "玉箫金琯", "淘沙取金", "闻一知十", "救急扶伤", "深远", "舍我其谁", "刿目鉥心", "成竹在胸", "千秋万岁", "拜请", "龙跃凤鸣", "以理服人", "调谐", "昼乾夕惕", "音调优美", "饶有余韵", "名著", "花魁", "沅芷澧兰", "尊奉", "相悦", "NB", "一字褒贬", "太山北斗", "看菜吃饭，量体裁衣", "行远自迩", "辩才", "比翼鸟", "不避艰险", "群英会", "架海金梁", "漂漂亮亮", "东南之美", "宠物", "大路椎轮", "玲珑", "蹈汤赴火", "刳心雕肾", "僻壤", "响晴", "见闻", "有纪律", "鬼哭栗飞", "一步一个脚印", "奔命", "考究", "八面威风", "国光", "娇婉", "知己知彼", "反躬自问", "蓬蓬", "秀外慧中", "流风回雪", "铁面无私", "舍命", "憨实", "信用", "拏风跃云", "少礼", "达标", "光可鉴人", "蕲求", "朱弦三叹", "流金铄石", "打拱作揖　", "丰富多彩", "毁家纾国", "鲁阳挥日", "奔袭", "圆浑", "深自砥砺", "辨如悬河", "挥日阳戈", "娇好", "鼓足干劲", "尊无二上", "远谋深算", "焚香礼拜", "朝贺", "流水不腐，户枢不蝼", "艺术家", "曲尽其妙", "每下愈况", "眷注", "悔过自新", "慈慧", "金声玉服", "贫贱之知", "凉爽", "着魔", "正道", "大肆厥辞", "追风蹑景", "黼蔀黻纪", "清华", "春色满园", "宏丽", "守口如瓶", "忠义", "珍藏", "清晰明了", "自信", "援外", "鲜眉亮眼", "镂骨铭肌", "前锋", "洪量", "渐入佳境", "劲旅", "贤淑", "赤胆忠心", "打破沙锅璺到底", "信赏必罚", "时贤", "宽敞", "警醒", "不错", "决胜千里", "老成见到", "忍辱含羞", "执着", "超人", "扫眉才子", "倩女离魂", "出口不凡", "素淡", "标兵", "平息", "正义凛然", "撒娇", "软香温玉", "推行", "拍手叫好", "辩士", "我踩", "佩服", "仔细", "忠言", "春心", "硬气", "鼎新革故", "红星", "騃女痴男", "安常处顺", "精彩", "新禧", "雄赳赳，气昂昂", "侃侃而谈", "矫捷", "平凡", "温情密意", "图腾", "冰肌玉骨", "真率", "权益", "景气", "朱脣皓齿", "上天入地", "珠围翠绕", "权变锋出", "分贫振穷", "国色天姿", "祝鲠祝饐", "莺啼燕语", "不同流俗", "斗士", "认认真真", "独领风骚", "先发制人", "青出于蓝", "功臣", "甘心瞑目", "一目了然", "必恭必敬", "分劳赴功", "视死如饴", "精选", "徇国忘身", "不看僧面看佛面", "深造", "一板正经", "唾地成文", "扶倾济弱", "金针", "顿挫抑扬", "嚼铁咀金", "金刚眼睛", "通险暢机", "父辈", "声如洪钟", "出类拔萃", "熟练", "雅量豁然", "星驰电走", "凤毛麟角", "神物", "眷顾", "芳泽", "善始善终", "雪白", "炽盛", "雄风", "赳赳", "戎马", "掀天动地", "鸾交凤友", "高人", "金玉", "高等级", "气度恢宏", "飞快", "匀调", "涓滴之劳", "洁身自好", "能干", "令行如流", "戴天蹐地", "博闻强志", "清逸", "清扬", "最好", "轴心国", "叫绝", "析肝沥悃", "超伦", "拜服", "真知灼见", "榜眼", "阎罗", "攻无不克", "忠忱", "高位重禄", "满腔热忱", "俭省", "金瓯无缺", "土阶茅茨", "逸趣", "谦尊而光", "声望", "令人鼓舞", "龙言凤语", "凤骨龙姿", "种瓜得瓜，种豆得豆", "拜恩私室", "凤叹虎视", "刚毅木讷", "第一线", "感激", "兴利除弊", "飘摇", "真情", "卫护", "上品", "玲珑透漏", "奖旗", "天生地设", "鸡鸣而起", "武艺超群", "光明正大", "通文调武", "精一", "文治武功", "深入显出", "桑弧蒿矢", "降贵纡尊", "怜香惜玉", "未为不可", "美不胜收", "枝叶扶苏", "好意", "宏旨", "贯彻", "欢喜冤家", "针砭", "荣辱", "坚贞不屈", "义诊", "同声相求", "英名", "相中", "天朗气清", "披襟解带", "死而后已", "朱楼碧瓦", "思路清晰", "弃邪从正", "合情理", "娇丽", "蒲鞭示辱", "王牌", "周而不比", "埋头苦干", "迫不及待", "离世遁上", "随和", "岸然", "披沥肝胆", "卓绝", "炯炯有神", "芬芳馥郁", "三好", "老黄牛", "禀呈", "如日方升", "解衣般礴", "同窗好友", "善类", "爱素好古", "亲属", "能写会算", "不丰不杀", "涣若冰释", "同德协力", "列功覆过", "方滋未艾", "搀扶", "独树一帜", "皎白", "马首是瞻", "无瑕疵", "1兒巴经", "悍勇", "跪叩", "驷马难追", "挂牵", "能手", "历世摩钝", "迷而知返", "知之为知之", "天下为公", "国事", "拳拳服膺", "金字招牌", "亲征", "好日子", "人急智生", "竹枝词", "胆大心细", "入眼", "临机应变", "禹惜寸阴", "心肝", "深情厚谊", "浑厚", "傲雪凌霜", "中庸之道", "辉煌", "毫发不爽", "清彻", "秀俊", "声气相投", "倒背如流", "对症发药", "试看", "五言长城", "闳识孤怀", "瞩目", "惟妙惟肖", "思如涌泉", "持重", "有鼻子有眼儿", "仁心仁闻", "佳儿佳妇", "之死靡二", "主力军", "千真万确", "上供", "枯骨生肉", "悬河泻水", "珠围翠拥", "丝毫不差", "清秀", "超凡脱俗", "铿然", "寿比南山", "解纷排难", "月地云阶", "面善", "随圆就方", "果刑信赏", "正理", "翻天覆地", "品味", "人证", "百川归海", "清通", "识荆", "反间之计", "品学兼优", "宜截了当", "没石饮羽", "追求", "硬手", "神通广大", "允执厥中", "绽放", "辉赫", "独胆英雄", "赴汤蹈火", "九间大殿", "举案齐眉", "谭言微中", "高朗", "刚肠嫉恶", "高节清风", "仰望", "行之有效", "赡养", "独占鼇头", "辟邪", "君子之接如水", "月夕花晨", "勇于", "人寿年丰", "朴拙", "风义", "以类相从", "博闻强记", "稳练", "有根有据", "祥麟威凤", "盛典", "欧鹭忘机", "健壮", "好说话", "稳如泰山", "红旗", "顽廉懦立", "进退有常", "累世通好", "请教", "深彻", "母爱", "长戟高门", "损己利人", "口直心快", "墩请", "薪火相传", "绸缪", "多艺多才", "飘渺", "娇嫩", "一见倾心", "微言大谊", "珠歌翠舞", "金镳玉络", "流水高山", "有进无退", "馨香祷祝", "精审", "夜以继日", "特产", "青梅竹马", "燕燕莺莺", "乐山乐水", "殚见洽文", "解囊", "柔情", "爱戴", "芝兰之室", "爱人以德", "赤心", "梯愚入圣", "郑重其事", "抑强扶弱", "晴好", "郁郁芊芊", "操持", "险隘", "撒痴撒娇", "三过其门而不入", "进退有节", "高风亮节", "以身殉职", "通人", "迷涂知反", "倾倒", "拼命", "清风劲节", "不绝如缕", "善感", "呈请", "无有伦比", "力挽狂澜", "热火", "勤俭", "恩荣", "春意盎然", "成全", "奇崛", "顶级", "钦赞", "仁义", "弃绝", "喜闻乐见", "神至之笔", "轻财好士", "不二法门", "文气", "耳鬓厮磨", "诗云子曰", "公道", "博学多闻", "能工巧匠", "革凡成圣", "指日可待", "杀鸡饮黍", "赏劳罚罪", "恬言柔舌", "锦标", "云起龙骧", "芳烈", "心细", "微显阐幽", "天下无难事，只怕有心人", "千里驹", "孝心", "怜我怜卿", "圆熟", "细心", "帮手", "冀望", "以一持万", "铺垫", "慷慨陈词", "磨砺", "洞达", "侠义", "河清人寿", "公平无私", "铢积丝累", "拜聆", "月里嫦娥", "心烦技痒", "河晏水清", "和平", "跑电", "推诚相见", "克肩一心", "倚重", "权力", "丰功盛烈", "回春妙手", "宽宏大度", "顶下", "地利", "容情", "得当", "冤家", "随物应机", "救星", "九鼎", "击赏", "宝重", "娇鸾雏凤", "拔山举鼎", "金壁辉煌", "风靡一时", "囊萤映雪", "惠而不费", "砺世磨钝", "端端正正", "投合", "方外之士", "肥沃", "众星捧月", "注目", "顾盼生辉", "英姿", "传世", "深藏若虚", "亮察", "仇人快语", "辞让", "贤能", "罹难", "浩浩汤汤", "葱茏", "左宜右宜", "发达", "臣门如市，臣心如水", "婉曼", "无施不效", "探赜索隐", "英姿焕发", "千古绝调", "屏息", "得力", "牛角挂书", "好手", "相好", "嘉名", "闻风而动", "龙腾虎蹴", "神色自若", "智慧型", "甜爽", "烈烈轰轰", "洞若观火", "千里之足", "柔韧", "目不转睛", "令人起敬", "高下在心", "对台戏", "惺惺", "敏悟", "伏龙凤雏", "忠孝节义", "白头偕老", "视人如伤", "乾净利落", "循名责实", "龙骧虎视", "解数", "守信", "报应不爽", "对景挂画", "麾之即去", "文章钜公", "正襟危坐", "冰魂素魄", "无量", "功德圆满", "贯通融会", "占理", "响彻云表", "林籁泉韵", "擿奸发伏", "国粹", "晴爽", "锋不可当", "出色", "佳作", "光车骏马", "铁嘴钢牙", "慈爱", "珍存", "好样儿的", "栩栩", "仙逝", "解闷", "忧国爱民", "龙盘凤翥", "雄深雅健", "凤毛济美", "颠扑不破", "恭恭敬敬", "统筹兼顾", "铁板铜琶", "下凡", "讴歌", "鸡犬无惊", "柔腻", "九天揽月", "锦心绣口", "割股之心", "因人成事", "攻关", "圣手", "商议", "咄嗟立办", "威风凛凛", "吃苦在前", "烈火乾柴", "言必行，行必果", "浑然天成", "革面革心", "不容怀疑", "能耐", "福分", "斑衣戏彩", "威武", "忠顺", "黄花晚节", "轻飘", "滑溜", "有成", "春风化雨", "繁庶", "见微知著", "倍道兼行", "好使", "识文断字", "青钱学士", "干干净净", "秦镜高悬", "赏识", "垂名竹帛", "赐教", "桃夭柳媚", "晴朗", "望其项背", "太平盛世", "详细", "适宜", "无施不可", "赏功罚罪", "拜将封侯", "改过迁善", "允执其中", "光芒", "讨恶翦暴", "戮力同心", "推举", "约请", "近便", "精雕细刻", "三头八臂", "青史留名", "憞信明义", "大礼", "和额悦色", "院士", "道路相望", "深历浅揭", "情深意重", "柔嫩", "王法无情", "打眼", "过得硬", "雄壮", "胸有成竹", "因人制宜", "廉政勤政", "一挥而就", "袅娜", "陶猗之家", "璞玉浑金", "花团锦簇", "娴淑", "进贤进能", "中流击揖", "王公大人", "从容不迫", "兄肥弟瘦", "紧凑", "随时制宜", "亲昵", "菲菲", "省事", "不念旧恶", "深仁厚泽", "猛虎深山", "地主之谊", "饶裕", "闭邪存诚", "纯稚", "枉驾", "满腹珠玑", "声振寰宇", "见缝插针", "交浅言深", "鲜货", "柔远能迩", "解衣盘礴", "兵舰", "轻车熟道", "劈手", "算无遗策", "摧朽拉枯", "富贵不淫", "竹苞松茂", "无私之光", "正经", "伟业", "稳实", "不费吹灰之力", "各显其能", "功碑", "节俭", "称誉", "雕章镂句", "有素", "地主", "爱怜", "平和", "隋珠和玉", "仪态万方", "错落有致", "辩护", "改过自新", "平衍", "宝卷", "垂询", "上校", "扶贫帮困", "开利除害", "体态轻盈", "浩博", "豪壮", "祥风时雨", "金石之言", "爽快", "尽善尽美", "判断正确", "倾向", "诤友", "英发", "长林丰草", "道高一尺，魔高一仗", "拾带重还", "动情", "推重", "仁人君子", "问安视膳", "慰劳", "翩翩", "鱼水和谐", "下笔成篇", "金石之交", "眼花缭乱", "不在话下", "洁身累行", "虎威", "改恶为善", "映月读书", "还礼", "尽态极妍", "从善如流", "性感", "百不失一", "东央西浼", "有眼力", "弃旧图新", "研精覃思", "啮血沁骨", "独创", "不拘形迹", "摩登", "仔仔细细", "千锤百炼", "格物穷理", "光采夺目", "支持一下", "惨绿年华", "得法", "英挺", "严格", "金兰契友", "不失毫厘", "露红烟绿", "嘘枯吹生", "阳春有脚", "贯通", "退旅进旅", "三贞九烈", "点缀", "热心", "夙夜匪懈", "甘之如饴", "山明水秀", "贤惠", "鸿篇钜制", "光耀", "大席", "龙肝凤髓", "墩劝", "荐举", "讷言敏行", "因时制宜", "后来居上", "景仰", "斗南一人", "肩荷", "任人唯贤", "千载一圣", "疲竭", "齐刷刷", "晖光日新", "清朗", "挺身而出", "准绳", "按强助弱", "一往情深", "撒娇撒痴", "深爱", "无其伦比", "开朗", "百年偕老", "至亲骨肉", "风流才子", "脱口成章", "披裘负薪", "良药", "五彩纷呈", "困而学之", "战无不胜，攻无不取", "明明白白", "好心", "克爱克威", "创新", "体贴", "万古不变", "执鞭随镫", "汗牛塞栋", "生寄死归", "可见一斑", "砥柱中流", "珠圆玉洁", "精娴", "渊谋远略", "骆驿不绝", "言近旨远", "嘉许", "端方", "嗳呀呀", "出水芙蓉", "匹敌", "日新月异", "如胶似漆", "热心苦口", "左右开弓", "天姿国色", "光鲜", "神龙马壮", "仰屋著书", "才疏志大", "讲礼貌", "守法", "簇新", "勤王", "排列有序", "无畏", "风度翩翩", "凿凿", "波尔卡", "奉令承教", "梗直", "持之有故", "丁是丁，卯是卯", "天子", "卓拔", "高峻", "求实", "推诚布公", "口吻生花", "鹄峙鸾停", "功成名遂", "暗室不欺", "心手相应", "略迹原情", "宝典", "党坚势盛", "八斗才", "余音缭绕", "沉雄", "地下党", "实话", "拜访", "柔和", "久经考验", "阔达", "昂扬", "敦聘", "想方设法", "学习", "弊绝风清", "铮铮铁汉", "应对如流", "兼爱", "扑扇", "轻灵", "元老", "浊泾清渭", "全能全智", "心知其意", "神工意匠", "殚智竭力", "破脑刳心", "企慕", "家学", "由衷之言", "傲然屹立", "别树一旗", "日以继夜", "履汤蹈火", "竹林七贤", "一不做，二不休", "功成不居", "明人不做暗事", "罪人不孥", "国本", "自己人", "金玉良言", "著作", "持平之论", "一针见血", "摩顶放踵", "翁中捉鳖", "才貌双全", "见危致命", "天仙", "格高意远", "垂爱", "神韵", "达官贵人", "进贤任能", "急起直迫", "燕歌赵舞", "恩深义重", "白骨再肉", "和而不同", "朝奉", "赏贤罚暴", "芳醇", "浑朴", "守望相助", "鱼鱼雅雅", "中流一壸", "称赞", "解困扶贫", "公评", "洋洋", "侍奉", "示好", "温柔", "目光远大", "审美", "佳人", "打先锋", "绝色", "跌宕昭彰", "真知", "恭候", "豪语", "气节", "有韧劲", "林下风韵", "啧啧称羡", "老当益壮", "昂首伸眉", "谨行俭用", "兵强将勇", "请战书", "噩噩浑浑", "智周万物", "不泄气", "扬威耀武", "珍品", "轻财仗义", "晴美", "葱绿", "肥甘", "彩旗", "绰约", "娇滴滴", "百家争鸣", "主体", "自出心栽", "破觚斫雕", "拱手", "量凿正枘", "义演", "情急智生", "斗妍", "美好", "忧国奉公", "倚马可待", "才干", "松柏后凋", "淳古", "乐善不倦", "不同凡响", "出蓝", "甘当", "从军", "君圣臣贤", "旗开得胜", "健步", "随群", "木人石心", "盖世英雄", "推心置腹", "坚持", "激薄停浇", "以文会友　", "名垂竹帛", "昂藏七尺", "高大", "应点", "洞视", "有始有卒", "贺表", "入定", "别提", "崇论宏议", "男子汉", "款留", "披胆", "平分秋色", "卓荦超伦", "智多星", "小心谨慎", "过人", "声誉鹊起", "妙言要道", "得名", "丰腴", "见可而进", "真挚", "刚克柔克", "跌荡风流", "柴立不阿", "赤心相待", "爱老虎油", "机变如神", "素雅", "投缘", "毫无保留地", "羡慕", "美意延年", "龙蛇飞舞", "饶有兴趣", "公门桃李　", "建树", "谦抑", "鸟枪换炮", "镕古铸今", "绘声绘色", "远征", "廓达大度", "泱泱大风", "蹈节死义", "起根", "撇脱", "无限", "秀异", "察言观色", "弃伪从真", "一日之长", "熟读深思", "师值为壮", "却金暮夜", "千红万紫", "浑然自成", "绘声绘影", "抱诚守真", "于家为国", "毕力", "无懈可击", "优质", "真正", "鼓吹喧阗", "夙夜不解", "称羡", "让位", "除暴安良", "牙签锦轴", "冰寒于水", "毅力", "因势利导", "红心", "气谊相投", "正梁", "详赡", "亨通", "振臂一呼", "虚怀若谷", "反听内视", "光华夺目", "跻身", "乖巧", "平权", "得手应心", "正规", "逊顺", "好心好意", "潺潺", "无所忌讳", "燃荻夜读", "智谋", "不恶而严", "不惜", "经世", "称谢", "宝藏", "积善", "居首", "医圣", "喜好", "颂德歌功", "头角", "德政", "银钩玉唾", "才识过人", "屋上乌", "热血", "孳孳汲汲", "扬名", "表里一致", "耽爱", "眼观六路，耳听八方", "上劲", "气吞山河", "有声有色", "尊老爱幼", "百岁千秋", "感佩", "ding", "百折不回", "展望", "比翼齐飞?", "衣冠楚楚", "青紫", "回天挽日", "挚切", "鉥心刿目", "慷慨解囊", "布衣蔬食", "助人为乐", "沥血披肝", "_ding", "稳固", "厚意", "陆离斑驳", "白头相守", "才高意广", "崇高", "对手", "宁肯", "直接了当", "输肝写胆", "光润", "爱慕", "傲然", "活宝", "才子佳人", "活分", "襟怀", "拳拳盛意", "车马盈门", "洪流", "鲁戈挥日", "赤胆", "培育", "手足之情", "撮科打閧", "清和平允", "视如珍宝", "偏宠", "体惜", "开心丸儿", "叔度陂湖", "双瞳剪水", "殚精竭力", "揽辔登车", "痛痒相关", "砥砺", "保家卫国", "檀郎谢女", "脂膏不润", "步步生莲华", "随行逐队", "白发苍苍", "随车甘雨", "护航", "齐全", "引人注目", "百发百中", "兴隆", "滔滔", "同恶相助", "上好", "昂昂", "人杰地灵", "铮亮", "迥然不同", "案无留牍", "战胜攻取", "志坚行苦", "翩若惊鸿", "改步改玉", "卑以自牧", "食不累味", "目如悬珠", "除旧布新", "天府之国", "景胜", "娇红", "良人", "勇壮", "专诚", "赞誉", "打抱不平", "铁打心肠", "鹏霄万里", "倜傥不羁", "铜铸铁浇", "可信赖", "因事制宜", "革面敛手", "可敬", "自力更生", "酒龙诗虎", "如花似月", "降尊纡贵", "根深叶茂", "长者", "稳拿", "珠璧交辉", "意志", "其味无穷", "恢廓", "玉洁冰清", "铢积寸累", "功成弗居", "贯斗双龙", "兴起", "同心并力", "富岁", "守1不桡", "涤瑕荡秽", "坚确", "深中隐厚", "英才盖世", "回敬", "如持左券", "下笔有神", "慧黠", "辞华", "敢勇当先", "岿然", "三复斯言", "一干二净", "心仪已久", "冬温夏清", "高雅简朴", "确定", "千金买骏骨", "相知", "天无绝人之路", "蕙质兰心", "舍身求法", "道义之交", "松茂竹苞", "开门见山", "昂首阔步", "情愫", "鹏程万里", "按时", "轻车简从", "天资", "赏罚分明", "洞鉴古今", "顺从", "魏颗结草", "韧劲", "奇才异能", "龙蟠虎绕", "屈尊", "老骤伏枥", "伐毛洗髓", "保盈持泰", "人格", "足智多谋", "不耻下问", "一介不取", "忠诚", "小可", "师傅", "看得上", "谦躬下士", "慈心", "辈出", "流连忘返", "卷甲衔枚", "浑然一体", "通材达识", "所向无敌", "通今达古", "劈脸", "智圆行方", "嫂嫂", "聪明伶俐", "钻天入地", "洗心换骨", "背碑覆局", "盛会", "姣丽", "春深似海", "了若指掌", "言者无罪，闻者足戒", "跌荡不拘", "落拓", "烈士", "含垢忍耻", "洁清自矢", "无可比拟", "厚望", "和煦", "莹白", "身手不凡", "浇瓜之惠", "博览古今", "赤心奉国", "赏不遗贱", "水火相济，盐梅相成", "荣谐伉俪", "行云流水", "交情", "名垂千古", "至品", "声名远播", "拔类超群", "独出心裁", "仁者见仁，智者见智", "般配", "青云", "山中宰相", "褒美", "行成于思", "气度不凡", "奖罚分明", "苍郁", "以身许国", "功均天地", "澄明", "平稳", "逢人说项", "内峻外和", "管鲍之交", "眼里揉不下沙子", "龙腾虎踯", "神武", "着力", "饮马投钱", "受过良好训练", "心灵性巧", "相机行事", "久要不忘", "高步阔视", "患难之交", "荣华富贵", "能事", "渴骥奔泉", "礼遇", "三年化碧", "赫奕", "仁厚", "送眼流眉", "出息", "如花似玉", "师长", "古典", "铁石心肝", "高顾遐视", "当仁不让", "大好河山", "相去无几", "举贤使能，举贤任能", "危言正色", "不食周粟", "风雨无阻", "名教", "道无拾遗", "戒骄戒操", "胆大於身", "血肉相连", "救灾恤患", "慈亲", "奖台", "声名大噪", "兼覆无遗", "虎头虎脑", "千了百当", "镂冰劚雪", "视死若生", "耳闻目睹", "勇敢者", "傅粉何郎", "摊书傲百城", "锦上添花", "披荆斩棘", "积极性", "融会贯通", "憨态", "入耳", "青郁", "蓝天生玉", "宁为玉碎，不为瓦全", "涵养", "追风蹑影", "千恩万谢", "晶莹剔透", "栉霜沐露", "不名一格", "前所未有", "争先恐后", "庸中皦皦", "千秋人物", "和易", "归真反朴", "含辛茹苦", "桃李成蹊", "如汤沃雪", "一片丹心", "干将", "鹤鸣九皋", "八窗玲珑", "经纶济世", "通好", "浓丽", "莺歌燕舞", "共贯同条", "巧取豪夺", "合理", "献身", "明心见性", "活形活现", "锐敏", "风节", "盛举", "铜脣铁舌", "井渫莫食", "同力协契", "至性", "适口", "默默无闻", "推荐", "抵御", "大杖则走", "急中生智", "笙磬同音", "令人神往", "与虎添翼", "翩翩少年", "麟角凤觜", "奇秀", "推心致腹", "超绝尘寰", "不爽毫发", "十年树木，百年树人", "雅洁", "造诣", "徇国忘己", "刚烈", "山肤水豢", "及时", "奋起", "日理万机", "横槊赋诗", "富国安民", "乐此不倦", "无可比伦", "能言快语", "快人快语", "姿色", "挚诚", "持盈保泰", "忧国忘家", "振奋人心", "碰巧", "高情远致", "不徇私情", "出生入死", "显祖荣宗", "谏鼓谤木", "乾脆利索", "随心", "善男信女", "能文能武", "毫发不差", "碰劲儿", "坦荡", "横翔捷出", "问一答十", "到家", "日角珠庭", "尊服", "磨穿铁砚", "勤俭持家", "精彩绝伦", "节俭力行", "胸怀坦白", "赤诚", "汗马之劳", "面目一新", "虚左以待", "随行就市", "银花火树", "旗帜", "龙章麟角", "你追我趕", "方闻之士", "鹰心雁爪", "云过天空", "献技", "深奥", "名特优新", "吐哺捉发", "掷地有声", "虎踞龙蟠", "技痒", "精确", "鬼设神使", "赏善罚否", "白净", "风虎云龙", "豁然开悟", "辩口利舌", "长驱直入", "体贴入微", "难解难分", "一心一德", "珪璋特达", "繁荣昌盛", "福地洞天", "引咎责躬", "大而全", "贤人", "拜托", "得宜", "确守", "头号", "主心骨", "似漆如胶", "贞不绝俗", "活用", "丰盈", "发扬", "千古独步", "师父", "英气", "大刀阔斧", "从命", "才艺", "赏钱", "事实胜于雄辩", "合浦珠还", "外简内明", "剖肝泣血", "华美", "壮发冲冠", "大法小廉", "郢人斤斫", "善举", "园丁", "轻淡", "崟崎磊落", "金玉之言", "隐居求志", "敬老恤贫", "置之死地而后生", "兔走鹘落", "秋毫无犯", "姣翠", "水佩风裳", "恩遇", "喝彩", "浑金璞玉", "敦本务实", "馨香", "人强马壮", "进贤黜恶", "削铁如泥", "一狐之腋", "金石良言", "确固不拔", "麟角凤毛", "温故知新", "钢筋铁骨", "生花妙笔", "慷慨", "栉风酾雨", "不折不扣", "成仁", "研精殚力", "廉明", "连枝共冢", "权威", "巧发奇中", "光滑", "瑰意奇行", "难分难舍", "低廉", "敌惠敌怨", "长于", "治国安民", "了不起", "如胶投漆", "如坐春风", "圭角岸然", "锦绣山河", "有贡献", "光彩耀日", "朴茂", "干净利落", "和蔼", "甲第连云", "彪炳春秋", "言之成理", "前贤", "可靠", "文武双全", "骏马", "乐土", "不蔓不枝", "死而不朽", "大旱望云霓", "书香世家", "玉宇", "雅正", "云程发轫", "戴圆履方", "神气", "无可厚非", "千里姻缘使线牵", "很有抱负", "谦虚", "热血沸腾", "涣若冰消", "亲操井臼", "白璧无暇", "盛产", "心小志大", "本草纲目", "龙颜凤姿", "劝善黜恶", "严师出高徒", "道高望重", "虎不食子", "精耕细作", "正骨", "花枝招展", "含蓼问疾", "极好", "扶危济困　", "朝乾夕惕", "百读不厌", "娇美", "晨昏定省", "饮胆尝血", "见贤思齐", "八字打开", "信实", "宏富", "万人空巷", "高耸", "三臡八菹", "怜爱", "明公正义", "善后", "情韵", "乘风破浪", "并蒂莲", "别出机杼", "熟谙", "踏踏实实", "众毛攒裘", "风韵", "明媚", "完好如新", "龙行虎变", "特长", "拔山超海", "金銮殿", "经邦纬国", "谱写", "哀求", "必定", "倍儿棒", "刮目相待", "誓以皦日", "具有压倒性优势", "绝好", "鸿渐之翼", "压轴戏", "卓尔独行", "鹤发松姿", "一琴一鹤", "委曲求全", "开明", "天尊", "煦色韶光", "驰名", "清顺", "壮土解腕", "崭露头角", "长技", "交好", "通幽洞灵", "厚往薄来", "通才", "富有成果", "坚固", "玉液金浆", "出以公心", "克勤克俭", "雅趣", "忘生舍死", "亲吻", "贞风亮节", "研桑心计", "敛锷韬光", "兼资文武", "不分彼此", "长进", "疑则勿任，任则勿疑", "赞不绝口", "舒适", "无可比象", "笔直", "救偏补弊", "日角龙庭", "秉正", "颂声载道", "解衣磅礴", "高端", "枕戈寝甲", "入室升堂", "动魄惊心", "发聋振聩", "待时而动", "万象更新", "不赖", "青天", "忠直", "洁身自守", "神乎其神", "拭面容言", "熙来攘往", "颊上三毛", "寸善片长", "中肯", "舍已救人", "冰壸秋月", "四平八稳", "滑润", "清纯", "果不其然", "长材茂学", "高足", "倡导", "谨始虑终", "婉娈", "殷殷", "商彝夏鼎", "祈求", "厚生利用", "不错眼", "打铁趁热", "怒蛙可式", "手到擒来", "自知之明", "户限为穿", "奶声奶气", "借身报仇", "德泽", "宁缺毋滥", "暖洋洋", "有利可图", "共识", "数得上", "自出机杼", "形输色授", "俏皮", "投刃皆虚", "前言往行", "意前笔后", "陶醉", "宠辱不惊", "嫡派", "以义割恩", "独出新裁", "文武之道", "雄健", "忍辱负重", "得胜回朝", "香醇", "眼疾手快", "锦篇绣帙", "朴实", "天衣无缝", "辅车相依", "脍炙人口", "状行", "适意", "直道而行", "龙章凤姿", "精核", "鲜嫩", "决断如流", "善人", "飘悠", "有凭有据", "文子同升", "琼瑶", "宵衣旰食", "赏鉴", "规重矩叠", "箴言", "商谈", "正义战争", "主观能动性", "禀赋", "风光月霁", "情投意合", "爽目", "挚友", "琅琅上口", "主子", "不落窠臼", "婉顺", "铢铢较量", "洒脱", "创造", "夭桃穠李", "舜日尧年", "后起之秀", "得行", "情人眼里出西施", "叠翠", "救时厉俗", "软伫", "雅人深致", "大慈大悲", "生荣死哀", "友人", "谢幕", "繁蔚", "种仁", "审时度势", "在行", "一板三眼", "精研", "洞究", "丽句清辞", "可心", "千闻不如一见", "心到神知", "洁白", "感人肺腑", "金友玉昆", "高官尊爵", "十拿九稳", "牵制", "爽气", "夙兴夜寐", "气壮如牛", "掬诚", "问安", "才气", "孚尹旁达", "桃李满天下", "的当", "昃食宵衣", "言必有中", "没齿不忘", "相辅相成", "辨日炎凉", "可操左券", "不以人废言", "再接再砺", "团队精神", "杏脸桃腮", "和暖", "幽韵", "见爱", "图腾崇拜", "滴水不漏", "犯而勿校", "息黥补劓", "意中人", "善眉善眼", "幼学壮行", "重用", "磨练", "顽健", "亲善", "冰洁渊清", "温凊定省", "尊严", "贫乏", "去邪归正", "福寿绵绵", "彪炳史册", "下子", "御侮", "傲雪欺霜", "践诺", "契合", "披肝沥胆", "纯良", "不患", "雄视", "祭祀", "较真", "言之有理", "春和景明", "神会心融", "飞鸟依人", "锦绣心肠", "华章", "天下太平", "绝世无双", "道貌凛然", "辩口利辞", "敬酒", "耐穿", "热中", "公事公办", "如左右手", "标新竞异", "状元", "雪案萤窗", "辛劳", "抟心揖志", "刚健", "敬老慈少", "云涌飙发", "望影揣情", "洽商", "拔萃出群", "壮健", "点题", "神工鬼力", "吐属不凡", "批鳞请剑", "长生久视", "一饭千金", "皇皇", "三寸之舌", "历史性", "回山倒海", "扶掖", "轻捷", "堂皇富丽", "奇旁福艾", "有形", "白衣卿相", "空前绝后", "善良", "煮粥焚须", "斠若画一", "谈笑而道", "姮娥", "不怕", "功德无量", "深壁高垒", "骁骑", "承上启下", "参合", "见义勇为", "文治武力", "爆强", "下阪走丸", "强健", "清心", "扭转乾坤", "经师", "力行", "一呼百诺", "纯美", "谢词", "直言极谏", "衣香鬓影", "闻风而起", "义务", "老练", "深邃", "饮冰食蘖", "顾全大局", "寄托", "任从风浪起，稳坐钓鱼船", "救民水火", "甘心如荠", "顾盼神飞", "同牢之礼", "不可磨灭", "节烈", "宽怀", "无间可乘", "皮实", "重视", "耳闻不如目见", "安不忘危", "随高就低", "毫无问题", "文章经济", "铁棒磨成针", "连枝分叶", "惊起梁尘", "游刃馀地", "崇信", "松柏寒盟", "助困", "龙精虎猛", "左右图史", "无名之璞", "登峰造极", "国富民强", "英模", "光彩", "依从", "履信思顺", "进可替不", "赏贤使能", "旺炽", "连枝同气", "天空海阔", "盛景", "可人", "8错", "知书识礼", "同心敌忾", "死心塌地", "轮焉奂焉", "有动", "一言既出，驷马难追", "修身慎行", "瓜熟蒂落", "同声相应", "居安资深", "百战不殆", "剑气箫心", "一世龙门", "六韬三略", "神仙中人", "腾蛟起凤", "行不更名，坐不改姓", "履险若夷", "勤力", "义无反顾", "龙兴云属", "旖旎", "倾动", "与世无争", "妙手回春", "博识", "勇猛果敢", "晶光", "立功赎罪", "各有千秋", "高才绝学", "后浪催前浪", "急公好施", "强中自有强中手", "清澈", "鹊反鸾惊", "逶迤退食", "姹紫嫣红", "俊杰", "异途同归", "新交", "钦慕", "实属不易", "崇奉", "柔心弱骨", "情谊", "如解倒悬", "砥厉廉隅", "百炼之钢", "洞幽烛远", "稳操左券", "含垢弃瑕", "通融", "严肃", "惊采绝艳", "谨言慎行", "龙翔凤舞", "一身都是胆", "光泽", "好言好语", "余音袅袅", "开化", "交辉", "气吞湖海", "换骨夺胎", "把稳", "柔远怀迩", "打拱", "右翦左屠", "威望", "泰山北斗", "路见不平", "才高气清", "进德脩业", "凤臆龙鬐", "不落俗套", "气色", "桃蹊柳陌", "推贤让能", "沅芷湘兰", "宽怀大度", "弥足珍贵", "主敬存诚", "重望高名", "靡颜腻理", "碧绿", "惜墨如金", "神功圣化", "打恭作揖", "不屈不挠", "甘拜下风", "適心娱目", "文武全才", "进化", "真谛", "坐薪尝胆", "多快好省", "淳化", "佳品", "脱帽", "除患宁乱", "谦虚敬慎", "当轴处中", "宽豁大度", "汗牛充屋", "道骨仙风", "肃贪倡廉", "谢意", "相称", "鸿博", "笃实", "侠客", "节用爱人", "堂哉皇哉", "驳倒", "遵循", "发烧友", "借客报仇", "有耻且格", "殷天蔽日", "贫贱不移", "系念", "心宽", "天然", "日就月将", "抱玉握珠", "海涵", "真独简贵", "官清法正", "傅粉和郎", "谦辞", "国花", "进贤退奸", "功烈", "假以辞色", "看上", "镂冰雕琼", "单刀直入", "动心忍性", "不可多得", "君子之交", "安贫乐道", "才俊", "更始", "一目十行", "以德报德", "持之以恒", "腹中兵甲", "危言谠论", "众口一词", "毫不动摇", "剑及履及", "长上", "谆谆", "牵羊担酒　", "上交不谄", "泽及枯骨", "昌盛", "总角之交", "沃壤", "梨花带雨", "价值连城", "呕心沥血", "跌宕不羁", "雄劲", "无名之朴", "警觉", "不夷不惠", "熊韬豹略", "纪念章", "有口皆碑", "坚信", "人间重晚晴", "高招", "浪子回头金不换", "仪容", "廉正", "遐迩闻名", "化境", "锦绣前程", "巧妙", "吐肝露胆", "清歌妙舞", "兴致", "锐利", "所当无敌", "闻人", "带动", "徐娘半老", "福寿绵长", "歆慕", "真才实学", "淳美", "回肠荡气", "至上", "当先", "爱民如子", "腹饱万言", "鳞次栉比", "桑梓", "悠扬", "谦顺", "抛锚", "前驱", "大展宏图", "幽静", "包羞忍耻", "吞刀刮肠", "孺子可教", "无幽不烛", "声振林木", "魁岸", "开心见肠", "显著", "贺信", "明堂1道", "借鉴", "救亡图存", "输肝剖胆", "腹载五车", "百兽率舞", "和容悦色", "救困扶危", "新兴", "昌言", "拍案叫绝", "入画", "主权", "跑腿儿", "轰雷贯耳", "称兄道弟", "卓越", "大节不可夺", "路无拾遗", "殢云尤雨", "龙翰凤翼", "清寒", "九世同堂", "海涸石烂", "雅人清致", "真牛", "永恒", "通都大邑", "正心诚意", "谦虚谨慎", "康庄大道", "诗豪", "强固", "饮醇自醉", "辩白", "人材", "信而有征", "无疵", "济楚", "雅致", "严以律己，宽以待人", "耳聪目明", "绘影绘色", "拔尖儿", "夕寐宵兴", "坚强不屈", "宽洪海量", "如饮醍醐", "择善而从", "寸步不离", "坦率", "淳朴", "直性", "无误", "量枘制凿", "口碑载道", "依依不舍", "耐久", "一见钟情", "举世无双", "深信不疑", "金石交", "材朽行秽", "谈吐不俗", "道古稽今，言远和近", "违时绝俗", "佳话", "顺藤摸瓜", "靓丽", "盛开", "论辩风生", "仙风道气", "宝贝儿", "路遥知马力，日久见人心", "近水楼台先得月", "寒灰更然", "刮肠洗胃", "退藏於密", "来者不拒", "雕章绘句", "海内存知己，天涯若比邻", "烂若舒锦", "铁打江山", "名句", "随乡入俗", "扼要", "碧油油", "易地皆然", "高精尖", "日新月著", "济人利物", "修桥补路", "灿烂", "名胜", "软硬兼施", "拱立", "致敬", "艰苦朴素", "熟能生巧", "深思远虑", "砌红堆绿", "铜筋铁肋", "真实可信", "慈眉善目", "改造", "鼎力", "敦默寡言", "甘美", "公正不阿", "仙境", "富可敌国", "有脚书厨", "精壮", "无为而成", "权责", "劝勉", "誓死不渝", "春山如笑", "情文并茂", "才学", "哥儿们", "高谈雄辩", "芳菲", "编撰", "正轨", "尖兵", "钜人长德", "交响乐队", "起死人，肉白骨", "眷怀", "详尽", "厉精更始", "四海昇平", "歌声绕梁", "毫不利已，专门利人", "瑰奇", "铁杆儿", "谦恭", "彻亮", "有礼", "鸾歌凤舞", "同德一心", "玉振金声", "枵腹从公", "绝伦", "媳妇儿", "寸土尺金", "桃羞杏让", "截铁斩钉", "峨冠博带", "引绳切墨", "迎头赶上", "谦恭下士", "点头会意", "路见不平，拔刀相助", "超逸", "随乡入乡", "托福", "得道", "炼石补天", "丰功懿德", "龙骧虎步", "死诸葛能走生仲达", "无上", "流芳百世", "革命性", "公才公望", "东山再起", "健旺", "热劲", "千里马", "栈山航海", "麻姑献寿", "看杀卫玠", "机灵", "发轫", "仁慈", "淳厚", "无垠", "金鳷擘海", "指天誓心", "专家", "有所作为", "琪华瑶草", "坚忍", "谢孝", "食鱼遇鯖", "磅礴", "清源正本", "雄伟", "历井扪天", "机断", "倜傥不群", "洞幽烛微", "胆气", "顶踵尽捐", "谆谆不倦", "公平交易", "平衡", "囊括四海", "修旧利废", "柔美", "廉而不刿", "大户", "眷爱", "拜识", "千斤", "勋绩", "眼福", "人死留名", "踏破铁鞋", "虎虎", "倾羡", "正明公道", "细腻", "吐哺辍洗", "匀妥", "负重致远", "恩泽", "仙露明珠", "翩然", "宽饶", "景慕", "救火扬沸", "斩钢截铁", "过化存神", "省便", "期许", "千人唱，万人和", "充实", "弸中彪外", "文风不动", "铁打", "轩豁", "诚挚", "澄澈", "叫好", "痌瘝在抱", "登高望远", "教一识百", "瞧得起", "喷薄", "辉耀", "韩信将兵，多多益善", "能屈能伸", "澄净", "荣名", "对客挥毫", "防微杜渐", "云心鹤眼", "物阜民丰", "乌衣子弟", "纯正", "龙战玄黄", "心闲手敏", "声势浩大", "九间朝殿", "八斗之才", "田父献曝", "奥旨", "民族英雄", "机变", "余响绕梁", "义卖", "金口御言", "年丰时稔", "文从字顺", "苦中作乐", "细发", "仁言利溥", "实至名归", "清风峻节", "之死不渝", "作善降祥", "成器", "一言以蔽之", "排列整齐", "至交", "深思熟虑", "轻怜疼惜", "八错", "光灿", "朝气勃勃", "回头是岸", "传神", "入室昇堂", "宏放", "奥妙无穷", "奇花异草", "名贵", "红情绿意", "红润", "铁定", "珍贵", "闯将", "夫唱妇随", "服服帖帖", "情有可原", "克己奉公", "流畅", "推陈致新", "凤翥龙翔", "才气过人", "举直错枉", "瑜百瑕一", "具有吸引力", "存问", "赞助", "徐图", "千姿百态", "井井有方", "贤哲", "晴丽", "闲习", "亲人", "大事不糊涂", "不避水火", "谦让", "除邪去害", "耿介", "善行", "粉妆玉琢", "权变", "浅近", "文章宿老", "体察", "人生七十古来稀", "堆金积玉", "云舒霞卷", "灵活", "奖励", "束修自好", "仁至义尽", "志士仁人", "饮灰洗胃", "俏式", "潇洒", "仁德", "不怨天,不尤人", "忠心", "玉树琼枝", "虔婆", "进善退恶", "登高能赋", "岳镇渊渟", "磨砻浸灌", "知无不言，言无不尽", "大军", "前列", "忠告", "愤不顾身", "专长", "讲文张字", "问罪之师", "桃李春风", "匡救弥缝", "辩证", "波澜老成", "昭彰", "正义感", "偏离", "更无长物", "正面", "浑古", "既往不咎", "援手", "开拓型", "干才", "情书", "凡事预则立，不预则废", "婵娟", "厉行节约", "美艳", "闪耀", "业绩", "赏立诛必", "高识远见", "荣归", "宽宏", "声威", "道同契合", "深切著明", "赏封", "百炼成钢", "勤劬", "二分明月", "六臂三头", "扶危救困", "莹洁", "可泣可歌", "能人", "纤小", "高等", "竭尽全力", "舐犊情深", "贞洁", "醇浓", "用兵如神", "后发制人", "龙行虎步", "成就", "翠微", "高斋学士", "下车泣罪", "博览五车", "含明隐迹", "窍门", "勋章", "多谋善虑", "虎势", "斗艳", "焚香膜拜", "有教养", "敝帷不弃", "毋庸置言", "清馨", "柔曼", "秀拔", "济世安民", "沥胆堕肝", "广为", "巾帼", "豪侠", "BUCUO", "问牛知马", "斑斓", "丰姿冶丽", "天假之年", "白水鉴心", "退避三舍", "契友", "天高地厚", "于飞", "勇士", "自圆其说", "自重", "出尘", "北宫婴儿", "受吃", "蔼然仁者", "抵抗", "教益", "群威群胆", "谢客", "贴心", "亲爱", "远怀近集", "百事通", "月老", "老实巴交", "力排众议", "雕文织采", "月异日新", "称贺", "甘甜", "再生之德", "独胆", "甘心情原", "条脩叶贯", "有涵养", "破相", "九衢三市", "含垢匿瑕", "海约山盟", "鲁阳挥戈", "莫可名状", "脆美", "分外夺目", "彪炳", "渭浊泾清", "潜力", "一瓣心香", "迎门请盗", "形影不离", "追风摄景", "秀润", "未可同日而语", "言简意赅", "认真", "观止", "勤劳", "地平天成", "遐迩著闻", "盛筵", "钢浇铁铸", "垂范", "言语妙天下", "意境", "同舟共济", "春色", "洪福", "宏敞", "博爱", "伟力", "尊师重道", "婉妙", "独具特色", "光荣", "黄雀衔环", "创见", "清洌", "长命富贵", "头等", "千里神交", "推己及人", "平复如故", "双宿双飞", "高迈", "精通", "门墙桃李", "培植", "不忘沟壑", "百代文宗", "顾复之恩", "诗意", "遵照", "灵通", "秉笔直书", "捷给", "责无旁贷", "别开蹊径", "国宝", "立身扬名", "娇娃", "极顶", "文名", "完美无瑕", "返邪归正", "扬武耀威", "三朝元老", "流芳千古", "光彩溢目", "阶级观点", "左宜右有", "前进", "保藏", "有胆有识", "天下莫敌", "劲秀", "苏气", "漂泊", "镂金错采", "温情蜜意", "唯妙唯肖", "先声后实", "耸壑昂霄", "自若", "悟道", "患难与共", "黛绿", "咳唾成珠", "随方就圆", "精辟", "清正", "气贯长虹", "壮心", "另开生面", "古雅", "惩前毖后", "翠蓝", "朝贡", "恬谧", "雄武", "驱雷掣电", "林下风范", "执法如山", "思同再造", "烂熳天真", "光大", "明察秋毫", "痛痛快快", "水火不辞", "一表非凡", "德配天地", "妙曼", "迷而知反", "洪福齐天", "光彩陆离", "韶华", "精深", "断长补短", "露胆披肝", "回邪入正", "柔远镇迩", "雪窗萤几", "公买公卖", "文宗", "光天化日", "洗练", "含章天挺", "坐以待旦", "初露锋芒", "老成", "凑巧", "支持", "一如既往", "小儿", "新秀", "岳丈", "吐胆倾心", "胆大心小", "多财善贾", "勤谨", "教学相长", "爱不释手", "平民", "麈尾之诲", "入境问禁，入国问俗", "直言正色", "松萝共倚", "清绮", "娇客", "卓荦不羁", "特级", "有勇知方", "盛食厉兵", "孤高", "凤髓龙肝", "莹润", "汪洋大海", "夸口", "弃瑕取用", "挚情", "隆重", "文章宗工", "沉醉", "嘉言善行", "文韬武略", "艳慕", "秀外惠中", "多谋善断", "情分", "婷婷袅袅", "送抱推襟", "平地楼台", "孜孜不懈", "延誉", "神清骨秀", "风行电掣", "忠骨", "后盾", "煜煜", "黛紫", "矢志", "金昭玉粹", "身先士众", "知趣", "万全之策", "挺拔", "准确无误", "廉洁自律", "光风霁月", "龙腾虎踞", "无一不备", "手到病除", "人儿", "底蕴", "殚见洽闻", "和调", "让路", "截断众流", "丰沃", "戮力壹心", "发短心长", "香花", "勤奋好学", "进献", "弘誓大愿", "沁入肺腑", "舍亲", "胸有成算", "洗心回面", "文才", "铜城铁壁", "尊崇", "师表", "名门望族", "不露斤斧", "卓荦", "拜节", "斩头沥血", "会师", "忧深思远", "情天孽海", "松筠之节", "铁面鎗牙", "凤翥鸾回", "善有善报，恶有恶报", "舌战", "留芳万古", "举足轻重", "贯朽粟陈", "材茂行絜", "举止文雅", "权柄", "驷马仰秣", "藕断丝连", "丢掉", "爽心悦目", "苍翠欲滴", "绝了", "不无裨益", "追根究底", "绝艺", "洽博多闻", "扶危济困", "洁莹", "翕然", "逸态横生", "偷寒送暖", "廉顽立懦", "酣嬉淋漓", "班师得胜", "每事问", "优良", "人望", "自成一家", "顶呱呱", "饼干", "劝进", "贵客", "拜恳", "捐躯赴难", "芳名", "神魂飞越", "推亡固存", "惺惺惜惺惺", "心口如一", "劚山觅玉", "慈颜", "革命", "废寝忘食", "手脚麻利", "协调", "恩重如山", "周情孔思", "具体", "以礼相待", "弃暗投明", "儒雅风流", "繁茂", "君子一言", "忠于", "浓桃艳李", "好客", "耿直", "出其不意", "享乐在后", "石赤不夺", "金闺国士", "好学", "笃论", "谈笑风生", "洗手", "改天换地", "表决", "龙姿凤采", "截发剉稾", "赏信罚必", "阳春白雪", "时髦", "食不二味", "雨旸时若", "刘毅答诏", "公正", "视民如子", "炉火纯青", "起誓", "道德", "主导", "清廉", "纯挚", "匡鼎解颐", "神摇目夺", "尝鼎一脔", "雄浑", "清新俊逸", "劝善戒恶", "严整", "晬面盎背", "财宝", "神工天巧", "恩公", "书香门户", "有过之无不及", "道同义合", "俭约", "拔山盖世", "同声共气", "公正无私", "不祧之祖", "桃李门墙", "价廉物美", "甜犊情深", "上上", "犯而不校", "直言尽意", "耐性", "点水不漏", "匹马一麾", "路见不平，拔剑相助", "佻身飞镞", "精练", "风云变态", "王佐之才", "有名气", "劝化", "奖杯", "福星高照", "另辟蹊径", "厚谊", "鲜绿", "钻研", "远至迩安", "革旧鼎新", "艳羡", "材雄德茂", "坐言起行", "长枕大衾", "成材", "如操左券", "洞察", "神枢鬼藏", "虔诚", "淑质英才", "开宗明义", "新人", "热情", "稀世之珍", "归全反真", "我武惟扬", "资深", "盈盈", "忠臣", "别具一格", "彬彬有礼", "敢作敢当", "楚楚", "根治", "亲密", "风光", "宾至如归", "妥善", "难能可贵", "帮助", "谈天论地", "精致", "热流", "文雅", "神悟", "红男绿女", "哀丝豪竹", "神清气朗", "调和鼎鼐", "鸿鹄之志", "豁亮", "宝贝", "谈霏玉屑", "神来之笔", "精绝", "凤采鸾章", "应弦而倒", "企而望归", "众擎易举", "云中仙鹤", "慧心", "远虑深谋", "吐心吐胆", "寸铁杀人", "有益", "雅淡", "列土分茅", "涣尔冰开", "元勋", "采兰赠药", "大含细入", "盛极一时", "彪悍", "见称", "名家", "超拔", "风清月白", "血性", "千儿八百", "老实", "侠骨", "站得高，看得远", "胜状", "眼光锐利", "福无双至，祸不单行", "上乘", "拔群出萃", "现代化", "殊荣", "大有裨益", "胜迹", "温婉", "平头正脸", "遵道秉义", "矗立", "有味", "金章玉句", "屋乌之爱", "地大物博", "新硎初试", "谊切苔岑", "忠君报国", "舍己救人", "闻所未闻", "摧锋陷阵", "改恶从善", "热忱", "高妙", "出奇制胜", "攻克", "悃诚", "握发吐飧", "入味", "狷介之士", "嘘寒问暖", "全始全终", "灵巧", "弃书捐剑", "秩序井然", "随时随地", "镞砺括羽", "昂霄耸壑", "高山仰止", "黄金世界", "渲染", "衔石填海", "抛售", "磨杵成针", "叫座", "有志不在年高", "胜任", "拱挹指麾", "群芳竟艳", "行不由径", "维妙维肖", "足赤", "简切", "剋己奉公", "雅饬", "始终如一", "胜地", "一呼百应", "正直", "自拔来归", "仗义疏财", "龙翔凤翥", "下界", "爱上", "博学多才", "相儒以沫", "仪表", "才识", "飞鸾翔凤", "一发破的", "宏愿", "贤德", "准确", "门无杂宾", "日试万言", "细活", "万马奔腾", "眉清目秀", "射像止啼", "简明扼要", "燎发摧枯", "披心相付", "奖劝", "云鬟雾鬓", "天下第一", "腾焰飞芒", "银钩铁画", "精要", "胸无宿物", "笔扫千军", "百二山河", "不敢告劳", "门不停宾", "要好", "博古通今", "兴旺", "偏好", "勇气", "梦笔生花", "息息相通", "筚路蓝缕", "红花绿柳", "流连", "纳谏如流", "真纯", "草圣", "真理", "游戏三昧", "古色古香", "搭手", "目光炯炯", "义师", "亲睦", "激流", "不能赞一词", "苍翠", "熠熠生辉", "顾盼生姿", "妙处不传", "春风雨露", "拔刀相助", "冰清玉粹", "敬业乐群", "承蒙", "昼日三接", "左右手", "甜密", "赏赐", "天高听下", "寻根究底", "心照情交", "太强了", "更进一竿", "回味", "惠尔不费", "高贵", "流星飞电", "集思广益", "唐虞之治", "盛名", "学识渊博", "荩臣", "花朵", "行不苟合", "斋心涤虑", "外宾", "万死不辞", "通文达艺", "奇志", "输肝沥胆", "强中更有强中手", "忘寝废食", "酷好", "持盈守虚", "传诵", "喷喷香", "瑰意琦行", "豪言壮语", "无所不尽其极", "一定", "一诺干金", "有门儿", "般若", "舍己为人", "丽藻春葩", "镂骨铭心", "怯防勇战", "比及", "道路相告", "一无所失", "废奢长俭", "剑及屦及", "磐石之固", "从严", "嚼墨喷纸", "广开言路", "楚楚可怜", "戴天履地", "忧国忘身", "国色天香", "出手不凡", "脆爽", "靡然成风", "好性儿", "分甘共苦", "孝子慈孙", "有福气", "声誉", "燕妒莺惭", "老一辈", "澄空", "季布一诺", "较若画一", "不欺暗室", "洪大", "通儒达士", "洞识", "入火赴汤", "左图右史", "连舆并席", "感兴趣", "突破性", "投梭折齿", "勤能补拙", "一身是胆", "洪亮", "深入浅出", "自告奋勇", "十之八九", "高材捷足", "名不虚得", "才貌超群", "艰苦卓绝", "精蕴", "心腹", "深根固蒂", "超尘拔俗", "星移斗转", "禅世雕龙", "拔犀擢象", "偷营劫寨", "名不虚传", "一以当十", "抱柱之信", "白手起家", "忠贞不渝", "飞声腾实", "十全十美", "肥美", "沥胆濯肝", "润饰", "坚定不移", "降心俯首", "解民倒悬", "慧眼", "守成", "豪奢放逸", "龙心凤肝", "神仙", "端直", "温生绝裾", "映雪读书", "入乡随俗", "房谋杜断", "挥戈回日", "无师自通", "芳兰竞体", "名利双收", "情趣", "三寸不烂之舌", "誓海盟山", "绝甘分少", "爱才如命", "衣被群生", "生死不二", "登门", "直性子", "不讳之路", "不知寝食", "出手阔气", "勤恳", "骁健", "珠规玉矩", "危言危行", "鲜润", "流离播迁", "好善恶恶", "高情逸兴", "本色", "谦逊", "洁净", "豪情", "肯切", "高头大马", "铁绰铜琶", "桂枝片玉", "上手", "褒善贬恶", "功底", "进贤用能", "抵事", "兵不血刃", "脱俗", "拙直", "识涂老马", "如实", "活动家", "祝福", "多姿", "智慧", "兔起鹘落", "欢心", "识礼知书", "擅名", "香饽饽", "龙蛇飞动", "说一不二", "金声玉润", "玉液琼浆", "逸乐", "面壁功深", "视死如归", "风景如画", "金断觿决", "偶像", "隐恶扬善", "余妙绕梁", "发愤忘食", "白首之心", "至圣至明", "雍容华贵", "虎虎生气", "毅勇", "辉煌金碧", "笃厚", "花容月貌", "气味相投", "凭信", "工欲善其事，必先利其器", "白雪阳春", "蓬荜生辉　", "援笔成章", "憔神悴力", "同心断金", "光灿夺目", "铁拳", "爱宠", "巧不可阶", "唇亡齿寒", "玉骨冰肌", "绘影绘声", "纤细", "赞赏", "依顺", "抢手", "同仇敌忾", "有嘴无心", "人物", "众志成城", "齐天洪福", "儆醒", "食少事繁", "镂玉裁冰", "彰善瘅恶", "麟角虎翅", "实际", "深沟高垒", "婉转", "窗明几净", "舵手", "卧薪尝胆", "火速", "少年老成", "顶天立地", "恩情", "扶疏", "七步八叉", "材高知深", "齐名", "噙齿戴发", "流水不腐，户枢不蠹", "钩玄提要", "映雪囊萤", "丰硕", "牛气", "精诚", "品评", "精神焕发", "视下如伤", "道合志同", "肯定", "谐趣横生", "精金良玉", "盖世", "荣誉军人", "直心眼儿", "凌厉", "清拔", "红装素裹", "盛装", "龙血凤髓", "大人物", "平等互利", "暖融融", "谈玄说妙", "堂皇", "傲骨嶙嶙", "言犹在耳", "巧计", "稳厚", "胁不沾席", "沥血叩心", "温枕扇席", "严密", "煦煦", "先天下之忧而忧，后天下之乐而乐", "小康之家", "软心肠", "识趣", "袁安高卧", "嘉酿", "拔山扛鼎", "志在四海", "桃蹊柳曲", "宝盒", "美味可口", "望衡对宇", "沁入心扉", "周穷卹匮", "光明磊落", "引人入胜", "铭感不忘", "肌劈理解", "恩同父母", "展现", "精细", "接济", "开卷有益", "菩提", "坚忍不拔", "厚德载福", "温厚", "战无不胜", "忘餐废寝", "任侠", "供奉", "美德", "颖异", "秀美", "葱茂", "熙熙攘攘", "站得住脚", "一尘不染", "满意", "兼权熟计", "聘任", "声名大振", "见兔放鹰", "鸣鹤之应", "才高行洁", "视人如子", "至宝", "枝繁叶茂", "忧公无私", "休明盛世", "博览会", "拔尖", "穷不失义", "荣任", "赞颂", "明澈", "饮水思源", "强壮有力", "绿叶成阴", "海立云垂", "塞上江南", "值价", "据理力争", "器宇轩昂", "神威", "天老地荒", "风骨", "蹈锋饮血", "来者居上", "小姑娘的脸蛋－爱煞人", "不失为", "鸿图华构", "能牙利齿", "起义", "千里之驹", "曼妙", "井井有条", "惠子知我", "居之不疑", "引荐", "默默无言", "夏雨雨人", "称雄", "切合", "莹莹", "硕果仅存", "稳定", "望其肩项", "记忆犹新", "甘棠遗爱", "博闻强识", "嘱托", "合胆同心", "仪表堂堂", "玉宇琼楼", "潜光匿曜", "建瓴高屋", "心肠软", "闻鸡起舞", "栋梁之材", "大大方方", "甑尘釜鱼", "报偿", "顶一下", "天真", "松枝挂剑", "除害兴利", "秀出班行", "河沙世界", "言而有信", "乐善好施", "豪情壮志", "夫子", "雾鬓风鬟", "忧国如家", "大旱望云", "一体同心", "一心一意", "波光粼粼", "箭不虚发", "明窗净几", "高飞远举", "云净天空", "红装", "真刀真枪", "深谋远虑", "钦仰", "铜围铁马", "伐罪吊民", "省心", "新意", "胆壮气粗", "大有可为", "传家宝", "情操", "亲生", "天公地道", "劝戒", "贯朽粟腐", "鲁人回日", "完善", "先见之明", "稳便", "鼎鼎", "嫠不恤纬", "经纶", "鲜车健马", "进退有度", "三跪九叩", "优渥", "追本溯源", "饶沃", "屏绝", "宏材大略", "如汤浇雪", "显豁", "二八佳人", "秀气", "锦瑟华年", "红角儿", "神气十足", "鸷鸟将击，卑飞敛翼", "一清二白", "关怀备至", "鸡犬不惊", "拙笔", "十七勇士", "陆詟水栗", "长寿", "奖状", "不差毫发", "杜隙防微", "嵚崎磊落", "统率", "优胜", "喜怒不形于色", "皮面", "多能多艺", "精当", "闳意眇指", "玉质金相", "重地", "每饭不忘", "花红柳绿", "奔走之友", "艳丽", "探竿影草", "经久不衰", "公认", "化及豚鱼", "初写黄庭", "遇物持平", "肃然", "斫雕为朴", "羽扇纶巾", "命根子", "中正", "温顺", "乃心王室", "宽洪大量", "洁身自爱", "故旧不弃", "礼让为国", "尖子", "夙世冤家", "英烈", "能言善辩", "和顺", "碧鬟红袖", "友善", "游刃有馀", "得天独厚", "献计", "三星高照", "唾手可得", "沃野千里", "严正", "深见远虑", "勤学好问", "亡羊补牢", "活眼活现", "吐故纳新", "鹤立鸡群", "独具一格", "柳折花残", "通文达理", "热爱", "赞一个", "惠顾", "幽闲", "豁然顿悟", "委婉", "大方之家", "没有搀杂", "迥不犹人", "好语似珠", "天网恢恢", "骥子龙文", "剖析肝胆", "赏不逾时", "即兴", "奋不顾身", "凭依", "今夕何夕", "鲜丽", "握素怀铅", "语近指远", "英雄所见略同　", "同心合力", "天造地设", "龙驹凤雏", "大道", "候教", "碧血", "清歌曼舞", "甘洌", "渐至佳境", "发愤", "无可挑剔", "求之不得", "守经达权", "飞跃", "谢帖", "宵鱼垂化", "同休共戚", "同文共规", "不塞不流，不止不行", "秩然不紊", "追魂摄魄", "尽心尽力", "蹄閒三寻", "气压山河", "名流巨子", "雄踞", "牛x", "计日程功", "板正", "鲁殿灵光", "炙鸡渍酒", "促膝谈心", "和和气气", "芝兰", "轻便", "果敢", "竭尽", "顶啊", "甘醇", "壮阔", "陪房", "洗心革面", "振作", "三槐九棘", "面如满月", "运筹帷幄", "赞服", "防患未然", "水木明瑟", "采葑采菲", "赞叹", "敦厚", "一碗水端平", "枕善而居", "钻洞觅缝", "天真无邪", "时兴", "繁富", "骑驴风雪中", "嘉尚", "不世之功", "不主故常", "鸾翔凤集", "龙翰凤雏", "革旧图新", "水灵灵", "有鼻子有眼", "拖金委紫", "风樯阵马", "怜贫恤老", "化育", "方兴未艾", "圆场", "不如", "雕章琢句", "婀娜", "随物赋形", "学问", "摧枯拉朽", "雪中送炭", "含冰茹檗", "少年老诚", "确定不移", "持重待机", "清幽幽", "旗手", "精神十足", "甜润", "三釁三浴", "新鲜", "伯乐相马", "同心一意", "丁一确二", "捐残去杀", "光前绝后", "保泰持盈", "金嗓子", "浓密", "荣宗耀祖", "创举", "悦目", "桑弧蓬矢", "灵快", "嫡传", "爱如己出", "上报", "先进", "尽孝", "瑕不掩瑜", "五星级", "强记博闻", "水光山色", "慷慨激昂", "和善", "健儿", "面面俱到", "繁华胜地", "尽忠竭力", "金相玉映", "高山流水", "铜头铁臂", "执牛耳", "鼓舞人心", "博达", "十年读书", "偶俱无猜", "心虔志诚", "捐身徇义", "松乔之寿", "冬温夏凊", "沉毅", "呱呱叫", "躬冒矢石", "驷马轩车", "别致", "从一而终", "美名", "击钵催诗", "绝少分甘", "白发红颜", "跑车", "不讳之朝", "大观", "呼风唤雨", "连舆接席", "不苟", "奋武扬威", "美妙", "英爽", "恭请", "稚齿婑婿", "轨物范世", "庄严", "稀饭", "高级", "栎阳雨金", "并蒂芙蓉", "赤子", "锦心绣腹", "粉装玉琢", "锦囊玉轴", "一流", "可塑", "隳肝尝胆", "向若而叹", "排山倒海", "真金不怕火炼", "佼佼者", "敬姜犹绩", "妙语解颐", "坚固耐用", "白玉无瑕", "鸾鸣凤奏", "泓峥萧瑟", "嫡亲", "蹈仁履义", "确然不群", "高行", "良家", "端雅", "名人", "井井有法", "固若金汤", "苍绿", "进贤退愚", "响亮", "志向", "滴溜溜", "切望", "亲聆", "佛眼相看", "洛阳的牡丹－人人喜欢", "何其相似乃尔", "小弟", "骀背鹤发", "弃邪归正", "三贞五烈", "倾慕", "抢险", "斯事体大", "为国捐躯", "饶有风趣", "奖许", "指日誓心", "扣楫中流", "婞直", "雅气", "细嫩", "叩拜", "壮实", "言近指远", "对劲", "偏房", "搏大精深", "余霞成绮", "谈论风生", "信念", "风月无边", "杰作", "轰天烈地", "如影随形", "情理", "超等", "凤冠霞帔", "雄丽", "跃然纸上", "栉风沐雨", "反腐倡廉", "老牛舔犊", "研精竭虑", "严慈", "戴霜履冰", "言而不渝", "划时代", "栉垢爬痒", "抱朴含真", "宽宏海量", "完好如初", "事有必至，理有固然", "恒心", "清高", "神效", "效劳", "叩首", "可意", "魄力", "纬武经文", "大显神通", "含蓄", "上下同欲", "满坐风生", "独尊", "温雅", "如火如荼", "渊涌风厉", "刚正", "悬石程书", "精忠", "妥实", "巍巍", "成事", "按期", "韬迹隐智", "尽忠报国", "福地", "无偏无党", "清鲜", "不苟言笑", "上士", "栩栩如生", "知之为知之，不知为不知", "合乎逻辑", "兼爱无私", "大雅", "五世同堂", "高性能", "怀珠韫玉", "不避斧铽", "流离转徙", "生发", "海屋筹添", "改邪归正", "渐进", "甘脆", "彫章镂句", "凤歌鸾舞", "至大至刚", "二人同心，其利断金", "心贯白日", "洁身自律", "傲霜斗雪", "誓死不屈", "骈枝俪叶", "迷上", "袍泽之谊", "进贤拔能", "待势乘时", "幽默滑稽", "弃恶从善", "心雄万夫", "不甘雌伏", "天下兴亡，匹夫有责", "轻俏", "不讳之门", "观于海者难为水", "熊罴之师", "有备无患", "良善", "韵味", "一身正气", "遵从", "保重", "长策", "企求", "毋庸置疑", "了不得", "不可偏废", "敦实", "追风逐电", "热切", "气韵", "友情", "真实", "才华横溢", "香草美人", "老成之见", "见利思义", "百举百全", "超轶绝尘", "芳心", "轻裘缓带", "推诚相信", "娇蓝", "衙官屈宋", "好整以暇", "人中骐骥", "权谋", "哀而不伤", "磊落豪横", "师兄", "吉人天相", "风华正茂", "必得", "蹄间三寻", "报本返始", "盛大", "豁然省悟", "处尊居显", "感慨系之", "勤奋", "显山露水", "伯乐", "踊跃", "终非池中物", "声震寰宇", "有过之而无不及", "勤勤", "爱生恶死", "公诸同好", "兼备", "布帆无恙", "准儿", "纯厚", "兵销革偃", "锦囊佳制", "倍道而进", "封胡羯末", "国魂", "浓艳", "拱服", "荣军", "素朴", "郢人运斧", "推尊", "称体裁衣", "外宽内明", "截击", "谐婉", "讨类知原", "良工巧匠", "煊赫", "急先锋", "淡泊名利", "婉媚", "傲骨", "春暖花开", "有条不紊", "饶有兴致", "柳下借阴", "虔敬", "丰赡", "精密", "qiang", "事捷功倍", "拚命", "给脸", "进退应矩", "不自满假", "一清二楚", "同心共胆", "宋玉东墙", "谈笑封侯", "天下无双", "蜚声", "有礼貌", "车水马龙", "道山学海", "飘然", "快刀斩麻", "肥壮", "南州冠冕", "敢作敢为", "广袤", "爱才若渴", "慕名", "独占鰲头", "朱甍碧瓦", "精诚团结", "鞠躬尽力，死而后已", "凤毛龙甲", "屡试不爽", "恰到好处", "书香人家", "老前辈", "同心僇力", "愉乐", "堪称第一", "德重恩弘", "合时", "枝叶扶疏", "幽情", "铺叙", "确乎不拔", "乾脆利落", "功盖天下", "叠韵", "雅怀", "过门不入", "得体", "卓见", "不露声色", "淡水交情", "芳容", "骨鲠之臣", "梦寐以求", "进退中绳", "韩信用兵，多多益办", "食不兼味", "摧锋陷坚", "博施济众", "沉挚", "精勤", "沉潜刚克", "机警", "俱收并蓄", "超前", "凤翥鹏翔", "情郎", "厉兵秣马", "怀柔天下", "贺匾", "硕壮", "率马以骥", "闻所不闻", "东床姣婿", "跗萼载韡", "磊落不羁", "全知全能", "龙神马壮", "月貌花容", "擅场", "情坚金石", "折冲之臣", "革旧维新", "精纯", "高效益", "含霜履雪", "较紧牙关", "扪心无愧", "可亲", "义务劳动", "看上眼", "奇花异卉", "今非昔比", "暗香疏影", "识才尊贤", "炽烈", "灵秀", "自尊", "丰姿绰约", "尽致", "凛然", "遇水叠桥", "显而易见", "飞檐走壁", "握发吐哺", "游刃有余", "勇猛直前", "画栋雕梁", "干练", "驰援", "分花约柳", "绚烂", "庄重", "余热", "发人深思", "重任", "铢寸累积", "用工夫", "流丽", "万古千秋", "脉脉", "文星高照", "宝塔", "过目成诵", "精警", "财礼", "雄文", "寄情", "柔远怀来", "月圆花好", "百万雄师", "击楫中流", "彩礼", "听从", "恩同山岳", "公平正直", "马壮人强", "短小精悍", "两袖清风", "见义当为", "吞纸抱犬", "大器晚成", "积雪囊萤", "呵护", "至言", "胖乎乎", "文静", "标准", "宽广", "一箭双雕", "口若悬河", "语重心长", "簪缨世族", "无所不晓", "跑合儿", "社会贤达", "千金买骨", "轶类超群", "豪杰蜂起", "归十归一", "乾乾翼翼", "上缴", "才赋", "六街三市", "味道好", "斩钉截铁", "主动", "爱才如渴", "断头将军", "真凭实据", "响彻云际", "不以规矩就不能成方圆", "识微见远", "盛世", "曲突徙薪", "裨益", "倾听", "余味无穷", "明见万里", "相宜", "卬头阔步", "妆新", "据实", "谢天谢地", "万家生佛", "不容置疑", "济世", "条贯部分", "讬孤寄命", "神圣工巧", "不凡", "钦定", "发展", "柔情密意", "好问则裕", "情同骨肉", "干霄蔽日", "味道鲜", "默契", "树碑立传", "一往无前", "萋萋", "心盛", "通变达权", "创议", "我黼子佩", "口碑载道　", "匡救", "观隅反三", "平缓", "权能", "铁骨铮铮", "尽瘁事国", "名士", "怀春", "相见恨晚", "高风", "人中之龙", "惠及", "如渴如饥", "皎洁", "积极", "志行", "活龙活现", "钉是钉，铆是铆", "朱唇皓齿", "大德不酬", "休戚相关", "尖锐", "桃腮粉脸", "擅长", "嫂夫人", "顶事", "娇娘", "龙跃虎踞", "文深网密", "文经武略", "空古绝今", "深计远虑", "厚德载物", "厚遇", "如花似锦", "多行不义必自毙", "忘我", "锲而不舍", "投传而去", "执法必严", "哀兵必胜", "元气", "理智", "蔼然", "大熊猫", "峻宇雕墙", "谦恭虚己", "体恤", "祭扫", "倜傥", "岳岳荦荦", "反求诸己", "瑰伟", "驽马十驾", "明公正气", "创业", "文采风流", "同盘而食", "诚笃", "显姓扬名", "热心快肠", "柔肤弱体", "勤勤恳恳", "国家栋梁", "大澈大悟", "诚心", "风光如画", "让座", "观摩", "饥不暇食", "姣妍", "慈善", "守正不桡", "立竿见影", "精益求精", "坚贞", "景观", "发奋", "肝胆过人", "玉润冰清", "名士派", "迫切", "非同寻常", "癖好", "金帛珠玉", "再作冯妇", "准时", "圆全", "补益", "量能授官", "返哺之恩", "如虎添翼", "无华", "浩气", "百折不挠地", "语妙绝伦", "添砖加瓦", "轻巧", "冰寒於水", "铁板铜弦", "蔼如", "雅俗", "拱揖指挥", "鸡骨支床", "期于", "柳泣花啼", "成名", "十指连心", "对头", "敬祝", "未雨绸缪", "闭月羞花", "淘沙得金", "仰慕", "激赏", "一臂之力", "示范", "新颜", "怀金拖紫", "实事求是", "柳暖花春", "平价和售", "任凭风浪起，稳坐钓鱼船", "积厚流广", "千万买邻", "着实", "前程万里", "枭将", "答拜", "长夜之饮", "奏效", "幽雅", "可歌可泣", "成仁取义", "杀身成仁", "奋不顾命", "名标青史", "饮冰茹蘖", "珍爱", "凤表龙姿", "同声同气", "革面洗心", "善马熟人", "夸示", "有同情心", "庖丁解牛", "洪炉点雪", "民富国强", "天才", "志同道合", "不知疲倦", "福寿齐天", "举贤任能", "文绉绉", "力求", "精良", "透彻", "战无不胜，攻无不克", "清香", "鉴别", "赏信罚明", "元首", "爱心", "闳言崇议", "肝胆", "寓意深长", "信心", "佣中佼佼", "端重", "打拱作揖", "清冽", "都中纸贵", "行礼", "毫不介意", "迅捷", "少不了", "嬉笑怒骂，皆成文章", "投鞭断流", "酷毙了", "兼顾", "把玩", "悦近来远", "功力兼人", "位极人臣", "镂月裁云", "徇公灭私", "荡荡", "太丘道广　", "笔下生花", "陪吊", "临危不惧", "清辞丽句", "不即不离", "审慎", "仙姿佚貌", "天不怕，地不怕", "人民战争", "申请", "神异", "宏伟", "将心比心", "敬辞", "水色山光", "气势磅礴", "云窗月户", "光芒万丈", "铁中铮铮", "周详", "燎若观火", "离世绝俗", "憧憬", "慈祥", "乾巴利脆", "高质量", "救苦弭灾", "名公钜人", "鸿笔丽藻", "简便易行", "跛鳖千里", "江山", "穿云裂石", "一字不苟", "红运", "通儒达识", "出众", "弟兄", "如汤泼雪", "窈窕淑女", "亲历", "先人后己", "露胆披诚", "气壮山河", "开国济民", "直肠子", "自觉", "威信", "别开一格", "真心实意", "鱼米之乡", "见惠", "畏服", "手脚乾净", "诗礼之家", "聪明智慧", "海枯石烂", "弹无虚发", "苦心孤诣", "一视同仁", "酬谢", "信从", "孜孜矻矻", "草长莺飞", "死诸葛哧走生仲达", "接遇", "青钱万选", "极品", "匀净", "摇头麰尾", "蓬生麻中，不扶自直", "烟花", "郢中白雪", "重托", "高风劲节", "繁华", "牛B", "娓娓动听", "桃红柳绿", "才略", "我见犹怜", "古井无波", "柳亸花娇", "马上墙头", "加人一筹", "搜肠润吻", "百二河山", "道不拾遗", "至理名言", "舒缓", "周公吐哺", "丹心", "八面驶风", "空前", "青藜学士", "笃志好学", "泰然处之", "和畅", "显祖扬名", "未焚徙薪", "一床两好", "量力而行", "安抚", "摧陷廓清", "大器", "忠魂", "风致", "从紧", "金翅擘海", "笃志", "旗帜鲜明", "没的说", "才思", "不祧之宗", "淡远", "先达", "不时之需", "探幽索隐", "独鹤鸡群", "下笔成章", "参天贰地", "津润", "神奥", "军不血刃", "变通", "名扬天下", "凤翥龙骧", "事倍功半", "离世异俗", "纤尘不染", "风雨同舟", "祝哽视噎", "粉嫩", "游响停云", "白首北面", "璨然", "廉正无私", "弯弓饮羽", "情同手足", "如拾地芥", "嵬眼澒耳", "必然", "羡慕ING", "雄大", "端然", "学老於年", "阳间", "玲珑剔透", "痴恋", "蓊郁", "眉目传情", "金光盖地", "为善最乐", "赞语", "高档化", "亲如手足", "劈里啪啦", "垂盼", "应答如响", "一代风流", "日旰不食", "长风破浪", "好人", "敬重", "诚服", "宝刀", "推己及物", "靓妆", "大处落墨", "秀雅", "无胫而行", "最佳", "改弦易辙", "悬崖勒马", "龙跧虎卧", "才调秀出", "绝佳", "尤物", "目不斜视", "高材疾足", "圣礼", "劝善惩恶", "胸中甲兵", "豁目开襟", "金城千里", "鞠躬", "铁铮铮", "闳意妙指", "为人说项　", "文章宗匠", "冉冉", "花花绿绿", "心领神会", "成章", "春光", "对路", "奉公克己", "余勇可贾", "香甜可口", "够朋友", "革心易行", "见德思齐", "斐然成章", "靡然乡风", "雅观", "纯洁", "踌躇满志", "目无全牛", "气吞虹蜺", "威名", "开路先锋", "久慕", "仁者能仁", "闳中肆外", "沃土", "自食其力", "肝胆相照", "令人敬畏", "朴厚", "鲜明", "赏罚严明", "雄厚", "连更彻夜", "公忠体国", "期求", "金石可开", "迥然不群", "清亮亮", "鸿篇巨著", "古朴", "与世偃仰", "陵云之志", "千金一刻", "极负盛誉", "铁画银钩", "三十而立", "断决如流", "践约", "众望所归", "引商刻角", "柳娇花媚", "肃立", "周正", "方员可施", "合衷共济", "鲜美", "守正不回", "嘹亮", "挥沐吐餐", "非池中物", "英姿飒爽", "艳冶", "赤心报国", "金玉锦绣", "坚挺", "飘舞", "漂亮", "活神活现", "战功", "公平合理", "饼子", "斩将搴旗", "郢匠挥斤", "举止大方", "炳炳麟磷", "览闻辩见", "带月披星", "烂漫天真", "雍容闲雅", "上峰", "渴望", "清平", "献旗", "慎终追远", "无所不包", "老牛舐犊", "擎天架海", "哲人", "一德一心", "不爽累黍", "碎玉零玑", "蕙心纨质", "戴笠乘车", "见素抱朴", "淡泊", "下笔千言", "渭川千亩", "钢打铁铸", "岂弟君子", "纯净", "狂热", "牛羊勿践", "天与人归", "杀身报国", "畅茂", "才贯二酉", "投梭之拒", "头一无二", "商约", "恰恰", "其应若响", "热肠", "赏心悦目", "谨密", "雪胎梅骨", "拜认", "主力", "嫡系", "仗节死义", "惊才风逸", "有板有眼", "轻徭薄赋", "恶不去善", "完满", "耿耿", "顶尖", "雄姿英发", "精髓", "神力", "显明", "柔远绥怀", "英雄好汉", "救灾恤邻", "射石饮羽", "鸿儒硕学", "美如冠玉", "独具只眼", "望尘而拜", "如闻其声，如见其人", "安常守分", "语重情深", "美丽", "法不阿贵", "主一无適", "稳扎稳打", "香车宝马", "齐集", "孝子顺孙", "渡江战役", "周全", "奉若神明", "老诚", "博雅", "刚正不阿", "扑闪", "德艺双馨", "满而不溢", "昌明", "超级大国", "克尽厥职", "公平", "传颂", "客气", "儒家", "临机处置", "呼吸相通", "涵蓄", "披甲", "金声掷地", "名望", "就义", "亲笔", "着花", "高古", "计行言听", "不羁之才", "娇娆", "亲友", "仗义", "治郭安邦", "忘形交", "独立自主", "金璧辉煌", "义学", "求告", "擿埴索涂", "生死不渝", "扶持", "投机", "济弱扶倾", "爱日惜力", "诚实", "无乎不可", "博闻", "不揣冒昧", "博览", "伶俐乖巧", "侠气", "辩论", "节用厚生", "旰食之劳", "大节不夺", "士饱马腾", "三谏之义", "价廉质优", "泼天", "天经地纬", "信奉", "妙算神机", "明眸皓齿", "镂心鉥肝", "烛照数计", "千古不灭", "盛服", "工细", "强壮", "不图", "志在千里", "争气", "辛勤", "拜寿", "深入人心", "嘉言善状", "活蹦活跳", "温馨", "毫厘不爽", "后进之秀", "九天九地", "爱国主义", "文豪", "身先士卒", "投木报琼", "革面悛心", "砥节厉行", "轻健", "锦心绣肠", "护国佑民", "守望相助　", "管事", "悍将", "爱护", "向往", "任职", "夜不闭户", "秀丽", "嘁嘁喳喳", "人各有志", "放长线钓大鱼", "气义相投", "奉公守法", "环肥蕉痪", "群英", "殚谋戮力", "轻财好施", "勇悍", "凤舞龙蟠", "开来继往", "有价值", "帮补", "赏阅", "轰轰烈烈", "亲政", "款款深深", "拥戴", "小有名气", "无为自成", "精英", "发愤图强", "拖青纡紫", "剥茧抽丝", "钜学鸿生", "连枝带叶", "婷婷", "明智", "复旧如初", "一五一十", "主角", "量才器使", "孜孜", "权数", "其应如响", "流言止于智者", "尽职", "揭幕", "鼎助", "逖听遐视", "决一雌雄", "在望", "坐不垂堂", "体贴入妙", "平平稳稳", "俊雅", "节能", "斗酒百篇", "严阵以待", "巨强", "戴笠故交", "求民病利", "清新", "了了解人意", "和和睦睦", "葱笼", "福与天齐", "八面张罗", "高足弟子", "度德量力", "经用", "用功", "设备齐全", "抛砖引玉", "恩同再造", "挚敬", "浩荡", "心凝形释", "雄心", "钦敬", "申辩", "含垢包羞", "竹马之好", "富有", "见效", "精品", "精美", "百花齐放", "鞠躬尽瘁，死而后已", "葱郁", "龙蛰蠖屈", "解惑", "著名", "风云人物", "易如破竹", "不刊之论", "灵丹圣药", "轻暖", "平妥", "见微知萌", "峭拔", "公允", "同德同心", "纯贞", "十全", "盆景", "无与伦比", "蓊勃", "含在嘴里怕化了，捏在手里怕碎了", "可圈可点", "丁一卯二", "造极登峰", "上座", "迁善黜恶", "温席扇枕", "妆饰", "精镌", "打破砂锅问到底", "破肝糜胃", "至死不变", "真确", "输心服意", "正大", "娇柔", "千金一壸", "褎然举首", "根结盘据", "尊长", "隐若敌国", "全优", "毫无错误", "铁壁铜山", "朝拜", "任命", "雄才大略", "天覆地载", "执友", "贴切", "乐退安贫", "官法如炉", "贤良", "高山景行", "帮扶", "因陋就简", "信手拈来", "瞻仰", "欣悦", "甘露", "合得来", "通晓", "艰贞", "不假思索", "铺展", "诚朴", "殉国", "知过必改", "勾魂摄魄", "指导", "山盟海誓", "新颖", "向上", "相濡以沫", "鹰击长空", "钳制", "山餚海错", "有趣", "起敬", "失敬", "造微入妙", "技高一筹", "匠心独具", "日下无双", "三顾茅庐　", "光溜", "擢用", "书通二酉", "再生父母", "丰功茂德", "整本大套", "告往知来", "夭桃称李", "有志者事竟成", "鸣于乔木", "高扬", "德尊望重", "轻盈", "手谕", "任凭风浪起，稳坐钓鱼台", "勃发", "爆满", "高抬明镜", "陶情养性", "聪敏", "正颜厉色", "砺世摩钝", "目牛无全", "龙飞虎跳", "俏美", "一言九鼎", "功到自然成", "柔情绰态", "象话", "千金市骨", "龙伸蠖屈", "有出息", "坚持不懈", "新星", "流连忘反", "爱恋", "铁肠石心", "举错得当", "有理由", "奋起直追", "谦卑", "鞠躬君子", "断长续短", "衔华佩实", "援救", "规言矩步", "宠幸", "爽口", "偏远", "犬马之报", "知书达礼", "深猷远计", "Cool毙", "远瞩高瞻", "雪案萤灯", "伟人", "仙丹", "坐不窥堂", "严守", "浩如烟海", "华丽", "剖心析肝", "心服", "随珠和璧", "佼佼", "抱椠怀铅", "添兵减灶", "自强", "顾惜", "风发", "合口味", "身体力行", "铸新淘旧", "完美", "民智", "坚决", "尊师重教", "向学", "广厦", "上房", "瓮中之鳖", "采兰赠芍", "娇黄", "乘车戴笠", "坚心守志", "典范", "高亢", "先知", "相貌堂堂", "万里长城", "朱颜绿发", "金镶玉裹", "人心", "不废江河", "丰碑", "车笠之盟", "风车云马", "龙德在田", "救治", "诤谏", "倾心", "拨乱反正", "亲身", "注重", "恶衣粝食", "秀挺", "一清如水", "宏论", "卑礼厚币", "漂流", "并肩", "佳酿", "冰清玉润", "伯歌季舞", "繁密", "省力", "俊俏", "浑金白玉", "弓虽", "锱铢不爽", "誓死不二", "史无前例", "报德", "达官要人", "博闻广识", "温润而泽", "礼赞", "奋勉", "甘贫守志", "肝胆披沥", "珠窗网户", "扶植", "无名英雄", "爱不忍释", "翩跹", "胜不骄，败不馁", "镂心呕血", "娟秀", "相扰", "运用自如", "名列榜首", "津津乐道", "豪爽", "砥节励行", "危言高论", "雪里送炭", "正人君子", "真情实意", "斯文", "神品", "登堂入室", "有滋味", "望尘追迹", "小廉曲谨", "锐气", "波澜壮阔", "良机", "前无古人", "邪不压正", "相成", "不偏不倚", "候光", "语出月胁", "辨明", "蓬勃", "助威", "钦服", "乾巴利落", "顶用", "忠心耿耿", "戴鸡佩豚", "隙穴之窥", "擎肌分理", "扫榻", "倜傥之才", "月白风清", "专注", "珊瑚在网", "详明", "杰出", "宁愿", "森郁", "连鼇跨鲸", "拜领", "坦白", "欣赏", "攻书", "纤悉", "情深义重", "同心协济", "小家碧玉", "同心共济", "拿手", "济事", "读书君子", "门庭若市", "山清水秀", "新陈代谢", "重义轻财", "骄人", "亮丽", "行者让路", "酷爱", "清峻", "清名", "敬恭桑梓", "宝爱", "门当户对", "千金一诺", "蹇蹇匪躬", "完璧归赵", "推陈出新", "有求必应", "妍丽", "才分", "丰收", "蹈刃不旋", "坚守", "义结金兰", "文房四宝", "因地制宜", "丝丝入扣", "百尺竿头，更进一步", "逊志时敏", "拱揖指麾", "因风吹火", "尔雅", "活泼泼", "驷马高盖", "先哲", "朴直", "美轮美奂", "凿壁偷光", "拯救", "严谨", "一鸣惊人", "心醉", "概日凌云", "清流", "霄鱼垂化", "父老", "红榜", "匀称", "淳良", "头绪", "名言", "贺词", "乐成人美", "高人一等", "敬老怜贫", "匡谬正俗", "郑重其辞", "不吝", "清晰可辨", "视死若归", "岁寒松柏", "明达", "跌宕风流", "夭桃襛李", "命根", "仗义执言", "浩浩", "心地善良", "义勇", "秀媚", "坚如磐石", "别出心裁", "良辰美景", "药石之言", "惩恶劝善", "郁郁葱葱", "标新竖异", "大度", "排除万难", "兼听则明，偏信则暗", "药到病除", "耿介不阿", "英伟", "根本", "皓首穷经", "玄远", "河汉江淮", "恭肃", "第一流", "八街九陌", "闻风响应", "四海皆兄弟", "闻一知二", "勤敏", "带头", "脱颖而出", "称道", "无巧不成话", "枯木再生", "十行俱下", "金淘沙拣", "边式", "冰雪聪明", "保卫", "满座风生", "财运", "自出心裁", "无与为比", "兴邦立国", "功标青史", "有滋有味", "独占鳖头", "粹集", "革旧从新", "生色", "通权达变", "碎身粉骨", "干脆", "铁砚磨穿", "风车雨马", "称扬", "奋力", "齐楚", "人之将死，其言也善", "同甘共苦", "天壤之别", "操劳", "辨物居方", "直率", "润色", "卓著", "铮铮铁骨", "情不自禁", "势不可当", "新巧", "凭险", "仁兄", "不远千里", "完美无缺", "不顾", "大才榱槃", "有智慧", "随高逐低", "避让贤路", "迁善塞违", "古劲", "赞词", "解人", "皮包骨", "冶叶倡条", "开通", "宁可", "寄怀", "推燥居湿", "捷径", "热望", "和婉", "清官", "嵯峨", "乐观主义", "驾轻就熟", "口快心直", "顺天应人", "感深肺腑", "桃李遍天下", "高门大屋", "如日中天", "切实", "顶礼膜拜", "不易之论", "晶亮", "衡石量书", "黼国黻家", "才调", "最高级", "飞针走线", "一改故辙", "万无一失", "风行水上", "日无暇晷", "义烈", "大智若愚", "珠璧联辉", "膨胀", "亭亭玉立", "天涯若比邻", "施诊", "括目相待", "贴体", "津要", "告准", "遍地开花", "盛意", "仆仆", "青山绿水", "有头有脸", "锦囊佳句", "前赴后继", "活力", "有以善处", "洗手奉职", "恋恋不舍", "时新", "顶踵捐糜", "柳骨颜筋", "猛士", "握铅抱椠", "世交", "初生牛犊", "华封三祝", "掀天斡地", "气量", "文丝不动", "五光十色", "俭朴", "舍得一身剐，敢把皇帝拉下马", "围魏救赵", "gx", "真真切切", "配合", "仁言利博", "规贤矩圣", "至亲", "勇者不惧", "忧公忘私", "速战速决", "镕今铸古", "匣里龙吟", "安老怀少", "巧夺天工", "流离播越", "身价百倍", "胆大", "镂肝鉥肾", "南金东箭", "一轨同风", "琴瑟和同", "进退履绳", "救死扶伤", "孝子爱日", "洞天", "无衣之赋", "莫逆之交", "有恒", "财大气粗", "光焰万丈", "柳宠花迷", "哂纳", "违世异俗", "洽谈", "珠玉在侧", "抚爱", "聚精会神", "执两用中", "拳不离手，曲不离口", "枉突徙薪", "文圆质方", "雅量", "幽深", "毁家纾难", "前程似锦", "辨客", "破门", "延颈企踵", "闻过则喜", "日旰忘食", "噫嘻", "又红又专", "躬体力行", "追风逐影", "彬彬", "明察暗访", "金浆玉液", "勇冠三军", "刻雾裁风", "鼎鼎大名", "百里挑一", "铜墙铁壁", "才过屈宋", "博洽", "倾注", "标致", "友邻", "放达", "笔大如椽", "规天矩地", "屋乌推爱", "人自为战", "乡贤", "明辨是非", "国泰民安", "有心有意", "骨力", "果行育德", "激切", "坚致", "抱表寝绳", "应答如流", "冬日可爱", "海誓山盟", "文治", "风行电击", "酌古斟今", "柳眉星眼", "毫不犹豫", "大义灭亲", "起死回生", "见地", "勃兴", "云中白鹤", "挽救", "沥胆隳肝", "锦绣河山", "极神圣", "据义履方", "辽阔", "万夫不当", "物华天宝", "足音空谷", "入微", "上下同心", "俭可养廉", "助战", "人给家足", "缜密", "鉥肝刿肾", "称职", "宽容", "手到拈来", "元龙豪气", "珠联璧合", "深图远算", "昏定晨省", "沃饶", "忠烈", "长辈", "锄强扶弱", "感动中", "精微", "疼惜", "轻婉", "披坚执锐", "一身清白", "不懈怠", "研核是非", "归根究柢", "恰当", "文质斌斌", "口服心折", "新雅", "民主", "贺电", "舍生取义", "恰如", "属实", "奇珍异宝", "明理", "叹赏", "解渴", "推崇", "韩潮苏海", "鞠躬尽力", "鞍不离马，甲不离身", "贲临", "和衷共济", "求索", "知人善任", "朗朗乾坤", "姿容", "颂歌", "确凿无疑", "无人不晓", "流星趕月", "兵来将当，水来土掩", "一表堂堂", "敝帚自珍", "上人", "轻财重义", "有胆量", "专著", "金箍棒", "实心实意", "诚意", "妍雅", "贤身贵体", "粗衣淡饭", "稳重", "心悦诚服", "绅士", "围城打援", "值得", "敬意", "鸾翔凤翥", "朝阳鸣凤", "要而言之", "情面难却", "力争经营", "架海金樑", "精神满腹", "壮士", "语简意赅", "省吃俭用", "大儒", "文江学海", "珍本", "奋勇当先", "精心", "道谢", "美气", "忘身忘家", "材轻德薄", "痛快淋漓", "风和日暖", "通幽洞微", "截获", "鼓掌", "醒目", "威震天下", "眼光远大", "多见广识", "自求多福", "器重", "进善惩恶", "大师", "仙子", "宽赦", "大辂椎轮", "截长补短", "天上石麟", "大家风范", "优点", "上风", "手拜", "健全", "刁钻促搯", "贵人", "高见", "知被知己", "无私", "七步之才", "灵透", "气宇", "鳞集仰流", "光复旧物", "超凡入圣", "单刀赴会", "东风", "老大", "扶危定乱", "表彰", "景星凤凰", "无往不克", "绅耆", "倾耳而听", "依稀犹记", "帮教", "笔下超生", "活脱脱", "沥胆披肝", "赏脸", "数一数二", "冰壶秋月", "治病救人", "过细", "功不可没", "瑰丽", "桃李精神", "清晰", "北辰星拱", "骑驴索句", "替天行道", "桂林一枝", "千变万化", "力争上游", "了得", "大同境域", "胸怀祖国，放眼世界", "赐光", "座上客", "手泽", "秋风扫落叶", "峭直", "头名", "福寿无疆", "高才生", "鲁阳指日", "万紫千红", "敬老慈幼", "刚勇", "能上能下", "率真", "班荆道故", "不武断", "可观", "实干", "3x", "文章巨公", "含情脉脉", "英明", "肝胆涂地", "面不改容", "宝货", "无出其右", "不免", "口角生风", "万流景仰", "黄金", "井然有条", "醉心", "重生父母", "控名责实", "细水长流", "兢兢乾乾", "显学", "净化", "爽脆", "函盖充周", "钟鸣鼎重", "洒落", "跑堂儿的", "依依", "伯祖", "才华", "机锋", "人才", "恩爱", "桃花人面", "请援", "专心", "六通四辟", "金镳玉辔", "警悟", "郁郁葱葱", "浓妆艳裹", "尊主泽民", "光芒四射", "优遇", "靡丽", "六通四达", "地望", "奋发踔厉", "洗尘", "丰厚", "珍玩", "赔偿", "感人肺肝", "心连心", "龙雏凤种", "才思敏捷", "浴血奋战", "偏爱", "刚韧", "深通", "日乾夕惕", "枕席过师", "纯谨", "鸿业远图", "简劲", "通权达理", "决命争首", "节节胜利", "贺礼", "催人奋进", "探赜钩深", "衣轻乘肥", "请命", "风流倜傥", "奇兵", "平正", "膜拜", "一鼓作气", "忧国恤民", "无微不至", "撑门柱户", "茏葱", "芊眠", "改容更貌", "嘉奖", "磊落轶荡", "头羊", "平复", "碧蓝", "文思敏捷", "委佗", "熟稔", "涌现", "企足矫首", "鱼水相懽", "千里眼", "团体精神", "优美动听", "铜心铁胆", "夸赞", "言听行从", "谐和", "迷恋", "有眼光", "多难兴邦", "驷马不追", "洞晓", "活溜", "鹤势螂形", "笃情", "沉稳", "孳孳不倦", "放下屠刀，立地成佛", "精神抖擞", "同心毕力", "富庶", "扶危翼倾", "金针见血", "埋头苦幹", "吃苦耐劳", "乖乖", "我顶顶顶", "灵捷", "集锦", "硬汉", "真心真意", "入孝出悌", "朱颜翠发", "洞隐烛微", "降尊临卑", "夙兴夜处", "称颂", "绰约多姿", "童贞", "一是一", "骁勇善战", "翰墨", "香花供养", "铁面御史", "平生", "借重", "红艳艳", "藏龙卧虎", "贤良方正", "坐薪悬胆", "高雅", "海盟山咒", "霞光", "奉行", "乐而不荒", "朝气蓬勃", "随珠荆玉", "革故鼎新", "芳龄", "文章山斗", "兢兢业业", "屏除", "寥寥无几", "连根共树", "珠玑", "明朗", "龙腾虎跃", "集大成", "祷告", "滋润", "守时间", "福如东海　", "赏罚信明", "枕戈待敌", "规范", "天禀", "朴实无华", "健美", "温文儒雅", "文宗学府", "体谅", "够味儿", "教导有方", "和谐", "气吞宇宙", "出口成章", "秾艳", "友于兄弟", "豹死留皮", "肃穆", "聪明绝顶", "正面人物", "河山", "析肝吐胆", "先意希旨", "标准化", "通幽动微", "德深望重", "势不可挡", "流芳", "促进", "无可争议", "悬梁刺股", "朱楼绮户", "妙不可言", "师公", "刚性", "韬略", "鸡鸣起舞", "酌水知源", "红颜", "萍踪", "王孙公子", "爽健", "入文出武", "面貌一新", "弹丸脱手", "深醒", "嘴紧", "建设", "聪慧", "才能", "金碧辉煌", "比屋而封", "救助", "国是", "矍铄", "献宝", "气魄", "群策群力", "超绝", "禁鼎一脔", "完美无疵", "烟景", "并世无两", "心仪", "让枣推梨", "端整", "折服", "闺秀", "及时雨", "幽趣", "清芬", "安常守故", "箪食壶浆", "渊涓蠖濩", "闻风而至", "脂膏莫润", "结义", "可口", "汤池铁城", "龟鹤", "扶正黜邪", "金辉玉洁", "磨砻砥砺", "东南之宝", "福星", "有为", "微言大义", "祝酒", "革新变旧", "无偏无倚", "蔚成风气", "精醇", "侧重", "门无杂客", "丰润", "灵便", "六问三推", "擘肌分理", "直到事人", "稳步", "出手得卢", "崔嵬", "视死如生", "心如止水", "表扬", "有地位", "直言不讳", "神通", "粹聚", "问好", "宾朋", "死党", "春暖花香", "景致", "回生起死", "昂然自得", "相国", "脱颖囊锥", "英风", "见解", "除残去暴", "丽句清词", "鱼水情深", "毕肖", "勇决", "含垢忍辱", "气概", "节操", "雄强", "万寿无疆", "适时", "逼真", "勋劳", "口齿伶俐", "惟力是视", "雄师", "加意", "满腔热血", "朱轮华毂", "清俊", "白璧无瑕", "秉公无私", "重要", "猛将", "神算", "忠驱义感", "杀富济贫", "交口称誉", "匠心", "供献", "一门心思", "龟鹤遐龄", "心胸开阔", "探汤蹈火", "牢不可破", "献丑", "款曲", "事在人为", "久仰", "搏击", "功薄蝉翼", "升堂入室", "天人共鉴", "利害", "直抒己见", "同等重要", "不费力", "待贾而沽", "岿然不动", "爱国如家", "不遗巨细", "识时达变", "道同志合", "亿万斯年", "乐而不厌", "圣上", "爽利", "大爷", "小生", "望表知里", "龙眉豹颈", "是非分明", "施主", "歌星", "威风", "气象万千", "麟肝凤髓", "神勇", "迷途知反", "开心见诚", "人一己百", "艳紫妖红", "名下无虚", "灵敏", "洞烛", "韬光敛彩", "痛改前非", "清碧", "指挥若定", "大丈夫", "钟情", "逐句逐字", "赞美诗", "韶光", "严气1性", "千虑一得", "一倡百和", "爱好", "儒生", "洞悉", "露纂雪钞", "完名全节", "龙飞凤翥", "螓首妮眉", "寿山福海", "兵未血刃", "宜人", "怀金垂紫", "鼎盛", "咫尺万里", "未明求衣", "灵心慧性", "丰富", "广文先生", "进军", "严气正性", "震古铄今", "管止神行", "轻身殉义", "花絮", "抟心壹志", "新郎", "昂然", "无偏无陂", "绝伦逸群", "本分人", "祲威盛容", "纪念碑", "亲族", "改往修来", "无上光荣", "扬葩振藻", "路见不平，拔刀相救", "人道", "远大", "对味儿", "显眼", "爱如珍宝", "别具手眼", "繁荣富强", "运斤如风", "金相玉质", "魁伟", "明眼人", "准点", "气宇轩昂", "再造", "谈议风生", "气势", "建功立事", "不徐不疾", "河山之德", "教化", "容恕", "乐而忘死", "富源", "鸿福", "馥馥", "进退中度", "药笼中物", "德才兼备", "见猎心喜", "无所不有", "梯山架壑", "允文允武", "名流", "珠零锦粲", "规整", "举止端庄", "原宥", "如雷贯耳", "轻财敬士", "嵚崎历落", "龙章凤函", "强有力", "知己", "爱抚", "齿白唇红", "匹配", "聚而歼之", "光顾", "半面不忘", "高论", "革命反正", "躬行", "肺腑之言", "拔丛出类", "壮士解腕", "水涨船高", "捍卫", "气逾霄汉", "高明", "问寝视膳", "同心协力", "一柱擎天", "讲求", "合身", "平列", "青史名垂", "含章挺生", "呈献", "白黑分明", "赐予", "保障", "琨玉秋霜", "钦羡", "铁杵磨成针", "情恕理遣", "杜断房谋", "惊世骇俗", "能近取譬", "大义凛然", "上口", "无污染", "天下为一", "鹊返鸾回", "省时", "超越", "解劝", "翻然悔悟", "均匀", "铁证如山", "救难解危", "学而不厌", "正大堂皇", "救饥拯溺", "夺目", "匹马当先", "温良恭俭让", "不为五斗米折腰", "趁热打铁", "顺人应天", "魂飞目断", "灸艾分痛", "刻骨镂心", "经天纬地", "直内方外", "韬光俟奋", "晴明", "飘逸", "掌上明珠", "恩义", "渊亭山立", "贫民", "壮烈", "鸿俦鹤侣", "超凡", "盛宴", "超群", "璧还", "钩深致远", "河目海口", "材士练兵", "践行", "重听", "深挚", "金榜挂名", "哇塞", "全盘托出", "年高德卲", "吐哺握发", "孜孜不辍", "墩朴", "忠肝义胆", "苦笑", "识微知著", "研精毕智", "神采英拔", "栩栩如活", "惟精惟一", "绳愆纠谬", "奉为至宝", "啧啧称赞", "同心合意", "道貌俨然", "曲线美", "鼓腹击壤", "一步一个脚印儿", "不忘久要", "材优幹济", "毫不利己，专门利人", "别有风味", "洗手奉公", "全力以赴", "手快", "真心诚意", "巍然", "寓意深刻", "不懈", "通天达地", "娇妻", "进贤黜佞", "始终不懈", "威权", "简易", "刨根问底", "心秀", "最高", "上进", "神谟远算", "天开图画", "故剑情深", "严细", "小巧", "芬香", "交椅", "向着", "郢人斤斧", "修身洁行", "衷情", "钟灵毓秀", "口服", "超然物外", "热潮", "粗放", "金科玉律", "功若丘山", "琳琅", "不言而信", "圆木警枕", "沿波讨源", "香馥馥", "识途老马", "优美", "追风逐日", "告成", "春山", "言之有物", "至当", "纯情", "雍容", "称美", "柔软", "好模好样", "急转直下", "憨笑", "甘贵", "劚玉如泥", "岳父", "仰观俯察", "运用之妙，存乎一心", "披肝露胆", "枕戈汗马", "锦簇花团", "剿除", "元方季方", "清介", "推乾就湿", "良金美玉", "进退裕如", "鸾吟凤唱", "巍然屹立", "之死摩它", "凤鸣鹤唳", "卓立", "刮目相见", "戞戛独造", "粗中有细", "光艳", "缓兵之计", "量材录用", "鸿章钜字", "磊落", "尊敬", "逸辈殊伦", "玉液金波", "宰相", "合格", "见告", "啸傲", "法宝", "不可", "刀头燕尾", "改革", "宝贝疙瘩", "确实", "才高七步", "追认", "烟霭", "通畅", "艳阳天", "堪称一绝", "虚心", "晓以利害", "弱冠", "宽大", "迁善去恶", "欲擒故纵", "龙举云兴", "大显身手", "头领", "洗心涤虑", "料事如神", "迩安远至", "高速", "绚丽多彩", "拔份儿", "饶富", "日昃旰食", "管用", "擿植索涂", "迫临", "入圣超凡", "识明智审", "源远流长", "骑牛读汉书", "高歌猛进", "不大离", "万变不离其宗", "超脱", "直观", "精湛", "通亮", "尽责", "冠绝一时", "日昃不食", "朱脣粉面", "辩正", "人治", "有才干", "高才疾足", "星眸皓齿", "无坚不摧", "至亲好友", "大手笔", "义士", "伟绩", "未艾方兴", "鳌头独占", "山止川行", "率直", "驯良", "峻宇彫墙", "秀外愿中", "怀铅提椠", "志气凌云", "景色优美", "澄清", "好说话儿", "千娇百媚", "公私两利", "都雅", "奖誉", "软语", "显荣", "周急济贫", "天籁", "揖让", "桃李无言，下自成蹊", "青睐", "惠风", "心中有数", "善邻", "嘉言懿行", "快人快事", "补偏救弊", "劝慰", "儒术", "名气", "深情厚意", "君子国", "淋漓尽致", "担当", "飞檐走脊", "慈蔼", "扶善惩恶", "追赠", "爱惜", "赞叹不已", "鸿运", "驰誉", "闻名", "难分难解", "磊落飒爽", "歌颂", "焚膏继晷", "擘两分星", "接气", "手不释卷", "金城石室", "根绝", "cool", "嘴清舌白", "挺立", "如痴如醉", "百废俱兴", "南征北战", "日昃忘食", "反正还淳", "昭德塞违", "安泰", "恶衣菲食", "铁人", "伶俐", "十年磨剑", "无敌于天下", "道头知尾", "相辅而行", "通儒硕学", "情网", "不务空名", "悬军深入", "仪式", "作小服低", "巍峨", "直谅多闻", "细工", "绝长补短", "雅静", "进贤兴功", "如虎得翼", "威武不屈", "衰多益寡", "保养", "清醇", "有才", "妙想天开", "光前启后", "怀材抱器", "不栉进士", "杅穿皮蠹", "风雨不改", "真知卓见", "屹立", "远见卓识", "高效能", "富贵不能淫", "承欢膝下　", "从者如云", "名公巨卿", "锐意", "赏光", "天渊之隔", "远志", "龙盘虎拏", "鞭笞天下", "正正经经", "信誉卓著", "毛遂自荐", "鹤骨松筋", "风月无涯", "突飞猛进", "娇媚", "恩德", "同气连枝", "林下清风", "两小无猜", "安如磐石", "不可或缺", "负重吞污", "鹤鸣之士", "千金", "冲霄", "意气", "奋发有为", "少艾", "活络", "东床佳婿", "涣如冰释", "槁项黄馘", "虎背熊腰", "精卫填海", "盖世无双", "字顺文从", "青出于蓝而胜于蓝", "领先", "旷达", "名垂青史", "豪放不羁", "事迹", "握素披黄", "潜精积思", "心如古井", "鹤骨松姿", "精白", "头角峥嵘", "柔中有刚", "帮贫济困", "龟年鹤算", "名德重望", "七窍玲珑", "随机应变", "万古长青", "桂玉之地", "雅俗共赏", "走召弓虽", "舍身图报", "恋恋难舍", "施舍", "茵茵", "智勇双全", "横眉吐气", "民和年丰", "谦和", "君子之交淡如水", "使命", "披肝沥血", "尽让", "入时", "如痴如狂", "凿柱取书", "娇小", "豆嘴儿", "胸有悬镜", "实实惠惠", "国术", "书不释手", "济困扶危", "信息丰富", "投桃之报", "优秀", "居高临下", "贤贤易色", "震聋发聩", "镌刻", "使用方便", "应权通变", "有死无二", "开诚布公", "更生", "坚壁", "在理", "热衷", "文才武略", "鸾翱凤翥", "结草衔环", "金口玉音", "龙腾虎掷", "称叹", "别才", "相安无事", "弘扬", "境界", "捐赠", "刃迎缕解", "舍生存义", "文武之道，一张一弛", "放之四海而皆准", "高垒深沟", "激励", "偏题", "好评", "寒素", "春风夏雨", "见经识经", "茂密", "世界级", "金石交情", "京兆画眉", "灿若云霞", "上升", "不俗", "礼贤下士", "掞藻飞声", "生动活泼", "条分节解", "蹇谔匪躬", "金丹换骨", "精严", "前辈", "醇雅", "寸辖制轮", "特立独行", "分文不取", "各奔前程", "异香", "美观", "世兄", "毅然决然", "即温听厉", "囊锥露颖", "养晦韬光", "凤鸣朝阳", "柳弱花娇", "分花拂柳", "有勇气", "进贤", "鹭约鸥盟", "干劲", "霁月光风", "柔情侠骨", "义勇军", "能者为师", "切中时弊", "无偏无颇", "冰释", "无所畏惧", "值钱", "燕语莺声", "节衣缩食", "柳腰花态", "朴质", "万古流芳", "东南之秀", "骑驴吟灞上", "冷静", "五风十雨", "超群绝伦", "女中尧舜", "胆大心雄", "违利赴名", "先贤", "光彩耀目", "通元识微", "路不拾遗", "敬谢不敏", "提倡", "坚强", "友邦", "通俗易懂", "胸有邱壑", "观赏", "麻利", "不破不立", "瑞兽珍禽", "月下花前", "通书达礼", "持正不阿", "清新淡雅", "经验丰富", "取义成仁", "拜读", "镌脾琢肾", "壮丽", "三吐三握", "一字一板", "清清白白", "深长", "精制", "卓识", "身强体壮", "流行", "举一反三", "宫可敌国", "古貌古心", "扶老携幼", "有血气", "笃信", "精锐", "结缘", "成气候", "肃然起敬", "果决", "娇小玲珑", "通古博今", "精美绝伦", "一级", "宝山", "心坚石穿", "伫立", "左辅右弼", "有血有肉", "正正气气", "后来之秀", "亲戚", "韩海苏潮", "温文尔雅", "乐事劝功", "有伸缩性", "名卿钜公", "情窦初开", "宝库", "宝地", "简要", "砥砺名号", "理所当然", "握瑜怀瑾", "马到功成", "远见", "折节下士", "龟龄鹤算", "丰茂", "片言折狱", "宏博", "无所不备", "赤诚相待", "劲拔", "爽直", "勃勃生机", "出神入化", "恨铁不成钢", "匀和", "聊胜于无", "江山如画", "拔新领异", "西施", "合度", "天矫", "简括", "进贤退佞", "兼功自厉", "克逮克容", "亲谊", "拔地倚天", "正正堂堂", "天随人愿", "抵掌而谈", "飞将军", "聪明", "情态", "机智", "玉液", "简单明了", "明月入怀", "信誓旦旦", "以手加额", "历历可数", "贤达", "反朴还淳", "过目不忘", "挥毫", "恋爱", "本支百世", "繁星", "凤舞龙飞", "贡禹弹冠", "国宾", "以终天年", "脱胎换骨", "神人", "先自隗始", "智囊", "韵致", "行家", "一枝独秀", "舍己为公", "才略过人", "道弟称兄", "至尊", "天假其年", "勇猛精进", "效死勿去", "物美价廉", "绿水青山", "博学", "辛壬癸甲", "笔走龙蛇", "即席", "堂堂", "生机盎然", "鸿渐之仪", "乖觉", "铢量寸度", "回天之力", "鹤骨龙筋", "叩头", "奋斗", "酎金", "信任", "神完气足", "明净", "进步", "优裕", "盘根究底", "解衣槃磅", "丰美", "舍生忘死", "充裕", "英灵", "怀才抱器", "高档", "渊清玉絜", "同心同德", "丰功伟绩", "碎首糜躯", "个性鲜明", "豁达大度", "龙腾凤集", "殷情", "乍毛变色", "茁壮", "勋业", "同垂不朽", "媲美", "日角偃月", "取友必端", "商榷", "发祥地", "道道地地", "常备不懈", "方桃譬李", "忍让", "深透", "精敏", "张公吃酒李公颠", "坐上琴心", "安国宁家", "一片至诚", "遏恶扬善", "衔沙填海", "心慈面软", "言笑自若", "名实相符", "道高魔重", "拜谒", "英雄所见略同", "技艺", "钟鼎山林", "做得好", "蔚然", "雄心壮志", "风范", "通情达理", "鸿案相庄", "磊落光明", "开口见心", "低心下意", "普遍", "奋战", "弦无虚发", "亮光光", "不弃草昧　", "君子", "好心肠", "言简义丰", "宽打窄用", "开阔", "岳母", "警省", "情义", "绾角弟兄", "洞中肯綮", "殉节", "贪恋", "青肝碧血", "英魂", "云蒸霞蔚", "全面", "褒誉", "目不窥园", "开源节流", "知名", "为人正直", "无胫而走", "措置裕如", "为裘为箕", "博物洽闻", "先行者", "诤言", "袍泽", "隋侯之珠", "教导", "宣战", "郎才女姿", "骁将", "佳音", "人道主义", "凭仗", "两肋插刀", "可贵", "轻怜重惜", "攻破", "结伴", "佳丽", "乞灵", "活泼", "大直若诎", "物阜民康", "视死犹归", "奇观", "天马行空", "有目共睹", "吃香", "花朝月夕", "乾坤", "温香艳玉", "意味深长", "范例", "革邪反正", "老马嘶风", "顺眼", "梯山栈谷", "建设性", "襟怀坦白", "柔滑", "健朗", "安静", "手疾眼快", "干净", "如兄如弟", "论德使能", "晶莹", "黄金时代", "转日回天", "优异", "一统天下", "乐此不疲", "体念", "错彩镂金", "跌宕", "绝代", "推食解衣", "光前裕后", "绳趋尺步", "矢志不渝", "雕章缛彩", "主流", "碧澄", "滔滔滚滚", "誓约", "推诚置腹", "端凝", "奋勇直前", "平易近人", "吉祥物", "阐扬光大", "林下风度", "无胫而来", "眉头一皱,计上心头", "鲜车怒马", "功劳", "报本反始", "偏劳", "奉公如法", "群芳", "秋收起义", "井井有序", "谋及庶人", "皦短心长", "亮堂", "狂放", "惨绿少年", "入阁登坛", "铢分毫析", "珠圆玉润", "镌骨铭心", "老少无欺", "菩萨低眉", "度越", "赞幕", "闯劲", "独步", "含垢藏瑕", "好汉", "鹰扬虎视", "进利除害", "另眼相看", "广宇", "认可", "厚待", "言来语去", "清切", "棋逢敌手", "暖流", "轻怜痛惜", "长命富贵　", "披露腹心", "救援", "一双两好", "别有天地", "夙兴昧旦", "心灵美", "权略", "风趣", "充畅", "家喻户晓", "称许", "乱世英雄", "著作等身", "先辈", "不蔓不支", "别趣", "智勇兼全", "硬朗", "毅然", "忠于职守", "博采", "柔肠百转", "准将", "商讨", "三顾茅庐", "不动声色", "之死靡它", "笔挺", "可嘉", "废寝忘餐", "从谏如流", "英豪", "独特", "目不邪视", "手挥目送", "挥戈退日", "对证下药", "雅人韵士", "左图右书", "林下高风", "义正词严", "相投", "原封不动", "洁己从公", "确确实实", "相与", "交谊", "被褐怀玉", "精悍", "推梨让枣", "益友", "清莹", "卓有成效", "以德报怨", "旁观者清", "牢甲利兵", "上级", "将勤补拙", "铮铮佼佼", "大才", "转海回天", "居安思危", "犒劳", "进可替否", "勇健", "肩劳任怨", "讽一劝百", "乐道忘饥", "清亮", "千羊之皮，不如一狐之腋", "轻死重义", "不动摇", "牙签玉轴", "白玉无暇", "八面莹澈", "殚思极虑", "恒性", "堕入爱河", "颂扬", "启迪", "艳称", "龙眉凤目", "兼人之勇", "潜休隐德", "光彩夺目", "拨草瞻风", "醇香", "下情上达", "生聚教训", "歃血", "摧坚陷阵", "松柏之志", "本固邦宁", "不忍释手", "聪明过人", "本枝百世", "左萦右拂", "三个臭皮匠，合成一个葛亮", "稍胜一筹", "敬信", "王后卢前", "佳偶", "桑土绸缪", "优雅", "金榜", "心如金石", "显赫", "推服", "轩朗", "相公", "优等", "掷地赋声", "战无不克", "赫赫", "惨淡经营", "凤凰于飞", "后生可畏", "敏捷", "尖端", "心动", "利喙赡辞", "锦团花簇", "赞礼", "少不得", "私访", "珍奇", "吃大户", "量力度德", "于安思危", "闻风而兴", "艺高胆大", "爱礼存羊", "欣欣", "引而深知", "网开一面", "痴情", "口谐辞给", "禁中颇牧", "不甘后人", "捐躯济难", "砥节砺行", "颉颃", "河岳", "金相玉振", "违世乖俗", "格物致知", "井然", "心领", "玉箫金管", "装点", "谢忱", "甜头", "名扬四海", "首善之区", "奉如神明", "雅兴", "退食从容", "杏眼圆睁", "装饰", "刨根儿", "丹楹刻桷", "委宛", "顶了", "不含糊", "感恩图报", "明镜高悬", "心直口快", "剿灭", "佛眼佛心", "公听并观", "完人", "不同寻常", "秉公办理", "精巧", "意气飞扬", "雄图", "得人心", "酒虎诗龙", "千里寄鹅毛", "饮泉清节", "英雄汉", "识文谈字", "济世经邦", "浩渺", "荟萃", "得饶人处且饶人", "蓬茸", "切中", "陆海潘江", "进善惩奸", "宝书", "追远慎终", "隐鳞戢翼", "纤巧", "有良心", "蒸蒸日上", "了了可见", "深刻", "光彩炫目", "绳锯木断", "胭脂", "伏贴", "搜岩采幹", "佳境", "戴清履浊", "析肝刿胆", "古香古色", "劳神", "千里骏骨", "见义必为", "烁亮", "鲁戈回日", "敬上爱下", "分丝析缕", "可信", "神兵天将", "轻生重义", "天长地久", "淡雅", "白日衣绣", "仙风道骨", "姣美", "塞井夷灶", "活菩萨", "省俭", "神往", "荣华", "银钩虿尾", "古调不弹", "水汪汪", "宝刀不老", "有脚阳春", "放达不羁", "拜会", "刚强", "千里鹅毛", "贤明", "艺术性", "推许", "孝顺", "确实可靠", "识见", "跗萼连晖", "牙签犀轴", "急需", "春晖", "字斟句酌", "犯而不较", "赏善罚恶", "九牛二虎之力", "疲癃", "砥柱", "铢积锱累", "进贤屏恶", "饯别", "躬逢", "敬贤重士", "得人", "无往不胜", "道存目击", "团头聚面", "显耀", "化鸱为凤", "天真烂漫", "心尖", "用心", "连枝并头", "柔媚", "想头", "生死之交", "醇厚", "掷果潘安", "富贵", "千里一曲", "雨后春笋", "够意思", "赔垫", "志气", "筋道", "待价而沽", "令人大开眼界", "不无道理", "可信任", "潜光隐德", "金声玉振", "遵命", "当机立断", "忿不顾身", "看重", "名公钜卿", "忠贞不屈", "济世安邦", "还乡昼锦", "负重含汙", "剖心析胆", "歃血为盟　", "一秉至公", "新式", "讳树数马", "宛转", "竞秀", "须髯如戟", "小鬼", "见义敢为", "全才", "班衣戏采", "利齿能牙", "向慕", "饶爽", "温暖", "钦佩", "掮客", "进德修业", "翔实", "恭谨", "鬼功神力", "大匠运斤", "丰盛", "识字知书", "大而化之", "合宜", "鉴定", "朝过夕改", "创业垂统", "孳孳矻矻", "三顾草庐", "学好", "推进", "天香国色", "玉清冰洁", "温软", "声情并茂", "丢卒保车", "救火拯溺", "月下老人", "辅佐", "嵩生岳降", "清淡", "铁板钉钉", "疼爱", "兼容并包", "泰山磐石", "违世绝俗", "昂头阔步", "仆从", "不解之缘", "昂然直入", "通时达变", "非同一般", "富饶", "合口", "斯斯文文", "利索", "为国之哭", "千金一瓠", "爱人", "老到", "颜骨柳筋", "因敌为资", "投戈讲艺", "打前站", "精精神神", "无所顾惮", "名副其实", "应对如响", "伯祖母", "气数", "奔腾", "通忧共患", "恭而敬之", "锦绣", "磨不磷，涅不缁", "大方", "雅玩", "崎嵚历落", "择地而蹈", "有头脑", "如臂使指", "再造之思", "强盛", "明断", "精粹", "长才广度", "dingding", "秀劲", "见访", "高级化", "亮眼人", "言听计从", "洒心更始", "莺俦燕侣", "感激涕零", "移风易俗", "赢得", "赞歌", "云窗月帐", "无双", "着手成春", "恭顺", "脆生", "奇伟", "铢两悉称", "坚苦卓绝", "通达", "龙章凤彩", "八仙过海，各显神通", "披露肝胆", "大型", "伸畅", "海晏河清", "目不苟视", "履险如夷", "殚精竭虑", "精本", "至诚", "救护", "铜山铁壁", "切近", "工力悉敌", "浓香", "上书", "无为自化", "唇齿相依", "兴趣", "贞松劲柏", "桃之夭夭", "安宅正路", "力透纸背", "天翻地覆", "实心眼儿", "祝哽祝噎", "分条析理", "乱真", "恩物", "劳苦功高", "倒屣相迎", "众星拱北", "流星掣电", "贯穿融会", "六畜兴旺", "大寿", "苌弘碧血", "旺盛", "从令如流", "铸山煮海", "逐风追电", "卓特", "烈火见真金", "殚精毕力", "心爱", "立功", "嫂子", "快人快性", "享帚自珍", "宽大为怀", "溜光水滑", "落落大方", "磊磊落落", "文经武纬", "先知先觉", "泱泱", "廉洁", "耳闻是虚，眼见是实", "机敏", "生龙活虎", "对唱", "奋进", "百堵皆作", "孟母三迁", "力疾从公", "简朴", "才情", "廉政", "敬服", "细匀", "匀细", "力所能及", "地灵人杰", "求真务实", "娇儿", "谆谆诰诫", "乾坤再造", "希世之宝", "流利", "深中笃行", "板板正正", "存亡继绝", "高见远识", "神施鬼设", "所向皆靡", "史诗般", "想望", "信及豚鱼", "帅气", "韬曜含光", "坚韧", "挥戈反日", "马上得天下", "事半功倍", "七行俱下", "人权", "解扣儿", "慈悲为怀", "至理", "独步一时", "恰如其分", "菠萝蜜", "钟鸣鼎列", "过硬", "比美", "息息相关", "魁梧奇伟", "嘁哩喀喳", "蹈火赴汤", "壮举", "勇武", "夸父追日", "鲜亮", "精打细算", "福齐南山", "亲信", "贤慧", "刚直", "设身处地", "慈悲", "陶冶", "大处着眼", "细润", "捐躯殉国", "至尊至贵", "精装", "口壅若川", "烛照", "识时达务", "心灵手巧", "光荣榜", "造福", "激越", "妙手丹青", "清风两袖", "伴当", "铢两相称", "危言覈论", "龙马精神", "颜精柳骨", "自我作故", "福寿年高", "进贤黜奸", "并力", "高人逸士", "坐拥书城", "拉枯折朽", "不知肉味", "详密", "金浆玉醴", "恋歌", "珍禽", "流水行云", "克敌制胜", "拜望", "林下风气", "井渫不食", "陟罚臧否", "妙绝时人", "引商刻羽", "磨礲淬励", "沥胆抽肠", "通才练识", "有效", "砥砺廉隅", "怀珠抱玉", "娓娓而谈", "下饭", "精妙", "松柏之茂", "赤忱", "贤路", "碎琼乱玉", "机巧", "称德度功", "平易近民", "饮犊上流", "鸿函钜椟", "柱天踏地", "贵宾", "榜首", "憨直", "超赞", "齐心", "香喷喷", "取长补短", "燃糠自照", "清奇", "引绳棋布", "象样", "头油", "百世师", "人民政府", "谨终如始", "德高望重", "逢机立断", "回文织锦", "圆润", "神童", "诗篇", "实地", "备至", "计出万全", "忠勇", "滚瓜烂熟", "出身名门", "虎彪彪", "摧枯拉腐", "随时施宜", "一衣带水", "毫不畏惧", "够格", "才智", "谈笑自如", "降龙伏虎", "束身自修", "确切无疑", "有缘", "绮丽", "鼎鼎有名", "鸾回凤翥", "人心所向", "鲁女忧国", "飞灵", "销魂夺魄", "相依为命", "重头戏", "跪拜", "鹄峙鸾翔", "桃来李答", "自信不疑", "勇力", "闳大不经", "平易", "恬美", "后进领袖", "蹈赴汤火", "全神贯注", "问羊知马", "通家之好", "视险若夷", "公论", "情深一往", "识变从宜", "安然举首", "因难见巧", "众醉独醒", "亲眼", "别创一格", "呴湿濡沫", "殚财竭力", "玉人", "仙姿玉质", "锐不可当", "载酒问字", "与民更始", "十围五攻", "语妙天下", "亲近", "鲜红", "知情达理", "班班", "土产", "直言正谏", "回报", "拔萃", "仁人志士", "壮志", "完好", "灵丹妙药", "各有所长", "视微知著", "莽苍", "懂行", "怀瑾握瑜", "黄钟大吕", "能伸能屈", "中坚", "鲠直", "讨教", "德隆望尊", "束杖理民", "没世不渝", "狖轭鼯轩", "健康美", "通今博古", "灵活机动", "聪明才智", "亲和力", "英次飒爽", "掀天揭地", "豪迈", "郁烈", "微察秋毫", "蹈火探汤", "非凡", "迁善改过", "表率", "勿为左右袒", "生力军", "龙骧虎跱", "劲健", "千秋万古", "显扬", "显达", "动人", "匡衡凿壁", "快刀斩乱麻", "刁钻促狭", "合欢", "诲人不惓", "湛恩汪濊", "精洁", "顾盼多姿", "大气磅礴", "高洁", "高纯", "摧枯折腐", "亲和", "鸾停鹄峙", "有见识", "红娘", "忠贞", "清静", "幽娴", "崇尚", "归真反璞", "善事", "守正不阿", "轩敞", "永生", "答礼", "友爱", "相忘形骸", "如弟", "英雄", "不吝金玉", "锦片前程", "露钞雪纂", "磨砥刻厉", "英勇", "蓬勃向上", "威力", "不吐不茹", "敬天爱民", "荆山之玉", "心慈手软", "背暗投明", "道头会尾", "训练良好", "切磋琢磨", "轻财好义", "欹嵚历落", "心心相印", "龙眉皓发", "顶天踵地", "尧趋舜步", "挺进", "矢志不愈", "日锻月炼", "磨而不磷，涅而不缁", "巴巴急急", "支前", "闻名遐迩", "平价", "闳言高论", "师爷", "爱屋及乌", "典要", "呈正", "儒教", "英俊", "合理化", "专一", "前事不忘，后事之师", "甘芳", "山高水长", "云涌风飞", "同休等戚", "济困", "韬光韫玉", "风清月皎", "洗礼", "麟子凤雏", "震古烁今", "所向无前", "人尽其才", "谛听", "谆谆告诫", "量体裁衣", "达官贵要", "光灿灿", "别树一帜", "褒衣博带", "谦谦", "迈古超今", "灵心慧齿", "食不兼肉", "移樽就教", "倡条冶叶", "郎才女貌", "实诚", "途途是道", "龙威燕颔", "如期", "水米无交", "佳美", "抑塞磊落", "无敌", "谈言微中", "干云蔽日", "汤去三面", "器识", "棋高一着", "澡身浴德", "韦编三绝", "健将", "全心全意", "健步如飞", "惊才绝艳", "效死输忠", "韬光养晦", "正派", "重镇", "甲等", "刻苦", "扶危拯溺", "苦心", "言芳行洁", "沅茝灃兰", "鸣野食苹", "知恩报恩", "鸿均之世", "助益", "必须", "大士", "烛花", "正气", "鱼游濠上", "揽辔中原", "荣耀", "气血方刚", "名物", "断齑塊粥", "顶一个", "华艳", "乌衣门第", "疏财重义", "旰食宵衣", "令人钦佩", "人才出众", "丰功厚利", "举无遗策", "清心寡欲", "兹事体大", "种子选手", "无所不通", "按荆斩棘", "上宾", "上第", "贺联", "珍馐", "坚持不渝", "美人", "昂首挺胸", "琴瑟之好", "由衷", "相亲相爱", "直节劲气", "截发留宾", "超超率著", "豪杰", "与日俱增", "倾耳注目", "鼓舞", "贞烈", "警句", "五车书", "打气", "天地剖判", "待时守分", "躬蹈矢石", "金字塔", "一日千里", "拙朴", "腴润", "实意", "不卑不亢", "积德", "醇和", "申谢", "东床娇婿", "硬实", "谐美", "日新月盛", "再造之恩", "龙骧麟振", "九烈三贞", "榜样", "名列前茅", "缓急相济", "盈溢", "多文为富", "小人儿", "出凡入圣", "囊茧照读", "工力", "醍醐", "异彩纷呈", "专心致志", "孤胆", "无所回避", "实打实", "好善嫉恶", "经始大业", "先人", "出人头地", "跌荡不羁", "凤舞鸾歌", "真迹", "功德", "涅而不缁", "无可非议", "求贤若渴", "之死靡他", "感人", "君子成人之美", "戮力一心", "无前", "远求骐骥", "渊渟岳峙", "摅肝沥胆", "别具匠心", "犟劲", "解囊相助", "令行禁止", "三头六臂", "葱白", "都头异姓", "惹眼", "必操胜券", "中流砥柱", "飘洒", "隐然敌国", "便捷", "舆死扶伤", "卓乎不群", "山珍海错", "问安视寝", "姣好", "启蒙", "目量意营", "词穷理极", "娇宠", "懂事", "无私无畏", "维新", "麦丘之祝", "感恩戴德", "异彩", "夹道欢迎", "比冀齐飞", "高深", "直爽", "重整旗鼓", "超巨星", "切磋", "独秀一枝", "切要", "伯仲之间", "脆嫩", "丰满", "闳宇崇楼", "驰名天下", "善于", "撞府冲州", "敬老慈穉", "醉酒饱德　", "宋斤鲁削", "亲手", "金石为开", "恳挚", "雄俊", "甘旨", "实惠", "艳美", "信守", "博古", "笔饱墨酣", "乐道好古", "遵守", "学有专长", "敏锐", "开诚相见", "莹然", "致谢", "不畏艰险", "体恤入微", "改行自新", "手下留情", "俊美", "隳胆抽肠", "变戏法", "如山压卵", "娴熟", "施礼", "偏锋", "静若处子，动若脱兔", "善贾而沽", "打富济贫", "生机", "不平则鸣", "快刀斩乱丝", "稀贵", "高才捷足", "痴心不改", "有头有脑", "陶情適性", "忠信", "金声玉色", "超俗", "文武兼备", "救焚拯溺", "丹忱", "神鬼莫测", "精兵简政", "搞活", "前仆后踣", "犯颜极谏", "首善之地", "牛角书生", "贤母良妻", "皓首苍颜", "熙攘", "来者勿拒", "宰相肚里能撑船", "茂林修竹", "明慧", "清凌凌", "角巾私第", "删华就素", "卓尔不群", "磨厉以须", "神采奕奕", "高深莫测", "敬贺", "商洽", "祖武宗文", "珠光宝气", "交心", "远亲不如近邻", "回肠伤气", "锋利", "善战", "有心眼儿", "百无一失", "家珍", "准谱儿", "扶危持倾", "英雄豪杰", "荣膺", "涉笔成趣", "嗷嗷的", "雷厉风行", "教育", "饱学之士", "安常习故", "较劲", "无拘束", "天神", "揽蕹吻?", "不伐其功", "辩才无碍", "博大精深", "河奔海聚", "不欺闇室", "有的放矢", "郢人斫垩", "兴盛", "头头是道", "忧盛危明", "名重一时", "长生不老", "如埙如篪", "陵劲淬砺", "救亡", "英武", "关照", "为人宽厚", "龙威虎震", "明快生动", "舒爽", "骠勇", "荷花", "遂心应手", "琼楼玉宇", "姜桂之性", "轻倩", "颂赞", "随车夏雨", "进善黜恶", "千里姻缘一线牵", "让逸竞劳", "光辉", "中河失舟，一壶千金", "披沥", "范本", "大公无私", "斐然", "夷旷", "国威", "东床娇客", "享年", "功勋", "独到", "明睿", "尽力", "无坚不陷", "憨厚", "匀实", "熠熠", "实在", "施与", "芬芳", "自爱", "歆羡", "分外妖娆", "铁壁铜墙", "宽洪大度", "神乎其技", "广譬曲谕", "结拜", "价廉质优|", "鞭辟入里", "潜精研思", "铭记镂骨", "高情远韵", "贵不可言", "旁求俊彦", "万里江河", "千伶百俐", "麟凤龟龙", "轶群绝类", "同心竭力", "谏争如流", "一世之雄", "协调一致", "豁人耳目", "寸草春晖", "雕饰", "答谢", "休戚与共", "化日光天", "平整", "金貂贳酒", "中立不倚", "盎然", "意蕴", "兵精粮足", "重于泰山", "铜筋铁骨", "治世", "大马金刀", "顽强", "低柔", "重气狥名", "孜孜汲汲", "共挽鹿车", "和风", "隳肝沥胆", "有则改之，无则加勉", "信服", "贫贱之交", "逐字逐句", "周济", "宾客", "鸾鹄在庭", "瞧得上眼", "肝脑涂地", "小试锋芒", "秋高气爽", "杀身成义", "不愧", "拙见", "祁奚之荐", "混然天成", "宏亮", "反风灭火", "感召", "打破沙锅问到底", "风流旖旎", "善善恶恶", "上等", "丽日和风", "八方呼应", "火炽", "百世不磨", "警愦觉聋", "偏巧", "刮目相看", "以身报国", "神到之笔", "正视绳行", "宽阔", "左提右挈", "顽石点头", "孝子贤孙", "日久见人心", "喜欢", "情见乎辞", "三年不窥园", "功垂竹帛", "警切", "大发慈悲", "恭祝", "以一当十", "纵横驰骋", "少爷", "欣羡", "有案可稽", "心服首肯", "冰心", "明公正道", "论道经邦", "贵重", "奖学金", "看中", "风度", "拜见", "指天誓日", "相爱", "文文静静", "奖赏", "咏赞", "合情合理", "一举千里", "蹇之匪躬", "材剧志大", "脉脉含情", "运掉自如", "湛蓝", "戆直", "儒将", "辞宗", "留恋", "退食自公", "美女", "桃腮柳眼", "奋志", "骨气", "井井有绪", "气派", "天保九如", "不厌其详", "宏图", "斗志昂扬", "琪花瑶草", "一叶知秋", "天从人原", "赅备", "升高自下", "余声三日", "道高德重", "朋友", "三头六证", "崇仰", "一表人才", "成果", "依恋", "智巧", "爱鹤失众", "治乱存亡", "时尚", "高强", "量力而为", "驾驭", "进种善群", "真金烈火", "如雷灌耳", "一笑干金", "前歌后舞", "忠实", "快捷", "厚道", "嗜好", "沉鱼落雁", "独当一面", "身手", "推轮捧毂", "先公后私", "并容徧覆", "坚贞不渝", "坚甲利兵", "嫣红", "笃守", "一定之规", "拜别", "没卫饮羽", "少陪", "追魂夺命", "金台市骏", "顾名思义", "不屈", "谨身节用", "安分守己", "正大堂煌", "金相玉式", "缤纷", "世上无难事，只怕有心人", "雍容尔雅", "仍旧", "娇艳", "机杼一家", "抢眼", "鸿渐於干", "心细於发", "豆蔻华华", "披心沥血", "垂首过膝", "万众一心", "分毫析釐", "未卜先知", "观化听风", "诚意正心", "鹤行鸡群", "拜候", "透亮", "洒洒", "仁政", "据理", "修好", "同仇敌慨", "手不释书", "平年", "德隆望重", "情意恳挚", "灼然无疑", "十分重要", "灵蛇之珠", "生死骨肉", "功高不赏", "肚才", "年富力强", "勤则不匮", "尊重", "忠君爱国", "疏财仗义", "注视", "谈吐生风", "结晶", "容止", "才女", "耐劳", "近悦远来", "投桃报李", "文玩", "焚香顶礼", "指教", "天道无亲", "真诚", "心向往之", "鲜艳", "堂堂一表", "萧曹避席", "公仆", "切当", "全胜", "捐躯", "充沛", "楼阁台榭", "晚节", "披榛采兰", "春兰秋菊", "堂奥", "能言快说", "济贫", "逼肖", "宁为五碎，不为瓦全", "剖肝沥胆", "秀慧", "功盖天地", "宜家宜室", "追本穷源", "腾达飞黄", "雄肆", "感染力", "黜陟幽明", "蔼然可亲", "灼见真知", "众望", "褒奖", "公耳忘私", "乾啼湿哭", "荡气回肠", "闪烁", "柳绿桃红", "隋珠和璧", "知心人", "千方百计", "润泽", "性情温良", "赅博", "万夫莫当", "攻研", "护佑", "呈文", "水火不避", "尽瘁", "鸣凤朝阳", "含仁怀义", "器宇", "高屋建瓴", "活便", "八珍玉食", "讽德诵功", "古道热肠", "爽朗", "自愧不如", "显祖扬宗", "志趣", "高矗", "高精度", "亮节高风", "立志", "千古绝唱", "救荒", "倡议", "不步人脚", "祖功宗德", "金石不渝", "谨慎", "矫矫不群", "合当", "胡越同舟", "云起雪飞", "金链", "寥若晨星", "獬豸", "风行电照", "优越", "接班人", "留得青山在，不愁没柴烧", "强大", "磨形炼性", "长盛不衰", "大才槃槃", "马革盛尸", "威凤一羽", "华灯", "精彩纷呈", "善气迎人", "好玩儿", "见几而作", "景星庆云", "佳趣", "人伦", "气壮河山", "正品", "四海承风", "食不重昧", "宝贵", "英杰", "高卧", "碎骨粉身", "上流", "开口见喉咙", "保境息民", "冰清玉洁", "敞快", "情真意切", "芳邻", "碧血丹心", "同生共死", "气概不凡", "忍苦耐劳", "五世其昌", "因利乘便", "凛凛", "运斤成风", "优厚", "望族", "含蕴", "乐山爱水", "鸾跂鸿惊", "搭救", "简洁", "左家娇女", "剔透玲珑", "横从穿贯", "坐怀不乱", "斫轮老手", "标新立异", "有征无战", "民殷国富", "正论", "含垢纳汙", "华彩", "名士风流", "安定团结", "先锋", "繁丽", "老成持重", "亮堂堂", "喁喁", "一家之言", "际逢", "平允", "夺锦才", "有意义", "不分畛域", "不挠不屈", "千金敝帚", "余裕", "入木三分", "容受", "巨构", "开天辟地", "无与比伦", "转托", "杞梓之林", "炯然", "厚礼", "饮冰吞檗", "乐道安贫", "直心眼", "壮气凌云", "赞佩", "忠心赤胆", "同心叶力", "无疆", "金汤", "近情", "心无二用", "幽婉", "宏大", "承平", "誓言", "珑玲", "乡音", "讬骥之蝇", "古趣", "姚黄魏紫", "堂堂正正", "六街三陌", "细致", "争分夺秒", "好事", "见识", "我负子戴", "邈处欿视", "结发夫妻", "束缊请火", "殷切", "持平", "能言巧辩", "无可不可", "仁人义士", "假人辞色", "知难而退", "上镜", "相知恨晚", "不朽", "存候", "行若无事", "难分难合", "岁寒三友", "纤纤", "遒媚", "再接再历", "对眼", "活蹦乱跳", "闻名丧胆", "六出奇计", "悟性", "根深本固", "竹头木屑", "端平", "飘扬", "猗猗", "见长", "楚楚动人", "威仪", "全盛", "颀长", "孺子", "锥处囊中", "远交近攻", "热诚", "平滑", "凤吟鸾吹", "硬骨头", "广见洽闻", "显证", "居安虑危", "班香宋艳", "舍策追羊", "踞虎盘龙", "洗心自新", "煦暖", "神工鬼斧", "效力", "左翼", "浩浩荡荡", "通窍", "金碧荧煌", "娉婷", "至高无上", "追风掣电", "扬清激浊", "下酒", "难舍难分", "朴素", "师母", "鸾飘凤泊", "柳烟花雾", "风禾尽起", "报国", "鸣雁直木", "鲜花", "沅茝醴兰", "雄奇", "慧眼独具", "宁死不屈", "创收", "左提右挚", "啸聚山林", "好听", "有始有终", "革奸剷暴", "明堂正道", "敏于事，慎于言", "岳峙渊渟", "赞美", "稳健", "高爽", "两相情原", "鹣鲽", "罗曼蒂克", "纤秀", "宋画吴冶", "孔武有力", "铢称寸量", "互惠", "抱打不平", "隐鳞戢羽", "如花似朵", "金龟换酒", "诗圣", "不耻最后", "多才多艺", "胜残去杀", "岳岳磊磊", "胜境", "酣痛淋漓", "红豆相思", "宝剑", "改行为善", "碎身糜躯", "端丽", "洛阳纸贵", "赏玩", "毫分缕析", "风采", "名满天下", "流溺忘反", "雍容大雅", "生机勃勃", "奖牌", "文不加点", "大巧若拙", "神圣", "洞天福地", "存亡安危", "通人达才", "驷马莫追", "功绩", "鸿轩凤翥", "骨肉相连", "左辅右粥", "负气含灵", "靡然向风", "上等兵", "负土成坟", "浑身是胆", "殚诚毕虑", "温和", "天使", "上照", "友好", "无可置辩", "金貂取酒", "鸾俦凤侣", "亮铮铮", "君子好逑", "破柱求奸", "仁弟", "沃野", "担待", "深惟重虑", "鲜果", "珍宝", "欣慕", "百花生日", "反正拨乱", "鞭辟近里", "最新", "辩护士", "典雅", "惜客好义", "通顺", "光彩射人", "盛事", "量己审分", "迷恋骸骨", "企及", "金刚怒目", "膺惩", "相忍为国", "结实", "清健", "担保", "询谋佥同", "一登龙门", "睹著知微", "汹涌澎湃", "迫使", "倾心吐胆", "锦绣肝肠", "感恩怀德", "含瑕积垢", "珍重", "焕然一新", "颂词", "标新创异", "先生", "京兆眉妩", "孚尹明达", "鸿鹄", "熙和", "满腹经纶", "一表非俗", "徽号", "刑于之化", "逐机应变", "钧天广乐", "祝咽祝哽", "贤契", "知止不殆", "义仓", "父母国", "深湛", "夺胎换骨", "垂手", "灵性", "顺天从人", "不拘一格", "名公巨人", "平实", "作为", "情有独钟", "量金买赋", "亲知", "泡货", "日角龙颜", "闲逸", "勉励", "后起", "穷猿奔林", "极致", "甘愿", "心灵", "前茅", "细高挑儿", "合十", "心软", "威势", "承欢膝下", "挥洒", "蹊径", "瑰宝", "交疏吐诚", "去暗投明", "觥觥", "鱼跃鸢飞", "金瓯", "捐生殉国", "昂头挺胸", "温柔敦厚", "改行从善", "活现", "痴心", "青霄白日", "首肯心折", "神妙", "渊博", "借助", "眉目如画", "富裕", "宝号", "牺牲", "陈言务去", "驾御", "鬼设神施", "众人拾柴火焰高", "雨顺风调", "怀银纡紫", "金婚", "千夫", "条理", "与人为善", "五谷丰登", "危言逆耳", "奇巧", "邹衍谈天", "宽仁大度", "云兴霞蔚", "魔力", "锦胸绣口", "鉴赏", "时和年丰", "风骨峭峻", "灯火辉煌", "通计熟筹", "精兵", "秉承", "说笑自若", "内敛", "六马仰秣", "宾礼", "敬养", "朝闻夕改", "装帧", "深入", "勃勃", "整饬", "尧天舜日", "凭借", "白皙", "呼之欲出", "白首不渝", "师道尊严", "迷人", "高新", "牵线", "无比", "函盖乾坤", "绝世超伦", "报谢", "懂礼", "心慈好善", "驷不及舌", "露红烟紫", "士为知己者死", "伐罪吊人", "爱国", "寡二少双", "大笔如椽", "奇勋", "掷地金声", "清洌洌", "刚气", "荫庇", "栉比鳞次", "不败之地", "体大思精", "股肱", "先世", "义战", "兼人", "装璜", "流风馀韵", "举荐", "龙举云属", "质优价廉", "铁饭碗", "中看", "锃光瓦亮", "恶衣蔬食", "敞阔", "群言堂", "警辟", "口角风情", "鹤处鸡群", "交相辉映", "掷果潘郎", "鸷鸟累百，不如一鹗", "苍茫", "身做身当", "触类旁通", "谭天说地", "备荒", "爱侣", "磨砻底厉", "表演艺术", "带引", "甘于", "含英咀华", "大音希声", "醉玉颓山", "五经筒", "爱人儿", "长项", "涓滴归公", "没毛大蟲", "东央西告", "引人瞩目", "洞彻", "褒扬", "舍身为国", "幽默", "强势", "容颜", "真诠", "知心", "祝鲠祝噎", "效命", "奖掖", "济助", "诗仙", "寿比南山　", "身强力壮", "参拜", "佳妙", "长足", "跗萼联芳", "纪念堂", "游侠", "冲锋", "其次", "天下为家", "出尖", "边区", "祝僇祝鲠", "拥抱", "膘肥体壮", "高遏行云", "好吃", "节奏", "驰名中外", "独占鳌头", "景星麟凤", "飞速", "兼优", "匀整", "陶铸", "直来直去", "负责", "胆壮心雄", "巨擘", "好强", "纯朴", "一若以往", "贡献", "遒健", "移山倒海", "温情脉脉", "业精于勤", "洒扫", "崇拜", "金贵", "轻妙", "豆蔻", "清风高节", "荆钗布裙", "达官显宦", "都丽", "训练有素", "洪钟", "挥洒自如", "润资", "名誉", "活波", "滔滔不断", "麟角凤嘴", "容姿", "刚毅", "汗牛充栋", "降心下气", "桃李不言，下自成行", "卓然", "海不波溢", "出将入相", "节省", "光宗耀祖", "攻取", "灼见", "模范", "虚己受人", "沃衍", "保准", "机谋", "杜渐除微", "工巧", "清辞丽曲", "平均", "前仆后继", "安分", "扶危济急", "津津", "文搜丁甲", "器量", "金缕玉衣", "材疏志大", "击节称赏　", "辉映", "瞽言萏议", "PFPF", "公直", "汗青", "百伶百俐", "勇者不慎", "凭眺", "同生死，共存亡", "商酌", "知书达理", "柳门竹巷", "铁案如山", "深耕易耨", "英才", "巾帼须眉", "攻疾防患", "金城汤池", "相得益章", "推戴", "尺短寸长", "逸群", "神枪手", "壮观", "天经地义", "忠良", "透辟", "桂折一枝", "轩昂", "软媚", "口服心服", "敬佩", "林下风致", "惜玉怜香", "河润泽及", "肩负", "要言妙道", "高超", "急智", "殷勤", "昆山片玉", "庸中佼佼", "有目共赏", "繁花", "衣不解带", "覆车之鉴", "博大", "一望而知", "玉昆金友", "洗耳拱听", "孜孜不倦", "镇定", "救苦救难", "宁可玉碎，不能瓦全", "虎贲", "横扫千军", "扶贫济困", "通文达礼", "温情", "精雅", "泥而不滓", "言谈林薮", "承教", "文籍先生", "绅士协定", "尽忠", "威望素著", "本分", "通天彻地", "恶尘无染", "同忧相救", "潜心", "任劳任怨", "拔树寻根", "都俞吁咈", "不骄不躁", "勤学苦练", "马到成功", "精义", "闲庭", "代代红", "心折首肯", "彘肩斗酒", "甘雨随车", "无所不及", "确有其事", "大节", "公正客观", "心乡往之", "纯真", "攻苦食淡", "巧合", "居仁由义", "短平快", "龙兴凤举", "洽闻强记", "誓同生死", "桑廕未移", "正统", "如响斯应", "颜筋柳骨", "始终不渝", "柔顺", "不存芥蒂", "燕众议员虎颈", "甘旨肥浓", "翠绿", "冰洁玉清", "尊贵", "高参", "历精更始", "鸳俦凤侣", "繁花似锦", "看得上眼", "竭力", "铜打铁铸", "望眼将穿", "挥戈", "智者千虑，必有一失", "適材適所", "默祷", "五行并下", "绝代佳人", "呕心滴血", "握炭流汤", "三媒六证", "云容月貌", "誓山盟海", "一笔一划", "软谈丽语", "信而好古", "香泽", "百战百胜", "厚爱", "暮鼓晨钟", "吐食握发", "摧枯振朽", "东方不亮西方亮", "悃愊无华", "硕大无朋", "零光片羽", "佳肴", "桃李不言，下自成蹊", "解放战争", "锃亮", "奋发图强", "无冬无夏", "如汤灌雪", "全新", "七步成章", "稳键", "娥眉", "金口玉牙", "无所畏惮", "以逸代劳", "相待如宾", "入门问讳", "揽辔澄清", "鼻祖", "余音绕梁", "钦迟", "清丽", "热心肠", "秉持公正", "国士无双", "食不重味", "美味", "理解", "渊深", "鲜活", "有个性", "相视而笑，莫逆于心", "详实", "鬼工雷斧", "拾金不昧", "连昬接晨", "大彻大悟", "突破", "龙骧虎啸", "气质", "余霞散绮", "甘美多汁", "龙雕凤咀", "逼真逼肖", "内行", "刚直不阿", "夸奖", "宏达", "左右采获", "有条理", "嫡堂", "滑腻", "灿烂夺目", "弘毅宽厚", "守正不挠", "清越", "杜渐防微", "变躬迁席", "好谋善断", "班师回朝", "健硕", "勤快", "国优", "璧谢", "思乡", "马足龙沙", "鸿鶱凤立", "千里送鹅毛", "公心", "讨俏", "拨乱为治", "沉郁顿挫", "足履实地", "活灵活现", "果断", "和风细雨", "清雅", "回礼", "前途", "敬贤下士", "神机妙算", "没世不忘", "巧同造化", "睹始知终", "捐金抵璧", "如指诸掌", "能者多劳", "知恩必报", "中流底柱", "十足", "黄灿灿", "强嘴硬牙", "动听", "国而忘家", "主人翁", "拥护", "年高德劭", "乐而不淫", "深图密虑", "有头有尾", "敏而好学", "随车致雨", "金枝玉叶", "便民", "广博", "笑纳", "细巧", "巍巍荡荡", "坐树无言", "入室弟子", "孜孜无倦", "详备", "炽热", "勇往直前", "骄子", "汗马之功", "靠得住", "整洁", "同呼吸，共命运", "从善如登", "腹心相照", "上将", "回春", "询于刍荛", "春风风人", "具有历史意义", "娇艳欲滴", "昂藏", "洛阳才子", "拔擢", "旌麾", "坐拥百城", "分秒必争", "合群", "百废待举", "指日可下", "交映", "卓异", "陶钧", "家骥人璧", "款款", "汰劣留良", "爱情", "狷介", "渊蜎蠖伏", "杏腮桃脸", "无可讳言", "函丈", "风华", "痴迷", "火树银花", "魏紫姚黄", "入孝出弟", "洗耳恭听", "报恩", "秉直", "雍容典雅", "圣明", "贺幛", "云冈石窟", "聪颖", "揭晓", "灵机一动", "淡泊明志", "坚定", "扫榻以待", "对答如流", "文昭武穆", "轻柔", "抚躬责己", "长空", "金石至交", "无边风月", "昌隆", "弘旨", "所向披靡", "直溜", "化腐为奇", "秋高气肃", "悠远", "节节", "龟年鹤寿", "冲坚毁锐", "仁义道德", "龙腾虎啸", "铿金霏玉", "洁己奉公", "交能易作", "偏方", "新媳妇儿", "服从", "剖心坼肝", "睿智", "好心人", "强将手下无弱兵", "意气相投", "金口", "鸾风和鸣", "语长心重", "高旷", "怜惜", "贫而无谄", "自主", "软玉温香", "人品", "督师", "驱雷策电", "因材施教", "鸾鹄停峙", "劫富济贫", "夭桃秾李", "夙夜匪解", "手足胼胝", "稀有", "光洁", "饱满", "远谋", "恨相知晚", "高情远意", "拜倒辕门", "胸无城府", "轻徭薄税", "温衾扇枕", "遥相应和", "刳肝沥胆", "简雅", "铜浇铁铸", "白发丹心", "龙飞凤翔", "甲天下", "含辛忍苦", "乐道遗荣", "存抚", "响当当", "祭拜", "如龙似虎", "乡谊", "纪念塔", "安谧", "隋珠荆璧", "燃萁之敏", "国耳忘家", "高效", "同工同酬", "府上", "龙翔虎跃", "生死与共", "夕惕朝乾", "威严", "殚精极虑", "深根固本", "活跃", "摆袖却金", "安良除暴", "博物君子", "根深蒂结", "巨著", "稳帖", "响彻云霄", "不挠不折", "柳亸莺娇", "义不容辞", "比户可封", "巧干", "气冲霄汉", "胖墩墩", "亡秦三户", "完备", "鸾交凤俦", "保佑", "倒峡泻河", "平坦", "一笔不苟", "纯熟", "公明正大", "俱佳", "冠山戴粒", "噀玉喷珠", "端详", "做小伏低", "成人之美", "加人一等", "精炼", "同明相照", "功成名就", "稳操胜算", "须眉皓然", "可爱", "识微见几", "独具匠心", "斗霜傲雪", "仙风道格", "质优", "老夫子", "诸位", "匠心独运", "勤勉", "敦睦", "爱人好士", "铢累寸积", "布衣疏食", "然诺", "己饥己溺", "圣洁", "素洁", "娴雅", "柔枝嫩条", "妖娆", "顺水行舟", "明快", "把玩无厌", "周到", "问十道百", "施斋", "高倪大谈", "神霄绛阙", "捐助", "龙跳虎卧", "宛然如生", "马上功成", "恒久", "谦让末遑", "思深义重", "百闻不如一见", "花容玉貌", "有一手", "森森", "智能型", "铁杵成针", "久战沙场", "陪伴", "胖墩儿", "正大光明", "高手", "奉为楷模", "兴味", "借问", "孝敬", "长亲", "恭正", "荣升", "凝脂点漆", "换羽移宫", "忘怀得失", "扎扎实实", "热火朝天", "求情", "盛况", "工工整整", "黑白分明", "操刀必割", "涎玉沫珠", "革故立新", "铜头铁额", "敬奉", "凿凿有据", "仁惠", "够水平", "柔枝嫩叶", "如数家珍", "欣欣向荣", "令人信服", "天下无敌", "渺若烟云", "起眼儿", "小巧玲珑", "枕籍经史", "行善", "初生之犊不怕虎", "滚瓜流水", "打躬", "一诺千金", "饥不遑食", "俊丽", "七步成诗", "变古易常", "一个心眼儿", "有生气", "中意", "柔婉", "讲信修睦", "渊海", "柳夭桃艳", "蓬蓬勃勃", "超迈", "有条有理", "曲高和寡", "不染一尘", "八面受敌", "豪兴", "鹿裘不完", "脱口而出", "聘问", "识相", "良种繁育", "谙练", "温良", "遒炼", "孩子头", "惺惺相惜", "拨乱反治", "动心", "督率", "遒劲", "文觌武匿", "乘龙", "亲炙", "安邦定国", "希望", "延颈跂踵", "心口相应", "妥靠", "前程", "杨柳宫眉", "巧劲儿", "材薄质衰", "琪花玉树", "磨礲浸灌", "喷香", "赞慕", "抓尖要强", "毕恭毕敬", "龙跳虎伏", "马工枚速", "普渡众生", "我醉欲眠", "炳耀", "柔静", "逸韵高致", "戴头识脸", "申报", "赞羡", "英华", "埋轮破柱", "信赖", "困守", "无所不能", "高义薄云", "无为而治", "受看", "入骨", "文无加点", "神医", "通时合变", "赏高罚下", "热乎", "有福同享", "格守不渝", "新异", "剑胆琴心", "直言切谏", "合胃口", "顶门壮户", "明目达聪", "瑰玮", "教坛", "芳姿", "通古达变", "菲食薄衣", "从容就义", "永垂不朽", "宏阔", "滕蛟起凤", "飘忽", "鲁阳麾戈", "先驱", "晶洁", "胸怀坦荡", "一语破的", "失陪", "吃得开", "立地书橱", "富民", "恳切", "不偏不党", "松形鹤骨", "幽香", "并疆兼巷", "人杰", "吊死问疾", "君于一言，快马一鞭", "继往开来", "活龙鲜健", "丹书白马", "低调", "玉堂金马", "三户亡秦", "五彩缤纷", "良好", "义正辞严", "主力舰", "毕生", "殢雨尤云", "长处", "石烂海枯", "赞成", "元戎", "直溜溜", "玉柱擎天", "广阔", "张敞画眉", "咳珠唾玉", "如兄", "研经铸史", "形影相追", "岁寒知松柏", "泰山压卵", "金口木舌", "懂门儿", "化民成俗", "精进", "洞见", "后拥前呼", "碎首縻躯", "粉白黛黑", "跬步千里", "自强不息", "辨若悬河", "自如", "雪操冰心", "朝气", "抱负", "良师益友", "剑态箫心", "娓娓不倦", "舍死忘生", "妥当", "胆略", "精熟", "雅士", "学富五车", "飘溢", "有能力", "翘楚", "神而明之", "亲临其境", "晶晶", "快速", "醍醐灌顶", "楷模", "改过", "中允", "摊书拥百城", "猛志常在", "扎实", "精准", "擎天柱", "锋发韵流", "芊绵", "和洽", "宽宏大量", "高才卓识", "谆谆告戒", "鳌里夺尊", "倾城倾国", "甘之若素", "馈赠", "权衡轻重", "福寿双全", "龙攀凤附", "秀色可餐", "哀感顽艳", "韶秀", "另眼相待", "不私其利", "娇女", "雄威", "醇朴", "才名", "不厌其烦", "英秀", "江左夷吾", "逐电追风", "上下一心", "服膺", "凤仪兽舞", "执鞭坠镫", "革凡登圣", "谨终慎始", "创意", "棒儿香", "知疼着热", "带金佩紫", "杀敌致果", "齐整", "锦缎", "稳妥", "孝子", "衾影无惭", "端静", "黄发骀背", "钻坚研微", "童叟无欺", "善心", "稳静", "悉索敝赋", "足色", "咽苦吐甘", "孜孜无怠", "郁郁苍苍", "度量大", "韧性", "恢弘", "光华", "繁盛", "千姿万态", "pf", "惊佩", "沁人肺腑", "诛故贳误", "屏藩", "引锥刺股", "桃李争妍", "爽捷", "犀照牛渚", "迁善远罪", "中听", "渴慕", "脚踏实地", "鸿儒", "爱人利物", "正直公平", "盛情", "广求", "一二九运动", "秦晋之好", "鱼沉雁落", "多材多艺", "善始令终", "纷华", "大塊文章", "捐躯报国", "真心", "老成练达", "不以一眚掩大德", "看莱吃饭，量体裁衣", "珍惜", "盛誉", "致力", "乐善好义", "志士", "清婉", "敬仰", "圭谬", "屦及剑及", "诲人不倦", "同心一力", "齐截", "鉥心刿肾", "桃花潭水", "德厚流光", "济济", "戴玄履黄", "公正廉洁", "通力合作", "礼轻情意重", "树叶茂盛", "政通人和", "柔情似水", "鬼斧神工", "倾国倾城", "炮舰政策", "撇开", "大名鼎鼎", "适当", "圣人", "山包海容", "金屋娇娘", "伟绩丰功", "雍容閒雅", "才子", "心肝宝贝", "誓愿", "宾服", "笨鸟先飞", "甘服", "多闻", "玩赏", "亲热", "牛刀小试", "范文", "不矜不伐", "细针密缕", "五颜六色", "收视反听", "嗓子好", "晴和", "涣然冰释", "饱雨", "自始至终", "抑暴扶弱", "兵权", "倾盖如故", "一见如故", "不食烟火", "不愧屋漏", "螽斯衍庆　", "柳腰莲脸", "雪窗萤火", "琼林玉树", "易如反掌", "扶危定倾", "望子成龙", "走笔成章", "喜雨", "渊渟岳立", "应机立断", "凤翥龙蟠", "王道", "反客为主", "回天", "弃过图新", "首屈一指", "兴腾", "义举", "儿女心肠", "搤臂啮指", "贤良方1", "破家为国", "惬当", "拥政爱民", "威风八面", "不磷不缁", "化民易俗", "根盘蒂结", "骨干", "心服口服", "多情多义", "老寿星", "三沐三薰", "陂湖禀量", "拿手好戏", "云窗霞户", "丰饶", "立国安邦", "公祭", "绰有余裕", "昭聋发聩", "事半功百", "深意", "靡然从风", "铁笔无私", "陷阵", "流脍人口", "劳驾", "大家闺秀", "相敬如宾"}
#惊
DUTIR_Jings = {"骇人视听", "拍案惊奇", "悬念", "无翼而飞", "原来", "冷门", "奇遇", "喔唷", "我去", "殷浩书空", "目眩神摇", "魂惊魄落", "单复之术", "示众", "奇特", "千载一时", "青天霹雳", "魂消魄丧", "恰巧", "鬼神不测", "希奇", "活脱", "怨不得", "恢恑憰怪", "和尚不吃豆腐－怪哉", "俛拾地芥", "目瞪口张", "魂消魄夺", "魂耗魄丧", "目瞪舌挢", "悬心", "措手不及", "河出伏流", "骇心动目", "奇怪", "不谓", "哄动一时", "魂慴色沮", "惊奇", "讶异", "百足之虫，死而不僵", "一怔", "魂惊胆落", "傥来之物", "怪事咄咄", "魂飞魄越", "瞠目结舌", "惊心惨目", "形迹可疑", "惊心骇瞩", "珍闻", "银河倒泻", "魂惭色褫", "跌眼镜", "好奇", "洞心骇目", "鬼使神差", "舌桥不下", "不期", "邪门儿", "咂嘴舔脣", "魂飘魄散", "骇然", "yun", "惊见骇闻", "好晕啊", "不可思议", "诧异", "怔住", "骤然", "目瞪口呆", "不期而遇", "无奇不有", "魂飞神丧", "撒豆成兵", "惊心怵目", "摇身一变", "大跌眼镜", "惊愕", "惊诧", "魂飞魄荡", "从天而降", "惊世骇目", "罕见", "令人咋舌", "骇怪", "大吃一惊", "晕倒", "千载难逢", "堤之千里，溃于蚁穴", "大惊失色", "哗然", "阴错阳差", "诡形奇制", "铁树开花", "魂惊魄惕", "惊天动地", "吃惊", "怔神儿", "石破天惊", "迅雷不及掩耳", "口呆目钝", "魂飞胆破", "魂消胆丧", "猛然", "骇目惊心", "别开生面", "奇异", "千载一遇", "亘古未有", "惊呆", "横生", "猝不及防", "哄动", "真晕啊", "撼天动地", "怔怔", "忽地", "惊世绝俗", "神秘", "目乱精迷", "目瞪口结", "动人心魄", "平地一声雷", "蹊跷", "怪讶", "诧愕", "鞭策", "不期然而然", "晴天霹雳", "愕然", "惊服", "目瞪舌彊", "惊疑", "铁树花开", "意出望外", "目乱睛迷", "纳罕", "_god", "意料之外", "848", "FT", "回光返照", "魂飞胆丧", "惊世震俗", "魂惊胆颤", "目瞪口僵", "异军突起", "出人意表", "讶然失色", "魂飞胆战", "震慑人心", "惊爆", "恍然", "一个骰子掷七点－出乎意料", "平地风波", "稀奇古怪", "震撼人心", "一举成名", "震撼寰宇", "意想不到", "忽而", "奇妙", "低估", "魂丧神夺", "不期而然", "动地惊天", "千奇百怪", "天惊石破", "海外奇谈", "骇人闻听", "冷不丁", "轰天裂地", "不虞之誉", "讶然", "惊动", "奇袭", "奇闻", "惊奇不已", "奇迹", "惊异", "突如其来", "离奇古怪", "咂嘴咂舌", "咄咄怪事", "惊怪", "错愕", "逐新趣异", "震天动地", "不得了", "咂嘴弄脣", "惊耳骇目", "目瞪口歪", "惊叹", "世外桃源", "神神秘秘", "惊愚骇俗", "不料", "天崩地裂", "可惊", "骇人闻见", "洞心骇耳", "魂飞胆裂", "叹为观止", "亘古奇闻", "无巧不成书", "光怪陆离", "匪夷所思", "冷不防", "猛不防", "悬系", "惊人", "惊讶", "骇龙走蛇", "魂飞胆落", "震悚", "一步登天", "奇谈", "神妙莫测", "猛孤丁地", "魂飞魄飏", "神奇", "黄河水清", "轰动", "寒噤", "铁树开华", "口呆目瞪"}
#惧
DUTIR_Jus = {"山摇地动", "月黑风高", "流血", "老鼠偷猫饭－心惊肉跳", "一发千钧", "八公山上，草木皆兵", "黑漆寥光", "行刺", "担惊受恐", "波涛", "部分质变", "惊弓之鸟", "神情不属", "重足而立，侧目而视", "杯影蛇弓", "认生", "赔小心", "担忧", "致命", "事关重大", "马仰人翻", "舌挢不下", "夜场梦多", "凶宅", "鹤唳风声", "心忙意急", "株连蔓引", "虎穴", "迫於眉睫", "张皇", "一年被蛇咬，三年怕草索", "不知所厝", "燕巢幕上", "性命攸关", "心慌撩乱", "晦冥", "寝不安席", "千钧一发", "束手无计", "夏日可畏", "忸怩作态", "搏斗", "魂飞胆颤", "家丑", "骇惧", "满坑满谷", "惊慌无措", "失张失志", "惊怕", "击搏挽裂", "魂不守宅", "丧胆", "釜底游魂", "困心衡虑", "危急", "心惊胆落", "溃散", "鞭打", "阴险毒辣", "慌乱", "汗流夹背", "千难万险", "匪患", "煞白", "丢丑", "请降", "羞人答答", "狼奔鼠窜", "失措", "心寒胆战", "羞恶", "累卵之危", "食不终味", "面如死灰", "发急", "憷头", "鹰瞵鹗视", "严刑", "履霜坚冰", "扑腾", "中计", "囚牢", "脸无人色", "丢魂失魄", "杜口吞声", "血雨腥风", "紧要", "追魂夺魄", "筛糠", "惊心吊魄", "十万火急", "仓卒从事", "心神不宁", "毛咕", "鬼哭神惊", "洪水横流", "惊悚", "惊心夺目", "惊皇失措", "十死一生", "惊魂夺魄", "布氏杆菌病", "热战", "失魂荡魄", "内外夹攻", "腹热肠荒", "无面目见江东父老", "鼻咽癌", "迫在眉睫", "晕池", "忙不择价", "心神不定", "福不重至，祸必重来", "股栗", "丢魂丢魄", "冰窖", "求靠", "杯弓市虎", "方寸已乱", "厉鬼", "画无人色", "神不收舍", "进退亡据", "有毒性", "当头一棒", "黑茫茫", "顷刻", "闹鬼", "牛蹄中鱼", "抱佛脚", "慌慌张张", "节骨眼", "恍忽", "畏难", "心如悬旌", "行色匆匆", "惊魂失魄", "亡魂失魄", "屏气慑息", "风雨漂摇", "晕高儿", "相形见绌", "望而生畏", "畏惧", "脸红筋暴", "险些", "目瞪心骇", "悄悄", "食不甘味", "惊愕失色", "目眐心骇", "惶恐不安", "进网的鱼虾－慌了手脚", "杜口绝言", "心急如火", "七…八…", "束手无措", "紧急", "魂飞魄丧", "灭顶之灾", "慌张", "旱魃为虐", "交战", "心上心下", "五马分尸", "胆战心摇", "困难", "虎穴龙潭", "左支右吾", "昼阴夜阳", "仗马寒蝉", "腆颜", "主宰", "生死攸关", "隔墙有耳", "震慑", "惟恐", "骇然", "着慌", "虚怯", "岌岌不可终日", "委肉虎蹊", "毛骨悚然", "小心翼翼", "惶遽", "后患无穷", "匕首", "跼高蹐厚", "左支右调", "恇怯不前", "死路", "进退失踞", "失魂丧魄", "扰动", "惊心眩目", "毕命", "乱葬岗子", "心惊肉战", "惶恐", "作好作歹", "龙潭虎窟", "铁腕", "惊心悼胆", "不利", "失惊倒怪", "火妻灰子", "胆颤心惊", "大眼贼", "胁肩絫足", "局促", "愧汗", "白区", "鹿死不择廕", "仓皇失措", "娇羞", "避难", "重点", "骇目振心", "惊风骇浪", "羞愧", "受惊", "风风火火", "原子武器", "丧胆游魂", "魂飘神荡", "阴恶", "乔装", "脚板上长草－慌了脚", "丧魂落魄", "雪窖冰天", "病原菌", "病痛", "面色如土", "鼎鱼幕燕", "赤痢", "势成骑虎", "盲人骑瞎马", "碍口识羞", "魂不附体", "忑忑忐忐", "阽危之域", "波谲云诡", "燃眉之急", "濒危", "厉害", "阴沉沉", "黑洞洞", "横灾飞祸", "诚惶诚恐", "屎流屁滚", "发憷", "病害", "惊恐", "惊恐万状", "凶焰", "惊险", "心劳意冗", "壁间蛇影", "险症", "栗栗危俱", "神魂荡飏", "追逼", "黑黢黢", "众目睽睽", "发毛咕", "兵乱", "脸红耳赤", "坐卧不安", "伈伈睍睍", "窘促", "羊落虎口", "骤不及防", "目动言肆", "因噎废食", "战战栗栗", "心惊胆颤", "露丑", "通缉", "大厦将颠", "焦急", "草木皆兵", "畏葸", "杯中蛇影", "添堵", "一座皆惊", "摇摇欲坠", "麇骇雉伏", "崩症", "狐凭鼠伏", "性急", "杀人不见血", "险乎", "人事", "惧色", "不敢当", "狼顾麕惊", "大难临头", "凄厉", "惊慌", "危殆", "不好惹", "肘腋之患", "膝语蛇行", "龇牙裂嘴", "前门拒虎，后门进狼", "祸结兵连", "五色无主", "智藏瘝在", "急务", "踵足相接", "无地自厝", "如箭在弦", "厝火积薪", "不祥", "手足失措", "赤霉病", "隐忧", "凶杀", "左枝右梧", "动荡不安", "擢筋割骨", "刀俎馀生", "仑皇失措", "前门进虎，后门进狼", "脚忙手乱", "逃遁", "怦怦", "云翳", "天险", "情夫", "人荒马乱", "不可终日", "切骨之寒", "怯生生", "一触即发", "森严", "胆怯", "艰险", "够瞧的", "撧耳挠腮", "急赤白脸", "无立足之地", "惨怛", "赘瘤", "饶命", "神不守舍", "险厄", "惊魂丧魄", "一则以喜，一则以惧", "杌陧", "肠伤寒", "心惊胆裂", "半三不四", "相形失色", "兵器", "毛发悚然", "鸟骇鼠窜", "心胆俱裂", "求生", "急切", "翻来覆去", "只轮不返", "恐后无凭", "绞手", "危机重重", "变乱", "危如累卵", "汗流洽背", "乱了方寸", "震撼", "抄家", "人人自危", "畏忌", "视为畏途", "惕励", "被猎人追赶的金鹿－慌里慌张", "让步", "覆巢无完卵", "心胆俱碎", "胆丧魂惊", "磨不开", "积羽沉舟", "惊心破胆", "大厦将倾", "惕厉", "不安", "匆忙", "血晕", "举止失措", "掷鼠忌器", "气消胆夺", "昼警夕惕", "苯中毒", "缩头缩尾", "骇浪惊涛", "人言可畏", "汗流洽衣", "紧急状态", "刻不容缓", "局促不安", "七慌八乱", "手足无措", "金刚努目", "战战兢兢", "心劳意攘", "险要", "面面相睹", "剧毒", "补考", "鹿死不择音", "胆寒", "鸿门宴", "撒旦", "神逝魄夺", "打呼噜听见放炮－吓人一跳", "惨厉", "丧魂失魄", "抓紧", "凶多吉少", "狼狈周章", "心事", "销魂荡魄", "膝行", "众怒难犯", "非同小可", "火急", "天有不测风云", "发慌", "屈服", "失魂丧胆", "噤若寒蝉", "杀气腾腾", "鸟惊鼠窜", "如狼如虎", "行凶", "慌手忙脚", "谨防", "祸起肘腋之间", "慌神", "漆黑一团", "动刑", "团团转", "闻风丧胆", "慌手慌脚", "严峻", "惶然不安", "心有余悸", "贼人心虚", "履虎尾", "惊惶无措", "害臊", "不迭", "绞杀战", "险地", "恐怖", "孙大圣闹天宫－慌了神", "面红耳赤", "斤斤自守", "兵临城下", "骇异", "毛发森竖", "釜鱼幕燕", "拽巷逻街", "六神不安", "不祥之兆", "天崩地坼", "眩晕", "汗流接踵", "没头苍蝇", "心切", "羞于", "汗流满面", "神魂飘荡", "缓不济急", "惴惴", "粉身碎骨", "招致不幸", "分化瓦解", "汗流浃背", "碎心裂胆", "求救", "惧怕", "闷雷", "羞赧", "三伏天发抖－不寒而栗", "横殃飞祸", "危机存亡之秋", "碍口", "不过意", "履霜之戒", "局天蹐地", "局高蹐厚", "惊惶失措", "意乱心忙", "豪末不掇，将成斧柯", "低眉垂眼", "飞灾横祸", "抱火寝薪", "怀里揣着个小兔子－怦怦直跳", "临深履薄", "虎狼之穴", "如芒在背", "困兽犹斗", "险滩", "避乱", "阎王", "失火", "劳心焦思", "忐忑不定", "惊魂摄魄", "忌惮", "匪穴", "拶子", "龇牙咧嘴", "心头撞鹿", "鞋里长草－慌了脚", "拉不下脸", "肠阻塞", "逡巡", "羞羞答答", "神思恍惚", "骨软筋酥", "腹心之疾", "心腹之患", "狼奔兔脱", "虎视眈眈", "噩梦", "心头鹿撞", "魂不赴体", "不堪设想", "原子炸弹", "惶然", "危急存亡之秋", "急杵捣心", "踵趾相接", "抓耳搔腮", "暗礁", "余悸", "胆裂魂飞", "平靖", "担惊受怕", "危惧", "鬼哭神号", "惊魂未定", "令人不安", "迁延观望", "羞涩", "追亡逐北", "撧耳揉腮", "恐慌万状", "树高招风", "触目", "安危相易", "胆丧魂消", "天堑", "迫近", "急风暴雨", "辟易", "追捕", "性命交关", "跳脚", "星飞电急", "急忙", "张徨失措", "倒执手版", "病粒", "如履薄冰", "讳言", "绑架", "做好做恶", "窘急", "逃反", "眉睫之祸", "羞答答", "可骇", "不好意思", "瘆人", "财政危机", "顾左右而言其他", "忐忑不安", "失灵", "挠腮撧耳", "面面相看", "危言竦论", "紧绷绷", "大敌当前", "惊心悲魄", "惶惧", "鸷狠狼戾", "如临深渊", "飞来横祸", "病例", "危急存亡", "小媳妇见了恶婆婆－心里直扑腾", "魂不守舍", "冰凉", "火烧眉毛", "畏敌如虎", "憷场", "面如土色", "临阵磨枪", "溃不成军", "剑树刀山", "岌岌可危", "捉襟肘见", "险僻", "猪瘟", "心寒胆落", "回肠", "伤弓之鸟", "暴风雪", "躭惊受怕", "惊魂动魄", "东藏西躲", "丙夜", "拶指", "骇愕", "炮火连天", "风声鹤唳", "刿目怵心", "暴乱", "不知所措", "担风险", "凶险", "波荡", "神不附体", "火烧火燎", "心焦如焚", "鸟惊鱼散", "逃奔", "龙潭虎穴", "捉衿露肘", "腼腆", "暴洪", "入超", "间不容发", "惴栗", "刿心怵目", "在逃", "惶惶而不可终日", "心孤意怯", "心急火燎", "福善祸淫", "侧目而视", "心慌", "簸荡", "急来抱佛脚", "悬崖峭壁", "寺庙里失火－慌了神", "切忌", "战战业业", "惊惧", "鱼游沸釜", "心神恍惚", "胆寒发竖", "怔忪", "叮咛", "血淋淋", "囚车", "绞杀", "仓促", "凶相", "鬼泣神嚎", "踵武相接", "畏友", "耗子遇见猫－六神无主", "惶惶", "冷峭", "戒惧", "不宁", "魂亡胆落", "突兀", "红潮", "箭在弦上", "唯唯诺诺", "汗流浃肤", "惧内", "自愧弗如", "可怖", "头难", "横祸飞灾", "忐上忑下", "变天", "倾耳侧目", "新来乍到", "危於累卵", "中心摇摇", "鱼游釜底", "逃亡", "千里之隄，溃于蚁穴", "尘肺", "做刚做柔", "体力不支", "寒心酸鼻", "仓卒应战", "燕雀处堂", "天坍地陷", "堤防", "险兆", "晕车", "恫毅虚喝", "齐大非耦", "如临大敌", "慑服", "人情汹汹", "惊心骇神", "警戒", "怯然", "最后一根稻草", "钳口挢舌", "尘埃传染", "万死一生", "战兢兢", "拽巷啰街", "履薄临深", "敛声屏气", "惊魂", "阴森森", "窃窃", "怕生", "移东补西", "擢筋剥肤", "悔过", "变动", "气吁吁", "破击", "求饶", "发怵", "出丑", "慌忙", "背气", "惊心吊胆", "天灾人祸", "且慢", "泼天大祸", "汗颜", "患得患失", "黑风孽海", "慌神儿", "仓卒之际", "饮冰内热", "心惊胆寒", "小心", "黑蒙蒙", "七口八嘴", "唯恐", "敛声屏息", "提心吊胆", "抢救", "逃匿", "赧然", "谈虎色变", "心殒胆落", "鬼哭狼嗥", "崩漏", "羞惭", "忧人发迹怕自穷", "烂额焦头", "屁滚尿流", "悄没声儿", "皮开肉绽", "囚禁", "闻雷失箸", "马去马归", "狼前虎后", "遑遑", "有害", "壮胆", "腹热心煎", "洪水猛兽", "恐后争先", "惟日不足", "刀光剑影", "撞车", "撧耳顿足", "魄散魂飞", "险情", "险象", "汗流浃体", "濒于", "忙忙碌碌", "神丧胆落", "够戗", "慌恐", "惊心褫魄", "前怕狼后怕虎", "九死一生", "下台", "毛发耸然", "拽巷攞街", "心乔意怯", "重兵", "鱼游釜内", "崩塌", "思深忧远", "大火烧了菩萨庙－慌神了", "刀头剑首", "惊神破胆", "杯蛇幻影", "难为情", "害羞", "追问", "惩戒", "无地自处", "身寄虎吻", "七上八下", "病院", "捉衿肘见", "雪虐风饕", "急躁", "捉衿见肘", "鱼游釜中", "幽灵", "握蛇骑虎", "捩手覆羹", "杜口无言", "忧心仲忡", "碍面子", "结巴", "心荡神迷", "二愣子报丧－慌里慌张", "灾难性", "心悸", "不寒而栗", "食不遑味", "可怕", "逃逸", "肘胁之患", "尿流屁滚", "牢狱", "屏气吞声", "季常之惧", "匆匆", "面面相觑", "急迫", "求人", "芒刺在背", "吴牛喘月", "不旋踵", "抢先", "跑警报", "鼓睛暴眼", "惶惶然", "生怕", "黑灯瞎火", "做神做鬼", "张皇失措", "寄颜无所", "天台路迷", "脸皮薄", "惊弦之鸟", "魂飞魄散", "栗栗危惧", "热锅上的蚂蚁－团团转", "丧胆销魂", "凶殴", "黑漆漆", "热辣辣", "定时炸弹", "驱迫", "跼高天蹐厚地", "晦暝", "愧色", "汗流至踵", "面如灰土", "脸红", "雀目鼠步", "藏踪蹑迹", "毛森骨立", "胸脯长草－心慌", "黑云压城城欲摧", "急如风火", "惊骇", "黑森森", "虎口", "鸟散鱼溃", "胁持", "脸上下不来", "亟亟", "如鸟兽散", "失张失致", "阴凄", "冤魂", "乱坟岗", "烟视媚行", "耻辱", "蹑手蹑脚", "失张失智", "急若流星", "火急火燎", "悬心吊胆", "情见势屈", "目不见睫", "手脚无措", "惊心丧魄", "惊惶", "众目昭彰", "急刹车", "紧张", "含羞", "肤粟股栗", "急用", "羞窘", "茫然", "惊醒", "肉刑", "恐慌", "失惊打怪", "骨软筋麻", "逃命", "腹热肠慌", "晕厥", "心虚", "暴病", "鱼游沸鼎", "人心惶惶", "畏途", "急促", "动乱", "目不交睫", "三魂出窍", "负荆谢罪", "胆战心惊", "危机四伏", "前跋后疐", "追亡逐遁", "黯然失色", "面若死灰", "便血", "劫夺", "严酷", "毛骨竦然", "忡忡", "认帐", "东闪西挪", "跑反", "飞殃走祸", "神经错乱", "认罪", "生恐", "提心在口", "病原虫", "做贼心虚", "奔窜", "心焦火燎", "有毒", "暴动", "羞臊", "启齿", "破胆寒心", "吓人", "惊心裂胆", "冰雹", "屎屁直流", "抠心挖血", "绞痛", "吃紧", "人情恟恟", "神迷意夺", "惶惶不可终日", "心忙意乱", "虎尾春冰", "犯怵", "森然", "劫持", "重足而立", "匆猝", "分裂", "象齿焚身", "抹不开", "认错", "危若朝露", "病毒性肝炎", "小巫见大巫", "残废", "鬼哭神愁", "兵慌马乱", "胆战心慌", "食不知味", "徬徨失措", "矜持", "相惊伯有", "捉刀", "山高水险", "枯脑焦心", "鸟惊鱼溃", "并发症", "胆战心寒", "十死九活", "羊入虎群", "追奔逐北", "犯憷", "屏声息气", "山羊见了老虎皮－望而生畏", "在劫难逃", "蹀躞不下", "鱼县鸟窜", "心急", "暗礁险滩", "来者不善，善者不来", "天灾", "交火", "心惊胆战", "羞面见人", "面面相窥", "手忙脚乱", "踞炉炭上", "杯蛇鬼车", "惊心惮胆", "落汤的螃蟹－手忙脚乱", "低头搭脑", "弥天大祸", "一蛇两头", "寒心消志", "心惊肉跳", "险象环生", "牢房", "恣凶稔恶", "呆似木鸡", "魂飞天外", "生死存亡", "险工", "人心皇皇", "露怯", "畏缩", "失踪", "毛骨耸然", "惊慌失色", "忸忸怩怩", "不是玩儿的", "瞎子过索桥－提心吊胆", "暴风雨", "叮嘱", "下不来", "绑票", "兵变", "惊怖", "病魔", "杯弓蛇影", "崩落", "逃难", "存亡绝续", "害怕", "奉命唯谨", "腹背受敌", "慌不择路", "重围", "鼠窜蜂逝", "戕身伐命", "气咻咻", "东窗事发", "惊涛骇浪", "冰霜", "谷马砺兵", "朽索驭马", "产褥感染", "鞭笞", "惊慌失措", "逃散", "赔笑", "失魂落魄", "坐不安席", "惊吓", "畏罪", "四郊多垒", "紧迫", "捉襟露肘", "惊厥", "心慌意急", "险恶", "危如丝发", "鸟惊鱼骇", "土狗子", "潜伏", "漆黑", "凶煞", "面无人色", "亡魂丧胆", "波及", "抓狂", "狼狈万状", "被发缨冠", "战战惶惶", "逃犯", "鬼哭神嚎", "急不可待", "肝髓流野", "后怕", "弄影团风", "脸红耳热", "绕弯子", "天崩地陷", "晦暗", "卷席而居", "六神无主", "七首八脚", "前门去虎，后门进狼", "呆如木鸡", "震惊", "进退失措", "日趋", "丢脸", "羞耻", "死里逃生", "顾此失彼", "丢魂丧胆", "冲杀", "惭怍", "敛手屏足", "鬼魔", "胁肩累足", "急如星火", "瑟瑟", "恐惧", "残疾", "面面厮觑", "颤颤悠悠", "火辣辣", "震荡", "仓皇", "倒持手板", "无时无刻", "撞见", "紧急集合", "囚笼", "水火兵虫", "急茬儿", "阻山带河", "搔头摸耳", "侧足而立", "仲裁", "惨烈", "做好做歹", "窘涩", "鱼游燋釜", "病毒", "曲折", "进退失所", "情急", "受窘", "钻心刺骨", "屈挠", "心慌意乱", "丢人", "惊心骇目", "扭捏", "凶兆", "病原体", "魔怪", "令人毛骨悚然", "忙中有失", "地狱", "土蚕", "一脸横肉", "惊魂落魄", "疑惧", "热锅上的蚂蚁", "骇然失色", "危在旦夕", "东滚西爬", "德薄能鲜", "坐卧针氈", "阴森", "高抬贵手", "时不待我", "刀山火海", "强颜", "诡秘", "望而却步", "风兵草甲", "树大招风", "似箭在弦", "危亡", "张嘴挢舌", "惶悚", "怯场"}
#乐
DUTIR_Les = {"含哺鼓腹", "欢呼鼓舞", "莺歌蝶舞", "将伯之助", "逸兴横飞", "舒畅", "两得其便", "垂手而得", "欣幸", "增殖", "遇合", "铸甲销戈", "坐山观虎斗", "柳暗花遮", "抚慰", "拜年", "顺非而泽", "一得之功", "彻悟", "解除", "酣饮", "喜从天降", "安歇", "自得其乐", "民脂民膏", "適可而止", "神意自若", "相视而笑", "微笑", "其乐融融", "三对六面", "高朋满座", "嘻嘻哈哈", "大白", "神怡心旷", "锵金鸣玉", "转世", "激发", "燕雀相贺", "遣兴陶情", "笑颜", "旌旗蔽日", "天趣", "三昧", "旱苗得雨", "求仁得仁", "放怀", "心广体胖", "绰绰有余", "心潮澎湃", "安身为乐", "接援", "一方平安", "三思而行", "品尝", "凑趣儿", "死骨更肉", "慢腾斯礼", "还珠返璧", "升迁", "急拍繁弦", "开花结实", "化枭为鸠", "政清人和", "天从人愿", "连阶累任", "包管", "天伦之乐", "同心戮力", "怡神", "优容", "化险为夷", "奏凯", "谅解", "笑咪咪", "拄笏看山", "夹道欢呼", "生财", "哗笑", "逍遥自在", "兴致淋漓", "凭证", "踏实", "无虑无忧", "乐陶陶", "无往不利", "黄发鮐背", "付之一笑", "开怀", "河清云庆", "俎樽折冲", "高枕安卧", "安于一隅", "网开三面", "优游自在", "陶然而醉", "便当", "鼓乐齐鸣", "顺风使船", "中兴", "出头", "报捷", "振奋", "顺风扯帆", "不忮不求", "安心落意", "轻而易举", "丰登", "安外", "巫山云雨", "赚钱", "万寿无疆　", "声应气求", "顺理成章", "莺飞草长", "拄笏西山", "欢笑", "华年", "吐气扬眉", "游兴", "气骄志满", "悠闲", "金石丝竹", "九月里的甘蔗－甜到心", "空谷足音", "眉开眼笑", "凿坏而遁", "一路顺风", "两世为人", "挂灯结彩", "亲热亲热", "正中下怀", "河溓海晏", "游戏", "粟红贯朽", "连战皆捷", "相安", "增长", "春风得意", "甜美", "家给人足", "哑笑", "在所难免", "失之东隅，收之桑榆", "大白于天下", "和美", "好天良夜", "公道合理", "抚掌大笑", "安闲自在", "鸢飞鱼跃", "得意洋洋", "重见天日", "名正言顺", "庇佑", "履盈蹈满", "喜出望外", "情愿", "惠然", "哦耶", "清明", "水天一色", "中选", "游园", "安神定魄", "紫气东来", "焕然如新", "献花", "爽适", "日暖风和", "兄弟怡怡", "坐不重席", "爽然自失", "陶然", "玉燕投怀", "酌古御今", "开展", "欣忭", "笑容", "红叶题诗", "消夏", "遂愿", "亲嘴", "闾阎安堵", "铸剑为犁", "Happy", "黄袍加体", "闻宠若惊", "计获事足", "天国", "顺流而下", "开心", "和气致祥", "沉静", "安神", "吃得住", "慢条斯礼", "随寓而安", "桂冠", "喜鹊", "民安物阜", "陶情适性", "暴笑", "胜任愉快", "静谧", "润格", "乐天安命", "释疑", "游戏尘寰", "陶陶", "贺年", "安居乐业", "烛光", "风雨对床", "眉头一皱，计上心来", "抱子弄孙", "众说", "振发", "恬淡无为", "欢声", "解颐", "自然", "死里求生", "人逢喜事精神爽", "秋月春风", "批风抹月", "猛虎添翼", "万家灯火", "喜报", "呈祥", "求婚", "涣然", "一帆风顺", "o(∩_∩)o", "哂笑", "包圆儿", "新昏宴尔", "快心满志", "视险如夷", "沉着", "像心称意", "谧静", "令人满意", "心花怒发", "珠还合浦", "如履平地", "广夏细旃", "朝阳", "日丽风和", "黄童白叟", "捷书", "乐悠悠", "杀鸡为黍", "酌盈剂虚", "洞房花烛", "足食丰衣", "摆脱", "特等", "倒海翻江", "熨帖", "喜悦", "尽欢", "新婚", "神融气泰", "心花怒放", "进展", "枯树逢春", "坐享其功", "放歌纵酒", "胸中有数", "佐雍得尝", "阳关大道", "尽情", "恢复", "兵无血刃", "安家乐业", "自由自在", "知足", "愿意", "嬉戏", "遇救", "禳解", "足不出门", "敲锣打鼓", "赚头", "生业", "持家", "河清三日", "欢歌", "庆祝", "怡然自得", "神飞气扬", "笑谈", "归马放牛", "沁入心脾", "知遇", "转败为功", "如愿以偿", "一团和气", "各得其宜", "激扬", "龙凤呈祥", "適以相成", "大喜", "遂心满意", "佐饔得尝", "带劲", "开豁", "兵藏武库，马入华山", "泛泛之交", "包容", "仰不愧天", "举国若狂", "欣跃", "理冤摘伏", "遁逸无闷", "杯酒言欢", "随寓随安", "解气", "真相大白", "逗人", "愿望", "欣悉", "入结家足", "闲云野鹤", "安闲", "还愿", "遂心如意", "骀荡", "歌吟", "丰亨豫大", "感奋", "十成九稳", "兴奋", "油然而生", "如鱼似水", "恍然大悟", "胡敲梆子乱击磬－欢喜若狂", "瑞雪", "吉日良辰", "好事", "启发", "门庭如市", "旷心怡神", "大幸", "喜色", "顺风吹火", "甘心情愿", "如梦初觉", "轻飘飘", "调侃", "丸泥封关", "快慰", "起来", "高官厚禄", "面无愧色", "惊喜", "含饴弄孙", "与世无争", "即以其人之道，还治其人之身", "情深潭水", "破格", "飞越", "着落", "死得其所", "钻头觅缝", "黄粱美梦", "畅适", "食甘寝宁", "和解", "满足", "逍遥物外", "乐乐陶陶", "安慰", "哑巴拾金条－喜不可言", "黄龙痛饮", "喜跃抃舞", "拉朽摧枯", "含笑入地", "凯歌", "恬然自足", "优礼", "超额利润", "歇心", "舒意", "讨饭的捡黄金－喜出望外", "可心如意", "得时", "笑貌", "心怡神旷", "红包", "做一天和尚撞一天钟", "对酒当歌", "善处", "主情造意", "恭贺", "闾阎扑地", "言论风生", "连珠合璧", "喜洋洋", "处之泰然", "天女散花", "神流气鬯", "喜联", "战果", "足食足兵", "夺魁", "堆金叠玉", "愉悦", "安堵如故", "笑影", "月夕花朝", "吃著不尽", "打底", "随意", "转祸为福", "鼓舞欢欣", "展望", "喜上眉梢", "从容应对", "顺利", "安眠", "凤引九雏", "优游岁月", "怡乐", "恭喜", "成亲", "元夜", "丰年", "喜酒", "解颜而笑", "喜幸", "雨过天青", "海阔天空", "门不夜关", "额手相庆", "快心满意", "高歌", "逸兴云飞", "慢条丝礼", "极情尽致", "众生", "协力", "面有喜色", "捧檄色喜", "驰骋", "酣畅淋漓", "逗闷子", "夺金", "愉快", "枯木发荣", "撒欢儿", "彩虹", "晋级", "心悦神怡", "反败为胜", "披红", "长治久安", "韶颜稚齿", "手舞足蹈", "鼓乐喧天", "充实", "否极泰来", "鼎沸", "供不应求", "以石投水", "可喜", "喜气", "爱美的", "坦然自若", "确信", "离蔬释蹻", "百龄眉寿", "色授魂与", "欣欣自得", "如许", "约会", "开云见天", "畅游", "兴会", "安稳", "探囊取物", "文修武偃", "十光五色", "优抚", "左右逢原", "增生", "怡情悦性", "摆设", "如意", "巫云楚雨", "蛟龙得水", "松快", "三曹对案", "晋职", "生息", "神采焕发", "转游", "风和日丽", "哑巴讨老婆－喜在心里", "否极阳回", "寿元无量　", "抃风儛润", "舒快", "邦交", "起色", "欢乐", "热闹", "发蒙振落", "太平", "两相情愿", "浅笑", "一拍即合", "LOL", "遵而勿失", "遵养待时", "快活", "飞驰", "匡乱反正", "破涕", "神来气旺", "委委佗佗", "遂心快意", "安步当车", "俯首戢耳", "回心转意", "飞翔", "酣梦", "haha", "和缓", "喜形於色", "涂歌里咏", "气昂昂", "得手", "制胜", "日丽风清", "饭蔬饮水", "奔头儿", "悠闲自在", "墙头马上", "迷途知返", "天幸", "与民同乐", "茅塞顿开", "平反", "撑肠拄腹", "喜兴", "任便", "对偶婚", "食饥息劳", "看淡", "拈花微笑", "豁然", "订婚", "尻舆神马", "顺心", "晒暖儿", "岿然独存", "放眼", "蒲包", "顺水顺风", "激昂", "时亨运泰", "解纷", "久旱逢甘雨", "瑞气", "六根清净", "元宵", "兴冲冲", "藏器待时", "乐道安命", "柳影花阴", "乌衣之游", "转运", "情怀", "消气", "扫平", "乐在其中", "破愁为笑", "气满志得", "青春", "范进中举－喜疯了", "好玩", "椿萱并茂", "悠然自得", "辑睦", "开怀儿", "开眉展眼", "拍手称快", "去危就安", "如愿", "因祸得福", "大获全胜", "清湛", "麦秀两歧", "和乐", "视同拱璧", "周而复始", "自我陶醉", "破涕为笑", "生趣", "上进", "飞黄腾达", "安乐窝", "悬灯结彩", "展翅", "红红火火", "斫琱为朴", "开眉笑眼", "安详", "了身脱命", "各取所需", "欢宴", "清和", "地久天长", "有缘千里来相会", "相门有相", "中西合璧", "笑剧", "甜蜜", "掷杖成龙", "盈余", "CC", "惊喜欲狂", "坦直", "乐不可言", "乐园", "望梅止渴", "专心一志", "中流击楫", "放情", "享受", "坦诚相见", "热呼", "破壁飞去", "宽心", "哇哈哈", "高官重禄", "得意", "河清海宴", "风雨时若", "大功告成", "骋怀", "济济一堂", "光复", "如天之福", "破涕成笑", "河溓海夷", "娱心", "先睹为快", "平安", "恬适", "哈哈", "打成一片", "熟路轻车", "击壤鼓腹", "竹苞松茂　", "珠连璧合", "切理会心", "顿开茅塞", "左右逢源", "晋升", "凫趋雀跃", "悲欢离合", "缱绻", "欢呼", "增光", "平静", "醉吐相茵", "俯仰无愧", "起劲", "普天同庆", "喜钱", "贫而乐道", "乐滋滋", "神采飞扬", "使人愉快", "获准", "解甲归田", "转灾为福", "丰足", "塞翁失马", "取之不尽，用之不竭", "菽水承欢", "如故", "展眼舒眉", "hiahia", "乐天", "欣然自得", "嬉笑", "只可意会，不可言传", "慢条厮礼", "神怿气愉", "沁人心脾", "结彩", "太公钓鱼，愿者上钩", "喜剧", "喷饭", "拄颊看山", "情爱", "不关痛痒", "得意忘言", "美滋滋", "万事亨通", "兴高彩烈", "拳拳", "妙趣横生", "散闷", "六尘不染", "众人国士", "亲口", "涤荡", "如鱼得水", "使喜悦", "恬静", "停战", "陪侍", "吃着不尽", "静心", "洋洋得意", "喜笑颜开", "涂歌里抃", "欢庆", "无官一身轻", "否极泰回", "欣然", "增援", "逢凶化吉", "神清气爽", "热情洋溢", "成效", "发噱", "水明山秀", "载歌载舞", "神领意得", "茶余酒后", "千岩竞秀", "塌实", "和蔼可亲", "合意", "凿坏以遁", "从容", "宽限", "神超形越", "拜客", "无拘无束", "任凭", "绰绰有裕", "天堂", "醉山颓倒", "云雨巫山", "麦穗两岐", "旭日东升", "轩轩甚得", "倾吐", "批郤导窾", "门不夜扃", "花好月圆", "平平当当", "吉利", "欢娱", "眉飞色舞", "新婚宴尔", "觥筹交错", "飘飘然", "喜娘", "容身", "潜流", "欢欢喜喜", "扑面", "轻快", "畅述", "奔驰", "坐树不言", "扳不倒儿", "柳暗花明又一村", "献词", "水落石出", "日月重光", "鸿飞冥冥", "华冠丽服", "酒逢知己千钟少", "酌古沿今", "適性任情", "称庆", "敞亮", "心安理得", "寂静", "十世单传", "欣快", "鹊笑鸠舞　", "快意", "畅通", "吉庆", "开颜", "香甜", "优游涵泳", "存亡续绝", "恬然", "极乐世界", "会心", "得济", "缓和", "荣获", "春风满面", "潜光隐耀", "大白于世", "平生愿足", "新媳妇过门－大喜", "食甘寝安", "令人捧腹", "呼朋引类", "珠玉在侧　", "开胃", "千仓万箱", "超然", "吉日", "捷报频传", "班师", "增进", "小康", "乐颠颠", "镇静", "坐无虚席", "急管繁弦", "悲喜交集", "昂奋", "有凤来仪", "额手称颂", "热乎乎", "刀枪入库，马放南山", "七夕", "生机勃勃", "泠泠", "噱头", "悠哉游哉", "尽欢而散", "引吭高歌", "適性忘虑", "准许", "克绍箕裘", "大团结", "顺风张帆", "三清四白", "进禄加官", "帮衬", "中外合璧", "荣登", "闲情逸趣", "夺标", "天随人原", "驻颜益寿", "他山之石", "安乐", "平服", "游乐", "官运亨通", "安然", "志得气盈", "如获至宝", "增强", "广土众民", "吉兆", "皆大欢喜", "干脆", "安常履顺", "喜糖", "哑然失笑", "信步", "淡然", "抵掌", "露脸", "高兴", "莺歌燕语", "满载而归", "绳其祖武", "高枕无忧", "普照", "击壤而歌", "财运亨通", "没齿无怨", "两小无猜　", "助我张目", "道喜", "绝倒", "鹊笑鸠舞", "互助", "爽畅", "前仰后合", "说笑", "解恨", "欢唱", "自豪", "人身自由", "安心定志", "插科打诨", "安身", "幕天席地", "左顾右眄", "欢欣", "四通五达", "修文偃武", "普通", "对歌", "漫条斯理", "民淳俗厚", "涸鱼得水", "惊喜交集", "取得", "有恃无恐", "十拏九稳", "逢吉丁辰", "足兵足食", "胜利果实", "享有", "心安", "三平二满", "包票", "含笑", "轻取", "心旷神愉", "电线杆上挂邮箱－高兴", "把酒持螯", "息怒", "和好", "心旷神恬", "平平", "改观", "秋波", "安然无事", "欢天喜地", "如鱼得水　", "时运亨通", "燕尔", "笑逐言开", "如梦初醒", "棋逢对手", "转悠", "逗笑儿", "满怀激情", "热恋", "高官显爵", "足不出户", "河清社鸣", "心荡神驰", "螽斯衍庆", "吉祥如意", "惬意", "塞北江南", "他乡遇故知", "恬淡", "从轻", "水来土掩", "笑眯眯", "温居", "恰好", "安分知足", "释怀", "朱衣点头", "致贺", "十世同堂", "优游自如", "好过", "切理厌心", "去故纳新", "高枕而卧", "曲径通幽", "一蹴而就", "避世绝俗", "心宽体胖", "优游自適", "既来之，则安之", "吉时", "诗情画意", "不胜", "喜事", "扬眉吐气", "何乐不为", "时通运泰", "高枕勿忧", "无奢望", "游玩", "醉翁之意不在酒", "发财", "祥瑞", "笑语", "跑跑跳跳", "祝愿", "清美", "乐不可支", "戏谑", "对得起", "笑容可掬", "徜徉", "称心如意", "忠言逆耳", "天上人间", "安恬", "洋溢", "乐业安居", "全家福", "心静", "满面春风", "人喊马嘶", "解剑拜仇", "安逸", "恝置", "切理餍心", "缓解", "乐于", "道贺", "开雾睹天", "遵养时晦", "大有年", ":)", "郎若列眉", "飘飘欲仙", "耳目一新", "衣钵相传", "身名两泰", "哺育", "令人高兴", "见怪不怪", "优哉游哉", "叫化子拾黄金－乐不可支", "好离好散", "喜不自禁", "乐得", "胜仗", "祝寿", "耳根清静", "超爽", "复苏", "逗趣儿", "兴会淋漓", "幸运", "入选", "不召而来", "洋洋自得", "洞房", "安全", "流水桃花", "遵而不失", "適如其分", "欣喜若狂", "笑脸", "熊罴入梦　", "嘻嘻", "痛饮黄龙", "援军", "海屋添筹　", "满脸春风", "柳暗花明", "和风丽日", "拜堂", "洗雪", "献礼", "天保九如　", "嘉慰", "適逢其会", "放松", "峰回路转", "喧腾", "情意绵绵", "娱乐", "安康", "火树琪花", "归正首邱", "娱心悦目", "耳热酒酣", "欢好", "升格", "联欢", "安适", "志满气得", "富国裕民", "兴高采烈", "大好", "优惠", "欢蹦乱跳", "大笑", "艳福", "解围", "若无其事", "安忍无亲", "救急", "酣睡", "酣甜", "溥天同庆", "安好", "理直气壮", "握雨携云", "涂歌邑诵", "燕舞莺啼", "赏心乐事", "凤凰来仪", "明月清风", "神闲气静", "加官进禄", "峨峨洋洋", "闲情逸致", "应节合拍", "水到鱼行", "擢升", "好笑", "心满意足", "应付自如", "遵时养晦", "和光同尘", "喜逐颜开", "风雨连床", "还朴反古", "渔夫赶上鱼汛－喜之不尽", "遁俗无闷", "顺风行船", "萨噶达娃节", "洋财", "轻软", "笑骂", "气满志骄", "满心欢喜", "得救", "欢声笑语", "否往泰来", "游艺", "得胜的猫儿－欢似虎", "成功", "一块石头落了地", "解黏去缚", "伏首贴耳", "乐意", "鼓腹含哺", "日暖风恬", "幸福", "称快", "欢忭鼓舞", "娴静", "喜乐", "畜妻养子", "不慌不忙", "欢忻鼓舞", "从宽", "欢腾", "沐仁浴义", "闲雅", "服服帖帖", "许婚", "佳节", "河海清宴", "酌盈注虚", "霁风朗月", "爱悦", "得志", "轻松", "欢畅", "急竹繁丝", "冻解冰释", "反手可得", "刘郎前度", "挥斥", "解决", "顺乎", "安生乐业", "批准", "河清海晏", "感人心脾", "包揽", "鳌掷鲸吞", "狂笑", "行乐", "瓮中捉鳖", "融融", "珠联玉映", "爽心", "称心如愿", "莺飞燕舞", "坦荡荡", "满脸春色", "径情直行", "舒服", "乐趣", "宽松", "元宵节", "心照不宣", "笑噱", "情形", "红火", "高升", "带牛佩犊", "春意", "和睦", "安土乐业", "加官进爵", "熟思审处", "喜盈盈", "举止自若", "夺冠", "享用", "安魂定魄", "不痴不聋", "神采", "猛虎插翅", "幸甚", "和颜说色", "回归", "顺和", "离蔬释屩", "消受", "送往事居", "解脱", "周游", "乐和", "烘堂大笑", "焕然", "诸如此类", "乔迁", "激活", "通过", "东山高卧", "心旷神飞", "手下留情", "民安国泰", "狂欢", "趣剧", "怡然", "拜天地", "益处", "得劲", "机遇", "随心所欲", "谐戏", "镜圆璧合", "暄腾", "还年驻色", "长乐未央", "入绪", "一颦一笑", "一路福星　", "达观", "瑞签", "笑逐颜开", "顺意", "碰杯", "够本", "民康物阜", "升官", "桂子飘香", "扶摇直上", "来好息师", "人非圣贤，孰能无过", "哺养", "喜冲冲", "步步登高", "顺适", "开花结果", "鼓腹含和", "得未曾有", "钟鼓之色", "福音", "以碫投卵", "亡戟得矛", "苦尽甘来", "见好", "热热闹闹", "如获至珍", "慰藉", "纵情", "弯腰捧腹", "鸿翔鸾起", "飞扬", "凿坯而遁", "入吾彀中", "康乐", "俯拾即是", "西天", "尽兴", "拿获", "消弭", "乐以忘忧", "犁庭扫穴", "人心大快", "投袂而起", "好受", "坦诚相待", "民膏民脂", "焕然冰释", "吉星", "深受感动", "增益", "鲤鱼跳龙门", "时来运转", "稳定性", "浮一大白", "麦穗两歧", "调情", "乐呵呵", "圆满", "欢闹", "鸣金收兵", "乐乐呵呵", "祥和", "开物成务", "情人", "清偿", "遇难成祥", "洗耻", "各得其所", "否终复泰", "十日之饮　", "放歌", "平步青云", "甜津津", "足足有余", "心甘情愿", "对床夜雨", "沁人心腑", "羲皇上人", "惊喜若狂", "嘻笑", "驻红却白", "奔放", "双喜临门", "悠然", "身远心近", "凿饮耕食", "打开天窗说亮话", "侥幸", "舒心", "黄发台背", "喜封", "千条万绪", "吹灰之力", "大吉", "不咎既往", "风平浪静", "否终则泰", "写意", "畅怀", "恬不为意", "死中求活", "黄发兒齿", "优游卒岁", "定心丸", "甜瓜地里长甘蔗－从头甜到脚", "遂意", "爽歪歪", "宽免", "释然", "腾欢", "安闲自得", "侃侃訚訚", "过瘾", "兴致勃勃", "散心", "悠游自得", "对得住", "赏心悦目", "焰火", "民富国彊", "傻乐", "应有尽有", "喜气洋洋", "足踏实地", "元旦", "欢声雷动", "足不逾户", "无愧", "转危为安", "无拘无碍", "庆幸", "包抄", "俯拾皆是", "饮水曲肱", "手到拿来", "地利人和", "遣愁索笑", "得其所哉", "暖乎乎", "吉日良时", "麦秀两岐", "允洽", "鼓腹讴歌", "踵事增华", "伯乐一顾", "升平", "欢慰", "遂心", "精神", "夫倡妇随", "吉祥", "想开", "协和", "喜人", "笑哈哈", "享福", "润笔", "张灯结彩", "大捷", "乐不思蜀", "赏赉", "遨游", "亲事", "顺当", "契机", "宽恕", "捷报", "得心应手", "高昂", "安心乐业", "团圆节", "失笑", "膏场绣澮", "畅想", "兴头儿上", "飞黄腾踏", "端午", "坦然", "知足常乐", "是味儿", "游览", "遨翔自得", "消遣", "中原逐鹿", "原谅", "和平鸽", "同乐", "感同身受", "四海宴然", "身退功成", "歌舞昇平", "遁世无闷", "终南捷径", "作如是观", "宽舒", "意气风发", "适中", "剪彩", "贺喜", "同条共贯", "水秀山明", "势如破竹", "忍俊不禁", "升官发财", "闲情逸志", "脱险", "歌舞升平", "浮想联翩", "巧遇", "月饼", "浮家泛宅", "安身乐业", "悠游自在", "如释重2", "耳根清净", "坐卧不离", "润例", "幸事", "长生", "沐日浴月", "跷足抗手", "告竣", "合家欢", "欢送", "高高兴兴", "无束无拘", "求亲", "姗姗", "通明", "欢悦", "同文共轨", "平顺", "嫣然一笑", "否去泰来", "亮堂", "水到渠成", "了如指掌", "落忍", "哄堂大笑", "无忧无虑", "言归于好", "开眼", "咬得菜根", "互利", "泰然", "_so", "飞奔", "际会风云", "大团圆", "哑巴拾黄金－说不出的快活", "受宠若惊", "娱妻弄子", "塌心", "豁然大悟", "轻装", "志得意满", "歙漆阿胶", "搔着痒处", "櫜弓卧鼓", "告捷", "像心如意", "酣适", "了身达命", "地老天荒", "鼓舞欢忻", "凯旋", "额手称庆", "安内攘外", "久旱逢甘霖", "大吉大利", "蝶粉蜂黄", "诗悄画意", "百事大吉", "清爽", "纷红骇绿", "偎依", "大梦初醒", "大喜过望", "丰稔", "畅通无阻", "岩居川观", "准予", "乐道", "喜上心头", "豁朗", "淡薄", "安然无恙", "竖起脊梁", "吃得来", "凉快", "调良稳泛", "寂然", "升级", "凤皇来仪", "功成事立", "锣鼓喧天", "称愿", "唠嗑", "阪上走丸", "莞尔", "天真烂熳", "酣暢淋漓", "三阳交泰", "安富尊荣", "如原以偿", "人欢马叫", "解放", "平淡", "洋洋", "滴溜儿", "畅饮", "锦瑟年华", "田园", "服帖", "演唱", "问心无愧", "吉光片羽", "邂逅", "新媳妇怀孕－暗喜", "花香鸟语", "裕如", "后福", "豁然贯通", "进益", "丰沛", "顿悟", "一颦一笑胁肩谄笑", "水乳交融", "欣喜", "热烈", "贯朽粟红", "鸾凤和鸣", "彩牌楼", "如梦方醒", "同声相应，同气相求", "喜见於色", "厚厚", "民和年稔", "哄堂", "四通八达", "联结", "高位厚禄", "適逢其时", "不疼不痒", "甜丝丝", "和气", "酣畅", "畅谈", "豁然开朗", "惊喜交加", "欢聚", "安堵乐业", "打扮", "团圆", "安生服业", "遇难呈祥", "丰衣足食", "照耀", "鳌掷鲸呿", "握手言欢　", "容光", "怡悦", "坐运筹策", "温存", "感天动地", "顺畅", "日月合壁", "联翩而至", "悠悠", "蜂拥而上", "xixi", "爽心豁目", "捷音", "莺吟燕舞", "肩从齿序", "情事", "乐天知命", "风平波息", "转正", "磊浪不羁", "包举", "际遇风云", "酣眠", "锦囊还矢", "祝捷", "伸冤理枉", "安定", "锥刀之末", "甚感欢慰", "平心静气", "奏捷", "一日九迁", "清闲", "兴头", "转生", "马入华山", "愈合", "不愧不作", "轻闲", "启示", "酣醉", "涂歌巷舞", "距跃三百", "获得", "还醇返朴", "富实", "高唱", "美美", "畅顺", "解颜", "捧腹", "快感", "欢喜", "晨鸡暮钟", "跌荡", "象箸玉杯", "完好无损", "朝发夕至", "源源不绝", "邂逅相遇", "喜神", "闲情别致", "孤云野鹤", "枕稳衾温", "热烘烘", "黄道吉日", "鹊桥相会", "倾谈", "喜滋滋", "不由自主", "送往视居", "为虎傅翼", "鸾飞凤翥", "燕雀相贺　", "演出", "高涨", "俯首弭耳", "恺悌", "唠扯", "呵呵", "放心", "黄人捧日", "畅快", "津津有味", "狂喜", "谘经诹史", "坐筹帷幄", "富国彊兵", "情味", "娶亲", "田园诗", "互通", "喜庆", "尽意", "独善其身", "逍遥自得", "后继有人", "怀里装梳子－舒心", "自在", "笑嘻嘻", "黄袍加身", "神武挂冠", "延年益寿", "喜笑盈思", "缥缈", "火花", "莺吟燕儛", "像心像意", "如痴似醉", "报喜", "鸡犬桑麻", "容留", "热泪", "得未尝有", "阳关道", "失马塞翁", "十雨五风", "开云见日", "热呼呼", "祝词", "祝贺", "拜把子", "骋目", "韬晦之计", "欢欣鼓舞", "汶阳田反", "智均力敌", "死中求生", "尽如人意", "纳福", "如醉方醒", "十风五雨", "熬头儿", "火热", "不亦乐乎", "金玉满堂", "其乐无穷", "痛快淋漓", "闲适", "还年卻老", "回嗔作喜", "新年", "无拘无缚", "酒酣耳热", "富足", "充盈", "庆贺", "高枕安寝", "大年初一", "喜眉笑眼", "昼日昼夜", "披红戴花", "捧腹大笑", "安枕而卧", "神飞色舞", "升学", "心满意得", "惊天地泣鬼神", "粲然", "侃侃谔谔", "连中三元", "乐观", "重聚", "低唱浅斟", "大快人心", "彩霞", "随喜", "破颜", "少小无猜　", "平定", "摄卫", "剥极必复", "安富恤贫", "同心合胆", "杯觥交错", "喜形于色", "增产", "益鸟", "包办", "和颜悦色", "赢利", "新婚燕尔", "安安稳稳", "喜果", "敲锣放砲", "暖衣饱食", "枯木逢春", "朵颐", "于心无愧", "畅所欲言", "乐天任命", "摆动", "求偶", "清风朗月", "雪冤", "互让", "欢度", "天成地平", "沁人心肺", "许字", "孤儿盼到了亲人－喜出望外", "青云直上", "鼓歌载舞", "相逢", "乞浆得酒", "黄人守日", "枯枝再春", "优游自得", "白日升天", "修心养性", "如释重负", "笑吟吟", "游园会", "便于", "乔迁之喜", "天下一家", "神色不动", "打哈哈", "快乐", "风调雨顺", "得意扬扬", "从容自若", "心旷神怡", "胡越一家", "吃得消", "欢快", "快心遂意", "惬心", "舒展", "大年夜", "喜讯", "何乐而不为", "欢跃", "足蹈手舞", "安居", "舒舒服服", "衾影无愧", "轻轻松松", "展眉", "做人做世", "一岁三迁", "重圆", "志喜", "无比幸福", "向平之愿", "欢迸乱跳", "取乐", "屐齿之折", "谈天说地", "足衣足食", "欣慰", "福祉", "中奖", "樽酒论文", "碧空", "安心乐意", "欢愉", "闲心", "斫彫为朴", "眉开跟笑", "畅销", "kaka", "嫣然", "凿楹纳书", "不以为奇", "千端万绪", "甜滋滋", "尊俎折冲", "运气", "却病", "泰然自若", "鸾飞凤舞", "捧哏", "迎刃而解", "琴歌酒赋", "举手之劳", "吉期", "伴同", "青眼", "野鹤孤云", "安之若素", "机运", "清风明月", "两姓之好", "恬不知怪", "遵厌兆祥", "心满原足", "适逢其会", "乐而忘返", "万幸", "爽亮", "消释", "剥极将复", "野鹤闲云", "安国富民", "舒坦", "剥极则复", "座无虚席", "雀跃", "肝胆照人", "荣幸", "胜券", "激烈", "风不鸣条", "吹拂", "化干戈为玉帛", "身名俱泰", "游历", "逸兴遄飞", "和祥", "怡和", "内省不疚", "情侣", "虚惊", "喜笑盈腮", "温暾", "痛快", "以汤沃雪", "兴奋不已", "百感交集", "心平气和", "衷肠", "酣然", "比配", "富国强民", "气决泉达", "熟路轻辙", "民熙物阜", "种花", "醉酒饱德", "阳光", "穰穰", "取胜", "依偎", "水长船高", "谐谑", "小国寡民", "宁静", "低价位", "尻轮神马", "扑哧", "千载一弹", "拨浪鼓", "净心", "悦目赏心", "钟鼓馔玉", "樽前月下", "兴文偃武", "摩拳擦掌", "转败为成", "天网恢恢，疏而不漏", "安生", "子继父业", "喜不自胜", "三生有幸", "神閒气定", "意气扬扬", "无思无虑", "激奋", "情欲", "两全其美", "和悦", "有眉目", "酌古准今", "畅旺", "帮办", "逍遥", "吃请"}
#怒
DUTIR_Nus = {"怨气满腹", "面有愠色", "愤愤", "直眉瞪眼", "负气斗狠", "挑眼", "七窍冒火", "义形于色", "愤然", "横眉怒目", "犯肝气", "无名火起", "暴怒", "一刀两断", "羞愤", "恩断义绝", "无明业火", "动怒", "攘臂嗔目", "易怒", "辩诬", "嗟来之食", "糟害", "忿然作色", "大发雷霆", "悲愤填膺", "怒火中烧", "热锅上的蒸笼－气到顶了", "狠劲", "深仇重怨", "忿忿", "敌焰", "貂裘换酒", "背黑锅", "嗔怒", "忧愤", "岂有是理", "吹胡子", "敌情", "抱不平", "一怒之下", "豁出去", "焚林而猎", "努牙突嘴", "怫然", "感愤", "气冲冲", "瞪眼", "惯愤不平", "嫉恶若仇", "龙屈蛇伸", "闲气", "翘辫子", "郁愤", "面带嗔色", "气忿忿", "盗憎主人", "怒不可遏", "草场着火－火气冲天", "惩治", "活该", "直木先伐", "怒色", "陪葬", "植发穿冠", "你丫", "民怨沸腾", "挂气", "劈头", "怒火冲天", "扬眉瞬目", "纳鞋底戳了手－真气人", "握拳透掌", "唱老生的生气－吹胡子瞪眼镜", "强取", "冤家路窄", "旧愁新恨", "怒冲冲", "恼羞成怒", "皇上拍桌子－盛怒", "赌气", "狭路相逢", "气冲牛斗", "气呼呼", "拍案而起", "不甘示弱", "寒碜", "发上冲冠", "敢怒不敢言", "焚骨扬灰", "真TM", "全无心肝", "戟指嚼舌", "眼中钉", "投诉", "横眉努目", "决一死战", "怒气冲冲", "气鼓鼓", "哀的美敦书", "恼怒", "使心彆气", "kao", "七窍生烟", "破脸", "情怨理遣", "变色", "奇耻大辱", "报仇", "厉声", "来气", "光火", "看扁", "郁怒", "太岁头上动土", "狞髯张目", "棒喝", "生闲气", "正言厉色", "枕戈饮血", "除恶务尽", "疾恶如仇", "扑杀此獠", "气涌如山", "吹夹生饭－胀气", "陆离光怪", "新仇旧恨", "发踊冲冠", "暴跳如雷", "变脸", "血债", "老羞成怒", "TNND", "横眉瞪眼", "打群架", "捰袖揎拳", "冒大不韪", "匹夫无罪，怀璧其罪", "甩脸子", "狂轰滥炸", "怒目而视", "怒目", "数说", "怒目切齿", "嚼穿龈血", "赫然", "种族主义", "激愤", "义愤", "悲愤交加", "怒容", "上火", "冒渎", "筋疲力尽", "狗血淋头", "勃然", "气哼哼", "喑恶叱咤", "出气", "直眉怒目", "失落", "发怒冲冠", "上等轮胎－有气难出", "私愤", "枕干之雠", "戟指怒目", "惹气", "急眼", "鼓囊囊的皮球－有气", "三尸暴跳，七窍生烟", "竭泽而渔", "火冒三尺", "刻骨仇恨", "火箭筒射击－两头冒火", "叫嚣", "气愤", "扫地出门", "愤不欲生", "悻然", "握拳透爪", "羞辱", "竟敢", "脸红筋涨", "怒气冲天", "敢怒而不敢言", "割席分坐", "攘除", "火头上", "拳打脚踢", "令人生气", "捉奸", "戏耍", "怒视", "抗议", "一气一个死", "义愤填膺", "忿忿不平", "冷厉", "敲边鼓", "怒气", "挂火", "众怒", "敌台", "枕戈泣血", "怨气冲天", "落草为寇", "掊击", "植发冲冠", "狐不二雄", "扬眉眴目", "气汹汹", "呵喝", "宣泄", "脾气", "横眉立目", "忧愤成疾", "拂袖", "叱喝", "窝火", "负气", "刻骨仇很", "鳌愤龙愁", "曝骨履肠", "气不忿儿", "雷霆之怒", "喝西北风", "发脾气", "仇人相见，分外眼红", "咆哮", "撒气", "无名火气", "精疲力竭", "渎犯", "寒天吃冰棍－心里有火", "檑木", "敌手", "柳眉踢竖", "指桑骂槐", "动气", "告非", "震怒", "盱衡厉色", "欺君罔上", "触怒", "愤怒", "柳眉倒竖", "偾事", "一刀两段", "民愤", "天怒人怨", "叵耐", "启瞶振聋", "滚出去", "恼火", "横眉立眼", "雷嗔电怒", "2气斗狠", "发指", "睚眦", "气急败丧", "狼顾鸢视", "勃然变色", "盛怒", "负屈衔冤", "发标", "抓破脸子", "火冒三丈", "叱呵", "咬牙切齿", "使人发怒", "可气", "耍态度", "格杀弗论", "泄愤", "拍案", "公愤", "污手垢面", "呼天籥地", "吵嘴", "我靠", "抓破面皮", "不平", "gun", "怏怏不乐", "愤懑", "忿火中烧", "愤激", "欺上罔下", "艴然不悦", "气冲斗牛", "杀气", "人神共愤", "鱼瞵鹗睨", "发上指冠", "造反", "饮恨吞声", "悲愤", "狼顾虎视", "火气", "横眉瞪目", "飘瓦虚舟", "惩罚", "饮气吞声", "大动肝火", "气愤愤", "揎拳捋袖", "忿忿然", "阴沉", "不服气", "牺牲品", "声色俱厉", "格杀无论", "怫然作色", "柳眉剔竖", "种族歧视", "追击", "不忿", "一朝之忿", "发怒", "拂袖而去", "气狠狠", "MD", "气忿", "割席断交", "诟龟呼天", "抵命", "吃了芋头不下肚－顶心顶肺", "狗嘴里吐不出象牙", "愠怒", "含怒", "卧榻之侧，岂容他人鼾睡", "动肝火", "怒形于色", "走气门", "格杀勿论", "忿怒", "攞袖揎拳", "攒锋聚镝", "针锋相对", "暗气暗恼", "狼嗥狗叫", "剖白", "肝火", "洗雪逋负", "复仇", "清君侧", "敌阵", "扬长而去", "抓破脸皮", "暴跳", "气不忿", "肉中刺", "揉搓", "勃然大怒", "当场出彩", "气势汹汹", "哇靠", "疾言厉色", "逼上梁山", "爆发", "微愠", "仇人相见,分外眼红", "住手", "怒发冲冠", "迁怒于人", "愤愤不平", "愤愤然", "骂不绝口", "气急败坏", "发指眦裂", "愤然作色", "愤慨", "交詈聚唾", "没好气", "切齿愤盈", "无明火", "恼羞变怒", "心火", "惩办", "捉鸡骂狗", "火暴", "横眉冷眼", "惩处", "横眉", "敌忾", "火性", "愤世嫉俗", "起火", "面带怒色"}


#知网Hownet词典
HOWNET_deny = {"不", "不是", "不能", "不可", "没有", "不要", "别", "没", "无", "莫", "未", "勿", "休", "甭", "非"}
HOWNET_extreme = {"百分之百", "倍加", "备至", "不得了", "不堪", "不可开交", "不亦乐乎", "不折不扣", "彻头彻尾", "充分", "到头", "地地道道", "非常", "极", "极度", "极端", "极其", "极为", "截然", "尽", "惊人地", "绝", "绝顶", "绝对", "绝对化", "刻骨", "酷", "满", "满贯", "满心", "莫大", "奇", "入骨", "甚为", "十二分", "十分", "十足", "死", "滔天", "痛", "透", "完全", "完完全全", "万", "万般", "万分", "万万", "无比", "无度", "无可估量", "无以复加", "无以伦比", "要命", "要死", "已极", "已甚", "异常", "逾常", "贼", "之极", "之至", "至极", "卓绝", "最为", "佼佼", "郅", "綦", "齁", "最"}
HOWNET_ish = {"点点滴滴", "多多少少", "怪", "好生", "还", "或多或少", "略", "略加", "略略", "略微", "略为", "蛮", "稍", "稍稍", "稍微", "稍为", "稍许", "挺", "未免", "相当", "些", "些微", "些小", "一点", "一点儿", "一些", "有点", "有点儿", "有些", "半点", "不大", "不丁点儿", "不甚", "不怎么", "聊", "没怎么", "轻度", "弱", "丝毫", "微", "相对"}
HOWNET_more = {"大不了", "多", "更", "比较", "更加", "更进一步", "更为", "还", "还要", "较", "较比", "较为", "进一步", "那般", "那么", "那样", "强", "如斯", "益", "益发", "尤甚", "逾", "愈", "愈...愈", "愈发", "愈加", "愈来愈", "愈益", "远远", "越...越", "越发", "越加", "越来越", "越是", "这般", "这样", "足", "足足"}
HOWNET_neg = {"压坏", "鲁莽的", "被控犯罪", "银根紧", "警惕的", "残缺", "致污物", "柔弱", "劣势", "拉出", "烂", "分隔", "极度痛苦", "猛撞", "苦味", "不稳定", "不甘心", "诟病", "严重", "拘礼", "懒到极点", "不充分", "偏执狂", "针刺", "阴郁", "砍得", "生活放荡的人", "可疑的", "感叹", "愤而", "瓜田李下", "求教", "未得到", "黢", "不屑一顾", "吞吃", "战斗", "酸不溜丢", "使麻木", "荒诞", "茕茕", "不便", "搞不懂", "充血", "屠宰", "越礼", "傲脾气", "难达成", "不祥", "气馁", "不太可能的", "硫化", "顽梗", "挖苦", "较坏", "可容忍", "无希望", "徵收", "威吓", "会蔓延", "挤", "火灾", "古里古怪", "悲哀", "病狂", "非难", "不舒适", "无准备", "暴徒", "使人厌烦", "微愠", "不自然", "麻木", "邋里邋遢", "丑男", "狂", "冷清", "暗里", "不雅观", "发抖", "丧魂落魄", "偷运", "长期折磨", "麻麻黑", "研碎", "疏懒", "吵人", "怎麽搞的", "呜哩哩", "惋", "被诅咒", "羊质虎皮", "宣告放弃", "模糊", "缓慢的", "弄乱", "削弱", "呆", "令人恐惧", "那麽干", "骄弱", "荒年", "伤人感情", "故态复萌", "痴痴", "唾沫飞溅", "任意的", "倚老卖老", "子虚", "暗沉沉", "激愤", "苛刻", "独断的", "畏", "夸示", "大灾难", "使模糊", "髒话", "长痔疮", "苦脸", "得鱼忘筌", "花", "了不起", "使恼怒", "懊悔", "毫无价值", "不愿意的", "一脸稚气", "无权", "心急如焚", "攘攘", "嗜杀", "不听话", "扼腕", "横行霸道", "疝气", "不坚固的", "虚假", "疑问", "铁石心肠", "监禁所", "破败", "低吼", "狗男女", "孤寡", "褊狭", "没劲", "追赶", "婊子", "揶揄者", "毒手", "不和", "怒视", "不能容忍", "未知数", "危机", "憋拗", "祸害", "丑陋的", "挤向前", "委靡不振", "懔", "不断地找..的岔子", "过剩的", "落魄", "失怙", "俘虏", "压制", "看不惯", "残毒", "未减轻的", "垃圾", "使潜入", "彻底击溃", "忪", "嫌恶", "白费的", "笨的", "使恐惧", "走下坡", "超出", "难", "痛责", "一怔", "不起作用", "不快", "笃", "不平坦的", "消瘦", "疼痛的", "发动", "嗜杀成性的人", "卑", "致命之物", "无勇气", "夸耀的", "大而笨拙", "痛恨", "怀着恶意", "拷问", "赌气", "嗜血成性", "何不", "漫骂", "被抑制", "如履薄冰", "死板", "妖", "虚荣的", "使倾覆", "神经病", "无意义的", "毒打一顿", "穷极潦倒", "直瞪瞪", "硬背", "辣", "一气之下", "隐隐约约", "形容枯槁", "孩子气的", "挑拨是非", "鸡犬不宁", "荒谬的", "痴", "尽力睁大", "诡", "不毛的", "起皱", "不良", "疯的", "重", "窥视", "人为财死，鸟为食亡", "腐朽没落", "紧巴巴", "闲闲", "未指明", "令人寒心", "胆寒", "粗拙", "诞", "嘲笑", "澹然", "矮", "太迟", "饶恕", "不悦之色", "紧迫", "歹", "私生的", "不精密", "丢失", "有愧", "从动", "粗率", "支配", "不爱交际", "破败", "低落", "口渴", "灰暗", "毁容", "令人悲痛的", "使焦虑", "神经紧张", "哀愁", "使下垂", "听天由命", "不顾一切地", "惭愧", "私下里", "难以", "毁灭性的", "蛊惑", "动气", "多有微词", "哀鸿遍野", "沈浸", "苟且偷安", "大错而特错", "没味", "使人产生不愉快的感觉", "好假", "塞你祖马勒", "课刑", "狂暴", "主观", "被碾碎", "私底下", "散乱", "失去光泽", "杀人", "令人不满意", "败坏道德之事", "简陋的", "低效", "可争论的", "闷着", "成碎片", "强奸", "情急拼命", "蛇蝎心肠", "不能决定的", "敢喵我", "无人情味的", "撕毁", "刺鼻", "枉", "驽", "嘘", "沈重地走", "抨击", "气绝身亡", "二手", "喧杂", "浸没", "缺席者", "奸邪", "辛辣的", "沈重的步伐", "万恶", "牛", "违法", "附会", "凌杂", "险象环生", "悖", "要吐", "刻薄的", "心黑手辣", "伤人", "流里流气", "落套", "谎言", "为人作嫁", "大惊小怪", "变污", "假仁假义", "刺探", "不好意思", "费解", "不问青红皂白", "吓人", "寂寞", "死心眼", "多疑的", "刻板的", "死胖女", "下垂", "一触即溃", "暗淡", "不规则", "变凌乱", "艰", "似", "泄漏", "绝不", "一发千钧", "不稳", "与..斗争", "陌生", "无子可动", "难控制", "起疑心", "慑", "失去法律保护", "误入歧途地", "干扰者", "硬生生", "串秧儿", "失控", "你她妈", "不合宜的", "泛滥", "无遮蔽的", "成废物", "鱼游釜中", "跩的二五八万", "抗辩", "苦口", "令人恼火", "色欲", "执拗", "料想不到", "虚无", "意外事件", "侮辱的", "令人厌恶的", "焦心", "索费", "夭寿", "使成孤儿", "反对改革", "与..战斗", "暴虐行为", "害羞", "水性杨花", "伤风败俗的", "原", "呆痴", "暴怒", "死东西", "断绝", "无能为力", "割伤", "输家", "私运", "功利", "设伏", "嫉妒", "受害者", "撬动", "同性恋者", "危害物", "如兽", "哀伤", "耍脾气", "闷闷", "怆怳", "错误百出", "喃喃", "残损", "死亡状态", "球触网重发", "迁怒", "吠尽", "不管三七二十一", "追悔莫及", "丢脸", "憎", "淫荡", "不关心", "给我死", "有点儿", "泼", "占据", "包容", "与..打仗", "发展迟缓", "瘦弱", "激动", "坏人当道", "机歪", "旷课者", "失去知觉的", "卖不掉", "下", "垂头丧气", "鄙贱", "危险", "招摇撞骗", "如兽的", "狞", "有毒性", "死肥猪", "萧然", "好自为之", "鬼叫", "乱糟糟", "猛然地一拉", "不济事", "不合适", "家伙", "惊奇不已", "泄露", "拉拉杂杂", "哀痛欲绝", "受难", "嘲弄", "恐惧", "带赛", "毒蛇一样的家伙", "呆笨", "骄傲", "不自在", "仿制", "反社会", "贱役", "使病弱", "怅然若失", "卑鄙地", "怕羞", "驽钝", "很烂", "患病的", "孬", "墙头草两边倒", "乱杂", "不注意", "风吹", "伤痕", "挂火", "孤", "凄婉", "冲三小", "骗人的", "凶什麽", "使感觉不满", "自满", "寒颤", "自杀", "流浪者", "有好有坏", "厉声", "大失所望", "暗自", "偏心眼", "投入深渊", "捣蛋", "悲叹", "稀松平常", "强盗罪", "龃龉", "非难", "粗疏", "不对头", "求解", "有毒", "命运注定的", "呕吐物", "自负", "沈郁", "生气", "乱蓬蓬", "使钝", "靠北", "鼓动", "作弊", "精疲力竭", "变模糊", "裂开的", "操你的", "有矛盾情绪", "给我注意点", "作祟", "抑止", "不灵敏", "多虑", "卑鄙", "使缠结", "蓬头散发", "妨害物", "落入", "吊儿郎当", "大吃一惊的", "异常兴奋", "穷", "义正词严", "使蓬乱", "模糊不清地说话", "受伤的", "别有用心", "含恨在心", "未解决", "谫陋", "心毒", "以怨报德", "漠视", "微弱", "挤出前进", "饿死", "分割", "毛糙", "驱逐", "惴", "铤而走险的", "慨叹", "心切", "来之不易", "患精神病的", "自缚", "神经", "无法忍受的", "阻止", "冒失", "蹩脚", "小眼睛", "厌恶", "死薪水", "干声连连", "影影绰绰", "养不起", "固定不变", "倔强地", "敦促", "含泪", "黑蒙蒙", "反对的", "咯咯", "气愤填膺", "胆战心惊", "不懂事", "倔犟", "发愣的", "苴", "使临险境", "轻蔑", "老大", "变化万千", "叛逆", "使陷危地", "非人", "冷汗", "伤风", "严肃", "小瞧", "大骂", "非难的理由", "侵略者", "未经检查的", "冒险假设", "乱乎", "弱智", "过度的疲劳", "刺耳", "荫", "溷浊", "侵吞", "最跩", "又气", "喧嚣", "野性的", "没卫生", "使失明", "疑云", "使用计谋的", "惹人厌", "阴冷", "偷偷", "哭夭个屁", "丑", "亳不留情", "若隐若现", "使烦乱", "死掉", "降级", "蛮荒", "忧心忡忡", "爆发", "多余", "有点火", "恶兆", "难人", "不健全", "不结果的", "崩溃", "鸡蛋里挑骨头", "善罢干休", "笨手笨脚", "无底洞", "臭铜钱", "体弱", "不结果实的", "亏死", "奸淫", "腻味", "生恨", "不会的", "乖张", "罪大恶极", "丧心病狂的", "拒绝", "无情", "使毁灭", "凄酸", "没法儿", "弊端", "头壳坏去", "地震", "改变改变", "衰落的", "不宜居住", "发臭的", "赛你娘", "乌托邦", "真是蠢", "嘲骂", "粗劣的", "误传", "变酸", "否定", "我好恨", "妨害", "暗地", "破坏活动", "不快", "心酸", "鄙吝", "黑沉沉", "不切", "倒塌", "嫌憎", "投诉", "心慌", "虚荣", "象征性", "无帮助的", "威厉", "冥顽不化", "凶残", "死蚊子", "冷漠", "乏", "离群", "煞费苦心", "小规模战斗", "拘留", "空洞", "不能解决问题的", "怆恻", "斑点", "穷人", "何妨", "压治统治", "冒昧的", "细小", "自暴自弃", "草", "烦愁", "未被证明为正当", "使行为不端", "逾分", "悲触", "哭笑不得", "不谨慎的", "蜻蜓点水", "悭", "使恼火", "疑惧的", "瓦解", "撞墙", "神志委靡", "极不协调的", "令退役", "僻静", "酸的", "迫切的", "申饬", "凶悍", "马的咧", "可笑的", "龌", "炸毁", "愚弄", "闹闹哄哄", "罪孽", "气咻咻", "风骚", "近视", "疏忽", "沮", "风声鹤唳", "孑", "悚然", "掌击", "耍贱", "搞分裂", "消沉", "憝", "不管怎样地", "不均等", "憋", "恼火", "病菌", "得罪", "嫌疑", "红脸", "黯然销魂", "充满危险的", "恼人的", "禽兽不如", "害怕", "用旧", "不引人注意", "追杀", "眷顾", "淡然", "失去勇气", "下流的", "处置", "凄惶", "异乎", "火爆", "差的", "激烈进行", "丑闻", "死小鬼", "差点儿", "笑里藏刀", "疯狂", "憎恶", "受到阻滞", "谋杀", "引起不舒服", "毫不客气", "懒散", "斥责", "哙", "世故", "庸俗", "不合适", "施以", "罪名", "恐怖病", "不成", "滚回去", "压迫的", "性格内向", "隐退", "渗透物", "受损失", "不怕死", "长线", "厚颜薄耻", "不忠", "不知", "浑名", "不屑", "克制", "发出咯咯声的东西", "蒙胧", "苛求", "顽抗", "粗鲁", "勉强", "打倒", "一锅粥", "有失检点", "反常现象", "出尔反尔", "不和谐", "黑店", "妄动", "哭幺", "土头土脑", "沈沦", "模糊不清地说", "破碎", "住监狱", "名义", "烦扰", "激怒", "看了就有气", "依赖的", "干恁老老鸡掰", "不可抵抗的", "取消", "易变", "发出尖锐的声音", "他妈的", "屈服", "蒙羞", "忌惮", "没有用", "不适应", "解雇", "危急", "惊扰", "空转", "欺诈的", "搞斗争", "颐指气使", "闻出..的臭气", "喝叱", "沈重缓慢地走", "劳而无功", "捉襟见肘", "使迟钝", "叹气", "生疏的", "寥", "山南海北", "不像真实的", "无志气", "逊位", "名声臭", "内疚", "煮豆燃萁", "使跛", "蚀坏", "嫉恨", "乱扯", "骂得狗血喷头", "滞", "用手掌打", "关在", "焦灼", "坎坷不平", "受伤", "剽窃", "闲闲没事", "死刑", "跟..纠缠不休", "灼痛感", "尖刻", "惊骇的", "不闻不问", "被浮渣覆盖", "惶恐不安", "反社会", "责斥", "不经", "糟透", "够呛", "紧拉", "拙劣", "无威严", "等而下之", "虎头蛇尾", "空虚", "碰运气", "结结巴巴地说", "纠缠", "共犯", "暗示", "实利的", "大败", "痛不欲生", "没有防备的", "狂怒的", "淫亵", "使失去能力", "不怀", "背信", "打抱不平", "令人不满意的", "忧心", "供给..过强", "失志", "等不及", "通货膨胀", "你就完了", "不务正业", "挤挤插插", "污名", "食而不知其味", "绝望的", "如泣如诉", "烦厌", "愁容", "自我中心的", "使腐蚀", "禁止接近", "损失", "胆敢", "台独", "狼藉", "无力", "无效", "神不知，鬼不觉", "横穿", "负面", "感冒", "使错综", "怪异", "僵化", "脾气坏", "不便之处", "不安稳的", "报仇", "俗气", "作奸犯科", "酥软", "痛打", "大量喷出", "嘶哑", "服丧", "体谅", "极度悲哀", "闷热", "引咎", "使绷紧", "不在乎", "下手", "出神", "使爆炸", "缩头缩脑", "砰地落下", "多风暴的", "血雨腥风", "死要面子", "灰头灰脸", "拖泥带水", "碰伤", "急功近利", "蔓生的", "倒胃口", "拒付", "渺渺", "艰难险阻", "放逐", "发疝气", "漂泊者", "忷", "抓住", "拥挤的", "一枪毙了你", "粗鲁无礼的人", "不切实际的", "以为不可", "干他", "残废", "烂上万倍", "香艳", "木雕泥塑", "游移", "胆大妄为", "拗客", "神经过敏的", "蒙受耻辱", "不足挂齿", "凹陷", "变钝", "炮轰", "见死不救", "自私的", "烂家伙", "惊诧", "看扁", "倒置", "咒语", "使恐怖", "弄死", "落荒而逃", "带塞", "有始无终", "偏执狂患者", "冬烘", "游击队", "鸟态度", "废弃的", "使极度激动", "敌对", "战战兢兢", "不可预测", "失宠", "利己主义的", "不幸事件", "怨悔", "强击", "出糗", "逆向的", "萧瑟", "使遭危险", "止步", "屁眼", "羞怯怯", "除害", "无伤大雅", "玩", "暗杀", "最低水平", "去死吧", "看低", "给你们好看", "玉石俱焚", "压制性的", "自怨自艾", "水中捞月", "逼政", "鸟屎", "减少之量", "险恶", "不能解释", "挫败", "狂暴地", "猛吃", "混江湖", "不合格", "动武", "牙碜", "心生畏惧", "砍下", "让人讦", "自命为", "漫不经心的", "不可能的", "有诡计的", "新手", "沮丧", "戆", "不识", "越轨", "灼痛", "琐碎", "不能征服的", "感到遗憾", "轻贱", "找碴", "蜕化", "反垄断的", "令人窒息", "潜逃", "不是滋味儿", "苍白", "大嚷", "陋", "草荒", "勉勉强强", "呆滞", "杀人的", "无智的", "近视", "无爱情的", "骇然失色", "怨恨", "现行", "老奸巨猾", "暴跳如雷", "围困", "惊人", "拆桥", "不够", "无政府主义者", "灯火阑珊", "看不开", "悲观失望", "打赌", "喜夸耀", "刺针", "无礼貌的", "愁眉紧锁", "对..起反作用", "云谲波诡", "内阻", "激潮", "恨入骨髓", "变脸", "没品德", "反冲", "厌烦", "虑", "孤独的", "冲动", "迁怒", "绵软", "违建", "豪奢", "愚蠢地说出", "无故", "专横", "荒唐的", "做秀", "流空", "无聊", "难相处", "用心良苦", "怵头", "心有余悸", "大失所望", "冗馀", "失礼的", "杀人者", "根本不是我", "厉声", "令人无法忍受", "成为空的", "嗓子不好", "嘲谑", "乱盖", "伤感", "嗲", "迫害", "走失动物认领栏", "恶人", "罪孽深重的", "任意", "体恤", "恶毒", "更恶劣地", "咒诅", "卖弄风骚的人", "扼制", "混兄弟", "弱不禁风", "冷落", "似乎", "冒昧", "鞭子", "目中无人", "使不平", "黑心", "使遭受", "分心的事物", "流言蜚语", "杂", "歪曲", "紧张的", "逆行", "小视", "陷落", "无视", "使停顿", "使跛行", "丧心病狂", "高不成", "逃走", "横冲直撞", "不成体统", "掩埋", "绷着", "乱语", "亚", "羽毛未丰", "冲撞", "开玩笑", "你他妈妈的", "塞人", "证明..是虚假", "见识短浅", "大胆的", "粉无聊", "心烦意乱", "腐蚀", "忍耐", "认命", "鸟话", "强", "未中", "着忙", "满脸横肉", "加负荷於", "正色", "后顾之忧", "无助", "猛烈抨击", "好色", "砍落", "荆棘载途", "恃才傲物", "去你", "大哭", "顽钝", "两面光", "混浊状态", "沈重", "窘困", "大声的要求", "低级", "冥顽", "贱男人", "冗长", "苍白无力", "腐蚀性的", "推诿", "惨痛", "瞎", "少惹", "没受", "增剧", "伪人", "爱理不理", "胡子拉碴", "不知的", "趁火打劫", "粗陋", "不管", "恨", "长的丑", "使大伤元气", "无目的的", "急躁的", "怪诞的事物", "搞政变", "忏悔", "落拓", "吵闹声", "贿赂", "断然拒绝", "摇尾乞怜", "偿付", "乖张", "机机歪歪", "瞧不上眼", "秃头", "气不平", "最小限度", "喧嚷", "烦乱", "背靠背", "怯懦", "白痴的", "爆炸的", "繁难", "悲伤者", "纵恣", "不均匀", "忿怒", "使作呕", "苦的", "不适任", "误认", "无知觉", "打..的屁股", "陈", "发作", "悸栗", "吝", "可怜的", "惊慌", "心惊胆战", "反复无常", "发誓要", "惹恼", "猪母", "冒失的", "灰沉沉", "噪声", "二五眼", "悔不当初", "盗窃", "无规", "指桑骂槐", "使成残废", "啜泣", "浅薄", "神经质的", "艰涩", "无勇气的", "昏愦", "不对劲", "噘起", "面目可憎", "粗制滥造", "困窘", "松散", "使遭受海难", "未受过教育", "反常", "重打", "挑战", "愚昧", "不可降解", "厌烦的", "有病", "强制的", "讨厌鬼", "不适时的", "主观上", "无能为力的", "丧失的", "浓烈", "发出砰声", "不忠实的", "靠啊", "窒息的", "严寒", "傻里瓜唧", "委琐", "诽谤", "毙了他", "悲切切", "神气活现", "粗陋", "使便宜", "孤僻", "倾斜", "绷着脸", "烫手", "惊叫", "耗尽的", "延期", "暗淡的", "婚外", "难看", "使分心", "眼花的", "向..挑战", "使凹陷", "敌视", "刚愎", "高昂", "狷", "恐怖时期", "涵蓄", "不加思考", "逞威风", "一阵狂风", "斗", "复杂性", "胡话", "吵起来", "心灰意懒", "隐密", "轻佻", "怒气", "丧失", "踌躇不决", "不自在的", "忧虑", "臭你老师咧", "爆破", "砰然作声", "混浊", "有够蠢", "不可否认的", "矫揉造作", "有毒腺", "刺眼", "死人", "绝对不会原谅你", "冗", "荒地", "目光如豆", "从中作梗", "意乱", "秘", "不划算", "低质", "畸", "脏兮兮", "困死", "蠢驴", "死狗", "专横的", "呵", "恶作剧", "不满意", "漫无目的", "喃喃地说出", "极危险之物", "觉得疼痛", "变态", "手头紧", "造谣中伤的", "奸男女", "以诱饵吸引", "不合规定的", "患得患失", "与..不符", "牲畜", "寡断", "粗糙地", "小心眼", "难题", "利用别人", "不彰", "愚妄", "责问", "为难", "无名", "复杂的", "淌混水", "压力", "失常", "未完成体", "难治疗的", "乏味", "烈酒", "凶猛", "劈啪", "陨落", "贪图", "罪恶", "落後", "击中", "胡", "挥霍的", "没关系", "自命", "消灭", "疲惫", "赊购", "鼎沸", "不知道", "不共戴天", "丢脸的事", "逃掉", "丧尽天良", "狂妄的", "危地", "拘留所", "烧毁", "烧坏", "紧急状况", "下乘", "焦躁", "发臭", "爱挑剔的", "疯人", "变破烂", "低姿态", "哀", "羞愧", "不清楚", "溘逝", "积满灰尘", "偷摸行走的人", "灰心丧气", "无用", "盲目", "家贫如洗", "恐怖", "烦闷", "诅咒", "悖妄", "没有自信", "避开", "度烂", "心如刀割", "系念", "不合", "无志气的人", "曲折", "尖啸", "重击", "短促频繁地乾咳", "冠冕堂皇", "不正", "愚拙", "肥肉", "结仇", "你妈", "着急", "流离", "悔", "反感", "麻", "闹事", "变得微弱", "失当", "失宜", "恶骂", "窒闷", "高度兴奋", "不合情理", "举棋不定", "眩目", "气得", "善变的", "惶然不安", "使厌烦", "衣衫不整", "控诉", "懵", "失望", "传染性的", "繁冗", "漠视", "功利主义的", "专横", "不是省油的灯", "气死了", "喷溅出来的东西", "不妥当", "怨天尤人", "淫靡", "害羞的", "死缠活缠", "罪恶", "摇摆", "萎靡", "牵连", "冲击波", "不得了", "经受不起", "狗眼看人低", "无能力的", "蛮干", "生气", "暴力引起", "卖不动", "变皱", "肮髒", "拜托", "遭受风吹雨打的", "弃义", "被俘", "少烦", "迟钝的", "申诉", "呆笨", "做坏", "海难", "灰色", "斤斤计较", "沉吟", "慌忙", "硗薄", "乱丢", "抠", "气势汹汹", "无威严的", "禁忌", "痛苦的经验", "隐然", "搞新闻", "不庄重的", "掩饰", "拘谨", "去你妈的", "郁闷", "硬", "皮条客", "自作多情", "杂遝", "不洁", "焦虑", "无遮蔽", "畜生", "被分解", "杂乱无章", "心地不好", "不流行", "厚颜", "气短", "不轨", "施暴", "迷信", "碍手碍脚", "浮浅", "负数", "悻悻然", "吓出", "脏乱", "打耳光", "没事", "流眼泪", "荏", "清算清算", "满", "狂妄", "不义", "不正常", "不可理喻", "食人", "高傲", "折断", "惦", "相撞", "钝", "精神上的打击", "不理", "心脏受不了", "狗嘴", "耸肩表示", "议论", "忍让", "自我中心", "奚落", "相反的", "不讲信用", "可恶", "筋疲力尽的", "扁到你说不出话", "怨恨", "苦事", "猪狗", "不上算的", "不可信的", "贪", "沉重", "侵入", "放肆的", "鸟样", "刺伤", "靠不住", "大", "抗议", "消耗热的", "道德败坏", "自命清高", "未定的", "孱弱", "结巴", "见不得人", "有毒", "战败", "躁急", "哀切", "减缩", "不够的", "使纯", "严苛", "无慈悲心的", "谣言", "用尽", "殷", "搞公关", "熊", "畸型", "输理", "悲愁", "自恃", "使苦恼", "冷血", "皱皱巴巴", "暧昧的", "赧然", "无人过问", "大意", "人心惶惶", "顽强的", "窒息状态", "彻底失败", "横", "模棱两可的话", "有够累", "愤愤然", "敢骗", "我咧", "配不上", "干瘪瘪", "抱歉", "裂开", "乞求", "折磨", "徒劳无益", "绝对", "捶胸顿足", "苛", "劣根", "巨物", "叱骂", "灾祸", "带来痛苦", "使休克", "使悲痛", "被议论的", "板脸", "绵里藏针", "诡密", "法西斯党员", "不肯", "下垂度", "尚未准备好", "细", "荏弱", "私生", "海底捞针", "发怒", "愣", "剌", "暗中", "不能说明", "啼笑皆非", "拖着", "自诩为", "年久失修", "不受欢迎", "哇哩", "看不惯", "冥顽不灵", "自卑感", "锋芒毕露", "污", "逼视", "劝阻", "退步", "淫", "荒芜", "奈何", "相反", "拳头", "不说话", "独裁", "活动", "假冒品", "狭路", "令人困倦", "没出息", "死心塌地", "叫苦连天", "使受危困", "腻人", "琐", "用不着", "凶狠", "要饭", "真是够了", "首鼠两端", "朝秦暮楚", "仿造品", "不合语法", "猖", "屈辱", "无知觉的", "不发达", "回头", "不恰当", "人生不就是如此", "疑心的", "凛然", "悲凄", "震悚", "不安全的", "捕捉", "向隅", "虚诈", "没脚", "关押", "流浪的", "奇怪的", "臆", "随心所欲", "于心有愧", "苦恼", "白费", "恶贯满盈", "文恬武嬉", "被弄髒", "抑制", "遁辞", "臭名昭彰", "穷困潦倒", "黝黯", "雾里看花", "进退两难", "狂奔", "摇晃", "黑黝黝", "不顺眼", "贫瘠", "不忠诚", "很丑", "哀恸", "发疯似的", "焦虑的事", "众叛亲离", "后悔莫及", "没种", "惊醒", "顺从", "不能决定", "鬼子", "混浊", "猛砍", "势利", "嗜杀成性", "地牢", "过当", "使降级品格", "难以相信", "不足", "无动於衷", "不为人喜", "绝望", "不利", "棘手", "愕", "猪就是猪", "失去..", "废墟", "不注意的", "异常的", "毫不留情", "啪地落下", "懒", "狙", "发育迟缓", "遇刺", "惊吓", "哄然", "假道学", "昂贵", "穷困", "冒牌", "利用", "短视", "单调", "动荡", "有毒腺的", "无礼貌", "不知所云", "愚昧", "疑", "不长眼睛", "鬼天气", "无谓", "训诫", "愁苦", "下等的", "不合时宜", "窖藏", "遇难船", "肤浅的", "不平等", "不省人事的", "无决断力的", "饥荒", "疲倦的", "无兴趣", "抱疚", "黑漆寥光", "黝暗", "使加深", "责备话", "啼哭", "跛足", "使伤残", "蔑视", "闹得不愉快", "草草", "破烂", "不生育的", "惊叹", "小卒", "挖苦的", "牲畜栏", "干麻", "一无是处", "发愣", "囚犯", "臭男人", "自任不凡", "很气", "使脱轨", "次要", "磕磕绊绊", "不长果实", "不精确", "轻描淡写", "不幸的人", "凶暴", "误用", "惼", "把..割下", "令人讨厌", "打退", "羞涩", "无怜悯心的", "茕", "油渍渍", "不尊重", "妈的", "不体面的", "死脑筋", "索然", "诱惑", "晦暝", "不对", "摭", "油滑", "批评家", "良心不安", "恐怖主义", "暴风雨", "大乱", "奴性", "尴尬", "未经检查", "令人生气", "含蓄", "剧烈", "横着的", "败坏", "不平衡", "心惊肉跳", "不两立", "低档", "昏乱", "用滥", "艰难曲折", "紧巴", "狠狠", "凄凉的", "色厉内荏", "狎", "呆滞的", "裹尸布", "毛骨悚然", "泥泞", "犬儒", "琐碎", "较劲", "肏你", "偷偷摸摸地行走", "找茬", "旁敲侧击", "有失偏颇", "失察", "薄弱", "虎着脸", "完全丧失者", "累卵", "过度", "惘然", "变忧沈", "哀怨", "欠妥", "斑驳的", "心急如焚", "压倒性", "忘不了", "残虐", "从重", "良心被狗吃", "恬淡", "万劫不复", "不肯接受", "无依无靠", "强暴", "无关紧要", "强制", "行为不礼貌", "起诉人", "苛刻的", "巫婆", "惹毛", "不满足", "塞你娘鸡吧", "惨死", "无变化", "窝囊", "残忍", "优柔寡断", "粗制", "假毒品", "突发", "模糊不清的事物", "恐怕", "浪费的", "禁制", "水火不相容", "见风使舵", "刁蛮", "恶魔的", "淡而无味的", "罢市", "嘲讽", "感到灼痛", "镇压", "差强人意的", "封闭式", "麻醉药物", "错综复杂", "说不过去", "苶", "砰然作声地", "兔死狗烹", "论争的", "错觉", "其貌不扬", "厚脸", "神经错乱", "阴郁", "暴躁", "倾斜", "哗然", "强迫..服务", "运气好", "焦急", "不科学", "分离的", "闷沉沉", "滥用", "粗莽", "脏乎乎", "胡乱搞", "流言", "艰苦的", "索价", "冗语", "碎片", "挑剔的", "使失调", "不要脸", "浅", "使瓦解", "垮台", "臭名远扬", "俚俗", "莽", "不习惯", "浮滑", "懊丧", "难达到", "惶惶不安", "杯弓蛇影", "使头晕眼花", "一手遮天", "做作", "蓬乱", "不能解释的", "扼杀", "胡吹", "苦", "欺诈性", "反复告诉", "落寞", "凶猛的", "眼泪", "险峭", "粗鲁无礼", "剧毒", "恝然", "呼啸", "绷脸", "慢吞吞地", "荒瘠", "令人沮丧的", "心情浮动的", "触怒", "哽咽", "走散", "浸水而沈没", "纷乱", "经验不足", "恶名昭着的", "使处於不利地位", "使不高兴", "狷急", "不美", "老辣", "嗔怪", "冷淡", "骭林娘", "疾病", "放一个屁", "不得要领的", "懈怠", "没劲", "贸然轻率", "触及", "坐而论道", "闹革命", "压抑住", "流逝", "缺乏教养", "衰弱的", "腐恶", "随口", "有口无心", "玩世不恭", "使惊愕", "威慑", "作假", "憋气", "初出茅庐", "无家", "哀悼", "令人疲倦", "含愤", "痛恨", "负", "狼狈为奸", "不规则的", "一钱不值", "外伤的", "颓废", "面色蜡黄", "使减少", "无用", "骨折", "使破烂", "厌倦", "乞丐", "磕头碰脑", "繁复", "不省", "瘸的", "抢走", "看风使舵", "贱命", "神不知鬼不觉", "大谬不然", "无救", "匆匆忙忙", "窘急", "道德不好", "不登大雅之堂", "骂", "拒绝承认", "犯怵", "没用", "累赘的", "干", "宥", "有害的", "无人", "焦燥", "陷阱", "无精打采的", "干你娘老鸡巴", "真假可疑", "从..清除", "疑忌", "使延期", "拿腔作势", "颤抖", "不赞同", "好事多磨", "反覆无常的", "小小不言", "劫掠", "非常饥饿的", "跛足的", "使烦躁", "菲", "猛夺", "使变暗淡", "羞辱", "使失宠", "斗争", "官僚主义", "交疲", "黯然神伤", "赛人", "无目的", "烟雾腾腾", "刁恶", "嚣杂", "豪横", "缺陷", "哀伤", "呆呆", "恶报", "地雷", "不学无术", "面带嗔色", "下三烂", "不检", "优柔寡断", "气呼呼", "气冲牛斗", "捕风捉影", "傲慢的", "不名誉", "使失去", "狂暴", "制止", "费工夫", "令人不安", "窘迫", "不可信", "冷峭", "逃避义务", "羞耻", "急语", "懒惰", "狡诘", "摇摆", "小看", "发脾气", "亵渎", "肆无忌惮", "结结巴巴", "怍", "倾倒", "悒", "见罪", "过多", "伤..的感情", "羞怯", "变旧", "没受教育的", "呆愣愣", "非", "指鸡骂狗", "生硬", "不合法", "霭霭", "充满危机", "烦闷", "被控", "照本宣科", "难接近", "未达到", "遗漏", "高速疾驶", "愣头愣脑", "愁眉", "干戈", "凄寂", "差强", "变化无常", "鄙", "用树篱围", "苦干", "失焦", "苦大仇深", "质次价高", "搞独立", "反对", "狐疑不决", "一错再错", "冒充的", "唉哟", "酸", "傅会", "摧毁", "粗暴的", "竟然一直给我", "布置地雷或水雷", "凄冷", "幻", "没注意到", "不予置评", "残酷无情", "诧", "误入", "不像话", "发育停止", "自以为了不起", "掉以轻心", "抱恨终生", "气坏", "直呆呆", "最後的审判日", "假正经", "泛", "倒垃圾", "啰里啰唆", "不等", "尖酸", "易变", "错乱", "污物", "恧", "奢糜", "智障", "蹇", "不合适的", "不相宜", "蕴藉", "费时", "傻里傻气", "悍然不顾", "横过", "甩得一乾二净", "赘", "不能信赖的", "使人不愉快", "怒发冲冠", "缥缈", "荒诞", "不好", "猛然", "搏斗", "隐身", "寡言少语", "恝", "使纠缠", "嗬欠", "龉", "挖空", "失利", "惴惴不安", "应负责的", "猛烈", "劣质", "假仁假义", "虐待", "落後程度", "遭受", "过分单纯化", "我操你妈", "坏的", "示不同意", "命令", "瘫软", "严冷", "怀疑", "隐蔽处", "误期", "磨损处", "不中用", "歧视", "不以", "惊栗", "无补于事", "减弱", "苦不唧", "稀松", "大意", "怒潮", "揍一顿", "没边儿", "耍心机", "未必的", "大夸", "判决", "蠢男", "拍拍屁股走人", "啬刻", "盛怒", "拉紧", "不更事", "满腹", "针砭", "嫌", "鸟尽弓藏", "驳难", "不耐", "惊怪", "致命的", "搀杂", "乱哄哄", "离乡", "不起眼", "有啥", "扯碎", "风雨飘摇", "表里不一", "丢魂", "非议", "菀", "悻悻", "冷嘲的", "嗔怒", "高压", "挂虑", "惊惶奔跑", "剧烈的", "打入十八层地狱", "昏庸", "刮出", "挡开", "虚诞", "惊异", "有仇", "亏马子", "过虑", "易爆发的", "己见", "饥谨", "堕落的", "呼幺喝六", "权宜", "混杂", "喧嚣的", "不充足", "没法", "挫赛", "拒绝接受", "强制性", "扫兴", "洋鬼子", "敢死你", "起诉状", "拉下脸来", "羞於", "叫苦", "搞关系", "不肖", "那里惹到你", "冷", "行为不检的", "恶言", "淫荡", "使变模糊", "失去母兽", "怪诞的图样", "不能肯定", "剔除", "不明确的", "反动分子", "滞後於", "激烈的", "藐视", "使变酸", "使磨损", "卖弄风骚", "魄散魂飞", "白目", "疑难", "哭妖", "伪装", "官僚", "讪讪", "缩小", "哀哀切切", "毛骨悚然", "残暴", "有名无实", "薄弱", "狡诈", "损坏", "不亲切的", "淘", "痛骂", "谋反", "吵架", "操你", "斜体", "贸贸然", "看不起", "不值得", "发红", "乌漆墨黑", "无常", "反其道而行", "有伤风化", "猪哥", "大小姐脾气", "歪", "交恶运", "困顿", "中伤者", "不合格", "赘词", "后患无穷", "充满危险", "含含糊糊", "肉", "愧对", "做贼心虚", "不甘", "沈溺", "疯疯癫癫", "卑贱", "放荡", "戟指", "谫", "倾销", "胡闹", "畏忌", "蔓生", "狠很", "贫寒", "轻蔑的", "古怪", "不受感动的", "空洞无聊", "恨死", "架空", "疾驶", "仗着", "腻歪", "不欢而散", "忍下来", "搞的鬼", "品性不端的", "祸不单行", "惊怕", "腐败", "乱诌", "暂停", "感觉不到", "作梦", "冒有风险", "椎心泣血", "傻子", "缺德", "祟", "使消沈", "使心慌", "得不到休息", "意图", "沈重的责任", "入迷", "骂他", "无口才", "可忍受的", "自傲", "迂阔", "未经通知的", "流浪汉", "煽动者", "旧病", "似是而非", "气疯", "使不舒服", "坏事", "使降级", "无动于衷", "不舒适的", "漏气", "鸷", "叫喊声", "荒诞无稽", "粗鲁的人", "想呕吐的", "不顾", "惨烈", "恹恹", "好挖苦人", "哄诱", "不易的", "刺耳声", "悲伤的", "未经训练", "进退维谷", "不讲道理的", "祸国殃民", "脾气坏", "蠢话", "是非不分", "惊慌失措", "未完全发展的", "最屌", "破产了", "穷苦", "打扰", "懵懵懂懂", "使无效", "使发怒", "不近情理", "使变陈腐", "吃力", "羞赧", "辛辛苦苦", "不毛", "但愿", "气汹汹", "拒受", "遏制", "真假可疑的", "败德", "敌对的", "抱憾终身", "鸡巴", "俗丽", "气冲冲", "浮光掠影", "贱", "喧嚷的", "殆", "复", "诱..入圈套", "挤满", "清冷", "杀人罪", "绕圈子的", "安抚", "淡漠", "讥刺", "愧恧", "悬心", "利已", "一团糟", "怨命", "任性的", "使晕眩", "恶运", "颠三倒四", "闷", "厌恶", "斜歪", "家徒四壁", "破败的", "辁", "残酷的行为", "老到", "卖假毒品给人", "疑虑", "惊呆", "失和", "下降", "过时的", "愣怔怔", "骂一顿", "不近情理", "成为障碍", "刻薄", "暗", "有恃无恐", "避债", "砍头", "搞这一套", "死猫", "难过", "用嘶哑的声音说", "声色俱厉", "古怪的人", "难接近的", "苛责", "谋得", "偷摸", "造成损害", "很蠢", "不合逻辑的", "呵叱", "饥饿", "随随便便", "哇咧", "辛酸", "凛", "不能辨别", "游荡", "宿命论", "逼退", "华", "相反地", "义愤", "无理取闹", "情况不好的", "病歪歪", "暧", "心绪沉落", "惨毒", "怔住", "蜚语", "退场", "麻烦事", "吹牛皮", "微弱的", "神经病的", "不服从的", "卖弄", "无感觉的", "惊讶", "批驳", "不虔诚", "痛心疾首", "误人子弟", "非生产性", "忧怨", "使痛苦", "懒汉", "不注意", "暗地里", "冗长的", "厚脸皮", "使人生气", "低沉", "发出嘈杂的声音", "低声下气", "嗤之以鼻", "使腐烂", "必修", "谬", "急性子", "蛮横无理", "弱", "饶", "误差", "搞小动作", "犹犹豫豫", "养伤", "离开正道", "叶公好龙", "逆境", "憋着", "费精神", "泪流", "策略性", "悔不该", "才疏学浅", "屠杀", "六亲不认", "偷偷地吃", "不平常", "使折断", "猎食", "艰难", "使僵持", "可怜", "无实效", "咒骂", "怪异的东西", "突然不见", "刚愎的", "与..矛盾", "很屌", "没办法", "腐败", "冷静", "胸无城府", "不利于健康", "诱获", "不兴", "失望", "洪流", "吝啬鬼", "孑身", "烦嚣", "缠结", "胡说八道", "自以为", "用拳猛击", "未触及", "道德不好的", "脱口", "零丁", "不羁", "空想家", "萧条", "胡乱对付", "急眼", "同情", "恶煞煞", "没得说", "恐布份子", "使沮丧", "使性子", "患病", "勾引到", "被掩饰", "狂怒", "说反话", "不知羞耻的", "真他妈贱", "使讨厌", "污七八糟", "歉然", "不安的状态", "无赖", "断念", "蛮", "屌ㄌ", "睡不着", "娇憨", "隐蔽的", "避重就轻", "萎靡不振", "变幻不定", "糟透了", "唠唠叨叨地责备", "沉郁", "使受毒气影响", "惟我独尊", "不智", "残疾者", "笨手笨脚", "讥讪", "哭诉", "感伤", "把工作搞糟", "随便", "透露", "嫩", "漆黑", "隐秘", "涩滞", "磨不开", "挥霍无度", "一成不变", "使透不过气来", "悲观", "不法行为", "不肖", "脸皮薄", "潜行於", "反动主义", "引起紧张的", "瘠", "淫逸", "痛哭", "不符", "制止物", "多馀的", "日本鬼子", "危险物", "在那边混", "误诊", "分歧", "花容失色", "无政府状态", "惶", "讶异", "刺眼的强光", "涉世不深", "下不来台", "极蠢之人", "强烈的欲望", "黠", "示众", "跺脚", "局促不安", "迫切", "过早", "虚假的", "不负责任", "受腐蚀", "隐藏", "杀人不眨眼", "低智", "乖戾", "价格不菲", "轻信的", "冷清清", "差强人意", "凑什麽热闹", "踹开", "打问号", "玩笑", "险毒", "世侩", "贫穷", "变坏", "去死", "混淆不清", "懊恼", "怒火", "狂乱地说", "桀骜不驯", "伪造", "击败", "无聊", "面生", "未成熟", "淡而无味", "占去", "不悦耳", "追诉时效", "一下子爆发", "不新鲜", "无声音的", "不知道的", "冷噤", "惶惶", "遗赠", "莽苍", "忍受", "淡漠", "三八", "漠不", "失实", "起绉", "铁血", "丑死", "曲曲折折", "不信", "一塌糊涂", "取笑", "不怀好意", "桀", "含恨", "感染", "呆气", "正颜厉色", "悲观的", "气粗", "没有礼貌", "不正的", "裂缝", "极可厌", "污的", "理不直不壮", "不实在", "委决不下", "办错", "吵死", "前後颠倒", "贪求", "使沾上泥污", "肥胖", "随风倒", "不流行", "靠幺", "激浪", "萧疏", "多变", "空", "一再", "心急如火", "未经训练的", "孤单", "生拉硬拽", "隐隐", "刚愎", "恶名昭张的", "抢劫", "使不合格", "太随便", "失眠的", "不胜任", "悲愁", "破陋", "鄙俚", "危在旦夕", "死亡", "去搞", "那麽没用", "可疑", "惨败", "不屑於", "伤", "意志消沈", "白衣苍狗", "缺心眼儿", "颓唐", "泥污", "分泌毒液的", "陈旧", "脱口说出", "卑下", "乱讲", "远点", "不调和的", "干你娘", "杂多的", "恼怒", "砰声", "枉费心机", "爱莫能助", "没收物", "落俗套", "一把死拿", "已过盛年的", "死胖子", "不长果实的", "忌", "性急", "悛", "进行威胁", "不可预知", "寒冷", "坏去", "五味杂陈", "油头滑脑", "悍妇", "小提大做", "生恐", "自私自利", "落寞", "可惜的", "引诱", "奇怪", "使不知所措", "烦死", "心高气傲", "吵的像什麽鬼一样", "付之一笑", "将浮渣去除掉", "拳打脚踢", "被放逐者", "捣蛋鬼", "潮", "声名狼藉", "凶猛", "含糊地说", "变得模糊", "不为人喜的", "瘠薄", "凋谢", "顽皮的", "嗤之以鼻", "没才华", "不耻", "垢", "缺乏绅士风度", "自认", "无秩序的", "牛头不对马嘴", "被利用", "昏黑", "猛扔", "大烂人", "爱吃", "大失败", "傻呵呵", "见风转舵", "不足轻重", "作战", "乌烟瘴气", "缺席", "做霸占行为", "处於支配地位", "来气", "宠坏", "木棍", "弱点", "雪上加霜", "反反复复", "退学", "黑茫茫", "酷烈", "呲", "无可无不可", "喋喋不休", "心眼儿窄", "墓穴", "严厉对待", "爱挑剔", "撸", "行为不端", "愚鲁", "骂得狗血淋头", "烂上", "未揭露", "刍", "战栗", "未缓和", "死有余辜", "内疚", "不清不白", "剌戾", "处於不利地位", "清高", "凶", "被撕破", "零零碎碎", "作弄", "大祸", "消耗性", "模棱两可的", "偷工减料", "对..不忠", "使对抗", "平白无故", "不在乎的", "丢掉", "原子尘", "不好使", "无礼", "冷酷无情", "贸然", "使陷於", "笨重", "不稳固的", "恼火", "走神", "使稀薄", "闷闷不乐的", "不能容忍", "失检", "停止", "挤过", "异乎寻常的", "经济拮据", "皮", "包围", "次级", "发出刺耳声", "罢了", "赘余", "窒息噎", "剧痛", "死寂", "没规矩", "掺假货", "对..突然查抄", "伤心惨目", "垄断", "妄动的", "不对头地", "退化", "无声音", "不关痛痒", "被骗", "低俗", "过得去的", "小心", "无吸引力", "偏心", "封闭", "劣等的", "斥骂", "奸猾", "拘", "矫揉造作的", "喷出", "表示谢绝", "沓", "变态者", "埋地雷", "不公平", "悬乎", "老气横秋", "不吉利", "使费解", "急不可待", "退落", "木讷", "武装部队", "不受感动", "喧闹声", "背时", "响而刺耳", "躲藏者", "塞哩几抠碗粿", "短少", "古怪", "卷入", "不及格", "怒气冲天", "皱巴", "牵肠挂肚", "失调", "粗野", "贫", "致人死命", "被雷打死", "掴..耳光", "假正经", "自夸的", "逃避责任", "不确实", "僻", "等着看", "藏奸", "衰竭", "干你全家", "出乎", "对峙", "穿不得", "毛头毛脑", "撞击声", "畸形", "发麻", "偏废", "坏孩子", "忧虑的", "谬误", "奸恶", "变化无穷", "说怪话", "浪荡", "娆", "吵嘴", "不郎不秀", "手生", "肆行", "不愉快的事", "可鄙", "使茫然", "做假", "老弱病残", "偷工减料", "懆懆", "泄气", "百孔千疮", "害怕", "勾结", "使起纠纷", "残废的人", "劳累", "死期", "强加", "不可一世", "恶毒的", "最後通牒", "摇摇欲坠", "失业", "侵略的", "绝对的", "惊骇", "密藏", "不在意", "达不到", "假装的", "吓坏", "难信", "茫然的", "尖着", "保守", "拮据", "失手", "失恋", "烂到极点", "愚行", "呜咽", "暗黑", "不宁", "麻烦的", "怀恨者", "不严密", "多风暴", "背叛", "耍小姐脾气", "少给", "义愤填膺", "坚硬的", "杂物", "严峻", "惨案", "阴谋者", "有罪的", "同情的", "刮落", "哀戚", "吃错药", "竹篮子打水", "僵硬", "酸味", "碍眼", "忧心", "破产", "漠", "忿恨的", "死囡仔", "致使", "尖锐的", "亏缺", "旁若无人", "走失的", "非分", "骄奢淫逸", "关我什麽事", "引起嘲笑的", "发飙", "如丧考妣", "容忍", "阴暗", "鸷悍", "哝", "告诉错误的消息", "使人反感", "陷害", "血腥", "亏死了", "放荡", "悲恸", "说风凉话", "奸", "违抗命令", "诅骂", "难处理的", "空泛", "不快乐的", "寥寂", "迟滞", "发怒", "天南海北", "说粗话", "体衰", "打乱", "无生命", "率", "道德败坏", "竞争", "谴责", "啜泣着说", "不周到", "瞀", "酸腐", "不牢靠", "使举止失礼", "危险的", "黩", "芜杂", "受感情驱使", "低落", "混淆国际视听", "火急火燎", "现世的", "怨恨引起", "无知", "他马", "送葬", "异议", "喧闹", "残", "委罪", "野兽", "打滚", "挥泪", "不庄重", "小气", "卑鄙的", "不适应环境的", "潦草", "大吃一惊", "申讨", "冒..的危险", "抓来", "邋邋遢遢", "无恙", "炸药", "老气横秋", "含恨", "令人伤心", "给我小心点", "贝戈哥", "畏怯", "指斥", "烦人", "黑", "散", "难看死了", "低人一等", "废", "污浊", "忌讳", "脚步沈重地行走", "赊欠", "不成功", "何尝", "贪财", "行为不检", "瘦削", "模糊", "吃不准", "忉", "作势", "感慨", "掠夺行为", "狼狈", "约束物", "汗颜", "忧烦", "失败者", "无诚意", "有愧", "惶恐", "丧亲", "紧急需要", "呆板", "不顺当", "死一般", "老奸巨滑", "搞飞机", "弱不胜衣", "不好意思", "弄歪", "误期的", "难以取悦的", "违章式", "谬见", "篡改", "无人理睬的", "摔倒", "後退", "糊糊涂涂", "羞人", "幽晦", "硬气", "空洞", "岔子", "违抗命令的", "患", "打烂", "索然无味", "暴躁的", "不经心", "孤单单", "问道于盲", "剧跳", "流气", "简陋", "哀诉", "杀死", "深以为异", "烦心", "与..脱离", "豪强", "气壮如牛", "小气的", "放弃权利", "不务", "豪侈", "白痴般", "受痛苦", "疯癫的", "蚕食", "闹得慌", "虚幻", "不厚道的", "怪力乱神", "幼稚", "有缺陷的", "不为人知", "冷漠", "伪人之心", "奸诈", "懒惰的", "任纵", "使断念", "过不去", "装可怜", "大闹", "劣根性", "死得难看", "使变黑", "稗", "怫然", "窒息", "昏迷的", "悲恻", "完全丧失的", "支离", "格斗", "装腔作势", "干屄", "不经济的", "恂", "伤痛欲绝", "不健康", "之嫌", "凄苦", "失常", "乌烟瘴气", "粗劣", "费力", "哀痛", "不忠实", "不胜任的", "愚蠢的", "易爆发", "荒年的", "朦胧", "不合法的", "虚拟", "谄媚", "泞", "未加抑制", "风凉话", "攻击", "邪恶", "不满意的", "窃听器", "开炮", "花插着", "贬损的", "将交保释放", "眼花缭乱", "迷惑", "以..为赌注", "无原则", "怫然不悦", "不可靠", "独裁", "规避", "蹒跚地走", "嘴巴放乾净一点", "愚陋", "发狂", "轻薄", "凶顽", "妨碍", "逊色", "偷东西", "滚蛋", "饥饿的", "要求", "猛烈的力量", "禁令", "阻滞", "不长", "诱捕", "心胸狭窄", "四大皆空", "抓来打一打", "没有防备", "大吵大闹", "缺乏幽默", "哩哩啦啦", "怨声载道", "丑丑", "妨碍者", "可憎", "避免", "好呕", "不可能之事", "搞得一团乱", "怎麽混", "怒发冲冠", "自作", "短路", "该责备", "倾侧", "富余", "望梅止渴", "漆黑一团", "不问是非情由", "不近", "未指明的", "沉闷", "暴戾之气", "成废物的", "没有目标的", "使烦燥", "断裂", "次等", "差劲", "粗心", "不大可能", "阻拦", "鸡零狗碎", "不忠", "闹脾气", "胆大", "潸然泪下", "脆弱", "失礼", "三天打鱼两天晒网", "危如累卵", "屠宰者", "烟雾", "拘执", "精神病患者", "打死", "撕裂", "干礁", "暴戾恣睢", "煞费", "低层", "追踪", "不成材", "踟躇", "十室九空", "冒火", "轻蔑", "不负责任", "滥老师", "不敬", "油腻", "闲散", "混沌", "意见分歧", "超越误差", "蠢蛋", "不辨菽麦", "狼狈不堪", "恨死你", "狭窄", "气哼哼", "狂热地", "陡然下降的", "不和蔼", "使堕落", "荒疏", "刻毒", "微暗的", "难驾驭", "甩了", "最糟的是", "落落寡合", "含羞", "不肯定的", "哇勒塞你娘", "不愉快的", "使不安", "吵吵闹闹", "粗鲁地对待", "唯恐", "不舒服", "败家", "险阻", "有难度", "聒", "乱砍", "不适任的", "变阴暗", "失去能力", "装作", "言不及义", "鲰", "愠怒", "冗赘", "欲呕", "凶狂", "担负", "辗转", "该死", "悲情", "迷宫般", "干休", "私自", "捕捉之物", "愤恨", "人人自危", "被撕裂", "嫌疑犯", "僵痛的", "板滞", "唯恐不及", "使粗糙", "无教养", "慢性的", "粗心的", "胆颤心惊", "诶", "不真实", "伤元气", "托辞", "癫狂者", "无用的", "落下", "穷光蛋", "不合意", "弱小的", "侵害", "歇斯底里", "刻苦", "想不到地", "养肥", "恚愤", "跩什麽", "媸", "泪珠", "徒然", "沉寂", "没救", "耻辱", "不受", "重担", "拖延", "勒除", "灰朦朦", "变得有缺陷", "惦记", "屈才", "淘气", "人声鼎沸", "抓取", "浊", "凶戾", "裂隙", "漠然", "惶惶不可终日", "有害的植物", "惨不忍睹", "顽固", "猖獗的", "舔鸟蛋", "轧轧", "未发觉的", "目光短浅", "诡计多端的", "内斗", "不洁", "无精打采", "烟雾弥漫的", "吼道", "胁迫", "示不满", "辞职", "嘴巴烂掉", "不宜说出口", "不明不白", "侈糜", "不合时宜的", "不合标准的", "破坏..的基础", "颓废期的", "狡诈", "不直截了当的", "晒焦", "闻风丧胆", "勒除器", "留下伤痕", "犀利", "偷摸行走", "恶心", "险诈", "衰微", "怀恨在心", "砍得很深", "阴森", "乱了方寸", "夸诞", "乱吠", "败坏", "心急", "沈闷的", "卑怯", "尖叫着说", "烫痛", "如临大敌", "诱惑力", "匆忙咽下", "不济", "骂他神经病", "惹人恼怒", "向隅而泣", "迷离倘恍", "邪恶的", "由不得", "置之不理", "面带怒色", "夸大", "势成骑虎", "无心", "愁眉锁眼", "急忙", "唯恐天下不乱", "易生气", "凶杀", "拗", "含有特定意味", "暴发", "无依", "反讽", "情何以堪", "浇漓", "絮", "怫", "偏颇", "拉不下脸", "鸡毛蒜皮", "要死", "怪异风格", "使恶心", "迷恋者", "造反", "坏水", "吃不下", "臭烘烘", "畸轻畸重", "辛苦的", "十恶不赦", "酥", "堵得慌", "沦为乞丐", "割破", "不住", "鲁莽", "滥打", "不安定", "擦破", "鸡歪", "大错", "不在意的", "惹人恼怒的事", "愚笨的", "有得瞧", "看不上眼", "债务", "靠夭", "不关心的", "示怒", "逃避", "气恼", "没精打采", "玩忽", "不要紧", "嫉妒的", "鄙陋", "神经紧张的", "恫", "蛀蚀", "锥心", "眼睛瞎调", "极度渴望的", "阴郁的", "粗线条", "处罚", "为什麽还", "忍气吞声", "困顿", "临死的痛苦", "闹哄哄", "片断", "佶屈聱牙", "混吃等死", "翻滚", "不近人情", "有差别地对待", "打击", "斥骂", "潜伏", "毒品交易中收钱而不给货", "狂悖", "油脂麻花", "忧虑", "不胜", "持异议", "旷课", "作难", "战战兢兢", "讽剌", "是怎样", "像哈巴狗一样", "笨拙地说出", "惆", "使空转", "抱不平", "荒芜", "发疯似", "目空一切", "狠劲", "声明拒付", "引起嘲笑", "感到难过", "遏制的", "不易弯曲", "不好过", "心机很重", "不予", "赶快消失", "空想", "虚幻的", "寒心", "生疑", "爱搭不理", "准备参加战斗", "超重", "易受..影响的", "躲避责任者", "做错", "细碎", "悔恨", "还不够乱吗", "朝三暮四", "僵硬的", "不可更新", "极坏的", "没有能力", "给...一点颜色看看", "使..失去法律保护", "卑鄙无耻", "羞涩", "争气点", "破坏我的心情", "不寻常", "奢靡", "毒害", "使发愣", "奴隶", "化石", "以退为进", "阴", "昏昧", "讥诮", "不能解救", "滞後", "小孩没屁眼", "喜欢吵架的", "戳壁脚", "回避", "不理智", "与..竞争", "心狠手辣", "屌琅当", "板", "不合算", "蹙额", "起褶子", "冷冷", "断掉", "草木皆兵", "恶习", "毒液", "贪婪", "不雅", "扼死", "零落", "猾", "幽", "刺客", "学坏", "哭着使..", "贱命一条", "蓬散", "不受欢迎的", "垃圾场", "使不正常", "损失物", "强横", "不甘不愿", "阴惨的", "砰击", "你以为自己", "忮", "不得要领", "不情愿的", "偷偷地做", "嘴尖", "瘆得慌", "杀害", "恍恍惚惚", "夭折", "嫌东嫌西", "变节", "滥捕", "未成熟", "吐一口痰", "咋舌", "提防", "无感情", "晕眩的", "歪歪扭扭", "着急", "疙里疙瘩", "打仗", "不利", "压制性", "疙瘩", "不幸", "皱", "面斥", "惟恐", "减少", "乖剌", "关他屁事", "异想天开", "战役", "千疮百孔", "崎岖不平", "奴颜婢膝", "狠毒", "洁身自好", "虚有其表", "秘密的", "出轨", "从心所欲", "够了没", "逆着", "碍眼", "虚虚实实", "弥天", "污迹", "渗透", "不要", "忸怩作态", "无凭无据", "临时手段", "槁木死灰", "颓败", "故意", "臭娘们", "不孝", "生变", "咒", "独断", "婞直", "批斗", "置之不顾", "混沌", "唯恐", "隐伏的", "花钱浪费", "离开", "榨出", "冷厉", "使退却", "漏损", "人渣", "粗心大意", "关上", "策略", "不到", "不屑", "严厉批评", "谁死谁亡", "失神", "吝啬", "不可挽回", "表示轻蔑", "棼", "彷徨", "捆住", "干你桌来", "局促", "害怕的", "魔王", "反动派", "惹的祸", "干到最高点", "愁眉不展", "棍打", "嘈杂声", "绊倒", "告发", "严重事故", "世俗", "有差别", "强光", "哈欠", "使陷入", "海底捞月", "自卑情绪", "一箭之仇", "使疲倦的", "急", "庸", "冲口", "自相矛盾", "行不通", "漫漶", "怀敌意", "失业者的", "草率的", "人不知，鬼不觉", "发软", "木", "与..斗拳", "无理", "花里胡哨", "步入歧途的", "单挑", "令人愤慨的", "变得紧张", "不够格", "糟糕", "使极苦闷", "急躁", "残忍的", "骇怪", "文弱", "压迫", "不平衡的", "使复杂化", "魔女", "不知所措", "未下定义", "好责骂", "偷偷摸摸", "违命", "貌似强大", "狂风", "瓜田李下之嫌", "往心里去", "滞钝", "牵制", "张扬", "膈应", "乱纷纷", "辛辣", "挤巴", "残骸", "臭屁", "使极痛苦", "碎布条", "含糊地说话", "剉小", "罢课", "没水准", "猛烈的", "变化不定", "使沈没", "裂痕", "脚步沈重地走", "旧病复发", "背叛者", "断肠", "吹嘘说", "否决", "天怒人怨", "无利益", "使复杂", "扣押", "辩解", "删除", "心软", "使陷入困境", "淡淡", "使後退", "伤害", "惨白", "骑虎难下", "摆脱", "碍难", "羞", "不堪入耳", "密告", "自私到极点", "蔑", "短处", "有..倾向", "麻醉", "不巧", "伤心", "国仇家恨", "鬼", "权宜之计", "夹七夹八", "间杂", "使不足", "把..吓跑", "占着", "痛哭流涕", "狠命", "誓不两立", "极可厌的", "狮子大开口", "意欲", "饶人", "发腻", "质量差", "纸醉金迷", "挥霍无度的", "艽", "搞统一", "萧索", "停业清理", "愎", "紧急事件", "高难", "朝不谋夕", "乾咳", "吃得过饱", "价高", "揶揄", "装相", "恣意", "诡计多端", "斗争", "尖声发出", "昂贵的", "陡然", "丧失公权者", "娇羞", "逼人", "不对称", "干走", "假冒", "贼头贼脑", "不适当", "以讹传讹", "横冲", "未击中", "幼稚", "变黑", "插嘴", "危亡", "遗憾", "烦忧", "怒气冲冲的", "对..提出质疑", "好争论的", "眼花缭乱的", "处境艰难", "不成样子", "讨厌", "可耻", "吃劲", "管闲事", "莫名其妙", "野草", "险", "挂记", "怕", "秽乱", "打鼾", "死赖", "轰击", "贱人", "精疲力尽的", "烂源", "冲天骂娘", "抽噎", "义愤", "羞愧", "罪不容诛", "现出愁容", "沾污", "被扯破", "魔鬼似", "说谎", "昏迷", "穷困的", "加油添醋", "保守", "褊急", "含混的", "矫揉造作", "自欺", "封闭型", "寒酸", "使发狂", "使生气", "不公平的", "置疑", "怀疑宗教教条的", "搪塞", "娇生惯养", "奸诈", "毛躁", "盲信", "操贱役的人", "侮辱", "不合法", "囊空如洗", "怀恨的", "深重", "不适应环境", "大变革", "婉拒", "煞风景的", "猜疑", "烟雾弥漫", "戏侮", "恕宥", "强挤", "否认", "徒劳无功", "坡", "撒旦", "荒唐无稽", "前呼后拥", "娇养", "贝戈戈", "满脸横肉", "邋遢", "轻忽", "无礼的人", "夹痛", "闷闷", "目光凶狠", "没救了", "嘀咕", "忧国忧民", "气忿忿", "过世", "极度地", "活该", "满目疮痍", "在困难中", "非法", "不值得的", "衰颓", "奓着头发", "谈虎色变", "无法预料", "渐渐破坏", "固执", "迟钝", "简单", "违反行为", "去你的", "申斥", "不卫生", "不调和", "被玩弄的人", "强挤入", "提心吊胆的", "费用浩大", "轰炸", "穿不出去", "下贱", "刑事", "肩摩毂击", "招供", "不正直的", "无魅力的", "不能矫正的", "枯槁", "使摆脱", "禁欲", "疲劳", "笨拙的", "嫉羡", "毫无", "使挫折", "最没有", "延缓", "蓬首垢面", "死气沈沈的", "捉摸不定", "怜", "拍击..使之前进", "六神无主", "低下", "怠惰", "窒息而死", "撒气", "猛攻", "吃不开", "支吾", "铤而走险", "未知的", "走险", "乱吼", "胡说", "豪", "查抄", "鬼鬼祟祟的人", "一掷千金", "造成破坏的", "不实在的", "忿忿然", "病态", "反对..提案", "倒不如", "弄皱", "粗笨", "隐形", "无依无靠", "无节制", "弄碎", "糠", "财迷心窍", "灰心", "郁郁不乐", "没教养", "无精打采", "不是人", "由他去", "伏兵", "不准", "脱离常规", "被害", "丑恶", "破坏心情", "惦挂", "阴晦", "被勒死", "有成见", "变黑暗", "反作用", "失检", "泥泞的", "不宁", "狡狯", "不得人心的", "好唠叨的人", "迂回说法", "使得灾祸", "臭气", "割下", "心灰意冷", "使丧失", "千疮百孔", "设陷阱捕捉", "虚空", "厚着脸皮做", "费", "不真诚", "闷气", "不平", "食言而肥", "精神分裂", "只听楼梯响，不见人下来", "悬系", "坏的东西或情形", "抵抗", "短暂", "模棱两可", "不卫生", "假手", "迷乱", "不妊", "偷懒的", "贬黜", "黑暗", "肉麻", "不可行", "抽打", "暮气沉沉", "出乎意料地", "鸡屎肚", "扯懒蛋", "野蛮", "装死", "偷懒", "袭取", "气呼呼", "该咒骂", "呆头呆脑", "不屑于", "同谋", "冷酷的", "贪婪", "反动主义的", "才怪", "唉唷", "小人", "猖獗", "发脾气", "不情愿", "失密", "尴尬", "有目的", "流氓", "投敌", "扑灭", "如野兽般的", "寒冷的", "不像真实", "区区", "脆弱", "无价值", "蛮横", "漠然置之", "坏", "封锁", "死", "发疯", "悠谬", "怅惘", "轻佻", "蒙昧", "刻薄", "好事的人", "说含沙射影的话", "充公", "束手", "求助", "反", "无感觉", "制服", "白痴", "强盗", "凿死理儿", "失礼", "不雅致", "震怒", "差异", "自作主张", "吵人", "暴敌", "艰巨", "极残忍的人", "巧取", "心神不安的", "逃走的人", "懊", "不守规矩的", "真干", "逞性子", "短促频繁", "使消散", "恶劣地", "使充满臭气", "愣怔", "激愤", "用矛刺", "隐晦", "恶毒", "无助", "赶走", "逐出教会", "乌灯黑火", "敲诈者", "私密", "徒然", "看不顺眼", "怀疑论的", "啪嗒一声关上", "强压", "秽", "使阴暗", "胆大妄为的", "踟", "一拳", "避讳", "反垄断", "怅", "上钩", "不会", "通奸行为", "感到不适", "可怕的人", "耗尽", "地狱般", "真他x的虽", "悔之不及", "矛盾的", "粗鲁", "心情沉重", "被害者", "动手", "胡干", "默默承受", "鄙夷", "冷战", "恐惧", "不悦", "干扰", "弄髒", "憨", "紧张不安的", "不服从", "大咧咧", "依违", "秘密", "下流", "漂浮", "不落忍", "好死不死", "无远见的", "通奸", "造成错觉", "臭狗", "无可置疑的", "阴暗的", "纸上谈兵", "假托", "华而不实", "不得已的", "无端端", "满不在乎", "压皱", "歇斯底里的", "失信", "杀气", "不甚重要", "不合规格之物", "心神不宁", "发狠", "被驱逐的人", "淫乱", "地狱", "反抗", "撒谎", "有够", "求救", "夺取之物", "虚浮", "告密者", "硬挤过去", "中毒", "盗贼", "无法无天", "没受过教育", "忧郁", "死黑店", "冷嘲热讽", "举止失礼", "鬼东西", "不妥当的", "着三不着两", "未受制止的", "混账", "艰巨", "着急的", "发誓", "冷峻", "迂腐", "拖沓", "不公正", "腥臊", "微不足道", "不得已", "失去", "不到案", "唠叨", "哄骗做", "闹鬼", "迫不", "乏善", "伤天害理", "惦念", "绝对地", "没轻没重", "黯然", "低等", "难捉摸", "闹翻", "老生常谈", "分化", "不加思考的", "不结果实", "葸", "宁可", "小里小气", "藏刀", "污浊", "拙", "可鄙", "没去", "低级庸俗的", "虢", "拖累", "监狱", "不满意", "刁赖", "反驳的", "难受", "被打碎", "船失事", "痛处", "单调", "拖着脚走", "抓得之物", "黑暗", "巫术", "平铺直叙", "谎", "欲哭无泪", "缺少的东西", "放纵的", "疚愧", "不正确", "隔绝掉", "目中无人的", "盘根错节", "猜嫌", "傲慢", "不修边幅", "无人问津", "嗲声嗲气", "痛心疾首", "大笨蛋", "惨不忍睹", "荒废", "虚幻", "不好卖", "天真", "闪烁", "碎裂", "动怒", "自以为清高", "机八", "危急", "不适于居住", "粗暴地", "粗俗的", "诡计多端", "吝啬", "憷", "私党", "恨你", "犬儒主义", "落後於", "理屈词穷", "不恰当地", "虚无", "母夜叉", "无子的", "疹子", "非法", "艰难的", "怀疑", "凶多吉少", "进退两难", "无理由的", "牵挂", "泼冷水", "陷住", "诡秘", "冷淡", "大噪", "不和", "搞投机", "不善交际", "尖嘴薄舌", "价值不高的", "外面儿光", "谲诈", "毵毵", "受不了", "罪孽深重", "反常的", "随风转舵", "心急", "落伍", "使惊呆", "误入歧途", "还可以的", "扰扰", "死缠", "当不起", "巴掌", "小冲突", "不公", "刁钻", "世态炎凉", "语无伦次", "狂放", "粗鲁的", "骗局", "苦闷", "促狭", "不平坦", "髒污", "辛苦", "易损坏的", "中饱私囊", "不仁", "惨绝人寰", "残疾", "有瑕疵", "犯规", "惊慌", "空洞无物", "别扭", "不正直", "投机", "渺小", "双关话", "畸形人", "傻眼", "情结", "受挫折的", "吝啬的", "背地", "乱批评", "烂女人", "喃喃低语", "愕然", "劣学生", "失意", "气死人", "没有头脑", "饿得要死", "无道德的", "荒凉", "噱头", "撕破脸", "命运注定", "流亡者", "窳败", "急切的", "未决定", "非法的", "不真实的", "放狗咬我啊", "猛地关上", "浅的", "怪罪", "冰炭不相容", "窘促", "万箭穿心", "从..开小差", "觉得自己理亏", "狰狞", "什麽态度", "打哈欠", "死不", "大发雷霆", "变得束手无策", "不孝", "恹", "用力按", "残酷", "歇斯底里症", "琐屑", "村野", "非正式", "侵夺", "动干戈", "不省人事", "暗无天日", "提出论据反对", "咯咯声", "轻率的", "被扼死", "骚乱", "抹黑", "无语", "惊讶", "连篇累牍", "揭不开锅", "搪塞过去", "倥偬", "荒野", "苦恼", "野心", "猴儿急", "厌倦", "退避", "一团漆黑", "明哲保身", "威胁", "武力", "口臭", "俗", "怒不可遏", "荒废", "落后", "猛拉", "使衰竭", "诽谤罪", "空头", "不可收拾", "大吼", "令人烦恼", "假公济私", "憾恨", "令人发指", "极蠢", "执迷不悟", "仓皇失措", "暮气", "肝肠寸断", "赶尽杀绝", "生裂缝", "使破产", "慨然", "巴结", "心眼儿小", "使灰心", "停顿", "地下", "渺茫", "恨得牙痒痒", "打出", "靠母", "放低", "恶性肿瘤", "伪造品", "腥膻", "大洪水", "擅自", "可憎的", "耸肩", "狡滑", "老派", "污秽", "可悲", "空袭", "过剩", "不眠的", "杂乱的一团", "圈套", "耸人听闻", "太闲", "狩猎", "漏洞百出", "报歉", "手脚不干净", "灰茫茫", "使污浊", "告密", "累赘", "气急败坏地说", "自求", "不对劲", "硬性", "尚武的", "灰蒙蒙", "郁郁", "腐败堕落", "令人费解", "稚气", "不如人意", "很深的裂缝", "非自愿的", "倒彩", "顾忌", "不够完善", "干你祖宗十八代", "老赶", "绑架", "哀怨", "搞屁", "来路不明", "没有观察到的", "混球", "装模作样", "他妈妈", "刻板", "反托拉斯", "低劣", "无涵养", "不配", "徵税", "离题", "不着", "高价地", "无趣味的", "慌慌张张", "莽莽苍苍", "干！", "寞", "一意孤行", "他奶奶", "旧式", "张狂", "背井", "混日", "贪欲", "犯疑心病", "战场", "低级庸俗", "刺骨", "够不爽", "悲剧", "庸碌", "使荒芜", "诅", "批判", "哇哩咧", "挑衅的", "无法", "刺痛人", "胆小的", "反目", "不告而别", "无计划", "吓了一跳", "斗不过", "无赖", "虚伪", "得不到", "波谲云诡", "抽筋", "凄凉", "虚张", "赤贫者", "愁", "慢吞吞", "自危", "哀矜", "叛国者", "顽固地", "低", "寡", "恶魔般的", "怎麽混的", "挟怨", "为祸", "飞溅", "质地薄的", "作乐", "脾气暴躁", "罗唆", "奢侈", "相异的", "消极的", "死老头", "严格的", "淡", "犯难", "不力", "死脑筋", "开小差", "讨嫌", "颓靡", "死玻璃", "醉醺醺", "昏聩", "反叛者", "更坏", "特贫", "清算", "狂妄", "缺乏自信", "诡密的", "低三下四", "横暴", "娇贵", "静僻", "假造", "白受气", "卖国", "赤贫", "极不", "丑老太婆", "不逊", "讨厌的", "押往监狱", "过了气", "徒然的", "没有考虑", "追诉", "陌生", "烈性子", "讶", "轻视", "无补", "临死", "久经世故", "奚落", "梼昧", "娇", "抱恨终天", "拈轻怕重", "怀疑的", "邋遢", "延误", "砰地", "灯红酒绿", "强夺", "头晕眼花", "诡谲", "置之脑后", "脾气急躁", "沸沸扬扬", "自任", "不顾一切", "惆怅", "警惕", "作废", "申斥", "零乱", "休克", "花心", "气死我了", "无稽", "有瘾", "定罪", "大骂", "窳", "不周到", "要紧", "威压", "放弃", "惊奇", "不牢靠的", "该死", "将信将疑", "因循守旧", "愠", "蔫头耷脑", "献殷勤", "悲苦", "感到可怜的", "直勾勾", "迷恋", "占用", "嫌贫爱富", "黑道", "颓丧", "气哼哼", "打怵", "小题大作", "狠狠抨击", "孤立无援", "不真实", "击成..", "马虎", "不清楚", "咕哝着说", "瞧不起人的", "不平等", "使惊慌", "沈沈不乐", "冲昏头脑", "少惹我", "不足额", "怀恶意", "厄运", "灰心", "废物", "精神错乱", "户斥", "微末", "狂怒的人", "不知去向", "文不对题", "有危险的", "极无礼", "抗议", "孤立的", "迷离扑朔", "反抗的", "使昏乱", "下暴雨", "狗眼看人", "刺入", "老羞成怒", "腻", "交战的", "陷危", "喜欢吵架", "伤残退役军人", "呛声", "踌躇不前", "狠毒", "欠你的", "没觉察到", "对付不了", "可鄙的", "急扯", "变暗", "焦炙", "臭老师", "詟", "削掉", "漏做", "毒蛇", "惊惧", "气愤", "四处觅食", "狂躁", "使更坏", "被吼叫着表达出来", "不知不觉", "死板", "干巴巴", "惴惴不安的", "怀恨", "千变万化", "令人敬畏", "生惧", "不礼貌", "狂乱", "拉下脸", "使惊恐", "低水平", "将..弄糟", "骄", "存有偏见", "不小心的", "摇动", "浪", "歧视", "灌输", "僵硬", "惊愕", "怔神儿", "漫无目标", "厌烦", "对头", "紧急", "荒淫无度", "郁闷", "变得不愉快", "嫌厌", "跩屁", "四面楚歌", "肿瘤", "糜烂", "脾气火暴", "犯了罪", "低下", "不愉快", "忧惧", "害羞", "无可置疑", "冲击", "未被", "异常的人或物", "惹气", "气馁", "凶悍", "含沙射影", "嘲笑着说", "死者", "没来由", "不是味儿", "窄", "未上班者", "寂寥", "祸根", "真气", "天昏地暗", "创伤的", "生病的", "被刺痛", "凝滞", "满腹疑云", "欲哭无泪", "对健康有害", "反弹", "娇嫩", "不体面", "忏", "乱吹牛", "隐隐绰绰", "惝恍", "湎", "零散", "虚无缥缈", "忌妒", "适得其反", "欠干", "咬字不清晰", "荒芜的", "凋敝", "痛心的", "鬼鬼祟祟", "长篇大论", "所谓", "降低..", "阴森", "缺乏感情或兴趣", "困难重重", "阴性", "有点旧", "没礼貌", "滚远", "犯过失", "不端", "不合宜", "诚惶诚恐", "阴森森", "更坏的事", "推挤", "忽视", "悲痛欲绝", "可叹", "鲁钝", "死皮赖脸", "大声要求的", "不愿", "半真半假", "加罪", "寒素", "无目的", "烦腻", "羞羞答答", "狼狈", "缺点", "减去", "人为", "忧思", "猛推", "出乎意料", "吓呆", "凹痕", "不劳而获", "乏善可陈", "苦闷", "搁下", "偏差", "受害", "发热", "强迫的", "薄情", "面如土色", "欠钱", "不合适地代表", "懑", "大意的", "噩", "贼溜溜", "大错特错", "才疏学浅", "小家子气", "突然", "褒贬", "混乱的", "伤心事", "忧愁", "迍邅", "损害", "犹豫", "不诚实的", "不置可否", "利益输送", "逆向", "惹祸", "拖沓地进行", "形单影只", "恣", "潜入", "魂不附体", "变动", "劈啪声", "偏", "低贱", "有失身分", "粗里粗气", "嘎", "哀悯", "不谨慎", "死德性", "未必", "透不过气来", "莫明", "惊呆", "贪得无厌", "监牢", "低级", "空洞洞", "纷繁", "易碎", "无效果的", "超然", "一气之下", "倔强", "詈", "泥坑", "有毒的", "无人遵守的", "机买", "神经病患者", "挥霍", "热病", "浅薄", "愠怒", "使蛀坏", "怨愤", "靡靡", "抽噎地哭", "凄怆", "不寻常的", "非真正", "自吹自擂", "无生命的", "愚钝", "表示坏情感", "自扫门前雪", "讨人嫌", "重新陷入", "暴发出", "学不来", "两面三刀", "使难办", "劣", "不洁净", "令人讨厌的事物", "宣判", "推翻", "可厌", "反证", "难相处的", "德性", "在..中加入脂肪", "诽谤的", "挂怀", "蚍蜉撼大树", "嘈杂", "不甘寂寞", "绌", "咆哮着说", "发出嘈杂", "故意的", "脆弱的", "作呕", "翻手为云，覆手为雨", "粗糙的", "闲混", "使委屈", "蠢事", "收买", "不可靠的", "攻击者", "使用计谋", "忧愤", "反冲的", "莽莽撞撞", "撺", "不景气", "自吹自擂说", "变化多端", "辣的", "阴影", "趁乱抢劫", "愚痴", "枪毙", "无生气", "恼人事", "不结果", "破坏名誉", "震", "不周到的", "压榨", "理屈", "缺乏才智", "通告废除", "尖锐", "凉", "拉不下脸来", "有条件投降", "错失", "胆怯", "水妖", "侵扰", "娼妓", "虞", "狰狞", "虚假", "有种", "怒冲冲", "血腥", "骂骂咧咧", "使失败", "与世无争", "惩罚", "气昂昂", "悻然", "拒绝给予", "怅怅", "不足为奇", "惟利是图", "气昏", "不肯定", "伪造的", "不敢苟同", "屁用", "残酷", "冒", "未下定义的", "心灰意冷", "诱饵", "贬低..的身份", "空空洞洞", "不惧", "哀求", "难受", "沈沈不乐的", "对进行报复", "被狗吃", "闷闷不乐", "未被通知", "诉苦", "通敌", "肿痛", "昏倒", "酸的东西", "恤", "红眼", "较坏者", "浑头浑脑", "迂拙", "疾", "有差异的", "鱼目混珠", "薄幸", "无情的", "腻烦", "准备参加战斗的", "逼退回", "怎麽搞", "严厉的", "出没", "不平均的", "叫嚷", "楞住", "滥挖", "羞恼", "愤激", "恼人", "超常", "小儿科", "不小心", "丧失亲人的", "无争论之馀地的", "不就", "涩苦", "赃物", "嗜杀成性", "使迷惑", "乱腾腾", "不完全的", "迷迷糊糊", "赊帐", "驱使", "老虎屁股摸不得", "本末倒置", "惨绝人寰", "筋疲力尽", "惨烈", "蠢头蠢脑", "发臭味", "恐怖行动", "掉队的飞机", "不充足的", "恶化", "无家可归的", "威", "手无缚鸡之力", "侵入者", "冻伤", "还会做什麽", "原谅", "柔肠寸断", "陡然下降", "使人疲劳", "脱离", "半新不旧", "两难", "突然地", "不成熟的", "卒仔脸", "痴愚", "望而生畏", "不懂事的", "与..断绝关系", "龃", "横着", "杂牌", "大惑", "坐井观天", "势不两立", "不安定的", "侮慢", "畏缩", "难闻", "战争", "吵别人", "真他妈的", "肮髒的", "困境", "陷入僵局", "你管我", "粗浅", "使混淆", "坏脾气的", "攫取", "有困难", "逃犯", "造假", "不显眼", "鞭挞", "乱成一团", "不善", "没出息", "好唠叨", "不稳定", "偏见", "寡情", "抱怨", "不太", "不得力", "不祥的", "过分简单化", "逞威", "轻易停止", "怅然", "一肚子气", "牛气", "大失", "表面性的事物", "哩溜歪斜", "狂风大浪", "一文不名", "世界末日", "轻率", "丑恶", "对不起", "倾斜的", "悍", "腐蚀性", "不出场", "减损", "骄傲自满", "离心离德", "驳杂", "跅弛", "投机", "滑头滑脑", "心眼小", "发憷", "龌龊", "长肥", "对..感到後悔", "繁琐", "孤傲", "造次", "剩余", "猛然一动", "笨手", "卑琐", "莫能", "不明确", "疑神疑鬼", "张冠李戴", "陈腐", "穷酸", "使赤贫", "赤地千里", "反对称", "次品", "料想不到的", "势利眼", "悲戚", "悱", "很混", "羞赧", "用枪射击", "束缚", "罪行", "怒目", "顿生疑窦", "假惺惺", "怪人", "变髒", "心神不安", "错综", "怀恶意的", "惊惧", "掌掴", "操你妈", "与..格斗", "无能", "不成熟", "险峻", "满脸愁雾", "不切实际", "不知恩", "不赞成", "失去感觉", "不切实际", "当头棒喝", "负疚", "庸俗", "认输", "恶作剧的", "悲观主义的", "结怨连仇", "易怒", "鸟东西", "风吹日晒", "心酸", "使抽动", "讥讽", "吝惜", "饮恨", "喷溅声", "起阻碍作用", "疏忽的", "评头品足", "反胃", "死屌", "保残守缺", "被告", "等因奉此", "抵消", "一厢情愿", "卸磨杀驴", "狠心", "阴冷", "当头棒喝", "潜伏者", "滞涩", "复杂", "流浪", "怀恨", "失效", "沮丧的", "品头论足", "不足之处", "背信弃义", "败北", "乏人问津", "乌涂", "咄咄逼人", "无知的", "眼皮子浅", "靠腰", "没用", "一不小心", "千篇一律", "名誉扫地", "使敌对", "令人恶心", "挤得水泄不通", "讽", "皱眉表示", "怯", "固执的", "乱搞", "本本主义", "忙乱", "孤独", "狂怒", "村气", "挑衅", "扭捏作态", "颓废的", "未决定的", "使人厌恶的", "穷途末路", "无趣", "骂不绝口", "把..烤焦", "冒失女孩", "心智衰弱", "晦", "失业的", "坏掉", "馀地", "死记硬背功课", "惊觉", "守旧", "倔头倔脑", "作色", "使痉挛", "不是", "花天酒地", "千钧一发", "乏人", "含含混混", "恣意", "蛮悍", "名义上", "清淡", "叱", "单薄", "跩个屁", "懦弱", "皇皇", "污垢", "离婚", "大吃一惊", "酷", "耍什麽狠", "谎话", "尖叫", "含混", "麻木的", "狗眼", "罪恶滔天", "颓废者", "卑微", "草率", "不懂", "凄楚", "坚硬", "功败垂成", "不甩", "使震动", "误会", "毁坏", "土气", "阴森地逼近", "盲信的", "好责骂的人", "疏远的", "违禁", "归咎於", "气愤愤", "矫饰", "爱管闲事的人", "喃喃自语", "低迷", "危机重重", "狼心狗肺", "无道德", "半半拉拉", "限制", "碰击", "逼缴", "发炎", "未受制止", "不可爱", "幻想", "擅自摸弄", "物伤其类", "惊惶", "什麽东西", "不足为训", "自由心证", "仇视", "晦冥", "窥探", "不应该", "易受..影响", "混乱", "愚笨", "粗暴", "难看的", "废止", "严加", "粪尿", "狗屁不通", "通俗的", "堪虑", "得陇望蜀", "暴力引起的", "会蔓延的", "稀里糊涂", "怏怏", "怖", "憋着一肚子气", "吓到", "耗费", "防守状态", "吓跑", "不成功的", "疑惑", "触犯", "老朽", "不赚钱的", "难捕捉之物", "恚怒", "愀", "受窘", "偏激", "孤立", "躲开", "痴傻", "凌乱", "差劲", "破裂", "墨", "烂掉", "油乎乎", "不休", "不坦率", "狗嘴吐不出象牙", "阴沈沈", "中伤", "得不到休息的", "骂得很惨", "守株待兔", "机八事", "管你去死", "砰地放下", "不名誉的", "怪诞的行动", "背叛的", "当不了", "不自然的", "想呕吐", "奇形怪状", "仇恨", "背信弃义的人", "丑陋", "遭遇", "瘅", "不纯洁", "猥亵的", "找碴", "置于脑后", "卑屈", "越气", "蠢牛", "搜索", "恍惚", "入迷的", "多刺", "吵吵闹闹", "破洞", "无表情", "通俗", "闭塞", "变革", "向...问罪", "未获情报", "上瘾", "悍然", "用诡计取得", "胖的", "搞什麽名堂", "阳奉阴违", "玩忽", "虚饰", "惭愧", "余剩", "耸人听闻的", "纷杂", "骇异", "艰苦", "半死", "酒醉", "发急", "老处女", "让你好看", "乞讨", "心情恶劣", "人穷志短", "不平等的", "为富不仁", "粗鄙", "被动性", "用力", "固执", "卑污", "引起反感", "丢三落四", "吹胡子瞪眼", "神经质", "轻佻的", "违规", "变复杂", "禁止", "心如刀绞", "一无所有", "处於不利", "打人喊救人", "无礼", "啷", "不熟悉", "武装", "警报器", "萧飒", "肆无忌惮", "惊惶失措", "用臭气赶出", "气急", "俱焚", "误导", "歹毒", "空腹的", "不为", "陷入", "古旧", "缝你嘴巴", "狡黠", "使惊惧", "被当", "竟敢", "急流", "图谋", "易被瞒", "腐化", "替..报仇", "无意识", "智障", "虚惊", "犯过错", "有罪", "无缘无故", "骚动", "使负重担", "悭吝", "心痛", "放荡的", "自作聪明", "未详细说明的", "一波三折", "急切地要求得到", "蹩脚的", "破坏性", "呵斥", "未被证明为正当的", "遗憾", "抛弃", "破口", "强压的", "微茫", "死猪头", "疣赘", "谴责", "无远见", "肃", "后悔", "你妈的", "中伤性", "死样子", "狡", "挨打", "匿名", "因循", "根绝", "催促", "毁灭", "劣等", "怒目", "腐化堕落", "没规矩的", "肆意", "恨的牙痒痒", "笑里藏刀", "易受", "宰杀", "胡诌", "难捉摸的", "毛骨悚然的", "违背", "紊", "忘记", "使极度痛苦", "悲剧", "被瞒", "宽假", "致死", "无事自扰", "乱七八糟", "毛", "悚", "睖睁", "卑鄙小人", "躲避", "鸟不拉机", "颤颤巍巍", "逼使", "复发", "听不清", "以貌取人", "无靠", "胆小的人", "噪音", "霸道", "过河拆桥", "短浅", "胡乱地涂", "鲁莽行为", "病弱", "挤得要命", "未定", "起纠纷", "破坏的", "说来话长", "心寒", "猛抛", "袖手旁观", "干恁娘", "独断", "闲荡", "窭", "无效率", "流浪人", "嫌恶", "凶巴巴", "困惑", "目光短浅", "过强", "下品", "费用大", "割断", "怒容的", "碾碎", "啪的一声甩", "碌碌无为", "鄙薄", "自吹", "被逐出的", "未归类", "心惊胆颤", "痴人说梦", "惊恐", "失去理性", "乌压压", "说", "垂头丧气的", "臭脸", "磨坏", "假货", "惊人的", "乌洞洞", "驳斥", "动肝火", "吃同类的动物", "面有难色", "骄人", "被干走", "短促", "搞钱", "混流氓", "坏心", "来火", "迷蒙蒙", "骚", "尖声", "猪头", "百无聊赖", "令人怀疑的", "满得溢出", "愧汗", "逮捕", "复合型", "家徒壁立", "击退的", "大悲", "依赖", "不耐烦的", "癃", "难相处", "窳劣", "不是滋味", "无常", "浮泛", "荒", "退役", "含怒", "吵吵闹闹的要求", "焦急", "恶劣", "逼走", "不可否认", "科以", "风凉", "鱼龙混杂", "膻", "怆", "使士气低落", "不守", "复仇", "愧疚", "感到难过的", "你是怎样啊", "婆婆妈妈", "超自然的", "撤销", "错误", "不好吃", "气死ㄌ", "免谈", "贫乏", "没教养", "使疼痛", "无资格的", "有恶意的", "引起震惊的事件", "恨极", "不顺利", "怒目注视", "狡兔三窟", "恶心的", "伪", "患..病的", "惨苦", "假惺惺", "轰鸣", "转移性", "困难的", "突然的", "破机八", "欠揍", "看不上", "悲惨", "古怪的", "惊呆的", "死不认帐", "失神", "支付利息", "有罪", "冷淡的", "坎坷", "聒噪", "孤儿", "伪造", "愁闷", "歪的", "难以捉摸的", "心情不稳", "有诡计", "突然止步不前", "灰溜溜", "没有教养", "胡言乱语", "孤立", "加重压於", "不可告人", "有资格", "拍打", "强烈", "赤裸裸淫秽", "凶横", "搞什麽玩意", "坚决主张", "恶名昭着", "冷峻", "嗟叹", "杌", "无能", "抱怨", "背悔", "泪下", "将心比心", "不悦耳的", "夸张", "恻隐", "後悔", "猖狂", "走散的人", "烫伤", "蚀坏的", "寡了叭叽", "迷濛", "呆傻", "告诉错误", "颟顸", "偏心", "感到抱歉", "惊爆", "发出刺耳的声音", "眼光短浅", "被动", "溅出", "加罪於", "哭得使..", "微尘", "破产者", "忽视", "跌价", "与世隔绝", "偏听偏信", "不称心地", "用皮带抽打", "困难重重", "表示忿恨", "荒弃", "不值钱的东西", "搞了再说", "不名誉", "无希望的", "猫哭老鼠", "淫秽", "对..索费", "煽风点火", "失调的", "未老先衰", "惊呼出来", "差别", "挤过去", "应名儿", "没事做", "久经", "落选", "蚩", "被泼水弄湿的", "易变的", "纷扰", "白搞", "黑漆漆", "低沉", "无地自容", "意意思思", "隐", "挖掘地基", "投降", "忧郁的", "死气", "我咧看", "与..争辩", "杂沓", "迷途", "想不到", "会传播的", "衍", "不安", "纠纷", "愧恨", "骇", "唐突", "沦为", "卡住", "荒谬", "暧昧", "卑猥", "语焉不详", "周恤", "亳不", "泥沙俱下", "暴", "宽恕", "冗长乏味的", "私心", "彻底的失败", "狂恣", "病殃殃", "不易", "破产了的", "错", "秘教", "短浅", "大发雷霆", "危害", "祸从天降", "变幻无常", "说反话的", "猥劣", "畏惧", "为..斗争", "勒索所得之款", "逆耳", "不法的", "心情浮动", "引起紧张", "杂交", "自命不凡", "惨绿", "文盲", "灭绝人性", "被扼杀", "多阴雨的", "倒楣的", "寂", "漫不经心", "使无资格", "喊叫声", "无变化的", "无特色", "屁话", "凶险", "怃", "错误地处理", "滞缓", "土匪", "狡猾", "贪婪的", "不履行", "觊觎", "没精打采", "荒诞派", "可厌恶的", "面黄肌瘦", "僵痛", "屈理", "挂心", "死爱面子", "独裁者", "叫苦", "缺少", "造反的", "挫折", "无耻", "沮丧", "与..作战", "忧惧", "孬种", "令人厌恶", "搞阶级斗争", "倾覆", "凄怨", "鬼玩意", "闹哄哄", "空话", "该罚下地狱", "你去死", "伧", "挂牵", "障碍", "横加", "松垮垮", "死的", "使变得无耻", "黑咕隆咚", "光火", "责", "喷溅", "无法计数", "崎", "交战国的", "藐视", "尚武", "对抗", "火大", "剥落", "腐烂", "焦痕", "夸大的", "骗吃混喝", "走油", "负心", "无意义", "褶", "单", "孱", "木然", "使受电击", "挂一漏万", "专权", "使人不高兴", "不堪入目", "不直截了当", "黝", "让渡", "憔悴的", "学识谫陋", "刻板", "动乱", "下作", "疑惑", "喊叫", "乱想", "怒火冲天", "调皮", "翻找", "被沾污", "无厌", "吹捧", "妄为", "引起死亡", "冒牌货", "隐讳", "窘迫", "指责", "玩世不恭", "如鲠在喉", "无关", "一哭二闹三上吊", "悲怆", "恐怖症", "撕破", "坏处", "铺张浪费", "使局限於狭小空间", "小手小脚", "自大", "模糊不清", "不详尽", "唉呀", "功利主义者", "油腻", "急促", "装屎", "碌", "损失惨重的", "烦琐", "黯淡", "绷紧的", "好屌", "可怕", "令人齿冷", "装腔", "不正派", "粗心", "猥亵", "爆炸性", "屌屁", "朝..反冲", "罪过", "作贼", "苛刻", "羡慕", "沈没", "批", "动作迟顿", "碰运气的", "痛", "感到遗憾的", "贫瘠", "逃避职责", "癌症", "动火", "拘束", "吐痰", "小捣蛋", "不和谐", "奢华", "挑逗性", "银根紧的", "严格", "薄情", "恶质", "使离乡背井", "未加", "骂得狗血淋头", "起风暴", "隔绝", "生硬", "低声含糊", "不对付", "费用浩大的", "没头脑", "伤感情", "勃然大怒", "忧闷", "不清洁", "鞭打", "撞死", "狂傲", "艰辛", "极小", "质疑", "郁", "哩哩罗罗", "自闭", "训斥", "最恨", "分赃", "跅驰", "淫邪", "不能想像的", "未开化", "闷住", "煽动", "使失去感觉", "令人恐惧的", "无决断力", "纵情", "憎恶", "乾枯", "基础薄弱", "杂碎", "故障", "嘲弄的物件", "轰动", "勒索", "含糊话", "不友善地", "挤满", "愚蒙", "遍寻", "心虚的", "恶事", "搞迷信", "不幸", "悲哀地说", "缺席的", "游荡的", "不规则", "自慰", "粗蛮", "气不忿", "抹去", "腐蚀的", "无意义的事", "烦冗", "暮色苍茫", "秘教的", "骂出", "变幻", "倚老卖老", "非自愿", "绞死", "自豪", "冒险", "支离破碎", "不法", "有碍观瞻", "无伴", "陈旧", "失节", "教训", "心里堵得慌", "逼近", "欺骗", "骄纵", "问心有愧", "困难", "迷离", "败退", "处刑", "错过", "真他ㄇㄉ", "破门", "臭骂", "反驳", "存心", "悲凉", "偏颇", "拘泥", "使一蹶不振", "忘恩", "使人痛苦", "费力地做", "不快乐", "悔之无及", "漠不关心的", "损伤", "乱腾", "浮皮蹭痒", "折旧", "不纯洁的", "干瘪", "黪", "困人", "四散", "使渗漏", "叫骂", "袭击", "斥", "疼痛", "更坏地", "减低", "浪荡", "变阴沈", "误", "率然", "仇敌", "不光明", "查禁", "整垮", "睁一眼闭一眼", "不出", "慌乱", "东西", "绝", "使糊涂", "有顾忌的", "孤独", "狼籍", "蒙蔽", "之仇", "淫荡样", "跌眼镜", "令人失望", "非常饥饿", "唱衰", "质疑", "缺德", "不赚钱", "赤裸裸", "烦恼", "阴阳怪气", "毒杀", "头痛", "逃生", "倨", "有..倾向的", "竦", "在乎", "怆然", "刀割", "与..匹敌", "忘恩负义", "尖刻的", "惋惜", "三流", "算你厉害", "刁悍", "板面孔", "酷虐", "嗜血", "无望", "暗中", "失序", "犯贱", "疑心病", "天杀的", "心有馀悸", "乱真", "翘尾巴", "捏一把汗", "含糊", "敲打", "使有成见", "干醮", "顽", "装窃听器", "唐突", "气头上", "散漫", "使含糊", "担忧", "暧昧", "漠然", "快枯竭的", "太过自信", "从事伪造活动", "令人窒息的浓烟", "渺", "拖紧", "愚蠢", "乏味", "无证据", "酥松", "死鱼脸", "烦", "随风使舵", "没什么了不得", "臭蚊子", "失掉", "烈", "品行不端", "目瞪口呆", "求求", "胆小怕事", "胡子拉茬", "破烂不堪", "违拗", "暴露", "不可读", "疯狂般", "疾言厉色", "零零散散", "禁止的", "背离", "甩得", "逃之夭夭", "黑森森", "欠周到", "惴惴", "鸣冤叫屈", "找岔子", "不值钱的", "可疑分子", "睁大", "不可逆转", "使凹下", "难驯服", "无益", "勘漏", "荒无人烟", "冒犯", "冷笑", "摸弄", "歹徒", "空虚", "行为不良", "不顾後果", "失笑", "闹法庭", "憾", "臭美", "放任", "反托拉斯的", "无帮助", "颇有微词", "阴毒", "不参加", "懊恨", "码的", "臭名昭著", "孤陋寡闻", "突袭", "曲解", "一脸横肉", "喧哗", "破麻", "竟然", "死光光", "臭虫", "漏洞", "机械式", "面目狰狞", "浪费时间", "混血", "粗手笨脚", "冷眼", "怔忪", "同情", "魂飞魄散", "一贫如洗", "糟心", "兔死狐悲", "失误", "妒忌", "忿忿", "害虫", "闷闷不乐", "脚踢", "恚", "闷郁", "已过盛年", "不合标准", "呜咽地说", "下半身思考", "丑陋", "自诩", "共谋", "恶贯满盈", "负荷", "背人", "应该谴责", "不高兴的", "凹种", "责备", "生活放荡", "幽黯", "不明了的", "形格势禁", "愚钝", "薄情的", "不确信", "器焰嚣张", "狡辩", "病根", "找碴儿", "不重要", "心神不定", "磨损", "淡薄", "使无能为力", "使不能", "对..提出异议", "从严", "萎缩", "花痴", "狂乱的", "受害的", "割裂", "可怕的", "傻头傻脑", "死澳门仔", "矜", "无效能", "不平衡", "心力交疲", "不明了", "使变空", "一肚子坏水", "翻云覆雨", "表示忿恨的", "凄恻", "极愚蠢", "设伏地点", "无可奈何", "障碍船具", "不才", "重负", "臭功夫", "不关紧要之事", "凌乱", "患者", "吃同类", "急拉", "废物", "无济于事", "奸伪", "大话", "争执", "传染病", "凹下", "好不", "硬逼", "困穷", "发烧", "忸怩", "狭隘", "滞销", "半途而废", "悲天悯人", "难事", "不知羞耻", "宽贷", "数落", "成零", "轻淡", "去去去", "怯然", "心不甘情不愿", "诎", "严酷的考验", "不合宜", "使狂热", "使对立", "流出", "蜕化变质", "不均匀的", "负的", "叛徒", "非礼", "可怖", "撕裂处", "入迷的人", "颓丧", "委屈", "如野兽般", "难以取悦", "杀人如麻", "竹篮打水", "什", "以偏概全", "使人反感的", "没能力", "被泼水弄湿", "讶然", "心疼", "弇陋", "一点点", "哑的", "连累", "闹得不可开交", "上当", "避免直接答覆", "浑浊", "缺心眼", "不均匀", "有病的", "不问三七二十一", "阴暗", "偷", "顾虑", "责怪", "喀嚓", "发爆震声", "迂回的", "亵", "加剧", "可恨", "粗劣", "蔓延", "无慈悲心", "悔之晚矣", "嫌贫", "骂髒话", "敌视", "獠", "破旧的", "邋遢的", "不定", "搞鬼", "缭乱", "不以为然", "烦乱的", "落後的", "隐秘", "惶惧", "没理", "呜咽着说", "受诅咒的", "变空", "浇薄", "一仍旧贯", "笨手笨脚地做", "不易了解", "互吵", "阴沈的", "外行", "黯淡的", "软绵绵", "怒斥", "笑柄", "心惊胆战", "脾气坏的", "愁眉苦脸", "意义不明确的", "有害的动物", "虚伪", "一脚踹开", "世代结仇", "低迷", "费神", "垂下", "全无的", "艰巨的", "彷", "伤风败俗", "不值钱", "食而不化", "真烂", "昂贵", "臭不可闻", "愧赧", "叫嚣", "切断", "不纯", "孤孤单单", "嫌恶的", "侵犯的", "最坏", "欺侮", "暴雨", "太过", "损伤痕", "下等", "弄坏", "拎背", "不友善的", "被击中", "作犯规动作", "忽略", "暴躁", "功利论者", "使疾走", "隐忧", "塞到", "危及", "含糊", "搞政治", "唯我独尊", "谢绝", "八面玲珑", "认死理", "不良的", "悲痛", "含糊其词", "使失去光泽", "好战的", "交战", "紧张不安", "灾难", "左右为难", "半路出家", "宁愿", "惧", "矫情", "未知", "叛逆的", "变幻莫测", "沈重的脚步声", "困扰", "滑稽剧", "赌掉", "未完成的", "人身攻击", "闹大", "垂怜", "谬论", "矍", "不重视", "有差异", "屁啦", "懒得", "相异", "霸气", "动荡", "无的放矢", "小家伙", "酸臭", "沈闷", "丧志", "招致", "漏损量", "不能容忍的", "啰啰唆唆", "违反教规", "踌躇", "增恶", "不清楚的", "迟疑不决", "不对茬儿", "圆滑", "目光短浅的", "成为零", "不牢固的", "使不得", "生活艰苦", "贮藏货物", "害人", "践踏", "变得阴沈", "没手没脚", "复杂的事物", "形容枯槁的", "派不是", "洪水", "急巴巴", "拉杂", "自命清高", "没法子", "臭老头", "虚弱", "欺压", "打屁股", "辛", "困难", "贬斥", "震惊", "骂出来", "对..施暴", "闷热的", "僵", "吹牛", "疑有", "诽谤性", "饿得", "不易弯曲的", "使放纵", "蒙冤", "衰落", "口诛笔伐", "格外的", "落伍的士兵", "利己", "漏出", "狗杂碎", "言之无物", "惛", "怠慢", "推托", "诱捕野兽", "何必", "庇护", "废弛", "禁忌的", "猖狂", "劣马", "痛斥", "易怒的", "憋得慌", "瞽", "流泪", "杀人不见血", "无道德观念", "酸腐的", "犷", "生锈", "骄慢", "没关系", "失去..的", "易坏", "无法投递的邮件", "享乐", "奶声奶气", "凶险", "蹿火", "随口泄漏", "败家子", "缺乏兴趣", "溃疡", "胡搞", "贪婪地吃", "患精神病", "晦涩", "漫不经意", "使人厌恶", "提心吊胆", "死了", "贪婪地注视", "烦扰", "逆", "疯子", "拉长个脸", "随便的", "撤回", "何苦", "使散落", "怯阵", "外伤用", "老二", "吸毒", "违反的", "贪得无厌的", "不肯越过障碍物", "落伍", "伪善", "有危险", "啰唆", "破", "下地狱", "伤感情的", "误导的", "寒苦", "无深虑的", "怒形于色", "倒楣", "臭哄哄", "不能压制的", "烦躁", "老子", "未经", "糟透了的", "旧", "怠惰", "疤痕", "可惜", "丑恶的", "暴风", "大跌眼镜", "抓伤", "败家女", "种族隔离", "微贱", "目不识丁", "情节剧似", "费功夫", "倾销商品", "匪谍", "骇怕", "令人厌恶", "紊乱", "噲", "敌对", "絮叨", "唐突的", "极不协调", "使蒙受耻辱", "肋脦", "行窃", "气", "停滞", "剥削", "最低", "一张臭脸", "暗杀者", "芭乐问题", "不合理", "不整齐的", "筋疲", "亮红灯", "心地狭窄", "鄙视", "欠缺", "塞满", "不能", "调戏", "错愕", "干恁", "完了", "有缺陷", "胡言", "窝火", "塞拎娘", "肆", "忧悒", "无光", "傲慢无礼的行为", "不受尊重", "以牙还牙", "混蛋", "窝心", "扎手", "虫子", "特困", "怠惰地", "不择手段", "幼稚的", "阴沈", "拒绝..", "窈冥", "拍马屁", "不能矫正", "蛮不讲理", "好不应该", "不羁", "动魄惊心", "瞠然", "降低..的品格", "病弱", "不像", "诱骗", "藐小", "卑下", "恣肆", "不适当的", "过时", "漫", "威慑力量", "动不动就发脾气", "不合群", "看轻", "消沈", "下毒手", "自私", "狼吞虎咽", "心胸狭隘", "不打紧", "发怔", "险恶", "说谎者", "丧心病狂", "扭歪", "未减轻", "粉碎", "不周", "丢脸的人", "迫使", "不坚固", "承受", "贼眉鼠眼", "乱嘈嘈", "蓬头垢面", "有一搭没一搭", "难听", "人声嘈杂", "惹到", "对..沈下脸", "救命", "危险", "烦燥", "训斥", "承受不住的", "巧黠", "偏执", "豺狼当道", "无力", "无怜悯心", "不可避免的", "诋毁", "嘈杂的谈笑声", "朦", "横渡", "缩减", "砍掉", "恶梦", "搞什麽飞机", "啪地一声放下", "鄙视", "放肆", "阴间", "顾念", "昏天黑地", "离开正道的", "幽暗", "难上加难", "辐射", "利欲熏心", "不平", "使丢脸", "愚痴", "漏损物", "好战", "暴力", "下三烂", "不留神", "使陷危", "吸毒者", "屈从", "世情冷暖", "系", "从事小争论", "蔑视", "装模做样", "有瑕疵的", "赛林良", "麻木", "无效", "醉汉", "怨天尤人", "看淡", "丑死了", "宣告非法", "烂污货", "悲悯", "冲口说出", "逼供", "放纵", "贫困", "忍心", "没辄", "人事不省", "高成本", "非婚生子", "琐细", "德行", "钝的", "未完全发展", "懦", "实属不易", "冷冷清清", "疯狂地", "咬住", "骈枝", "灰秃秃", "厌气", "争论的", "不能征服", "不分青红皂白", "搞阴谋", "消耗", "惋惜", "倥侗", "放屁", "一掴", "使失事", "砍伤", "勉强", "颓然", "胡乱", "阴险人", "八股", "一团糟", "极残忍", "雾朦胧", "恶狠狠", "生怕", "世俗的", "自弃", "哇靠", "两难", "价值不高", "责难", "轻", "晕眩", "仇外情节", "不精确", "污染", "硗瘠", "急躁", "碰壁", "出错", "滥葬", "带衰", "没去理会", "令人无法忍受的", "索然乏味", "玩弄", "粗犷", "烦神", "没到", "不透气", "可怕", "泪动", "讨好", "处..以罚金", "不得劲", "恐怖", "什锦", "恶言相向", "昏乱", "背光", "拍案而起", "惨痛", "狂妄自大", "仿造", "繁芜", "失去知觉", "致命", "冰冷", "心胸狭隘", "掠夺", "混战场", "侵犯", "机变", "白搭", "凄惨", "动摇", "惨厉", "未列计划", "你他妈的", "不择", "做人情", "大言不惭", "不舒服的", "老谋深算", "扰乱", "有困难的", "争吵", "不值", "生病", "泄劲", "白痴般", "不明智", "卑贱", "做作", "自高自大", "恝置", "凶巴巴", "悲哀", "传染性", "迷迷怔怔", "无可争辩", "鸡犬不留", "敌军", "惆怅", "无度", "不便的", "自封", "无子", "不可预知的", "恣意的", "愚人", "软", "打断", "使暴露", "马的逼", "猛地", "长期不和", "羸弱", "严寒的", "哈喇", "贱招", "讶然", "申述", "无助的状态", "见怪", "抑制的", "毫无办法的", "姑息", "好斗", "不确实的", "野蛮的", "诱入", "缠绕", "打骂", "衰退", "老死", "为..哀痛", "长的丑并不是你的错", "不甘心", "愦", "瞻前顾后", "冤孽", "凭什麽", "死心眼儿", "轻率", "该责备的", "拿腔拿调", "天下大乱", "肤泛", "男盗女娼", "不善交谈", "更恶劣的事", "评头论足", "发出砰然声", "谬误的", "衰败", "无把握的事", "扁你", "砍击", "别别扭扭", "俗辣", "不到黄河心不死", "混合", "讨厌的人或东西", "坏情", "使存偏见", "没把握", "末日", "使失望", "皮里阳秋", "恶狠很", "高不成低不就", "腐蚀物", "死爱滋", "皱巴巴", "气不过", "预示..的凶兆", "不适宜", "险要", "碌碌", "残杀", "悒闷", "动荡的局面", "黑暗的", "琐细", "反感", "人身攻击", "冗杂", "抽搐", "发愁的人", "加障碍於", "拒给", "滥", "失落", "马屁话", "被迷住", "未加抑制的", "疑虑", "动荡不安", "走失的家畜", "看你娘卡好", "不能的", "举反证", "低能", "原始", "该罚", "怪胎", "宣告无效", "恼恨", "愚", "重击声", "难民", "变色", "悚然", "坏脾气", "不断骚扰", "干你老师", "不死心", "水雷", "不愿意", "束手无策", "险境", "可骇", "破旧", "穷凶极恶", "柔肠百结", "忡", "迟到的", "把你打死", "发酒疯", "含糊的", "愤愤然", "开小差", "形影相吊", "给...当头棒喝", "介意", "野性", "蹂躏", "怎样", "讨", "发呆", "灭绝的", "王八羔子", "荒野的", "混交", "觖", "破裂处", "欺凌", "欲坠", "宽免", "怏", "干政", "贫困的", "多刺的", "攻占", "假意", "呕吐", "擦伤", "未解决的", "使困惑", "疑心", "暗地里破坏", "傻乎乎", "破坏", "迫切需要", "拥挤", "真是烂", "侵略国", "把..分隔开", "搞乱", "可容忍的", "不尽", "恶性", "强词夺理", "凄婉", "刺激物", "错综", "一窝蜂", "勒赎", "使孤寂", "凶狠", "弊病", "倜然", "有出息", "气愤地说粗话", "唾弃", "铁公鸡一毛不拔", "厌", "干的好事", "丢弃", "非婚生", "冷嘲热讽", "危殆", "忧郁", "心碎", "不能信赖", "勉强的", "不可恢复", "哀戚", "难上难", "诘", "病人的", "使发烧", "徵收报复性关税", "不平均", "腐朽", "不足的", "大叫", "扬长", "指摘", "逼上梁山", "假面目", "盘陁", "逐渐消耗", "蓬乱", "欠打", "溲", "土俗", "凶煞", "无礼的", "阴险", "不安稳", "无能力者", "我恨你", "逃跑", "可忍受", "假", "万难", "馀", "浮渣", "乖谬", "猥琐", "使短路", "浅薄的", "代罪羔羊", "受阻止", "杂乱", "猥亵", "奸情", "味道不好", "憷头", "不人道", "劳神", "性情急躁", "不留心", "悲观地", "令人失望的人", "深仇大恨", "无效果", "不宽容", "渗透活动", "无根据", "奴役", "笨拙", "世仇", "心如铁石", "恶心", "委屈", "遭殃", "讽刺", "男盗女娼", "不确", "无趣的", "不屑做", "伪君子", "闹闹嚷嚷", "悲惨的", "远离", "乱窜", "摆脱了", "魔怔", "命苦", "危急的", "无争论之馀地", "发牢骚", "贪吃", "光怪陆离", "亏心", "吵到", "抵制", "枯寂", "砍得很深的伤口", "窃听", "不发达", "代价", "断魂", "不合格的", "迫不得已", "蛮横的", "畏怯", "肤皮潦草", "残疾的", "慢吞吞地行进", "恸", "不信任的", "苛察", "斑块", "痉挛", "作怪", "功利的", "不见", "糟糕", "骇愕", "迷迷蒙蒙", "怜恤", "倾卸", "屠场", "烦躁", "悲惨", "不妙", "漠不关心", "劈开的", "着火", "交恶运的", "狂骂", "家务杂事", "批发", "昏头昏脑", "使碎裂", "吵闹", "纷", "去世", "巽", "愤世嫉俗的", "叫屁", "不起眼儿", "颠覆", "卑鄙", "絮烦", "沈重的", "坏心肠", "违约", "金刚努目", "荒漠", "胖子", "愤恨", "隐秘的", "暗淡", "没意思", "赋闲无事", "成事不足，败事有余", "恐布", "搞小圈圈", "令人作呕", "焦愁", "刻舟求剑", "打人", "使紧张", "愠怒的", "诱拐走", "凹凸", "纠缠不休", "不确定", "令人讨厌的人", "陷於", "无关重要", "愧怍", "心眼坏", "僄", "使分离", "雷霹", "闹僵", "迷蒙", "不能解决问题", "不可补救", "辛酸", "打一打", "偏心的", "死鱼", "敢冒", "傻的", "使变得低劣", "埋葬", "阴险毒辣", "神经的", "说不", "猥", "使烦恼", "倒下", "发劈啪声", "毒辣", "等闲视之", "缛", "冷冰冰", "火头上", "不公正", "不当", "愤懑", "诟", "对手", "万念俱灰", "疏远", "不成功", "圆", "穷奢极欲", "敢骗我", "鸣不平", "荒淫无耻", "色情", "大叫大嚷着要求", "灿怒嚣憎", "怪物", "现实的", "肘掖生变", "必死", "限止", "茫茫", "恐", "使反感", "使疲劳", "索然寡味", "费心", "蠢举", "执拗", "使产生纹裂", "悲愤", "草菅", "不谨慎", "淘神", "不择手段", "走开", "屁股", "厉", "草率", "下狱", "不可讳言", "道貌岸然", "朦朦胧胧", "糊涂", "没良心", "不健康的", "僵持状态", "傒倖", "骂人", "损", "在..留下疤痕", "扭斗", "生疏", "阻隔", "烂", "艰危", "毫无办法", "异", "老马", "训戒", "漠不关心", "棘手的", "骞", "向下倾斜", "低於他人者", "哀凄", "没用的家伙", "苦痛", "火冒三丈", "大便", "诡不诡异", "毒药", "神气十足", "改变不了", "羞惭", "凋谢的", "胆战心惊", "冷若冰霜", "拒绝..的要求", "不得体", "陌生的", "无家可归", "刺痛的", "娇痴", "非正式的", "愁思", "假心假意", "长篇累牍", "怀疑宗教教条", "挥猛烈冲打", "无德", "极苦闷", "难办", "爆炸", "无准备的", "如死一般地", "土得掉渣", "斑驳", "大而化之", "不友好", "谋略", "气狠狠", "优柔", "气盛", "真蠢", "不正直", "萧", "受感情驱使的", "水泄不通", "伪善", "囊中羞涩", "寄生虫", "丧心", "大惊失色", "恶势力", "回绝", "善变", "指控", "严厉", "吃后悔药", "去死啦", "密谋", "不经济", "声讨", "过激", "遗失者", "盛气凌人", "行为不检", "寂寞的", "无实质", "挖苦", "弱势", "黯淡", "令人头痛之事", "震惊", "小鼻子", "严峻", "悒郁寡欢", "受挫折", "小器", "无味", "大惊", "掉泪", "非真正的", "鄙弃", "不信实", "找麻烦", "隐瞒", "行骗", "宽宥", "奸佞", "不大重要", "抠门儿", "杂乱", "劣等", "责骂不休", "坏人", "压破", "自相矛盾", "不法", "懒趴", "啥玩意", "寒碜", "使受到伤害", "淫污", "猪八戒", "陷於困境", "唾骂", "伤人感情的", "昏晕", "抵触", "过分单纯化的", "说含沙射影", "破衣服", "搞糟", "反常", "拙劣", "悲伤", "破铜烂铁", "乱叫", "漂泊", "可惊", "自我本位的", "使枯萎", "混战", "幺麽", "犯错", "散漫", "不宜", "忍住", "士气低落", "一团乱麻", "怒骂", "沈下", "苍凉", "现世", "恼羞成怒", "乖僻", "愤懑", "不可收拾", "累牍连篇", "乱骂", "安慰安慰", "冗长", "絮聒", "猥陋", "离我远一点", "驳回", "啰啰嗦嗦", "愁惨", "滥用职权", "快枯竭", "摸不清", "秃", "易受骗", "囚首垢面", "与..扭打", "独裁的", "悄悄", "使隐退", "意外", "屁事", "未便", "引咎自责", "权宜的", "遮暗", "作低沈声", "无关痛痒", "看不见", "亳不留情的", "含悲", "哭妈", "高不成低不就", "突如其来的", "不修边幅", "猴", "冷然", "搞台独", "叛乱", "擅离", "废话", "娄", "荒唐", "摸不准", "以饵引诱", "大惊失色", "哭丧着脸", "浮", "穷凶", "操你母", "舛", "拖欠", "笨", "情急拼命的", "煞车", "暴行", "老是", "东倒西歪", "浅尝辄止", "欲望", "无形", "轻易", "大而无当", "乖僻", "无法忍受", "进攻", "失盲", "疙疙瘩瘩", "未经通知", "邪神", "单调的", "沈下脸", "猛闯", "忸忸怩怩", "堵心", "膻气", "正式脱离或退出", "死气沉沉", "讆", "乱骂人", "难点", "一气", "叹息", "死了算了", "不顾", "缭乱", "发出尖锐", "自私", "悲观主义", "假冒", "自怜", "酸刻", "气乎乎", "侵略", "枯燥", "颠倒是非", "恐吓", "心焦", "阴恶", "头晕", "诡计", "绕脖子", "俗丽的", "书生气", "赝", "暴乱", "叱责", "心虚", "援交", "黑灯瞎火", "纤弱", "傻瓜", "不贞洁", "犯有罪行", "挑毛病", "暗地", "狯", "消极", "奸险", "加负担於", "怵然", "骨鲠在喉", "背信弃义的", "冷销", "黠慧", "浮躁", "有意", "破坏性的", "暗昧", "臊", "低卑", "放狗", "不道德", "低等", "鸡八", "枯燥乏味", "猪狗不如", "有碍", "心烦", "崎岖", "大面额", "贫乏的", "伤口", "晃悠悠", "啬", "哀痛", "不分皂白", "是我的错吗", "踩踏", "反复无常", "裂口", "魔鬼的", "愍", "海洛因", "没有考虑的", "偷骂", "中断", "噍", "不对头", "幽忧", "战兢兢", "挣扎", "私通", "颠簸", "变暗淡", "孤零零", "孤寂", "不经意说出", "为难", "愁眉苦脸", "心机", "疲累", "闹剧", "不端", "中伤性的", "打入冷宫", "慌恐", "有缺点", "对立的", "溺死", "衰老的", "抄你爸", "变幻无常的", "甩不掉", "腐蚀剂", "迷信的", "矮小的人", "懒人", "乳臭未干", "死色呸", "狂热", "价格高昂", "发泄", "怏然不悦", "不宜的", "打架", "丑丑的", "胡思", "借古讽今", "惊愕", "惧怕", "皮毛", "可怜", "难耐的", "紧张", "发出嘈杂声", "易坏的", "憎恨之物", "顽劣", "荒寂", "不过意", "犹豫的", "愚蠢的人", "敢喵", "不坦率的", "一文不值", "不同意", "慌张", "严重", "过份", "报怨", "气忿", "被侵蚀", "供给..过强的力量", "孛", "窝囊", "怨恨的", "废旧", "恶棍", "连屁都不如", "始作俑者", "烧伤", "亡命", "有矛盾情绪的", "表示谢绝的短柬", "高压政治", "行为不端", "抱憾", "煞风景", "素昧平生", "唉声叹气", "气冲冲", "颤颤悠悠", "刺激", "乞得", "横行", "疲乏", "阔绰", "完全不重要", "惊叹", "疏松", "短暂的", "使心智衰弱", "不得当", "使受伤", "加油门快速前进", "见异思迁", "狞恶", "欠完善", "用沸水烫", "不得力的", "不合理", "愧悔", "过敏", "呆呆", "窃", "低端", "人头攒动", "神神秘秘", "不高兴", "反覆无常", "感到可怜", "极小的空间", "冲出", "沈默不语", "没精打彩", "违抗", "横肉", "大大咧咧", "阴险的", "顿足捶胸", "动怒", "军阀", "不稳固", "水性杨花的女人", "阔气", "没受教育", "可怜的人", "愀然", "清寒", "承受不住", "目中无人", "对..徵税", "背阴", "精力枯竭", "占领", "藉口", "一场空", "不高", "怄", "病病歪歪", "老气", "嶙嶙", "戏弄", "没觉察到的", "警报", "消失", "被逐出", "无关重要的", "讨人厌", "独裁者的", "行刺", "怯弱", "不新鲜的", "冲压机", "不劳", "干巴", "死活", "你他妈", "一无可取", "死家伙", "悒悒不乐", "依赖他人者", "没见过世面", "束缚物", "懒散地", "落泪", "愤怒", "愚钝的", "优柔寡断的", "固执己见", "绷", "不和的", "喜怒无常", "爱管闲事", "自咎", "沉溺", "无价值", "不能压制", "超过", "向上倾斜", "蒙受", "令人怀疑", "使人不愉快的", "瘦", "失落", "褊", "诡诈", "斯文扫地", "可作两种解释", "看不见的", "气急败坏", "怒", "惶遽", "自认为", "闹嚷嚷", "奢华", "围殴", "有顾忌", "事故", "想不开", "无力的", "辩驳", "死死", "口是心非", "一言堂", "掩蔽", "变幻无常", "沉默", "难吃", "否定", "迂回", "使疏远", "谩", "疲倦", "学识浅薄", "颠倒", "过少", "拖着行进", "老娘", "欠骂", "感伤", "隐约", "潜行", "有气", "烤焦", "单弱", "乱撕", "穷乏", "被压坏", "败絮", "不友善", "有害", "失慎", "刺痛", "陈腐的", "可有可无", "让你死", "违犯", "低声地", "哎呀", "干傻事", "心狠", "揭穿", "使羞愧", "鬼计多端", "模糊的", "打入", "不诚实", "板着面孔", "胡乱", "闪人", "堕落", "无可奈何状态", "不稂不莠", "愤世嫉俗", "批评为", "贱女人", "你完了", "破掉", "怔怔", "不稳定的", "腥", "颓废派艺术家", "坚持己见的", "形同虚设", "扭曲", "刺打", "使落空", "贫苦", "围住", "误人", "半信半疑", "受难者", "吹嘘", "头壳坏掉", "悬念", "作孽", "群魔乱舞", "强使", "说蠢话", "抹不开", "弄混", "暗指", "丢脸的", "昏暗", "瞎了眼", "存心的", "前後矛盾", "叫化子", "孤寂", "应斥责", "古板", "皱纹", "严肃", "崒", "蒙蒙胧胧", "虚设", "嚣张", "沾染", "可怕的事", "必死无疑", "色狼", "除掉", "蛀牙", "眼生", "暴虐的", "噘嘴", "无常的", "不良", "涵容", "岸然", "给我注意一点", "贝哥哥", "贪污", "酸溜溜", "恶名昭张", "愧", "讽刺的", "不平整", "凶暴", "结结巴巴", "阿谀", "辩论", "嫌弃", "走私", "不加", "恶臭的", "使忧郁", "淹没", "莫名", "羞怯", "幕后", "矫情造作", "名不副实", "刺棒", "被俘的", "臭青蛙", "懦弱", "掊击", "傲慢", "膻腥", "厌恶的", "可恶", "损耗", "不合意的", "恶果", "凄切", "松散散", "欺诈", "急切", "脾气暴", "限制因素", "凶恶", "难以明了的", "长期争斗", "斗臭", "局限於狭小空间", "可争论", "毫无意义", "虎踞龙蟠", "没得", "死记", "漠然视之", "凋萎", "犯急", "蹰", "妄", "悲切", "莫明奇妙", "惶恐", "魔鬼", "废弃", "被腐蚀", "损人利己", "不活泼的", "无知识", "赶出", "不能解决的", "未遂", "骗人", "亡命者", "有缺点的", "不能医治的", "无法挽回", "拍拍屁股找不着人", "抖颤", "痴愣", "刚愎自用", "阴谋", "佻", "粗俗", "刮走", "变成废墟", "不妊的", "杀千刀", "烂到爆", "无限制", "暴烈", "拥挤不堪", "大小便", "寡言", "马的", "砰然声", "血腥的", "饥馑", "勾心斗角", "竭蹶", "呆住", "自夸说", "变软弱", "宣告有罪", "邋遢女人", "怕生", "赤字", "火", "困迫", "使成废墟", "旁徨", "炸", "你以为你是谁", "鼻酸", "三心二意", "困穷的", "地位低下", "小时了了", "怔", "蓄意", "更呕", "蹩脚", "清贫", "令人毛骨悚然", "强迫", "其反", "落空", "松松垮垮", "搜捕", "黄色", "乱杀", "弄污", "复杂", "劣质", "菜鸟", "捏把汗", "不足为外人道", "松垮", "烦死了", "大胖子", "异乎寻常", "不名一文", "委靡", "死得很难看", "冷眼旁观", "休止", "严厉", "被弄死", "撕碎", "臭德性", "可悲的", "呕气", "奢华的", "行为不良的人", "困乏", "更贱", "这麽烂", "不成话", "繁乱", "超自然", "惊天动地", "背地里", "救我", "痴呆呆", "密不透风", "豺狼成性", "不合群的动物", "未成熟的", "令人悲痛", "中邪", "惊异", "惶惶然", "不活泼", "耸人听闻", "迷漫", "开除", "烦恼", "轻薄", "不受欢迎", "喀嚓喀嚓行进", "利用我们", "根本就", "悖谬", "闪边", "羞人答答", "一再叮嘱", "拒绝承兑", "颛", "未获情报的", "不公", "怀敌意的", "唾沫", "浅陋", "呆怔", "觖望", "打着哈欠说", "迫不及待", "腐烂", "射击", "苦苦", "一个屁", "使倾侧", "畸形的人", "叫喊着说", "使悲伤", "坏运气", "诡异", "小偷", "岌岌不可终日", "硬挤", "惰", "挂", "自求多福", "冥", "不定的", "矮小", "我靠", "搞屁啊", "乱虐并生", "背后", "伪善者", "欠扁", "臭酸", "不可信的事物", "游街示众", "迷路者", "使载重", "倾轧", "禁锢", "降低..的地位", "谋反者", "杂事", "违章", "打颤", "对健康有害的", "用尖锐的声音说", "审判", "殴打", "疑虑重重", "撞击", "比肩接踵", "恟", "矛盾", "嘀里嘟噜", "厚脸皮的", "掊", "次", "没能", "不慎", "薄", "倒闭", "难说话", "疑神疑鬼", "俚", "混", "悻悻", "堵塞", "特权", "破旧", "躲藏", "啪嗒", "道歉", "慵懒", "轻信", "惊险动作", "老实", "放荡不羁", "阻碍物", "恐怖手段", "无依无靠的", "侵犯人身", "奢侈的", "有屁用", "使处於不利", "可悲", "顽固的", "畏缩的", "羡余", "灭绝", "异形", "变态", "臭味", "无人遵守", "触目惊心", "羞于", "骇惧", "胸无点墨", "艰深", "凶毒", "夸张的手法", "恶意", "油腻腻", "劳役", "手紧", "杂七杂八", "破布条", "生疏", "潜", "乱烘烘", "高不成，低不就", "自食恶果", "打退堂鼓", "匆匆忙忙的", "了不得", "颓废", "复杂化", "清寒", "懈怠", "逐出", "使沈溺", "庸俗的", "老大难", "徘徊", "碰撞", "吃重", "逼迫", "敏感的", "不安宁的", "大海捞针", "急于", "乱哄哄地跑", "骚扰", "忿恨", "不佳", "总行了吧", "紧迫地", "蠢笨", "杂讯", "内情", "不光彩", "胆小如鼠", "弄错", "莫须有", "不可", "喜夸耀的", "删去", "他马的", "艰苦", "腥臭", "诡辩", "失明", "荒僻", "未被通知的", "哈巴狗", "不体面", "找茬儿", "缠手", "用话刺痛", "丢丑", "苦的东西", "疏忽", "造谣中伤", "无深虑", "抠搜", "不喜欢", "心眼坏的", "不习惯的", "催吐", "看不过去", "鄙俗", "烧焦", "赶尽杀绝", "峭", "哭泣", "生活艰苦的", "过分", "压倒", "眼巴巴", "颛蒙", "不堪设想", "不知不觉的", "篡夺", "纳罕", "软弱", "歼灭", "搞得", "出气", "高压", "马屁", "狠心", "无语问苍天", "屌啥", "叛国", "懒惰鬼", "溢价", "萧条", "诅咒", "使混乱", "操你个鬼", "臭气熏天", "否", "伤害的", "没心眼儿", "瞎的", "脆的", "轧轧地作响", "丑不拉叽", "沈迷", "搞性", "窃贼", "复杂多变", "不容", "诽谤性的", "容易受惊", "过不去", "女巫", "贱货", "因魂不散", "响而刺耳的", "怵", "作惊人表演", "骄矜", "分裂的", "该死的", "伶仃", "怎麽这样", "捶胸顿足", "刁钻古怪", "没脑袋", "后怕", "阴沉沉", "骂粗话", "埋汰", "败德的", "片面", "死沉沉", "骗人", "恕", "平淡无味", "怏然", "用欺骗致使", "自负的", "拘留处", "用愤怒", "大破坏", "口渴的", "风流", "没头没脑", "什麽世界", "辛苦", "不畏", "斥责", "衔恨", "平铺直序", "哀悼者", "难以捉摸", "没什么了不起", "草率从事", "遭受风吹雨打", "压倒性的", "为..报复", "损污", "棘手", "大批出没", "击溃", "严厉拒绝", "草率从事的", "极端", "无耻谓之贱", "通牒", "别扭", "顽固", "人不为己，天诛地灭", "围攻", "驶你母", "无资格", "凭白无故", "阻碍..的发育", "风波", "无魅力", "嘈杂", "使变得不愉快", "挖掘", "迷信引起的", "沈沈", "不详", "没想到", "说梦", "崎岖不平", "有义务", "欺瞒", "血淋淋", "起鸡皮疙瘩", "郁结", "嗔斥", "犯罪", "不成器", "瘆", "傲", "皱眉头", "不正当", "丑的", "不痛不痒", "流行病", "感到後悔", "病弱的", "不可爱的", "正式放弃", "不好看", "骄傲的", "屁滚尿流", "惰性", "摩肩接踵", "烦燥的", "没收", "感到极度痛苦", "斜", "繁缛", "弹劾", "一蹶不振", "摇摇晃晃", "不充分的", "缺乏兴趣的", "荒谬的言行", "杂草丛生", "嫉俗", "自卑", "不绝如缕", "心甘情愿", "不着调", "严酷", "不明不白", "偷偷摸摸的", "沈寂", "可耻", "携贰", "抱怨地说", "严酷的", "蛮横", "费用大的", "失眠", "单调枯燥", "悲", "暴虐", "不好听", "利己主义", "可厌恶", "虚张声势", "严重地", "没好气", "偷偷摸摸的人", "忧沈", "忽略", "愤愤", "偷偷摸摸", "做死做活", "懵懂", "未完成", "讨厌的人", "使中断", "懒得理你", "卑俗", "隐密的", "不适", "发出咯咯声", "说打就打", "诡辩的", "瞧不起人", "揪心", "无救的", "不光明正大", "阽", "坑洼不平", "愚笨", "死板板", "乱套", "不逊", "粗涩", "招致不幸", "困窘", "大浪", "不信任", "惶悚", "坑坑洼洼", "脸上发红的", "弄凹", "易碎的", "化脓", "趾高气扬", "逃亡者", "呆滞", "摆脱的", "极端的", "批评", "不冷不热", "大声要求", "懒惰", "烧制", "破落的", "缺乏的", "问题", "孤傲不群", "一巴掌", "败俗", "外行的", "缺德的", "易受骗的", "左右为难", "怀有恶意", "予取予求", "卑劣", "使胆寒", "对证", "山穷水尽", "挂念", "无聊死了", "使贫困", "不负责任的", "令人折断腰", "不开化", "想不到的", "徒", "过度的", "无休止", "相差", "用嘶哑", "不足取的", "害臊", "糙", "过意不去", "遏止", "好容易", "受骗者", "很臭", "无聊的想法", "搞下去", "骄傲", "讥讽", "粗暴", "鬼鬼祟祟", "世界的末日", "令人沮丧", "匮乏", "骂大街", "岂有此理", "快滚", "反复", "颠倒黑白", "恐慌", "厚颜无耻", "压治", "变得渺茫", "阴损", "恚恨", "凄凉", "妄自尊大", "粉屌", "无光泽", "酒醉的", "失血", "枯竭", "脸上发红", "反动", "强暴", "油煎火燎", "下陷", "颤动", "熹微", "对立面", "仿制品", "扣住", "伏击", "面呈病色", "浮躁的", "尚未", "健忘", "引颈企盼", "哀怜", "冷酷", "自甘堕落", "粗", "无名火起", "战争的", "不起眼", "没完没了", "阙略", "刮掉", "渣滓", "经不起", "不大可能之事", "夸张的言语", "奢", "发出撞击声", "死老太婆", "娇气", "不相容", "使枯竭", "刺耳", "疾风", "排斥", "畸形物", "猛踢", "荒唐", "混杂的", "残暴", "白痴般的", "生怕", "流放", "欠缺的", "视同儿戏", "惭不惭愧", "假装", "使沦为乞丐", "汽车扣押场", "郁郁寡欢", "去你妈", "批斗", "生气的", "笨拙的处理", "暴跌", "食古不化", "大怒", "岌岌可危", "心狠手辣", "使有危险", "贪心", "发狂的", "臭老猴", "不规则的事物", "不协调", "体念", "发动突然袭击", "缓慢", "苦涩", "没有勇气", "倔强的", "腐败的", "远去", "极度", "匆忙", "被控犯罪的人", "可怕的事物", "重压", "毫无用处", "丧气", "呆笨的", "变心", "走得慢", "无动於衷的", "猜想", "争辩", "罪该万死", "降祸", "抱歉", "讷", "呆子", "局限", "可叹", "骂人", "挑刺儿", "漏电", "笨猪", "乱七八糟", "不仁不义", "砰然", "没有学问", "使一团糟", "顽童", "沉沦", "低值", "痛恶", "放诞", "外行", "被遗弃的", "悲痛欲绝", "戳脊梁骨", "不流动", "皱眉", "鲁莽", "花拳绣腿", "鳞状", "扯破", "心痛", "下贱", "悲剧的", "无秩序", "挑拨", "瞧不起", "不可预测的", "离群的动物", "令人窒息", "残暴的", "杀戮", "心惊肉跳", "寒伧", "禁闭", "患..病", "强迫..入伍", "溜号", "恶浊", "铺张", "油", "愤慨", "使人痛苦的", "愚蠢", "无形的东西", "难以置信", "无能为力", "与虎谋皮", "贫困", "孟浪", "剑拔弩张", "枯燥无味", "最差", "责骂", "垮掉", "不礼貌", "分开", "不好客", "可耻的人", "漠漠", "深渊", "赌注", "高傲态度", "沉陷", "低声含糊地说", "卑贱的", "专横跋扈", "头痛", "发愁", "吵翻天", "衔冤", "为人作嫁衣裳", "硗", "得罪人", "粗陋的", "被绞死", "荒谬", "懵里懵懂", "神秘", "残败", "宿命论的", "弄糟", "慧黠", "不熟悉的", "心如死灰", "杂质", "讳言", "没天理", "恼", "撑着", "绝望", "假装神圣", "大雨", "控告", "呻吟", "颤巍巍", "拆毁", "陈旧的", "昏昏欲睡的", "冷血", "辱骂", "担惊受怕", "攻击性的", "不相信", "蠢女", "心口不一", "浮躁", "金玉其外败絮其中", "顽强", "枯槁", "心不在焉", "失悔", "羞耻的", "发火", "残害", "慢性", "干里娘操鸡麦", "激烈", "埋伏", "憋屈", "肚量小", "错的是你", "成为空", "板脸", "紧拖", "狭小", "瞪眼", "窘涩", "大惑不解", "外来", "恸哭", "你死我活", "难达成的", "失事", "无信用", "可笑", "低级的", "勾引", "干燥", "简陋", "嗔怒", "乱了营", "软弱无力", "啰嗦", "汉奸", "烂人", "浪荡的", "一屁股", "严峻的", "欠佳", "不能医治", "进行恐吓", "没想", "搞什麽鬼", "低声下气", "刺死", "永远都不要看到你", "得罪人的人", "驱散", "老不休", "欲壑难填", "无所不用其极", "假模假式", "左", "不平静的", "使腐朽", "残破不全", "武装部队的", "费劲", "脏乱差", "丢丑的人", "费力的", "提出..来反对", "变丑", "恶脸", "大胆", "忿忿不平", "使极", "恶兆的", "不大", "愤世嫉俗", "超标", "内哄", "别来烦我", "砍死", "送葬者", "之耻", "不可一世", "好事", "绕圈子", "老", "满腹牢骚", "令人愤慨", "暴风雨的", "宽赦", "极愚蠢的", "老油条", "义愤填膺", "虚", "停滞的", "丧失亲人", "晃晃悠悠", "凄寒", "绷着的脸", "米珠薪桂", "天杀", "不三不四", "追捕", "穷匮", "失败", "火暴", "反叛", "不正常的兴奋", "撤退信号", "自怨自艾", "胆寒", "风流", "危困", "不友好", "失业人数", "债务人", "流血", "损毁", "使分隔", "不断", "不重要的", "沉重", "猛冲", "堕落者", "等外", "未确定", "挂名", "凄然", "失却", "恶狠", "间不容发", "世故", "存有偏见的", "使倒塌", "怆然", "谁来救救我", "使离婚", "刀光剑影", "未确定的", "丧友", "引起震惊", "使服从", "不忿", "惊骇", "忧伤", "白日梦", "受抑止", "监禁", "禁止使用", "心胸狭窄", "暗下", "穷凶极恶", "变态的", "惊疑", "不存在", "压抑", "惊惶", "为耻", "黯", "警告", "阴凄", "要被当了", "贫穷的", "干娘", "不必要", "迷糊", "严重的", "使厌倦的", "疏", "有个屁用", "张口结舌", "颠倒", "使腐败", "动不动", "不干不净", "不协调", "缺", "不耐烦", "喧嚣声", "顽皮", "困局", "错杂", "丧气", "脚步沈重", "被驱逐", "病人", "变相", "辱骂", "挥击", "捕捉器", "置疑", "不确定的", "失去感觉的", "遇难", "矮的", "犯愁", "加害", "阴冷的", "游街", "真给他", "致死的", "秽土", "讶然失色", "被遗弃", "惊", "垂涎", "见鬼", "不客气", "凄怆", "愤愤不平", "踟蹰不前", "虚脱", "不祥", "他妈", "伤害..的感情", "易烦恼的", "口头上", "无纪律", "渎", "好不容易", "未见过的", "粗枝大叶", "令人遗憾", "弱小", "倥", "潦倒", "惘然若失", "不洁净的", "敌意", "服麻醉品", "不得人心", "恶意的", "喧嚣", "窳惰", "獐头鼠目", "悲观", "愚不可及", "滂", "面如死灰", "外伤用的", "错误的", "炫耀", "狠", "低沈", "徒劳", "不友善", "不利的", "使复杂的因素", "不整齐", "烂肉", "寡淡", "犬牙交错", "奇丑无比", "不健康", "不合逻辑", "追逐", "迟到", "坏脾气", "难控制的", "菲薄", "不识字", "罪恶昭著", "风风火火", "以怨", "声名狼藉", "打偏", "诘屈聱牙", "不好用", "怒喝", "拖沓", "敌手", "他奶奶的", "毛坑", "负气", "顾虑重重", "违反", "暴戾", "小家子相", "忍痛", "逼不得已", "有头无尾", "耍贱招", "随你便", "萎靡", "怪异的", "分崩离析", "羼", "心碎", "鼠目寸光", "吃惊", "白烂", "惨白的", "使隔绝", "凶恶的", "费事", "偏狭", "强烈抗议", "野蛮", "输光", "尖声喊叫", "可耻的", "抑郁", "不能想像", "癫狂", "真他ㄉ滥", "闹情绪", "快活", "变深", "无权的", "小气", "不厚道", "吊儿郎当", "甩不甩", "迷路", "匆忙地做", "烟雾弥漫", "概念化", "暴虐", "暝", "老年", "槁", "退缩", "呆板", "基卖", "被抑制状态", "乞怜", "歧途", "为..感到遗憾", "怀疑论", "一毛不拔", "不清不楚", "凌辱", "荡", "轻视", "未雨绸缪", "报应", "瞎眼", "颓废期", "无奈", "冲打", "惭", "没心没肺", "突如其来", "臭味", "喝斥", "伤残", "出气", "厝火积薪", "詈骂", "吓一跳", "容易受惊的", "刀刃", "不明显", "狡计多端", "滑头", "大恐慌", "不可避免", "嘈", "令人不愉快的", "凌虐", "恶魔般", "窜改", "一般杀人罪", "乱说", "赖", "含怨", "鬼头鬼脑", "不着边际", "抱恨", "忘恩负义", "万马齐喑", "茫", "破口大骂", "不正确的", "迷住", "脾气暴躁的", "斩首", "不流动的", "纵情於", "无利益的", "谅解", "当紧", "乏味的", "难过", "分心", "之恨", "埋怨", "会来事", "不可抵抗", "塌陷", "使过早硫化", "玩忽行为", "过得去", "搞援交", "不称心", "无趣味", "不可逾越", "渺然", "妄求", "火冒三丈", "傲岸", "背静", "虚荣", "妈ㄉ", "乱批评别人", "放纵", "使紊乱", "倔", "发呜咽声", "传染", "少不更事", "繁杂", "恐慌", "不重要之人", "过气", "开枪", "压下", "忝", "鼾声", "悲哀的", "尖酸刻薄", "疾走", "不爽", "安然无恙", "粗放", "以呻吟声说出", "一阵紧张", "灼伤", "死鬼", "分裂", "不行", "朦胧", "结疤", "听任", "跩什麽鬼", "心如蛇蝎", "驽马", "暮气沉沉", "急切", "用滥的", "死命", "感到痛苦", "使破裂", "伧俗", "小心眼儿", "星星点点", "过敏的", "抑郁", "抑郁寡欢", "牙痒痒", "孩子气", "冒失", "难解", "模棱两可", "异常", "击退", "低劣", "打骂", "坐卧不安", "蠢翻了", "落市", "不引人注意的", "滥打人", "不可理喻", "鄙弃", "二百五", "不成熟", "厌腻", "无形的", "工作过度", "忘恩负义的", "疑惧", "给..不快之感", "批评别人", "意马心猿", "乱丢垃圾", "苟且", "凭空", "哭爸", "摇摇欲坠", "流浪乞丐", "用尖锐", "猜忌", "差", "使皱缩", "狼心狗肺", "挫伤", "昏沉", "内讧", "走狗", "聋的", "痛惜", "心猿意马", "抗辩的", "不能辨别的", "过时", "恍惚", "关我辟事", "心烦", "毛躁", "阢", "矜夸", "轻狂", "拉忽", "限定", "仇恨", "发狂", "凄惨的", "追击", "颠连", "刺眼", "没有经验的", "肤浅", "勾搭", "无聊毙", "可恨", "受阻", "押往", "够了", "自任不凡的", "笨蛋", "不对", "平白", "岌岌", "隐伏", "犯憷", "零碎", "令人厌倦", "琐碎的", "无耻的", "死臭酸", "炮击", "迟疑", "轧", "粗重", "存偏见", "宿命", "沉闷", "顾忌", "肃杀", "闯入", "傻", "恻", "神经过敏", "差可", "高难度", "惊呼", "怪僻", "挹", "泼辣", "发育不全", "还想怎样", "使人产生不愉快", "犯罪者", "不合逻辑", "荒乱", "暗中来回寻觅", "呆若木鸡", "杂草", "臭话", "空幻", "辣手", "寒冷刺骨", "围城", "打搅", "枝蔓", "难堪", "刑事被告", "使厌恶", "发展迟缓的", "胡作非为", "踌躇", "垂头丧气", "蹒跚", "机械", "瞢", "妓女", "小便", "铁杆儿", "奢侈", "疯狂的", "污浊的", "罢黜", "没两下子", "食人者", "喧", "情急", "胆怯", "囚禁", "驴唇不对马嘴", "教得烂", "惊险", "贼", "轻看", "反话", "丧胆", "讽刺", "狡诈的", "好斗的", "责怨", "狂热的", "污秽", "泪流满面", "渺茫", "荒诞不经", "过多的", "任性", "叫嚣", "被玩弄", "密藏的金钱", "不可思议", "造作", "未触及的", "逞强", "劣质的", "伤风败俗", "孤寂的", "无智", "秽亵", "不悦", "非正义", "削减", "暗暗", "胡里胡涂", "易生气的", "掉魂", "窘", "败坏的", "愤怒的", "痛心", "私下", "悬", "无意识的", "使孤立", "吓呆的", "悒郁", "被动式", "不值得羡慕", "污秽的", "以喧闹声扰", "匪类", "强迫徵兵", "克星", "跩什麽跩", "失策", "偷偷", "左右两难", "不正当的", "打碎", "倔强", "退出", "无名小卒", "盲人瞎马", "错误", "无重要性", "孤单的", "不文雅", "老猴", "竹篮子打水一场空", "拥塞", "阴惨", "臭", "精神不振", "肮里肮脏", "暗弱", "浑浑噩噩", "爆炸物", "精疲力尽", "捉贼", "无可争辩的", "殖民地", "体力不支", "喧天", "敬陪末座", "枯萎", "糟", "无意", "掉队", "不相适应", "太虚", "气死", "过量的", "故意少给", "灰心的", "异常", "狂暴的", "官逼民反", "臭气冲天", "复杂的因素", "有特权", "毛毛躁躁", "惊悚", "老态龙锺", "把..孤注一掷", "假扮", "吵闹的", "卮", "求情", "罪的宣告", "粗鲁无礼的", "违悖", "撒尿", "自责", "贫穷", "前後颠倒的", "危险期", "讨厌的事", "投诉", "原子尘的降下", "诧异", "冷门", "全无", "恶根", "哄骗", "髒唐烂汉", "愣住", "更恶劣", "出没於", "苦难", "没效", "居然", "目无余子", "沉郁", "发出刺耳", "不值一文", "跋扈", "愧对", "浪子", "低声", "尖着声音讲", "受挫", "虚荣心", "秽恶", "伤悲", "不能区别的", "多阴雨", "贪念", "庸庸碌碌", "耻笑", "不必要的", "罪恶昭彰", "徒劳", "小心眼", "轻蔑地笑", "停业", "土里土气", "偷偷地行动", "沉滞", "匕首", "挂漏", "一下子爆发的一连串", "吆三喝四", "不雅观", "漫不经心", "不满足", "心地不好的", "偷偷摸摸的勾当", "头脑空虚", "累赘", "疯狂", "滞呆", "大肆", "不念旧恶", "背包袱", "破口大骂", "矜持", "苦境", "凶恶", "惧怕", "使乾枯", "漂泊的", "上瘾者", "迷惑的", "失业者", "认死理儿", "低潮", "你是怎样", "使无法动棋子", "多馀", "戚然", "解气", "坚持己见", "好挖苦人的", "笨拙", "狠打", "近视的", "脏", "使惨败", "不疼不痒", "愚昧无知", "讹", "笑骂", "鸡巴毛", "感到忧虑", "惊人", "犯人", "难看", "羞臊", "难以置信的", "皮相", "咒死", "睨", "记仇", "不足道", "使有缺陷", "受骗", "肥的", "绷紧", "使变暗", "错乱", "无度", "乾燥的", "不能说明的", "引起疼痛", "遗弃", "搀假", "瘫痪", "不文明", "夺取", "僵局", "坏蛋", "雪特", "难取悦", "在..埋地雷", "脸上下不来", "暴政", "威慑的", "难解的", "嗔", "箪食瓢饮", "咬伤", "恶性的", "装样子", "夜郎自大", "倨傲", "使窘迫不安", "害", "野", "变态性欲者", "痔疮", "说话不算话", "赧", "骂娘", "磨损的", "极度兴奋", "琐细的", "搞了鬼", "忧心如焚", "口齿不清", "征服", "困苦", "惨无人道", "訾议", "死心", "绝情", "毒打", "贱种", "名过其实", "限度", "平庸", "屌儿啷当", "忧", "过桥抽板", "瞑", "含混不清", "殖民", "空腹", "如死一般", "家破人亡", "水性杨花", "力尽", "卑鄙的人", "贪得", "易被瞒的", "憎恨", "脂肪", "责备", "赌博", "凹凸不平", "有瘾的人", "论战", "婞", "直盯盯", "行贿", "哀惜", "不流行的", "谲", "不顺当地", "未缓和的", "不美观", "阴雨", "虚妄", "骗子", "毛病", "使狼狈", "乱屁", "尚未准备好的", "隔靴搔痒", "暴跳", "稀薄", "狂傲", "现实", "尖刻", "羞窘", "震动", "闲闲没事做", "失身", "不生育", "使窒息", "罗网", "失措", "切齿", "争吵的原因", "伪造物", "拥有压倒优势", "瑕疵", "雨打", "抠唆", "脾气", "无知识的", "外伤", "无情", "大屠杀", "宣布脱离关系", "傲慢无礼", "游击", "被打", "发愁", "白忙活儿", "如临深渊", "板板六十四", "懒散", "纸老虎", "离乡背井", "胡扯", "无记名", "疯癫", "得饶人处且饶人", "好战者", "气恼", "延迟", "翻腾", "消耗热", "不景气的", "轰动一时的", "使堵塞", "杏眼圆睁", "造谣", "心情不稳的", "心胆俱裂", "僵直", "犹豫不决", "难信的", "不民主", "直撞", "不管怎样", "魔鬼似的", "不安的", "劝告", "身无分文", "没屁眼", "懒洋洋", "喋喋不休地讲话", "把关在栏内", "度量小", "谩骂", "眩目地照射", "有问题", "过分拥挤", "溢出", "乱吃豆腐", "迷信引起", "家长式", "误解", "唯利是图", "腐朽", "私", "讥嘲", "老练", "僵持", "二把刀", "讶异", "脱落", "管我", "抱残守缺", "魔鬼般", "强行", "下层社会", "滑", "懒得", "没动逃", "引咎", "随便地放置", "狡猾的", "伤亡", "轻易停止的人", "发怵", "戾", "卑劣", "冲头", "丢脸", "复合式", "一面倒", "貌似真实的", "踟蹰", "该咒骂的", "无关宏旨", "塌落", "骄傲自大", "得寸进尺", "馁", "面面相觑", "穷途末路", "风暴", "难取悦的", "不伦不类", "深恨", "吓人", "发指", "讽剌之事", "无聊的", "粗糙", "唠唠叨叨", "不要命", "高傲", "不正常", "下道儿", "够戗", "子弹", "被击中的", "积聚钱财", "自惭形秽", "赖皮", "乱哄哄", "敲诈", "松散", "蠢翻", "忿恨", "空落落", "耸人", "心疼", "残暴的行为", "猛击", "梗塞", "震颤", "下三滥", "蠢毙", "受惊", "发作", "感到疼痛", "罪孽深重", "迷途地", "猛然地", "担忧", "叫苦不迭", "言不由衷", "混吃混住", "粮食不足", "尘世", "可叹的", "占便宜", "荒落", "打压", "分离", "没有目标", "不尽如人意", "不可救药", "偷人", "污辱", "没好气", "缈", "後座力", "曲折", "谣传", "孤行", "陈腐", "偏袒", "适於屠宰", "使困窘", "微暗", "乾燥", "怄气", "不完全", "疑忌", "不近人情", "争斗", "不幸之事", "衰弱", "无所谓", "惊跳", "大声", "以怨报怨", "骇人听闻", "白云苍狗", "报忧", "惨事", "荒废的", "惊怖", "使惊讶", "说模棱两可的话", "胡来", "口吃", "干你", "奸诈的", "怒叱", "激战", "抱愧", "恨之入骨", "低效能", "愣神儿", "惮", "失去母兽的小动物", "撤退", "乱吃", "暴发出来", "不确切", "寒微", "祸延", "残酷的", "极恶的", "于事无补", "严肃的", "困在", "偏斜", "自怨", "无人理睬", "甩都不甩", "萋迷", "悯", "招致毁灭", "永诀", "乱乱哄哄", "黑心肠", "埋没", "不堪造就", "想抢走", "厌恨", "执拗的", "跋涉", "哼！", "吃饱闲闲", "包涵", "多义", "瓜分", "用力击", "抨击", "怠惰的", "灾害", "吃饱撑着", "不伦不类", "草菅人命", "不满", "不便", "未发觉", "靠不住的", "使摔倒", "微不足道", "微不足道的", "火烧火燎", "咕哝", "自大", "妖里妖气", "毛手毛脚", "板起脸", "什麽德性", "不顾後果的", "狂荡", "一掌", "溺爱", "走开啦", "忧愁", "吼叫着表达", "批臭", "用碎纸机撕毁", "渐失", "完全丧失", "算啥", "烦难", "死爱", "撵走", "贪污的", "瑟缩", "起诉", "不足取", "痴呆", "阵痛", "犯愁", "使受人轻视", "叫屈", "叱责", "有恶意", "敏感", "不甘示弱", "亡羊补牢", "跛行", "猥贱", "伤神", "清苦", "冒充", "猛烈的抨击", "饿馑", "拳打", "含糊其辞", "土", "冒冷汗", "反对改革的", "妒恨", "怆恍", "堵", "催吐剂", "砍痕", "净余", "肉麻", "拼命", "无所帮助", "肉脚", "腐旧", "我操", "不合规定", "吓人的", "沉痛", "冷嘲", "判刑", "华而不实", "失败的", "猥鄙", "恶行", "使惊惶失措", "一暴十寒", "担心", "愤愤", "大伤", "清算", "不适时", "泄恨", "恶有恶报", "不管用", "失魂落魄", "瞠目结舌", "傻事", "绞痛", "持续的叫喊", "艰难", "没品", "赛人样", "窝气", "拍击", "无用的老马", "无助的", "使竞争", "麻痹", "异常兴奋的", "作贼喊捉贼", "峻", "混乱", "使泛滥", "推却", "质地薄", "舌头断掉", "可怖", "无感情的", "打入地狱的", "心焦如焚", "不顺利的", "死光", "不方便", "破烂的", "质问", "易烦恼", "难达到的", "喷溅出来", "不平常的", "离间", "逞威风的", "自负的地方", "麻木不仁", "木头木脑", "破坏性", "搞违建", "使疲倦", "极无礼的", "设陷阱", "法西斯主义者", "仆人", "免职", "弄复杂", "拉屎", "躁", "怜悯", "蛮横行为", "少烦我", "荡妇", "不熟练", "虚夸", "情节剧似的", "骂街", "使凌乱", "效率很差", "玄", "纵容", "刁", "潜藏", "一偏", "耍我", "阴沉", "隔开", "瞧不起", "守财奴", "呜呜咽咽", "殷勤", "细菌", "僵直的", "儇", "霸占", "咂嘴", "垂头", "不光明正大的", "太迟的", "易损坏", "民怨沸腾", "杠上", "隐性", "政变", "花花搭搭", "假想", "论争", "糊涂", "萧条的", "冷静下来", "烙跑", "干你娘老鸡麦", "面无人色", "搞封建", "小肚鸡肠", "下流", "背令", "不一致", "畸形的", "一文不值", "废除", "不合时宜", "憎恨", "锯掉", "枉然", "烂车", "马马虎虎", "巧", "招致毁灭的", "忌刻", "骚乱性", "淫猥", "乖张的", "肚烂", "数不上", "死硬", "默默", "死三八", "作梗", "置辩", "痴人", "寡欢", "翻然悔悟", "奸刁", "辐射性微尘", "假冒的", "乱结", "泪如雨下", "表面粗糙的", "不合时令", "过激的", "哀号", "死去活来", "争斗者", "幽幽", "可恶的", "迂", "下毒", "辛苦地", "自称", "死里逃生", "操心", "沈默", "使不适", "肆虐", "芴", "率尔", "贷", "哀伤的", "死不瞑目", "使断裂", "厉害", "砰击声", "投弹於", "报怨声", "占着毛坑不拉屎", "饭桶", "密", "精神溜号", "卒仔", "败类", "耳热", "昏暗", "弥漫", "浓烟", "焦躁的", "不断唠叨", "使愤怒", "拷问的", "灾难性", "畏惧", "残忍", "没骨头", "昏昏欲睡", "烂戏", "粗话", "门外汉", "瞪眼", "挨饿", "多病", "慵懒", "惶然", "打高空", "獪", "软弱的", "恐怖统治", "不许", "生锈的", "愁容满面", "寻仇", "对立者", "未获", "对..采取破坏行动", "冷酷", "使人厌烦的", "闹", "压碎", "铲除", "要不得", "打入地狱", "气鼓鼓", "急促地说", "丑事", "凄厉", "饿昏", "幻异", "缺乏", "迟钝", "愧疚", "胶柱鼓瑟", "怕死", "设圈套", "含混", "极可憎的", "风刀霜剑", "犷悍", "无可", "久坐", "极度渴望", "急急巴巴", "竞争者", "含沙射影", "不正当", "攻击性", "麻烦", "过失", "王八蛋", "逼死", "忧闷", "消散", "不管三七二十一", "秀逗", "严惩", "侵袭", "隐退处", "学究气", "犹豫", "使发出撞击声", "积重难返", "指摘", "鼠胆", "使局促不安", "刮出刺耳声", "格外", "被损坏", "黑黢黢", "芜", "扣留", "狃", "不吉利的", "排除", "装肖唯", "不道德", "利令智昏", "诱惑物", "冷酷地", "使发愁", "搞啥鬼", "凛凛", "油汪汪", "蚍蜉撼树", "渺若烟云", "极可憎", "消耗性的", "气急败坏", "难耐", "使逆行", "分泌毒液", "失控地", "叫喊", "抢夺", "滑稽的", "罗哩吧唆", "只顾自身利益", "恫吓", "惜", "掎", "七零八落", "无理性的", "显怒容", "高价位", "把..闷死", "无味", "心急火燎", "扭伤", "受诅咒", "云遮雾障", "打破", "病魔", "毒蛇一样", "噘着嘴说", "掺杂的", "难驾驭的", "掺杂", "横蛮无理", "凝重", "抱歉的", "痛心", "空洞的", "步入歧途", "荒凉的", "未详细说明", "遗失", "哀叹", "灰头土脸", "可惜", "要死要活", "激进分子", "鞍伤", "苍茫", "费解的", "轻浮", "反悔", "偷偷取得", "被迷住的", "寡味", "下等", "嚣张", "拆除", "烂校鸟系", "抓瞎", "任重道远", "千金一掷", "成问题", "平淡无奇", "病恹恹", "暗讽", "惭愧的", "孤独的人", "厌弃", "害处", "不了", "诧愕", "孤僻", "脾气爆躁", "瞬息万变", "毁掉", "凄迷", "痛苦的", "被议论", "毙了你", "喧闹的谈笑", "酸楚", "穷奢极侈", "自夸", "面有愠色", "喧哗吵闹", "莽撞", "搥胸顿足", "难以", "粗野", "自负", "沈寂的", "爆震", "武断", "鬼鬼祟祟做事", "凄然", "剽悍", "小", "痛苦", "震怒", "长长短短", "砍断", "缺乏感情", "成见", "无端", "恨铁不成钢", "空中楼阁", "数说", "病态", "暴客", "憋死", "成空", "打憷", "不安宁", "受闷", "受气", "不美的", "简慢", "把..归咎於", "易怒", "贬损", "不完美", "责难", "盘问", "变迟钝", "羞答答", "外来的", "稀罕", "阙陋", "逞性", "中止", "没意思", "恶名", "激进", "闹情绪", "欺负", "蛀坏", "看不起", "仇佛蔑僧", "轸", "冲蚀", "怪里怪气", "发愣", "晕头转向", "坑洼", "越想越气", "无效能的", "醉翁之意不在酒", "断开", "发牢骚", "饿死光", "加重", "电击", "非正统", "忿怒", "使朦胧", "寸草不生", "毒气", "冥冥", "凶蛮", "专制", "不可容忍", "惭惶", "交媾", "险恶的", "心烦意乱", "闹性子", "腐臭", "不甘", "迟缓", "动粗", "喋喋", "崎岖", "盲目", "怅恨", "饥不择食", "清理债务", "交战国", "使忧伤", "犹豫不前", "惨淡", "散落", "怊", "毙了", "涩", "横七竖八", "弄翻", "冒充者", "发出颤声", "忌恨", "头皮发麻", "翻倒", "贸然", "真他妈", "茫茫然", "仇视", "不完美的", "杀气腾腾", "发毛", "自我", "使隔离", "老掉牙", "羞羞羞", "梦魇", "说胡话", "戒惧", "贪得无厌", "说模棱两可", "毁谤", "感到抱歉的", "靠不住", "直眉瞪眼", "仇外", "不洁的", "变得无耻", "置之不理", "何苦来哉", "使束手无策", "愤愤不平", "屌什麽", "使蒙羞", "空虚的", "过量", "零", "凶手", "无意义", "不忠的", "歉甚", "性急", "穷途潦倒", "迷茫", "声名狼藉的", "污蔑", "浮动", "若明若暗", "功利主义", "淫秽的", "不俭省", "病的", "笨脚", "在..上蔓生", "烂到", "抨", "说鸟话", "犯罪的", "傥", "使分裂", "危机四伏", "无知", "烙印", "冀望", "不堪一击", "专制", "皱缩", "感伤的", "摆脱了的", "不宜", "愁肠百结", "等着瞧", "怒容", "犟", "犯了罪的", "不爽", "使失效", "大手大脚", "瘦的", "非正常", "拙笨", "遴", "使厌倦", "飞溅出", "气闷", "恼怒", "群魔乱舞", "侈", "使饿死", "混淆", "唱反调", "戆头戆脑", "痛苦的根源", "把..吓出来", "倒坍", "别离", "燃烧", "无益的", "侵占", "零星", "寄食", "蔫不唧儿", "匆忙地走", "掉下", "怒气冲冲", "没精", "低哦", "呐喊", "侮慢的", "粗糙", "不实", "羞恶", "品性不端", "不道德的", "零七八碎", "无法解决的", "伤心死了", "介怀", "苦心", "相差的", "虚无飘渺", "损失者", "不纯的", "穷凶极恶的", "重沓", "瞎扯", "挑剔", "残破", "冲动的", "逃亡的", "秘密", "塞八", "滴里嘟噜", "忧心忡忡", "挑拨离间", "脑满肠肥", "偷窃", "趄", "不留神的", "急急忙忙", "顽皮", "诮", "犯杀人罪", "淡而无味", "大量杀戮", "心粗", "产生反作用", "不合情理之事", "多馀物", "毒气影响", "饿殍遍野", "不像话", "伤脑筋", "贸然轻率的", "愤世", "穷困", "睁只眼闭只眼", "生厌", "拥挤", "逃亡", "令人讨厌", "剥夺", "使落入圈套", "麻痹", "混吃混喝", "恻然", "悲痛", "不能区别", "混混沌沌", "茕茕孑立，形影相吊", "使贫穷", "慢的", "悬空", "使激动", "素不相识", "酶烂", "钳制", "干上", "空想的", "万花筒似", "含糊不清", "丑八怪", "怫然作色", "糟粕", "卑下的", "找谁干啊", "蒙蒙", "小家子气", "厚利可图", "冗余", "急死", "无眉目", "嗜杀的", "蹈常袭故", "弱小", "死蟑螂", "利用人", "放浪", "良莠不齐", "僵持不下", "口角", "啧有烦言", "腐烂的", "惹怒", "挑逗", "漏球", "难处理", "缺乏感情的", "矫揉", "不眠", "告诫", "凶兆", "带有敌意", "没个好脸", "人为的", "遮蔽", "茕茕孑立", "嘲弄的话", "咒骂", "脸红耳热", "猜疑", "幽暗", "花搭着", "恶臭", "惊险", "离索", "枪声", "兔子尾巴长不了", "没有观察到", "上吊", "不识字的", "反叛", "结结巴巴地说话", "眼睛狗到蛤仔肉", "悖晦", "窘境", "无价值的", "生硬的", "玷污", "会传播", "尸体", "虚弱", "负担", "恶", "赤裸裸的", "毫无目标", "峭直", "腆", "不消化", "加深", "勒死", "烦人的", "乱说话", "病弱的人", "意外的", "胆小", "艰苦卓绝", "反覆", "蠢妇", "奉承", "没有好脸", "里出外进", "罪恶多端", "无中生有", "使挨饿", "冗长乏味", "严", "不赞同", "使黑暗", "穷境", "粗野的", "森", "不现实", "使不相宜", "末日审判", "走人", "令人不愉快", "罢工", "绝不原谅你", "太过自信的", "对..处以缺席裁判", "傲视", "高价", "谅", "不长进", "可望", "意见不合", "邪恶", "扑朔迷离", "夸耀", "忍受不了", "表示鄙视", "非婚生子女", "胀大", "忌讳的", "曲折的", "对立", "伤心的", "轫", "拒人于千里之外", "装备不良", "不留心的", "卑劣的", "疯癫癫", "耳生", "亢", "不说话的", "鲁", "不守规矩", "害臊", "吼叫", "无效的", "较量", "乱", "摇摇", "叫吠", "自相残杀", "不起", "令人生厌", "不待见", "出卖", "使受严重损伤", "乾旱", "耍色", "糜", "砍倒", "衰弱", "野鸡", "介意", "惨重", "不合理的", "成问题的", "反唇相讥", "瞎了狗眼", "耗费的", "弄跛", "无关大局", "疮痍满目", "烂老师", "情况不好", "撬起", "歪斜", "走着瞧", "不确的", "渗漏", "寒冷刺骨的", "障碍物", "过分操心", "凶狠的", "惶惑", "娇弱", "下跌", "毫不在乎", "闵", "有碍观瞻", "夜盗", "寒", "拘束", "自以为是", "怛", "罪的", "腐坏", "饮泣", "不成比例的", "畏葸", "坐立不安", "不透明", "大动肝火", "被诅咒的", "僭", "惨", "对付", "黢黑", "自馁", "残忍或好色之人", "申明", "唠里唠叨", "鲨鱼", "不足取", "孑然", "媚俗", "茫然", "降低", "蠢呆", "使道德败坏", "辜负", "懦怯", "蔫儿坏", "减小", "咆哮得使", "堙", "背理", "深恶痛绝", "谪", "低哼", "过节", "浪费", "啰里啰嗦", "不下", "畸形", "惘", "罪犯", "置之度外", "甘你屁事", "奚幸", "下不了台", "毁灭性", "意义不明确", "使恐慌", "大块呆", "未开化的", "提心吊胆", "平淡", "不可接受", "绕圈子的话", "乾阴阳", "殷切", "诃", "把..强加於", "造成损失", "退回", "尖酸", "紊乱", "晦暗", "否决权", "怯生生", "多疑", "自责", "心情不好", "怪诞", "大变动", "消极", "胆小", "喜怒无常的", "死老百姓", "摇晃着行驶", "孩子气", "使变丑", "可憎", "瞧不上", "萧森", "沈重缓慢", "老式", "怨", "否定的", "令人讨厌的", "诱拐", "极恶", "白", "泄密", "强要", "纹裂", "过河拆桥", "尖嘴猴腮", "苦工", "卖国贼", "生", "佯装", "迁就", "频繁", "狠骂", "惹上", "理亏", "东骂西骂", "作秀", "悔悟", "切齿痛恨", "冲突", "吆五喝六", "使咬字不清晰", "供认", "依稀", "久坐的", "阻塞", "创伤", "畏首畏尾", "未知的东西", "专制的", "数不着", "憋闷", "不灵巧", "气馁的", "怀有恶意的", "孑然一身", "扭扭捏捏", "滞背", "发昏", "碜", "非常悲哀", "枯", "懊悔", "浮噪", "把..烧焦", "视同蝼蚁", "使失常", "约束", "放射", "难为情", "干瞧", "擦痛", "吃饱太闲", "逼问", "诽谤者", "天南地北", "麻烦", "吃屎", "直愣愣", "偏激", "嚎啕", "造成破坏", "败兴", "呵责", "难以明了", "忘情", "蠢", "反对者", "高价", "罚金", "不可信赖", "刺耳的", "不关", "急煞车声", "不适当", "紧", "仆人的", "懊恼", "侈靡", "迷路的", "胡思乱想", "不明", "不健全的", "约略", "泼妇", "卑微", "不牢固", "有弊", "变得更坏", "怠工", "卑微的", "赶这样说", "反面", "劣中之劣", "使失去勇气", "口蜜腹剑", "贬值", "在..下挖掘", "耍狠", "恶魔", "怪", "冷冷", "冒险的", "七窍生烟", "模糊不清", "靡丽", "凿空", "令人伤心的", "改变成", "谈不拢", "任性的举动", "毒腺", "肮脏", "酒鬼", "卑陋", "违法的", "发出呻吟声", "愚傻", "劈开", "穷极无聊", "逃走的", "一怒之下", "糟透的", "脱离常规的人", "不能胜任", "归咎", "严重破坏", "忧伤", "临时地", "机八毛", "不友好的", "责骂", "躁狂", "贬低..", "操贱役", "争论", "蠢人", "悲凉", "淫贱", "冷冰冰", "超讨厌", "怨言", "破门盗窃", "难治疗", "污渍", "嘲笑的", "不学无术", "大摇大摆", "原宥", "不逊的", "易瞒", "次要的", "肉了叭叽", "做坏事", "颓", "怒气冲冲", "愤然", "喧闹的", "瘟疫", "强盗行为", "牵念", "不信实的", "发生矛盾", "眼花", "刁难", "烂仗", "造成损害的", "以怨报德", "多事", "食古不化", "斗起来", "使起皱纹", "死气沈沈", "过错", "烂学校", "难以沟通", "心死", "不幸的", "虚伪的", "板着脸", "忿懑", "不易", "不能胜任的", "损失惨重", "矮小的东西", "悲悼", "不听话的", "无理由", "倒底要怎样", "不乐", "贪心不足", "喧噪", "吊儿郎当的人", "荒谬绝伦", "低标准", "变淡", "使上瘾", "急走", "斗拳", "颤声", "无聊人做无聊事", "暴动", "失约", "害人精", "荒淫", "蔽塞", "使气馁", "覆雨翻云", "过意不去", "兴叹", "愤怒", "烂货", "不成比例", "野蛮人", "凌迟", "懂个屁", "有特权的", "污点", "故意刁难", "出手阔气", "侥", "心寒", "无法解决", "操心", "不寒而栗", "进退维谷", "应斥责的", "不同意", "玩人家", "过意", "无把握", "扁一扁", "不可爱", "走失", "欺诈者", "不讲道理", "索", "惊恐", "风骚", "兀突", "忿恚", "讨厌", "捣碎", "包庇", "自疚", "安静下来", "对抗力量", "蠕动", "搞什麽", "悲伤", "不安全", "谈何容易", "爱面子", "捏造", "搞妇运", "危险之源", "脱离联邦", "恶劣", "不可思议的", "没有自信的", "坟墓", "怒斥", "自扰", "有什麽了不起", "讨价还价", "浑噩", "秉性剌戾", "机械性", "不努力", "急忙地讲", "隐蔽", "功亏一篑", "白吃", "酸涩", "指责", "干干巴巴", "在..搜寻", "冒险", "暴戾", "赤贫", "理由不充分", "糊里糊涂", "无人情味", "计谋", "盲目的", "狎昵", "不赞成", "锱铢必较", "寂寞", "毁损", "昏暗的", "恶劣的", "黑洞洞", "没有经验", "钻牛角尖", "繁重", "气愤", "东洋鬼子", "不够意思", "跛子", "无策", "费力", "那麽烂", "逃不过", "老奸巨猾", "侉", "伤怀", "闹别扭", "虐", "隔离", "焦虑", "台湾之耻", "耍起狠", "死性", "不容易的", "灼枯", "令人烦恼的", "残缺不全", "心浮", "使骨折", "面有愧色", "去除", "粗俗", "难为情", "世俗", "强制", "甩掉", "扭打", "乌沉沉", "癫狂", "好争论", "戚戚", "计较", "无法预料的", "干涉", "流亡", "一无所长", "拉出来", "骄气", "不清", "轰动一时", "强打", "怏怏不乐", "擦痕", "向..开枪", "不重要", "罚款", "耻骂", "不一致", "闷死", "罪恶深重", "甩都甩不掉", "不亲切", "火爆", "没手", "浮漂", "不雅观的", "惹到你", "贫瘠的", "为所欲为", "懦弱的人", "刁滑", "用带捆住", "终止", "昏", "白白", "阴险", "退却", "错乱地做事", "惶惶", "实利", "乱辩", "枯涩", "衰老", "破落", "失意", "狼藉", "不愿意", "浑", "体惜", "荒凉", "变得冷酷无情", "无情无义", "封建", "眼皮子高", "厚颜无耻的", "面无表情", "反动的", "不易了解的", "不近人情的", "没有", "不得", "狂热者", "嬉笑怒骂", "自暴自弃", "志大才疏", "猛地落下", "凄", "没大没小", "哓", "机车", "使恶化", "子虚乌有", "恶搞", "滑稽", "极度悲伤", "伤悲", "邪", "耽搁", "无益", "哭夭", "战斗的", "空乏", "同病相怜", "丝毫", "干谯", "宣布中止", "阴沈沈的样子", "油腻的", "狡猾", "尖叫声", "出卖身体", "黑乎乎", "骄横", "味同嚼蜡", "灭亡", "现世报", "变弱", "心如刀割", "阻碍", "责怪", "胡思乱想的", "六亲不认", "恶心鬼", "由爱生恨", "冷落", "苦役", "应该谴责的", "杂多", "昂贵地", "持异议", "受损害", "朝不保夕", "顽强地", "嶙峋", "毒", "操切", "贵", "无法计数的", "忸", "失态", "悲酸", "牢骚", "错误地", "窘迫不安", "粗心大意", "软弱", "形同路人", "笨头笨脑", "不平静", "复合", "驳议", "恶脸相向", "表面粗糙", "怒火中烧", "揭露", "声明放弃", "脸红脖子粗", "凄惨", "喜新厌旧", "滥砍", "乌七八糟", "扯破的洞", "要饭的", "被擦模糊", "惶急", "假的", "侵蚀", "要吐的", "横刀夺爱", "碎", "不理会", "变相", "慊", "不觉", "心虚", "头晕的", "好恨", "整死", "犹疑", "极坏", "腼腆", "肤浅", "饕", "攻击", "将..逐出社会", "漫无边际", "反动主义者", "幽冥", "自我本位", "淫秽", "摩擦", "怨恨引起的", "派系", "算了", "兔子不吃窝边草", "被闷死", "满脸烂肉", "毒品", "不仁", "有害", "粗拉", "徘徊", "不精密的", "该罚下地狱的", "不以为然", "迷迷茫茫", "后进", "魂飞天外", "老年的", "嫌弃", "没道理", "使身心交疲", "孤单", "贼去关门", "放肆", "以商逼政", "违背习俗", "伤心", "敌人", "抹煞", "悔恨", "脱轨", "罔", "生涩", "久经世故的", "被污染", "气的半死", "暗朦", "严酷", "辞呈", "用愤怒的目光表示", "憔悴", "完蛋", "白忙", "有啥了不起", "动摇", "咆哮", "不如", "使不关心", "自大的", "色迷迷", "庞杂", "别来惹我", "嘀咕", "不满", "追悔", "泛泛", "葬身", "怜惜", "冒牌", "不断引起苦恼", "不妥", "排揎", "随便", "灭口", "睁一只眼闭一只眼", "划破", "无足轻重", "新仇旧恨", "悖逆", "公愤", "廪", "无能力", "赌运气", "互撞", "报复", "巨澜", "失色", "赧颜", "产生纹裂", "水火不容", "安慰", "谴", "无理性", "投弹", "无重要性的", "谇", "过饱", "痼疾", "悄悄踱步", "呆钝", "埋怨", "愚顽", "昏厥", "担心", "不能解决", "工作过度的", "殚", "贬低"}
HOWNET_pos = {"无误", "感激不尽", "受大众欢迎", "敬礼", "合口味", "突出", "文雅", "一尘不染", "高精度", "兴盛", "如获至宝", "朴", "浑然", "辉煌", "炫目", "标致", "冰清玉洁", "细致优雅的", "精心的", "心灵", "照理", "最主要", "湛", "热心肠的", "恭敬", "超凡入圣", "眄", "懂礼", "真心诚意", "倾心", "滑稽", "瑰", "无上光荣", "道谢", "断然", "驯服", "自行", "确凿无疑", "行云流水", "伶俐", "全始全终", "任意", "勾魂", "驯良", "渴盼", "适度的", "宝贵", "巧妙的", "协力", "征服", "以求", "致敬", "朝气蓬勃", "慊", "牣", "由衷", "高高兴兴", "惨淡", "肜", "不耻下问", "忠诚的行为", "流利的", "悄悄", "慕名", "认命", "不含糊的", "和顺", "令人信服", "舒", "欢闹的", "欢叫", "荣耀", "纯洁", "明目张胆", "有财产", "坚不可摧", "拿手", "有两下子", "整洁的", "整齐的", "低首下心", "有助益", "鼎鼎大名", "光洁", "悔改", "清雅", "大量的", "忘不了", "轻悄悄", "昌盛", "苦心", "精壮", "正经", "奇妙", "助手", "妇孺皆知", "如意", "称心如意", "上", "别致的", "妄想", "舒松", "喜爱", "中肯", "卓越", "最理想", "有福", "资源", "圆通", "翻天覆地", "入理", "诚心诚意", "朴实无华", "节制的", "心心相印", "高山流水", "省力", "堂堂", "承认", "不同寻常", "明达", "超拔", "跃跃欲试", "心地纯良", "精细", "素雅", "把牢", "直捷", "芳香", "熟练地", "一口", "优秀的", "祝福", "平板", "惊羡", "寂静", "髀肉复生", "蔼然可亲", "敦", "善理家", "相信", "珍爱", "热心", "最上的", "叫真", "创新", "欢慰", "无懈可击", "惬意", "相安无事", "清白", "上上", "心地善良", "许可", "温存", "积极", "滴水不漏", "耐劳", "软心肠", "公平", "有一套", "精巧的设计", "赞", "名不虚传", "当之无愧", "时机适宜", "期望", "亲切的", "好情", "煌煌", "狠抓", "坚决的", "受欢迎的", "省心", "喜欢", "鲜豔的", "浑金璞玉", "笃厚", "有嘴无心", "冶艳", "勇敢的事迹", "礼貌性", "庄严", "贵族", "繁盛", "占理", "厚道的", "喜剧的", "稀奇的", "有效的", "福祉", "正派", "练达", "皎皎", "无价的", "强势", "信得过", "姣", "通明透亮", "没分开", "维护", "招笑儿", "闳", "前程万里", "准", "忌妒", "铁面无私", "可口的", "勤", "平静下来", "肝胆相照", "引领", "谦卑的", "芳", "衷心的", "不亢不卑", "浓香", "余裕", "欢闹", "协力的", "见微知萌", "受看", "脱俗", "赤心", "满意", "盛大", "浩大", "敏锐", "负责", "呼之欲出", "省时", "说白了", "颇为重要", "勇猛", "谦逊的", "自动的", "爱戴", "变清", "可靠", "登峰造极", "够味儿", "酷", "驰念", "心慈", "千依百顺", "恭敬的", "示喜", "热爱", "情愿", "奉迎", "爱国的", "宽阔的", "幸福", "精辟", "尚好", "灵光", "灵秀", "有门", "入神", "面有喜色", "无懈可击", "五大三粗", "洋洋大观", "温文尔雅", "满怀敬畏的", "令人鼓舞", "老于世故", "俭朴", "有头脑", "繁盛", "为怀", "坚持的", "重要的", "坚韧", "挑战性", "无可挑剔", "绘声绘色", "超群", "吸引人眼球", "光明磊落", "珍惜", "报答", "鸟语花香", "素朴", "无害处", "令人难忘的", "贤人", "诚笃", "节约", "敞开儿", "百里挑一", "自明", "明净", "既定", "快活", "通用的", "热心的", "承望", "宁静", "清高", "关注", "上好的", "过谦", "绮丽", "神志正常的", "准确", "回礼", "万变不离其宗", "洒脱", "匀称", "英武", "静", "度量大", "时髦", "跌宕", "可钦佩", "有帮手的", "丰饶", "超尘拔俗", "精神", "经得起检验", "有胆量", "公然", "秀异", "有责任心", "可敬重", "适口", "激动人心", "垂涎三尺", "简朴", "龙腾虎跃", "刚直", "豁达大度", "确切", "惺惺", "超卓", "僖", "标致的", "热忱", "有秩序", "韧", "令人愉快的", "安安静静", "光辉灿烂", "爱国", "万夫莫当", "福如东海", "娴雅", "通透", "喜孜孜", "四平八稳", "根深蒂固", "高档", "细腻", "传奇性", "大胆", "忠贞的", "慈悲心", "发自肺腑", "肯顺从", "渊博", "悄", "阴翳", "完整的", "翩翩", "灿烂的", "有才智的", "光明正大", "静幽幽", "宽宏", "谐调", "祝贺的", "树叶茂盛", "静谧", "苦苦", "慈和", "徼幸", "对劲儿", "无私无畏", "对", "精美的", "强硬", "悦服", "通过", "难能可贵", "革命", "稳当", "富有", "大喜", "偏重", "趣味相同的", "有涵养", "启发想像力", "嫣然一笑", "诚实的", "一致的", "百读不厌", "友好", "甲等", "恒久", "深入浅出", "生死", "清新", "原谅", "夹道欢迎", "聚精会神", "明睿", "避免", "赞叹", "清朗", "庆幸", "领先", "得奖的", "手松", "圣洁的", "雍容", "眉清目秀", "活着", "重大", "珍奇", "发人深省", "使安静", "厚", "激励", "特异", "匡", "安全", "从宽", "平滑", "出众", "红润", "鬼斧神工", "精力充沛的", "凿凿", "赞成", "清白", "营养的", "安全", "成熟", "有帮助", "严谨", "永恒的", "能干", "亲和", "直率", "盼念", "详实", "曼妙", "光风霁月", "简朴的", "伸缩", "无瑕的", "丰姿绰约", "热闹", "迷人之处", "乐不可支", "熙", "爽口", "悔悟", "尊敬人", "文雅的", "蓬蓬勃勃", "正义的", "毫发无损", "坚贞不渝", "发育完全", "优於", "朴实", "十全十美", "令人钦佩", "秀挺", "徼", "俶傥", "得力", "工整", "全神贯注的", "顶级", "合意", "有威严", "和睦的", "同意", "富丽", "稳健", "谈吐不俗", "红红火火", "精悍", "不费力", "极好的", "目光如炬", "极好的人", "愉", "婵娟", "独创性", "锃光瓦亮", "奉公守法", "无缺点的", "相等", "爱上", "不费吹灰之力", "随遇而安", "痴心妄想", "在乎", "顺畅", "柔滑", "妒火中烧", "头号", "打眼", "准确", "有特色的", "侠义", "钟情", "时机成熟", "不赖", "显扬", "决断", "众口一词", "喜剧", "彰", "妒", "富於", "排场", "合乎卫生的", "通用", "一清二楚", "博爱者", "过细", "通俗", "铁铮铮", "气概不凡", "赏心悦目", "作为奖品", "精明", "柔曼", "暖呼呼", "虔诚的", "专属", "香醇", "令人钦佩", "温静", "清澈", "心驰神往", "亲近", "淡泊名利", "倜傥", "互助合作", "无毒", "前程似锦", "新颖", "深切", "足够", "可爱的", "煌", "崇仰", "药到病除", "容易的", "戆直", "唱喏", "渴慕", "健康", "有心眼", "妒恨", "飘逸", "通俗", "快乐主义的", "岑寂", "爱宠", "英勇", "经济宽裕", "示好", "鼓掌欢呼表示通过", "相中", "第一流的", "奋起", "率真", "可用", "滑溜溜", "真心实意", "热情洋溢", "竟敢", "翘望", "秀丽", "爽气", "昂扬", "适应的", "快乐的", "忠义", "夸奖", "使人信服", "强健", "静态", "非常热心", "清明", "祝贺", "丰满的", "质朴", "笑兮兮", "精神十足", "渴望", "磅礴", "渴望", "眉飞色舞", "迅速", "集资", "对味儿", "崇拜", "醇厚", "欣欣向荣", "滑爽", "昌", "对头", "自由", "铁打", "整洁", "端庄", "值得", "稳定性", "管", "出神入化", "实际的", "齐整", "整齐划一", "颂扬", "平等互利", "适意的", "心灵美", "致贺", "胜过", "日久生情", "有韧劲", "一律", "安睡", "卑", "凝重", "你侬我侬", "训练", "品性端正的", "真实可信", "值得的", "灼灼", "舒适的", "雷打不动", "顾虑周到的", "赞成的", "博学", "锐利", "深挚", "杰出人物", "老练", "琦", "关切", "毫无隐讳交谈的", "闲雅", "破釜沉舟", "柔和", "举行凯旋式", "没有负担", "恩人", "富裕", "正", "郁郁葱葱", "引人注目的", "自在", "事实上", "叹羡", "精明", "和易", "天从人愿", "叫绝", "挚切", "甚感欢慰", "稳健的", "紧凑", "挑三拣四", "注意", "名垂千古", "群威群胆", "实在论", "永恒", "森森", "隆", "顽石点头", "投入", "豁然开朗", "双料", "不容置辩", "愿意", "斯斯文文", "可用的", "顶数", "外向", "宽厚", "精制", "紧紧", "康乐", "卫冕", "景色优美", "孝顺", "盯紧", "高级化", "同情", "明快生动", "快快活活", "慨", "悄然", "懿", "娟", "有说服力的", "奔放", "感激", "耀眼", "日有所思", "舒畅", "忠忱", "天公地道", "虔心", "聪明过人", "可喜", "欢忭", "茏", "精力充沛", "陶", "珍视", "公开的", "衷心地", "偏要", "学富五车", "赞同", "雅致", "热烈", "清白的", "繁荣", "足色", "机警", "可爱地", "快乐论", "滑不唧溜", "企盼", "清楚", "独具特色", "为快", "奉献", "生意盎然", "有礼貌的行为", "使平坦", "自觉自愿", "显要", "儒雅", "完", "溺爱", "天籁", "锣鼓喧天", "敬祝", "发财", "无比", "一往情深", "开化", "顶尖", "深切", "喜出望外", "无可置辩", "噱头", "中意", "得体", "得人心", "喜气", "透明", "沉静", "理直气壮", "合乎逻辑", "引以为傲", "示同意", "香馥馥", "风风光光", "夥伴的", "汹汹", "繁茂的", "迎", "高新", "扎实", "乖觉", "锲而不舍", "鑫", "尊敬的", "清幽幽", "不动摇的", "铿锵", "强", "乐于", "感到满意", "刻意", "过奖", "狂欢的", "企", "和平的", "熙熙攘攘", "嗜好", "相当重要", "尊敬人的", "生效的", "有决心的", "淡雅", "精心", "悄没声", "全心全意", "金壁辉煌", "廉洁", "至尊至贵", "隆重", "敬礼", "古道热肠", "顾", "叹服", "健硕", "企望", "巨大", "实诚", "一流", "一体化", "清洁", "恣肆", "希罕", "理性的", "有盼儿", "拍案叫绝", "安泰", "吸引", "成熟的", "怀着希望的", "惓惓", "难忘", "略", "易办", "强健的", "贤惠", "不任性的", "抒情的", "工工整整", "齐", "俭省", "幽美", "实实在在", "翕然", "温厚", "规范", "良心", "平平淡淡", "狂想", "愿", "具有压倒性优势", "坚强", "娴雅的", "保密", "有效率", "曲线美", "看得上", "无髒污", "留心的", "无欲的", "顽强", "流芳百世", "愉快", "高性能", "独具匠心", "茂盛", "称", "热衷的", "醒目", "聪慧", "很好的", "仁义", "好办", "百听不厌", "文绉绉", "偏宠", "窈冥", "最佳", "沃", "知名", "腻", "恭祝", "神采飞扬", "全", "基础扎实", "狂爱", "儇", "当心", "如鱼得水", "感恩戴德", "坚毅", "善於经营", "浑然一体", "光润", "无上", "留个心眼儿", "令人惊奇", "有目的的", "迎迓", "直性", "小心谨慎", "好看", "盼望", "娴淑", "曾经沧海", "浪漫", "得法", "恰如其分", "基", "明白无误", "任性", "中肯", "有意义", "信赖", "茂盛的", "庆贺", "安然无恙", "丝毫不差", "稳定", "有名的", "水灵灵", "壮健", "值得向往的", "可靠性", "简", "有头有脸", "使人信服的", "遵守", "畏", "请求", "思考", "前卫", "专心", "謇", "才华", "有帮手", "语重心长", "如雷贯耳", "有益於健康", "功绩", "肥沃", "融和", "湛深", "金不换", "了当", "得体的", "身强力壮", "稀罕", "清秀", "恺", "热火", "幸运地", "功德", "磊落", "着眼于", "驰名", "熟悉的", "博爱的", "奇异", "圣徒", "科学", "给面子", "有爱心", "爱好", "清晰", "有理", "纯净", "不争", "理会", "和气", "尊重", "适度", "得意", "料事如神", "明智", "促成", "手脚麻利", "出息", "人性", "有利润", "公正地", "洌", "高等级", "便捷", "鸡犬不惊", "耿介", "锺爱", "阒", "其实", "全面", "落落大方", "彬彬有礼", "值得纪念的", "倍儿棒", "侃", "夸赞", "嘉奖", "熟虑", "不偏不倚的", "功不可没", "痴情", "学识", "入木三分", "谦恭的", "不犹豫", "有说有笑", "供娱乐用", "欢跃", "要紧", "上等", "关爱", "好感", "快捷", "忭跃", "迎刃而解", "秀润", "称羡", "冰雪聪明", "迫切需要", "简单", "膏腴", "名誉", "均一", "博大精深", "完美的", "信心", "刻苦", "光滑的", "堂而皇之", "赞扬", "谐调的", "出众", "喜欢", "答应", "正常", "风华正茂", "详", "不加掩饰", "蔚", "庆贺", "有规矩", "亦然", "值得接受", "提高", "友善", "望子成龙", "彪形", "传统", "杰", "无可责难", "强有力", "互利", "老实", "妙计", "坚忍不拔", "宽怀", "赞成的论点", "拥护", "密切", "聪明的", "有求必应", "睦", "历史性", "头脑清楚", "着边儿", "志愿", "快乐主义者", "学成归国", "笃", "爱好", "桌面儿上", "不拘泥的", "瑰伟", "有鼻子有眼儿", "心甘情愿", "高端", "聪敏", "干净", "紧要", "听话", "爽怡", "顺口", "不亦乐乎", "严整", "调和", "值得尊敬的", "入迷", "出身名门", "快乐地", "會", "绝好", "艳冶", "孜孜不倦", "平息", "锃", "千姿百态", "始终不渝", "显性", "安於", "清晰可辨", "美妙的", "适得其所", "新", "情不自禁", "多才多艺的", "肉墩墩", "全力的", "雪亮", "喜出望外", "想像的", "确切无疑", "精深", "默许", "真确的", "金玉满堂", "清洁", "正点", "内秀", "爱情", "心满意足", "第一流", "真真实实", "婉言", "稳重", "人性的", "夺目", "看上", "长进", "香", "高妙", "神工鬼斧", "缜", "引以为荣", "贴切", "杲杲", "巩固", "丰沃", "干劲", "重要", "有钱", "点头称是", "锋利", "冶容", "满意的", "懂事", "认真", "弘", "大有裨益", "芜", "意气风发", "轻捷", "待人如友", "低调", "浓艳", "炯", "友爱", "怏然自足", "裣衽", "怜悯心", "真实", "谧", "嫣然", "一本正经", "光辉", "勤快", "生死不渝", "慧", "醇美", "叹赏", "深长", "投机", "明理", "肥沃的", "融洽", "不俗", "有威严的", "自信", "倾情", "恒久不变", "伟大", "昶", "行时", "水汪汪", "轻轻松松", "奢望", "柔", "满腔热忱", "为人宽厚", "划一", "吊祭", "心爱的", "文武兼备", "至深", "精密", "完成的", "敬若神明", "吉庆", "担待", "强固", "详密", "礼貌", "彬", "香纯", "晔", "有指望", "眷恋", "恒", "小心翼翼", "乐融融", "狂喜", "照旧", "唯实论", "明明白白", "嶷", "尽心", "衣冠楚楚", "廉洁奉公", "事关重大", "把握", "豁朗", "互助", "不落窠臼", "弹性", "公平", "胜利", "叩拜", "可爱", "前所未闻", "适合", "空前", "簇新", "心满意足地注视", "聪明", "怀着希望", "整", "柔顺", "板实", "明艳", "有前途", "厚道", "奘", "出类拔萃", "慨然", "常规", "有才能的", "深远", "意在言外", "有名", "细润", "神往", "啧啧称羡", "合理的", "英烈", "毅然", "威严", "平稳", "小", "飞黄腾达", "均等", "糖味", "五星级", "果断", "有品味", "熙攘", "无畏的", "持久", "人欢马叫", "安如泰山", "迷", "行礼", "前所未见", "敏", "穆", "有贵族气派", "似天使的", "烁", "精灵", "诙谐的", "褒扬", "交口称赞", "廉洁", "饶沃", "遥遥领先", "优", "整齐", "精确度", "均匀", "绝妙的", "不会受伤害的", "欢欣", "如数家珍", "贤慧", "爱恋", "有进取精神的", "透彻", "不愧", "为人正直", "希冀", "陶陶", "抢眼", "栩栩如活", "全新", "属实", "轻快地", "遐迩闻名", "帅", "尊贵", "动听", "拥护", "俳谐", "翔实", "精神百倍", "思想性", "器宇不凡", "善始善终", "较优", "顾惜", "增加", "谦虚", "愀", "博学多闻", "流畅", "天使的", "出以公心", "充份的", "心情舒畅的", "赞佩", "诚恳", "磕头", "留神", "简朴", "可经营", "明慧", "智力的", "理想的", "夺冠", "春色满园", "显着地", "明处", "挨边", "花哨", "芬芳", "繁茂", "适得", "器重", "准时", "有把握的", "有滋有味", "新奇", "品行端正", "神圣", "浅易", "守时", "飞快", "从容不迫", "达到", "高深莫测", "幽寂", "不厌其详", "坦白", "疯魔", "耳聪目明", "端丽", "堪称第一", "明媚", "驯顺", "眼熟", "玄妙", "骁勇", "表里如一", "晶莹", "透亮", "经常性", "人寿年丰", "坦", "至高的", "暖意", "盼", "哏", "认可", "自立自强", "梦想", "经营", "碍事", "欢喜", "扬扬自得", "黄金", "简明", "尖", "端直", "婉娩", "尽心竭力", "坚定", "温柔的", "二话不说", "天造地设", "锐", "居高临下", "乐乎", "方正", "率直", "殷勤的", "谦逊地", "仁慈", "古典的", "漂亮", "顺耳", "正常的", "敦实", "天随人愿", "周至", "爽快", "善理", "最好", "坦直", "坦白", "称心", "值得注意的", "够格", "谠", "夜有所梦", "轻悠悠", "大有作为", "生死攸关", "绝无错误的", "宝贵的", "", "灼然可见", "有吸引力的", "不惮其烦", "清澈见底", "没错儿", "才高八斗", "从始至终", "有分寸", "可靠", "卓越超群", "缝补", "十拿九稳", "鲜亮", "领情", "易控制的", "热闹", "有所作为", "责任重大的", "爱打趣的", "关心", "感兴趣", "头脑清楚的", "喧闹", "明白的", "向往", "有用的", "说项", "较优者", "宏富", "名实相符", "欢快", "重视", "公正", "容忍", "袅袅婷婷", "实在论的", "翘企", "胜", "高尚的", "安好", "愿意", "牢稳", "忍耐", "相当", "值得赞扬", "斗志", "固定", "卓", "人情味", "感动", "审慎", "虚心", "娓娓", "偿清", "能力", "驯", "道地", "胪", "智巧", "确实", "能动", "推尊", "令人愉快", "非凡的", "豪勇", "赤胆忠心", "口头通过", "望", "含情脉脉", "可统一", "胜任的", "缩手缩脚", "主导", "名声", "渴盼", "织补", "百废俱兴", "形象化", "忠贞", "喜不自禁", "幽雅", "可理解的", "老到", "必要", "向", "无疑的", "堂皇的", "轩然", "答应", "无价", "开心", "瓷实", "稳步", "易理解", "活", "心醉神迷", "自得", "可信任", "无恶意的", "无害处的", "纯净", "详细", "流芳千古", "灼", "堕入情网", "犒赏", "精巧的", "精当", "叮嘱", "光彩炫目", "翩若惊鸿", "自愿", "由衷", "宏丽", "无可非议", "欢愉", "警觉", "牢固的", "和声", "生育", "欢呼", "烂熟", "沈着的", "春秋正富", "诙谐", "娇好", "富庶", "坚强不屈", "好学", "稳重", "善行的", "尽善尽美", "纯", "豪壮", "发人深思", "花好月圆", "富有弹性", "见机", "简洁", "赞赏", "快人快语", "秀逸", "起眼儿", "妒嫉", "妖娆", "俨然", "吉祥如意", "名特优新", "省俭", "可亲", "坦荡", "怀恋", "识趣", "战胜", "迎接", "靓丽", "佳丽", "满面春风", "没的说", "老成", "热心", "慎虑的", "蔫不声", "家喻户晓", "注目", "有耐性的", "主动", "馐", "敏捷的", "波光粼粼", "易控制", "功德无量", "廑", "景仰", "矫健", "芬芳袭人", "感谢", "如花似锦", "照直", "享受", "地覆天翻", "天使", "守信", "使用方便", "风雅", "美味", "没说的", "固定", "款洽", "幽默滑稽", "有为", "顾盼自雄", "言简意赅", "勃勃", "舒畅", "超凡脱俗", "天香国色", "得意忘形", "毫厘不爽", "充份", "原封", "事迹", "十分重要", "爱屋及乌", "有功", "努力的", "有光泽", "目无全牛", "改良", "宽洪", "如画的", "希冀", "熠耀", "喜洋洋", "没有拖累", "偏好", "年高德劭", "了不起", "爱怜", "勇敢", "顾及", "爱抚", "礼貌", "眼光锐利", "光彩", "质优", "不咎既往", "手勤", "坦率直言", "哙", "中心", "有确实根据的", "高纯", "平静的", "仔仔细细", "羞怯的", "一叶知秋", "扣人心弦", "勋绩", "学会", "活泛", "着迷", "地地道道", "目眩", "宗仰", "拥", "专注", "栩栩如生", "谧静", "明明", "有把握", "言归於好", "痛快", "睎", "克制", "坦诚", "艮", "众所周知", "稳定", "出人意表", "鞭辟入里", "明文", "自满", "特别的", "潜心", "着迷", "欢天喜地", "花容玉貌", "真切", "忠直", "袅", "澄清", "富有的", "怡然", "无罪", "智勇双全", "彬彬", "僭", "赞许的", "决定性", "叫好", "完整", "安顿", "获利", "大有文章", "吐气扬眉", "富丽堂皇", "上赶", "部优", "鲜活", "决断力", "有含义", "可理解", "贤慧", "豪", "一致", "具有吸引力", "豪华", "彰明较著", "绿色", "情愿", "表现突出的", "群策群力", "幽丽", "受过良好训练", "毫不犹豫", "赏", "平平安安", "是的", "菁菁", "惟命是从", "气贯长虹", "脍炙人口", "同感", "真实", "实现出来", "谨言慎行", "多才多艺", "有利益的", "简易", "璀璨", "奇巧", "爽直", "娇媚", "满园春色", "最优秀", "娴", "乖", "根除", "健壮", "悚", "恬静", "滋养", "奠基者", "诙谐", "令人高兴的", "尊重人", "愉快的", "心慈手软", "朝思暮想", "尽心尽力", "资深", "值得赞扬的", "佳", "无拘束", "猗", "变平静", "管教好", "有贵族气派的", "矍铄", "魔法", "打心眼儿里", "优质的", "经用", "馥馥", "多姿多采", "光滑滑", "务实", "朴素的", "激昂", "有魔力", "安宁", "昌盛的", "独特的", "温和", "决定性", "贵", "尊严", "美丽的", "发育", "愉悦", "丰饶的", "璀璨夺目", "满怀敬畏", "巧妙", "如痴如狂", "顺当", "趣味相同", "如旧", "叫真儿", "全神贯注", "端正", "利落", "清凌凌", "丰裕", "刚强", "痴心", "不可侵犯", "扬扬", "欢喜的", "必不可少", "顺眼", "平缓", "诚恳", "大喜过望", "笑死", "明澈", "高屋建瓴", "神圣", "淳美", "人和", "比较好", "说得通", "勤恳", "嗟", "精神百倍", "安", "打心底里", "应许", "投缘", "解决", "闪亮", "参拜", "喜上心头", "奉若神明", "婉约", "先进", "爱抚", "魂牵梦系", "瞩望", "贵重", "迷恋", "妖冶", "知耻", "殷殷", "训练良好", "强壮的", "扬扬得意", "鲜美", "正义", "适当", "守候", "油光光", "丰美", "亲爱的", "强健", "聚焦", "一丝不苟", "趣味盎然", "井然", "聪明伶俐", "虎虎生气", "许可", "昭著", "希", "饶有兴趣", "泠然", "古雅", "明显", "温文", "发财致富", "器重", "有心", "褒", "哿", "有天资", "齐楚", "精神焕发", "完好", "有雅量的", "清湛", "爱惜", "祝", "值得崇拜的", "群情激愤", "喜不自禁", "出神的", "心有戚戚", "纯挚", "简略", "精确的", "缓和", "亭亭玉立", "友谊", "革命性", "旖旎", "以一当十", "最适当地", "两袖清风", "热衷", "致谢", "从一而终", "苍郁", "工细", "详细", "喜感", "倡", "可心", "天翻地覆", "不偏不倚", "令人满意的", "悦耳", "睿智", "水乳交融", "苞", "封禅", "剀", "善意", "光芒四射", "媢嫉", "才能", "信实", "昭彰", "憨厚", "熙来攘往", "阗", "傧", "佶", "坚韧的", "没有说的", "简单易行", "难忘的", "道贺", "柔中有刚", "神采奕奕", "沁人心脾", "凝聚性", "惨烈", "周详", "锐敏", "细致", "积极", "静寂", "活着的", "革新", "富於同情心", "忠心耿耿", "亲切", "贱", "叹为观止", "巨大的", "富有成效", "闻过则喜", "亮光光", "满足", "平整", "耳熟能详", "端秀", "高", "流利", "不可名状", "谦虚谨慎", "消停", "谅解", "无罪", "活生生", "自愿", "深沉", "亲善", "娉婷", "骋怀", "和平", "实心", "太平", "可靠程度", "容人", "秀外慧中", "惊喜", "豁亮", "长治久安", "高强", "成", "受吃", "佼", "惜", "手软", "红色", "体面", "吐口", "想望", "恒定", "文从字顺", "实行", "正直", "流行", "利益", "羡煞", "恳", "完好如初", "出名的", "获胜", "显赫", "正派的", "工稳", "不胜欣忭", "好奇的", "华贵", "敏悟的", "忠", "战斗", "婀娜多姿", "奋争", "安静", "关怀", "诗意的", "最佳的", "爱", "见爱", "炜", "慰问", "有同情心的", "心安理得", "明细", "欢欣鼓舞", "丰富", "体态轻盈", "自然的", "不同凡响", "内行", "尊敬", "旋律优美", "喷香", "美好的", "性格外向", "光可鉴人", "非常大方的", "猴儿精", "芾", "嘴稳", "入味", "聪明绝顶", "恩爱", "决定性的", "有助", "佩服", "拥戴", "纯真", "价值连城", "溜光", "热切", "招待", "炳", "允准", "折服", "母爱", "道德", "慷慨", "心有灵犀", "灵验", "最高", "狷介", "赤裸裸", "笨鸟先飞", "喜气洋洋", "确实可靠", "小面额", "有财产", "吃香", "芊", "有理由", "冰肌玉骨", "毫不利己", "深谋远虑", "诚实", "微微的", "消除", "鲠直", "有势力的", "无裂缝", "自告奋勇", "憨直", "秀俊", "哀婉", "内行", "放胆", "傲然", "勤勉", "嫉", "圆满", "照耀", "不无裨益", "均", "精通", "赏罚分明", "广阔", "玉立", "统一", "恭谨", "未被污染", "风行", "忠贞不贰", "怜爱", "觉察", "合适地", "论功行赏", "英雄式", "均衡的", "精巧", "引吭高歌", "无所不能", "兴奋", "鼓舞人心", "板正", "忠贞不渝", "狂欢", "了然", "贵重的", "恭喜", "果断", "刚毅", "严谨的", "梦魂萦绕", "措意", "楚楚动人", "称身", "赤裸", "上乘", "透辟", "兴高采烈", "着眼", "意味深长的", "恭敬", "纯厚", "野心勃勃", "有价值的", "友好", "清明", "眇", "有规范的", "合格", "说服", "无愧", "直性子", "和婉", "调谐", "含义明确", "排列有序", "轻轻", "硬", "喜滋滋", "有精神", "干脆", "怡", "不大不小", "婷", "生动", "精卫填海", "灵捷", "无疵", "有个性", "分工", "轻轻松松", "熟练", "富丽堂皇", "博闻广识", "圆活", "谦诚", "犀利", "人心大快", "平易近人", "牵挂", "无污点", "恩恩爱爱", "大胆", "宠爱", "俨", "公道", "先见之明", "灵活", "澹", "崇高", "注重", "有帮助的人", "奋力", "美妙", "有道德的", "连贯", "豪华型", "高级", "恩惠", "神气活现的", "鬼迷心窍", "利嘴", "典雅", "基本", "柔软", "淡泊", "正当的", "柔媚", "老牌", "举行", "高高手儿", "依依不舍", "有两手", "有魅力的", "致富", "棒", "痛快", "浑身是胆", "热情的", "收获", "财大气粗", "热恋", "身强体壮", "完美无缺", "别有风味", "无瑕", "一吐为快", "幽婉", "实在", "风靡", "魔力", "天真烂漫", "通亮", "尽如人意", "奋进", "极热心", "明亮", "昭然若揭", "爱上", "炉火纯青", "敬服", "恳挚", "深", "情投意合", "匀实", "受听", "瑕不掩瑜", "无误地", "明显", "及格", "顺势", "有利益", "高超", "主要", "毫无", "吉星高照", "不偏不倚", "顾虑周到", "戏剧性", "消遣", "一身是胆", "有思想性", "光艳", "眼疾手快", "恒心", "有趣的", "欢愉", "众目昭彰", "远大", "疼爱地", "谐趣横生", "精雕细刻", "屏息静气", "装备完善", "重大", "精巧地", "嘉许", "一刻千金", "平易", "欢腾", "资源丰富", "入情入理", "超逸", "高尚", "值得尊重的", "钟", "第一流", "正确", "值得注意地", "声情并茂", "心花怒放", "详详细细", "富丽的", "承", "不会弄错", "恭", "解开", "机敏的", "顶事", "有意", "知觉", "法定", "耿", "灿烂", "助益", "茂密", "大好", "逼真地", "清楚易懂的", "粹", "同意给予", "专门", "欣赏", "服从", "赞助", "乐此不疲", "正牌", "敬仰", "使平静", "忠耿", "高贵", "品学兼优", "无庸置疑", "很好地", "清脆", "廉价", "引人注目", "幸运的", "有爱国心的", "跪拜", "有朝气", "庆祝", "明人不做暗事", "颂", "免除", "流畅", "乐於", "进取心", "甜蜜", "兴旺", "坚固", "盖了帽", "富丽堂皇的", "记挂", "夸耀", "创造", "丽", "适任", "合乎", "爱怜", "坚韧", "博古通今", "注", "留意", "客观", "接受", "十全", "肥沃", "畅快", "完好无损", "融融", "入耳", "胸怀坦白", "汹涌", "获胜的", "雅致的", "明智的", "香甜可口", "有效", "弘大", "谢", "淑", "数得上", "照章", "温顺的", "有思想性的", "最好地", "婉转", "有权能的", "火", "数得着", "有节制的", "毫不费力", "买账", "哄闹", "着名的", "熙和", "庆幸", "敏慧", "勤勉", "明理", "有意义", "宠爱", "粹白", "孜孜", "满腔热情", "好笑的", "有规范", "正常", "惊奇", "茏葱", "神奥", "微微", "实打实", "清真", "当红", "好客", "有礼貌的", "醒豁", "安康", "稳态", "熠熠生辉", "作兴", "豪放不羁", "松", "弹冠相庆", "整饬", "诚心诚意", "悦目", "幸福的", "可贵的", "机警", "少不得", "支持", "英雄", "兴奋的", "端重", "彬彬有礼的", "仁厚", "挺秀", "富贵", "出神", "天真无邪", "魂牵梦萦", "因陋就简", "直觉", "伟大", "促成的", "无牵无挂", "忠信", "光泽", "放心", "优美", "光滑", "精到", "豪宕", "好玩儿", "热心肠", "嫕", "提倡", "优势", "上劲", "深情", "便民", "可了解", "柔软的", "委婉", "严肃的", "益", "上色", "优雅", "热烈", "闪闪", "能充分理解的", "非常合适的", "谦逊", "顺理成章", "从轻", "可以信赖", "泼悍", "繁茂", "应允", "机巧", "清婉", "致密", "仞", "讲理", "松快", "快活的", "铮铮", "友善的", "有价值", "迷上", "慈悲", "合乎情理的", "欢喜", "捎带", "有福气", "检点", "古香古色", "平衡", "无损", "令人瞩目", "柔和", "求之不得", "可观", "好玩", "渴望的", "恰当", "平安的", "咏赞", "有种", "怿", "伶俐", "风度翩翩", "清淡", "俊美", "造诣", "脸红", "圆润", "成为", "宽大", "赞颂", "嫣", "立项", "热情", "甘甜", "意味深长", "人格高尚的", "准许", "澈", "和祥", "赏识到", "喜眉笑眼", "进步的", "言之成理", "学有专长", "繁华", "欣赏", "不迫", "入迷", "小心", "举止端庄", "旷达", "神通广大", "健实", "奖掖", "扰攘", "重大的", "无罪的", "有远见的", "痛痛快快", "平心", "孝顺", "约定", "吸引人", "学习好", "爽朗", "气冲霄汉", "天下为公", "矫捷", "及格", "锺", "仡", "负责的", "信用", "殷", "冠军的", "骁悍", "端整", "至关重大", "痴迷", "超俗", "欢畅", "无偿", "百无一失", "富甲一方", "崇拜", "恭维", "崭新", "壮观的", "平平静静", "幽", "感恩", "巴望", "健全的", "拜拜", "戴", "承平", "秩序", "有理", "神智健全", "迎来", "养尊处优", "热血", "多情", "气魄", "和谐的", "有先见之明", "慈悲为怀的", "圆浑", "理想", "谦和", "笃诚", "韵味", "倩", "绚丽多彩", "著", "气派", "实事求是", "穰穰", "有才能", "井然有序", "梦寐以求", "牢固", "敢", "嘴紧", "耳熟", "为荣", "利索", "名", "尽人皆知", "值得赞美的", "茌", "娇美", "沾沾自喜", "兴致勃勃", "溜滑", "生机盎然", "韶", "经久耐用", "微妙", "加薪", "端雅", "笑勒", "毫无隐讳交谈", "红火", "深湛", "轻轻地", "凉快", "粗壮", "有力", "堂皇", "奇迹", "跂望", "万人空巷", "知冷着热", "不拘泥", "风流倜傥", "雄心勃勃", "倾慕", "陶醉", "敬贺", "中允", "蓬茸", "多留个心眼儿", "壮丽", "毫不", "保皇", "仁爱", "设备齐全", "致意", "成长", "亮晶晶", "谒", "清幽", "优良", "健全", "俯允", "一致", "肯定语", "判断正确", "甘愿的", "有魔力的", "顺利", "多劳多得", "慎重", "赞美", "膜拜", "郁郁", "殷勤", "热火朝天", "法定", "衷心", "婀娜", "敬畏", "悬红", "勤奋的", "有名气", "宽容", "醒眼", "坦诚相待", "夜不闭户", "流行的", "值得信赖的", "不厌其烦", "妖艳", "无缺点", "有钱", "年富力强", "打千", "满意", "节约", "结实", "老实的", "别有情趣", "赏罚严明", "虚己", "神圣不可侵犯", "令人大开眼界", "有先见之明的", "有感觉的", "重要", "可信", "增进友谊的", "靠得住", "兴趣盎然", "生长完全", "恬适", "可贵", "怀着", "施舍慷慨", "脉脉", "醇的", "精光", "佩", "如初", "可敬的", "启发想像力的", "毖", "一身正气", "善於", "水涔涔", "责任心", "群言堂", "详尽", "好用", "想念", "孝行", "油光水滑", "习惯", "妙", "贤明", "光溜", "精彩", "体贴的", "驾轻就熟", "捐献", "合理", "健美", "主动", "壮实", "英俊的", "宜", "正好", "留意", "盛年", "圣洁", "令人喜悦", "引吭", "清口", "回敬", "奥妙", "吃得开", "和谐", "娟秀", "平和", "卓尔不群", "确定性", "热望的", "艳丽", "绝无", "勐", "有学问", "仁至义尽", "逍遥自在", "名垂青史", "等内", "精采", "肯", "慕", "不屈不挠", "多趣", "固", "欢乐的", "关照", "梗直", "诚", "好事", "丕", "谙练", "美味的", "焕发", "宽恕的", "意味深长", "知书达理", "万能的", "叠翠", "重点", "通过", "时机适宜的", "富幽默感的", "开诚布公", "著称", "好笑", "不整齐", "光耀", "勇", "勃勃生机", "充分", "保证", "诚实", "茵茵", "万马奔腾", "客气", "利齿", "喜幸", "坚决", "腴", "石破天惊", "金碧辉煌", "可口", "膀阔腰圆", "爽", "有才气的", "喜吟吟", "赏心悦目", "看在", "称道", "安然", "欢腾的", "忠诚的", "滴水穿石", "参加", "能", "钐", "俞允", "自由", "狂热", "正面地", "浩然", "泠泠作响", "有效性", "有地位", "称许", "无刺激性", "畅顺", "调和", "漂漂亮亮", "缥", "盖帽", "长处", "伸张", "自然", "健旺", "正确的", "供娱乐用的", "庆", "热乎", "安泰", "动人", "符合要求", "器宇轩昂", "安稳", "玄秘", "新奇的", "小巧玲珑", "透明的", "硬朗", "细", "正而不谲", "使醉心", "坚硬无比", "雍和", "有序", "评价颇高", "春光明媚", "严密", "要害", "有纪律", "荩", "体系化", "茁壮", "英勇的", "忠诚", "幸运", "铁骨铮铮", "慷慨的行为", "顺从", "趣味", "廉", "阒然", "明智的行为", "潇", "亮晃晃", "昂藏", "公平正直", "有派", "适宜的", "金玉", "全神贯注", "玉洁冰清", "艺术", "鼓舞人心的人", "刚正不阿", "味道好", "浅显", "最著名", "炯炯有神", "深邃", "兢兢业业", "鲜明", "划一不二", "能吃苦耐劳", "正当", "冀求", "鲜明的", "绝色", "采纳", "协调一致", "硬实", "系统", "从实", "俏美", "过问", "清平", "高档化", "安身", "擅长", "值得接受的", "容易亲近的", "偏", "深思的", "谢谢", "轻松", "媚人", "不会受伤害", "好意地", "适宜", "合乎情理", "信赏必罚", "莹", "又红又专", "灏", "胸怀坦荡", "有利条件", "至上", "滚瓜烂熟", "经意", "切题", "脱俗", "要强", "舒缓", "喜庆", "质量好", "荣幸", "通俗的", "创新的", "赤诚", "正义", "红旗", "引人注目", "防止", "深切注意", "助长", "表扬", "简明扼要", "朴厚", "有头脑的", "成趣", "作为奖品的", "悦耳的", "爽心悦目", "鸣谢", "不加区别", "允诺", "一门心思", "肃然", "仔细", "尔雅", "捷", "虔诚", "雩", "瞧得起", "正面", "盈盈", "美满", "一呼百应", "挂牵", "简括", "资助", "给予", "撑腰", "敬奉", "信任", "屏声息气", "时兴", "公而忘私", "谆", "实用", "中听", "如故", "顺手", "重在", "龙飞凤舞", "着名", "激荡", "确确实实", "奋勇", "喜爱", "被喜爱", "稀罕", "温蔼", "聪明", "着边", "有天赋", "文不加点", "引人赞美", "获得胜利", "至善", "俏皮", "铮亮", "赞成", "才思敏捷", "毫无错误", "好说话儿", "良善", "光明", "富强", "勇猛", "无拘无束", "瞧得上眼", "韪", "朴质", "罕见", "真", "经", "温文儒雅", "善良", "炽盛", "歆羡", "当众", "雅致", "华美", "和和睦睦", "孛", "精巧", "慷慨的", "特级", "时髦的", "嬉戏的", "称谢", "特色", "可称赞", "钦佩", "营养", "秀雅", "使陶醉", "清亮", "驰誉", "凤毛麟角", "正规", "风起云涌", "一团和气", "未被污染的", "健全", "进行", "知恩", "蓊郁", "宝贵", "天然", "人道", "了解", "忠实", "消消停停", "不言而喻", "适", "使凉快", "羡慕的", "博识", "有把握地", "心想事成", "怀想", "甘之如饴", "远见", "开拓型", "真诚", "兴盛的", "甘美", "洁净", "方方正正", "热烈的", "牺牲", "挚", "甘", "绰约", "奥", "多彩", "有品格的", "公祭", "通达", "快乐论的", "松动", "百折不挠", "捐赠", "优雅", "乐颠颠", "雀跃", "牢靠", "光滑", "很有意义", "大大方方", "首肯", "互助的", "容许", "谆谆", "卓著", "机智", "善", "温慰", "坚固的", "顶呱呱", "无可争议", "泰", "很好", "前进", "冲劲", "心甘情愿的", "鼓励", "淳朴", "武", "十足", "有进取精神", "优良", "饶有风趣", "正确性", "形影不离", "显然", "圣人", "熟悉", "世界级", "审慎", "衷心", "可以接受", "独立自主的", "爱心", "扼要", "钦", "留意的", "敬重", "以德报怨", "得体", "花容月貌", "威严", "信息丰富", "荟", "匀溜", "粗中有细", "特大", "敞口", "树碑立传", "端平", "有口无心", "安适", "捧场", "乐不可支", "温柔亲切", "无可挑剔的", "雄壮", "率真", "力主", "尊崇", "带有灵感", "静穆", "明", "有眉目", "锃亮", "网开一面", "新鲜", "灵感", "拜", "丰润", "瓦亮", "蓁", "辩证", "有目共睹", "深切注意的", "温馨", "水滴石穿", "热切", "深奥", "有板有眼", "一帆风顺的", "羡", "贤明的", "机动", "平稳", "有眼光", "毫不含糊", "喜好", "符合的", "有才干", "完成", "粲然", "死静", "含情", "恳求", "带来福气", "恰当", "众目睽睽", "言笑晏晏", "得宜", "豪华的", "温暖的", "别致", "葱茏", "可信赖", "忮", "唯实论的", "欣然", "安分", "辅助", "可嘉", "宜人", "和缓", "大有益处", "明晃晃", "祭祀", "恨不得", "乐意的", "彪炳千古", "亮丽", "妙趣横生", "考究", "热切於", "安宁的", "庄严的", "海枯石烂", "有光", "骠", "不懈", "一心", "切身", "允许", "有礼", "踏实的", "秀巧", "典雅的", "奋勇", "照样", "智能型", "学有专精", "自由主义", "仰慕", "新鲜的", "旺盛", "温顺", "欣喜若狂", "摩登", "贪图", "品行端正的", "错落有致", "炙手可热", "象话", "恪", "通融", "怕事", "端庄", "认真的", "窗明几净", "狠狠", "肯干", "回味无穷", "合法", "敬佩", "蔼如", "稳如泰山", "公允", "显著", "易", "不变", "不可侵犯的", "淳厚", "乐乐呵呵", "忘不了的", "谦恭有礼", "举止文雅", "气度恢宏", "极乐的", "出身高贵", "值得拥有的", "欣喜", "一心一意", "毅", "贞洁", "庄重", "可信赖的", "优美的", "熟练的", "绵密", "消退", "生动活泼", "富於机智的", "小心谨慎的", "基础", "仰", "无过失", "职责", "国优", "独具慧眼", "皓", "可信", "体贴", "芊眠", "翩然", "刚正", "活泼地", "鼓舞人心的", "可行", "必要", "雅俗共赏", "恰好的", "精密", "客气", "情深", "不离儿", "动态各异", "足月", "善举", "皎洁", "千恩万谢", "劼", "言语流利", "生机勃勃", "万能", "怡然自得", "发达", "喜悦", "善辩", "俊丽", "显而易见", "支援", "尤异", "稚弱", "皆大欢喜", "自由自在", "使人首肯", "求新", "祭拜", "兴盛", "蜜", "芳香的", "适当的", "祯", "堂皇", "欣然地", "似天使", "谢谢", "可意", "良", "不成为问题的", "平整", "逻辑", "简便", "坦直", "精干", "疼爱", "明窗净几", "妩", "悲怜", "招待周到的", "光灿", "高姿态", "震古烁今", "感人", "安定", "惊喜", "健康", "百炼成钢", "宁静的", "带有灵感的", "机智", "赤胆", "简短", "深透", "雅静", "甜蜜蜜", "谬奖", "有创造力", "解除武装", "知道", "确有其事", "恨不能", "无疑", "称颂", "无恙", "可信任", "垂涎", "实用", "壮丽雄伟的", "引人瞩目", "究其实", "尽可能", "庆祝", "和蔼的", "平等", "有特色", "有鼻子有眼", "吉祥", "一流", "美不胜收", "倾向", "流芳后世", "好端端", "高处", "学而不厌", "急", "绚", "做得好", "认可", "齐刷刷", "机敏地", "熠", "和洽", "清正", "说妥", "慈善", "从容不迫的", "洋房", "俊", "慈", "细致", "繁盛的", "好", "戒除", "热力", "妒忌", "无懈可击的", "甘醇", "慈祥", "娉娉袅袅", "不屈服的", "方便的", "博爱", "正大", "轻手轻脚", "满口", "有血气", "有力的", "白", "施恩", "乐观的", "向着", "踌躇满志", "供奉", "强悍", "彪悍", "精致的", "不无道理", "明快", "应准", "甲级", "直截了当", "无裂缝的", "大喜若狂", "熟透", "炯炯", "吸引人的", "温顺", "明畅", "秩然不紊", "同意", "平静", "悃", "飒爽", "香的", "确实的", "彪炳史册", "道德的", "和睦", "温柔", "机灵的", "感激", "生产", "腾跃", "为宜", "好追根究底的", "光亮亮", "乐意", "鞭辟近里", "敬佩", "稳健", "醇朴", "欣然", "缠绵", "似曾相识", "暖烘烘", "有见地", "安适", "喜不自禁的", "最重要的", "欢迎", "健康的", "吃苦耐劳", "基础性", "传奇性的", "机智的", "利他", "补足的", "游刃有余", "防水", "睬", "克服", "最高", "安安稳稳", "足智多谋", "醇和", "属意", "踏实", "狷", "使免除", "赞成票", "轻", "扬扬", "有目的", "光明", "长", "恋恋不舍", "胆大", "死得其所", "梦想", "车水马龙", "可忍受的", "稳妥", "通情达理", "喜兴", "平实", "荣誉的", "恂", "茂盛", "祗", "厚望", "学进", "匀和", "自尊", "杰出的", "美人", "超凡", "寂然", "不泄气", "依然", "经心", "耀", "婷婷袅袅", "精力", "小康", "侻", "有权益", "出众的", "明摆着", "天资", "鸾凤和鸣", "亲切友好", "烂漫", "精致", "五谷丰登", "童颜鹤发", "令人满意地", "希望", "死活", "尽情地", "垂爱", "欣", "揖", "行得通", "疼", "可携带的", "光", "声誉好的", "决定", "快乐", "幽默", "集中", "协助", "相宜", "申谢", "心爱", "按期", "卓荦", "蕻", "手快", "至关重要", "独特", "光芒万丈", "合适", "粗豪", "有益於健康的", "奇迹的", "容光焕发", "有恒", "生动", "急公好义", "壮烈", "安康", "过硬", "合群", "争相", "恰", "杲", "水灵", "金灿灿", "天然的", "顺利的", "娇丽", "客观上", "名副其实", "地位", "珍贵", "暖和", "险固", "安生", "宏伟", "荧", "义务", "精", "婉顺", "匀净", "正直的", "头", "本着良心的", "爱说话的", "懂事", "兴隆", "安然无事", "安稳", "物理", "喜气洋洋的", "过瘾", "光辉", "鹤发童颜", "富有魅力的", "属望", "有才干的人", "披沥", "独出心裁", "天摇地动", "不可缺", "奖励", "欢笑", "忘我", "香甜", "绻", "温情脉脉", "粗犷", "慷慨", "谨慎的", "热情", "改革", "乐善好施", "客气的", "光溜溜", "蕃茂", "周密", "眼热", "安慰", "创造性的", "惠顾", "随手", "亲密", "警", "精妙", "到家", "鼓舞", "祝贺", "不限", "狂喜", "保险", "休息", "澄澈", "冷静的", "称赞", "正面", "劬", "心醉", "洁净", "知足", "心平气和", "坚贞", "义不容辞", "可塑", "质朴无华", "渴望获得", "高标号", "促进", "风度", "赤", "崇", "逼真", "滢", "突出", "芳香", "因材施教", "定", "简约", "雍容华贵", "著名", "无微不至", "伊甸园", "无可指责的", "平坦的", "雄伟", "醍醐灌顶", "秀媚", "崇敬", "修理", "风平浪静", "谐和", "首位的", "勤劳", "安详的", "无可厚非", "平坦", "无可指责", "如期", "睿", "痴恋", "有益的", "甘心", "淳", "对称", "醊", "萦念", "坚定的", "叩首", "珠圆玉润", "光荣", "悠哉", "秋毫无犯", "热门", "和悦", "自来熟", "公", "赫赫", "诚心", "国泰民安", "尊敬", "和蔼可亲的", "分秒必争", "有名", "甘心情愿", "写实的", "肥", "可爱", "甘美", "最理想的", "春意融融", "很多", "乐趣", "答礼", "爱说话", "有戏", "闪烁", "不会腐败", "注重实际的", "分明", "指靠", "乐而忘忧的", "不可思议", "善交际", "虎背熊腰", "有条不紊", "创立者", "智慧型", "单纯", "高效益", "祭", "奕", "雄赳赳", "抖", "直肠子", "莺声燕语", "忍耐的", "弥足珍贵", "帮手", "自告奋勇", "知性的", "一定", "果", "完全", "羞怯", "熠熠", "如画", "久经考验", "合乎卫生", "拔俗", "自由的", "喜气洋洋", "公正", "茁", "硕学", "肯定词", "憧憬", "先公后私", "真心真意", "节省", "慧眼独具", "眼花缭乱", "成就", "珍重", "谢天谢地", "精细", "亲爱", "优秀", "活灵活现", "畅谈", "清", "垂涎欲滴", "美观", "人情", "期盼", "井然有序", "缔造者", "百依百顺", "明白", "幽闲", "有利", "兴趣", "陶醉", "轻柔", "华丽", "容易亲近", "探囊取物", "可行的", "劢", "精准", "才干", "感", "雄辩的", "一元化", "纯朴", "开朗", "毫不动摇", "挺括", "斐", "高洁", "俊俏", "高级的", "优质", "不屈不挠", "持正不阿", "规范", "朴素", "闻达", "在赞成方面", "掏心", "郑重", "动态平衡", "坚持", "堪称一绝", "停妥", "友爱", "有头脑", "信实", "眩目", "连根拔起", "确凿", "爽心", "荣", "显目", "内向", "爱不释手", "健美", "伟", "费心", "歌颂", "天才", "可圈可点", "优惠", "一往情深", "理解", "真心", "快乐主义", "谨严", "神采焕发", "严肃", "坚持不懈", "艾", "珍", "惟命是听", "妥当", "坦荡荡", "嘉", "求实", "鉴别力", "安详", "实际可行的", "一目了然", "福利", "有理有据", "结实粗壮", "莽莽", "古色古香", "关键性", "学以致用", "重要的地位", "精选", "巴不得", "德高望重的人", "丰饶", "相安", "心花怒放", "正经八百", "干净利落", "英雄式的", "便宜", "绝佳", "灵敏", "轻而易举", "准予", "妙不可言", "温和", "绘声绘影", "赞服", "有魅力", "隽永", "不会弄错", "一碗水端平", "老谋深算", "宽畅", "有胆量的", "极力夸奖", "真确", "履行", "寓意深长", "膂力过人", "吉利", "不错", "熟悉", "互敬", "眷爱", "细致优雅", "安逸", "确实", "轻巧", "毫无保留地", "管事", "很棒的", "耿介不阿", "灼亮", "亮堂", "崇尚", "直言不讳的", "一笑置之", "说服力", "秀色可餐", "精良", "有功绩", "凉快的", "清丽", "最有效地", "斌", "迷人的", "杰出", "蓊", "头头是道", "迷人", "秉正", "容光", "五彩纷呈", "震天动地", "满怀激情", "光芒", "忠鲠", "史无前例", "轫", "减轻", "一呼百诺", "迅速的", "竭诚", "有能力", "专门的", "顺当", "玲珑", "不屈不挠的", "有文章", "嘴快", "可口", "有才干", "在情理之中", "饶有兴味", "乐滋滋", "联合起来", "肯于", "褒扬", "有的放矢", "无过失的", "深虑", "英明", "姝", "无异议", "判断力", "极贵重的", "诚挚", "亲昵", "全知全能", "细腻", "不成为问题", "看得上眼", "侠义", "生气勃勃地", "扬眉吐气", "安详", "翊戴", "有干劲的", "万不得已", "聪慧的", "诚挚", "战无不胜", "目光灼灼", "戏剧化", "节俭", "中肯的", "当真", "有效率的", "小有名气", "一心一德", "明朗朗", "按时", "互相密合着", "无疑问", "吉利", "顺利", "晟", "合法", "憨", "婉丽", "百不一失", "高雅", "乐观", "详尽", "文武全才", "葱葱", "防水的", "开通", "吃苦", "花气袭人", "披肝沥胆", "抓", "三思而行", "辟", "追根究底", "完善", "入画", "便利", "中正", "凝聚性的", "双稳态", "清洁的", "有望", "有价值的人", "真理", "深刻", "庆祝的", "适逢其会", "安眠", "瑞", "权威性", "善说服", "感人的", "管理", "有利", "粗放", "赞扬", "觥筹交错", "窈窕", "晶", "好运", "爽利", "富有成果", "多才多艺", "在理", "因地制宜", "贯注", "安逸的", "便利", "符合", "真正", "产量多的", "孝顺的", "清秀", "坦率", "历历可数", "稳定的", "推重", "良好", "优等", "近便", "坦坦荡荡", "撑台面", "饱学", "承情", "值得称赞", "忻", "废寝忘食", "精神矍铄", "推崇", "鹄望", "很棒", "好吃的", "强壮", "巴结", "宝", "活力", "善良的", "历历", "莫测高深", "赞叹", "欢蹦乱跳", "帮助脱离困境", "斗胆", "自豪的", "不懈", "肥美", "方便", "刚劲有力", "精确", "轻松的", "僄", "道德崇高", "安和乐利", "俭", "油光", "端方", "义", "引人注意", "恭贺", "刻苦", "灵巧", "美味可口", "竦", "无忧无虑", "有益健康的", "可以接受的", "公平的", "忘乎所以", "备细", "富实", "勾魂摄魄", "送往迎来", "启发", "敏锐的", "有见识", "入神的", "有助的", "企慕", "奖励", "扎眼", "匀称", "善行", "感恩", "独有", "沉鱼落雁", "熟识", "使平静下来", "可信赖性", "拜贺", "可取的", "好追根究底", "无污点的", "打趣", "电贺", "不落俗套", "兼顾", "震撼人心", "浪漫的", "美丽", "坦白的", "静悄", "稳", "经回火後具有的韧度", "丰腴", "互相密合着的", "常", "入眼", "绕圈子", "学习", "乐陶陶", "安命", "祝愿", "有智慧", "工整的", "合意的", "义务", "娇", "增进", "身体结实", "冀", "留心", "赞扬的", "雅量", "飞黄腾达的", "有意义的", "缜密", "扎扎实实", "油亮", "慎虑", "明了", "直", "正派", "大名鼎鼎", "执着", "简单明了", "放之四海而皆准", "不忍", "幸福", "认同", "振奋", "划时代", "繁荣的", "真率", "犒劳", "漂亮的东西", "修明", "称赞", "飘飘欲仙", "朝拜", "宏", "无忧无虑的", "谦恭有礼的言辞", "崭", "美梦", "称愿", "令人钦佩的", "自尊", "颖", "实至名归", "释放善意", "相称", "兴旺", "不慌忙", "噪声小", "沉寂", "切题的", "爱慕", "显", "夸奖", "免费", "老老实实", "笃实", "来得", "上赶着", "别具一格", "典型性", "丰富的", "事实胜于雄辩", "来者不拒", "不含糊", "连贯的", "入迷的", "既往不咎", "肫", "幽娴", "明显的", "迷人", "饶有余韵", "名誉", "把细", "洪", "老练", "敬", "抒情", "好心好意", "生龙活虎", "多产的", "上好", "实则", "特级", "天真", "敲边鼓", "正规的", "满", "烧高香", "可乐", "骠勇", "绮", "痴心不改", "富饶", "胆量", "端正", "嘻嘻哈哈", "不自私", "特许", "灵快", "和蔼", "活泼的", "娇美", "经验丰富", "准确无误", "清香", "辉耀", "专心致志", "专属的", "答谢", "高兴的", "翩跹", "细密", "大公无私", "滑润", "坚如磐石", "合拍", "凝神", "强大", "景气", "松心", "吉利的", "声誉好", "坚定不移的", "细腻的", "声誉", "拜服", "声望", "可敬重的", "富於的", "心直口快", "勤奋", "执著", "清馨", "最理想", "壮丽", "娇柔", "实心实意", "有贡献", "留情", "吃醋", "合作", "需要", "千真万确", "标准", "自足", "井井有条", "正当年", "美感", "合适", "安宁", "升平", "优裕", "济事", "高质量", "利口", "准点", "均衡", "泰然处之", "贴边儿", "稀少的", "崭新", "最新", "心口如一", "正确", "不畏艰险", "馥郁", "保准", "志哀", "精明的", "喝彩", "风雨无阻", "无奢望", "不在话下", "引人赞美的人", "小心的", "不屈服", "给...留面子", "上品", "责任重大", "忠良", "呱呱叫", "肃静", "牢靠", "好心", "贵族的", "姣美", "从头到底", "清一色", "顺从的", "斯文", "仁", "剽悍", "刚硬", "坚定", "皞", "潜心", "有案可稽", "清澈", "灯火通明", "柔婉", "爽目", "异彩纷呈", "站得住脚", "毅然的", "中用", "经济", "冥", "明火执仗", "济", "豁免", "有用", "狂热", "铁", "俘获", "千娇百媚", "一语双关", "饶有兴致", "灵透", "健壮", "明晰", "精精神神", "负有义务", "千方百计", "伦理的", "利", "合掌", "完好如新", "优渥", "中看", "守法的", "金闪闪", "心动", "友善", "诱人", "道理", "轻薄透明", "袅娜", "巧妙", "娆", "酣畅", "荧荧", "锋快", "好奇", "鲜", "奖", "洋洋", "可喜的", "清切", "简练", "殷勤", "无所不知", "光亮", "完美", "侠义的", "有功绩的", "深藏若虚", "鞠躬", "细心", "乐嗬嗬", "莹白", "醇", "亲切", "还礼", "烨", "说好话", "有决心", "顒", "适宜", "精练", "爱护", "正统", "老辣", "唯命是听", "特等", "易办的", "应承", "至尊", "活泼", "牢牢", "寓意", "路人皆知", "润", "安定", "活跃", "才智", "喜上眉梢", "热中", "喷喷香", "完整", "以期", "有势力", "康泰", "贴题", "专一", "多智的", "宁静", "至诚", "刺眼", "尊崇", "滑溜", "激赏", "奉", "容忍的", "垂念", "口角春风", "受锺爱", "形象地", "荣幸", "值得称赞的", "心细", "清理", "意欲", "有利润的", "举足轻重", "好客", "毫无问题", "精力充沛", "忺", "力透纸背", "爱好和平", "幸运", "敏感的", "入微", "好上加好", "掌握", "绚烂", "富足", "实意", "大红大紫", "柔美", "根深柢固", "芬芳的", "至高", "乐意地", "殷实", "学成", "郑重其事", "精彩纷呈", "秀慧", "玄", "慈善的", "平安", "批准", "上等的", "温馨", "养活", "血气方刚", "显耀", "服从的", "人味", "美味", "亮堂堂", "怜悯", "注意的", "欢腾", "饶", "真实的", "高大", "心诚则灵", "精粹", "醉人", "有血有肉", "明了", "独一无二的", "英俊", "逗人", "讲礼貌", "有义务的", "灵敏的", "推", "安祥", "明丽", "入魔", "谦逊", "蔼然", "才略过人", "刚健", "不含糊", "可忍受", "值钱", "疯狂", "有感觉", "形影不离的朋友", "热诚", "谦顺", "顶礼膜拜", "不懈怠", "高尚", "馋", "富可敌国", "华", "茁壮", "灿烂", "面熟", "恒量", "品味", "谨慎", "深入人心", "朝气勃勃", "实实惠惠", "道不拾遗", "大方", "有知觉的", "老当益壮", "昭", "浅", "学好", "快活", "合格", "健", "渊深", "恋爱", "波澜壮阔", "空前绝后", "内向型", "勇气", "彪壮", "用心", "赫然", "虔诚", "虔敬", "无敌", "亮亮堂堂", "嫉妒", "没有阻碍", "有门儿", "温润", "实在", "的确地", "圆满的", "俱佳", "机会", "恰好", "有权力的", "脆生", "顺顺当当", "柔顺", "卫生", "家给人足", "赞赏", "祭奠", "名特优", "足够的", "批准", "耿耿", "独有的", "强壮有力", "善说服的", "高雅简朴", "抒发", "优美动听", "至上的", "自在", "感激涕零", "后生可畏", "飘飘然", "乖巧", "有良心", "灵活", "娉", "惬意", "充满深情的", "实际可行", "有权益的", "平平静静", "无可置辩的", "文武双全", "有意思", "有智慧", "昭然", "幽静", "至高无上", "无畏", "崇高", "直截", "落拓不羁", "香甜", "宽大", "重视", "横心", "敏捷地", "纯洁", "期许", "合乎逻辑的", "深思", "闭月羞花", "体谅", "实用性", "心明眼亮", "泱泱", "标准的", "老而弥坚", "朴直", "超级", "恭恭敬敬", "能干", "慎重", "净", "期待", "不惜", "沉着", "辉煌", "想像", "美的音乐", "好声好气", "唯命是从", "机灵", "攻读", "切题", "巧", "审慎的", "心肠软", "消遣", "清除", "憨实", "冷静", "宓", "宽", "提升", "粗实", "文静", "雄辩", "开阔", "坚固", "满足", "醇浓", "高人一等", "婉", "钟爱", "较好", "无可置疑", "神气活现", "奖罚分明", "超俗绝世", "猎获", "甜滋滋", "合法的", "明灿灿", "亲热亲热", "慈悲的", "行善的", "精选", "想", "通权达变", "要", "渴想", "愉快", "动平衡", "刚直不阿", "妥切", "神气", "和风细雨", "特出", "脆美", "有爱国心", "知情达理", "浑俗和光", "怀", "完满", "恭喜", "来神", "光鲜", "忌", "金城汤池", "可靠的", "流畅的", "婵蝉", "绝妙", "有确实根据", "坚定不移", "虔信", "纯正", "珍贵的", "灵巧的", "虔敬", "味道鲜", "一丝不差", "打心眼里", "稳重的", "太太平平", "够水平", "壮阔", "和", "骨鲠", "匀整", "不简单", "锦", "卫生", "妥贴", "不凡的人", "洋洋得意", "憧憬", "思恋", "恰当地", "写实", "踏实", "老马识途", "光明的", "会", "丰实", "实", "兴高采烈", "鬼", "爱不忍释", "醋意大发", "去除", "畅谈的", "可称赞的", "大而全", "谈恋爱", "锻炼", "望眼欲穿", "十分满意", "知罪", "健步", "灿", "有智慧的", "朴素", "乐天", "钧", "秉持公正", "忠厚", "变好", "庄重", "真诚", "不动摇", "轻盈", "精密的", "欢悦", "无瑕疵", "沈着", "赫赫有名", "不遗馀力", "甜蜜", "努力", "敦厚", "表彰", "标致", "名声大振", "通天", "吉祥的", "赚钱", "晃眼", "坚硬无比的", "出色的", "天遂人愿", "摇头晃脑", "可信任的", "生产多的", "赳赳", "嘻嘻", "变通", "勤勤恳恳", "称心", "真性", "乐", "宽阔", "均匀", "稀奇", "心旷神怡", "康健", "学识渊博", "洋溢着幸福", "尽兴", "虔敬的", "哈", "肝胆过人", "心甘", "唯唯诺诺", "志气", "谦恭", "晓事", "活便", "实心眼儿", "透明", "神圣的", "认", "特大的", "有品格", "祥", "绵和", "较真儿", "在行", "臧", "太好", "确当", "文文静静", "不苟", "奥博", "亭匀", "宏伟", "含笑", "相宜", "兴高采烈地", "百折不回", "方便", "毅然", "充足", "愉悦", "如意", "顶刮刮", "悦", "不屈", "酹", "希望", "独具只眼", "省事", "迓", "和颜悦色", "大快人心", "芃芃", "详尽的", "熊腰虎背", "从头至尾", "通", "逊", "静悄悄", "面善", "纯熟", "接受", "充足的", "宽容的", "有礼貌", "春风满面", "独到", "彪炳", "获得", "含蓄", "温柔", "受锺爱的", "一笔一划", "据实", "宜人", "煊", "理会", "高瞻远瞩", "稀少", "妒羡", "超群绝伦", "公平地", "敬慕", "赞美", "清洁卫生", "美的事物", "依旧", "最高级", "坦直的", "旗开得胜", "倾国倾城", "凝聚", "坚定不移", "无刺激性的", "不可否认的", "和蔼可亲", "完备", "决定", "娇艳", "痴", "赞慕", "坦率的", "安谧", "使固定", "涵蓄", "滑天下之大稽", "蔫不溜", "邃", "有思想", "合宜", "愚公移山", "不知疲倦", "壮观", "受欢迎", "喜乐", "一步一个脚印儿", "觊觎", "天姿国色", "思念", "有益", "细巧", "满载而归", "可", "骁", "无异议的", "风光如画", "壮观", "行之有效", "奋斗", "令人神往", "从头到尾", "道谢", "耐性", "萧洒", "吉", "适性", "宜人的", "合法性", "高明", "苦修", "在乎", "创造力", "品性端正", "最重要", "精确性", "有勇气", "法律的", "实在的", "当然", "晶莹剔透", "使缓和", "着迷的", "有威信", "庄严", "明亮的", "与有荣焉", "联合", "正式的", "决心", "叩", "好过", "开绿灯", "浑厚", "了不起的", "写实地", "革命", "洗练", "入神", "同等重要", "优异", "体谅的", "在意", "友", "耳闻目睹", "蔫不悄儿", "苦口婆心", "不苟言笑", "有能力的", "调停", "敬爱", "招待周到", "礼节性", "满意地说", "正确地", "有天才的", "嘟嘟", "节俭", "考虑", "奖品", "多情善感", "免除的", "完美无瑕", "慈悲", "尚", "如醉如痴", "迅速地", "宽厚", "富有魅力", "音调优美", "有趣", "无髒污的", "神勇", "有远见", "得到", "匠心独具", "万全", "需", "崭新的", "嬖", "妥", "迷人的美", "决然", "学进去", "表示赞成的", "璞玉浑金", "秾艳", "自得其乐", "可了解的", "速效", "有说服力", "皎", "一板正经", "有始有终", "疼惜", "敏感", "一如既往", "悲壮", "值得注意", "灿然", "恳挚", "枝繁叶茂", "喁", "拍手称快", "勃", "良性", "端端正正", "简单化", "美好", "圆熟", "起敬", "不大离儿", "乐悠悠", "温文儒雅的", "伶俐的", "风风火火", "赫", "昌明", "天使般的人", "香喷喷", "引以为荣的事物", "低价", "贞洁的", "有才智", "的确", "三下五除二", "盯住", "欢洽", "清廉", "丰满", "宽宏大量", "魅人", "中", "实际", "一级", "奠祭", "安恬", "民主", "尊重人的", "漂亮的", "铁心", "节俭的", "明确", "无变化", "酷好", "清纯", "大无畏的", "协作", "愉快地说", "使相等", "欣喜", "空灵", "幽默感", "漂亮地", "决绝", "通畅", "花样翻新", "发觉", "毕恭毕敬", "祀", "气吞山河", "敞开", "清秀的", "爱国心", "慈祥的", "超绝", "同情", "懂行", "利害攸关", "姹", "音乐", "老练的", "得要领", "恰当的", "实质上", "合作的", "无瑕疵的", "晴朗", "羡慕", "快刀斩乱麻", "安安静静", "挚诚", "灼然", "红", "花团锦簇", "称赏", "圆柔", "符合要求的", "钦佩", "欣幸", "调剂", "许", "称誉", "虔", "恋", "创造性", "惬", "玄奥", "慈悲为怀", "甜滋滋", "雅正", "较真", "正式批准", "指望", "皎白", "看得起", "有权", "愉快地", "酷爱", "擅场", "有效", "眼明手快", "不武断", "光荣的", "普天同庆", "安静", "切实的", "齐备", "阔", "令人满意", "有心眼儿", "心醉", "明亮照耀", "性命攸关", "舒爽", "大慈大悲", "非凡", "医治", "逼真的", "求真务实", "靖", "心甘情愿", "开拓", "喜形于色", "完美", "肯定", "值得崇拜", "值得向往", "无容置疑", "茂", "轻快", "恰到好处", "并茂", "安静的", "灿亮", "原封不动", "光彩夺目", "感同身受", "威武", "甘美多汁", "物阜民丰", "清醇", "亲善", "关键", "应", "美妙", "倒向", "豪华", "纪念", "叱咤风云", "悬赏", "价值千金", "合乎逻辑", "练成", "赤忱", "得天独厚", "懔", "可钦佩的", "耐用", "豪放", "半透明", "最高的", "明面上", "分文不取", "刚劲", "感人", "哲人", "有信心", "富饶的", "平心静气", "重", "康", "想像力", "坚强的", "堂堂正正", "尊重", "正直", "稽首", "一视同仁", "夥伴", "感谢", "刻苦的", "振奋人心", "高等", "始终不懈", "甘愿", "能懂", "拍手叫好", "花", "治疗", "知书识礼", "担负", "坚实", "善良", "谦卑", "讨喜", "勤奋", "销魂", "安好", "耐人寻味", "有利的", "迎候", "可取", "熟巧", "和睦", "上流", "贤淑", "期待", "虚怀若谷", "驯善", "建设性", "敏悟", "安安稳稳", "守时间", "过", "优胜", "团结", "刚毅", "神志正常", "油光锃亮", "忠心", "能生产的", "权宜", "淘气", "秀外惠中", "理智", "好办法", "工巧", "会心一笑", "心宽体胖", "喜", "认真", "品行", "巧夺天工", "清楚的", "稳扎稳打", "直来直去", "和善", "萋", "有方", "仪态高贵", "欢迎的", "免费", "天衣无缝", "爽朗", "冒尖", "留心", "气度不凡", "痴狂", "不犹豫的", "惬意的", "权变", "反哺", "施礼", "生产多", "郁", "锺情", "楚楚可怜", "容易", "明亮亮", "精湛", "硬棒", "技高一筹", "性情温良", "顶礼", "期盼", "舒坦", "允", "留神的", "郁郁苍苍", "高看", "光亮", "活泼", "博雅", "平等", "下饭", "称叹", "膀大腰圆", "和蔼", "有光泽的", "获利的", "多福", "澄清", "优越", "坚决", "合理", "调和的", "脆亮", "灵便", "亮锃锃", "较好者", "铮", "称心如愿", "赞许", "敏捷", "煊赫", "动人心弦", "和和气气", "善意的", "春风得意", "至关紧要", "建设", "乐见", "明朗", "人来人往", "滋润", "拳拳", "多快好省", "奇妙", "配得上", "夤", "智", "贤", "雄姿英发", "足智多谋", "权益", "葱茂", "欣慰", "豁然", "纤细的", "诗意", "其乐融融", "惺", "可携带", "不容置疑", "合情合理", "宽大的", "实际上", "同情心", "酬谢", "奖赏", "神魂颠倒", "欢欢喜喜", "高层", "欣欣然", "忠诚", "有节制", "其乐无穷", "没弄脏", "老成练达", "瑰丽", "有能力", "优质", "极其流行", "感谢的", "值钱的", "有棱角", "优厚", "茁壮成长", "严正", "雅", "一贯", "适度", "大", "豆腐心", "美貌", "珍爱的", "气象万千", "浃", "重要性", "奠基", "厚道", "好意", "富有", "劳苦功高", "无辜", "朗", "敬爱", "纯粹", "坚固耐用", "用功", "儒雅", "暖和的", "轻快的", "博学多能", "国色天香", "嘿嘿", "直心眼儿", "着想", "谦卑", "玮", "侧重", "才气", "多产", "到", "生气勃勃", "文雅", "详明", "生杀予夺", "协调", "麻麻亮", "谦", "激进", "烁亮", "多智", "宠幸", "一若以往", "充沛", "各得其所", "蓬勃", "滑", "光彩", "帮助", "繁荣富强", "不任性", "清楚易懂", "行", "用功", "集注", "安如磐石", "勤勉的", "泠泠", "万夫不当", "极好", "精明强干", "头面", "坚忍", "平稳的", "首屈一指", "有益", "路不拾遗", "尽", "喜欢的", "手舞足蹈", "仪表堂堂", "首位", "专挚", "充满深情", "履险如夷", "翘盼", "颖慧", "不凡", "稀罕的", "上相", "支柱性", "平", "聪颖", "亲热", "言之有理", "在意", "快慰", "超好", "精神抖擞", "噪声小的", "持平", "带来福气的", "澹泊", "根本", "快", "施舍", "玄远", "毫不含糊的", "显达", "目光远大", "菲菲", "英明的", "矫正", "甜点", "成器", "绝了", "知趣", "适用", "珍贵", "显见", "必备", "向...倾斜", "一字不差地", "谦虚", "金风送爽", "有礼", "如实", "强大的", "开采", "敏捷", "直心眼", "艳羡", "合度", "大功率", "汹涌澎湃", "天堂", "服服帖帖", "有教育意义的", "奇货可居", "健美的", "热诚", "状况良好", "噲", "灵巧", "说明", "有帮助的", "慈善", "森然", "舒舒服服", "秾", "生花妙笔", "非常耐久", "固守", "蓬勃向上", "真诚的", "健朗", "并重", "兴冲冲", "灼然无疑", "犒", "菲", "周到的", "脆响", "好笑", "值得尊重", "教养", "容", "卫生的", "精细的", "精神饱满", "殷富", "无华", "可经营的", "晰", "花香鸟语", "善於经营的", "卓跞", "绘影绘声", "澄", "饶爽", "脆", "素洁", "蔼", "起作用", "舒适", "无比的", "脚踏实地", "无可訾议", "灵敏性", "够意思", "谐", "典型", "手不释卷", "首要", "法定的", "自信满满", "渴慕", "会心", "劲", "热热闹闹", "明智", "有助益的东西", "吸引人的事物", "英明", "讨人喜欢", "显赫", "半公开", "焕", "训练有素", "照准", "赞叹不已", "丰茂", "秉公", "妥善", "肯定", "小心", "卓越的", "财产", "别开生面", "牢", "直截了当", "工整", "有财产的", "值得崇拜", "神妙", "欢庆胜利", "秀美", "娴熟", "新鲜", "消散", "便", "名声大", "花枝招展", "革新的", "有知觉", "劭", "正大", "短平快", "认了", "艳", "狂喜的", "温情", "挑眼", "姣好", "舒快", "璨然", "有天赋的", "热热闹闹", "紧要", "留神", "聪颖", "欢乐", "偏袒", "陶然", "能实行", "福气", "出色", "博学多才", "祺", "小天使", "台面上", "眼光远大", "强壮", "纤细", "见微知著", "得势", "妖媚", "轻快", "物廉价美的", "点头", "辉煌的", "理性", "轩昂", "颂赞", "理想", "可歌可泣", "值得尊敬", "芬香", "瞩目", "保释", "明确", "引人入胜", "有据", "苒", "通顺", "正宗", "正式", "自动", "牢固", "娴静", "轻健", "如愿以偿", "安全的", "有识", "优胜的", "欢", "生情", "顾全", "烈", "刚好", "沉毅", "光灿灿", "欢天喜地", "莹莹", "主持", "过关", "冀望", "寂", "至善的", "甜", "讲求", "金晃晃", "始终如一", "勇敢", "精致", "尖利", "良性", "地动山摇", "有胆量", "玄之又玄", "赞羡", "富饶", "额手称庆", "浩荡", "富裕的", "信服", "辛勤", "恬", "赞许", "能充分理解", "为傲", "深刻的", "可亲", "高兴", "锦簇花团", "简明", "刚", "内敛", "现实", "无误", "狠", "清彻", "懋", "享有", "优秀", "推荐", "光彩照人", "适合的", "繁花似锦", "多姿", "谈笑", "扬扬自得", "富足", "明理的", "老实", "三思而后行", "依允", "坚持不懈", "宽容", "大胆的", "赤色", "晴朗的", "仪态万方", "有伸缩性", "坚持不渝", "歆", "成功", "多幸褔", "时机成熟的", "持重", "魅力", "实际", "明了的", "自动", "卓越", "全面的", "直率的", "高贵的", "畅达", "勇敢的行为", "娓娓动听", "专家", "谈笑风生", "问心无愧", "财富", "合当", "旗帜鲜明", "好心情", "免费的", "完美无疵", "优胜", "乐呵呵", "蔫不出溜", "明亮", "杰出", "有乐趣", "温驯", "看上眼", "建设性的", "正统", "鼓掌", "管用", "基部", "坦诚相见", "适时", "壮美", "风流", "粲", "货真价实", "醉心", "接济", "优良的", "由衷的高兴", "精通的", "一等", "羡慕", "改进", "悍", "眷念", "忠贞", "端", "记实", "有含义的", "感激的", "名牌", "匪夷所思", "狂乱", "发展", "在心", "快快乐乐", "当然的", "心仪", "易管理", "天经地义", "哀艳", "可敬", "匀", "值得信赖", "时新", "浏", "吉祥", "传神", "顶用", "笔直", "特别", "放下武器", "严肃性", "飒爽英姿", "开放", "好吃", "嬉戏", "干练", "高标准", "淳朴", "怀念", "别具匠心", "进步", "美丽", "忠实", "思", "痛快地", "富", "身心健康", "毫发不差", "首肯", "昂昂", "乐园", "有用", "使人首肯的", "健壮的", "雄伟", "产量多", "关心", "耐穿", "初生牛犊般", "泰然自若", "超等", "适当", "珍异", "德高望重", "学力宏赡", "通明", "不可缺少", "跟脚", "精选的", "宏伟的", "心情愉快", "均衡", "随便", "尽孝", "妥当", "踏踏实实", "忏悔", "溜", "谈言微中", "整整齐齐", "翕", "极度高兴", "使人愉快", "伟岸", "纲领性", "准期", "出乎意料", "苦思", "温柔亲切的", "自不待言", "罕见的", "值得羡慕", "心荡神驰", "睆", "刚毅的", "仁慈的", "严谨", "好好", "祈盼", "补台", "志在千里", "容光焕发的", "疼爱", "黑白分明", "无害", "密", "铁案如山", "自豪", "廉明", "山清水秀", "黄熟", "准备", "似乎有理", "乐事", "明白", "确信", "恳切", "发噱", "口紧", "勇敢的", "固守的", "均等", "倜傥不羁", "光亮的", "跪叩", "奋发", "自得其乐", "手巧", "相容", "赏赉", "不无小补", "最好", "戛戛", "坚固耐用", "美化", "低廉", "忠实的", "服帖", "有道德", "讨好", "分工合作", "好吃", "山明水秀", "轻松", "显豁", "盛赞", "周到", "孳", "利润", "默认", "怜悯的", "粼", "嗬嗬", "充裕", "歆慕", "得当", "大方的", "昂然", "令人惊奇的", "无先例", "敏锐", "手艺", "睿智", "聪悟", "易管理的", "真真", "细颗粒度", "井然有序的", "心旷神怡", "蕃", "博闻", "宽恕", "抬举", "智慧", "给脸", "体面", "不骄不躁", "身手不凡", "满怀", "风景如画", "娇滴滴", "时尚", "适当地", "无敌的", "互惠", "宠爱的", "有教益", "高级", "溜光水滑", "舒心", "健康美", "绥", "爱人如己", "大度", "贪", "粼粼", "能实行的", "顺眼", "戾", "宁", "短小精悍", "剔透", "有教育意义", "看中", "婷婷", "要言不烦", "坚韧不拔", "安逸", "成功的", "珍爱", "自立", "理想化", "平安无事", "安适的", "有天资的", "细针密缕", "诱人", "愣是", "毫厘不差", "富幽默感", "公开", "万无一失", "颂扬", "开发", "绝无错误", "有雅量", "参谒", "踊跃", "出迎", "豪迈", "达观", "铁杵磨成针", "明晰的", "念", "显明", "无边无际", "富丽", "表观", "匀称的", "有根有据", "心灵手巧", "满怀豪情", "率直的", "乐子", "见多识广", "威严的", "明码", "很多的", "婚生", "爽快", "亘古未有", "无人不晓", "铮铮铁骨", "果决", "敏悟", "守法", "圣", "抓紧", "努力解决", "娇娆", "天才", "欣羡", "报答的", "心宽", "资源丰富的", "怜惜", "时机", "经得起检验的", "正大光明", "神", "贵重", "机灵", "睹物思人", "称快", "没有搀杂", "无错误", "亮", "赏识", "值得赞美", "逍遥", "突破性", "高风亮节", "勇武", "合宜", "心胸开阔", "表现突出", "荦荦", "消魂", "值得拥有", "热忱的", "轻灵", "挢", "令人喜悦的", "痴痴", "诺言", "良心的", "非常大方", "大吉大利", "鲜明", "啧啧称赞", "平安", "欲", "当仁不让", "博大", "清晰", "对号", "文明", "不争", "喜冲冲", "琳琅满目", "枭", "免票", "坚固耐用的", "单一", "锖", "豪情满怀", "知足", "好生生", "喜不自胜", "清楚", "华丽", "进步", "华丽的", "无欲", "把稳", "推进", "风趣", "白纸黑字", "觊", "金贵", "凿", "报恩", "互爱", "干干净净", "非常合适", "易懂", "甘味", "不看僧面看佛面", "无所畏惧", "高山仰止", "谨", "清新淡雅", "升起", "热心肠", "生动的", "尖端", "心疼", "工致", "狂热赞扬", "结结实实", "自如", "毅然决然", "雅观", "耐用", "放在心上", "有才干的", "自勉", "谨饬", "霁月光风", "饶富", "真正的", "得力", "芬芳馥郁", "坚强", "走好运", "表里一致", "带劲", "温煦", "婵媛", "有才气", "实施得力", "令人高兴", "果敢", "摆好", "心满意足", "有盼", "随宜", "滟", "前无古人", "美言", "澄净", "脉脉含情", "流利", "渴求", "安身立命", "妍丽", "欢声雷动", "简要", "神童", "推戴", "荦", "风姿绰约", "极神圣", "慎重的", "葱郁", "善意", "不可否认", "誉", "点头哈腰", "本着良心", "法律", "持久的", "才华横溢", "公正客观", "醇香", "可实行", "和软", "真格的", "淋漓", "达", "淋漓尽致", "英勇", "不会弄错的", "敦敦实实", "娱乐", "钢铁", "赞同", "雄峻", "明晰", "大笑", "讲究", "得意", "平心静气", "如花似玉", "有干劲", "见所未见", "怃", "无可责难的", "高效", "好心肠", "睿哲", "固若金汤", "合群", "摇头摆尾", "具有历史意义", "妍", "不自私的", "贤达", "光芒四射的", "愣要", "得意扬扬", "无价", "清晰明了", "令人难忘", "贱价", "敏锐的感觉力", "变得较好", "博闻强记", "谦恭", "灵活机动", "柔韧", "洋溢着幸福的", "理所当然", "详备", "开明", "渴念", "热切地", "中和", "直爽", "真挚", "合口", "实质性", "兴高采烈的", "清醒", "必需", "精打细算", "不为已甚", "创造性", "俏丽", "乐而忘忧", "嘻嘻哈哈", "壮丽的", "阒寂", "情意恳挚", "伦理", "表示赞成", "明面", "来劲", "热和", "柔情", "快乐", "得奖", "周到", "秀气", "祥和", "上照", "坦实", "偏爱", "保存良好", "菀", "情真意切", "喝彩", "改头换面", "清净", "大胆泼辣", "优柔", "人山人海", "精心", "效率", "胜任", "通俗易懂", "广远", "芊芊", "像话", "最优秀的", "软", "蓬勃", "准确的", "逼真", "揄扬", "媢", "纤巧", "开心", "纯真", "公开", "高效能", "一专多能", "不加渲染", "浩", "孝敬", "使用方便", "纯种", "排列整齐", "高兴", "动人心魄", "可信的", "凯旋的", "新潮", "主动的", "令人高兴", "一笔不苟", "举止大方", "灿烂夺目", "天真的", "抒解", "从权", "道道地地", "使人敬畏", "裒", "有责任的", "取悦", "富裕", "机敏", "潜心於", "清通", "不受约束的", "顺", "解除", "搀扶", "眼红", "持之有故", "舒服的", "艺术", "确", "随心", "剡", "英姿飒爽", "善理家的", "平静", "优美地", "天赋", "有趣", "正当", "文质彬彬", "先决", "上等", "合胃口", "熟", "有判断力的", "值得纪念", "乐观", "慢条斯理", "容易", "无所顾忌", "大量", "出手不凡", "心宽", "行善", "微妙的", "开放的", "有判断力", "芊绵", "有同情心", "瑰玮", "生气勃勃", "时髦", "掬诚", "让步", "不难", "鹤立鸡群", "核心", "肃穆", "好运的", "声势浩大", "干脆利落", "风光旖旎", "实惠", "承蒙", "俊秀", "精确", "礼赞", "万众瞩目", "守岁", "花繁叶茂", "遂心", "整齐", "适应", "正中下怀", "凯旋", "自助", "飘洒", "创立", "宛转", "下酒", "高精尖", "蔫不唧儿", "匀乎", "美", "凉爽", "有爱心的", "自然", "扶疏", "神志清明", "义无反顾", "可喜", "无瑕疵", "确定", "内行的", "欢实", "忍耐力", "乐天", "平展", "新异", "塌实", "出名", "娴雅", "可信赖", "锐意", "古朴", "清楚地", "实现", "苦", "真真切切", "星级", "有节制", "赞成的一方", "关怀备至", "快乐主义者的", "荦荦大者", "指望", "巴", "有吸引力", "玄而又玄", "有文化", "颖悟", "优美", "单刀直入", "雄", "洋溢", "极好", "节节", "恭维", "美滋滋", "急进", "淡泊明志", "特许", "写意", "有教养", "全能", "唇红齿白", "自如", "宽松", "畅快", "殊", "一表非凡", "高强度", "狂热的", "积极的", "祭扫", "爱好和平的", "有耐性", "独创", "诚朴", "古典", "鲜豔", "像样子", "朴茂", "能懂的", "秉直", "芬芳", "亮闪闪", "悠扬", "好说话", "倜傥不群", "恋爱", "入时", "痴情", "曼", "约", "悦耳", "从容", "圣礼", "威风凛凛", "随和", "刚刚", "精美", "中坚", "盛", "拔尖儿", "珍稀", "稍息", "任劳任怨", "有益健康", "彬彬有礼", "向往", "坚挺", "舒适", "高风峻节", "毅力", "便宜", "阳", "兵强马壮", "有保留地", "喜盈盈", "机巧", "堕入爱河", "思慕", "灯火辉煌", "可笑", "目光炯炯", "埽", "仪态高贵的", "贪恋", "头等", "蔼蔼", "站得高，看得远", "显贵", "有声有色", "幽默", "豁", "守法", "潇洒", "爱慕", "增进友谊", "欢庆", "快意", "亲密的", "作为消遣", "清亮亮", "令人羡慕", "敬畏", "偏爱", "站得住", "温和的", "显赫的", "厮熟", "爱人", "无庸置疑地", "挚爱", "拜谒", "言必有中", "甜丝丝", "炅", "胜利的", "真爱", "古雅的", "阳性", "拔尖", "气派", "灵敏", "光闪闪", "引颈企待", "绝对可靠", "要死要活", "抒怀", "溺爱", "固定的", "超凡技术", "期", "绝妙", "甜甜蜜蜜", "得心应手", "渴求", "能干的", "安澜", "无比幸福", "贤明", "有责任心的", "乐在其中", "纯洁的", "沉稳", "显着", "安可", "偏偏", "纤尘不染", "驰思", "轻易", "悲悯", "闻名", "出色", "英俊", "极度高兴的", "谐调", "名正言顺", "漂亮", "不卑不亢", "佥同", "煇煌", "灵活的", "宏赡", "技巧", "嗓子好", "鸿", "明白了当", "有头有尾", "过誉", "生效", "完好", "大无畏", "欢迎", "有眼力", "管事儿", "宏大", "承应", "切实", "妩媚", "和畅", "热点", "建设性", "才艺", "像样", "保护", "无所不可", "思路清晰", "明亮照耀的", "高歌", "照实", "绝对可靠的", "麻利", "靓", "百折不挠地", "安乐", "补足", "心情舒畅", "显着的", "澄碧", "加意", "齐全", "纯一", "春秋鼎盛", "倬", "新奇", "玲珑剔透", "已知", "人给家足", "盼望", "不可思议的", "大有希望", "褒奖", "讴歌", "绰约多姿", "一个心眼儿", "如痴如醉", "垂青", "看车", "柔和的", "聪慧", "心向", "大吉", "逗", "神志清明的", "好受", "最佳", "不可名状的", "甜美", "微言大义", "清静", "有出息", "平允", "感同身受", "风光", "生猛", "恭顺", "耿直", "红得发紫", "便当", "忠心赤胆", "有责任", "悄声", "确定不移", "人格高尚", "赞成者", "个性鲜明", "自信地", "史诗般", "富於同情心的", "雄健", "有价值", "通知", "直觉的", "鼓舞人心", "独立自主", "细心", "说好", "安然", "趣", "天才人物", "顶天立地", "遂意", "含情脉脉", "坚毅", "流行", "秀拔", "有一手", "熟练", "见义勇为", "有礼貌", "浓丽", "恭而敬之", "抬爱", "皮实", "哲", "渐入佳境", "圈定", "无恶意", "特惠", "忠顺", "温情", "最上", "豁达", "天真", "贞", "真确", "坦率", "有同情心", "鸦雀无声", "逸乐", "山摇地动", "性命交关", "仁善", "上镜", "火暴", "心软", "白金", "高深", "创造的", "整洁", "开朗", "好客的", "很有抱负", "直言不讳", "慎", "满腔热血", "栩栩", "安心", "慈悲为怀", "天字第一号", "傥", "放心的", "便利的", "洵", "忭", "和平", "率", "水莹莹", "使用方便的", "娈", "尤", "跹", "冠军", "无忧无虑", "有钱的", "赏识", "旺", "可能", "过得硬", "荣誉", "聪颖的", "节约的", "祝颂", "有味", "当面", "洁净的", "笔挺", "上好", "叩头", "负责", "温暖", "鼓掌欢迎", "达观", "菁", "阳刚", "推许", "间歇", "合适的", "跌荡", "良好的", "安乐", "秀", "标定", "壮丽雄伟", "有权能", "很爽", "慈祥", "光荣", "深刻", "典雅", "理性", "引人深思", "用得着", "赅博", "绚丽夺目", "有权力", "老诚", "适意", "绵甜", "萋萋", "秀色", "风发", "当", "知冷知热", "甘甜", "头脑清醒", "尽忠", "幽凄", "使人敬畏的", "圣明", "有乐趣的", "分寸", "好天气", "率直地", "有分寸的", "是", "夺得", "正道", "催人奋进", "一清二白", "灵巧地", "带修辞色彩", "名贵", "无私", "无庸", "高贵", "俅", "自主", "满心欢喜", "奇妙的", "改善", "恋恋", "期望", "豪爽", "极贵重", "天真无邪", "认认真真", "小心谨慎", "真正", "清越", "有条有理", "自白", "开门见山", "万籁俱寂", "自认", "拥有", "尖锐", "独一无二", "耐用的", "确定", "崇敬", "仁慈", "坚", "严肃", "高雅", "锬", "狂放", "缔造", "出手大方", "太好了", "自由自在", "更优越", "辅助的", "屏气凝神", "沁入肺腑", "有创造力的", "无污染", "惇", "要紧", "易理解的", "泼辣", "拘谨", "一干二净", "贺", "进取", "丁是丁，卯是卯", "奋不顾身", "眼尖", "简便易行", "乐意", "规矩", "独立", "诚恳的", "洁", "看重", "爱打趣", "板板正正", "楚楚可人", "公正的", "绚丽", "才气横溢", "楚楚", "光辉的", "细细", "用心良苦", "达成", "无疑", "斐然", "效能", "火爆", "实用性的", "墩墩实实", "良好", "可实行的", "情有独钟", "积极性", "壮", "尊", "注意", "彬彬", "能生产", "关怀", "忠贞不屈", "本质", "关爱", "毫无疑义", "欢乐", "二话没说", "窝心", "端静", "全力", "物廉价美", "甘愿", "夺魁", "多趣的", "一五一十", "平衡", "油汪汪", "使精细", "浅近", "节制", "极乐", "苦心孤诣", "道德崇高的人", "分析纯", "朴拙", "数一数二", "一帆风顺", "欢娱", "心情愉快的", "情文并茂", "防备", "露骨", "可贵", "不动摇", "有信心的", "声名大噪", "不可或缺", "成熟", "平坦", "良善", "吸引力", "好奇", "满面春风", "笑死罗", "热诚地", "可尊敬的", "酬谢", "活络", "滋养的", "威风", "非同小可", "承诺", "令人满意", "用", "丰腴", "轻车熟路", "天赐", "尽如人意", "如虎添翼", "滑腻", "尽情", "一见锺情", "值钱", "卓然", "允当", "雅观", "直率", "应有", "喜庆的", "值得纪念", "机敏", "经验", "平等地", "不慌忙的", "全身心", "毫不畏惧", "丰", "娟娟", "先人后己", "适意", "精诚", "详悉", "不偏不倚地", "不厌", "合情理", "有条理", "舒服", "友好的", "能吃苦耐劳的", "注重实际", "可尊敬", "合时", "不受约束", "美轮美奂", "眼馋", "夸", "溢美", "惕", "圣洁", "笃学", "俏", "澄明", "和谐", "洋洋自得", "谨慎", "相称的", "气宇轩昂", "欢闹", "被喜爱的", "报喜", "生日快乐", "敬重", "宠", "茁壮的", "诚挚的", "遵从", "无疑问的", "陋", "洗炼", "无畏", "自卑", "欢欣", "富於机智", "自鸣得意", "牵肠挂肚", "有滋味", "夷", "饫", "绚丽多姿", "率直", "心如止水", "地道", "响当当", "嘉奖", "醉心", "热", "和蔼可亲", "不凡的", "细心的", "可敬", "肯定的", "毫发不爽", "哈哈", "精美", "稳固", "喜悦", "舒服", "端庄的", "少不了", "热望", "耐久", "施舍慷慨的", "筋道", "悫", "心慈面软", "妙不可言", "不容怀疑", "简易", "低价位", "玉", "怡和", "强大", "说一不二", "肯顺从的", "勇悍", "友爱的", "良性的", "铁定", "大无畏", "知性", "善心", "红润的", "温良", "表扬", "至上", "交口称誉", "皓月当空", "特级的", "拱手", "凝", "赞誉", "如饮醍醐", "应下", "大方", "坚贞不屈", "拾金不昧", "锦绣", "易如反掌", "灵", "叹", "敞亮", "清澈的", "讲", "胆敢", "韶秀", "悉心", "浑朴", "声名大振", "前所未有", "凉爽的空气", "稳固", "因时制宜", "万古长青", "希图", "寓意深刻", "秩序井然", "好听", "智力", "负有", "好使", "当心"}
HOWNET_very = {"不为过", "超", "超额", "超外差", "超微结构", "超物质", "出头", "多", "浮", "过", "过度", "过分", "过火", "过劲", "过了头", "过猛", "过热", "过甚", "过头", "过于", "过逾", "何止", "何啻", "开外", "苦", "老", "偏", "强", "溢", "忒", "不过", "不少", "不胜", "惨", "沉", "沉沉", "出奇", "大为", "多", "多多", "多加", "多么", "分外", "格外", "够瞧的", "够呛", "好", "好不", "何等", "很", "很是", "坏", "可", "老", "老大", "良", "颇", "颇为", "甚", "实在", "太", "太甚", "特", "特别", "尤", "尤其", "尤为", "尤以", "远", "着实", "曷", "碜"}


#常用停用词
STOPWORDS_zh = {"经", "得", "则甚", "跟", "好", "具体地说", "再者", "～", "再其次", "己", "哪样", "既往", "所在", "！", "咱们", "啐", "不得", "此", "不尽然", "彼", "哪怕", "咚", "设若", "一", "等", "已矣", "乎", "赶", "自个儿", "有关", "鉴于", "凡是", "较", "俺", "来说", "嘿", "不只", "惟其", "依照", "呜呼", "况且", "越是", "譬如", "嘎登", "致", "一来", "）", "极了", "某些", "截至", "请", "为什么", "即", "宁肯", "会", "朝着", "腾", "＆", "其二", "某", "上下", "就是说", "许多", "庶乎", "把", "诸", "每当", "非但", "自各儿", "非独", "连同", "各自", "不若", "逐步", "莫若", "此次", "继而", "还", "打从", "对待", "而况", "还是", "不是", "即便", "哼", "这样", "倘或", "结果", "所有", "如", "过", "人们", "继之", "反之", "只消", "余外", "根据", "下", "吓", "般的", "比方", "咱", "此时", "依据", "哗", "为了", "加以", "果然", "共", "谁知", "全体", "何时", "三", "以来", "呵呵", "无", "甚且", "靠", "罢了", "正如", "们", "处在", "分", "经过", "只", "论", "《", "再者说", "这么", "它们", "什么", "云尔", "〉", "有时", "孰料", "因", "哉", "别管", "本人", "呕", "凭", "某个", "吱", "另悉", "但凡", "分别", "故而", "何以", "旁人", "咦", "都", "甚么", "去", "啊", "其它", "嗬", "才能", "这么些", "基于", "一些", "为何", "照", "由此可见", "这么点儿", "的", "如上", "于是", "用", "后者", "所幸", "某某", "不过", "被", "综上所述", "他们们", "各个", "哈", "孰知", "一则", "也好", "再则", "随着", "而外", "二", "开外", "凭借", "不仅", "除开", "其", "对于", "随后", "非", "到", "一转眼", "呸", "全部", "彼时", "哪个", "除外", "她", "吗", "自家", "？", "甚至", "而是", "又", "只怕", "那个", "这个", "然则", "若", "说", "八", "再有", "尽", "诸位", "这些", "一旦", "随时", "＠", "不妨", "这儿", "呃", "内", "凡", "起见", "来", "由", "不问", "谁料", "这么样", "为止", "难道说", "能", "如何", "所以", "或则", "待", "且说", "地", "就算", "看", "尽管", "乃至于", "按", "本", "那么", "、", "归齐", "抑或", "一方面", "纵令", "据", "以为", "按照", "自己", "嗡嗡", "正巧", "只是", "任何", "别的", "借", "什", "换句话说", "吧哒", "＃", "别处", "此地", "而言", "，", "你们", "同时", "接着", "倘若", "仍", "要不是", "一般", "使", "且不说", "以故", "而后", "月", "是以", "七", "和", "之一", "出来", "那时", "即令", "鄙人", "果真", "秒", "本地", "要不然", "可是", "对方", "哎", "及其", "嘻", "沿", "故此", "就要", "那", "说来", "焉", "个", "来着", "它", "使得", "不论", "恰恰相反", "咋", "嘘", "一何", "即如", "然而", "始而", "只要", "怎么", "他", "＞", "由是", "有的", "倘然", "很", "作为", "哪", "但是", "便于", "与否", "宁可", "本着", "能否", "此处", "连", "由此", "》", "之所以", "更", "以期", "可以", "阿", "望", "各位", "那般", "第", "不成", "哩", "无论", "具体说来", "照着", "而", "不外乎", "何况", "正值", "可", "并", "有些", "冒", "任凭", "冲", "不管", "换言之", "另外", "为", "还有", "关于", "非徒", "又及", "在", "以至于", "就是", "及至", "矣乎", "唉", "︿", "虽说", "之", "向使", "这边", "啦", "嘎", "例如", "巴", "诚然", "仍旧", "我", "至今", "假使", "漫说", "故", "如若", "二来", "哼唷", "其次", "小", "这就是说", "甚或", "总的来说", "打", "后", "距", "要", "别", "如上所述", "在下", "各", "如下", "要是", "边", "如是", "至于", "等到", "什么样", "含", "两者", "等等", "哇", "欤", "莫不然", "再", "您", "就是了", "一切", "归", "宁", "往", "万一", "前后", "哈哈", "着", "这般", "另", "何处", "若夫", "加之", "九", "贼死", "这一来", "出于", "：", "才", "中", "若非", "替代", "给", "甚至于", "因此", "各种", "他们", "啪达", "因而", "今", "进而", "也", "以上", "是的", "呢", "自身", "只有", "虽", "光是", "设或", "｛", "不", "或曰", "几", "设使", "哎呀", "呼哧", "不料", "自打", "因了", "有及", "朝", "（", "向", "嗯", "只限", "即若", "云云", "人", "叮咚", "既然", "比如", "几时", "如同", "兼之", "就", "对比", "既是", "尚且", "该", "俺们", "至若", "那会儿", "咧", "矣", "彼此", "也罢", "呗", "替", "你", "如此", "以及", "四", "即或", "虽然", "每", "继后", "开始", "从", "亦", "自从", "那边", "时候", "及", "而且", "来自", "通过", "些", "岂但", "嘛", "怎奈", "假如", "虽则", "还要", "除非", "那么些", "或者", "用来", "五", "纵使", "尔", "要么", "哪年", "非特", "日", "犹自", "任", "＋", "像", "类如", "以致", "此外", "而已", "曾", "从此", "受到", "零", "我们", "同", "＜", "个别", "儿", "矣哉", "有", "上", "何", "一样", "依", "庶几", "％", "喽", "如其", "呀", "那儿", "呵", "不拘", "其一", "。", "除了", "较之", "＄", "从而", "了", "纵然", "〈", "与其说", "直到", "谁人", "多么", "前者", "倘使", "怎么样", "多少", "与", "以便", "不比", "者", "哪天", "叫", "紧接着", "再说", "之类", "别是", "］", "若果", "不光", "慢说", "其中", "却", "哪里", "嗡", "呜", "；", "总之", "那么样", "这里", "尔后", "譬喻", "她们", "与其", "或", "当然", "固然", "为此", "针对", "那里", "怎么办", "即使", "这次", "［", "咳", "得了", "竟而", "除", "省得", "并且", "只当", "不尽", "时", "这会儿", "啥", "｜", "不特", "甚而", "做", "其余", "除此之外", "当地", "向着", "关于具体地说", "反而", "着呢", "假若", "如果", "嗳", "那样", "不惟", "怎样", "比", "哪边", "由于", "人家", "然后", "哎哟", "自", "对", "赖以", "的确", "唯有", "趁着", "喔唷", "当", "至", "拿", "么", "不独", "哦", "嘿嘿", "别人", "因着", "比及", "可见", "管", "相对而言", "不至于", "介于", "自后", "沿着", "多", "眨眼", "随", "因为", "总而言之", "则", "乘", "不然", "纵", "大家", "另一方面", "已", "是", "宁愿", "要不", "乃", "趁", "犹且", "尽管如此", "离", "不怕", "起", "毋宁", "先不先", "所", "的话", "大", "倘", "本身", "不但", "让", "遵循", "据此", "兮", "尔尔", "既", "他人", "将", "｝", "于", "为着", "前此", "不单", "啷当", "于是乎", "最", "与此同时", "没奈何", "顺", "或是", "别说", "怎", "遵照", "且", "莫如", "首先", "正是", "那些", "诸如", "以免", "在于", "诚如", "哪儿", "否则", "临", "但", "乃至", "以", "吧", "无宁", "简言之", "￥", "这", "若是", "顺着", "反过来", "其他", "哟", "巴巴", "当着", "以至", "六", "谁", "乌乎", "借傥然", "这时", "哪些", "总的来看", "年", "不如", "喏", "＊", "喂", "反过来说", "似的", "总的说来", "此间"}
STOPWORDS_en = {'a', 'about', 'above', 'across', 'after', 'afterwards', 'again', 'against', 'ain', 'all', 'almost', 'alone', 'along', 'already', 'also', 'although', 'always', 'am', 'among', 'amongst', 'amount', 'an', 'and', 'another', 'any', 'anyhow', 'anyone', 'anything', 'anyway', 'anywhere', 'are', 'aren', "aren't", 'around', 'as', 'at', 'back', 'be', 'became', 'because', 'become', 'becomes', 'becoming', 'been', 'before', 'beforehand', 'behind', 'being', 'below', 'beside', 'besides', 'between', 'beyond', 'both', 'bottom', 'but', 'by', 'ca', 'call', 'can', 'cannot', 'could', 'couldn', "couldn't", 'd', 'did', 'didn', "didn't", 'do', 'does', 'doesn', "doesn't", 'doing', 'don', "don't", 'done', 'down', 'due', 'during', 'each', 'eight', 'either', 'eleven', 'else', 'elsewhere', 'empty', 'enough', 'even', 'ever', 'every', 'everyone', 'everything', 'everywhere', 'except', 'few', 'fifteen', 'fifty', 'first', 'five', 'for', 'former', 'formerly', 'forty', 'four', 'from', 'front', 'full', 'further', 'get', 'give', 'go', 'had', 'hadn', "hadn't", 'has', 'hasn', "hasn't", 'have', 'haven', "haven't", 'having', 'he', 'hence', 'her', 'here', 'hereafter', 'hereby', 'herein', 'hereupon', 'hers', 'herself', 'him', 'himself', 'his', 'how', 'however', 'hundred', 'i', 'if', 'in', 'indeed', 'into', 'is', 'isn', "isn't", 'it', "it's", 'its', 'itself', 'just', 'keep', 'last', 'latter', 'latterly', 'least', 'less', 'll', 'm', 'ma', 'made', 'make', 'many', 'may', 'me', 'meanwhile', 'might', 'mightn', "mightn't", 'mine', 'more', 'moreover', 'most', 'mostly', 'move', 'much', 'must', 'mustn', "mustn't", 'my', 'myself', 'name', 'namely', 'needn', "needn't", 'neither', 'never', 'nevertheless', 'next', 'nine', 'no', 'nobody', 'none', 'noone', 'nor', 'not', 'nothing', 'now', 'nowhere', 'o', 'of', 'off', 'often', 'on', 'once', 'one', 'only', 'onto', 'or', 'other', 'others', 'otherwise', 'our', 'ours', 'ourselves', 'out', 'over', 'own', 'part', 'per', 'perhaps', 'please', 'put', 'quite', 'rather', 're', 'really', 'regarding', 's', 'same', 'say', 'see', 'seem', 'seemed', 'seeming', 'seems', 'serious', 'several', 'shan', "shan't", 'she', "she's", 'should', "should've", 'shouldn', "shouldn't", 'show', 'side', 'since', 'six', 'sixty', 'so', 'some', 'somehow', 'someone', 'something', 'sometime', 'sometimes', 'somewhere', 'still', 'such', 't', 'take', 'ten', 'than', 'that', "that'll", 'the', 'their', 'theirs', 'them', 'themselves', 'then', 'thence', 'there', 'thereafter', 'thereby', 'therefore', 'therein', 'thereupon', 'these', 'they', 'third', 'this', 'those', 'though', 'three', 'through', 'throughout', 'thru', 'thus', 'to', 'together', 'too', 'top', 'toward', 'towards', 'twelve', 'twenty', 'two', 'under', 'unless', 'until', 'up', 'upon', 'us', 'used', 'using', 'various', 've', 'very', 'via', 'was', 'wasn', "wasn't", 'we', 'well', 'were', 'weren', "weren't", 'what', 'whatever', 'when', 'whence', 'whenever', 'where', 'whereafter', 'whereas', 'whereby', 'wherein', 'whereupon', 'wherever', 'whether', 'which', 'while', 'whither', 'who', 'whoever', 'whole', 'whom', 'whose', 'why', 'will', 'with', 'within', 'without', 'won', "won't", 'would', 'wouldn', "wouldn't", 'y', 'yet', 'you', "you'd", "you'll", "you're", "you've", 'your', 'yours', 'yourself', 'yourselves'}


#副词
ADV_words = ['都', '全', '单', '共', '光', '尽', '净', '仅', '就', '只', '一共', '一起', '一同', '一道', '一齐', '一概', '一味', '统统', '总共', '仅仅', '惟独', '可', '倒', '一定', '必定', '必然', '却', '', '就', '幸亏', '难道', '何尝', '偏偏', '索性', '简直', '反正', '多亏', '也许', '大约', '好在', '敢情', '不', '没', '没有', '别', '刚', '恰好', '正', '将', '老是', '总是', '早就', '已经', '正在', '立刻', '马上', '起初', '原先', '一向', '永远', '从来', '偶尔', '随时', '忽然', '很', '极', '最', '太', '更', '更加', '格外', '十分', '极其', '比较', '相当', '稍微', '略微', '多么', '仿佛', '渐渐', '百般', '特地', '互相', '擅自', '几乎', '逐渐', '逐步', '猛然', '依然', '仍然', '当然', '毅然', '果然', '差点儿']
#连词
CONJ_words = ['乃', '乍', '与', '无', '且', '丕', '为', '共', '其', '况', '厥', '则', '那', '兼', '凭', '即', '却', '今', '以', '令', '会', '任', '但', '使', '便', '倘', '借', '假', '傥', '单', '讵', '设', '谓', '及', '苟', '若', '连', '迨', '适', '将', '并', '当', '带', '句', '同', '向', '和', '唯', '噎', '噫', '宁', '如', '饶', '抑', '浸', '纵', '维', '缘', '坐', '因', '惟', '就', '子', '焉', '然', '载', '旋', '或', '所', '既', '斯', '果', '故', '是', '暨', '必', '忍', '总', '恁', '更', '脱', '爰', '甚', '盖', '直', '矧', '由', '用', '虽', '而', '耳', '要', '至', '第', '管', '自', '跟', '须', '', '纵使', '纵令', '纵然', '再说', '虚词', '至于', '至若', '至乎', '至如', '只有', '只要', '至乃', '致使', '自然', '再不', '于是乎', '于是', '又且', '与其', '由于', '因而', '因为', '以致', '以至', '要是', '以及', '以下', '以为', '虚字', '焉乃', '勿然', '万一', '无论', '忘其', '亡其', '倘然', '倘使', '所以', '顺推', '庶几', '顺接', '是故', '是以', '甚至', '设或', '设若', '便乃', '便做', '别管', '不然', '不论', '不怕', '不拘', '不仅', '不但', '不过', '不管', '不料', '诚然', '词类', '除非', '但凡', '从而', '等到', '当使', '分句', '而亦', '而乃', '尔其', '而且', '反而', '而况', '否则', '固然', '故尔', '果然', '或曰', '或是', '或者', '何况', '及至', '及以', '既然', '即使', '假借义', '加以', '加之', '尽管', '借如', '借令', '尽管', '借使', '就是', '可是', '况乎', '况于', '连絶', '况且', '哪怕', '乃至', '譬如', '丕则', '丕乃', '且夫', '然则', '然而', '任凭', '如其', '如果']


#金融情绪词典
# 姚加权,冯绪,王赞钧,纪荣嵘,张维.语调、情绪及市场影响:基于金融情绪词典[J].管理科学学报,2021,24(05):26-46.
#正式-肯定情绪词典
FORMAL_pos_words = ['100强', '3A级', '50强', 'AAA级', 'AAA企业', '爱戴','爱国','爱好','爱护','爱慕','爱惜','爱心','爱悦','安定','安分','安好','安静','安居乐业','安康','安宁','安全','安全可靠','安然','安泰','安稳','安详','安祥','安心','安逸','按时','昂然','昂扬','盎然','熬过','翱翔','鳌头','傲人','傲视','拔得头筹','拔尖','把握','百花齐放','百强','百战不殆','百折不挠','摆脱困境','拜访','般配','帮扶','帮忙','帮手','帮助','榜首','榜样','磅礴','包涵','包容','包容开放','褒奖','褒扬','薄利多销','饱满','宝贝','宝藏','宝地','宝典','宝贵','宝库','宝座','保持稳定','保护','保荐','保密','保卫','保障','保证','保值','保质','堡垒','报答','报国','报奖','报捷','报喜','报效','抱负','抱团取暖','暴增','暴涨','爆发式','爆满','备受瞩目','倍增','奔放','奔赴','奔腾','本领','本事','鼻祖','比肩','比较完善','比较稳定','必胜','裨益','变革','变通','便捷','便利','便民','便宜','便于','辩证','标兵','标杆','标致','彪炳','飙升','飙涨','表里如一','表率','表示满意','表扬','表彰','别出心裁','别具一格','别开生面','别致','宾朋','秉公','禀赋','并行不悖','并驾齐驱','并肩','并重','波澜壮阔','伯乐','勃勃生机','博爱','博采','博大','博大精深','博得','博览','博闻','博学','博雅','补充','补救','补涨','补足','不败之地','不错','不怠','不凡','不负众望','不含糊','不骄不躁','不拘一格','不可多得','不可或缺','不吝','不平凡','不屈','不屈不挠','不容小觑','不容置疑','不俗','不同凡响','不同寻常','不畏艰险','不畏艰辛','不懈','不朽','布局合理','步入正轨','才干','才华','才俊','才略','才能','才学','才艺','才智','才子','财宝','财富','财路','财气','财运','采纳','灿烂','苍穹','操守','差距缩小','蝉联','产能扩张','产销两旺','昌隆','昌明','昌盛','常青树','偿清','敞开','畅达','畅行','畅快','畅顺','畅通','畅旺','畅销','畅叙','畅游','倡导','倡议','超产','超常','超出预期','超等','超额','超额完成','超凡','超过','超前','超强','超群','超人','超脱','超逸','超预期','超越','朝气','朝气蓬勃','朝阳','潮流','沉稳','沉着','晨曦','称霸','称道','称谢','称心','称雄','称许','称意','称誉','称赞','称职','成本低','成本降低','成本下降','成本优势','成才','成材','成功','成果','成绩','成就','成立','成名','成器','成事','成熟','成效','成型','成长','诚服','诚恳','诚朴','诚实','诚心','诚心诚意','诚信','诚意','诚挚','承担','承蒙','承诺','承上启下','乘风破浪','乘胜','乘势','澄澈','澄清','吃苦耐劳','驰骋','驰名','驰誉','持久','持之以恒','赤诚','炽热','冲锋','冲破','充分','充沛','充实','充盈','充裕','充足','憧憬','崇高','崇尚','酬谢','筹集','筹谋','筹募','踌躇满志','出彩','出类拔萃','出路','出名','出色','出头','出息','出线','出众','初具','矗立','传奇','传世','传颂','传扬','创办','创汇','创获','创记录','创见','创建','创举','创立','创利','创奇迹','创设','创始','创收','创新','创新力','创新能力','创新型','创新性','创业','创业精神','创意','创造','创造力','创造性','创制','创作','垂青','垂询','纯粹','纯洁','纯净','纯朴','纯熟','纯真','纯正','纯种','淳朴','醇香','慈爱','慈惠','慈善','慈善事业','慈祥','慈心','聪慧','聪敏','聪明','聪颖','从容','从优','促成','促进','促请','促使','催化剂','催人奋进','璀璨','错落有致','达标','达到','达观','达人','答谢','打动','打破','打通','打造','大才','大胆','大刀阔斧','大典','大度','大方','大放异彩','大幅提高','大好','大好时机','大户','大吉','大奖','大捷','大开发','大佬','大力','大力提倡','大力推行','大力支持','大器','大师','大势','大势所趋','大手笔','大统','大团结','大团圆','大喜','大显身手','大雅','大义','大有裨益','大有希望','大有作为','大涨','大制作','带动','带头','带头人','担当','殚精竭虑','胆量','胆识','淡泊','淡季不淡','淡雅','当红','当机立断','当仁不让','当先','当之无愧','到位','道德','道谢','道义','得当','得分','得力','得人心','得胜','得体','得天独厚','得心应手','得宜','得益','得主','德才兼备','德育','德政','登顶','低成本','低负债','低库存','低损耗','低调','底气','底蕴','砥砺','砥柱','地道','地利','第一','第一流','缔造','巅峰','典范','典礼','典型','典雅','点睛','奠定','奠基','殿堂','顶峰','顶级','顶尖','顶梁柱','顶天立地','鼎力','鼎盛','鼎新','定心丸','定型','东风','懂事','动力','动人','动态平衡','动听','洞察','洞见','洞明','洞悉','斗士','斗志','斗志昂扬','独步','独创','独创性','独大','独到','独家','独家经营','独具','独具匠心','独具特色','独立','独立自主','独领','独善其身','独特','独享','独一无二','独有','独占','笃实','笃学','笃志','端正','端直','端庄','断然','锻炼','对症下药','敦厚','敦请','多彩','多层次','多功能','多管齐下','多劳多得','多谢','多样','多样化','夺标','夺得','夺冠','夺魁','舵手','遏制','恩德','恩惠','恩情','恩泽','耳目一新','耳熟能详','发财','发达','发奋','发奋图强','发挥','发家','发明','发起','发现','发祥地','发扬','发扬光大','发展','发展潜力','法宝','法治','翻倍','翻番','翻两番','翻三番','翻身','翻身仗','翻天覆地','翻新','翻一番','繁花','繁华','繁茂','繁荣','繁荣昌盛','繁荣富强','繁盛','繁星','范本','范例','范文','方便','方便快捷','方兴未艾','芳邻','芳名','放宽','放心','飞奔','飞驰','飞快','飞速','飞速发展','飞腾','飞舞','飞翔','飞扬','飞跃','非常丰富','非凡','肥美','肥沃','斐然','费用减少','费用降低','分工合作','分工协作','分明','芬芳','奋斗','奋发','奋发图强','奋发有为','奋飞','奋进','奋力','奋力拼搏','奋勉','奋起','奋勇','奋勇向前','奋战','丰碑','丰登','丰富','丰富多彩','丰厚','丰满','丰美','丰年','丰沛','丰饶','丰稔','丰润','丰盛','丰实','丰收','丰硕','丰沃','丰盈','丰裕','风采','风度','风发','风范','风骨','风光','风华','风华正茂','风流','风靡','风向标','风雨同舟','风雨无阻','峰回路转','锋利','锋芒','凤毛麟角','奉公守法','奉献','扶持','扶贫','扶助','符合实际','符合要求','福地','福份','福利','福气','福星','福音','福祉','辅助','负债率低','复活','复苏','复兴','赋有','富贵','富国','富丽','富民','富强','富饶','富实','富庶','富有','富有成效','富余','富裕','富源','富足','改革','改观','改进','改良','改善','改造','盖世','甘醇','甘霖','甘露','甘美','赶超','赶上','敢为人先','敢于','感动','感恩','感激','感染力','感人','感悟','感谢','感兴趣','感言','感召','干干净净','干将','干劲','干净','干练','刚健','刚强','刚韧','刚柔','刚毅','刚勇','刚正','高昂','高标准','高才','高参','高产','高超','高潮','高成长','高大','高档','高档化','高等','高等级','高地','高度评价','高端','高风','高峰','高附加值','高歌','高歌猛进','高贵','高回报','高级','高技术','高绩效','高见','高洁','高精度','高精尖','高居','高举','高峻','高亢','高朗','高毛利率','高明','高抛低吸','高品质','高起点','高潜力','高强度','高尚','高手','高水平','高速','高屋建瓴','高效','高效率','高效能','高效益','高新','高兴','高性能','高雅','高溢价','高远','高增长','高瞻远瞩','高涨','高质量','搞好','告捷','歌颂','革故鼎新','革新','个性化','各得其所','各有千秋','给力','根深蒂固','跟涨','更好','更进一步','更快','更快捷','更强','更新换代','更优越','更有效','工细','工整','公道','公开','公平','公平合理','公平竞争','公私分明','公正','功不可没','功绩','功劳','功能齐全','功勋','攻坚克难','攻克','恭敬','巩固','共赢','贡献','供不应求','供需平衡','古朴','骨干','鼓励','鼓舞','鼓舞人心','固本强基','固若金汤','顾全','关爱','关怀','关切','关心','关照','冠军','光彩','光顾','光辉','光亮','光芒','光明','光明磊落','光明正大','光荣','光鲜','光耀','光泽','规范','规模化','规模经济','规模效益','瑰宝','瑰丽','贵重','国宝','国粹','国际化','国家级','国色天香','果断','果敢','果决','过硬','含蓄','涵养','汗马功劳','旱涝保收','捍卫','夯实','行家','行之有效','毫不动摇','毫不逊色','豪华','豪杰','豪迈','豪气','豪情','豪情满怀','好处','好感','好看','好客','好评','好奇','好人','好日子','好时机','好事','好心','好意','好用','好于','好运','好转','号召力','浩大','浩浩荡荡','呵护','喝彩','合法','合格','合理','合理化','合力','合拍','合情合理','合群','合时','合适','合算','合宜','合意','合作','和畅','和风细雨','和好','和缓','和解','和乐','和睦','和平','和洽','和善','和顺','和谐','和悦','和衷共济','核心技术','核心竞争力','贺电','贺喜','赫赫','黑白分明','黑马','很好','很强','亨通','恒久','恒心','轰轰烈烈','弘大','弘扬','红榜','红包','红红火火','红火','红润','宏大','宏朗','宏丽','宏图','宏伟','宏愿','洪福','洪亮','鸿博','鸿儒','鸿运','后盾','后发优势','后福','后劲十足','后劲足','后来居上','后起之秀','厚爱','厚待','厚道','厚恩','厚积薄发','厚礼','厚实','厚望','虎威','互补','互惠','互惠互利','互利','互通','互信','互助','护航','护理','花好月圆','划时代','划算','华彩','华贵','华丽','华美','华章','化解','化危为机','欢畅','欢呼','欢聚','欢快','欢乐','欢庆','欢送','欢腾','欢天喜地','欢喜','欢笑','欢欣','欢欣鼓舞','欢迎','欢娱','欢愉','欢悦','环境优美','缓和','缓解','唤起','唤醒','焕发','焕然一新','黄金','黄金时代','挥斥','挥洒','恢复','恢弘','恢宏','辉煌','辉耀','辉映','回报','回补','回笼快','回暖','回升','回稳','回涨','会师','荟萃','惠存','惠及','慧心','慧眼','浑然一体','豁达','豁免债务','豁然开朗','活力','活泼','活用','活跃','火爆','火红','火热','货真价实','获得','获得授权','获奖','获利','获取','获益','获准','机会','机灵','机遇','机智','积德','积极','积极性','积蓄','基石','跻身','激昂','激动人心','激发','激活','激励','激情','激扬','及时','及时雨','吉利','吉庆','吉日','吉时','吉祥','吉祥物','吉星','吉星高照','吉兆','极好','极致','集大成','集思广益','纪念币','技高一筹','技能','技巧','技术创新','技术革新','技压群雄','济贫','济世','济助','继承','继往开来','寄予','绩效','绩优','冀望','加大','加紧','加快','加强','加速','加薪','佳话','佳绩','佳节','佳境','佳酿','佳品','佳期','佳作','家喻户晓','嘉奖','嘉许','甲等','价格优势','价值连城','驾驭','尖兵','尖端','尖子','坚不可摧','坚持','坚持不懈','坚定','坚定不移','坚固','坚固耐用','坚决','坚强','坚忍','坚忍不拔','坚韧','坚韧不拔','坚如磐石','坚实','坚守','坚挺','坚信','坚毅','坚贞','艰苦奋斗','艰苦朴素','兼备','兼顾','兼优','检点','减亏','减免','减少成本','减少费用','减少负债','减少坏账','减少库存','减少摩擦','减少损耗','减少损失','减少支出','减税','简便','简便易行','简单','简单化','简单明了','简单易行','简短','简洁','简捷','简练','简明','简明扼要','简朴','简要','简易','简约','见识','见效','见义勇为','见长','建立','建设','建设性','建树','建言','健步','健儿','健将','健捷','健康','健康美','健朗','健美','健全','健实','健硕','健壮','渐入佳境','践行','践诺','鉴赏','讲究','讲理','讲求','奖杯','奖罚分明','奖金','奖励','奖牌','奖品','奖赏','奖项','奖学金','奖优惩劣','奖章','奖状','匠心独运','降低成本','降低费用','降低负债','降低耗能','降低库存','降低损耗','交口称赞','交情','骄人','骄子','佼佼者','矫健','脚踏实地','叫好','觉悟','觉醒','较高','较好','较强','教化','教诲','教养','接地气','接轨','接济','揭示','节电','节俭','节节高','节流','节能','节省','节水','节用','节约','节支降耗','杰出','杰出青年','杰出人物','杰作','洁白','洁净','结晶','结盟','结实','捷报','捷径','捷足先登','竭诚','解除','解冻','解放','解封','解惑','解救','解决','解套','解围','金贵','金奖','金牌','金言','金钥匙','紧密衔接','锦标','锦旗','锦上添花','锦绣','谨慎','尽力','尽情','尽如人意','尽善尽美','尽心','尽心竭力','尽心尽力','尽责','尽职','进步','进化','进军','进取','进贤','进一步提高','进益','进展','劲草','劲旅','晋级','晋升','晋职','经典','经久不衰','经久耐用','经纶','经验丰富','旌旗','惊喜','晶亮','晶莹','晶莹剔透','兢兢业业','精白','精兵','精采','精彩','精彩纷呈','精诚','精诚团结','精纯','精粹','精打细算','精雕细刻','精雕细琢','精干','精悍','精华','精简','精进','精力','精练','精炼','精良','精美','精密','精妙','精明','精辟','精品','精强','精巧','精确','精确性','精锐','精深','精神','精神抖擞','精神风貌','精髓','精通','精微','精细','精心','精心组织','精选','精研','精要','精益','精益求精','精英','精于','精湛','精制','精致','精忠','精装','精准','井井有条','井喷','井然有序','景胜','景仰','警觉','警醒','净化','竞秀','竞艳','竞争力','敬爱','敬礼','敬佩','敬畏','敬信','敬仰','敬业','敬意','敬重','敬祝','静谧','静心','炯炯','久经考验','救护','救急','救济','救死扶伤','救援','救治','救助','居安思危','居前','居首','举荐','举一反三','举足轻重','巨匠','巨人','巨头','巨著','巨子','具体','俱佳','据理力争','据实','聚宝盆','聚精会神','捐献','捐赠','捐助','眷顾','决定性','决心','诀窍','绝对优势','绝好','绝技','绝佳','绝色','绝世','崛起','均等','均衡','均匀','君子','俊杰','俊美','俊伟','俊秀','俊雅','俊逸','骏马','开诚布公','开创','开创性','开发','开放','开放性','开化','开怀','开阔','开朗','开门红','开明','开辟','开启','开窍','开通','开拓','开拓型','开心','开源节流','凯歌','凯旋','楷模','侃侃','看多','看好','看涨','康复','康健','康乐','康泰','慷慨','慷慨解囊','抗跌','抗衡','抗争','考究','犒赏','靠得住','靠前','可爱','可持续','可观','可贵','可行','可靠','可控','可取','可圈可点','可塑','可塑性','可喜','可信','可信赖','可信任','可预测','渴望','克服','克服困难','克己奉公','刻苦','恪守','客观','肯定','肯干','恳谈','库存降低','酷爱','跨越','快感','快活','快捷','快乐','快速','快意','快周转','脍炙人口','宽博','宽敞','宽大','宽广','宽和','宽宏','宽厚','宽阔','宽仁','宽容','宽裕','狂欢','狂想','旷达','旷世','魁首','魁伟','魁元','馈赠','鲲鹏','扩充','扩大','扩建','扩容','扩展','扩张','阔步','拉动','拉高','拉涨','蓝图','浪潮','浪漫','劳模','牢不可破','牢固','牢靠','牢稳','老练','老牌','老字号','乐观','乐趣','乐善好施','乐事','乐天','乐土','乐业','乐意','乐于','乐园','了不起','雷厉风行','冷静','黎明','礼貌','礼让','礼遇','里程碑','里程碑式','理解','理顺','理想','理性','理直气壮','理智','力促','力行','力量','力求','力争','力争上游','力作','厉行','立竿见影','立功','立项','立志','立足','励精图治','利国利民','利好','利器','利润增加','利索','利他','利于','莅临','连理','连续盈利','连涨','联欢','联袂','联谊','廉洁','廉洁奉公','廉正','廉政','良策','良方','良港','良好','良好环境','良好条件','良好形象','良机','良品','良善','良师益友','良田','良心','良性','良药','良医','良友','良缘','凉爽','两全','亮点','亮丽','亮眼','靓丽','量才录用','量力而行','临危不惧','淋漓尽致','琳琅满目','伶俐','灵便','灵动','灵感','灵活','灵活机动','灵机','灵敏','灵巧','灵通','灵秀','灵验','玲珑','领导力','领导能力','领导者','领航','领航者','领军','领军人物','领军者','领跑','领头羊','领先','领先水平','领先于','领先者','领衔','领袖','领涨','令人鼓舞','令人满意','令人信服','令人瞩目','留心','流畅','流行','流通','柳暗花明','龙腾虎跃','龙头','隆盛','隆重','录用','戮力同心','露头角','论功行赏','落袋为安','落实','履行','履行职责','履约','率先','率直','马不停蹄','埋头苦干','迈进','满产满销','满分','满怀激情','满腔热情','满勤','满堂红','满意','满载而归','满足','满座','茂盛','冒尖','美称','美德','美感','美观','美好','美化','美景','美丽','美轮美奂','美满','美妙','美名','美事','美味','美秀','美意','美誉','魅力','猛进','猛增','猛涨','梦寐以求','梦想','弥足珍贵','密切合作','密切配合','免于','勉励','妙计','妙境','妙趣横生','民望','民意','民主','敏慧','敏捷','敏锐','名产','名副其实','名贵','名家','名将','名列','名列前茅','名流','名门','名牌','名品','名气','名人','名山','名胜','名师','名士','名望','名宿','名言','名医','名优','名誉','名著','名作','明辨是非','明达','明灯','明鉴','明洁','明净','明静','明镜','明快','明朗','明了','明理','明亮','明媚','明明白白','明确','明确指出','明晰','明显改善','明显增强','明星','明耀','明哲','明智','明珠','鸣谢','铭记','模范','摩登','魔力','睦邻','耐久','耐劳','耐心','耐性','耐用','难得','难能可贵','囊括','内行','内敛','内外兼修','能干','能人','能手','能征善战','逆袭','逆转','年度人物','年富力强','宁静','凝聚力','扭亏','扭转','努力','暖和','暖流','讴歌','偶像','排除万难','排难','排头兵','排忧解难','攀登','攀升','盘活','盼望','庞大','跑赢','陪伴','培养','培育','蓬勃','蓬勃发展','蓬勃向上','澎湃','批准','披荆斩棘','劈波斩浪','媲美','偏爱','漂亮','飘逸','拼搏','拼争','频传','品德','品牌','品牌优势','品学兼优','聘请','聘任','平安','平安无事','平等','平等互利','平和','平静','平实','平顺','平坦','平稳','平易','颇丰','破冰','破釜沉舟','破解','破旧立新','魄力','铺设','朴厚','朴实','普及','谱写','期待','期盼','期望','齐备','齐驱并进','齐全','齐头并进','齐心','齐心协力','齐一','齐整','齐抓共管','奇兵','奇才','奇观','奇迹','奇丽','奇妙','奇谋','奇伟','旗鼓相当','旗开得胜','旗帜鲜明','企盼','启迪','启示','起飞','起色','绮丽','气度','气概','气节','气派','气魄','气势','气质','契机','器重','恰当','恰到好处','恰如其分','千锤百炼','千金','千里马','千姿百态','谦卑','谦诚','谦和','谦让','谦慎','谦顺','谦虚','谦虚谨慎','谦逊','前100','前50','前锋','前赴后继','前行','前进','前景','前列','前茅','前仆后继','前驱','前三','前三甲','前十','前所未有','前途','前五','前沿','前瞻','前瞻性','虔诚','潜力','潜心','强大','强干','强固','强国','强悍','强化','强健','强劲','强力','强流动性','强强联合','强人','强身','强盛','强项','强心剂','强毅','强有力','强于','强者','强壮','抢先','抢眼','抢占','巧妙','巧思','翘楚','切合','切实','切实加强','切中','惬意','锲而不舍','钦佩','钦羡','亲和','亲和力','亲近','亲密','亲民','亲切','亲人','亲善','勤奋','勤俭','勤俭节约','勤恳','勤快','勤劳','勤力','勤勉','勤勤恳恳','青春','青睐','轻便','轻捷','轻快','轻巧','轻柔','轻松','轻盈','倾心','清白','清澈','清楚','清纯','清醇','清淡','清芬','清晖','清洁','清净','清静','清朗','清廉','清亮','清流','清泉','清润','清爽','清顺','清甜','清晰','清新','清馨','清醒','清秀','清逸','清正','情操','情谊','情有独钟','晴朗','庆典','庆贺','庆幸','庆祝','求实','求新','求真务实','取得','取得成功','取经','取胜','取长补短','去库存','趣味','权威','权威性','权威专家','全才','全力','全力以赴','全面','全面实现','全面提高','全面完成','全能','全神贯注','全胜','全盛','全心全意','全新','拳头产品','劝导','确切','确实','确信','确凿','群策群力','群芳','群贤毕至','冉冉升起','热爱','热潮','热忱','热诚','热点','热火朝天','热烈','热门','热闹','热捧','热切','热情','热销','热心','热血','人才','人才辈出','人才荟萃','人才济济','人道','人杰','人尽其才','人心所向','仁爱','仁慈','仁德','仁惠','仁义','仁政','认可','认认真真','认同','认真','认真负责','任劳任怨','任人唯贤','韧劲','韧性','日渐成熟','日新月异','日臻完善','荣登','荣光','荣获','荣任','荣升','荣幸','荣耀','荣膺','荣誉','荣誉称号','荣誉证书','容易','融会','融会贯通','融洽','柔和','柔滑','柔美','柔韧','柔顺','如虎添翼','如获至宝','如期','如期完成','如日中天','如实','如意','如愿','儒雅','入微','入围','入选','软和','锐敏','锐气','锐意','瑞气','睿哲','睿智','润泽','飒爽','三好','三甲','三连冠','闪亮','善行','善举','善良','善人','善始善终','善心','善意','善战','擅长','商机','赏罚分明','赏识','赏心悦目','上榜','上策','上乘','上等','上行','上好','上佳','上进','上流','上品','上升','上调','上位','上扬','上游','上涨','设备齐全','社会公德','伸张正义','身体力行','身先士卒','身心健康','深耕细作','深厚','深化','深刻','深切','深入','深入浅出','深入人心','深思','深透','深信','深远','深造','神采','神话','神力','神奇','神圣','神算','神通','神通广大','神韵','审慎','审时度势','慎密','升高','升格','升华','升级','升温','升值','生财','生动','生动活泼','生机','生机盎然','生机勃勃','生力军','声势浩大','声望','声威','声誉','省力','省时','省事','省心','圣地','圣洁','圣贤','胜出','胜地','胜过','胜会','胜景','胜利','胜券','胜任','胜似','胜诉','胜算','胜仗','盛产','盛大','盛典','盛行','盛会','盛景','盛开','盛况','盛名','盛情','盛世','盛事','盛筵','盛宴','盛意','盛誉','盛赞','十分满意','十佳','十强','十全十美','十足','时机成熟','时髦','时尚','时兴','识才','实诚','实打实','实干','实话','实惠','实绩','实力','实力雄厚','实实在在','实事求是','实现','实效','实用','实在','实至名归','拾金不昧','拾遗补缺','史无前例','矢志','矢志不渝','使命','始创','始终不懈','始终不渝','始终如一','示范','世界级','世界纪录','势不可挡','势如破竹','势头迅猛','势在必行','事半功倍','事关重大','事迹','试金石','适当','适度','适合','适销','适销对路','适宜','适应','适用','誓言','收放自如','收复','收获','收入增长','收效','守法','守信','守职','首倡','首创','首家','首肯','首款','首屈一指','首位','首选','首要','受到重视','受欢迎','受惠','受益','受用','受尊敬','售罄','殊荣','舒畅','舒服','舒缓','舒适','舒坦','舒心','舒展','疏导','熟练','熟练掌握','熟手','熟悉','熟习','熟知','曙光','树立','数一数二','双升','双喜','双赢','爽快','爽朗','水到渠成','水滴石穿','顺差','顺畅','顺风','顺境','顺理成章','顺利','顺利进行','顺利实现','顺利完成','顺势而为','顺心','顺应','顺应形势','硕果','硕果累累','思恋','思路清晰','思念','斯文','四连冠','颂歌','颂扬','素洁','素净','素雅','素养','速效','随和','随机应变','损耗低','缩小差距','踏实','踏踏实实','太平','泰斗','泰然','坦诚','坦诚相待','坦诚相见','坦荡','坦率','坦然','坦途','坦直','叹为观止','探索','陶然','陶冶','陶醉','特等','特惠','特级','特色','特许','特许经营权','特许权','特有','特长','腾飞','腾跃','提拔','提倡','提高','提炼','提前完成','提升','提速','提携','提振','提质降耗','体察','体谅','体面','体贴','体贴入微','体系化','倜傥','天才','天翻地覆','天分','天赋','天籁','天良','天然','天使','添彩','甜蜜','甜头','填补','挑大梁','调解','贴切','贴心','铁军','铁面无私','挺拔','挺进','挺身而出','通才','通畅','通达','通亮','通明','通情达理','通顺','通俗易懂','通透','同心','同心同德','同心协力','同意','统筹','统领','统一','痛快','头筹','头等','头号','头脑清醒','透彻','透亮','透明','透明化','突出','突飞猛进','突进','突破','突破性','突破性进展','突围','团结','团结奋进','团聚','团圆','推陈出新','推崇','推动','推广','推荐','推进','推举','推升','推重','蜕变','脱困','脱胎换骨','脱颖而出','妥当','妥善','妥善解决','拓荒','拓宽','拓展','挖潜增效','弯道超车','完备','完成','完好','完好无损','完满','完美','完全','完全符合','完人','完善','完整','顽强','万马奔腾','万全','万无一失','万众一心','万众瞩目','王道','王者','忘我','旺季','旺盛','旺销','望眼欲穿','威风','威猛','威名','威望','威武','威信','威仪','为人正直','伟大','伟观','伟人','伟业','未雨绸缪','温和','温静','温暖','温情','温润','温馨','文才','文采','文明','文雅','闻风而动','闻名','稳步','稳步发展','稳当','稳定','稳定化','稳固','稳健','稳居','稳实','稳妥','稳扎稳打','稳中求变','稳中求进','稳中有进','稳中有升','稳重','稳坐','问候','问世','沃土','无比','无敌','无坚不摧','无可比拟','无可争议','无愧','无上','无双','无私','无微不至','无畏','无污染','无误','无瑕','无恙','无与伦比','五彩缤纷','五谷丰登','五连冠','五星级','务实','物超所值','物美价廉','悟性','吸纳','吸引','吸引力','吸引人','希冀','希望','悉心','稀缺','稀有','犀利','喜爱','喜报','喜好','喜欢','喜剧','喜乐','喜庆','喜人','喜事','喜闻乐见','喜兴','喜讯','喜洋洋','喜悦','细密','细腻','细心','细致','先导','先导性','先发优势','先锋','先行','先行者','先河','先机','先进','先进典型','先驱','先驱者','先人后己','先抑后扬','先知','先知先觉','纤巧','鲜活','鲜亮','鲜美','鲜明','鲜嫩','鲜艳','闲适','贤达','贤德','贤惠','贤良','贤明','贤能','贤人','贤哲','娴熟','显达','显而易见','显贵','显赫','显性','显眼','显扬','显著','显著成绩','现代化','羡慕','献策','献礼','相称','相得益彰','相宜','相中','相助','详尽','详实','详细','祥和','祥瑞','翔实','享福','享受','享有','享誉','响当当','响应','想象力','向上','向往','向心力','像样','骁健','骁勇','小康','小心谨慎','孝敬','笑傲','效法','效率高','效益','效忠','协力','协调','协调一致','协同','协同效应','谐和','携手','谢谢','谢意','心动','心服','心花怒放','心满意足','心无旁骛','心细','辛劳','辛勤','欣然','欣赏','欣慰','欣喜','欣欣向荣','欣悦','新宠','新方法','新飞跃','新风','新高','新贵','新机制','新技术','新进展','新晋','新局面','新跨越','新里程','新理念','新能效','新篇章','新奇','新起点','新锐','新生','新水平','新思路','新台阶','新体验','新途径','新禧','新鲜','新鲜感','新星','新形象','新型','新兴','新秀','新意','新颖','新增','馨香','信得过','信奉','信服','信赖','信任','信守','信心','信仰','信义','信用','信誉','醒目','兴奋','兴高采烈','兴隆','兴起','兴盛','兴腾','兴旺','幸福','幸事','幸运','性价比高','胸怀','雄风','雄关','雄厚','雄浑','雄健','雄杰','雄纠纠','雄踞','雄奇','雄图','雄威','雄伟','雄武','雄心','雄心勃勃','雄壮','雄姿','修好','修身','修养','秀慧','秀丽','秀美','虚心','需求旺盛','许可','栩栩','栩栩如生','宣扬','选贤任能','炫目','绚烂','绚丽','绚丽多彩','削减成本','削减支出','学成','学以致用','学有专长','学者','雪中送炭','勋绩','勋章','熏陶','循序渐进','训练有素','迅捷','迅猛发展','迅速','雅洁','雅兴','雅致','延伸','严格','严谨','严密','严明','严师','严守','严正','言而有信','言行一致','研究成果','扬帆起航','扬眉吐气','扬名','扬升','扬长避短','阳光','洋溢','仰慕','仰望','邀请','遥遥领先','要塞','要事','要职','耀眼','业绩','夜以继日','一等','一帆风顺','一呼百应','一举','一流','一马当先','一门心思','一目了然','一气呵成','一日千里','一如既往','一视同仁','一丝不苟','一统江山','一往无前','一席之地','一线','一心一意','一枝独秀','一致','一专多能','怡和','怡乐','怡然','怡神','怡悦','宜居','宜人','颐养','以身作则','倚重','旖旎','义不容辞','义举','义卖','义勇','义诊','屹立','屹立不倒','异彩','异彩纷呈','异军突起','益处','益友','意境','意气风发','溢美','毅力','毅然','毅勇','熠熠生辉','因材施教','因地制宜','因时制宜','殷切','殷勤','殷实','引爆','引领','引领者','引擎','引人入胜','引人瞩目','引人注目','英才','英豪','英俊','英明','英武','英雄','英勇','英姿','迎接','迎难而上','迎刃而解','盈利','赢得','赢家','赢利','赢取','赢者','颖慧','颖异','影响力','影响深远','应变','硬朗','拥戴','拥护','永存','永恒','勇敢','勇健','勇力','勇猛','勇气','勇士','勇往直前','勇武','勇毅','勇于','勇壮','涌现','踊跃','用功','用劲','用途广泛','用心','优待','优等','优点','优抚','优厚','优化','优惠','优良','优良传统','优美','优胜','优胜劣汰','优势','优先','优秀','优秀企业','优选','优雅','优异','优于','优裕','优越','优质','幽默','幽雅','悠久','悠然','悠闲','悠游','由亏变盈','由衷','游刃有余','友爱','友邦','友好','友好合作','友军','友邻','友情','友善','友谊','有保障','有才干','有成','有的放矢','有底气','有福','有功','有恒','有价值','有进有退','有劲','有竞争力','有据','有口皆碑','有赖于','有理','有理有据','有力','有利','有利条件','有利于','有名','有名气','有目共睹','有能力','有前瞻性','有钱','有求必应','有趣','有声有色','有所缓和','有所斩获','有所作为','有特色','有条不紊','有条理','有望','有希望','有戏','有效','有效率','有效途径','有心','有信心','有序','有益','有益于','有影响力','有用','有缘','有增无减','有志','有质量','有助','有助于','有作为','诱人','愉快','愉悦','与人为善','与时俱进','浴火重生','预增','誉为','渊博','元勋','原创','圆满','圆满成功','圆润','援救','援助','远超','远大','远见','远见卓识','远景','远虑','愿景','悦目','跃居','跃然','跃上','跃升','匀称','匀整','允诺','允许','孕育','韵味','蕴涵','仔细','再创','再获','再接再厉','再生','再添','再续','再造','在理','在握','赞不绝口','赞成','赞歌','赞美','赞赏','赞叹','赞同','赞许','赞扬','赞誉','赞助','造福','造就','造诣','择机','择优','泽润','增补','增持','增多','增高','增光','增厚','增加','增进','增强','增色','增势','增收','增速','增添','增效','增益','增长','增值','赠送','扎实','扎扎实实','斩获','展翅','展望','崭露头角','崭新','占据','占领','战功','战果','战绩','战略思维','战略眼光','战略意义','战胜','战无不胜','站稳脚跟','彰显','长处','长存','长进','长青','长生','长盛不衰','长寿','长项','长于','长远','长治久安','长足','长足进步','涨势','涨停','掌控','掌握','照耀','珍爱','珍宝','珍本','珍藏','珍贵','珍品','珍奇','珍禽','珍视','珍惜','珍稀','珍重','真才实学','真诚','真谛','真话','真理','真切','真情','真情实意','真确','真实','真实可信','真实有效','真心','真心诚意','真心实意','真真切切','真知','真知灼见','真挚','真抓实干','箴言','缜密','振发','振奋','振奋人心','振兴','振作','震撼','镇定','镇静','争分夺秒','争光','争气','争先','争雄','峥嵘','蒸蒸日上','拯救','整合','整洁','整齐','整齐划一','整治','正本清源','正大','正大光明','正当','正道','正规','正轨','正果','正经','正理','正面','正能量','正派','正气','正确','正确性','正统','正向','正义','正直','正宗','郑重','政策补贴','政策红利','政府补贴','政通人和','支撑','支持','支出减少','支援','支柱','枝繁叶茂','知己','知己知彼','知名','知心','知音','知足','直观','值得','值得信赖','止跌反弹','止跌回升','止跌回稳','止跌企稳','指教','指明','指日可待','指引','至宝','至诚','至高无上','至关重要','至交','至上','至尊','志行','志气','志同道合','志愿','制高点','制胜','质朴','质优','炙手可热','挚诚','致富','致贺','致敬','致力','致谢','秩序井然','智多星','智慧','智谋','智囊','中标','中坚','中肯','中流砥柱','中心地位','中选','中意','中用','忠诚','忠告','忠厚','忠良','忠烈','忠实','忠顺','忠心','忠信','忠义','忠勇','忠于','忠直','钟爱','衷心','众所周知','众望','众望所归','众志成城','重大成果','重大进展','重点','重获','重奖','重生','重视','重托','重新获得','重要','重用','重振','重镇','重整','周到','周密','周全','周详','周正','周转快','珠玑','主导','主动','主动权','主动性','主将','主力军','主流','主人翁','主心骨','主旋律','瞩目','瞩望','助力','助人为乐','助推器','助益','注入','注重','祝福','祝贺','祝捷','祝愿','著称','著名','抓紧','专家','专属','专心','专心致志','专业化','专业人士','专一','专长','专注','转负为正','转好','转暖','转危为安','转型升级','转正','庄严','庄重','壮大','壮观','壮健','壮举','壮阔','壮丽','壮美','壮实','壮志','状况良好','状元','追捧','追求','追涨','准点','准确','准确无误','准时','准许','准予','茁壮','卓尔不群','卓见','卓立','卓然','卓识','卓有成效','卓越','卓著','孜孜','孜孜不倦','资金充裕','资深','资源优势','资助','滋补','滋润','滋养','自给自足','自豪','自觉','自觉自愿','自力更生','自立','自律','自强','自强不息','自信','自由','自在','自主','自足','纵横','走出低谷','走出困境','走高','走牛','走强','走俏','奏效','足够','足金','钻研','最高','最高级','最好','最合适','最佳','最具价值','最前端','最权威','最喜爱','最新','最新进展','最优','尊崇','尊贵','尊敬','尊重','遵从','遵纪守法','遵守','遵循','遵照','做大','做精','做精做细','做强','做优',]
#正式-否定情绪词典
FORMAL_neg_words = ['安于现状', '暗藏', '暗淡', '暗黑', '暗流', '暗箱操作','黯淡','扒皮','把持','罢免','霸道','霸权','霸占','摆布','摆设','败诉','绊脚石','绑架','包袱','薄弱','饱和','保护伞','保守','报废','报复','抱怨','暴跌','暴发','暴力','暴利','暴露','暴乱','爆仓','悲观','悲伤','悲痛','背道而驰','背离','被动','被控','被迫','被取消','被淘汰','笨重','崩溃','崩盘','逼迫','闭门造车','闭塞','弊病','弊端','壁垒','边缘化','编造','贬低','贬损','贬值','变差','变坏','变节','变脸','变卖','变态','变天','变相','变质','濒临','冰冷','病毒','病害','病魔','病弱','病态','病疫','波动','波及','波折','剥夺','剥离','驳回','搏杀','不安','不测','不畅','不成熟','不达标','不当','不当行为','不道德','不端','不发达','不负责任','不公','不公正','不够','不顾','不规范','不过关','不好','不合','不合时宜','不济','不佳','不见起色','不健全','不景气','不均','不堪','不可靠','不快','不乐观','不理想','不理性','不力','不利','不良','不满','不满意','不满足','不明朗','不明显','不匹配','不平衡','不强','不切实际','不全','不容乐观','不如','不善','不甚','不慎','不实','不爽','不思进取','不同意','不统一','不妥','不稳','不现实','不祥','不幸','不一致','不宜','不易','不愿意','不占优势','不振','不正常','不正当','不知去向','不足','不作为','步履维艰','财务困难','裁员','踩踏','参差不齐','残废','残酷','残缺','残杀','残损','残余','蚕食','惨淡','惨剧','惨烈','惨痛','惨重','仓促','苍白','操心','操纵','嘈杂','草草','草率','策动','查封','查扣','差距','差评','差强人意','差于','掺和','掺假','缠身','产量降低','产能过剩','产能降低','产能限制','谄谀','猖獗','偿债压力','抄袭','超标','超负荷','超载','超支','嘲笑','炒作','扯皮','掣肘','撤销','沉寂','沉疴','沉沦','沉闷','沉痛','沉重','陈腐','陈规','陈旧','成本高','成本上升','成本增加','成见','程度低','惩罚','吃紧','吃亏','痴呆','迟到','迟钝','迟缓','迟延','迟滞','赤字','冲高回落','冲击','冲突','冲撞','充斥','抽风','丑闻','出格','出轨','出局','出卖','出事','出逃','除名','处罚','触犯','触礁','触目惊心','串通','创伤','垂危','蠢蠢欲动','辞退','次货','次品','粗暴','粗笨','粗糙','粗略','粗制滥造','篡改','脆弱','存心','存疑','挫伤','挫折','错案','错过','错漏','错误','错综复杂','达不到','打击','打架','打压','大打折扣','大跌','大话','大起大落','大肆','大洗牌','大意','呆帐','呆滞','逮捕','代价','怠工','怠慢','担心','担忧','单薄','单打独斗','单调','耽搁','耽误','淡漠','荡然无存','倒闭','倒霉','倒退','倒下','盗版','盗卖','盗窃','盗用','得不到','得过且过','低产','低潮','低档','低等','低端','低附加值','低估','低谷','低级','低劣','低落','低迷','低靡','低能','低品质','低水平','低俗','低头','低微','低位','低下','低效','低效率','低效能','低效益','低于目标','低于预期','低质','敌对','敌人','诋毁','抵触','抵赖','抵制','地狱','垫底','刁难','凋零','吊销','掉队','掉以轻心','跌出','跌跌不休','跌回','跌价','跌破','跌入','跌势','跌停','铤而走险','丢失','动荡','动荡不安','动火','动乱','动摇','冻害','冻结','斗争','毒害','毒品','毒素','独霸','独断专行','渎职','赌博','短板','短浅','短缺','短视','断裂','堆砌','对抗','对立','惰性','扼杀','恶臭','恶棍','恶化','恶劣','恶魔','恶心','恶性','恶意','噩梦','发毛','发烧','发作','乏力','乏善可陈','乏味','翻版','翻车','烦恼','烦琐','烦躁','繁琐','繁杂','繁重','反常','反动','反对','反攻','反面','反目','犯错','犯罪','泛滥','防止','妨碍','妨害','仿冒','仿造','仿制','放缓','放火','放慢','放弃','放任','放肆','非法','非分','非理性','非人','非议','肥胖','诽谤','废除','废旧','废品','废弃','废物','费解','费力','费神','费事','费用高','费用上升','费用增加','分裂','分歧','纷乱','纷争','粉饰','愤怒','风波','风口浪尖','风浪','风声鹤唳','风险','封闭','封杀','封锁','疯狂','讽刺','否定','否决','否认','敷衍','浮亏','浮躁','腐败','腐化','腐烂','腐蚀','负担','负荷','负面','负增长','负债累累','负债率高','负债上升','负债增加','负重','附和','复杂','腹背受敌','尴尬','干扰','干涉','高成本','高费用','高负荷','高负债','高估','高价','高损耗','高位回落','高消耗','告警','疙瘩','搁浅','搁置','割据','割裂','隔阂','跟不上','跟风','功利','攻击','供过于求','勾结','构陷','诟病','孤独','孤寡','孤立','孤僻','姑息','辜负','谷底','鼓吹','鼓动','固步自封','故步自封','故障','顾此失彼','顾虑','痼疾','怪圈','怪物','关闭','关停','官僚主义','官司','管理不善','规避','诡谲','裹足不前','过错','过大','过度','过多','过分','过高','过激','过快','过量','过猛','过期','过热','过剩','过失','过时','过于','含糊','行贿','豪强','耗费','耗竭','耗损','合谋','黑暗','黑金','黑钱','黑市','黑天鹅','很差','很难','横行','哄抢','哄抬','后顾之忧','后患','后劲不足','后遗症','忽略','忽视','忽悠','囫囵吞枣','胡来','虎视眈眈','滑坡','滑铁卢','怀疑','坏处','坏蛋','坏事','坏帐','坏账增加','缓慢','涣散','荒废','荒凉','慌乱','惶恐','谎报','谎言','幌子','挥霍','回扣','回笼慢','回落','毁坏','毁伤','毁损','毁约','贿赂','昏迷','浑浊','混沌','混乱','混战','混浊','货损','积弊','积欠','积压','积重难返','畸高','畸形','激进','激烈','羁绊','羁押','岌岌可危','极其不利','急跌','急功近利','急剧','急性','急于','急躁','急转直下','棘手','挤兑','挤压','挤占','觊觎','寄生','寄生虫','寂寞','加剧','挟持','枷锁','夹带','夹击','假话','假冒','架空','尖锐','艰巨','艰苦','艰难','艰难曲折','艰难险阻','艰辛','煎熬','减产','减持','减弱','减少','减速','减退','简陋','贱卖','践踏','僵持','僵化','僵局','僵尸','僵硬','降低','降级','降价','降温','胶着','焦虑','焦灼','搅局','搅乱','叫停','较低','较少','教唆','教条','教训','揭发','揭露','劫持','结伙','解雇','解聘','解散','解体','紧迫','紧缺','紧缩','紧张','进退维谷','禁锢','禁运','经济衰退','经验不足','惊恐','惊悚','惊险','精神不振','警报','警告','警钟','窘境','窘况','窘迫','纠缠','纠纷','纠葛','纠集','纠结','拘留','居高不下','沮丧','举步维艰','举债','巨亏','惧怕','卷土重来','绝境','绝情','攫取','开除','堪忧','坎坷','看不起','看跌','抗拒','抗议','考验','苛刻','苛求','可耻','可怕','克扣','刻板','刻意','空洞','空耗','空话','空壳','空谈','空想','空心化','恐怖','恐慌','恐惧','控诉','枯竭','枯燥','苦难','苦恼','苦涩','苦于','库存积压','酷热','夸大','夸耀','夸张','狂暴','狂怒','狂躁','旷工','亏本','亏待','亏损','匮乏','困顿','困境','困窘','困局','困苦','困难','困难重重','困扰','垃圾','拉拢','赖账','拦截','拦路虎','懒惰','懒散','烂尾','滥用','浪费','老化','老弱病残','勒令','勒索','雷同','羸弱','累赘','冷淡','冷风','冷宫','冷清','冷遇','离间','力不从心','历经波折','利己','利空','利润减少','利润降低','利益受损','利益输送','利诱','良莠不齐','两难','劣势','劣质','裂痕','凌乱','零落','零增长','流产','流动性低','流离','流失','垄断','陋习','漏报','漏洞','漏税','乱世','乱象','掠夺','掠取','沦为','落后','落后于','落架','落空','落伍','屡教不改','屡禁不止','麻痹','麻痹大意','麻烦','麻木','马虎','埋怨','买通','卖国','蛮荒','忙乱','盲从','盲目','盲区','猫腻','毛病','矛盾','冒充','冒进','冒牌','冒险','贸然','没落','没收','每况愈下','迷茫','迷雾','迷信','糜烂','密谋','免职','勉强','面临淘汰','渺茫','藐视','敏感','模糊','模糊不清','摩擦','摩擦增加','磨难','磨损','魔鬼','魔咒','末路','末日','漠视','墨守成规','牟利','牟取','难处','难度加大','难度上升','难度增大','难度增加','难过','难解','难堪','难实现','难逃','难题','难突破','难维持','难以','闹事','内耗','内乱','内幕','内难','内外交困','内忧','内忧外患','能力不足','能力差','能力弱','逆境','逆流','年久失修','捏造','扭曲','弄虚作假','虐待','挪用','排斥','排挤','排外','徘徊','盘剥','判刑','彷徨','庞杂','抛弃','抛售','泡沫','炮制','赔本','赔偿','碰壁','碰撞','批判','批评','纰漏','疲劳','疲软','疲弱','疲态','偏差','偏低','偏见','偏紧','偏离','偏颇','偏袒','偏心','偏执','片面','骗取','剽窃','贫乏','贫瘠','贫困','贫穷','贫弱','平庸','瓶颈','泼辣','迫不得已','迫不及待','迫使','迫于','破财','破产','破发','破坏','破旧','破裂','破落','破灭','破碎','扑朔迷离','铺张','铺张浪费','曝光','欺负','欺骗','欺诈','歧视','企图','起诉','气短','气馁','弃权','千篇一律','牵连','牵制','前景不明','前科','钱荒','潜逃','遣散','谴责','欠佳','欠款','欠缺','欠妥','欠债','歉收','强行','强加','强迫','强求','强硬','强占','强制','抢夺','敲诈','敲诈勒索','窃密','窃取','侵犯','侵害','侵权','侵扰','侵入','侵蚀','侵吞','侵袭','侵占','青黄不接','轻视','轻信','倾覆','倾销','清仓','清盘','清算','穷困','穷途末路','求全','驱使','驱逐','屈才','屈服','趋紧','曲解','曲折','取消资格','圈钱','圈套','缺点','缺乏','缺憾','缺口','缺漏','缺欠','缺少','缺失','缺损','缺位','缺陷','裙带','染指','让位','扰乱','扰民','任性','冗余','冗员','冗杂','冗长','如履薄冰','入不敷出','入侵','软肋','软弱','软硬兼施','锐减','弱点','弱化','弱势','弱小','撒野','散布','丧失','骚乱','骚扰','杀害','煽动','闪失','擅自','伤害','奢侈','奢华','奢靡','涉案','涉事','涉嫌','深陷','深重','甚微','生气','生事','生疑','生硬','失败','失策','失察','失当','失和','失衡','失控','失利','失灵','失落','失去','失实','失事','失调','失望','失误','失效','失信','失意','失职','施压','事端','事故','是非','收买','收缩','收窄','手段','手腕','守旧','首当其冲','受挫','受罚','受害','受贿','受累','受难','受骗','受气','受损','受限','受压','受制','受阻','疏忽','疏于','束缚','束手无策','衰败','衰竭','衰落','衰弱','衰退','衰亡','双规','双输','水平低','私吞','私自','死灰复燃','四面楚歌','肆虐','肆意','松弛','松散','松懈','怂恿','搜罗','诉讼','算计','随波逐流','损害','损耗增加','损坏','损毁','损伤','唆使','缩减','缩水','缩小','缩窄','所剩无几','索贿','索赔','索要','琐碎','塌陷','贪婪','贪图','贪污','瘫痪','昙花一现','搪塞','掏空','逃避','逃离','逃税','逃亡','淘汰','讨价还价','套现','提心吊胆','天灾','添堵','挑剔','调减','停摆','停产','停顿','停工','停机','停售','停业','停滞','通病','通缉','通缩','通胀','同伙','同谋','同质化','痛心','偷盗','偷工减料','偷窃','偷税','投机','投诉','图谋','涂炭','团伙','推波助澜','推迟','推翻','推后','推脱','颓势','退步','退化','退却','退缩','吞噬','拖后腿','拖拉','拖累','拖欠','拖沓','拖延','脱节','脱离','瓦解','歪风','歪曲','外泄','玩忽职守','玩弄','顽固','顽疾','网罗','妄想','危害','危机','危机四伏','危机重重','危及','危局','危险','威胁','微薄','微乎其微','微利','微弱','为难','违背','违法','违反','违犯','违规','违纪','违禁','违约','围剿','伪劣','伪造','伪装','委靡','委屈','委婉','萎靡','萎靡不振','萎缩','未偿还','未经许可','畏惧','畏难','紊乱','窝点','乌合之众','乌云','污点','污秽','污蔑','污染','污水','污损','污浊','无常','无度','无端','无故','无节制','无赖','无理','无力','无利可图','无聊','无名','无奈','无能','无能为力','无情','无人问津','无视','无望','无效','无序','无用','无照经营','无知','无中生有','无助','武断','侮辱','舞弊','物价上涨','误导','误解','误区','误入','误诊','洗钱','狭隘','狭小','狭窄','瑕疵','下场','下挫','下等','下跌','下岗','下行','下滑','下降','下调','先扬后抑','闲置','嫌疑','险象环生','险阻','限贷','限售','限制','陷害','陷阱','陷落','陷入','相差甚远','向下','消耗','消极','消减','消失','消亡','萧条','小气','小人','小偷','效率低','效益低','胁迫','泄露','泄密','泄气','懈怠','心烦','心烦意乱','心痛','辛酸','新低','信心不足','刑事','形式主义','形同虚设','性价比低','虚报','虚高','虚构','虚假','虚惊','虚开','虚名','虚荣','虚弱','虚伪','虚增','蓄意','喧嚣','漩涡','炫耀','削价','削减','削弱','噱头','雪崩','雪上加霜','训诫','逊色','压低','压价','压力','压迫','压抑','压榨','压制','延迟','延后','延缓','延期','延误','严峻','严苛','严酷','严厉','严重','炎热','掩护','厌恶','厌倦','殃及','夭折','腰斩','谣言','摇摆','野蛮','一波三折','一成不变','一蹶不振','一落千丈','一损俱损','一言堂','依仗','贻误','遗憾','遗留','遗漏','遗弃','疑惑','疑虑','疑云','以次充好','异常','异动','异议','抑郁','抑制','易怒','意外','因循守旧','阴暗','阴跌','阴霾','阴谋','阴影','阴云','淫秽','引诱','隐藏','隐患','隐瞒','隐忧','迎合','盈利减少','盈利下降','营私舞弊','拥挤','臃肿','忧患','忧虑','忧伤','由盈变亏','犹豫','有毒','有害','有价无市','有失公允','幼稚','诱发','诱惑','诱使','鱼龙混杂','鱼目混珠','逾期','郁闷','预减','遇难','遇险','遇阻','愈演愈烈','元凶','怨天尤人','约束','越境','越权','杂乱','杂乱无章','杂牌','杂音','杂质','灾害','灾祸','灾难','灾难性','再犯','赃款','脏污','遭到','遭受','遭遇','糟糕','糟粕','早衰','造假','造谣','造作','噪音','躁狂','责备','责问','增加费用','增加难度','诈骗','摘牌','沾染','瞻前顾后','斩仓','战火','战乱','战战兢兢','战争','障碍','招致','召回','肇事','折价','震荡','震惊','争议','挣扎','支出上升','止步不前','纸老虎','指控','指使','指责','制裁','制约','质量低','质疑','桎梏','致命','致歉','窒息','滞后','滞销','滞涨','置疑','置之不理','中断','中计','终止','重创','重挫','重负','重复建设','重灾区','周转慢','骤减','助长','注水','注销','专权','专制','转嫁','追究','坠毁','坠落','捉襟见肘','资不抵债','滋生','滋长','自大','自负','自毁','自满','自相矛盾','纵容','走低','走过场','走弱','走私','租金上涨','阻碍','阻挡','阻隔','阻力','阻挠','阻塞','阻滞','最差','最坏','罪恶','罪犯','罪行','罪名','作弊','作对','作废','作假','坐井观天','坐享其成','做作',]
#非正式-肯定情绪词典
UNFORMAL_pos_words = ['爱心','安定','安全','安然无恙','安泰','霸主','百里挑一','百炼成钢','拜服','榜首','榜样','饱满','宝贵','保障','报恩','报喜','暴增','暴涨','爆发','爆增','爆涨','必胜','必涨','便捷','便利','便宜','标杆','飙升','飚升','表扬','表彰','禀赋','并进','补涨','不错','不含糊','不愧','不怕','不平凡','不缺钱','不泄气','不遗余力','不涨都难','才华横溢','才思敏捷','财运','彩头','蝉联','敞亮','畅快','畅通','畅销','超凡脱俗','超群','超预期','超越','朝阳','潮流','称霸','称颂','称雄','称赞','成本下降','成功','成果','成绩','成就','成熟','成效','成长','诚信','承上启下','吃得开','吃香','持久','持之以恒','叱咤风云','充分','充实','充裕','充足','出彩','出色','出众','创记录','创纪录','创新','创新高','创意','创造','春光明媚','春天','慈善','聪明','从善如流','促进','达标','答谢','大爆发','大胆','大发','大好时机','大获','大吉','大快人心','大佬','大力','大牛市','大手笔','大受欢迎','大笑','大有可为','大有希望','大有作为','大增','大涨','胆大','胆大心细','胆略','道谢','得力','得人心','得益','德高望重','低买','滴水不漏','底气足','底蕴','第一','典范','典型','点赞','奠定','顶梁柱','定心丸','东风','动力','独创','独创性','独到','独家','独具慧眼','独领风骚','独树一帜','多样化','夺得','耳熟能详','发财','发达','发大财','发力','发明','发展','发展潜力','法宝','翻倍','翻番','翻红','翻身仗','繁华','繁荣','反弹','放心','飞驰','飞腾','奋进','奋勇争先','丰富','丰功伟绩','丰厚','丰饶','丰收','风光','风景如画','风平浪静','风趣','风雨无阻','扶持','福利','福星','复苏','富民','富余','富裕','改革','改观','改进','改良','改善','肝胆相照','感谢','感兴趣','干净','高产','高潮','高档','高度评价','高风亮节','高峰','高富帅','高歌','高升','高效率','高兴','高于','给力','更好','更进一步','更强','更新换代','功成名就','恭贺','恭喜','贡献','股神','鼓励','鼓舞','固若金汤','光彩','光明','光明磊落','光明正大','广阔','贵人','果断','果决','过关','过瘾','过硬','哈哈','汗马功劳','行云流水','豪华','豪气','好榜样','好处','好股','好股票','好机会','好价钱','好看','好评','好人','好日子','好事','好爽','好玩','好消息','好样','好转','浩气','合法','合理','合算','和解','和睦','和谐','贺喜','黑马','很好','很爽','横空出世','红火','红利','宏伟','后劲十足','后来居上','互助','华丽','欢呼','欢聚','欢快','欢乐','欢欣','欢欣鼓舞','欢迎','欢娱','欢愉','缓解','焕发','黄金','诙谐','恢复','辉煌','回报','回暖','回升','回味无穷','回涨','会涨','惠及','豁然','活力','活跃','火暴','火热','获奖','获利','获益','机会','机遇','积极','积蓄','跻身','激动人心','激发','及时','极致','技术升级','绩优','加油','佳绩','佳境','尖端','坚定','坚强','坚强不屈','坚实','坚守','坚挺','俭朴','见多识广','健康','健全','渐入佳境','奖励','佼佼者','脚踏实地','叫好','皆大欢喜','节能','节约','杰出','解放','解封','解决','解套','解围','金奖','金牌','锦囊妙计','锦旗','谨言慎行','尽职','进步','进取','进展','晋升','经典','惊喜','精采','精彩','精诚','精力','精力充沛','精密','精明强干','精品','精确','精神饱满','精髓','精通','精细','精心','精湛','井井有条','净化','竞争力','居前','巨人','绝好','绝佳','崛起','君子','开创','开放','开门红','开辟','开拓','开心','楷模','看得上','看多','看好','看涨','扛住','抗跌','犒劳','靠得住','靠谱','靠前','可观','可行','可靠','可喜','可信赖','客观','肯定','空转多','口碑','苦功','苦心孤诣','跨越','快捷','快乐','快马加鞭','快买','快速','宽恕','宽裕','狂喜','狂涨','扩充','扩大','扩展','拉高','拉升','拉涨','蓝图','牢固','乐观','乐呵呵','乐趣','乐意','了不起','冷静','理顺','理想','理性','厉害','立功','利好','利器','利润','连翻','连冠','连阳','连涨','良策','良好','良机','良性','灵感','灵活','领导者','领跑者','领头羊','领先','领衔','领涨','令人高兴','令人鼓舞','令人钦佩','柳暗花明','龙头','落实','率先','马到成功','迈进','蛮好','满腔热情','满意','满足','美观','美好','美景','美丽','美誉','美滋滋','猛士','猛增','猛涨','梦寐以求','梦想成真','名牌','名气','名声大振','明辨是非','明察秋毫','明朗','明晰','明星','明智','明珠','鸣谢','模范','耐用','凝聚力','牛股','牛气','牛散','牛市','努力','排头兵','攀升','抛砖引玉','培育','佩服','蓬勃','鹏程万里','漂亮','平安无事','平平安安','平稳','魄力','期待','齐全','其乐融融','其乐无穷','奇迹','旗开得胜','企稳','起飞','起色','气魄','气宇轩昂','契机','器重','恰到好处','千里马','前赴后继','前列','前茅','前途无量','前沿','潜力','潜力大','潜力股','强大','强化','强劲','强力','强势','强者','抢筹','抢手','切实','勤勉','轻松','清晰','情有独钟','庆祝','取胜','全面','全新','冉冉升起','热潮','热忱','热火朝天','热烈庆祝','热烈祝贺','热门','热闹','热情','热情洋溢','热销','人心所向','仁慈','日新月异','荣登','荣获','荣幸','荣耀','荣膺','荣誉','融洽','柔情','如日中天','如意','如愿以偿','入选','润色','洒脱','善事','擅长','商机','上榜','上行','上升','上扬','上游','上涨','神采','神奇','神速','升华','升级','升值','生机','声誉','胜出','胜过','胜利','胜诉','胜仗','盛产','盛典','盛宴','盛誉','时机成熟','实惠','实事求是','实效','示范','势不可挡','拭目以待','收获','首创','首屈一指','首位','受欢迎','受益','殊荣','舒服','舒适','熟练','曙光','数一数二','双赢','爽','爽死','爽歪歪','顺畅','顺利','硕果','所向无敌','太好','太爽','叹为观止','讨人喜欢','特色','腾飞','提拔','提高','提升','提速','甜头','挑大梁','贴心','铁面无私','挺进','挺直腰杆','挺住','同意','统一','头脑清醒','突出','突飞猛进','突破','推崇','推动','推广','推荐','推进','妥当','拓展','哇塞','完备','完好','完美','完善','完整','万众瞩目','王者','旺盛','旺销','威严','微笑','唯一','伟大','未雨绸缪','稳步','稳定','稳固','稳健','稳妥','稳中求进','稳赚','无价之宝','无可非议','无可置疑','无所不能','无所畏惧','无懈可击','务实','吸金','吸引','吸引力','吸引人','喜爱','喜报','喜获','喜庆','喜人','喜事','喜笑颜开','喜讯','喜洋洋','细致','瑕不掩瑜','先锋','先行','先行者','先河','先进','咸鱼翻身','显著','献花','相信','香饽饽','享有','向好','向上','像样','小有名气','谢天谢地','谢谢','欣然','欣慰','欣喜','新高','新局面','新台阶','新鲜','新星','新兴','新颖','信赖','信任','信心','信心满满','兴奋','兴高采烈','兴起','兴盛','兴旺','幸福','幸亏','幸事','幸运','幸运儿','雄风','雄厚','雄纠纠','雄赳赳','雄起','学识渊博','雪中送炭','压轴戏','严谨','严密','言简意赅','眼明手快','扬帆起航','扬眉吐气','扬升','扬长避短','养眼','要大涨','要买','要涨','一帆风顺','一飞冲天','一流','一路升','一鸣惊人','益处','因地制宜','引吭高歌','英姿飒爽','迎难而上','盈利','赢得','赢家','赢利','硬汉','勇敢','勇气','用心','优点','优厚','优惠','优良','优势','优先','优秀','优异','优越','优质','由亏变盈','友好','有把握','有保障','有福气','有力','有利','有良心','有两手','有魅力','有目共睹','有趣','有所斩获','有条不紊','有望','有希望','有戏','有效','有效率','有眼光','有眼力','有一手','有一套','有益','有种','有助','诱人','愉快','愉悦','圆满','跃居','载歌载舞','再接再厉','再涨','在理','赞不绝口','赞歌','赞美','赞赏','赞颂','赞叹不已','赞誉','赞赞','赞赞赞','造就','增持','增光','增加','增进','增强','增色','增长','增值','崭新','战斗机','站稳脚跟','长盛不衰','涨','涨幅','涨势','涨停','涨停板','真好','真牛','真爽','真心真意','振奋','振兴','蒸蒸日上','正能量','支持','知名','知足','值得','值得称赞','止跌','止跌回稳','止跌企稳','制胜','致富','智慧','中选','忠诚','忠告','忠心耿耿','忠贞','众望所归','重生','重振','周到','周密','主力军','主旋律','祝福','祝贺','著名','专长','转暖','转型升级','赚不少','赚大','赚大钱','赚翻天','赚个够','赚钱','壮大','追捧','准确','卓越','自告奋勇','自主','走出低谷','走高','走强','最好','最好看','最佳','最牛','尊敬','做得好','做多','做强',]
#非正式-否定情绪词典
UNFORMAL_neg_words = ['哀鸿遍野','肮脏','罢免','白痴','败笔','败诉','半信半疑','包袱','保守','抱怨','暴跌','暴发','暴风雨','暴力','暴利','暴露','杯具','卑鄙','悲哀','悲惨','悲观','背离','被动','被告','被迫','被套','崩溃','崩盘','逼疯','逼迫','鄙视','必跌','必死','必套','边缘化','编造','贬值','变幻莫测','变态','变相','便秘','婊子','别买','病毒','病态','波动','波折','剥夺','驳回','补跌','不安','不成熟','不当','不道德','不负责任','不敢买','不给力','不够','不光彩','不行','不好','不合','不景气','不堪','不堪设想','不看好','不靠谱','不可告人','不利','不买账','不满意','不妙','不能买','不跑等死','不碰','不平衡','不爽','不现实','不屑','不幸','不要跟','不要脸','不要买','不一致','不宜','不友好','不愿意','不再','不择手段','不涨反跌','不振','不争气','不知去向','不值','不自量力','不足','猜忌','踩雷','踩踏','残','残酷','蚕食','惨','惨败','惨淡','惨剧','惨烈','操心','操纵','草包','差错','差评','差强人意','拆台','掺杂','猖獗','唱反调','抄袭','超跌','朝令夕改','嘲弄','炒作','扯蛋','扯皮','撤回','撤离','撤退','沉寂','沉重','成本高','承受','惩罚','吃错药','吃亏','冲高回落','冲击','冲突','愁','丑行','丑陋','丑闻','臭','臭股','臭骂','臭名','臭气熏天','出局','出卖','出事','出逃','处罚','畜生','触目惊心','触怒','串通','蠢庄','粗话','篡夺','篡改','篡权','脆弱','挫败','挫折','错过','错配','错失','错误','打倒','打击','打入冷宫','打水漂','打压','大便','大跌','大起大落','大失所望','大势已去','大肆','大洗牌','大熊市','呆账','呆滞','逮捕','代价','担心','担忧','耽误','蛋疼','倒闭','倒大霉','倒卖','倒霉','倒数第一','倒塌','倒贴','倒退','倒下','等死','低谷','低级','低开','低迷','低水平','低位','诋毁','抵赖','抵制','地雷','颠倒','垫底','刁难','跌','跌不止','跌倒','跌得快','跌幅','跌破','跌势','跌死','跌停','跌无止境','跌眼镜','顶不住','丢脸','丢人','丢人现眼','丢失','动荡','动摇','毒品','毒手','渎职','堵死','赌博','短板','短缺','断裂','断头','对不起','对抗','堕落','恶臭','恶毒','恶果','恶化','恶劣','恶心','恶意','恶庄','噩耗','噩梦','二百五','二货','发愁','发疯','发牢骚','乏力','罚款','烦','烦恼','烦心','烦躁','繁琐','反常','反对','反复','犯错','犯罪','妨碍','放弃','非法','非理性','诽谤','废柴','废物','分歧','坟墓','粉碎','愤怒','风暴','风波','风险','封闭','疯狗','疯狂','疯子','奉承','否定','否决','肤浅','腐败','负担','负荷','负面','负债','复杂','该死','尴尬','干扰','高估','高开低走','搁浅','割肉','攻击','共谋','苟延残喘','狗屁','狗日','狗屎','狗熊','诟病','孤独','辜负','股灾','蛊惑','鼓吹','鼓动','故步自封','故意','故障','关闭','观望','规避','诡计','鬼话','滚蛋','过不去','过大','过度','过分','过节','过期','过剩','过时','还会跌','害惨','害怕','害人','害死','汗颜','毫无意义','好逊','耗费','合谋','何必','黑暗','黑幕','黑哨','黑天鹅','很难','红眼','哄抬','后顾之忧','后果','后悔','忽视','忽悠','滑坡','怀疑','坏','坏消息','坏账','缓慢','荒废','慌不择路','谎言','幌子','回避','回扣','回落','回调','贿赂','混乱','混淆','活该','活埋','祸','激进','极度','急功近利','急剧','加剧','假公济私','假冒','艰难','煎熬','减持','减少','贱','贱货','僵局','降低','骄傲自大','焦虑','焦躁','搅乱','教训','揭露','紧缩','紧张','进退两难','警告','窘境','纠缠','纠纷','纠结','酒鬼','巨亏','绝望','开除','堪忧','坎坷','看不起','看不顺眼','看淡','看跌','扛不住','抗不住','靠不住','苛刻','可悲','可恶','可恨','可怜','可怕','可叹','可笑','坑害','坑骗','坑人','坑散户','空虚','恐怖','恐慌','恐惧','恐怕','控诉','枯竭','夸张','快卖','快逃','狂跌','狂泻','亏','亏本','亏死','亏损','愧疚','困顿','困惑','困境','困难','困扰','垃圾','垃圾股','拉屎','拉稀','来气','赖账','烂逼','烂臭股','烂股','烂货','滥用','浪费','老鼠','冷淡','冷落','冷清','利空','利益输送','连跌','廉价','劣势','劣质','零乱','令人失望','垄断','漏洞','漏洞百出','乱叫','掠夺','沦落','沦为','落败','落后','落空','落魄','落伍','妈比','麻痹','麻烦','麻木','骂','骂大街','骂街','骂娘','骂人','卖弄','谩骂','盲目','猫腻','矛盾','冒充','冒险','没出息','没得救','没劲','没救','没落','没前途','没收','没戏','没信心','没意思','没用','没指望','霉运','猛跌','迷惑','勉强','明争暗斗','磨难','末日','陌生','漠视','墨迹','牟利','谋私','目光短浅','难处','难过','难堪','难看','难上加难','难受','难题','难有作为','孬种','闹哪样','内幕','尼玛','你死我活','鸟公司','鸟股','扭曲','脓包','弄虚作假','奴化','怒骂','挪用','怕事','怕死','徘徊','抛弃','抛售','跑路','跑输','跑输大盘','泡沫','泡汤','炮制','呸','赔偿','赔光','赔钱','碰壁','批评','疲软','疲弱','疲态','偏差','偏离','骗','骗局','骗取','骗人','骗子','拼命','瓶颈','迫使','迫于','破产','破发','破股','破坏','破裂','破鞋','曝光','凄凉','欺瞒','欺骗','欺诈','奇葩','企图','起哄','起诉','起疑心','气愤','气死','弃权','谴责','强权','强制','敲诈','侵犯','侵害','侵权','侵蚀','侵吞','侵占','轻率','轻易','穷途末路','曲折','去死','圈钱','圈套','缺德','缺点','缺乏','缺口','缺失','缺陷','扰乱','任性','任意','软蛋','软弱','弱点','弱势','散布','丧失','骚','骚扰','杀跌','傻','傻逼','擅自','伤害','上当','涉嫌','深跌','深套','深陷','生气','生硬','失败','失衡','失控','失利','失灵','失落','失去','失望','失误','失效','失血','失意','失职','食言','屎','似是而非','事倍功半','事故','收买','手段','手贱','受挫','受害','受限','受影响','疏忽','束缚','衰竭','衰落','衰退','说谎','死','死板','死逼','死叉','死翘翘','死全家','四面楚歌','肆虐','肆无忌惮','诉苦','诉讼','损害','损耗','损失','索赔','踏空','太差','太黑','太烂','太弱','贪官','贪婪','贪图','贪污','瘫痪','昙花一现','逃离','逃命','逃跑','逃亡','淘汰','套牢','套死','套现','套住','天打雷劈','天花乱坠','天怒人怨','添堵','挑战','跳空','跳楼','跳水','铁公鸡','停产','停滞','通胀','痛苦','偷鸡','偷漏税','投机','投诉','吐血','推迟','颓势','退出','退市','拖后腿','拖累','挖坑','歪风','歪曲','完蛋','玩不起','玩蛋','玩忽职守','玩完','危害','危机','危及','危险','威胁','违背','违法','违反','违规','违纪','违约','唯利是图','惟恐','伪造','伪装','委靡','萎靡','萎缩','畏首畏尾','瘟鸡','瘟疫','问题','污染','无耻','无底洞','无法','无稽之谈','无赖','无力','无良','无奈','无能','无能为力','无望','无效','无用','无语','无知','舞弊','误导','误区','瞎忙','瑕疵','下场','下挫','下跌','下行','下滑','下降','下台','下调','嫌疑','险恶','限售','限制','陷井','陷阱','陷入','向下','消耗','消极','消失','萧条','嚣张','小人','泄漏','泄露','泄密','心烦','心寒','心碎','心痛','新低','兴风作浪','凶残','凶险','熊市','熊样','虚报','虚构','虚假','虚张声势','蓄意','悬而未决','炫耀','削弱','噱头','逊色','压低','压力','压力山大','压抑','压制','延迟','延期','延误','严峻','严厉','严重','妖魔','谣言','遥遥无期','要命','一败涂地','一毛不拔','一损俱损','一味','一直跌','遗憾','遗漏','疑惑','异常','异动','抑制','意外','阴暗','阴跌','阴霾','阴谋','阴险','阴影','引诱','隐藏','隐患','隐瞒','庸人','忧虑','由盈变亏','犹豫','犹豫不决','有病','有毒','有害','有问题','幼稚','诱饵','诱惑','诱骗','逾期','愚蠢','郁闷','欲哭无泪','遇阻','冤大头','远离','怨气','怨言','约束','杂乱无章','杂质','杂种','砸盘','灾害','灾祸','灾难','灾难性','宰','脏乱','遭雷劈','遭受','遭遇','造成','造假','造谣','噪音','诈骗','战争','张狂','涨不动','障碍','折磨','真他妈','真无耻','震荡','震惊','争斗','纸上谈兵','指责','制裁','制约','质问','质疑','致命','致使','智障','滞后','滞销','滞涨','终止','重灾区','注水','庄','庄家','庄托','装逼','装孙子','追究','追讨','自暴自弃','自取灭亡','自私','自以为是','自作孽','纵容','走低','走后门','走人','走弱','走下坡','阻碍','阻挡','阻力','最差','最坏','最烂','罪人','左右为难','做空','做作',]

























class SoPmi:
    """

    """
    def __init__(self, cwd, input_txt_file, seedword_txt_file):
        """
        :param cwd:  代码项目文件路径，传入os.getcwd()即可
        :param input_txt_file:  构建diy词典的语料txt文件路径
        :param seedword_txt_file:  人工筛选的种子词txt文件路径
        """
        self.cwd = cwd
        self.text_file = input_txt_file
        self.seedword_txt_file = seedword_txt_file

    '''分词'''
    def seg_corpus(self, train_data, seedword_txt_file):
        #将情感词加入到用户词典当中，保证分词能够将种子情感词切开
        sentiment_words = [line.strip().split('\t')[0] for line in open(seedword_txt_file, encoding='utf-8')]
        for word in sentiment_words:
            jieba.add_word(word)
        seg_data = list()
        count = 0
        for line in open(train_data, encoding='utf-8'):
            line = line.strip()
            count += 1
            if line:
                seg_data.append([word.word for word in pseg.cut(line) if word.flag[0] not in ['u','w','x','p','q','m']])
            else:
                continue
        return seg_data

    '''统计搭配次数'''
    def collect_cowords(self, seedword_txt_file, seg_data):
        def check_words(sent):
            if set(sentiment_words).intersection(set(sent)):
                return True
            else:
                return False

        cowords_list = list()
        window_size = 5
        count = 0
        sentiment_words = [line.strip().split('\t')[0] for line in open(seedword_txt_file, encoding='utf-8')]
        for sent in seg_data:
            count += 1
            if check_words(sent):
                for index, word in enumerate(sent):
                    if index < window_size:
                        left = sent[:index]
                    else:
                        left = sent[index - window_size: index]
                    if index + window_size > len(sent):
                        right = sent[index + 1:]
                    else:
                        right = sent[index: index + window_size + 1]
                    context = left + right + [word]
                    if check_words(context):
                        for index_pre in range(0, len(context)):
                            if check_words([context[index_pre]]):
                                for index_post in range(index_pre + 1, len(context)):
                                    cowords_list.append(context[index_pre] + '@' + context[index_post])
        return cowords_list

    '''计算So-Pmi值'''
    def collect_candiwords(self, seg_data, cowords_list, seedword_txt_file):
        '''互信息计算公式'''
        def compute_mi(p1, p2, p12):
            return math.log2(p12) - math.log2(p1) - math.log2(p2)
        '''统计词频'''
        def collect_worddict(seg_data):
            word_dict = dict()
            all = 0
            for line in seg_data:
                for word in line:
                    if word not in word_dict:
                        word_dict[word] = 1
                    else:
                        word_dict[word] += 1
            all = sum(word_dict.values())
            return word_dict, all
        '''统计词共现次数'''
        def collect_cowordsdict(cowords_list):
            co_dict = dict()
            candi_words = list()
            for co_words in cowords_list:
                candi_words.extend(co_words.split('@'))
                if co_words not in co_dict:
                    co_dict[co_words] = 1
                else:
                    co_dict[co_words] += 1
            return co_dict, candi_words
        '''收集种子情感词'''
        def collect_sentiwords(seedword_txt_file, word_dict):
            pos_words = set([line.strip().split('\t')[0] for line in open(seedword_txt_file, encoding='utf-8') if
                             line.strip().split('\t')[1] == 'pos']).intersection(set(word_dict.keys()))
            neg_words = set([line.strip().split('\t')[0] for line in open(seedword_txt_file, encoding='utf-8') if
                             line.strip().split('\t')[1] == 'neg']).intersection(set(word_dict.keys()))
            return pos_words, neg_words
        '''计算sopmi值'''
        def compute_sopmi(candi_words, pos_words, neg_words, word_dict, co_dict, all):
            pmi_dict = dict()
            for candi_word in set(candi_words):
                pos_sum = 0.0
                neg_sum = 0.0
                for pos_word in pos_words:
                    p1 = word_dict[pos_word] / all
                    p2 = word_dict[candi_word] / all
                    pair = pos_word + '@' + candi_word
                    if pair not in co_dict:
                        continue
                    p12 = co_dict[pair] / all
                    pos_sum += compute_mi(p1, p2, p12)

                for neg_word in neg_words:
                    p1 = word_dict[neg_word] / all
                    p2 = word_dict[candi_word] / all
                    pair = neg_word + '@' + candi_word
                    if pair not in co_dict:
                        continue
                    p12 = co_dict[pair] / all
                    neg_sum += compute_mi(p1, p2, p12)

                so_pmi = pos_sum - neg_sum
                pmi_dict[candi_word] = so_pmi
            return pmi_dict

        word_dict, all = collect_worddict(seg_data)
        co_dict, candi_words = collect_cowordsdict(cowords_list)
        pos_words, neg_words = collect_sentiwords(seedword_txt_file, word_dict)
        pmi_dict = compute_sopmi(candi_words, pos_words, neg_words, word_dict, co_dict, all)
        return pmi_dict

    '''保存结果'''
    def save_candiwords(self, pmi_dict):
        def get_tag(word):
            if word:
                return [item.flag for item in pseg.cut(word)][0]
            else:
                return 'x'
        pos_dict = dict()
        neg_dict = dict()
        Path(self.cwd).joinpath('output', 'sopmi_candi_words').mkdir(exist_ok=True)
        negfile= Path(self.cwd).joinpath('output', 'sopmi_candi_words', 'neg.txt')
        posfile= Path(self.cwd).joinpath('output', 'sopmi_candi_words', 'pos.txt')

        f_neg = open(negfile, 'w+', encoding='utf-8')
        f_pos = open(posfile, 'w+', encoding='utf-8')

        for word, word_score in pmi_dict.items():
            if word_score > 0:
                pos_dict[word] = word_score
            else:
                neg_dict[word] = abs(word_score)

        for word, pmi in sorted(pos_dict.items(), key=lambda asd:asd[1], reverse=True):
            f_pos.write(word + ',' + str(pmi) + ',' + 'pos' + ',' + str(len(word)) + ',' + get_tag(word) + '\n')
        for word, pmi in sorted(neg_dict.items(), key=lambda asd:asd[1], reverse=True):
            f_neg.write(word + ',' + str(pmi) + ',' + 'neg' + ',' + str(len(word)) + ',' + get_tag(word) + '\n')
        f_neg.close()
        f_pos.close()
        return

    def sopmi(self):
        print('step 1/4:...seg corpus ...')
        start_time  = time.time()
        seg_data = self.seg_corpus(self.text_file, self.seedword_txt_file)
        end_time1 = time.time()
        print('step 1/4 finished:...cost {0}...'.format((end_time1 - start_time)))
        print('step 2/4:...collect cowords ...')
        cowords_list = self.collect_cowords(self.seedword_txt_file, seg_data)
        end_time2 = time.time()
        print('step 2/4 finished:...cost {0}...'.format((end_time2 - end_time1)))
        print('step 3/4:...compute sopmi ...')
        pmi_dict = self.collect_candiwords(seg_data, cowords_list, self.seedword_txt_file)
        end_time3 = time.time()
        print('step 1/4 finished:...cost {0}...'.format((end_time3 - end_time2)))
        print('step 4/4:...save candiwords ...')
        self.save_candiwords(pmi_dict)
        end_time = time.time()
        print('finished! cost {0}'.format(end_time - start_time))







class W2VModels(object):
    def __init__(self, cwd, lang='english'):
        """
        模型初始化设置
        :param cwd:  当前工作路径
        :param lang:  数据的语言
        """
        self.cwd = cwd
        self.lang = lang
        self.start = time.time()


    def __preproces(self, documents):
        """
        对数据进行预处理,分词、去除停用词；   可以加单词同类型合并的
        :param documents:  文档列表
        :return:  清洗后的文档列表
        """


        docs = []
        if self.lang=='english':
            for document in documents:
                document = document.lower()
                document = [w for w in word_tokenize(document) if w not in STOPWORDS_en]
                docs.append(document)
            return docs
        elif self.lang=='chinese':
            for document in documents:
                words = jieba.lcut(document)
                document = [w for w in words if w not in STOPWORDS_zh]
                docs.append(document)
            return docs
        else:
            assert 'Do not support {} language'.format(self.lang)



    def train(self, input_txt_file, min_count=1):
        """
        训练语料库的word2vec模型
        :param input_txt_file:  传入的语料数据文件
        :param min_count: 模型中词语最少在语料中出现min_count次
        :return:
        """
        documents = list(open(input_txt_file).readlines())
        print('数据预处理开始.......')
        sentences = self.__preproces(documents=documents)
        print('预处理结束...........')
        print('Word2Vec模型训练开始......')
        self.model = word2vec.Word2Vec(sentences, min_count=min_count, workers=multiprocessing.cpu_count())
        modeldir = Path(self.cwd).joinpath('output', 'w2v_candi_words')
        Path(self.cwd).joinpath('output', 'w2v_candi_words').mkdir(exist_ok=True)
        modelpath = str(Path(modeldir).joinpath('w2v.model'))
        self.model.save(modelpath)
        print('已将模型存入 {} '.format(str(modelpath)))



    def __search(self, seedword_txt_file, n=50):
        seedwords = [w for w in open(seedword_txt_file).read().split('\n') if w!='']
        self.similars_candidate_idxs = [] #seedwords的候选词
        dictionary = self.model.wv.key_to_index
        self.seedidxs = [] #把word 转化为 index
        for seed in seedwords:
            if seed in dictionary:
                seedidx = dictionary[seed]
                self.seedidxs.append(seedidx)
        for seedidx in self.seedidxs:
            # sims_words形如[('by', 0.99984), ('or', 0.99982), ('an', 0.99981), ('up', 0.99980)]
            sims_words = self.model.wv.similar_by_word(seedidx, topn=n)
            #将词语转为index存储起来
            self.similars_candidate_idxs.extend([dictionary[sim[0]] for sim in sims_words])
        self.similars_candidate_idxs = set(self.similars_candidate_idxs)




    def find(self, seedword_txt_file, topn=50):
        seedwordsname = seedword_txt_file.split('/')[-1].replace('.txt', '')
        seedwords = [w for w in open(seedword_txt_file).read().split('\n') if w]
        simidx_scores = []
        print('准备寻找每个seed在语料中所有的相似候选词')
        self.__search(seedword_txt_file)
        print('初步搜寻到 {} 个相似的候选词'.format(len(self.similars_candidate_idxs)))

        print('计算每个候选词 与 {seedwordsname} 的相似度， 选出相似度最高的前 {topn} 个候选词'.format(seedwordsname=seedwordsname, topn=topn))
        for idx in self.similars_candidate_idxs:
            score = self.model.wv.n_similarity([idx], self.seedidxs)
            simidx_scores.append((idx, score))
        simidxs = [w[0] for w in sorted(simidx_scores, key=lambda k:k[1], reverse=True)]

        simwords = [str(self.model.wv.index_to_key[idx]) for idx in simidxs][:topn]

        resultwords = []
        resultwords.extend(seedwords)
        resultwords.extend(simwords)

        txtdir = Path(self.cwd).joinpath('output', 'w2v_candi_words')
        Path(self.cwd).joinpath('output', 'w2v_candi_words').mkdir(exist_ok=True)
        candidatetxtfile = Path(txtdir).joinpath('{}.txt'.format(seedwordsname))
        with open(candidatetxtfile, 'w', encoding='utf-8') as f:
            for word in resultwords:
                f.write(word+'\n')
        duration = int(time.time()-self.start)
        print('已完成 【{seedwordsname} 类】 的词语筛选，并保存于 {txtfile}， 耗时 {duration} 秒'.format(seedwordsname=seedwordsname, txtfile=candidatetxtfile, duration=duration))
        print('\n\n')







