"use strict";
// Copyright 2012-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
exports.RedshiftMetrics = void 0;
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class RedshiftMetrics {
    static commitQueueLengthAverage(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'CommitQueueLength',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static concurrencyScalingActiveClustersAverage(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'ConcurrencyScalingActiveClusters',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static concurrencyScalingSecondsAverage(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'ConcurrencyScalingSeconds',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static cpuUtilizationAverage(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'CPUUtilization',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static databaseConnectionsAverage(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'DatabaseConnections',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static healthStatusSum(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'HealthStatus',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static maintenanceModeSum(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'MaintenanceMode',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static maxConfiguredConcurrencyScalingClustersSum(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'MaxConfiguredConcurrencyScalingClusters',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static networkReceiveThroughputSum(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'NetworkReceiveThroughput',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static networkTransmitThroughputSum(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'NetworkTransmitThroughput',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static numExceededSchemaQuotasAverage(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'NumExceededSchemaQuotas',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static percentageDiskSpaceUsedAverage(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'PercentageDiskSpaceUsed',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static percentageQuotaUsedAverage(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'PercentageQuotaUsed',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static queriesCompletedPerSecondSum(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'QueriesCompletedPerSecond',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static queryDurationAverage(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'QueryDuration',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static queryRuntimeBreakdownSum(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'QueryRuntimeBreakdown',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static readIopsSum(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'ReadIOPS',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static readLatencyAverage(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'ReadLatency',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static readThroughputSum(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'ReadThroughput',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static storageUsedAverage(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'StorageUsed',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static totalTableCountAverage(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'TotalTableCount',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static wlmQueriesCompletedPerSecondAverage(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'WLMQueriesCompletedPerSecond',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static wlmQueryDurationAverage(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'WLMQueryDuration',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static wlmQueueLengthSum(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'WLMQueueLength',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static writeIopsSum(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'WriteIOPS',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static writeLatencyAverage(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'WriteLatency',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static writeThroughputSum(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'WriteThroughput',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static wlmQueueWaitTimeAverage(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'WLMQueueWaitTime',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static wlmRunningQueriesAverage(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'WLMRunningQueries',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
}
exports.RedshiftMetrics = RedshiftMetrics;
//# sourceMappingURL=data:application/json;base64,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