"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.executeStatement = void 0;
/* eslint-disable-next-line import/no-extraneous-dependencies */
const RedshiftData = require("aws-sdk/clients/redshiftdata");
const redshiftData = new RedshiftData();
async function executeStatement(statement, clusterProps) {
    const executeStatementProps = {
        ClusterIdentifier: clusterProps.clusterName,
        Database: clusterProps.databaseName,
        SecretArn: clusterProps.adminUserArn,
        Sql: statement,
    };
    const executedStatement = await redshiftData.executeStatement(executeStatementProps).promise();
    if (!executedStatement.Id) {
        throw new Error('Service error: Statement execution did not return a statement ID');
    }
    await waitForStatementComplete(executedStatement.Id);
}
exports.executeStatement = executeStatement;
const waitTimeout = 100;
async function waitForStatementComplete(statementId) {
    await new Promise((resolve) => {
        setTimeout(() => resolve(), waitTimeout);
    });
    const statement = await redshiftData.describeStatement({ Id: statementId }).promise();
    if (statement.Status !== 'FINISHED' && statement.Status !== 'FAILED' && statement.Status !== 'ABORTED') {
        return waitForStatementComplete(statementId);
    }
    else if (statement.Status === 'FINISHED') {
        return;
    }
    else {
        throw new Error(`Statement status was ${statement.Status}: ${statement.Error}`);
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVkc2hpZnQtZGF0YS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInJlZHNoaWZ0LWRhdGEudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsZ0VBQWdFO0FBQ2hFLDZEQUE2RDtBQUc3RCxNQUFNLFlBQVksR0FBRyxJQUFJLFlBQVksRUFBRSxDQUFDO0FBRWpDLEtBQUssVUFBVSxnQkFBZ0IsQ0FBQyxTQUFpQixFQUFFLFlBQTBCO0lBQ2xGLE1BQU0scUJBQXFCLEdBQUc7UUFDNUIsaUJBQWlCLEVBQUUsWUFBWSxDQUFDLFdBQVc7UUFDM0MsUUFBUSxFQUFFLFlBQVksQ0FBQyxZQUFZO1FBQ25DLFNBQVMsRUFBRSxZQUFZLENBQUMsWUFBWTtRQUNwQyxHQUFHLEVBQUUsU0FBUztLQUNmLENBQUM7SUFDRixNQUFNLGlCQUFpQixHQUFHLE1BQU0sWUFBWSxDQUFDLGdCQUFnQixDQUFDLHFCQUFxQixDQUFDLENBQUMsT0FBTyxFQUFFLENBQUM7SUFDL0YsSUFBSSxDQUFDLGlCQUFpQixDQUFDLEVBQUUsRUFBRTtRQUN6QixNQUFNLElBQUksS0FBSyxDQUFDLGtFQUFrRSxDQUFDLENBQUM7S0FDckY7SUFDRCxNQUFNLHdCQUF3QixDQUFDLGlCQUFpQixDQUFDLEVBQUUsQ0FBQyxDQUFDO0FBQ3ZELENBQUM7QUFaRCw0Q0FZQztBQUVELE1BQU0sV0FBVyxHQUFHLEdBQUcsQ0FBQztBQUN4QixLQUFLLFVBQVUsd0JBQXdCLENBQUMsV0FBbUI7SUFDekQsTUFBTSxJQUFJLE9BQU8sQ0FBQyxDQUFDLE9BQThCLEVBQUUsRUFBRTtRQUNuRCxVQUFVLENBQUMsR0FBRyxFQUFFLENBQUMsT0FBTyxFQUFFLEVBQUUsV0FBVyxDQUFDLENBQUM7SUFDM0MsQ0FBQyxDQUFDLENBQUM7SUFDSCxNQUFNLFNBQVMsR0FBRyxNQUFNLFlBQVksQ0FBQyxpQkFBaUIsQ0FBQyxFQUFFLEVBQUUsRUFBRSxXQUFXLEVBQUUsQ0FBQyxDQUFDLE9BQU8sRUFBRSxDQUFDO0lBQ3RGLElBQUksU0FBUyxDQUFDLE1BQU0sS0FBSyxVQUFVLElBQUksU0FBUyxDQUFDLE1BQU0sS0FBSyxRQUFRLElBQUksU0FBUyxDQUFDLE1BQU0sS0FBSyxTQUFTLEVBQUU7UUFDdEcsT0FBTyx3QkFBd0IsQ0FBQyxXQUFXLENBQUMsQ0FBQztLQUM5QztTQUFNLElBQUksU0FBUyxDQUFDLE1BQU0sS0FBSyxVQUFVLEVBQUU7UUFDMUMsT0FBTztLQUNSO1NBQU07UUFDTCxNQUFNLElBQUksS0FBSyxDQUFDLHdCQUF3QixTQUFTLENBQUMsTUFBTSxLQUFLLFNBQVMsQ0FBQyxLQUFLLEVBQUUsQ0FBQyxDQUFDO0tBQ2pGO0FBQ0gsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBpbXBvcnQvbm8tZXh0cmFuZW91cy1kZXBlbmRlbmNpZXMgKi9cbmltcG9ydCAqIGFzIFJlZHNoaWZ0RGF0YSBmcm9tICdhd3Mtc2RrL2NsaWVudHMvcmVkc2hpZnRkYXRhJztcbmltcG9ydCB7IENsdXN0ZXJQcm9wcyB9IGZyb20gJy4vdHlwZXMnO1xuXG5jb25zdCByZWRzaGlmdERhdGEgPSBuZXcgUmVkc2hpZnREYXRhKCk7XG5cbmV4cG9ydCBhc3luYyBmdW5jdGlvbiBleGVjdXRlU3RhdGVtZW50KHN0YXRlbWVudDogc3RyaW5nLCBjbHVzdGVyUHJvcHM6IENsdXN0ZXJQcm9wcyk6IFByb21pc2U8dm9pZD4ge1xuICBjb25zdCBleGVjdXRlU3RhdGVtZW50UHJvcHMgPSB7XG4gICAgQ2x1c3RlcklkZW50aWZpZXI6IGNsdXN0ZXJQcm9wcy5jbHVzdGVyTmFtZSxcbiAgICBEYXRhYmFzZTogY2x1c3RlclByb3BzLmRhdGFiYXNlTmFtZSxcbiAgICBTZWNyZXRBcm46IGNsdXN0ZXJQcm9wcy5hZG1pblVzZXJBcm4sXG4gICAgU3FsOiBzdGF0ZW1lbnQsXG4gIH07XG4gIGNvbnN0IGV4ZWN1dGVkU3RhdGVtZW50ID0gYXdhaXQgcmVkc2hpZnREYXRhLmV4ZWN1dGVTdGF0ZW1lbnQoZXhlY3V0ZVN0YXRlbWVudFByb3BzKS5wcm9taXNlKCk7XG4gIGlmICghZXhlY3V0ZWRTdGF0ZW1lbnQuSWQpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoJ1NlcnZpY2UgZXJyb3I6IFN0YXRlbWVudCBleGVjdXRpb24gZGlkIG5vdCByZXR1cm4gYSBzdGF0ZW1lbnQgSUQnKTtcbiAgfVxuICBhd2FpdCB3YWl0Rm9yU3RhdGVtZW50Q29tcGxldGUoZXhlY3V0ZWRTdGF0ZW1lbnQuSWQpO1xufVxuXG5jb25zdCB3YWl0VGltZW91dCA9IDEwMDtcbmFzeW5jIGZ1bmN0aW9uIHdhaXRGb3JTdGF0ZW1lbnRDb21wbGV0ZShzdGF0ZW1lbnRJZDogc3RyaW5nKTogUHJvbWlzZTx2b2lkPiB7XG4gIGF3YWl0IG5ldyBQcm9taXNlKChyZXNvbHZlOiAodmFsdWU6IHZvaWQpID0+IHZvaWQpID0+IHtcbiAgICBzZXRUaW1lb3V0KCgpID0+IHJlc29sdmUoKSwgd2FpdFRpbWVvdXQpO1xuICB9KTtcbiAgY29uc3Qgc3RhdGVtZW50ID0gYXdhaXQgcmVkc2hpZnREYXRhLmRlc2NyaWJlU3RhdGVtZW50KHsgSWQ6IHN0YXRlbWVudElkIH0pLnByb21pc2UoKTtcbiAgaWYgKHN0YXRlbWVudC5TdGF0dXMgIT09ICdGSU5JU0hFRCcgJiYgc3RhdGVtZW50LlN0YXR1cyAhPT0gJ0ZBSUxFRCcgJiYgc3RhdGVtZW50LlN0YXR1cyAhPT0gJ0FCT1JURUQnKSB7XG4gICAgcmV0dXJuIHdhaXRGb3JTdGF0ZW1lbnRDb21wbGV0ZShzdGF0ZW1lbnRJZCk7XG4gIH0gZWxzZSBpZiAoc3RhdGVtZW50LlN0YXR1cyA9PT0gJ0ZJTklTSEVEJykge1xuICAgIHJldHVybjtcbiAgfSBlbHNlIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoYFN0YXRlbWVudCBzdGF0dXMgd2FzICR7c3RhdGVtZW50LlN0YXR1c306ICR7c3RhdGVtZW50LkVycm9yfWApO1xuICB9XG59XG4iXX0=