"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTest = exports.IntegTestCaseStack = exports.IntegTestCase = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloud_assembly_schema_1 = require("aws-cdk-lib/cloud-assembly-schema");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const deploy_assert_1 = require("./assertions/private/deploy-assert");
const manifest_synthesizer_1 = require("./manifest-synthesizer");
const TEST_CASE_STACK_SYMBOL = Symbol.for('@aws-cdk/integ-tests.IntegTestCaseStack');
/**
 * An integration test case. Allows the definition of test properties that
 * apply to all stacks under this case.
 *
 * It is recommended that you use the IntegTest construct since that will create
 * a default IntegTestCase
 */
class IntegTestCase extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_IntegTestCaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, IntegTestCase);
            }
            throw error;
        }
        this._assert = new deploy_assert_1.DeployAssert(this);
        this.assertions = this._assert;
    }
    /**
     * The integration test manifest for this test case. Manifests are used
     * by the integration test runner.
     */
    get manifest() {
        return {
            version: cloud_assembly_schema_1.Manifest.version(),
            testCases: { [this.node.path]: this.toTestCase(this.props) },
        };
    }
    toTestCase(props) {
        return {
            ...props,
            assertionStack: this._assert.scope.node.path,
            assertionStackName: this._assert.scope.stackName,
            stacks: props.stacks.map(s => s.node.path),
        };
    }
}
exports.IntegTestCase = IntegTestCase;
_a = JSII_RTTI_SYMBOL_1;
IntegTestCase[_a] = { fqn: "@aws-cdk/integ-tests-alpha.IntegTestCase", version: "2.44.0-alpha.0" };
/**
 * An integration test case stack. Allows the definition of test properties
 * that should apply to this stack.
 *
 * This should be used if there are multiple stacks in the integration test
 * and it is necessary to specify different test case option for each. Otherwise
 * normal stacks should be added to IntegTest
 */
class IntegTestCaseStack extends aws_cdk_lib_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_IntegTestCaseStackProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, IntegTestCaseStack);
            }
            throw error;
        }
        Object.defineProperty(this, TEST_CASE_STACK_SYMBOL, { value: true });
        // TODO: should we only have a single DeployAssert per test?
        this.assertions = new deploy_assert_1.DeployAssert(this);
        this._testCase = new IntegTestCase(this, `${id}TestCase`, {
            ...props,
            stacks: [this],
        });
    }
    /**
     * Returns whether the construct is a IntegTestCaseStack
     */
    static isIntegTestCaseStack(x) {
        return x !== null && typeof (x) === 'object' && TEST_CASE_STACK_SYMBOL in x;
    }
}
exports.IntegTestCaseStack = IntegTestCaseStack;
_b = JSII_RTTI_SYMBOL_1;
IntegTestCaseStack[_b] = { fqn: "@aws-cdk/integ-tests-alpha.IntegTestCaseStack", version: "2.44.0-alpha.0" };
/**
 * A collection of test cases. Each test case file should contain exactly one
 * instance of this class.
 */
class IntegTest extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_IntegTestProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, IntegTest);
            }
            throw error;
        }
        this.enableLookups = props.enableLookups;
        const defaultTestCase = new IntegTestCase(this, 'DefaultTest', {
            stacks: props.testCases.filter(stack => !IntegTestCaseStack.isIntegTestCaseStack(stack)),
            hooks: props.hooks,
            regions: props.regions,
            diffAssets: props.diffAssets,
            allowDestroy: props.allowDestroy,
            cdkCommandOptions: props.cdkCommandOptions,
            stackUpdateWorkflow: props.stackUpdateWorkflow,
        });
        this.assertions = defaultTestCase.assertions;
        this.testCases = [
            defaultTestCase,
            ...props.testCases
                .filter(stack => IntegTestCaseStack.isIntegTestCaseStack(stack))
                .map(stack => stack._testCase),
        ];
        this.node.addValidation({
            validate: () => {
                aws_cdk_lib_1.attachCustomSynthesis(this, {
                    onSynthesize: (session) => {
                        const synthesizer = new manifest_synthesizer_1.IntegManifestSynthesizer(this.testCases, this.enableLookups);
                        synthesizer.synthesize(session);
                    },
                });
                return [];
            },
        });
    }
}
exports.IntegTest = IntegTest;
_c = JSII_RTTI_SYMBOL_1;
IntegTest[_c] = { fqn: "@aws-cdk/integ-tests-alpha.IntegTest", version: "2.44.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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