"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaInvokeFunction = exports.InvocationType = exports.LogType = exports.AwsApiCall = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const api_call_base_1 = require("./api-call-base");
const assertions_1 = require("./assertions");
const common_1 = require("./common");
const providers_1 = require("./providers");
/**
 * Construct that creates a custom resource that will perform
 * a query using the AWS SDK
 */
class AwsApiCall extends api_call_base_1.ApiCallBase {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_AwsApiCallProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AwsApiCall);
            }
            throw error;
        }
        this.provider = new providers_1.AssertionsProvider(this, 'SdkProvider');
        this.provider.addPolicyStatementFromSdkCall(props.service, props.api);
        this.name = `${props.service}${props.api}`;
        this.apiCallResource = new aws_cdk_lib_1.CustomResource(this, 'Default', {
            serviceToken: this.provider.serviceToken,
            properties: {
                service: props.service,
                api: props.api,
                parameters: this.provider.encode(props.parameters),
                flattenResponse: aws_cdk_lib_1.Lazy.string({ produce: () => this.flattenResponse }),
                salt: Date.now().toString(),
            },
            resourceType: `${providers_1.SDK_RESOURCE_TYPE_PREFIX}${this.name}`.substring(0, 60),
        });
        // Needed so that all the policies set up by the provider should be available before the custom resource is provisioned.
        this.apiCallResource.node.addDependency(this.provider);
    }
    getAtt(attributeName) {
        this.flattenResponse = 'true';
        return this.apiCallResource.getAtt(`apiCallResponse.${attributeName}`);
    }
    getAttString(attributeName) {
        this.flattenResponse = 'true';
        return this.apiCallResource.getAttString(`apiCallResponse.${attributeName}`);
    }
    expect(expected) {
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_ExpectedResult(expected);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.expect);
            }
            throw error;
        }
        new assertions_1.EqualsAssertion(this, `AssertEquals${this.name}`, {
            expected,
            actual: common_1.ActualResult.fromCustomResource(this.apiCallResource, 'apiCallResponse'),
        });
    }
    assertAtPath(path, expected) {
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_ExpectedResult(expected);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.assertAtPath);
            }
            throw error;
        }
        new assertions_1.EqualsAssertion(this, `AssertEquals${this.name}`, {
            expected,
            actual: common_1.ActualResult.fromAwsApiCall(this, path),
        });
    }
}
exports.AwsApiCall = AwsApiCall;
_a = JSII_RTTI_SYMBOL_1;
AwsApiCall[_a] = { fqn: "@aws-cdk/integ-tests-alpha.AwsApiCall", version: "2.44.0-alpha.0" };
/**
 * Set to Tail to include the execution log in the response.
 * Applies to synchronously invoked functions only.
 */
var LogType;
(function (LogType) {
    /**
     * The log messages are not returned in the response
     */
    LogType["NONE"] = "None";
    /**
     * The log messages are returned in the response
     */
    LogType["TAIL"] = "Tail";
})(LogType = exports.LogType || (exports.LogType = {}));
/**
 * The type of invocation. Default is REQUEST_RESPONE
 */
var InvocationType;
(function (InvocationType) {
    /**
     * Invoke the function asynchronously.
     * Send events that fail multiple times to the function's
     * dead-letter queue (if it's configured).
     * The API response only includes a status code.
     */
    InvocationType["EVENT"] = "Event";
    /**
     * Invoke the function synchronously.
     * Keep the connection open until the function returns a response or times out.
     * The API response includes the function response and additional data.
     */
    InvocationType["REQUEST_RESPONE"] = "RequestResponse";
    /**
     * Validate parameter values and verify that the user
     * or role has permission to invoke the function.
     */
    InvocationType["DRY_RUN"] = "DryRun";
})(InvocationType = exports.InvocationType || (exports.InvocationType = {}));
/**
 * An AWS Lambda Invoke function API call.
 * Use this istead of the generic AwsApiCall in order to
 * invoke a lambda function. This will automatically create
 * the correct permissions to invoke the function
 */
class LambdaInvokeFunction extends AwsApiCall {
    constructor(scope, id, props) {
        super(scope, id, {
            api: 'invoke',
            service: 'Lambda',
            parameters: {
                FunctionName: props.functionName,
                InvocationType: props.invocationType,
                LogType: props.logType,
                Payload: props.payload,
            },
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_LambdaInvokeFunctionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, LambdaInvokeFunction);
            }
            throw error;
        }
        const stack = aws_cdk_lib_1.Stack.of(this);
        // need to give the assertion lambda permission to invoke
        new aws_cdk_lib_1.CfnResource(this, 'Invoke', {
            type: 'AWS::Lambda::Permission',
            properties: {
                Action: 'lambda:InvokeFunction',
                FunctionName: props.functionName,
                Principal: this.provider.handlerRoleArn,
            },
        });
        // the api call is 'invoke', but the permission is 'invokeFunction'
        // so need to handle it specially
        this.provider.addPolicyStatementFromSdkCall('Lambda', 'invokeFunction', [stack.formatArn({
                service: 'lambda',
                resource: 'function',
                arnFormat: aws_cdk_lib_1.ArnFormat.COLON_RESOURCE_NAME,
                resourceName: props.functionName,
            })]);
    }
}
exports.LambdaInvokeFunction = LambdaInvokeFunction;
_b = JSII_RTTI_SYMBOL_1;
LambdaInvokeFunction[_b] = { fqn: "@aws-cdk/integ-tests-alpha.LambdaInvokeFunction", version: "2.44.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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