# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HostArgs', 'Host']

@pulumi.input_type
class HostArgs:
    def __init__(__self__, *,
                 application_url: pulumi.Input[str],
                 authentication: pulumi.Input['HostAuthenticationArgs'],
                 backup: pulumi.Input['HostBackupArgs'],
                 bind_address: pulumi.Input[str],
                 instance_name: pulumi.Input[str],
                 logging: pulumi.Input['HostLoggingArgs'],
                 port: pulumi.Input[int],
                 proxy: pulumi.Input['HostProxyArgs'],
                 ssl: pulumi.Input['HostSslArgs'],
                 update: pulumi.Input['HostUpdateArgs'],
                 url_base: pulumi.Input[str],
                 launch_browser: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Host resource.
        :param pulumi.Input[str] application_url: Application URL.
        :param pulumi.Input['HostAuthenticationArgs'] authentication: Authentication configuration.
        :param pulumi.Input['HostBackupArgs'] backup: Backup configuration.
        :param pulumi.Input[str] bind_address: Bind address.
        :param pulumi.Input[str] instance_name: Instance name.
        :param pulumi.Input['HostLoggingArgs'] logging: Logging configuration.
        :param pulumi.Input[int] port: Proxy port.
        :param pulumi.Input['HostProxyArgs'] proxy: Proxy configuration.
        :param pulumi.Input['HostSslArgs'] ssl: Backup configuration.
        :param pulumi.Input['HostUpdateArgs'] update: Update configuration.
        :param pulumi.Input[str] url_base: URL base.
        :param pulumi.Input[bool] launch_browser: Launch browser flag.
        """
        pulumi.set(__self__, "application_url", application_url)
        pulumi.set(__self__, "authentication", authentication)
        pulumi.set(__self__, "backup", backup)
        pulumi.set(__self__, "bind_address", bind_address)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "logging", logging)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "proxy", proxy)
        pulumi.set(__self__, "ssl", ssl)
        pulumi.set(__self__, "update", update)
        pulumi.set(__self__, "url_base", url_base)
        if launch_browser is not None:
            pulumi.set(__self__, "launch_browser", launch_browser)

    @property
    @pulumi.getter(name="applicationUrl")
    def application_url(self) -> pulumi.Input[str]:
        """
        Application URL.
        """
        return pulumi.get(self, "application_url")

    @application_url.setter
    def application_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "application_url", value)

    @property
    @pulumi.getter
    def authentication(self) -> pulumi.Input['HostAuthenticationArgs']:
        """
        Authentication configuration.
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: pulumi.Input['HostAuthenticationArgs']):
        pulumi.set(self, "authentication", value)

    @property
    @pulumi.getter
    def backup(self) -> pulumi.Input['HostBackupArgs']:
        """
        Backup configuration.
        """
        return pulumi.get(self, "backup")

    @backup.setter
    def backup(self, value: pulumi.Input['HostBackupArgs']):
        pulumi.set(self, "backup", value)

    @property
    @pulumi.getter(name="bindAddress")
    def bind_address(self) -> pulumi.Input[str]:
        """
        Bind address.
        """
        return pulumi.get(self, "bind_address")

    @bind_address.setter
    def bind_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "bind_address", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Input[str]:
        """
        Instance name.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter
    def logging(self) -> pulumi.Input['HostLoggingArgs']:
        """
        Logging configuration.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: pulumi.Input['HostLoggingArgs']):
        pulumi.set(self, "logging", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        Proxy port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def proxy(self) -> pulumi.Input['HostProxyArgs']:
        """
        Proxy configuration.
        """
        return pulumi.get(self, "proxy")

    @proxy.setter
    def proxy(self, value: pulumi.Input['HostProxyArgs']):
        pulumi.set(self, "proxy", value)

    @property
    @pulumi.getter
    def ssl(self) -> pulumi.Input['HostSslArgs']:
        """
        Backup configuration.
        """
        return pulumi.get(self, "ssl")

    @ssl.setter
    def ssl(self, value: pulumi.Input['HostSslArgs']):
        pulumi.set(self, "ssl", value)

    @property
    @pulumi.getter
    def update(self) -> pulumi.Input['HostUpdateArgs']:
        """
        Update configuration.
        """
        return pulumi.get(self, "update")

    @update.setter
    def update(self, value: pulumi.Input['HostUpdateArgs']):
        pulumi.set(self, "update", value)

    @property
    @pulumi.getter(name="urlBase")
    def url_base(self) -> pulumi.Input[str]:
        """
        URL base.
        """
        return pulumi.get(self, "url_base")

    @url_base.setter
    def url_base(self, value: pulumi.Input[str]):
        pulumi.set(self, "url_base", value)

    @property
    @pulumi.getter(name="launchBrowser")
    def launch_browser(self) -> Optional[pulumi.Input[bool]]:
        """
        Launch browser flag.
        """
        return pulumi.get(self, "launch_browser")

    @launch_browser.setter
    def launch_browser(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "launch_browser", value)


@pulumi.input_type
class _HostState:
    def __init__(__self__, *,
                 application_url: Optional[pulumi.Input[str]] = None,
                 authentication: Optional[pulumi.Input['HostAuthenticationArgs']] = None,
                 backup: Optional[pulumi.Input['HostBackupArgs']] = None,
                 bind_address: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 launch_browser: Optional[pulumi.Input[bool]] = None,
                 logging: Optional[pulumi.Input['HostLoggingArgs']] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 proxy: Optional[pulumi.Input['HostProxyArgs']] = None,
                 ssl: Optional[pulumi.Input['HostSslArgs']] = None,
                 update: Optional[pulumi.Input['HostUpdateArgs']] = None,
                 url_base: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Host resources.
        :param pulumi.Input[str] application_url: Application URL.
        :param pulumi.Input['HostAuthenticationArgs'] authentication: Authentication configuration.
        :param pulumi.Input['HostBackupArgs'] backup: Backup configuration.
        :param pulumi.Input[str] bind_address: Bind address.
        :param pulumi.Input[str] instance_name: Instance name.
        :param pulumi.Input[bool] launch_browser: Launch browser flag.
        :param pulumi.Input['HostLoggingArgs'] logging: Logging configuration.
        :param pulumi.Input[int] port: Proxy port.
        :param pulumi.Input['HostProxyArgs'] proxy: Proxy configuration.
        :param pulumi.Input['HostSslArgs'] ssl: Backup configuration.
        :param pulumi.Input['HostUpdateArgs'] update: Update configuration.
        :param pulumi.Input[str] url_base: URL base.
        """
        if application_url is not None:
            pulumi.set(__self__, "application_url", application_url)
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if backup is not None:
            pulumi.set(__self__, "backup", backup)
        if bind_address is not None:
            pulumi.set(__self__, "bind_address", bind_address)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if launch_browser is not None:
            pulumi.set(__self__, "launch_browser", launch_browser)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if proxy is not None:
            pulumi.set(__self__, "proxy", proxy)
        if ssl is not None:
            pulumi.set(__self__, "ssl", ssl)
        if update is not None:
            pulumi.set(__self__, "update", update)
        if url_base is not None:
            pulumi.set(__self__, "url_base", url_base)

    @property
    @pulumi.getter(name="applicationUrl")
    def application_url(self) -> Optional[pulumi.Input[str]]:
        """
        Application URL.
        """
        return pulumi.get(self, "application_url")

    @application_url.setter
    def application_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_url", value)

    @property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input['HostAuthenticationArgs']]:
        """
        Authentication configuration.
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input['HostAuthenticationArgs']]):
        pulumi.set(self, "authentication", value)

    @property
    @pulumi.getter
    def backup(self) -> Optional[pulumi.Input['HostBackupArgs']]:
        """
        Backup configuration.
        """
        return pulumi.get(self, "backup")

    @backup.setter
    def backup(self, value: Optional[pulumi.Input['HostBackupArgs']]):
        pulumi.set(self, "backup", value)

    @property
    @pulumi.getter(name="bindAddress")
    def bind_address(self) -> Optional[pulumi.Input[str]]:
        """
        Bind address.
        """
        return pulumi.get(self, "bind_address")

    @bind_address.setter
    def bind_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bind_address", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        Instance name.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="launchBrowser")
    def launch_browser(self) -> Optional[pulumi.Input[bool]]:
        """
        Launch browser flag.
        """
        return pulumi.get(self, "launch_browser")

    @launch_browser.setter
    def launch_browser(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "launch_browser", value)

    @property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input['HostLoggingArgs']]:
        """
        Logging configuration.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input['HostLoggingArgs']]):
        pulumi.set(self, "logging", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Proxy port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def proxy(self) -> Optional[pulumi.Input['HostProxyArgs']]:
        """
        Proxy configuration.
        """
        return pulumi.get(self, "proxy")

    @proxy.setter
    def proxy(self, value: Optional[pulumi.Input['HostProxyArgs']]):
        pulumi.set(self, "proxy", value)

    @property
    @pulumi.getter
    def ssl(self) -> Optional[pulumi.Input['HostSslArgs']]:
        """
        Backup configuration.
        """
        return pulumi.get(self, "ssl")

    @ssl.setter
    def ssl(self, value: Optional[pulumi.Input['HostSslArgs']]):
        pulumi.set(self, "ssl", value)

    @property
    @pulumi.getter
    def update(self) -> Optional[pulumi.Input['HostUpdateArgs']]:
        """
        Update configuration.
        """
        return pulumi.get(self, "update")

    @update.setter
    def update(self, value: Optional[pulumi.Input['HostUpdateArgs']]):
        pulumi.set(self, "update", value)

    @property
    @pulumi.getter(name="urlBase")
    def url_base(self) -> Optional[pulumi.Input[str]]:
        """
        URL base.
        """
        return pulumi.get(self, "url_base")

    @url_base.setter
    def url_base(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url_base", value)


class Host(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_url: Optional[pulumi.Input[str]] = None,
                 authentication: Optional[pulumi.Input[pulumi.InputType['HostAuthenticationArgs']]] = None,
                 backup: Optional[pulumi.Input[pulumi.InputType['HostBackupArgs']]] = None,
                 bind_address: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 launch_browser: Optional[pulumi.Input[bool]] = None,
                 logging: Optional[pulumi.Input[pulumi.InputType['HostLoggingArgs']]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 proxy: Optional[pulumi.Input[pulumi.InputType['HostProxyArgs']]] = None,
                 ssl: Optional[pulumi.Input[pulumi.InputType['HostSslArgs']]] = None,
                 update: Optional[pulumi.Input[pulumi.InputType['HostUpdateArgs']]] = None,
                 url_base: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        <!-- subcategory:System -->Host resource.
        For more information refer to [Host](https://wiki.servarr.com/lidarr/settings#general) documentation.

        ## Import

        import does not need parameters

        ```sh
         $ pulumi import lidarr:System/host:Host example ""
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_url: Application URL.
        :param pulumi.Input[pulumi.InputType['HostAuthenticationArgs']] authentication: Authentication configuration.
        :param pulumi.Input[pulumi.InputType['HostBackupArgs']] backup: Backup configuration.
        :param pulumi.Input[str] bind_address: Bind address.
        :param pulumi.Input[str] instance_name: Instance name.
        :param pulumi.Input[bool] launch_browser: Launch browser flag.
        :param pulumi.Input[pulumi.InputType['HostLoggingArgs']] logging: Logging configuration.
        :param pulumi.Input[int] port: Proxy port.
        :param pulumi.Input[pulumi.InputType['HostProxyArgs']] proxy: Proxy configuration.
        :param pulumi.Input[pulumi.InputType['HostSslArgs']] ssl: Backup configuration.
        :param pulumi.Input[pulumi.InputType['HostUpdateArgs']] update: Update configuration.
        :param pulumi.Input[str] url_base: URL base.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HostArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        <!-- subcategory:System -->Host resource.
        For more information refer to [Host](https://wiki.servarr.com/lidarr/settings#general) documentation.

        ## Import

        import does not need parameters

        ```sh
         $ pulumi import lidarr:System/host:Host example ""
        ```

        :param str resource_name: The name of the resource.
        :param HostArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HostArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_url: Optional[pulumi.Input[str]] = None,
                 authentication: Optional[pulumi.Input[pulumi.InputType['HostAuthenticationArgs']]] = None,
                 backup: Optional[pulumi.Input[pulumi.InputType['HostBackupArgs']]] = None,
                 bind_address: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 launch_browser: Optional[pulumi.Input[bool]] = None,
                 logging: Optional[pulumi.Input[pulumi.InputType['HostLoggingArgs']]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 proxy: Optional[pulumi.Input[pulumi.InputType['HostProxyArgs']]] = None,
                 ssl: Optional[pulumi.Input[pulumi.InputType['HostSslArgs']]] = None,
                 update: Optional[pulumi.Input[pulumi.InputType['HostUpdateArgs']]] = None,
                 url_base: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HostArgs.__new__(HostArgs)

            if application_url is None and not opts.urn:
                raise TypeError("Missing required property 'application_url'")
            __props__.__dict__["application_url"] = application_url
            if authentication is None and not opts.urn:
                raise TypeError("Missing required property 'authentication'")
            __props__.__dict__["authentication"] = authentication
            if backup is None and not opts.urn:
                raise TypeError("Missing required property 'backup'")
            __props__.__dict__["backup"] = backup
            if bind_address is None and not opts.urn:
                raise TypeError("Missing required property 'bind_address'")
            __props__.__dict__["bind_address"] = bind_address
            if instance_name is None and not opts.urn:
                raise TypeError("Missing required property 'instance_name'")
            __props__.__dict__["instance_name"] = instance_name
            __props__.__dict__["launch_browser"] = launch_browser
            if logging is None and not opts.urn:
                raise TypeError("Missing required property 'logging'")
            __props__.__dict__["logging"] = logging
            if port is None and not opts.urn:
                raise TypeError("Missing required property 'port'")
            __props__.__dict__["port"] = port
            if proxy is None and not opts.urn:
                raise TypeError("Missing required property 'proxy'")
            __props__.__dict__["proxy"] = proxy
            if ssl is None and not opts.urn:
                raise TypeError("Missing required property 'ssl'")
            __props__.__dict__["ssl"] = ssl
            if update is None and not opts.urn:
                raise TypeError("Missing required property 'update'")
            __props__.__dict__["update"] = update
            if url_base is None and not opts.urn:
                raise TypeError("Missing required property 'url_base'")
            __props__.__dict__["url_base"] = url_base
        super(Host, __self__).__init__(
            'lidarr:System/host:Host',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_url: Optional[pulumi.Input[str]] = None,
            authentication: Optional[pulumi.Input[pulumi.InputType['HostAuthenticationArgs']]] = None,
            backup: Optional[pulumi.Input[pulumi.InputType['HostBackupArgs']]] = None,
            bind_address: Optional[pulumi.Input[str]] = None,
            instance_name: Optional[pulumi.Input[str]] = None,
            launch_browser: Optional[pulumi.Input[bool]] = None,
            logging: Optional[pulumi.Input[pulumi.InputType['HostLoggingArgs']]] = None,
            port: Optional[pulumi.Input[int]] = None,
            proxy: Optional[pulumi.Input[pulumi.InputType['HostProxyArgs']]] = None,
            ssl: Optional[pulumi.Input[pulumi.InputType['HostSslArgs']]] = None,
            update: Optional[pulumi.Input[pulumi.InputType['HostUpdateArgs']]] = None,
            url_base: Optional[pulumi.Input[str]] = None) -> 'Host':
        """
        Get an existing Host resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_url: Application URL.
        :param pulumi.Input[pulumi.InputType['HostAuthenticationArgs']] authentication: Authentication configuration.
        :param pulumi.Input[pulumi.InputType['HostBackupArgs']] backup: Backup configuration.
        :param pulumi.Input[str] bind_address: Bind address.
        :param pulumi.Input[str] instance_name: Instance name.
        :param pulumi.Input[bool] launch_browser: Launch browser flag.
        :param pulumi.Input[pulumi.InputType['HostLoggingArgs']] logging: Logging configuration.
        :param pulumi.Input[int] port: Proxy port.
        :param pulumi.Input[pulumi.InputType['HostProxyArgs']] proxy: Proxy configuration.
        :param pulumi.Input[pulumi.InputType['HostSslArgs']] ssl: Backup configuration.
        :param pulumi.Input[pulumi.InputType['HostUpdateArgs']] update: Update configuration.
        :param pulumi.Input[str] url_base: URL base.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HostState.__new__(_HostState)

        __props__.__dict__["application_url"] = application_url
        __props__.__dict__["authentication"] = authentication
        __props__.__dict__["backup"] = backup
        __props__.__dict__["bind_address"] = bind_address
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["launch_browser"] = launch_browser
        __props__.__dict__["logging"] = logging
        __props__.__dict__["port"] = port
        __props__.__dict__["proxy"] = proxy
        __props__.__dict__["ssl"] = ssl
        __props__.__dict__["update"] = update
        __props__.__dict__["url_base"] = url_base
        return Host(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationUrl")
    def application_url(self) -> pulumi.Output[str]:
        """
        Application URL.
        """
        return pulumi.get(self, "application_url")

    @property
    @pulumi.getter
    def authentication(self) -> pulumi.Output['outputs.HostAuthentication']:
        """
        Authentication configuration.
        """
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter
    def backup(self) -> pulumi.Output['outputs.HostBackup']:
        """
        Backup configuration.
        """
        return pulumi.get(self, "backup")

    @property
    @pulumi.getter(name="bindAddress")
    def bind_address(self) -> pulumi.Output[str]:
        """
        Bind address.
        """
        return pulumi.get(self, "bind_address")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[str]:
        """
        Instance name.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="launchBrowser")
    def launch_browser(self) -> pulumi.Output[bool]:
        """
        Launch browser flag.
        """
        return pulumi.get(self, "launch_browser")

    @property
    @pulumi.getter
    def logging(self) -> pulumi.Output['outputs.HostLogging']:
        """
        Logging configuration.
        """
        return pulumi.get(self, "logging")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        Proxy port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def proxy(self) -> pulumi.Output['outputs.HostProxy']:
        """
        Proxy configuration.
        """
        return pulumi.get(self, "proxy")

    @property
    @pulumi.getter
    def ssl(self) -> pulumi.Output['outputs.HostSsl']:
        """
        Backup configuration.
        """
        return pulumi.get(self, "ssl")

    @property
    @pulumi.getter
    def update(self) -> pulumi.Output['outputs.HostUpdate']:
        """
        Update configuration.
        """
        return pulumi.get(self, "update")

    @property
    @pulumi.getter(name="urlBase")
    def url_base(self) -> pulumi.Output[str]:
        """
        URL base.
        """
        return pulumi.get(self, "url_base")

