# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['QualityProfileArgs', 'QualityProfile']

@pulumi.input_type
class QualityProfileArgs:
    def __init__(__self__, *,
                 quality_groups: pulumi.Input[Sequence[pulumi.Input['QualityProfileQualityGroupArgs']]],
                 cutoff: Optional[pulumi.Input[int]] = None,
                 cutoff_format_score: Optional[pulumi.Input[int]] = None,
                 format_items: Optional[pulumi.Input[Sequence[pulumi.Input['QualityProfileFormatItemArgs']]]] = None,
                 min_format_score: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 upgrade_allowed: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a QualityProfile resource.
        :param pulumi.Input[Sequence[pulumi.Input['QualityProfileQualityGroupArgs']]] quality_groups: Ordered list of allowed quality groups.
        :param pulumi.Input[int] cutoff: Quality ID to which cutoff.
        :param pulumi.Input[int] cutoff_format_score: Cutoff format score.
        :param pulumi.Input[Sequence[pulumi.Input['QualityProfileFormatItemArgs']]] format_items: Format items. Only the ones with score > 0 are needed.
        :param pulumi.Input[int] min_format_score: Min format score.
        :param pulumi.Input[str] name: Name.
        :param pulumi.Input[bool] upgrade_allowed: Upgrade allowed flag.
        """
        pulumi.set(__self__, "quality_groups", quality_groups)
        if cutoff is not None:
            pulumi.set(__self__, "cutoff", cutoff)
        if cutoff_format_score is not None:
            pulumi.set(__self__, "cutoff_format_score", cutoff_format_score)
        if format_items is not None:
            pulumi.set(__self__, "format_items", format_items)
        if min_format_score is not None:
            pulumi.set(__self__, "min_format_score", min_format_score)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if upgrade_allowed is not None:
            pulumi.set(__self__, "upgrade_allowed", upgrade_allowed)

    @property
    @pulumi.getter(name="qualityGroups")
    def quality_groups(self) -> pulumi.Input[Sequence[pulumi.Input['QualityProfileQualityGroupArgs']]]:
        """
        Ordered list of allowed quality groups.
        """
        return pulumi.get(self, "quality_groups")

    @quality_groups.setter
    def quality_groups(self, value: pulumi.Input[Sequence[pulumi.Input['QualityProfileQualityGroupArgs']]]):
        pulumi.set(self, "quality_groups", value)

    @property
    @pulumi.getter
    def cutoff(self) -> Optional[pulumi.Input[int]]:
        """
        Quality ID to which cutoff.
        """
        return pulumi.get(self, "cutoff")

    @cutoff.setter
    def cutoff(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cutoff", value)

    @property
    @pulumi.getter(name="cutoffFormatScore")
    def cutoff_format_score(self) -> Optional[pulumi.Input[int]]:
        """
        Cutoff format score.
        """
        return pulumi.get(self, "cutoff_format_score")

    @cutoff_format_score.setter
    def cutoff_format_score(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cutoff_format_score", value)

    @property
    @pulumi.getter(name="formatItems")
    def format_items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['QualityProfileFormatItemArgs']]]]:
        """
        Format items. Only the ones with score > 0 are needed.
        """
        return pulumi.get(self, "format_items")

    @format_items.setter
    def format_items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['QualityProfileFormatItemArgs']]]]):
        pulumi.set(self, "format_items", value)

    @property
    @pulumi.getter(name="minFormatScore")
    def min_format_score(self) -> Optional[pulumi.Input[int]]:
        """
        Min format score.
        """
        return pulumi.get(self, "min_format_score")

    @min_format_score.setter
    def min_format_score(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_format_score", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="upgradeAllowed")
    def upgrade_allowed(self) -> Optional[pulumi.Input[bool]]:
        """
        Upgrade allowed flag.
        """
        return pulumi.get(self, "upgrade_allowed")

    @upgrade_allowed.setter
    def upgrade_allowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "upgrade_allowed", value)


@pulumi.input_type
class _QualityProfileState:
    def __init__(__self__, *,
                 cutoff: Optional[pulumi.Input[int]] = None,
                 cutoff_format_score: Optional[pulumi.Input[int]] = None,
                 format_items: Optional[pulumi.Input[Sequence[pulumi.Input['QualityProfileFormatItemArgs']]]] = None,
                 min_format_score: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 quality_groups: Optional[pulumi.Input[Sequence[pulumi.Input['QualityProfileQualityGroupArgs']]]] = None,
                 upgrade_allowed: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering QualityProfile resources.
        :param pulumi.Input[int] cutoff: Quality ID to which cutoff.
        :param pulumi.Input[int] cutoff_format_score: Cutoff format score.
        :param pulumi.Input[Sequence[pulumi.Input['QualityProfileFormatItemArgs']]] format_items: Format items. Only the ones with score > 0 are needed.
        :param pulumi.Input[int] min_format_score: Min format score.
        :param pulumi.Input[str] name: Name.
        :param pulumi.Input[Sequence[pulumi.Input['QualityProfileQualityGroupArgs']]] quality_groups: Ordered list of allowed quality groups.
        :param pulumi.Input[bool] upgrade_allowed: Upgrade allowed flag.
        """
        if cutoff is not None:
            pulumi.set(__self__, "cutoff", cutoff)
        if cutoff_format_score is not None:
            pulumi.set(__self__, "cutoff_format_score", cutoff_format_score)
        if format_items is not None:
            pulumi.set(__self__, "format_items", format_items)
        if min_format_score is not None:
            pulumi.set(__self__, "min_format_score", min_format_score)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if quality_groups is not None:
            pulumi.set(__self__, "quality_groups", quality_groups)
        if upgrade_allowed is not None:
            pulumi.set(__self__, "upgrade_allowed", upgrade_allowed)

    @property
    @pulumi.getter
    def cutoff(self) -> Optional[pulumi.Input[int]]:
        """
        Quality ID to which cutoff.
        """
        return pulumi.get(self, "cutoff")

    @cutoff.setter
    def cutoff(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cutoff", value)

    @property
    @pulumi.getter(name="cutoffFormatScore")
    def cutoff_format_score(self) -> Optional[pulumi.Input[int]]:
        """
        Cutoff format score.
        """
        return pulumi.get(self, "cutoff_format_score")

    @cutoff_format_score.setter
    def cutoff_format_score(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cutoff_format_score", value)

    @property
    @pulumi.getter(name="formatItems")
    def format_items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['QualityProfileFormatItemArgs']]]]:
        """
        Format items. Only the ones with score > 0 are needed.
        """
        return pulumi.get(self, "format_items")

    @format_items.setter
    def format_items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['QualityProfileFormatItemArgs']]]]):
        pulumi.set(self, "format_items", value)

    @property
    @pulumi.getter(name="minFormatScore")
    def min_format_score(self) -> Optional[pulumi.Input[int]]:
        """
        Min format score.
        """
        return pulumi.get(self, "min_format_score")

    @min_format_score.setter
    def min_format_score(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_format_score", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="qualityGroups")
    def quality_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['QualityProfileQualityGroupArgs']]]]:
        """
        Ordered list of allowed quality groups.
        """
        return pulumi.get(self, "quality_groups")

    @quality_groups.setter
    def quality_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['QualityProfileQualityGroupArgs']]]]):
        pulumi.set(self, "quality_groups", value)

    @property
    @pulumi.getter(name="upgradeAllowed")
    def upgrade_allowed(self) -> Optional[pulumi.Input[bool]]:
        """
        Upgrade allowed flag.
        """
        return pulumi.get(self, "upgrade_allowed")

    @upgrade_allowed.setter
    def upgrade_allowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "upgrade_allowed", value)


class QualityProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cutoff: Optional[pulumi.Input[int]] = None,
                 cutoff_format_score: Optional[pulumi.Input[int]] = None,
                 format_items: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['QualityProfileFormatItemArgs']]]]] = None,
                 min_format_score: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 quality_groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['QualityProfileQualityGroupArgs']]]]] = None,
                 upgrade_allowed: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        <!-- subcategory:Profiles -->Quality Profile resource.
        For more information refer to [Quality Profile](https://wiki.servarr.com/lidarr/settings#quality-profiles) documentation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.profiles.QualityProfile("example",
            cutoff=1100,
            quality_groups=[lidarr.profiles.QualityProfileQualityGroupArgs(
                id=1100,
                name="lossless",
                qualities=[
                    lidarr.profiles.QualityProfileQualityGroupQualityArgs(
                        id=7,
                        name="ALAC",
                    ),
                    lidarr.profiles.QualityProfileQualityGroupQualityArgs(
                        id=6,
                        name="FLAC",
                    ),
                ],
            )],
            upgrade_allowed=True)
        ```

        ## Import

        import using the API/UI ID

        ```sh
         $ pulumi import lidarr:Profiles/qualityProfile:QualityProfile example 10
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] cutoff: Quality ID to which cutoff.
        :param pulumi.Input[int] cutoff_format_score: Cutoff format score.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['QualityProfileFormatItemArgs']]]] format_items: Format items. Only the ones with score > 0 are needed.
        :param pulumi.Input[int] min_format_score: Min format score.
        :param pulumi.Input[str] name: Name.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['QualityProfileQualityGroupArgs']]]] quality_groups: Ordered list of allowed quality groups.
        :param pulumi.Input[bool] upgrade_allowed: Upgrade allowed flag.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: QualityProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        <!-- subcategory:Profiles -->Quality Profile resource.
        For more information refer to [Quality Profile](https://wiki.servarr.com/lidarr/settings#quality-profiles) documentation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.profiles.QualityProfile("example",
            cutoff=1100,
            quality_groups=[lidarr.profiles.QualityProfileQualityGroupArgs(
                id=1100,
                name="lossless",
                qualities=[
                    lidarr.profiles.QualityProfileQualityGroupQualityArgs(
                        id=7,
                        name="ALAC",
                    ),
                    lidarr.profiles.QualityProfileQualityGroupQualityArgs(
                        id=6,
                        name="FLAC",
                    ),
                ],
            )],
            upgrade_allowed=True)
        ```

        ## Import

        import using the API/UI ID

        ```sh
         $ pulumi import lidarr:Profiles/qualityProfile:QualityProfile example 10
        ```

        :param str resource_name: The name of the resource.
        :param QualityProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QualityProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cutoff: Optional[pulumi.Input[int]] = None,
                 cutoff_format_score: Optional[pulumi.Input[int]] = None,
                 format_items: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['QualityProfileFormatItemArgs']]]]] = None,
                 min_format_score: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 quality_groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['QualityProfileQualityGroupArgs']]]]] = None,
                 upgrade_allowed: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QualityProfileArgs.__new__(QualityProfileArgs)

            __props__.__dict__["cutoff"] = cutoff
            __props__.__dict__["cutoff_format_score"] = cutoff_format_score
            __props__.__dict__["format_items"] = format_items
            __props__.__dict__["min_format_score"] = min_format_score
            __props__.__dict__["name"] = name
            if quality_groups is None and not opts.urn:
                raise TypeError("Missing required property 'quality_groups'")
            __props__.__dict__["quality_groups"] = quality_groups
            __props__.__dict__["upgrade_allowed"] = upgrade_allowed
        super(QualityProfile, __self__).__init__(
            'lidarr:Profiles/qualityProfile:QualityProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cutoff: Optional[pulumi.Input[int]] = None,
            cutoff_format_score: Optional[pulumi.Input[int]] = None,
            format_items: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['QualityProfileFormatItemArgs']]]]] = None,
            min_format_score: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            quality_groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['QualityProfileQualityGroupArgs']]]]] = None,
            upgrade_allowed: Optional[pulumi.Input[bool]] = None) -> 'QualityProfile':
        """
        Get an existing QualityProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] cutoff: Quality ID to which cutoff.
        :param pulumi.Input[int] cutoff_format_score: Cutoff format score.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['QualityProfileFormatItemArgs']]]] format_items: Format items. Only the ones with score > 0 are needed.
        :param pulumi.Input[int] min_format_score: Min format score.
        :param pulumi.Input[str] name: Name.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['QualityProfileQualityGroupArgs']]]] quality_groups: Ordered list of allowed quality groups.
        :param pulumi.Input[bool] upgrade_allowed: Upgrade allowed flag.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _QualityProfileState.__new__(_QualityProfileState)

        __props__.__dict__["cutoff"] = cutoff
        __props__.__dict__["cutoff_format_score"] = cutoff_format_score
        __props__.__dict__["format_items"] = format_items
        __props__.__dict__["min_format_score"] = min_format_score
        __props__.__dict__["name"] = name
        __props__.__dict__["quality_groups"] = quality_groups
        __props__.__dict__["upgrade_allowed"] = upgrade_allowed
        return QualityProfile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def cutoff(self) -> pulumi.Output[int]:
        """
        Quality ID to which cutoff.
        """
        return pulumi.get(self, "cutoff")

    @property
    @pulumi.getter(name="cutoffFormatScore")
    def cutoff_format_score(self) -> pulumi.Output[int]:
        """
        Cutoff format score.
        """
        return pulumi.get(self, "cutoff_format_score")

    @property
    @pulumi.getter(name="formatItems")
    def format_items(self) -> pulumi.Output[Sequence['outputs.QualityProfileFormatItem']]:
        """
        Format items. Only the ones with score > 0 are needed.
        """
        return pulumi.get(self, "format_items")

    @property
    @pulumi.getter(name="minFormatScore")
    def min_format_score(self) -> pulumi.Output[int]:
        """
        Min format score.
        """
        return pulumi.get(self, "min_format_score")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="qualityGroups")
    def quality_groups(self) -> pulumi.Output[Sequence['outputs.QualityProfileQualityGroup']]:
        """
        Ordered list of allowed quality groups.
        """
        return pulumi.get(self, "quality_groups")

    @property
    @pulumi.getter(name="upgradeAllowed")
    def upgrade_allowed(self) -> pulumi.Output[bool]:
        """
        Upgrade allowed flag.
        """
        return pulumi.get(self, "upgrade_allowed")

