# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['MetadataProfileArgs', 'MetadataProfile']

@pulumi.input_type
class MetadataProfileArgs:
    def __init__(__self__, *,
                 primary_album_types: pulumi.Input[Sequence[pulumi.Input[int]]],
                 release_statuses: pulumi.Input[Sequence[pulumi.Input[int]]],
                 secondary_album_types: pulumi.Input[Sequence[pulumi.Input[int]]],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MetadataProfile resource.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] primary_album_types: Primary album types.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] release_statuses: Release statuses.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] secondary_album_types: Secondary album types.
        :param pulumi.Input[str] name: Metadata Profile name.
        """
        pulumi.set(__self__, "primary_album_types", primary_album_types)
        pulumi.set(__self__, "release_statuses", release_statuses)
        pulumi.set(__self__, "secondary_album_types", secondary_album_types)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="primaryAlbumTypes")
    def primary_album_types(self) -> pulumi.Input[Sequence[pulumi.Input[int]]]:
        """
        Primary album types.
        """
        return pulumi.get(self, "primary_album_types")

    @primary_album_types.setter
    def primary_album_types(self, value: pulumi.Input[Sequence[pulumi.Input[int]]]):
        pulumi.set(self, "primary_album_types", value)

    @property
    @pulumi.getter(name="releaseStatuses")
    def release_statuses(self) -> pulumi.Input[Sequence[pulumi.Input[int]]]:
        """
        Release statuses.
        """
        return pulumi.get(self, "release_statuses")

    @release_statuses.setter
    def release_statuses(self, value: pulumi.Input[Sequence[pulumi.Input[int]]]):
        pulumi.set(self, "release_statuses", value)

    @property
    @pulumi.getter(name="secondaryAlbumTypes")
    def secondary_album_types(self) -> pulumi.Input[Sequence[pulumi.Input[int]]]:
        """
        Secondary album types.
        """
        return pulumi.get(self, "secondary_album_types")

    @secondary_album_types.setter
    def secondary_album_types(self, value: pulumi.Input[Sequence[pulumi.Input[int]]]):
        pulumi.set(self, "secondary_album_types", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Metadata Profile name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _MetadataProfileState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 primary_album_types: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 release_statuses: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 secondary_album_types: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None):
        """
        Input properties used for looking up and filtering MetadataProfile resources.
        :param pulumi.Input[str] name: Metadata Profile name.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] primary_album_types: Primary album types.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] release_statuses: Release statuses.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] secondary_album_types: Secondary album types.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_album_types is not None:
            pulumi.set(__self__, "primary_album_types", primary_album_types)
        if release_statuses is not None:
            pulumi.set(__self__, "release_statuses", release_statuses)
        if secondary_album_types is not None:
            pulumi.set(__self__, "secondary_album_types", secondary_album_types)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Metadata Profile name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="primaryAlbumTypes")
    def primary_album_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Primary album types.
        """
        return pulumi.get(self, "primary_album_types")

    @primary_album_types.setter
    def primary_album_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "primary_album_types", value)

    @property
    @pulumi.getter(name="releaseStatuses")
    def release_statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Release statuses.
        """
        return pulumi.get(self, "release_statuses")

    @release_statuses.setter
    def release_statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "release_statuses", value)

    @property
    @pulumi.getter(name="secondaryAlbumTypes")
    def secondary_album_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Secondary album types.
        """
        return pulumi.get(self, "secondary_album_types")

    @secondary_album_types.setter
    def secondary_album_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "secondary_album_types", value)


class MetadataProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 primary_album_types: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 release_statuses: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 secondary_album_types: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 __props__=None):
        """
        <!-- subcategory:Profiles -->Metadata Profile resource.
        For more information refer to [Metadata Profile](https://wiki.servarr.com/lidarr/settings#metadata-profiles) documentation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.profiles.MetadataProfile("example",
            primary_album_types=[
                1,
                2,
            ],
            release_statuses=[3],
            secondary_album_types=[1])
        ```

        ## Import

        import using the API/UI ID

        ```sh
         $ pulumi import lidarr:Profiles/metadataProfile:MetadataProfile example 10
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: Metadata Profile name.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] primary_album_types: Primary album types.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] release_statuses: Release statuses.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] secondary_album_types: Secondary album types.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MetadataProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        <!-- subcategory:Profiles -->Metadata Profile resource.
        For more information refer to [Metadata Profile](https://wiki.servarr.com/lidarr/settings#metadata-profiles) documentation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.profiles.MetadataProfile("example",
            primary_album_types=[
                1,
                2,
            ],
            release_statuses=[3],
            secondary_album_types=[1])
        ```

        ## Import

        import using the API/UI ID

        ```sh
         $ pulumi import lidarr:Profiles/metadataProfile:MetadataProfile example 10
        ```

        :param str resource_name: The name of the resource.
        :param MetadataProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MetadataProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 primary_album_types: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 release_statuses: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 secondary_album_types: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MetadataProfileArgs.__new__(MetadataProfileArgs)

            __props__.__dict__["name"] = name
            if primary_album_types is None and not opts.urn:
                raise TypeError("Missing required property 'primary_album_types'")
            __props__.__dict__["primary_album_types"] = primary_album_types
            if release_statuses is None and not opts.urn:
                raise TypeError("Missing required property 'release_statuses'")
            __props__.__dict__["release_statuses"] = release_statuses
            if secondary_album_types is None and not opts.urn:
                raise TypeError("Missing required property 'secondary_album_types'")
            __props__.__dict__["secondary_album_types"] = secondary_album_types
        super(MetadataProfile, __self__).__init__(
            'lidarr:Profiles/metadataProfile:MetadataProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[str]] = None,
            primary_album_types: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            release_statuses: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            secondary_album_types: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None) -> 'MetadataProfile':
        """
        Get an existing MetadataProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: Metadata Profile name.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] primary_album_types: Primary album types.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] release_statuses: Release statuses.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] secondary_album_types: Secondary album types.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MetadataProfileState.__new__(_MetadataProfileState)

        __props__.__dict__["name"] = name
        __props__.__dict__["primary_album_types"] = primary_album_types
        __props__.__dict__["release_statuses"] = release_statuses
        __props__.__dict__["secondary_album_types"] = secondary_album_types
        return MetadataProfile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Metadata Profile name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="primaryAlbumTypes")
    def primary_album_types(self) -> pulumi.Output[Sequence[int]]:
        """
        Primary album types.
        """
        return pulumi.get(self, "primary_album_types")

    @property
    @pulumi.getter(name="releaseStatuses")
    def release_statuses(self) -> pulumi.Output[Sequence[int]]:
        """
        Release statuses.
        """
        return pulumi.get(self, "release_statuses")

    @property
    @pulumi.getter(name="secondaryAlbumTypes")
    def secondary_album_types(self) -> pulumi.Output[Sequence[int]]:
        """
        Secondary album types.
        """
        return pulumi.get(self, "secondary_album_types")

