# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetQualityProfileResult',
    'AwaitableGetQualityProfileResult',
    'get_quality_profile',
    'get_quality_profile_output',
]

@pulumi.output_type
class GetQualityProfileResult:
    """
    A collection of values returned by getQualityProfile.
    """
    def __init__(__self__, cutoff=None, cutoff_format_score=None, format_items=None, id=None, min_format_score=None, name=None, quality_groups=None, upgrade_allowed=None):
        if cutoff and not isinstance(cutoff, int):
            raise TypeError("Expected argument 'cutoff' to be a int")
        pulumi.set(__self__, "cutoff", cutoff)
        if cutoff_format_score and not isinstance(cutoff_format_score, int):
            raise TypeError("Expected argument 'cutoff_format_score' to be a int")
        pulumi.set(__self__, "cutoff_format_score", cutoff_format_score)
        if format_items and not isinstance(format_items, list):
            raise TypeError("Expected argument 'format_items' to be a list")
        pulumi.set(__self__, "format_items", format_items)
        if id and not isinstance(id, int):
            raise TypeError("Expected argument 'id' to be a int")
        pulumi.set(__self__, "id", id)
        if min_format_score and not isinstance(min_format_score, int):
            raise TypeError("Expected argument 'min_format_score' to be a int")
        pulumi.set(__self__, "min_format_score", min_format_score)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if quality_groups and not isinstance(quality_groups, list):
            raise TypeError("Expected argument 'quality_groups' to be a list")
        pulumi.set(__self__, "quality_groups", quality_groups)
        if upgrade_allowed and not isinstance(upgrade_allowed, bool):
            raise TypeError("Expected argument 'upgrade_allowed' to be a bool")
        pulumi.set(__self__, "upgrade_allowed", upgrade_allowed)

    @property
    @pulumi.getter
    def cutoff(self) -> int:
        """
        Quality ID to which cutoff.
        """
        return pulumi.get(self, "cutoff")

    @property
    @pulumi.getter(name="cutoffFormatScore")
    def cutoff_format_score(self) -> int:
        """
        Cutoff format score.
        """
        return pulumi.get(self, "cutoff_format_score")

    @property
    @pulumi.getter(name="formatItems")
    def format_items(self) -> Sequence['outputs.GetQualityProfileFormatItemResult']:
        """
        Format items.
        """
        return pulumi.get(self, "format_items")

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        Quality Profile ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="minFormatScore")
    def min_format_score(self) -> int:
        """
        Min format score.
        """
        return pulumi.get(self, "min_format_score")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Quality Profile Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="qualityGroups")
    def quality_groups(self) -> Sequence['outputs.GetQualityProfileQualityGroupResult']:
        """
        Quality groups.
        """
        return pulumi.get(self, "quality_groups")

    @property
    @pulumi.getter(name="upgradeAllowed")
    def upgrade_allowed(self) -> bool:
        """
        Upgrade allowed flag.
        """
        return pulumi.get(self, "upgrade_allowed")


class AwaitableGetQualityProfileResult(GetQualityProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetQualityProfileResult(
            cutoff=self.cutoff,
            cutoff_format_score=self.cutoff_format_score,
            format_items=self.format_items,
            id=self.id,
            min_format_score=self.min_format_score,
            name=self.name,
            quality_groups=self.quality_groups,
            upgrade_allowed=self.upgrade_allowed)


def get_quality_profile(name: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetQualityProfileResult:
    """
    <!-- subcategory:Profiles -->Single Quality Profile.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_lidarr as lidarr

    example = lidarr.Profiles.get_quality_profile(name="Example")
    ```


    :param str name: Name.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('lidarr:Profiles/getQualityProfile:getQualityProfile', __args__, opts=opts, typ=GetQualityProfileResult).value

    return AwaitableGetQualityProfileResult(
        cutoff=pulumi.get(__ret__, 'cutoff'),
        cutoff_format_score=pulumi.get(__ret__, 'cutoff_format_score'),
        format_items=pulumi.get(__ret__, 'format_items'),
        id=pulumi.get(__ret__, 'id'),
        min_format_score=pulumi.get(__ret__, 'min_format_score'),
        name=pulumi.get(__ret__, 'name'),
        quality_groups=pulumi.get(__ret__, 'quality_groups'),
        upgrade_allowed=pulumi.get(__ret__, 'upgrade_allowed'))


@_utilities.lift_output_func(get_quality_profile)
def get_quality_profile_output(name: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetQualityProfileResult]:
    """
    <!-- subcategory:Profiles -->Single Quality Profile.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_lidarr as lidarr

    example = lidarr.Profiles.get_quality_profile(name="Example")
    ```


    :param str name: Name.
    """
    ...
