# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetQualityDefinitionResult',
    'AwaitableGetQualityDefinitionResult',
    'get_quality_definition',
    'get_quality_definition_output',
]

@pulumi.output_type
class GetQualityDefinitionResult:
    """
    A collection of values returned by getQualityDefinition.
    """
    def __init__(__self__, id=None, max_size=None, min_size=None, quality_id=None, quality_name=None, title=None):
        if id and not isinstance(id, int):
            raise TypeError("Expected argument 'id' to be a int")
        pulumi.set(__self__, "id", id)
        if max_size and not isinstance(max_size, float):
            raise TypeError("Expected argument 'max_size' to be a float")
        pulumi.set(__self__, "max_size", max_size)
        if min_size and not isinstance(min_size, float):
            raise TypeError("Expected argument 'min_size' to be a float")
        pulumi.set(__self__, "min_size", min_size)
        if quality_id and not isinstance(quality_id, int):
            raise TypeError("Expected argument 'quality_id' to be a int")
        pulumi.set(__self__, "quality_id", quality_id)
        if quality_name and not isinstance(quality_name, str):
            raise TypeError("Expected argument 'quality_name' to be a str")
        pulumi.set(__self__, "quality_name", quality_name)
        if title and not isinstance(title, str):
            raise TypeError("Expected argument 'title' to be a str")
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        Quality Definition ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> float:
        """
        Maximum size MB/min.
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> float:
        """
        Minimum size MB/min.
        """
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="qualityId")
    def quality_id(self) -> int:
        """
        Quality ID.
        """
        return pulumi.get(self, "quality_id")

    @property
    @pulumi.getter(name="qualityName")
    def quality_name(self) -> str:
        """
        Quality Name.
        """
        return pulumi.get(self, "quality_name")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Quality Definition Title.
        """
        return pulumi.get(self, "title")


class AwaitableGetQualityDefinitionResult(GetQualityDefinitionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetQualityDefinitionResult(
            id=self.id,
            max_size=self.max_size,
            min_size=self.min_size,
            quality_id=self.quality_id,
            quality_name=self.quality_name,
            title=self.title)


def get_quality_definition(id: Optional[int] = None,
                           min_size: Optional[float] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetQualityDefinitionResult:
    """
    <!-- subcategory:Profiles -->Single Quality Definition.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_lidarr as lidarr

    example = lidarr.Profiles.get_quality_definition(id=32)
    ```


    :param int id: Quality Definition ID.
    :param float min_size: Minimum size MB/min.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['minSize'] = min_size
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('lidarr:Profiles/getQualityDefinition:getQualityDefinition', __args__, opts=opts, typ=GetQualityDefinitionResult).value

    return AwaitableGetQualityDefinitionResult(
        id=pulumi.get(__ret__, 'id'),
        max_size=pulumi.get(__ret__, 'max_size'),
        min_size=pulumi.get(__ret__, 'min_size'),
        quality_id=pulumi.get(__ret__, 'quality_id'),
        quality_name=pulumi.get(__ret__, 'quality_name'),
        title=pulumi.get(__ret__, 'title'))


@_utilities.lift_output_func(get_quality_definition)
def get_quality_definition_output(id: Optional[pulumi.Input[int]] = None,
                                  min_size: Optional[pulumi.Input[Optional[float]]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetQualityDefinitionResult]:
    """
    <!-- subcategory:Profiles -->Single Quality Definition.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_lidarr as lidarr

    example = lidarr.Profiles.get_quality_definition(id=32)
    ```


    :param int id: Quality Definition ID.
    :param float min_size: Minimum size MB/min.
    """
    ...
