# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetDelayProfileResult',
    'AwaitableGetDelayProfileResult',
    'get_delay_profile',
    'get_delay_profile_output',
]

@pulumi.output_type
class GetDelayProfileResult:
    """
    A collection of values returned by getDelayProfile.
    """
    def __init__(__self__, enable_torrent=None, enable_usenet=None, id=None, order=None, preferred_protocol=None, tags=None, torrent_delay=None, usenet_delay=None):
        if enable_torrent and not isinstance(enable_torrent, bool):
            raise TypeError("Expected argument 'enable_torrent' to be a bool")
        pulumi.set(__self__, "enable_torrent", enable_torrent)
        if enable_usenet and not isinstance(enable_usenet, bool):
            raise TypeError("Expected argument 'enable_usenet' to be a bool")
        pulumi.set(__self__, "enable_usenet", enable_usenet)
        if id and not isinstance(id, int):
            raise TypeError("Expected argument 'id' to be a int")
        pulumi.set(__self__, "id", id)
        if order and not isinstance(order, int):
            raise TypeError("Expected argument 'order' to be a int")
        pulumi.set(__self__, "order", order)
        if preferred_protocol and not isinstance(preferred_protocol, str):
            raise TypeError("Expected argument 'preferred_protocol' to be a str")
        pulumi.set(__self__, "preferred_protocol", preferred_protocol)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if torrent_delay and not isinstance(torrent_delay, int):
            raise TypeError("Expected argument 'torrent_delay' to be a int")
        pulumi.set(__self__, "torrent_delay", torrent_delay)
        if usenet_delay and not isinstance(usenet_delay, int):
            raise TypeError("Expected argument 'usenet_delay' to be a int")
        pulumi.set(__self__, "usenet_delay", usenet_delay)

    @property
    @pulumi.getter(name="enableTorrent")
    def enable_torrent(self) -> bool:
        """
        Torrent allowed Flag.
        """
        return pulumi.get(self, "enable_torrent")

    @property
    @pulumi.getter(name="enableUsenet")
    def enable_usenet(self) -> bool:
        """
        Usenet allowed Flag.
        """
        return pulumi.get(self, "enable_usenet")

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        Delay Profile ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def order(self) -> int:
        """
        Order.
        """
        return pulumi.get(self, "order")

    @property
    @pulumi.getter(name="preferredProtocol")
    def preferred_protocol(self) -> str:
        """
        Preferred protocol.
        """
        return pulumi.get(self, "preferred_protocol")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[int]:
        """
        List of associated tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="torrentDelay")
    def torrent_delay(self) -> int:
        """
        Torrent Delay.
        """
        return pulumi.get(self, "torrent_delay")

    @property
    @pulumi.getter(name="usenetDelay")
    def usenet_delay(self) -> int:
        """
        Usenet delay.
        """
        return pulumi.get(self, "usenet_delay")


class AwaitableGetDelayProfileResult(GetDelayProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDelayProfileResult(
            enable_torrent=self.enable_torrent,
            enable_usenet=self.enable_usenet,
            id=self.id,
            order=self.order,
            preferred_protocol=self.preferred_protocol,
            tags=self.tags,
            torrent_delay=self.torrent_delay,
            usenet_delay=self.usenet_delay)


def get_delay_profile(id: Optional[int] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDelayProfileResult:
    """
    <!-- subcategory:Profiles -->Single Delay Profile.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_lidarr as lidarr

    example = lidarr.Profiles.get_delay_profile(id=1)
    ```


    :param int id: Delay Profile ID.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('lidarr:Profiles/getDelayProfile:getDelayProfile', __args__, opts=opts, typ=GetDelayProfileResult).value

    return AwaitableGetDelayProfileResult(
        enable_torrent=pulumi.get(__ret__, 'enable_torrent'),
        enable_usenet=pulumi.get(__ret__, 'enable_usenet'),
        id=pulumi.get(__ret__, 'id'),
        order=pulumi.get(__ret__, 'order'),
        preferred_protocol=pulumi.get(__ret__, 'preferred_protocol'),
        tags=pulumi.get(__ret__, 'tags'),
        torrent_delay=pulumi.get(__ret__, 'torrent_delay'),
        usenet_delay=pulumi.get(__ret__, 'usenet_delay'))


@_utilities.lift_output_func(get_delay_profile)
def get_delay_profile_output(id: Optional[pulumi.Input[int]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDelayProfileResult]:
    """
    <!-- subcategory:Profiles -->Single Delay Profile.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_lidarr as lidarr

    example = lidarr.Profiles.get_delay_profile(id=1)
    ```


    :param int id: Delay Profile ID.
    """
    ...
