# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['DelayProfileArgs', 'DelayProfile']

@pulumi.input_type
class DelayProfileArgs:
    def __init__(__self__, *,
                 tags: pulumi.Input[Sequence[pulumi.Input[int]]],
                 enable_torrent: Optional[pulumi.Input[bool]] = None,
                 enable_usenet: Optional[pulumi.Input[bool]] = None,
                 order: Optional[pulumi.Input[int]] = None,
                 preferred_protocol: Optional[pulumi.Input[str]] = None,
                 torrent_delay: Optional[pulumi.Input[int]] = None,
                 usenet_delay: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a DelayProfile resource.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        :param pulumi.Input[bool] enable_torrent: Torrent allowed flag at least one of `enable_usenet` and `enable_torrent` must be defined.
        :param pulumi.Input[bool] enable_usenet: Usenet allowed flag at least one of `enable_usenet` and `enable_torrent` must be defined.
        :param pulumi.Input[int] order: Order.
        :param pulumi.Input[str] preferred_protocol: Preferred protocol.
        :param pulumi.Input[int] torrent_delay: Torrent Delay.
        :param pulumi.Input[int] usenet_delay: Usenet delay.
        """
        pulumi.set(__self__, "tags", tags)
        if enable_torrent is not None:
            pulumi.set(__self__, "enable_torrent", enable_torrent)
        if enable_usenet is not None:
            pulumi.set(__self__, "enable_usenet", enable_usenet)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if preferred_protocol is not None:
            pulumi.set(__self__, "preferred_protocol", preferred_protocol)
        if torrent_delay is not None:
            pulumi.set(__self__, "torrent_delay", torrent_delay)
        if usenet_delay is not None:
            pulumi.set(__self__, "usenet_delay", usenet_delay)

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Input[Sequence[pulumi.Input[int]]]:
        """
        List of associated tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: pulumi.Input[Sequence[pulumi.Input[int]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="enableTorrent")
    def enable_torrent(self) -> Optional[pulumi.Input[bool]]:
        """
        Torrent allowed flag at least one of `enable_usenet` and `enable_torrent` must be defined.
        """
        return pulumi.get(self, "enable_torrent")

    @enable_torrent.setter
    def enable_torrent(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_torrent", value)

    @property
    @pulumi.getter(name="enableUsenet")
    def enable_usenet(self) -> Optional[pulumi.Input[bool]]:
        """
        Usenet allowed flag at least one of `enable_usenet` and `enable_torrent` must be defined.
        """
        return pulumi.get(self, "enable_usenet")

    @enable_usenet.setter
    def enable_usenet(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_usenet", value)

    @property
    @pulumi.getter
    def order(self) -> Optional[pulumi.Input[int]]:
        """
        Order.
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "order", value)

    @property
    @pulumi.getter(name="preferredProtocol")
    def preferred_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Preferred protocol.
        """
        return pulumi.get(self, "preferred_protocol")

    @preferred_protocol.setter
    def preferred_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_protocol", value)

    @property
    @pulumi.getter(name="torrentDelay")
    def torrent_delay(self) -> Optional[pulumi.Input[int]]:
        """
        Torrent Delay.
        """
        return pulumi.get(self, "torrent_delay")

    @torrent_delay.setter
    def torrent_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "torrent_delay", value)

    @property
    @pulumi.getter(name="usenetDelay")
    def usenet_delay(self) -> Optional[pulumi.Input[int]]:
        """
        Usenet delay.
        """
        return pulumi.get(self, "usenet_delay")

    @usenet_delay.setter
    def usenet_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "usenet_delay", value)


@pulumi.input_type
class _DelayProfileState:
    def __init__(__self__, *,
                 enable_torrent: Optional[pulumi.Input[bool]] = None,
                 enable_usenet: Optional[pulumi.Input[bool]] = None,
                 order: Optional[pulumi.Input[int]] = None,
                 preferred_protocol: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 torrent_delay: Optional[pulumi.Input[int]] = None,
                 usenet_delay: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering DelayProfile resources.
        :param pulumi.Input[bool] enable_torrent: Torrent allowed flag at least one of `enable_usenet` and `enable_torrent` must be defined.
        :param pulumi.Input[bool] enable_usenet: Usenet allowed flag at least one of `enable_usenet` and `enable_torrent` must be defined.
        :param pulumi.Input[int] order: Order.
        :param pulumi.Input[str] preferred_protocol: Preferred protocol.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        :param pulumi.Input[int] torrent_delay: Torrent Delay.
        :param pulumi.Input[int] usenet_delay: Usenet delay.
        """
        if enable_torrent is not None:
            pulumi.set(__self__, "enable_torrent", enable_torrent)
        if enable_usenet is not None:
            pulumi.set(__self__, "enable_usenet", enable_usenet)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if preferred_protocol is not None:
            pulumi.set(__self__, "preferred_protocol", preferred_protocol)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if torrent_delay is not None:
            pulumi.set(__self__, "torrent_delay", torrent_delay)
        if usenet_delay is not None:
            pulumi.set(__self__, "usenet_delay", usenet_delay)

    @property
    @pulumi.getter(name="enableTorrent")
    def enable_torrent(self) -> Optional[pulumi.Input[bool]]:
        """
        Torrent allowed flag at least one of `enable_usenet` and `enable_torrent` must be defined.
        """
        return pulumi.get(self, "enable_torrent")

    @enable_torrent.setter
    def enable_torrent(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_torrent", value)

    @property
    @pulumi.getter(name="enableUsenet")
    def enable_usenet(self) -> Optional[pulumi.Input[bool]]:
        """
        Usenet allowed flag at least one of `enable_usenet` and `enable_torrent` must be defined.
        """
        return pulumi.get(self, "enable_usenet")

    @enable_usenet.setter
    def enable_usenet(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_usenet", value)

    @property
    @pulumi.getter
    def order(self) -> Optional[pulumi.Input[int]]:
        """
        Order.
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "order", value)

    @property
    @pulumi.getter(name="preferredProtocol")
    def preferred_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Preferred protocol.
        """
        return pulumi.get(self, "preferred_protocol")

    @preferred_protocol.setter
    def preferred_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_protocol", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        List of associated tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="torrentDelay")
    def torrent_delay(self) -> Optional[pulumi.Input[int]]:
        """
        Torrent Delay.
        """
        return pulumi.get(self, "torrent_delay")

    @torrent_delay.setter
    def torrent_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "torrent_delay", value)

    @property
    @pulumi.getter(name="usenetDelay")
    def usenet_delay(self) -> Optional[pulumi.Input[int]]:
        """
        Usenet delay.
        """
        return pulumi.get(self, "usenet_delay")

    @usenet_delay.setter
    def usenet_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "usenet_delay", value)


class DelayProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_torrent: Optional[pulumi.Input[bool]] = None,
                 enable_usenet: Optional[pulumi.Input[bool]] = None,
                 order: Optional[pulumi.Input[int]] = None,
                 preferred_protocol: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 torrent_delay: Optional[pulumi.Input[int]] = None,
                 usenet_delay: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        <!-- subcategory:Profiles -->Delay Profile resource.
        For more information refer to [Delay Profiles](https://wiki.servarr.com/lidarr/settings#delay-profiles) documentation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.profiles.DelayProfile("example",
            enable_torrent=True,
            enable_usenet=True,
            preferred_protocol="torrent",
            tags=[
                1,
                2,
            ],
            torrent_delay=0,
            usenet_delay=0)
        ```

        ## Import

        import using the API/UI ID

        ```sh
         $ pulumi import lidarr:Profiles/delayProfile:DelayProfile example 10
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enable_torrent: Torrent allowed flag at least one of `enable_usenet` and `enable_torrent` must be defined.
        :param pulumi.Input[bool] enable_usenet: Usenet allowed flag at least one of `enable_usenet` and `enable_torrent` must be defined.
        :param pulumi.Input[int] order: Order.
        :param pulumi.Input[str] preferred_protocol: Preferred protocol.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        :param pulumi.Input[int] torrent_delay: Torrent Delay.
        :param pulumi.Input[int] usenet_delay: Usenet delay.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DelayProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        <!-- subcategory:Profiles -->Delay Profile resource.
        For more information refer to [Delay Profiles](https://wiki.servarr.com/lidarr/settings#delay-profiles) documentation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.profiles.DelayProfile("example",
            enable_torrent=True,
            enable_usenet=True,
            preferred_protocol="torrent",
            tags=[
                1,
                2,
            ],
            torrent_delay=0,
            usenet_delay=0)
        ```

        ## Import

        import using the API/UI ID

        ```sh
         $ pulumi import lidarr:Profiles/delayProfile:DelayProfile example 10
        ```

        :param str resource_name: The name of the resource.
        :param DelayProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DelayProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_torrent: Optional[pulumi.Input[bool]] = None,
                 enable_usenet: Optional[pulumi.Input[bool]] = None,
                 order: Optional[pulumi.Input[int]] = None,
                 preferred_protocol: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 torrent_delay: Optional[pulumi.Input[int]] = None,
                 usenet_delay: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DelayProfileArgs.__new__(DelayProfileArgs)

            __props__.__dict__["enable_torrent"] = enable_torrent
            __props__.__dict__["enable_usenet"] = enable_usenet
            __props__.__dict__["order"] = order
            __props__.__dict__["preferred_protocol"] = preferred_protocol
            if tags is None and not opts.urn:
                raise TypeError("Missing required property 'tags'")
            __props__.__dict__["tags"] = tags
            __props__.__dict__["torrent_delay"] = torrent_delay
            __props__.__dict__["usenet_delay"] = usenet_delay
        super(DelayProfile, __self__).__init__(
            'lidarr:Profiles/delayProfile:DelayProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enable_torrent: Optional[pulumi.Input[bool]] = None,
            enable_usenet: Optional[pulumi.Input[bool]] = None,
            order: Optional[pulumi.Input[int]] = None,
            preferred_protocol: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            torrent_delay: Optional[pulumi.Input[int]] = None,
            usenet_delay: Optional[pulumi.Input[int]] = None) -> 'DelayProfile':
        """
        Get an existing DelayProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enable_torrent: Torrent allowed flag at least one of `enable_usenet` and `enable_torrent` must be defined.
        :param pulumi.Input[bool] enable_usenet: Usenet allowed flag at least one of `enable_usenet` and `enable_torrent` must be defined.
        :param pulumi.Input[int] order: Order.
        :param pulumi.Input[str] preferred_protocol: Preferred protocol.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        :param pulumi.Input[int] torrent_delay: Torrent Delay.
        :param pulumi.Input[int] usenet_delay: Usenet delay.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DelayProfileState.__new__(_DelayProfileState)

        __props__.__dict__["enable_torrent"] = enable_torrent
        __props__.__dict__["enable_usenet"] = enable_usenet
        __props__.__dict__["order"] = order
        __props__.__dict__["preferred_protocol"] = preferred_protocol
        __props__.__dict__["tags"] = tags
        __props__.__dict__["torrent_delay"] = torrent_delay
        __props__.__dict__["usenet_delay"] = usenet_delay
        return DelayProfile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="enableTorrent")
    def enable_torrent(self) -> pulumi.Output[bool]:
        """
        Torrent allowed flag at least one of `enable_usenet` and `enable_torrent` must be defined.
        """
        return pulumi.get(self, "enable_torrent")

    @property
    @pulumi.getter(name="enableUsenet")
    def enable_usenet(self) -> pulumi.Output[bool]:
        """
        Usenet allowed flag at least one of `enable_usenet` and `enable_torrent` must be defined.
        """
        return pulumi.get(self, "enable_usenet")

    @property
    @pulumi.getter
    def order(self) -> pulumi.Output[int]:
        """
        Order.
        """
        return pulumi.get(self, "order")

    @property
    @pulumi.getter(name="preferredProtocol")
    def preferred_protocol(self) -> pulumi.Output[str]:
        """
        Preferred protocol.
        """
        return pulumi.get(self, "preferred_protocol")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[int]]:
        """
        List of associated tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="torrentDelay")
    def torrent_delay(self) -> pulumi.Output[int]:
        """
        Torrent Delay.
        """
        return pulumi.get(self, "torrent_delay")

    @property
    @pulumi.getter(name="usenetDelay")
    def usenet_delay(self) -> pulumi.Output[int]:
        """
        Usenet delay.
        """
        return pulumi.get(self, "usenet_delay")

