# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CustomFormatArgs', 'CustomFormat']

@pulumi.input_type
class CustomFormatArgs:
    def __init__(__self__, *,
                 specifications: pulumi.Input[Sequence[pulumi.Input['CustomFormatSpecificationArgs']]],
                 include_custom_format_when_renaming: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CustomFormat resource.
        :param pulumi.Input[Sequence[pulumi.Input['CustomFormatSpecificationArgs']]] specifications: Specifications.
        :param pulumi.Input[bool] include_custom_format_when_renaming: Include custom format when renaming flag.
        :param pulumi.Input[str] name: Specification name.
        """
        pulumi.set(__self__, "specifications", specifications)
        if include_custom_format_when_renaming is not None:
            pulumi.set(__self__, "include_custom_format_when_renaming", include_custom_format_when_renaming)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def specifications(self) -> pulumi.Input[Sequence[pulumi.Input['CustomFormatSpecificationArgs']]]:
        """
        Specifications.
        """
        return pulumi.get(self, "specifications")

    @specifications.setter
    def specifications(self, value: pulumi.Input[Sequence[pulumi.Input['CustomFormatSpecificationArgs']]]):
        pulumi.set(self, "specifications", value)

    @property
    @pulumi.getter(name="includeCustomFormatWhenRenaming")
    def include_custom_format_when_renaming(self) -> Optional[pulumi.Input[bool]]:
        """
        Include custom format when renaming flag.
        """
        return pulumi.get(self, "include_custom_format_when_renaming")

    @include_custom_format_when_renaming.setter
    def include_custom_format_when_renaming(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_custom_format_when_renaming", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specification name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _CustomFormatState:
    def __init__(__self__, *,
                 include_custom_format_when_renaming: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 specifications: Optional[pulumi.Input[Sequence[pulumi.Input['CustomFormatSpecificationArgs']]]] = None):
        """
        Input properties used for looking up and filtering CustomFormat resources.
        :param pulumi.Input[bool] include_custom_format_when_renaming: Include custom format when renaming flag.
        :param pulumi.Input[str] name: Specification name.
        :param pulumi.Input[Sequence[pulumi.Input['CustomFormatSpecificationArgs']]] specifications: Specifications.
        """
        if include_custom_format_when_renaming is not None:
            pulumi.set(__self__, "include_custom_format_when_renaming", include_custom_format_when_renaming)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if specifications is not None:
            pulumi.set(__self__, "specifications", specifications)

    @property
    @pulumi.getter(name="includeCustomFormatWhenRenaming")
    def include_custom_format_when_renaming(self) -> Optional[pulumi.Input[bool]]:
        """
        Include custom format when renaming flag.
        """
        return pulumi.get(self, "include_custom_format_when_renaming")

    @include_custom_format_when_renaming.setter
    def include_custom_format_when_renaming(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_custom_format_when_renaming", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specification name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def specifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomFormatSpecificationArgs']]]]:
        """
        Specifications.
        """
        return pulumi.get(self, "specifications")

    @specifications.setter
    def specifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomFormatSpecificationArgs']]]]):
        pulumi.set(self, "specifications", value)


class CustomFormat(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 include_custom_format_when_renaming: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 specifications: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CustomFormatSpecificationArgs']]]]] = None,
                 __props__=None):
        """
        <!-- subcategory:Profiles -->Custom Format resource.
        For more information refer to [Custom Format](https://wiki.servarr.com/lidarr/settings#custom-formats).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.profiles.CustomFormat("example",
            include_custom_format_when_renaming=True,
            specifications=[
                lidarr.profiles.CustomFormatSpecificationArgs(
                    implementation="ReleaseTitleSpecification",
                    name="Preferred Words",
                    negate=False,
                    required=False,
                    value="\\\\b(SPARKS|Framestor)\\\\b",
                ),
                lidarr.profiles.CustomFormatSpecificationArgs(
                    implementation="SizeSpecification",
                    max=100,
                    min=0,
                    name="Size",
                    negate=False,
                    required=False,
                ),
            ])
        ```

        ## Import

        import using the API/UI ID

        ```sh
         $ pulumi import lidarr:Profiles/customFormat:CustomFormat example 1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] include_custom_format_when_renaming: Include custom format when renaming flag.
        :param pulumi.Input[str] name: Specification name.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CustomFormatSpecificationArgs']]]] specifications: Specifications.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomFormatArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        <!-- subcategory:Profiles -->Custom Format resource.
        For more information refer to [Custom Format](https://wiki.servarr.com/lidarr/settings#custom-formats).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.profiles.CustomFormat("example",
            include_custom_format_when_renaming=True,
            specifications=[
                lidarr.profiles.CustomFormatSpecificationArgs(
                    implementation="ReleaseTitleSpecification",
                    name="Preferred Words",
                    negate=False,
                    required=False,
                    value="\\\\b(SPARKS|Framestor)\\\\b",
                ),
                lidarr.profiles.CustomFormatSpecificationArgs(
                    implementation="SizeSpecification",
                    max=100,
                    min=0,
                    name="Size",
                    negate=False,
                    required=False,
                ),
            ])
        ```

        ## Import

        import using the API/UI ID

        ```sh
         $ pulumi import lidarr:Profiles/customFormat:CustomFormat example 1
        ```

        :param str resource_name: The name of the resource.
        :param CustomFormatArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomFormatArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 include_custom_format_when_renaming: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 specifications: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CustomFormatSpecificationArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomFormatArgs.__new__(CustomFormatArgs)

            __props__.__dict__["include_custom_format_when_renaming"] = include_custom_format_when_renaming
            __props__.__dict__["name"] = name
            if specifications is None and not opts.urn:
                raise TypeError("Missing required property 'specifications'")
            __props__.__dict__["specifications"] = specifications
        super(CustomFormat, __self__).__init__(
            'lidarr:Profiles/customFormat:CustomFormat',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            include_custom_format_when_renaming: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            specifications: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CustomFormatSpecificationArgs']]]]] = None) -> 'CustomFormat':
        """
        Get an existing CustomFormat resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] include_custom_format_when_renaming: Include custom format when renaming flag.
        :param pulumi.Input[str] name: Specification name.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CustomFormatSpecificationArgs']]]] specifications: Specifications.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomFormatState.__new__(_CustomFormatState)

        __props__.__dict__["include_custom_format_when_renaming"] = include_custom_format_when_renaming
        __props__.__dict__["name"] = name
        __props__.__dict__["specifications"] = specifications
        return CustomFormat(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="includeCustomFormatWhenRenaming")
    def include_custom_format_when_renaming(self) -> pulumi.Output[bool]:
        """
        Include custom format when renaming flag.
        """
        return pulumi.get(self, "include_custom_format_when_renaming")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specification name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def specifications(self) -> pulumi.Output[Sequence['outputs.CustomFormatSpecification']]:
        """
        Specifications.
        """
        return pulumi.get(self, "specifications")

