# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['PushoverArgs', 'Pushover']

@pulumi.input_type
class PushoverArgs:
    def __init__(__self__, *,
                 api_key: pulumi.Input[str],
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 expire: Optional[pulumi.Input[int]] = None,
                 include_health_warnings: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 on_album_delete: Optional[pulumi.Input[bool]] = None,
                 on_application_update: Optional[pulumi.Input[bool]] = None,
                 on_artist_delete: Optional[pulumi.Input[bool]] = None,
                 on_download_failure: Optional[pulumi.Input[bool]] = None,
                 on_grab: Optional[pulumi.Input[bool]] = None,
                 on_health_issue: Optional[pulumi.Input[bool]] = None,
                 on_health_restored: Optional[pulumi.Input[bool]] = None,
                 on_import_failure: Optional[pulumi.Input[bool]] = None,
                 on_release_import: Optional[pulumi.Input[bool]] = None,
                 on_upgrade: Optional[pulumi.Input[bool]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 retry: Optional[pulumi.Input[int]] = None,
                 sound: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 user_key: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Pushover resource.
        :param pulumi.Input[str] api_key: API key.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] devices: List of devices.
        :param pulumi.Input[int] expire: Expire.
        :param pulumi.Input[bool] include_health_warnings: Include health warnings.
        :param pulumi.Input[str] name: NotificationPushover name.
        :param pulumi.Input[bool] on_album_delete: On album delete flag.
        :param pulumi.Input[bool] on_application_update: On application update flag.
        :param pulumi.Input[bool] on_artist_delete: On artist delete flag.
        :param pulumi.Input[bool] on_download_failure: On download failure flag.
        :param pulumi.Input[bool] on_grab: On grab flag.
        :param pulumi.Input[bool] on_health_issue: On health issue flag.
        :param pulumi.Input[bool] on_health_restored: On health restored flag.
        :param pulumi.Input[bool] on_import_failure: On download flag.
        :param pulumi.Input[bool] on_release_import: On release import flag.
        :param pulumi.Input[bool] on_upgrade: On upgrade flag.
        :param pulumi.Input[int] priority: Priority. `-2` Silent, `-1` Quiet, `0` Normal, `1` High, `2` Emergency, `8` High.
        :param pulumi.Input[int] retry: Retry.
        :param pulumi.Input[str] sound: Sound.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        :param pulumi.Input[str] user_key: User key.
        """
        pulumi.set(__self__, "api_key", api_key)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if expire is not None:
            pulumi.set(__self__, "expire", expire)
        if include_health_warnings is not None:
            pulumi.set(__self__, "include_health_warnings", include_health_warnings)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if on_album_delete is not None:
            pulumi.set(__self__, "on_album_delete", on_album_delete)
        if on_application_update is not None:
            pulumi.set(__self__, "on_application_update", on_application_update)
        if on_artist_delete is not None:
            pulumi.set(__self__, "on_artist_delete", on_artist_delete)
        if on_download_failure is not None:
            pulumi.set(__self__, "on_download_failure", on_download_failure)
        if on_grab is not None:
            pulumi.set(__self__, "on_grab", on_grab)
        if on_health_issue is not None:
            pulumi.set(__self__, "on_health_issue", on_health_issue)
        if on_health_restored is not None:
            pulumi.set(__self__, "on_health_restored", on_health_restored)
        if on_import_failure is not None:
            pulumi.set(__self__, "on_import_failure", on_import_failure)
        if on_release_import is not None:
            pulumi.set(__self__, "on_release_import", on_release_import)
        if on_upgrade is not None:
            pulumi.set(__self__, "on_upgrade", on_upgrade)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if retry is not None:
            pulumi.set(__self__, "retry", retry)
        if sound is not None:
            pulumi.set(__self__, "sound", sound)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_key is not None:
            pulumi.set(__self__, "user_key", user_key)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Input[str]:
        """
        API key.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter
    def devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of devices.
        """
        return pulumi.get(self, "devices")

    @devices.setter
    def devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "devices", value)

    @property
    @pulumi.getter
    def expire(self) -> Optional[pulumi.Input[int]]:
        """
        Expire.
        """
        return pulumi.get(self, "expire")

    @expire.setter
    def expire(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expire", value)

    @property
    @pulumi.getter(name="includeHealthWarnings")
    def include_health_warnings(self) -> Optional[pulumi.Input[bool]]:
        """
        Include health warnings.
        """
        return pulumi.get(self, "include_health_warnings")

    @include_health_warnings.setter
    def include_health_warnings(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_health_warnings", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        NotificationPushover name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="onAlbumDelete")
    def on_album_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        On album delete flag.
        """
        return pulumi.get(self, "on_album_delete")

    @on_album_delete.setter
    def on_album_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_album_delete", value)

    @property
    @pulumi.getter(name="onApplicationUpdate")
    def on_application_update(self) -> Optional[pulumi.Input[bool]]:
        """
        On application update flag.
        """
        return pulumi.get(self, "on_application_update")

    @on_application_update.setter
    def on_application_update(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_application_update", value)

    @property
    @pulumi.getter(name="onArtistDelete")
    def on_artist_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        On artist delete flag.
        """
        return pulumi.get(self, "on_artist_delete")

    @on_artist_delete.setter
    def on_artist_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_artist_delete", value)

    @property
    @pulumi.getter(name="onDownloadFailure")
    def on_download_failure(self) -> Optional[pulumi.Input[bool]]:
        """
        On download failure flag.
        """
        return pulumi.get(self, "on_download_failure")

    @on_download_failure.setter
    def on_download_failure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_download_failure", value)

    @property
    @pulumi.getter(name="onGrab")
    def on_grab(self) -> Optional[pulumi.Input[bool]]:
        """
        On grab flag.
        """
        return pulumi.get(self, "on_grab")

    @on_grab.setter
    def on_grab(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_grab", value)

    @property
    @pulumi.getter(name="onHealthIssue")
    def on_health_issue(self) -> Optional[pulumi.Input[bool]]:
        """
        On health issue flag.
        """
        return pulumi.get(self, "on_health_issue")

    @on_health_issue.setter
    def on_health_issue(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_health_issue", value)

    @property
    @pulumi.getter(name="onHealthRestored")
    def on_health_restored(self) -> Optional[pulumi.Input[bool]]:
        """
        On health restored flag.
        """
        return pulumi.get(self, "on_health_restored")

    @on_health_restored.setter
    def on_health_restored(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_health_restored", value)

    @property
    @pulumi.getter(name="onImportFailure")
    def on_import_failure(self) -> Optional[pulumi.Input[bool]]:
        """
        On download flag.
        """
        return pulumi.get(self, "on_import_failure")

    @on_import_failure.setter
    def on_import_failure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_import_failure", value)

    @property
    @pulumi.getter(name="onReleaseImport")
    def on_release_import(self) -> Optional[pulumi.Input[bool]]:
        """
        On release import flag.
        """
        return pulumi.get(self, "on_release_import")

    @on_release_import.setter
    def on_release_import(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_release_import", value)

    @property
    @pulumi.getter(name="onUpgrade")
    def on_upgrade(self) -> Optional[pulumi.Input[bool]]:
        """
        On upgrade flag.
        """
        return pulumi.get(self, "on_upgrade")

    @on_upgrade.setter
    def on_upgrade(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_upgrade", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Priority. `-2` Silent, `-1` Quiet, `0` Normal, `1` High, `2` Emergency, `8` High.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def retry(self) -> Optional[pulumi.Input[int]]:
        """
        Retry.
        """
        return pulumi.get(self, "retry")

    @retry.setter
    def retry(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retry", value)

    @property
    @pulumi.getter
    def sound(self) -> Optional[pulumi.Input[str]]:
        """
        Sound.
        """
        return pulumi.get(self, "sound")

    @sound.setter
    def sound(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sound", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        List of associated tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userKey")
    def user_key(self) -> Optional[pulumi.Input[str]]:
        """
        User key.
        """
        return pulumi.get(self, "user_key")

    @user_key.setter
    def user_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_key", value)


@pulumi.input_type
class _PushoverState:
    def __init__(__self__, *,
                 api_key: Optional[pulumi.Input[str]] = None,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 expire: Optional[pulumi.Input[int]] = None,
                 include_health_warnings: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 on_album_delete: Optional[pulumi.Input[bool]] = None,
                 on_application_update: Optional[pulumi.Input[bool]] = None,
                 on_artist_delete: Optional[pulumi.Input[bool]] = None,
                 on_download_failure: Optional[pulumi.Input[bool]] = None,
                 on_grab: Optional[pulumi.Input[bool]] = None,
                 on_health_issue: Optional[pulumi.Input[bool]] = None,
                 on_health_restored: Optional[pulumi.Input[bool]] = None,
                 on_import_failure: Optional[pulumi.Input[bool]] = None,
                 on_release_import: Optional[pulumi.Input[bool]] = None,
                 on_upgrade: Optional[pulumi.Input[bool]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 retry: Optional[pulumi.Input[int]] = None,
                 sound: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 user_key: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Pushover resources.
        :param pulumi.Input[str] api_key: API key.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] devices: List of devices.
        :param pulumi.Input[int] expire: Expire.
        :param pulumi.Input[bool] include_health_warnings: Include health warnings.
        :param pulumi.Input[str] name: NotificationPushover name.
        :param pulumi.Input[bool] on_album_delete: On album delete flag.
        :param pulumi.Input[bool] on_application_update: On application update flag.
        :param pulumi.Input[bool] on_artist_delete: On artist delete flag.
        :param pulumi.Input[bool] on_download_failure: On download failure flag.
        :param pulumi.Input[bool] on_grab: On grab flag.
        :param pulumi.Input[bool] on_health_issue: On health issue flag.
        :param pulumi.Input[bool] on_health_restored: On health restored flag.
        :param pulumi.Input[bool] on_import_failure: On download flag.
        :param pulumi.Input[bool] on_release_import: On release import flag.
        :param pulumi.Input[bool] on_upgrade: On upgrade flag.
        :param pulumi.Input[int] priority: Priority. `-2` Silent, `-1` Quiet, `0` Normal, `1` High, `2` Emergency, `8` High.
        :param pulumi.Input[int] retry: Retry.
        :param pulumi.Input[str] sound: Sound.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        :param pulumi.Input[str] user_key: User key.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if expire is not None:
            pulumi.set(__self__, "expire", expire)
        if include_health_warnings is not None:
            pulumi.set(__self__, "include_health_warnings", include_health_warnings)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if on_album_delete is not None:
            pulumi.set(__self__, "on_album_delete", on_album_delete)
        if on_application_update is not None:
            pulumi.set(__self__, "on_application_update", on_application_update)
        if on_artist_delete is not None:
            pulumi.set(__self__, "on_artist_delete", on_artist_delete)
        if on_download_failure is not None:
            pulumi.set(__self__, "on_download_failure", on_download_failure)
        if on_grab is not None:
            pulumi.set(__self__, "on_grab", on_grab)
        if on_health_issue is not None:
            pulumi.set(__self__, "on_health_issue", on_health_issue)
        if on_health_restored is not None:
            pulumi.set(__self__, "on_health_restored", on_health_restored)
        if on_import_failure is not None:
            pulumi.set(__self__, "on_import_failure", on_import_failure)
        if on_release_import is not None:
            pulumi.set(__self__, "on_release_import", on_release_import)
        if on_upgrade is not None:
            pulumi.set(__self__, "on_upgrade", on_upgrade)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if retry is not None:
            pulumi.set(__self__, "retry", retry)
        if sound is not None:
            pulumi.set(__self__, "sound", sound)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_key is not None:
            pulumi.set(__self__, "user_key", user_key)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[str]]:
        """
        API key.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter
    def devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of devices.
        """
        return pulumi.get(self, "devices")

    @devices.setter
    def devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "devices", value)

    @property
    @pulumi.getter
    def expire(self) -> Optional[pulumi.Input[int]]:
        """
        Expire.
        """
        return pulumi.get(self, "expire")

    @expire.setter
    def expire(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expire", value)

    @property
    @pulumi.getter(name="includeHealthWarnings")
    def include_health_warnings(self) -> Optional[pulumi.Input[bool]]:
        """
        Include health warnings.
        """
        return pulumi.get(self, "include_health_warnings")

    @include_health_warnings.setter
    def include_health_warnings(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_health_warnings", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        NotificationPushover name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="onAlbumDelete")
    def on_album_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        On album delete flag.
        """
        return pulumi.get(self, "on_album_delete")

    @on_album_delete.setter
    def on_album_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_album_delete", value)

    @property
    @pulumi.getter(name="onApplicationUpdate")
    def on_application_update(self) -> Optional[pulumi.Input[bool]]:
        """
        On application update flag.
        """
        return pulumi.get(self, "on_application_update")

    @on_application_update.setter
    def on_application_update(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_application_update", value)

    @property
    @pulumi.getter(name="onArtistDelete")
    def on_artist_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        On artist delete flag.
        """
        return pulumi.get(self, "on_artist_delete")

    @on_artist_delete.setter
    def on_artist_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_artist_delete", value)

    @property
    @pulumi.getter(name="onDownloadFailure")
    def on_download_failure(self) -> Optional[pulumi.Input[bool]]:
        """
        On download failure flag.
        """
        return pulumi.get(self, "on_download_failure")

    @on_download_failure.setter
    def on_download_failure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_download_failure", value)

    @property
    @pulumi.getter(name="onGrab")
    def on_grab(self) -> Optional[pulumi.Input[bool]]:
        """
        On grab flag.
        """
        return pulumi.get(self, "on_grab")

    @on_grab.setter
    def on_grab(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_grab", value)

    @property
    @pulumi.getter(name="onHealthIssue")
    def on_health_issue(self) -> Optional[pulumi.Input[bool]]:
        """
        On health issue flag.
        """
        return pulumi.get(self, "on_health_issue")

    @on_health_issue.setter
    def on_health_issue(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_health_issue", value)

    @property
    @pulumi.getter(name="onHealthRestored")
    def on_health_restored(self) -> Optional[pulumi.Input[bool]]:
        """
        On health restored flag.
        """
        return pulumi.get(self, "on_health_restored")

    @on_health_restored.setter
    def on_health_restored(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_health_restored", value)

    @property
    @pulumi.getter(name="onImportFailure")
    def on_import_failure(self) -> Optional[pulumi.Input[bool]]:
        """
        On download flag.
        """
        return pulumi.get(self, "on_import_failure")

    @on_import_failure.setter
    def on_import_failure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_import_failure", value)

    @property
    @pulumi.getter(name="onReleaseImport")
    def on_release_import(self) -> Optional[pulumi.Input[bool]]:
        """
        On release import flag.
        """
        return pulumi.get(self, "on_release_import")

    @on_release_import.setter
    def on_release_import(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_release_import", value)

    @property
    @pulumi.getter(name="onUpgrade")
    def on_upgrade(self) -> Optional[pulumi.Input[bool]]:
        """
        On upgrade flag.
        """
        return pulumi.get(self, "on_upgrade")

    @on_upgrade.setter
    def on_upgrade(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_upgrade", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Priority. `-2` Silent, `-1` Quiet, `0` Normal, `1` High, `2` Emergency, `8` High.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def retry(self) -> Optional[pulumi.Input[int]]:
        """
        Retry.
        """
        return pulumi.get(self, "retry")

    @retry.setter
    def retry(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retry", value)

    @property
    @pulumi.getter
    def sound(self) -> Optional[pulumi.Input[str]]:
        """
        Sound.
        """
        return pulumi.get(self, "sound")

    @sound.setter
    def sound(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sound", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        List of associated tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userKey")
    def user_key(self) -> Optional[pulumi.Input[str]]:
        """
        User key.
        """
        return pulumi.get(self, "user_key")

    @user_key.setter
    def user_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_key", value)


class Pushover(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[str]] = None,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 expire: Optional[pulumi.Input[int]] = None,
                 include_health_warnings: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 on_album_delete: Optional[pulumi.Input[bool]] = None,
                 on_application_update: Optional[pulumi.Input[bool]] = None,
                 on_artist_delete: Optional[pulumi.Input[bool]] = None,
                 on_download_failure: Optional[pulumi.Input[bool]] = None,
                 on_grab: Optional[pulumi.Input[bool]] = None,
                 on_health_issue: Optional[pulumi.Input[bool]] = None,
                 on_health_restored: Optional[pulumi.Input[bool]] = None,
                 on_import_failure: Optional[pulumi.Input[bool]] = None,
                 on_release_import: Optional[pulumi.Input[bool]] = None,
                 on_upgrade: Optional[pulumi.Input[bool]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 retry: Optional[pulumi.Input[int]] = None,
                 sound: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 user_key: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        <!-- subcategory:Notifications -->Notification Pushover resource.
        For more information refer to [Notification](https://wiki.servarr.com/lidarr/settings#connect) and [Pushover](https://wiki.servarr.com/lidarr/supported#pushover).

        ## Import

        import using the API/UI ID

        ```sh
         $ pulumi import lidarr:Notifications/pushover:Pushover example 1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] api_key: API key.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] devices: List of devices.
        :param pulumi.Input[int] expire: Expire.
        :param pulumi.Input[bool] include_health_warnings: Include health warnings.
        :param pulumi.Input[str] name: NotificationPushover name.
        :param pulumi.Input[bool] on_album_delete: On album delete flag.
        :param pulumi.Input[bool] on_application_update: On application update flag.
        :param pulumi.Input[bool] on_artist_delete: On artist delete flag.
        :param pulumi.Input[bool] on_download_failure: On download failure flag.
        :param pulumi.Input[bool] on_grab: On grab flag.
        :param pulumi.Input[bool] on_health_issue: On health issue flag.
        :param pulumi.Input[bool] on_health_restored: On health restored flag.
        :param pulumi.Input[bool] on_import_failure: On download flag.
        :param pulumi.Input[bool] on_release_import: On release import flag.
        :param pulumi.Input[bool] on_upgrade: On upgrade flag.
        :param pulumi.Input[int] priority: Priority. `-2` Silent, `-1` Quiet, `0` Normal, `1` High, `2` Emergency, `8` High.
        :param pulumi.Input[int] retry: Retry.
        :param pulumi.Input[str] sound: Sound.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        :param pulumi.Input[str] user_key: User key.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PushoverArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        <!-- subcategory:Notifications -->Notification Pushover resource.
        For more information refer to [Notification](https://wiki.servarr.com/lidarr/settings#connect) and [Pushover](https://wiki.servarr.com/lidarr/supported#pushover).

        ## Import

        import using the API/UI ID

        ```sh
         $ pulumi import lidarr:Notifications/pushover:Pushover example 1
        ```

        :param str resource_name: The name of the resource.
        :param PushoverArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PushoverArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[str]] = None,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 expire: Optional[pulumi.Input[int]] = None,
                 include_health_warnings: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 on_album_delete: Optional[pulumi.Input[bool]] = None,
                 on_application_update: Optional[pulumi.Input[bool]] = None,
                 on_artist_delete: Optional[pulumi.Input[bool]] = None,
                 on_download_failure: Optional[pulumi.Input[bool]] = None,
                 on_grab: Optional[pulumi.Input[bool]] = None,
                 on_health_issue: Optional[pulumi.Input[bool]] = None,
                 on_health_restored: Optional[pulumi.Input[bool]] = None,
                 on_import_failure: Optional[pulumi.Input[bool]] = None,
                 on_release_import: Optional[pulumi.Input[bool]] = None,
                 on_upgrade: Optional[pulumi.Input[bool]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 retry: Optional[pulumi.Input[int]] = None,
                 sound: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 user_key: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PushoverArgs.__new__(PushoverArgs)

            if api_key is None and not opts.urn:
                raise TypeError("Missing required property 'api_key'")
            __props__.__dict__["api_key"] = None if api_key is None else pulumi.Output.secret(api_key)
            __props__.__dict__["devices"] = devices
            __props__.__dict__["expire"] = expire
            __props__.__dict__["include_health_warnings"] = include_health_warnings
            __props__.__dict__["name"] = name
            __props__.__dict__["on_album_delete"] = on_album_delete
            __props__.__dict__["on_application_update"] = on_application_update
            __props__.__dict__["on_artist_delete"] = on_artist_delete
            __props__.__dict__["on_download_failure"] = on_download_failure
            __props__.__dict__["on_grab"] = on_grab
            __props__.__dict__["on_health_issue"] = on_health_issue
            __props__.__dict__["on_health_restored"] = on_health_restored
            __props__.__dict__["on_import_failure"] = on_import_failure
            __props__.__dict__["on_release_import"] = on_release_import
            __props__.__dict__["on_upgrade"] = on_upgrade
            __props__.__dict__["priority"] = priority
            __props__.__dict__["retry"] = retry
            __props__.__dict__["sound"] = sound
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_key"] = None if user_key is None else pulumi.Output.secret(user_key)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["apiKey", "userKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Pushover, __self__).__init__(
            'lidarr:Notifications/pushover:Pushover',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_key: Optional[pulumi.Input[str]] = None,
            devices: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            expire: Optional[pulumi.Input[int]] = None,
            include_health_warnings: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            on_album_delete: Optional[pulumi.Input[bool]] = None,
            on_application_update: Optional[pulumi.Input[bool]] = None,
            on_artist_delete: Optional[pulumi.Input[bool]] = None,
            on_download_failure: Optional[pulumi.Input[bool]] = None,
            on_grab: Optional[pulumi.Input[bool]] = None,
            on_health_issue: Optional[pulumi.Input[bool]] = None,
            on_health_restored: Optional[pulumi.Input[bool]] = None,
            on_import_failure: Optional[pulumi.Input[bool]] = None,
            on_release_import: Optional[pulumi.Input[bool]] = None,
            on_upgrade: Optional[pulumi.Input[bool]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            retry: Optional[pulumi.Input[int]] = None,
            sound: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            user_key: Optional[pulumi.Input[str]] = None) -> 'Pushover':
        """
        Get an existing Pushover resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] api_key: API key.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] devices: List of devices.
        :param pulumi.Input[int] expire: Expire.
        :param pulumi.Input[bool] include_health_warnings: Include health warnings.
        :param pulumi.Input[str] name: NotificationPushover name.
        :param pulumi.Input[bool] on_album_delete: On album delete flag.
        :param pulumi.Input[bool] on_application_update: On application update flag.
        :param pulumi.Input[bool] on_artist_delete: On artist delete flag.
        :param pulumi.Input[bool] on_download_failure: On download failure flag.
        :param pulumi.Input[bool] on_grab: On grab flag.
        :param pulumi.Input[bool] on_health_issue: On health issue flag.
        :param pulumi.Input[bool] on_health_restored: On health restored flag.
        :param pulumi.Input[bool] on_import_failure: On download flag.
        :param pulumi.Input[bool] on_release_import: On release import flag.
        :param pulumi.Input[bool] on_upgrade: On upgrade flag.
        :param pulumi.Input[int] priority: Priority. `-2` Silent, `-1` Quiet, `0` Normal, `1` High, `2` Emergency, `8` High.
        :param pulumi.Input[int] retry: Retry.
        :param pulumi.Input[str] sound: Sound.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        :param pulumi.Input[str] user_key: User key.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PushoverState.__new__(_PushoverState)

        __props__.__dict__["api_key"] = api_key
        __props__.__dict__["devices"] = devices
        __props__.__dict__["expire"] = expire
        __props__.__dict__["include_health_warnings"] = include_health_warnings
        __props__.__dict__["name"] = name
        __props__.__dict__["on_album_delete"] = on_album_delete
        __props__.__dict__["on_application_update"] = on_application_update
        __props__.__dict__["on_artist_delete"] = on_artist_delete
        __props__.__dict__["on_download_failure"] = on_download_failure
        __props__.__dict__["on_grab"] = on_grab
        __props__.__dict__["on_health_issue"] = on_health_issue
        __props__.__dict__["on_health_restored"] = on_health_restored
        __props__.__dict__["on_import_failure"] = on_import_failure
        __props__.__dict__["on_release_import"] = on_release_import
        __props__.__dict__["on_upgrade"] = on_upgrade
        __props__.__dict__["priority"] = priority
        __props__.__dict__["retry"] = retry
        __props__.__dict__["sound"] = sound
        __props__.__dict__["tags"] = tags
        __props__.__dict__["user_key"] = user_key
        return Pushover(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Output[str]:
        """
        API key.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter
    def devices(self) -> pulumi.Output[Sequence[str]]:
        """
        List of devices.
        """
        return pulumi.get(self, "devices")

    @property
    @pulumi.getter
    def expire(self) -> pulumi.Output[int]:
        """
        Expire.
        """
        return pulumi.get(self, "expire")

    @property
    @pulumi.getter(name="includeHealthWarnings")
    def include_health_warnings(self) -> pulumi.Output[bool]:
        """
        Include health warnings.
        """
        return pulumi.get(self, "include_health_warnings")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        NotificationPushover name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="onAlbumDelete")
    def on_album_delete(self) -> pulumi.Output[bool]:
        """
        On album delete flag.
        """
        return pulumi.get(self, "on_album_delete")

    @property
    @pulumi.getter(name="onApplicationUpdate")
    def on_application_update(self) -> pulumi.Output[bool]:
        """
        On application update flag.
        """
        return pulumi.get(self, "on_application_update")

    @property
    @pulumi.getter(name="onArtistDelete")
    def on_artist_delete(self) -> pulumi.Output[bool]:
        """
        On artist delete flag.
        """
        return pulumi.get(self, "on_artist_delete")

    @property
    @pulumi.getter(name="onDownloadFailure")
    def on_download_failure(self) -> pulumi.Output[bool]:
        """
        On download failure flag.
        """
        return pulumi.get(self, "on_download_failure")

    @property
    @pulumi.getter(name="onGrab")
    def on_grab(self) -> pulumi.Output[bool]:
        """
        On grab flag.
        """
        return pulumi.get(self, "on_grab")

    @property
    @pulumi.getter(name="onHealthIssue")
    def on_health_issue(self) -> pulumi.Output[bool]:
        """
        On health issue flag.
        """
        return pulumi.get(self, "on_health_issue")

    @property
    @pulumi.getter(name="onHealthRestored")
    def on_health_restored(self) -> pulumi.Output[bool]:
        """
        On health restored flag.
        """
        return pulumi.get(self, "on_health_restored")

    @property
    @pulumi.getter(name="onImportFailure")
    def on_import_failure(self) -> pulumi.Output[bool]:
        """
        On download flag.
        """
        return pulumi.get(self, "on_import_failure")

    @property
    @pulumi.getter(name="onReleaseImport")
    def on_release_import(self) -> pulumi.Output[bool]:
        """
        On release import flag.
        """
        return pulumi.get(self, "on_release_import")

    @property
    @pulumi.getter(name="onUpgrade")
    def on_upgrade(self) -> pulumi.Output[bool]:
        """
        On upgrade flag.
        """
        return pulumi.get(self, "on_upgrade")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[int]:
        """
        Priority. `-2` Silent, `-1` Quiet, `0` Normal, `1` High, `2` Emergency, `8` High.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def retry(self) -> pulumi.Output[int]:
        """
        Retry.
        """
        return pulumi.get(self, "retry")

    @property
    @pulumi.getter
    def sound(self) -> pulumi.Output[str]:
        """
        Sound.
        """
        return pulumi.get(self, "sound")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[int]]:
        """
        List of associated tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="userKey")
    def user_key(self) -> pulumi.Output[Optional[str]]:
        """
        User key.
        """
        return pulumi.get(self, "user_key")

