# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AppriseArgs', 'Apprise']

@pulumi.input_type
class AppriseArgs:
    def __init__(__self__, *,
                 server_url: pulumi.Input[str],
                 auth_password: Optional[pulumi.Input[str]] = None,
                 auth_username: Optional[pulumi.Input[str]] = None,
                 configuration_key: Optional[pulumi.Input[str]] = None,
                 field_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 include_health_warnings: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notification_type: Optional[pulumi.Input[int]] = None,
                 on_album_delete: Optional[pulumi.Input[bool]] = None,
                 on_application_update: Optional[pulumi.Input[bool]] = None,
                 on_artist_delete: Optional[pulumi.Input[bool]] = None,
                 on_download_failure: Optional[pulumi.Input[bool]] = None,
                 on_grab: Optional[pulumi.Input[bool]] = None,
                 on_health_issue: Optional[pulumi.Input[bool]] = None,
                 on_health_restored: Optional[pulumi.Input[bool]] = None,
                 on_import_failure: Optional[pulumi.Input[bool]] = None,
                 on_release_import: Optional[pulumi.Input[bool]] = None,
                 on_upgrade: Optional[pulumi.Input[bool]] = None,
                 stateless_urls: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None):
        """
        The set of arguments for constructing a Apprise resource.
        :param pulumi.Input[str] server_url: Server URL.
        :param pulumi.Input[str] auth_password: Password.
        :param pulumi.Input[str] auth_username: Username.
        :param pulumi.Input[str] configuration_key: Configuration key.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] field_tags: Tags and emojis.
        :param pulumi.Input[bool] include_health_warnings: Include health warnings.
        :param pulumi.Input[str] name: NotificationApprise name.
        :param pulumi.Input[int] notification_type: Notification type. `0` Info, `1` Success, `2` Warning, `3` Failure.
        :param pulumi.Input[bool] on_album_delete: On album delete flag.
        :param pulumi.Input[bool] on_application_update: On application update flag.
        :param pulumi.Input[bool] on_artist_delete: On artist delete flag.
        :param pulumi.Input[bool] on_download_failure: On download failure flag.
        :param pulumi.Input[bool] on_grab: On grab flag.
        :param pulumi.Input[bool] on_health_issue: On health issue flag.
        :param pulumi.Input[bool] on_health_restored: On health restored flag.
        :param pulumi.Input[bool] on_import_failure: On download flag.
        :param pulumi.Input[bool] on_release_import: On release import flag.
        :param pulumi.Input[bool] on_upgrade: On upgrade flag.
        :param pulumi.Input[str] stateless_urls: Stateless URLs.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        """
        pulumi.set(__self__, "server_url", server_url)
        if auth_password is not None:
            pulumi.set(__self__, "auth_password", auth_password)
        if auth_username is not None:
            pulumi.set(__self__, "auth_username", auth_username)
        if configuration_key is not None:
            pulumi.set(__self__, "configuration_key", configuration_key)
        if field_tags is not None:
            pulumi.set(__self__, "field_tags", field_tags)
        if include_health_warnings is not None:
            pulumi.set(__self__, "include_health_warnings", include_health_warnings)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_type is not None:
            pulumi.set(__self__, "notification_type", notification_type)
        if on_album_delete is not None:
            pulumi.set(__self__, "on_album_delete", on_album_delete)
        if on_application_update is not None:
            pulumi.set(__self__, "on_application_update", on_application_update)
        if on_artist_delete is not None:
            pulumi.set(__self__, "on_artist_delete", on_artist_delete)
        if on_download_failure is not None:
            pulumi.set(__self__, "on_download_failure", on_download_failure)
        if on_grab is not None:
            pulumi.set(__self__, "on_grab", on_grab)
        if on_health_issue is not None:
            pulumi.set(__self__, "on_health_issue", on_health_issue)
        if on_health_restored is not None:
            pulumi.set(__self__, "on_health_restored", on_health_restored)
        if on_import_failure is not None:
            pulumi.set(__self__, "on_import_failure", on_import_failure)
        if on_release_import is not None:
            pulumi.set(__self__, "on_release_import", on_release_import)
        if on_upgrade is not None:
            pulumi.set(__self__, "on_upgrade", on_upgrade)
        if stateless_urls is not None:
            pulumi.set(__self__, "stateless_urls", stateless_urls)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="serverUrl")
    def server_url(self) -> pulumi.Input[str]:
        """
        Server URL.
        """
        return pulumi.get(self, "server_url")

    @server_url.setter
    def server_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_url", value)

    @property
    @pulumi.getter(name="authPassword")
    def auth_password(self) -> Optional[pulumi.Input[str]]:
        """
        Password.
        """
        return pulumi.get(self, "auth_password")

    @auth_password.setter
    def auth_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_password", value)

    @property
    @pulumi.getter(name="authUsername")
    def auth_username(self) -> Optional[pulumi.Input[str]]:
        """
        Username.
        """
        return pulumi.get(self, "auth_username")

    @auth_username.setter
    def auth_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_username", value)

    @property
    @pulumi.getter(name="configurationKey")
    def configuration_key(self) -> Optional[pulumi.Input[str]]:
        """
        Configuration key.
        """
        return pulumi.get(self, "configuration_key")

    @configuration_key.setter
    def configuration_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_key", value)

    @property
    @pulumi.getter(name="fieldTags")
    def field_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags and emojis.
        """
        return pulumi.get(self, "field_tags")

    @field_tags.setter
    def field_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "field_tags", value)

    @property
    @pulumi.getter(name="includeHealthWarnings")
    def include_health_warnings(self) -> Optional[pulumi.Input[bool]]:
        """
        Include health warnings.
        """
        return pulumi.get(self, "include_health_warnings")

    @include_health_warnings.setter
    def include_health_warnings(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_health_warnings", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        NotificationApprise name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notificationType")
    def notification_type(self) -> Optional[pulumi.Input[int]]:
        """
        Notification type. `0` Info, `1` Success, `2` Warning, `3` Failure.
        """
        return pulumi.get(self, "notification_type")

    @notification_type.setter
    def notification_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "notification_type", value)

    @property
    @pulumi.getter(name="onAlbumDelete")
    def on_album_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        On album delete flag.
        """
        return pulumi.get(self, "on_album_delete")

    @on_album_delete.setter
    def on_album_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_album_delete", value)

    @property
    @pulumi.getter(name="onApplicationUpdate")
    def on_application_update(self) -> Optional[pulumi.Input[bool]]:
        """
        On application update flag.
        """
        return pulumi.get(self, "on_application_update")

    @on_application_update.setter
    def on_application_update(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_application_update", value)

    @property
    @pulumi.getter(name="onArtistDelete")
    def on_artist_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        On artist delete flag.
        """
        return pulumi.get(self, "on_artist_delete")

    @on_artist_delete.setter
    def on_artist_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_artist_delete", value)

    @property
    @pulumi.getter(name="onDownloadFailure")
    def on_download_failure(self) -> Optional[pulumi.Input[bool]]:
        """
        On download failure flag.
        """
        return pulumi.get(self, "on_download_failure")

    @on_download_failure.setter
    def on_download_failure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_download_failure", value)

    @property
    @pulumi.getter(name="onGrab")
    def on_grab(self) -> Optional[pulumi.Input[bool]]:
        """
        On grab flag.
        """
        return pulumi.get(self, "on_grab")

    @on_grab.setter
    def on_grab(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_grab", value)

    @property
    @pulumi.getter(name="onHealthIssue")
    def on_health_issue(self) -> Optional[pulumi.Input[bool]]:
        """
        On health issue flag.
        """
        return pulumi.get(self, "on_health_issue")

    @on_health_issue.setter
    def on_health_issue(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_health_issue", value)

    @property
    @pulumi.getter(name="onHealthRestored")
    def on_health_restored(self) -> Optional[pulumi.Input[bool]]:
        """
        On health restored flag.
        """
        return pulumi.get(self, "on_health_restored")

    @on_health_restored.setter
    def on_health_restored(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_health_restored", value)

    @property
    @pulumi.getter(name="onImportFailure")
    def on_import_failure(self) -> Optional[pulumi.Input[bool]]:
        """
        On download flag.
        """
        return pulumi.get(self, "on_import_failure")

    @on_import_failure.setter
    def on_import_failure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_import_failure", value)

    @property
    @pulumi.getter(name="onReleaseImport")
    def on_release_import(self) -> Optional[pulumi.Input[bool]]:
        """
        On release import flag.
        """
        return pulumi.get(self, "on_release_import")

    @on_release_import.setter
    def on_release_import(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_release_import", value)

    @property
    @pulumi.getter(name="onUpgrade")
    def on_upgrade(self) -> Optional[pulumi.Input[bool]]:
        """
        On upgrade flag.
        """
        return pulumi.get(self, "on_upgrade")

    @on_upgrade.setter
    def on_upgrade(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_upgrade", value)

    @property
    @pulumi.getter(name="statelessUrls")
    def stateless_urls(self) -> Optional[pulumi.Input[str]]:
        """
        Stateless URLs.
        """
        return pulumi.get(self, "stateless_urls")

    @stateless_urls.setter
    def stateless_urls(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stateless_urls", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        List of associated tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AppriseState:
    def __init__(__self__, *,
                 auth_password: Optional[pulumi.Input[str]] = None,
                 auth_username: Optional[pulumi.Input[str]] = None,
                 configuration_key: Optional[pulumi.Input[str]] = None,
                 field_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 include_health_warnings: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notification_type: Optional[pulumi.Input[int]] = None,
                 on_album_delete: Optional[pulumi.Input[bool]] = None,
                 on_application_update: Optional[pulumi.Input[bool]] = None,
                 on_artist_delete: Optional[pulumi.Input[bool]] = None,
                 on_download_failure: Optional[pulumi.Input[bool]] = None,
                 on_grab: Optional[pulumi.Input[bool]] = None,
                 on_health_issue: Optional[pulumi.Input[bool]] = None,
                 on_health_restored: Optional[pulumi.Input[bool]] = None,
                 on_import_failure: Optional[pulumi.Input[bool]] = None,
                 on_release_import: Optional[pulumi.Input[bool]] = None,
                 on_upgrade: Optional[pulumi.Input[bool]] = None,
                 server_url: Optional[pulumi.Input[str]] = None,
                 stateless_urls: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None):
        """
        Input properties used for looking up and filtering Apprise resources.
        :param pulumi.Input[str] auth_password: Password.
        :param pulumi.Input[str] auth_username: Username.
        :param pulumi.Input[str] configuration_key: Configuration key.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] field_tags: Tags and emojis.
        :param pulumi.Input[bool] include_health_warnings: Include health warnings.
        :param pulumi.Input[str] name: NotificationApprise name.
        :param pulumi.Input[int] notification_type: Notification type. `0` Info, `1` Success, `2` Warning, `3` Failure.
        :param pulumi.Input[bool] on_album_delete: On album delete flag.
        :param pulumi.Input[bool] on_application_update: On application update flag.
        :param pulumi.Input[bool] on_artist_delete: On artist delete flag.
        :param pulumi.Input[bool] on_download_failure: On download failure flag.
        :param pulumi.Input[bool] on_grab: On grab flag.
        :param pulumi.Input[bool] on_health_issue: On health issue flag.
        :param pulumi.Input[bool] on_health_restored: On health restored flag.
        :param pulumi.Input[bool] on_import_failure: On download flag.
        :param pulumi.Input[bool] on_release_import: On release import flag.
        :param pulumi.Input[bool] on_upgrade: On upgrade flag.
        :param pulumi.Input[str] server_url: Server URL.
        :param pulumi.Input[str] stateless_urls: Stateless URLs.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        """
        if auth_password is not None:
            pulumi.set(__self__, "auth_password", auth_password)
        if auth_username is not None:
            pulumi.set(__self__, "auth_username", auth_username)
        if configuration_key is not None:
            pulumi.set(__self__, "configuration_key", configuration_key)
        if field_tags is not None:
            pulumi.set(__self__, "field_tags", field_tags)
        if include_health_warnings is not None:
            pulumi.set(__self__, "include_health_warnings", include_health_warnings)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_type is not None:
            pulumi.set(__self__, "notification_type", notification_type)
        if on_album_delete is not None:
            pulumi.set(__self__, "on_album_delete", on_album_delete)
        if on_application_update is not None:
            pulumi.set(__self__, "on_application_update", on_application_update)
        if on_artist_delete is not None:
            pulumi.set(__self__, "on_artist_delete", on_artist_delete)
        if on_download_failure is not None:
            pulumi.set(__self__, "on_download_failure", on_download_failure)
        if on_grab is not None:
            pulumi.set(__self__, "on_grab", on_grab)
        if on_health_issue is not None:
            pulumi.set(__self__, "on_health_issue", on_health_issue)
        if on_health_restored is not None:
            pulumi.set(__self__, "on_health_restored", on_health_restored)
        if on_import_failure is not None:
            pulumi.set(__self__, "on_import_failure", on_import_failure)
        if on_release_import is not None:
            pulumi.set(__self__, "on_release_import", on_release_import)
        if on_upgrade is not None:
            pulumi.set(__self__, "on_upgrade", on_upgrade)
        if server_url is not None:
            pulumi.set(__self__, "server_url", server_url)
        if stateless_urls is not None:
            pulumi.set(__self__, "stateless_urls", stateless_urls)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="authPassword")
    def auth_password(self) -> Optional[pulumi.Input[str]]:
        """
        Password.
        """
        return pulumi.get(self, "auth_password")

    @auth_password.setter
    def auth_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_password", value)

    @property
    @pulumi.getter(name="authUsername")
    def auth_username(self) -> Optional[pulumi.Input[str]]:
        """
        Username.
        """
        return pulumi.get(self, "auth_username")

    @auth_username.setter
    def auth_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_username", value)

    @property
    @pulumi.getter(name="configurationKey")
    def configuration_key(self) -> Optional[pulumi.Input[str]]:
        """
        Configuration key.
        """
        return pulumi.get(self, "configuration_key")

    @configuration_key.setter
    def configuration_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_key", value)

    @property
    @pulumi.getter(name="fieldTags")
    def field_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags and emojis.
        """
        return pulumi.get(self, "field_tags")

    @field_tags.setter
    def field_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "field_tags", value)

    @property
    @pulumi.getter(name="includeHealthWarnings")
    def include_health_warnings(self) -> Optional[pulumi.Input[bool]]:
        """
        Include health warnings.
        """
        return pulumi.get(self, "include_health_warnings")

    @include_health_warnings.setter
    def include_health_warnings(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_health_warnings", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        NotificationApprise name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notificationType")
    def notification_type(self) -> Optional[pulumi.Input[int]]:
        """
        Notification type. `0` Info, `1` Success, `2` Warning, `3` Failure.
        """
        return pulumi.get(self, "notification_type")

    @notification_type.setter
    def notification_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "notification_type", value)

    @property
    @pulumi.getter(name="onAlbumDelete")
    def on_album_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        On album delete flag.
        """
        return pulumi.get(self, "on_album_delete")

    @on_album_delete.setter
    def on_album_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_album_delete", value)

    @property
    @pulumi.getter(name="onApplicationUpdate")
    def on_application_update(self) -> Optional[pulumi.Input[bool]]:
        """
        On application update flag.
        """
        return pulumi.get(self, "on_application_update")

    @on_application_update.setter
    def on_application_update(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_application_update", value)

    @property
    @pulumi.getter(name="onArtistDelete")
    def on_artist_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        On artist delete flag.
        """
        return pulumi.get(self, "on_artist_delete")

    @on_artist_delete.setter
    def on_artist_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_artist_delete", value)

    @property
    @pulumi.getter(name="onDownloadFailure")
    def on_download_failure(self) -> Optional[pulumi.Input[bool]]:
        """
        On download failure flag.
        """
        return pulumi.get(self, "on_download_failure")

    @on_download_failure.setter
    def on_download_failure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_download_failure", value)

    @property
    @pulumi.getter(name="onGrab")
    def on_grab(self) -> Optional[pulumi.Input[bool]]:
        """
        On grab flag.
        """
        return pulumi.get(self, "on_grab")

    @on_grab.setter
    def on_grab(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_grab", value)

    @property
    @pulumi.getter(name="onHealthIssue")
    def on_health_issue(self) -> Optional[pulumi.Input[bool]]:
        """
        On health issue flag.
        """
        return pulumi.get(self, "on_health_issue")

    @on_health_issue.setter
    def on_health_issue(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_health_issue", value)

    @property
    @pulumi.getter(name="onHealthRestored")
    def on_health_restored(self) -> Optional[pulumi.Input[bool]]:
        """
        On health restored flag.
        """
        return pulumi.get(self, "on_health_restored")

    @on_health_restored.setter
    def on_health_restored(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_health_restored", value)

    @property
    @pulumi.getter(name="onImportFailure")
    def on_import_failure(self) -> Optional[pulumi.Input[bool]]:
        """
        On download flag.
        """
        return pulumi.get(self, "on_import_failure")

    @on_import_failure.setter
    def on_import_failure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_import_failure", value)

    @property
    @pulumi.getter(name="onReleaseImport")
    def on_release_import(self) -> Optional[pulumi.Input[bool]]:
        """
        On release import flag.
        """
        return pulumi.get(self, "on_release_import")

    @on_release_import.setter
    def on_release_import(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_release_import", value)

    @property
    @pulumi.getter(name="onUpgrade")
    def on_upgrade(self) -> Optional[pulumi.Input[bool]]:
        """
        On upgrade flag.
        """
        return pulumi.get(self, "on_upgrade")

    @on_upgrade.setter
    def on_upgrade(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_upgrade", value)

    @property
    @pulumi.getter(name="serverUrl")
    def server_url(self) -> Optional[pulumi.Input[str]]:
        """
        Server URL.
        """
        return pulumi.get(self, "server_url")

    @server_url.setter
    def server_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_url", value)

    @property
    @pulumi.getter(name="statelessUrls")
    def stateless_urls(self) -> Optional[pulumi.Input[str]]:
        """
        Stateless URLs.
        """
        return pulumi.get(self, "stateless_urls")

    @stateless_urls.setter
    def stateless_urls(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stateless_urls", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        List of associated tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "tags", value)


class Apprise(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_password: Optional[pulumi.Input[str]] = None,
                 auth_username: Optional[pulumi.Input[str]] = None,
                 configuration_key: Optional[pulumi.Input[str]] = None,
                 field_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 include_health_warnings: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notification_type: Optional[pulumi.Input[int]] = None,
                 on_album_delete: Optional[pulumi.Input[bool]] = None,
                 on_application_update: Optional[pulumi.Input[bool]] = None,
                 on_artist_delete: Optional[pulumi.Input[bool]] = None,
                 on_download_failure: Optional[pulumi.Input[bool]] = None,
                 on_grab: Optional[pulumi.Input[bool]] = None,
                 on_health_issue: Optional[pulumi.Input[bool]] = None,
                 on_health_restored: Optional[pulumi.Input[bool]] = None,
                 on_import_failure: Optional[pulumi.Input[bool]] = None,
                 on_release_import: Optional[pulumi.Input[bool]] = None,
                 on_upgrade: Optional[pulumi.Input[bool]] = None,
                 server_url: Optional[pulumi.Input[str]] = None,
                 stateless_urls: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 __props__=None):
        """
        <!-- subcategory:Notifications -->Notification Apprise resource.
        For more information refer to [Notification](https://wiki.servarr.com/lidarr/settings#connect) and [Apprise](https://wiki.servarr.com/lidarr/supported#apprise).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.notifications.Apprise("example",
            auth_password="Password",
            auth_username="User",
            field_tags=[
                "warning",
                "skull",
            ],
            include_health_warnings=False,
            notification_type=1,
            on_application_update=False,
            on_download_failure=False,
            on_grab=False,
            on_health_issue=False,
            on_import_failure=True,
            on_release_import=True,
            on_upgrade=True,
            server_url="https://apprise.go")
        ```

        ## Import

        import using the API/UI ID

        ```sh
         $ pulumi import lidarr:Notifications/apprise:Apprise example 1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auth_password: Password.
        :param pulumi.Input[str] auth_username: Username.
        :param pulumi.Input[str] configuration_key: Configuration key.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] field_tags: Tags and emojis.
        :param pulumi.Input[bool] include_health_warnings: Include health warnings.
        :param pulumi.Input[str] name: NotificationApprise name.
        :param pulumi.Input[int] notification_type: Notification type. `0` Info, `1` Success, `2` Warning, `3` Failure.
        :param pulumi.Input[bool] on_album_delete: On album delete flag.
        :param pulumi.Input[bool] on_application_update: On application update flag.
        :param pulumi.Input[bool] on_artist_delete: On artist delete flag.
        :param pulumi.Input[bool] on_download_failure: On download failure flag.
        :param pulumi.Input[bool] on_grab: On grab flag.
        :param pulumi.Input[bool] on_health_issue: On health issue flag.
        :param pulumi.Input[bool] on_health_restored: On health restored flag.
        :param pulumi.Input[bool] on_import_failure: On download flag.
        :param pulumi.Input[bool] on_release_import: On release import flag.
        :param pulumi.Input[bool] on_upgrade: On upgrade flag.
        :param pulumi.Input[str] server_url: Server URL.
        :param pulumi.Input[str] stateless_urls: Stateless URLs.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppriseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        <!-- subcategory:Notifications -->Notification Apprise resource.
        For more information refer to [Notification](https://wiki.servarr.com/lidarr/settings#connect) and [Apprise](https://wiki.servarr.com/lidarr/supported#apprise).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.notifications.Apprise("example",
            auth_password="Password",
            auth_username="User",
            field_tags=[
                "warning",
                "skull",
            ],
            include_health_warnings=False,
            notification_type=1,
            on_application_update=False,
            on_download_failure=False,
            on_grab=False,
            on_health_issue=False,
            on_import_failure=True,
            on_release_import=True,
            on_upgrade=True,
            server_url="https://apprise.go")
        ```

        ## Import

        import using the API/UI ID

        ```sh
         $ pulumi import lidarr:Notifications/apprise:Apprise example 1
        ```

        :param str resource_name: The name of the resource.
        :param AppriseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppriseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_password: Optional[pulumi.Input[str]] = None,
                 auth_username: Optional[pulumi.Input[str]] = None,
                 configuration_key: Optional[pulumi.Input[str]] = None,
                 field_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 include_health_warnings: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notification_type: Optional[pulumi.Input[int]] = None,
                 on_album_delete: Optional[pulumi.Input[bool]] = None,
                 on_application_update: Optional[pulumi.Input[bool]] = None,
                 on_artist_delete: Optional[pulumi.Input[bool]] = None,
                 on_download_failure: Optional[pulumi.Input[bool]] = None,
                 on_grab: Optional[pulumi.Input[bool]] = None,
                 on_health_issue: Optional[pulumi.Input[bool]] = None,
                 on_health_restored: Optional[pulumi.Input[bool]] = None,
                 on_import_failure: Optional[pulumi.Input[bool]] = None,
                 on_release_import: Optional[pulumi.Input[bool]] = None,
                 on_upgrade: Optional[pulumi.Input[bool]] = None,
                 server_url: Optional[pulumi.Input[str]] = None,
                 stateless_urls: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppriseArgs.__new__(AppriseArgs)

            __props__.__dict__["auth_password"] = None if auth_password is None else pulumi.Output.secret(auth_password)
            __props__.__dict__["auth_username"] = auth_username
            __props__.__dict__["configuration_key"] = None if configuration_key is None else pulumi.Output.secret(configuration_key)
            __props__.__dict__["field_tags"] = field_tags
            __props__.__dict__["include_health_warnings"] = include_health_warnings
            __props__.__dict__["name"] = name
            __props__.__dict__["notification_type"] = notification_type
            __props__.__dict__["on_album_delete"] = on_album_delete
            __props__.__dict__["on_application_update"] = on_application_update
            __props__.__dict__["on_artist_delete"] = on_artist_delete
            __props__.__dict__["on_download_failure"] = on_download_failure
            __props__.__dict__["on_grab"] = on_grab
            __props__.__dict__["on_health_issue"] = on_health_issue
            __props__.__dict__["on_health_restored"] = on_health_restored
            __props__.__dict__["on_import_failure"] = on_import_failure
            __props__.__dict__["on_release_import"] = on_release_import
            __props__.__dict__["on_upgrade"] = on_upgrade
            if server_url is None and not opts.urn:
                raise TypeError("Missing required property 'server_url'")
            __props__.__dict__["server_url"] = server_url
            __props__.__dict__["stateless_urls"] = stateless_urls
            __props__.__dict__["tags"] = tags
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["authPassword", "configurationKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Apprise, __self__).__init__(
            'lidarr:Notifications/apprise:Apprise',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auth_password: Optional[pulumi.Input[str]] = None,
            auth_username: Optional[pulumi.Input[str]] = None,
            configuration_key: Optional[pulumi.Input[str]] = None,
            field_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            include_health_warnings: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            notification_type: Optional[pulumi.Input[int]] = None,
            on_album_delete: Optional[pulumi.Input[bool]] = None,
            on_application_update: Optional[pulumi.Input[bool]] = None,
            on_artist_delete: Optional[pulumi.Input[bool]] = None,
            on_download_failure: Optional[pulumi.Input[bool]] = None,
            on_grab: Optional[pulumi.Input[bool]] = None,
            on_health_issue: Optional[pulumi.Input[bool]] = None,
            on_health_restored: Optional[pulumi.Input[bool]] = None,
            on_import_failure: Optional[pulumi.Input[bool]] = None,
            on_release_import: Optional[pulumi.Input[bool]] = None,
            on_upgrade: Optional[pulumi.Input[bool]] = None,
            server_url: Optional[pulumi.Input[str]] = None,
            stateless_urls: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None) -> 'Apprise':
        """
        Get an existing Apprise resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auth_password: Password.
        :param pulumi.Input[str] auth_username: Username.
        :param pulumi.Input[str] configuration_key: Configuration key.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] field_tags: Tags and emojis.
        :param pulumi.Input[bool] include_health_warnings: Include health warnings.
        :param pulumi.Input[str] name: NotificationApprise name.
        :param pulumi.Input[int] notification_type: Notification type. `0` Info, `1` Success, `2` Warning, `3` Failure.
        :param pulumi.Input[bool] on_album_delete: On album delete flag.
        :param pulumi.Input[bool] on_application_update: On application update flag.
        :param pulumi.Input[bool] on_artist_delete: On artist delete flag.
        :param pulumi.Input[bool] on_download_failure: On download failure flag.
        :param pulumi.Input[bool] on_grab: On grab flag.
        :param pulumi.Input[bool] on_health_issue: On health issue flag.
        :param pulumi.Input[bool] on_health_restored: On health restored flag.
        :param pulumi.Input[bool] on_import_failure: On download flag.
        :param pulumi.Input[bool] on_release_import: On release import flag.
        :param pulumi.Input[bool] on_upgrade: On upgrade flag.
        :param pulumi.Input[str] server_url: Server URL.
        :param pulumi.Input[str] stateless_urls: Stateless URLs.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppriseState.__new__(_AppriseState)

        __props__.__dict__["auth_password"] = auth_password
        __props__.__dict__["auth_username"] = auth_username
        __props__.__dict__["configuration_key"] = configuration_key
        __props__.__dict__["field_tags"] = field_tags
        __props__.__dict__["include_health_warnings"] = include_health_warnings
        __props__.__dict__["name"] = name
        __props__.__dict__["notification_type"] = notification_type
        __props__.__dict__["on_album_delete"] = on_album_delete
        __props__.__dict__["on_application_update"] = on_application_update
        __props__.__dict__["on_artist_delete"] = on_artist_delete
        __props__.__dict__["on_download_failure"] = on_download_failure
        __props__.__dict__["on_grab"] = on_grab
        __props__.__dict__["on_health_issue"] = on_health_issue
        __props__.__dict__["on_health_restored"] = on_health_restored
        __props__.__dict__["on_import_failure"] = on_import_failure
        __props__.__dict__["on_release_import"] = on_release_import
        __props__.__dict__["on_upgrade"] = on_upgrade
        __props__.__dict__["server_url"] = server_url
        __props__.__dict__["stateless_urls"] = stateless_urls
        __props__.__dict__["tags"] = tags
        return Apprise(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authPassword")
    def auth_password(self) -> pulumi.Output[str]:
        """
        Password.
        """
        return pulumi.get(self, "auth_password")

    @property
    @pulumi.getter(name="authUsername")
    def auth_username(self) -> pulumi.Output[str]:
        """
        Username.
        """
        return pulumi.get(self, "auth_username")

    @property
    @pulumi.getter(name="configurationKey")
    def configuration_key(self) -> pulumi.Output[str]:
        """
        Configuration key.
        """
        return pulumi.get(self, "configuration_key")

    @property
    @pulumi.getter(name="fieldTags")
    def field_tags(self) -> pulumi.Output[Sequence[str]]:
        """
        Tags and emojis.
        """
        return pulumi.get(self, "field_tags")

    @property
    @pulumi.getter(name="includeHealthWarnings")
    def include_health_warnings(self) -> pulumi.Output[bool]:
        """
        Include health warnings.
        """
        return pulumi.get(self, "include_health_warnings")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        NotificationApprise name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notificationType")
    def notification_type(self) -> pulumi.Output[int]:
        """
        Notification type. `0` Info, `1` Success, `2` Warning, `3` Failure.
        """
        return pulumi.get(self, "notification_type")

    @property
    @pulumi.getter(name="onAlbumDelete")
    def on_album_delete(self) -> pulumi.Output[bool]:
        """
        On album delete flag.
        """
        return pulumi.get(self, "on_album_delete")

    @property
    @pulumi.getter(name="onApplicationUpdate")
    def on_application_update(self) -> pulumi.Output[bool]:
        """
        On application update flag.
        """
        return pulumi.get(self, "on_application_update")

    @property
    @pulumi.getter(name="onArtistDelete")
    def on_artist_delete(self) -> pulumi.Output[bool]:
        """
        On artist delete flag.
        """
        return pulumi.get(self, "on_artist_delete")

    @property
    @pulumi.getter(name="onDownloadFailure")
    def on_download_failure(self) -> pulumi.Output[bool]:
        """
        On download failure flag.
        """
        return pulumi.get(self, "on_download_failure")

    @property
    @pulumi.getter(name="onGrab")
    def on_grab(self) -> pulumi.Output[bool]:
        """
        On grab flag.
        """
        return pulumi.get(self, "on_grab")

    @property
    @pulumi.getter(name="onHealthIssue")
    def on_health_issue(self) -> pulumi.Output[bool]:
        """
        On health issue flag.
        """
        return pulumi.get(self, "on_health_issue")

    @property
    @pulumi.getter(name="onHealthRestored")
    def on_health_restored(self) -> pulumi.Output[bool]:
        """
        On health restored flag.
        """
        return pulumi.get(self, "on_health_restored")

    @property
    @pulumi.getter(name="onImportFailure")
    def on_import_failure(self) -> pulumi.Output[bool]:
        """
        On download flag.
        """
        return pulumi.get(self, "on_import_failure")

    @property
    @pulumi.getter(name="onReleaseImport")
    def on_release_import(self) -> pulumi.Output[bool]:
        """
        On release import flag.
        """
        return pulumi.get(self, "on_release_import")

    @property
    @pulumi.getter(name="onUpgrade")
    def on_upgrade(self) -> pulumi.Output[bool]:
        """
        On upgrade flag.
        """
        return pulumi.get(self, "on_upgrade")

    @property
    @pulumi.getter(name="serverUrl")
    def server_url(self) -> pulumi.Output[str]:
        """
        Server URL.
        """
        return pulumi.get(self, "server_url")

    @property
    @pulumi.getter(name="statelessUrls")
    def stateless_urls(self) -> pulumi.Output[str]:
        """
        Stateless URLs.
        """
        return pulumi.get(self, "stateless_urls")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[int]]:
        """
        List of associated tags.
        """
        return pulumi.get(self, "tags")

