# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ConfigArgs', 'Config']

@pulumi.input_type
class ConfigArgs:
    def __init__(__self__, *,
                 scrub_audio_tags: pulumi.Input[bool],
                 write_audio_tags: pulumi.Input[str],
                 metadata_source: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Config resource.
        :param pulumi.Input[bool] scrub_audio_tags: Scrub audio tags.
        :param pulumi.Input[str] write_audio_tags: Write audio tags.
        :param pulumi.Input[str] metadata_source: Metadata Source.
        """
        pulumi.set(__self__, "scrub_audio_tags", scrub_audio_tags)
        pulumi.set(__self__, "write_audio_tags", write_audio_tags)
        if metadata_source is not None:
            pulumi.set(__self__, "metadata_source", metadata_source)

    @property
    @pulumi.getter(name="scrubAudioTags")
    def scrub_audio_tags(self) -> pulumi.Input[bool]:
        """
        Scrub audio tags.
        """
        return pulumi.get(self, "scrub_audio_tags")

    @scrub_audio_tags.setter
    def scrub_audio_tags(self, value: pulumi.Input[bool]):
        pulumi.set(self, "scrub_audio_tags", value)

    @property
    @pulumi.getter(name="writeAudioTags")
    def write_audio_tags(self) -> pulumi.Input[str]:
        """
        Write audio tags.
        """
        return pulumi.get(self, "write_audio_tags")

    @write_audio_tags.setter
    def write_audio_tags(self, value: pulumi.Input[str]):
        pulumi.set(self, "write_audio_tags", value)

    @property
    @pulumi.getter(name="metadataSource")
    def metadata_source(self) -> Optional[pulumi.Input[str]]:
        """
        Metadata Source.
        """
        return pulumi.get(self, "metadata_source")

    @metadata_source.setter
    def metadata_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata_source", value)


@pulumi.input_type
class _ConfigState:
    def __init__(__self__, *,
                 metadata_source: Optional[pulumi.Input[str]] = None,
                 scrub_audio_tags: Optional[pulumi.Input[bool]] = None,
                 write_audio_tags: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Config resources.
        :param pulumi.Input[str] metadata_source: Metadata Source.
        :param pulumi.Input[bool] scrub_audio_tags: Scrub audio tags.
        :param pulumi.Input[str] write_audio_tags: Write audio tags.
        """
        if metadata_source is not None:
            pulumi.set(__self__, "metadata_source", metadata_source)
        if scrub_audio_tags is not None:
            pulumi.set(__self__, "scrub_audio_tags", scrub_audio_tags)
        if write_audio_tags is not None:
            pulumi.set(__self__, "write_audio_tags", write_audio_tags)

    @property
    @pulumi.getter(name="metadataSource")
    def metadata_source(self) -> Optional[pulumi.Input[str]]:
        """
        Metadata Source.
        """
        return pulumi.get(self, "metadata_source")

    @metadata_source.setter
    def metadata_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata_source", value)

    @property
    @pulumi.getter(name="scrubAudioTags")
    def scrub_audio_tags(self) -> Optional[pulumi.Input[bool]]:
        """
        Scrub audio tags.
        """
        return pulumi.get(self, "scrub_audio_tags")

    @scrub_audio_tags.setter
    def scrub_audio_tags(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "scrub_audio_tags", value)

    @property
    @pulumi.getter(name="writeAudioTags")
    def write_audio_tags(self) -> Optional[pulumi.Input[str]]:
        """
        Write audio tags.
        """
        return pulumi.get(self, "write_audio_tags")

    @write_audio_tags.setter
    def write_audio_tags(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "write_audio_tags", value)


class Config(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 metadata_source: Optional[pulumi.Input[str]] = None,
                 scrub_audio_tags: Optional[pulumi.Input[bool]] = None,
                 write_audio_tags: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        <!-- subcategory:Metadata -->Metadata Config resource.
        For more information refer to [Metadata](https://wiki.servarr.com/lidarr/settings#options) documentation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.metadata.Config("example",
            scrub_audio_tags=False,
            write_audio_tags="no")
        ```

        ## Import

        import does not need parameters

        ```sh
         $ pulumi import lidarr:Metadata/config:Config example ""
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] metadata_source: Metadata Source.
        :param pulumi.Input[bool] scrub_audio_tags: Scrub audio tags.
        :param pulumi.Input[str] write_audio_tags: Write audio tags.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        <!-- subcategory:Metadata -->Metadata Config resource.
        For more information refer to [Metadata](https://wiki.servarr.com/lidarr/settings#options) documentation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.metadata.Config("example",
            scrub_audio_tags=False,
            write_audio_tags="no")
        ```

        ## Import

        import does not need parameters

        ```sh
         $ pulumi import lidarr:Metadata/config:Config example ""
        ```

        :param str resource_name: The name of the resource.
        :param ConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 metadata_source: Optional[pulumi.Input[str]] = None,
                 scrub_audio_tags: Optional[pulumi.Input[bool]] = None,
                 write_audio_tags: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConfigArgs.__new__(ConfigArgs)

            __props__.__dict__["metadata_source"] = metadata_source
            if scrub_audio_tags is None and not opts.urn:
                raise TypeError("Missing required property 'scrub_audio_tags'")
            __props__.__dict__["scrub_audio_tags"] = scrub_audio_tags
            if write_audio_tags is None and not opts.urn:
                raise TypeError("Missing required property 'write_audio_tags'")
            __props__.__dict__["write_audio_tags"] = write_audio_tags
        super(Config, __self__).__init__(
            'lidarr:Metadata/config:Config',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            metadata_source: Optional[pulumi.Input[str]] = None,
            scrub_audio_tags: Optional[pulumi.Input[bool]] = None,
            write_audio_tags: Optional[pulumi.Input[str]] = None) -> 'Config':
        """
        Get an existing Config resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] metadata_source: Metadata Source.
        :param pulumi.Input[bool] scrub_audio_tags: Scrub audio tags.
        :param pulumi.Input[str] write_audio_tags: Write audio tags.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConfigState.__new__(_ConfigState)

        __props__.__dict__["metadata_source"] = metadata_source
        __props__.__dict__["scrub_audio_tags"] = scrub_audio_tags
        __props__.__dict__["write_audio_tags"] = write_audio_tags
        return Config(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="metadataSource")
    def metadata_source(self) -> pulumi.Output[str]:
        """
        Metadata Source.
        """
        return pulumi.get(self, "metadata_source")

    @property
    @pulumi.getter(name="scrubAudioTags")
    def scrub_audio_tags(self) -> pulumi.Output[bool]:
        """
        Scrub audio tags.
        """
        return pulumi.get(self, "scrub_audio_tags")

    @property
    @pulumi.getter(name="writeAudioTags")
    def write_audio_tags(self) -> pulumi.Output[str]:
        """
        Write audio tags.
        """
        return pulumi.get(self, "write_audio_tags")

