# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['RootFolderArgs', 'RootFolder']

@pulumi.input_type
class RootFolderArgs:
    def __init__(__self__, *,
                 metadata_profile_id: pulumi.Input[int],
                 monitor_option: pulumi.Input[str],
                 new_item_monitor_option: pulumi.Input[str],
                 path: pulumi.Input[str],
                 quality_profile_id: pulumi.Input[int],
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None):
        """
        The set of arguments for constructing a RootFolder resource.
        :param pulumi.Input[int] metadata_profile_id: Metadata profile ID.
        :param pulumi.Input[str] monitor_option: Monitor option.
        :param pulumi.Input[str] new_item_monitor_option: New item monitor option.
        :param pulumi.Input[str] path: Root Folder absolute path.
        :param pulumi.Input[int] quality_profile_id: Quality profile ID.
        :param pulumi.Input[str] name: Root Folder friendly name.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        """
        pulumi.set(__self__, "metadata_profile_id", metadata_profile_id)
        pulumi.set(__self__, "monitor_option", monitor_option)
        pulumi.set(__self__, "new_item_monitor_option", new_item_monitor_option)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "quality_profile_id", quality_profile_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="metadataProfileId")
    def metadata_profile_id(self) -> pulumi.Input[int]:
        """
        Metadata profile ID.
        """
        return pulumi.get(self, "metadata_profile_id")

    @metadata_profile_id.setter
    def metadata_profile_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "metadata_profile_id", value)

    @property
    @pulumi.getter(name="monitorOption")
    def monitor_option(self) -> pulumi.Input[str]:
        """
        Monitor option.
        """
        return pulumi.get(self, "monitor_option")

    @monitor_option.setter
    def monitor_option(self, value: pulumi.Input[str]):
        pulumi.set(self, "monitor_option", value)

    @property
    @pulumi.getter(name="newItemMonitorOption")
    def new_item_monitor_option(self) -> pulumi.Input[str]:
        """
        New item monitor option.
        """
        return pulumi.get(self, "new_item_monitor_option")

    @new_item_monitor_option.setter
    def new_item_monitor_option(self, value: pulumi.Input[str]):
        pulumi.set(self, "new_item_monitor_option", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        Root Folder absolute path.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="qualityProfileId")
    def quality_profile_id(self) -> pulumi.Input[int]:
        """
        Quality profile ID.
        """
        return pulumi.get(self, "quality_profile_id")

    @quality_profile_id.setter
    def quality_profile_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "quality_profile_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Root Folder friendly name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        List of associated tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _RootFolderState:
    def __init__(__self__, *,
                 accessible: Optional[pulumi.Input[bool]] = None,
                 metadata_profile_id: Optional[pulumi.Input[int]] = None,
                 monitor_option: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 new_item_monitor_option: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 quality_profile_id: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None):
        """
        Input properties used for looking up and filtering RootFolder resources.
        :param pulumi.Input[bool] accessible: Access flag.
        :param pulumi.Input[int] metadata_profile_id: Metadata profile ID.
        :param pulumi.Input[str] monitor_option: Monitor option.
        :param pulumi.Input[str] name: Root Folder friendly name.
        :param pulumi.Input[str] new_item_monitor_option: New item monitor option.
        :param pulumi.Input[str] path: Root Folder absolute path.
        :param pulumi.Input[int] quality_profile_id: Quality profile ID.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        """
        if accessible is not None:
            pulumi.set(__self__, "accessible", accessible)
        if metadata_profile_id is not None:
            pulumi.set(__self__, "metadata_profile_id", metadata_profile_id)
        if monitor_option is not None:
            pulumi.set(__self__, "monitor_option", monitor_option)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if new_item_monitor_option is not None:
            pulumi.set(__self__, "new_item_monitor_option", new_item_monitor_option)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if quality_profile_id is not None:
            pulumi.set(__self__, "quality_profile_id", quality_profile_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def accessible(self) -> Optional[pulumi.Input[bool]]:
        """
        Access flag.
        """
        return pulumi.get(self, "accessible")

    @accessible.setter
    def accessible(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "accessible", value)

    @property
    @pulumi.getter(name="metadataProfileId")
    def metadata_profile_id(self) -> Optional[pulumi.Input[int]]:
        """
        Metadata profile ID.
        """
        return pulumi.get(self, "metadata_profile_id")

    @metadata_profile_id.setter
    def metadata_profile_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "metadata_profile_id", value)

    @property
    @pulumi.getter(name="monitorOption")
    def monitor_option(self) -> Optional[pulumi.Input[str]]:
        """
        Monitor option.
        """
        return pulumi.get(self, "monitor_option")

    @monitor_option.setter
    def monitor_option(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "monitor_option", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Root Folder friendly name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="newItemMonitorOption")
    def new_item_monitor_option(self) -> Optional[pulumi.Input[str]]:
        """
        New item monitor option.
        """
        return pulumi.get(self, "new_item_monitor_option")

    @new_item_monitor_option.setter
    def new_item_monitor_option(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "new_item_monitor_option", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Root Folder absolute path.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="qualityProfileId")
    def quality_profile_id(self) -> Optional[pulumi.Input[int]]:
        """
        Quality profile ID.
        """
        return pulumi.get(self, "quality_profile_id")

    @quality_profile_id.setter
    def quality_profile_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "quality_profile_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        List of associated tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "tags", value)


class RootFolder(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 metadata_profile_id: Optional[pulumi.Input[int]] = None,
                 monitor_option: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 new_item_monitor_option: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 quality_profile_id: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 __props__=None):
        """
        <!-- subcategory:Media Management -->Root Folder resource.
        For more information refer to [Root Folders](https://wiki.servarr.com/lidarr/settings#root-folders) documentation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.media_management.RootFolder("example",
            metadata_profile_id=1,
            monitor_option="future",
            new_item_monitor_option="all",
            path="/music",
            quality_profile_id=1,
            tags=[1])
        ```

        ## Import

        import using the API/UI ID

        ```sh
         $ pulumi import lidarr:MediaManagement/rootFolder:RootFolder example 10
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] metadata_profile_id: Metadata profile ID.
        :param pulumi.Input[str] monitor_option: Monitor option.
        :param pulumi.Input[str] name: Root Folder friendly name.
        :param pulumi.Input[str] new_item_monitor_option: New item monitor option.
        :param pulumi.Input[str] path: Root Folder absolute path.
        :param pulumi.Input[int] quality_profile_id: Quality profile ID.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RootFolderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        <!-- subcategory:Media Management -->Root Folder resource.
        For more information refer to [Root Folders](https://wiki.servarr.com/lidarr/settings#root-folders) documentation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.media_management.RootFolder("example",
            metadata_profile_id=1,
            monitor_option="future",
            new_item_monitor_option="all",
            path="/music",
            quality_profile_id=1,
            tags=[1])
        ```

        ## Import

        import using the API/UI ID

        ```sh
         $ pulumi import lidarr:MediaManagement/rootFolder:RootFolder example 10
        ```

        :param str resource_name: The name of the resource.
        :param RootFolderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RootFolderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 metadata_profile_id: Optional[pulumi.Input[int]] = None,
                 monitor_option: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 new_item_monitor_option: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 quality_profile_id: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RootFolderArgs.__new__(RootFolderArgs)

            if metadata_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'metadata_profile_id'")
            __props__.__dict__["metadata_profile_id"] = metadata_profile_id
            if monitor_option is None and not opts.urn:
                raise TypeError("Missing required property 'monitor_option'")
            __props__.__dict__["monitor_option"] = monitor_option
            __props__.__dict__["name"] = name
            if new_item_monitor_option is None and not opts.urn:
                raise TypeError("Missing required property 'new_item_monitor_option'")
            __props__.__dict__["new_item_monitor_option"] = new_item_monitor_option
            if path is None and not opts.urn:
                raise TypeError("Missing required property 'path'")
            __props__.__dict__["path"] = path
            if quality_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'quality_profile_id'")
            __props__.__dict__["quality_profile_id"] = quality_profile_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["accessible"] = None
        super(RootFolder, __self__).__init__(
            'lidarr:MediaManagement/rootFolder:RootFolder',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accessible: Optional[pulumi.Input[bool]] = None,
            metadata_profile_id: Optional[pulumi.Input[int]] = None,
            monitor_option: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            new_item_monitor_option: Optional[pulumi.Input[str]] = None,
            path: Optional[pulumi.Input[str]] = None,
            quality_profile_id: Optional[pulumi.Input[int]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None) -> 'RootFolder':
        """
        Get an existing RootFolder resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] accessible: Access flag.
        :param pulumi.Input[int] metadata_profile_id: Metadata profile ID.
        :param pulumi.Input[str] monitor_option: Monitor option.
        :param pulumi.Input[str] name: Root Folder friendly name.
        :param pulumi.Input[str] new_item_monitor_option: New item monitor option.
        :param pulumi.Input[str] path: Root Folder absolute path.
        :param pulumi.Input[int] quality_profile_id: Quality profile ID.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RootFolderState.__new__(_RootFolderState)

        __props__.__dict__["accessible"] = accessible
        __props__.__dict__["metadata_profile_id"] = metadata_profile_id
        __props__.__dict__["monitor_option"] = monitor_option
        __props__.__dict__["name"] = name
        __props__.__dict__["new_item_monitor_option"] = new_item_monitor_option
        __props__.__dict__["path"] = path
        __props__.__dict__["quality_profile_id"] = quality_profile_id
        __props__.__dict__["tags"] = tags
        return RootFolder(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def accessible(self) -> pulumi.Output[bool]:
        """
        Access flag.
        """
        return pulumi.get(self, "accessible")

    @property
    @pulumi.getter(name="metadataProfileId")
    def metadata_profile_id(self) -> pulumi.Output[int]:
        """
        Metadata profile ID.
        """
        return pulumi.get(self, "metadata_profile_id")

    @property
    @pulumi.getter(name="monitorOption")
    def monitor_option(self) -> pulumi.Output[str]:
        """
        Monitor option.
        """
        return pulumi.get(self, "monitor_option")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Root Folder friendly name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="newItemMonitorOption")
    def new_item_monitor_option(self) -> pulumi.Output[str]:
        """
        New item monitor option.
        """
        return pulumi.get(self, "new_item_monitor_option")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[str]:
        """
        Root Folder absolute path.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="qualityProfileId")
    def quality_profile_id(self) -> pulumi.Output[int]:
        """
        Quality profile ID.
        """
        return pulumi.get(self, "quality_profile_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[int]]:
        """
        List of associated tags.
        """
        return pulumi.get(self, "tags")

