# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['NamingArgs', 'Naming']

@pulumi.input_type
class NamingArgs:
    def __init__(__self__, *,
                 artist_folder_format: pulumi.Input[str],
                 multi_disc_track_format: pulumi.Input[str],
                 rename_tracks: pulumi.Input[bool],
                 replace_illegal_characters: pulumi.Input[bool],
                 standard_track_format: pulumi.Input[str]):
        """
        The set of arguments for constructing a Naming resource.
        :param pulumi.Input[str] artist_folder_format: Artist folder format.
        :param pulumi.Input[str] multi_disc_track_format: Multi disc track format.
        :param pulumi.Input[bool] rename_tracks: Lidarr will use the existing file name if false.
        :param pulumi.Input[bool] replace_illegal_characters: Replace illegal characters. They will be removed if false.
        :param pulumi.Input[str] standard_track_format: Standard track formatss.
        """
        pulumi.set(__self__, "artist_folder_format", artist_folder_format)
        pulumi.set(__self__, "multi_disc_track_format", multi_disc_track_format)
        pulumi.set(__self__, "rename_tracks", rename_tracks)
        pulumi.set(__self__, "replace_illegal_characters", replace_illegal_characters)
        pulumi.set(__self__, "standard_track_format", standard_track_format)

    @property
    @pulumi.getter(name="artistFolderFormat")
    def artist_folder_format(self) -> pulumi.Input[str]:
        """
        Artist folder format.
        """
        return pulumi.get(self, "artist_folder_format")

    @artist_folder_format.setter
    def artist_folder_format(self, value: pulumi.Input[str]):
        pulumi.set(self, "artist_folder_format", value)

    @property
    @pulumi.getter(name="multiDiscTrackFormat")
    def multi_disc_track_format(self) -> pulumi.Input[str]:
        """
        Multi disc track format.
        """
        return pulumi.get(self, "multi_disc_track_format")

    @multi_disc_track_format.setter
    def multi_disc_track_format(self, value: pulumi.Input[str]):
        pulumi.set(self, "multi_disc_track_format", value)

    @property
    @pulumi.getter(name="renameTracks")
    def rename_tracks(self) -> pulumi.Input[bool]:
        """
        Lidarr will use the existing file name if false.
        """
        return pulumi.get(self, "rename_tracks")

    @rename_tracks.setter
    def rename_tracks(self, value: pulumi.Input[bool]):
        pulumi.set(self, "rename_tracks", value)

    @property
    @pulumi.getter(name="replaceIllegalCharacters")
    def replace_illegal_characters(self) -> pulumi.Input[bool]:
        """
        Replace illegal characters. They will be removed if false.
        """
        return pulumi.get(self, "replace_illegal_characters")

    @replace_illegal_characters.setter
    def replace_illegal_characters(self, value: pulumi.Input[bool]):
        pulumi.set(self, "replace_illegal_characters", value)

    @property
    @pulumi.getter(name="standardTrackFormat")
    def standard_track_format(self) -> pulumi.Input[str]:
        """
        Standard track formatss.
        """
        return pulumi.get(self, "standard_track_format")

    @standard_track_format.setter
    def standard_track_format(self, value: pulumi.Input[str]):
        pulumi.set(self, "standard_track_format", value)


@pulumi.input_type
class _NamingState:
    def __init__(__self__, *,
                 artist_folder_format: Optional[pulumi.Input[str]] = None,
                 multi_disc_track_format: Optional[pulumi.Input[str]] = None,
                 rename_tracks: Optional[pulumi.Input[bool]] = None,
                 replace_illegal_characters: Optional[pulumi.Input[bool]] = None,
                 standard_track_format: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Naming resources.
        :param pulumi.Input[str] artist_folder_format: Artist folder format.
        :param pulumi.Input[str] multi_disc_track_format: Multi disc track format.
        :param pulumi.Input[bool] rename_tracks: Lidarr will use the existing file name if false.
        :param pulumi.Input[bool] replace_illegal_characters: Replace illegal characters. They will be removed if false.
        :param pulumi.Input[str] standard_track_format: Standard track formatss.
        """
        if artist_folder_format is not None:
            pulumi.set(__self__, "artist_folder_format", artist_folder_format)
        if multi_disc_track_format is not None:
            pulumi.set(__self__, "multi_disc_track_format", multi_disc_track_format)
        if rename_tracks is not None:
            pulumi.set(__self__, "rename_tracks", rename_tracks)
        if replace_illegal_characters is not None:
            pulumi.set(__self__, "replace_illegal_characters", replace_illegal_characters)
        if standard_track_format is not None:
            pulumi.set(__self__, "standard_track_format", standard_track_format)

    @property
    @pulumi.getter(name="artistFolderFormat")
    def artist_folder_format(self) -> Optional[pulumi.Input[str]]:
        """
        Artist folder format.
        """
        return pulumi.get(self, "artist_folder_format")

    @artist_folder_format.setter
    def artist_folder_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "artist_folder_format", value)

    @property
    @pulumi.getter(name="multiDiscTrackFormat")
    def multi_disc_track_format(self) -> Optional[pulumi.Input[str]]:
        """
        Multi disc track format.
        """
        return pulumi.get(self, "multi_disc_track_format")

    @multi_disc_track_format.setter
    def multi_disc_track_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "multi_disc_track_format", value)

    @property
    @pulumi.getter(name="renameTracks")
    def rename_tracks(self) -> Optional[pulumi.Input[bool]]:
        """
        Lidarr will use the existing file name if false.
        """
        return pulumi.get(self, "rename_tracks")

    @rename_tracks.setter
    def rename_tracks(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "rename_tracks", value)

    @property
    @pulumi.getter(name="replaceIllegalCharacters")
    def replace_illegal_characters(self) -> Optional[pulumi.Input[bool]]:
        """
        Replace illegal characters. They will be removed if false.
        """
        return pulumi.get(self, "replace_illegal_characters")

    @replace_illegal_characters.setter
    def replace_illegal_characters(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "replace_illegal_characters", value)

    @property
    @pulumi.getter(name="standardTrackFormat")
    def standard_track_format(self) -> Optional[pulumi.Input[str]]:
        """
        Standard track formatss.
        """
        return pulumi.get(self, "standard_track_format")

    @standard_track_format.setter
    def standard_track_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "standard_track_format", value)


class Naming(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artist_folder_format: Optional[pulumi.Input[str]] = None,
                 multi_disc_track_format: Optional[pulumi.Input[str]] = None,
                 rename_tracks: Optional[pulumi.Input[bool]] = None,
                 replace_illegal_characters: Optional[pulumi.Input[bool]] = None,
                 standard_track_format: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        <!-- subcategory:Media Management -->Naming resource.
        For more information refer to [Naming](https://wiki.servarr.com/lidarr/settings#community-naming-suggestions) documentation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.media_management.Naming("example",
            artist_folder_format="{Artist Name}",
            multi_disc_track_format="{Album Title} ({Release Year})/{Medium Format} {medium:00}/{Artist Name} - {Album Title} - {track:00} - {Track Title}",
            rename_tracks=True,
            replace_illegal_characters=True,
            standard_track_format="{Album Title} ({Release Year})/{Artist Name} - {Album Title} - {track:00} - {Track Title}")
        ```

        ## Import

        import

        ```sh
         $ pulumi import lidarr:MediaManagement/naming:Naming example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] artist_folder_format: Artist folder format.
        :param pulumi.Input[str] multi_disc_track_format: Multi disc track format.
        :param pulumi.Input[bool] rename_tracks: Lidarr will use the existing file name if false.
        :param pulumi.Input[bool] replace_illegal_characters: Replace illegal characters. They will be removed if false.
        :param pulumi.Input[str] standard_track_format: Standard track formatss.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NamingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        <!-- subcategory:Media Management -->Naming resource.
        For more information refer to [Naming](https://wiki.servarr.com/lidarr/settings#community-naming-suggestions) documentation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.media_management.Naming("example",
            artist_folder_format="{Artist Name}",
            multi_disc_track_format="{Album Title} ({Release Year})/{Medium Format} {medium:00}/{Artist Name} - {Album Title} - {track:00} - {Track Title}",
            rename_tracks=True,
            replace_illegal_characters=True,
            standard_track_format="{Album Title} ({Release Year})/{Artist Name} - {Album Title} - {track:00} - {Track Title}")
        ```

        ## Import

        import

        ```sh
         $ pulumi import lidarr:MediaManagement/naming:Naming example
        ```

        :param str resource_name: The name of the resource.
        :param NamingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NamingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artist_folder_format: Optional[pulumi.Input[str]] = None,
                 multi_disc_track_format: Optional[pulumi.Input[str]] = None,
                 rename_tracks: Optional[pulumi.Input[bool]] = None,
                 replace_illegal_characters: Optional[pulumi.Input[bool]] = None,
                 standard_track_format: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NamingArgs.__new__(NamingArgs)

            if artist_folder_format is None and not opts.urn:
                raise TypeError("Missing required property 'artist_folder_format'")
            __props__.__dict__["artist_folder_format"] = artist_folder_format
            if multi_disc_track_format is None and not opts.urn:
                raise TypeError("Missing required property 'multi_disc_track_format'")
            __props__.__dict__["multi_disc_track_format"] = multi_disc_track_format
            if rename_tracks is None and not opts.urn:
                raise TypeError("Missing required property 'rename_tracks'")
            __props__.__dict__["rename_tracks"] = rename_tracks
            if replace_illegal_characters is None and not opts.urn:
                raise TypeError("Missing required property 'replace_illegal_characters'")
            __props__.__dict__["replace_illegal_characters"] = replace_illegal_characters
            if standard_track_format is None and not opts.urn:
                raise TypeError("Missing required property 'standard_track_format'")
            __props__.__dict__["standard_track_format"] = standard_track_format
        super(Naming, __self__).__init__(
            'lidarr:MediaManagement/naming:Naming',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            artist_folder_format: Optional[pulumi.Input[str]] = None,
            multi_disc_track_format: Optional[pulumi.Input[str]] = None,
            rename_tracks: Optional[pulumi.Input[bool]] = None,
            replace_illegal_characters: Optional[pulumi.Input[bool]] = None,
            standard_track_format: Optional[pulumi.Input[str]] = None) -> 'Naming':
        """
        Get an existing Naming resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] artist_folder_format: Artist folder format.
        :param pulumi.Input[str] multi_disc_track_format: Multi disc track format.
        :param pulumi.Input[bool] rename_tracks: Lidarr will use the existing file name if false.
        :param pulumi.Input[bool] replace_illegal_characters: Replace illegal characters. They will be removed if false.
        :param pulumi.Input[str] standard_track_format: Standard track formatss.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NamingState.__new__(_NamingState)

        __props__.__dict__["artist_folder_format"] = artist_folder_format
        __props__.__dict__["multi_disc_track_format"] = multi_disc_track_format
        __props__.__dict__["rename_tracks"] = rename_tracks
        __props__.__dict__["replace_illegal_characters"] = replace_illegal_characters
        __props__.__dict__["standard_track_format"] = standard_track_format
        return Naming(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="artistFolderFormat")
    def artist_folder_format(self) -> pulumi.Output[str]:
        """
        Artist folder format.
        """
        return pulumi.get(self, "artist_folder_format")

    @property
    @pulumi.getter(name="multiDiscTrackFormat")
    def multi_disc_track_format(self) -> pulumi.Output[str]:
        """
        Multi disc track format.
        """
        return pulumi.get(self, "multi_disc_track_format")

    @property
    @pulumi.getter(name="renameTracks")
    def rename_tracks(self) -> pulumi.Output[bool]:
        """
        Lidarr will use the existing file name if false.
        """
        return pulumi.get(self, "rename_tracks")

    @property
    @pulumi.getter(name="replaceIllegalCharacters")
    def replace_illegal_characters(self) -> pulumi.Output[bool]:
        """
        Replace illegal characters. They will be removed if false.
        """
        return pulumi.get(self, "replace_illegal_characters")

    @property
    @pulumi.getter(name="standardTrackFormat")
    def standard_track_format(self) -> pulumi.Output[str]:
        """
        Standard track formatss.
        """
        return pulumi.get(self, "standard_track_format")

