# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['MediaManagementArgs', 'MediaManagement']

@pulumi.input_type
class MediaManagementArgs:
    def __init__(__self__, *,
                 allow_fingerprinting: pulumi.Input[str],
                 chmod_folder: pulumi.Input[str],
                 chown_group: pulumi.Input[str],
                 create_empty_folders: pulumi.Input[bool],
                 delete_empty_folders: pulumi.Input[bool],
                 download_propers_repacks: pulumi.Input[str],
                 extra_file_extensions: pulumi.Input[str],
                 file_date: pulumi.Input[str],
                 hardlinks_copy: pulumi.Input[bool],
                 import_extra_files: pulumi.Input[bool],
                 minimum_free_space: pulumi.Input[int],
                 recycle_bin_days: pulumi.Input[int],
                 recycle_bin_path: pulumi.Input[str],
                 rescan_after_refresh: pulumi.Input[str],
                 set_permissions: pulumi.Input[bool],
                 skip_free_space_check: pulumi.Input[bool],
                 unmonitor_previous_tracks: pulumi.Input[bool],
                 watch_library_for_changes: pulumi.Input[bool]):
        """
        The set of arguments for constructing a MediaManagement resource.
        :param pulumi.Input[str] allow_fingerprinting: Allow fingerprinting.
        :param pulumi.Input[str] chmod_folder: Permission in linux format.
        :param pulumi.Input[str] chown_group: Group used for permission.
        :param pulumi.Input[bool] create_empty_folders: Create empty series directories.
        :param pulumi.Input[bool] delete_empty_folders: Delete empty series directories.
        :param pulumi.Input[str] download_propers_repacks: Download proper and repack policy. valid inputs are: 'preferAndUpgrade', 'doNotUpgrade', and 'doNotPrefer'.
        :param pulumi.Input[str] extra_file_extensions: Comma separated list of extra files to import (.nfo will be imported as .nfo-orig).
        :param pulumi.Input[str] file_date: Define the file date modification. valid inputs are: 'none', 'localAirDate, and 'utcAirDate'.
        :param pulumi.Input[bool] hardlinks_copy: Use hardlinks instead of copy.
        :param pulumi.Input[bool] import_extra_files: Import extra files. If enabled it will leverage 'extra*file*extensions'.
        :param pulumi.Input[int] minimum_free_space: Minimum free space in MB to allow import.
        :param pulumi.Input[int] recycle_bin_days: Recyle bin days of retention.
        :param pulumi.Input[str] recycle_bin_path: Recycle bin absolute path.
        :param pulumi.Input[str] rescan_after_refresh: Rescan after refresh policy. valid inputs are: 'always', 'afterManual' and 'never'.
        :param pulumi.Input[bool] set_permissions: Set permission for imported files.
        :param pulumi.Input[bool] skip_free_space_check: Skip free space check before importing.
        :param pulumi.Input[bool] unmonitor_previous_tracks: Unmonitor deleted files.
        :param pulumi.Input[bool] watch_library_for_changes: Whatch library for changes.
        """
        pulumi.set(__self__, "allow_fingerprinting", allow_fingerprinting)
        pulumi.set(__self__, "chmod_folder", chmod_folder)
        pulumi.set(__self__, "chown_group", chown_group)
        pulumi.set(__self__, "create_empty_folders", create_empty_folders)
        pulumi.set(__self__, "delete_empty_folders", delete_empty_folders)
        pulumi.set(__self__, "download_propers_repacks", download_propers_repacks)
        pulumi.set(__self__, "extra_file_extensions", extra_file_extensions)
        pulumi.set(__self__, "file_date", file_date)
        pulumi.set(__self__, "hardlinks_copy", hardlinks_copy)
        pulumi.set(__self__, "import_extra_files", import_extra_files)
        pulumi.set(__self__, "minimum_free_space", minimum_free_space)
        pulumi.set(__self__, "recycle_bin_days", recycle_bin_days)
        pulumi.set(__self__, "recycle_bin_path", recycle_bin_path)
        pulumi.set(__self__, "rescan_after_refresh", rescan_after_refresh)
        pulumi.set(__self__, "set_permissions", set_permissions)
        pulumi.set(__self__, "skip_free_space_check", skip_free_space_check)
        pulumi.set(__self__, "unmonitor_previous_tracks", unmonitor_previous_tracks)
        pulumi.set(__self__, "watch_library_for_changes", watch_library_for_changes)

    @property
    @pulumi.getter(name="allowFingerprinting")
    def allow_fingerprinting(self) -> pulumi.Input[str]:
        """
        Allow fingerprinting.
        """
        return pulumi.get(self, "allow_fingerprinting")

    @allow_fingerprinting.setter
    def allow_fingerprinting(self, value: pulumi.Input[str]):
        pulumi.set(self, "allow_fingerprinting", value)

    @property
    @pulumi.getter(name="chmodFolder")
    def chmod_folder(self) -> pulumi.Input[str]:
        """
        Permission in linux format.
        """
        return pulumi.get(self, "chmod_folder")

    @chmod_folder.setter
    def chmod_folder(self, value: pulumi.Input[str]):
        pulumi.set(self, "chmod_folder", value)

    @property
    @pulumi.getter(name="chownGroup")
    def chown_group(self) -> pulumi.Input[str]:
        """
        Group used for permission.
        """
        return pulumi.get(self, "chown_group")

    @chown_group.setter
    def chown_group(self, value: pulumi.Input[str]):
        pulumi.set(self, "chown_group", value)

    @property
    @pulumi.getter(name="createEmptyFolders")
    def create_empty_folders(self) -> pulumi.Input[bool]:
        """
        Create empty series directories.
        """
        return pulumi.get(self, "create_empty_folders")

    @create_empty_folders.setter
    def create_empty_folders(self, value: pulumi.Input[bool]):
        pulumi.set(self, "create_empty_folders", value)

    @property
    @pulumi.getter(name="deleteEmptyFolders")
    def delete_empty_folders(self) -> pulumi.Input[bool]:
        """
        Delete empty series directories.
        """
        return pulumi.get(self, "delete_empty_folders")

    @delete_empty_folders.setter
    def delete_empty_folders(self, value: pulumi.Input[bool]):
        pulumi.set(self, "delete_empty_folders", value)

    @property
    @pulumi.getter(name="downloadPropersRepacks")
    def download_propers_repacks(self) -> pulumi.Input[str]:
        """
        Download proper and repack policy. valid inputs are: 'preferAndUpgrade', 'doNotUpgrade', and 'doNotPrefer'.
        """
        return pulumi.get(self, "download_propers_repacks")

    @download_propers_repacks.setter
    def download_propers_repacks(self, value: pulumi.Input[str]):
        pulumi.set(self, "download_propers_repacks", value)

    @property
    @pulumi.getter(name="extraFileExtensions")
    def extra_file_extensions(self) -> pulumi.Input[str]:
        """
        Comma separated list of extra files to import (.nfo will be imported as .nfo-orig).
        """
        return pulumi.get(self, "extra_file_extensions")

    @extra_file_extensions.setter
    def extra_file_extensions(self, value: pulumi.Input[str]):
        pulumi.set(self, "extra_file_extensions", value)

    @property
    @pulumi.getter(name="fileDate")
    def file_date(self) -> pulumi.Input[str]:
        """
        Define the file date modification. valid inputs are: 'none', 'localAirDate, and 'utcAirDate'.
        """
        return pulumi.get(self, "file_date")

    @file_date.setter
    def file_date(self, value: pulumi.Input[str]):
        pulumi.set(self, "file_date", value)

    @property
    @pulumi.getter(name="hardlinksCopy")
    def hardlinks_copy(self) -> pulumi.Input[bool]:
        """
        Use hardlinks instead of copy.
        """
        return pulumi.get(self, "hardlinks_copy")

    @hardlinks_copy.setter
    def hardlinks_copy(self, value: pulumi.Input[bool]):
        pulumi.set(self, "hardlinks_copy", value)

    @property
    @pulumi.getter(name="importExtraFiles")
    def import_extra_files(self) -> pulumi.Input[bool]:
        """
        Import extra files. If enabled it will leverage 'extra*file*extensions'.
        """
        return pulumi.get(self, "import_extra_files")

    @import_extra_files.setter
    def import_extra_files(self, value: pulumi.Input[bool]):
        pulumi.set(self, "import_extra_files", value)

    @property
    @pulumi.getter(name="minimumFreeSpace")
    def minimum_free_space(self) -> pulumi.Input[int]:
        """
        Minimum free space in MB to allow import.
        """
        return pulumi.get(self, "minimum_free_space")

    @minimum_free_space.setter
    def minimum_free_space(self, value: pulumi.Input[int]):
        pulumi.set(self, "minimum_free_space", value)

    @property
    @pulumi.getter(name="recycleBinDays")
    def recycle_bin_days(self) -> pulumi.Input[int]:
        """
        Recyle bin days of retention.
        """
        return pulumi.get(self, "recycle_bin_days")

    @recycle_bin_days.setter
    def recycle_bin_days(self, value: pulumi.Input[int]):
        pulumi.set(self, "recycle_bin_days", value)

    @property
    @pulumi.getter(name="recycleBinPath")
    def recycle_bin_path(self) -> pulumi.Input[str]:
        """
        Recycle bin absolute path.
        """
        return pulumi.get(self, "recycle_bin_path")

    @recycle_bin_path.setter
    def recycle_bin_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "recycle_bin_path", value)

    @property
    @pulumi.getter(name="rescanAfterRefresh")
    def rescan_after_refresh(self) -> pulumi.Input[str]:
        """
        Rescan after refresh policy. valid inputs are: 'always', 'afterManual' and 'never'.
        """
        return pulumi.get(self, "rescan_after_refresh")

    @rescan_after_refresh.setter
    def rescan_after_refresh(self, value: pulumi.Input[str]):
        pulumi.set(self, "rescan_after_refresh", value)

    @property
    @pulumi.getter(name="setPermissions")
    def set_permissions(self) -> pulumi.Input[bool]:
        """
        Set permission for imported files.
        """
        return pulumi.get(self, "set_permissions")

    @set_permissions.setter
    def set_permissions(self, value: pulumi.Input[bool]):
        pulumi.set(self, "set_permissions", value)

    @property
    @pulumi.getter(name="skipFreeSpaceCheck")
    def skip_free_space_check(self) -> pulumi.Input[bool]:
        """
        Skip free space check before importing.
        """
        return pulumi.get(self, "skip_free_space_check")

    @skip_free_space_check.setter
    def skip_free_space_check(self, value: pulumi.Input[bool]):
        pulumi.set(self, "skip_free_space_check", value)

    @property
    @pulumi.getter(name="unmonitorPreviousTracks")
    def unmonitor_previous_tracks(self) -> pulumi.Input[bool]:
        """
        Unmonitor deleted files.
        """
        return pulumi.get(self, "unmonitor_previous_tracks")

    @unmonitor_previous_tracks.setter
    def unmonitor_previous_tracks(self, value: pulumi.Input[bool]):
        pulumi.set(self, "unmonitor_previous_tracks", value)

    @property
    @pulumi.getter(name="watchLibraryForChanges")
    def watch_library_for_changes(self) -> pulumi.Input[bool]:
        """
        Whatch library for changes.
        """
        return pulumi.get(self, "watch_library_for_changes")

    @watch_library_for_changes.setter
    def watch_library_for_changes(self, value: pulumi.Input[bool]):
        pulumi.set(self, "watch_library_for_changes", value)


@pulumi.input_type
class _MediaManagementState:
    def __init__(__self__, *,
                 allow_fingerprinting: Optional[pulumi.Input[str]] = None,
                 chmod_folder: Optional[pulumi.Input[str]] = None,
                 chown_group: Optional[pulumi.Input[str]] = None,
                 create_empty_folders: Optional[pulumi.Input[bool]] = None,
                 delete_empty_folders: Optional[pulumi.Input[bool]] = None,
                 download_propers_repacks: Optional[pulumi.Input[str]] = None,
                 extra_file_extensions: Optional[pulumi.Input[str]] = None,
                 file_date: Optional[pulumi.Input[str]] = None,
                 hardlinks_copy: Optional[pulumi.Input[bool]] = None,
                 import_extra_files: Optional[pulumi.Input[bool]] = None,
                 minimum_free_space: Optional[pulumi.Input[int]] = None,
                 recycle_bin_days: Optional[pulumi.Input[int]] = None,
                 recycle_bin_path: Optional[pulumi.Input[str]] = None,
                 rescan_after_refresh: Optional[pulumi.Input[str]] = None,
                 set_permissions: Optional[pulumi.Input[bool]] = None,
                 skip_free_space_check: Optional[pulumi.Input[bool]] = None,
                 unmonitor_previous_tracks: Optional[pulumi.Input[bool]] = None,
                 watch_library_for_changes: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering MediaManagement resources.
        :param pulumi.Input[str] allow_fingerprinting: Allow fingerprinting.
        :param pulumi.Input[str] chmod_folder: Permission in linux format.
        :param pulumi.Input[str] chown_group: Group used for permission.
        :param pulumi.Input[bool] create_empty_folders: Create empty series directories.
        :param pulumi.Input[bool] delete_empty_folders: Delete empty series directories.
        :param pulumi.Input[str] download_propers_repacks: Download proper and repack policy. valid inputs are: 'preferAndUpgrade', 'doNotUpgrade', and 'doNotPrefer'.
        :param pulumi.Input[str] extra_file_extensions: Comma separated list of extra files to import (.nfo will be imported as .nfo-orig).
        :param pulumi.Input[str] file_date: Define the file date modification. valid inputs are: 'none', 'localAirDate, and 'utcAirDate'.
        :param pulumi.Input[bool] hardlinks_copy: Use hardlinks instead of copy.
        :param pulumi.Input[bool] import_extra_files: Import extra files. If enabled it will leverage 'extra*file*extensions'.
        :param pulumi.Input[int] minimum_free_space: Minimum free space in MB to allow import.
        :param pulumi.Input[int] recycle_bin_days: Recyle bin days of retention.
        :param pulumi.Input[str] recycle_bin_path: Recycle bin absolute path.
        :param pulumi.Input[str] rescan_after_refresh: Rescan after refresh policy. valid inputs are: 'always', 'afterManual' and 'never'.
        :param pulumi.Input[bool] set_permissions: Set permission for imported files.
        :param pulumi.Input[bool] skip_free_space_check: Skip free space check before importing.
        :param pulumi.Input[bool] unmonitor_previous_tracks: Unmonitor deleted files.
        :param pulumi.Input[bool] watch_library_for_changes: Whatch library for changes.
        """
        if allow_fingerprinting is not None:
            pulumi.set(__self__, "allow_fingerprinting", allow_fingerprinting)
        if chmod_folder is not None:
            pulumi.set(__self__, "chmod_folder", chmod_folder)
        if chown_group is not None:
            pulumi.set(__self__, "chown_group", chown_group)
        if create_empty_folders is not None:
            pulumi.set(__self__, "create_empty_folders", create_empty_folders)
        if delete_empty_folders is not None:
            pulumi.set(__self__, "delete_empty_folders", delete_empty_folders)
        if download_propers_repacks is not None:
            pulumi.set(__self__, "download_propers_repacks", download_propers_repacks)
        if extra_file_extensions is not None:
            pulumi.set(__self__, "extra_file_extensions", extra_file_extensions)
        if file_date is not None:
            pulumi.set(__self__, "file_date", file_date)
        if hardlinks_copy is not None:
            pulumi.set(__self__, "hardlinks_copy", hardlinks_copy)
        if import_extra_files is not None:
            pulumi.set(__self__, "import_extra_files", import_extra_files)
        if minimum_free_space is not None:
            pulumi.set(__self__, "minimum_free_space", minimum_free_space)
        if recycle_bin_days is not None:
            pulumi.set(__self__, "recycle_bin_days", recycle_bin_days)
        if recycle_bin_path is not None:
            pulumi.set(__self__, "recycle_bin_path", recycle_bin_path)
        if rescan_after_refresh is not None:
            pulumi.set(__self__, "rescan_after_refresh", rescan_after_refresh)
        if set_permissions is not None:
            pulumi.set(__self__, "set_permissions", set_permissions)
        if skip_free_space_check is not None:
            pulumi.set(__self__, "skip_free_space_check", skip_free_space_check)
        if unmonitor_previous_tracks is not None:
            pulumi.set(__self__, "unmonitor_previous_tracks", unmonitor_previous_tracks)
        if watch_library_for_changes is not None:
            pulumi.set(__self__, "watch_library_for_changes", watch_library_for_changes)

    @property
    @pulumi.getter(name="allowFingerprinting")
    def allow_fingerprinting(self) -> Optional[pulumi.Input[str]]:
        """
        Allow fingerprinting.
        """
        return pulumi.get(self, "allow_fingerprinting")

    @allow_fingerprinting.setter
    def allow_fingerprinting(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allow_fingerprinting", value)

    @property
    @pulumi.getter(name="chmodFolder")
    def chmod_folder(self) -> Optional[pulumi.Input[str]]:
        """
        Permission in linux format.
        """
        return pulumi.get(self, "chmod_folder")

    @chmod_folder.setter
    def chmod_folder(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "chmod_folder", value)

    @property
    @pulumi.getter(name="chownGroup")
    def chown_group(self) -> Optional[pulumi.Input[str]]:
        """
        Group used for permission.
        """
        return pulumi.get(self, "chown_group")

    @chown_group.setter
    def chown_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "chown_group", value)

    @property
    @pulumi.getter(name="createEmptyFolders")
    def create_empty_folders(self) -> Optional[pulumi.Input[bool]]:
        """
        Create empty series directories.
        """
        return pulumi.get(self, "create_empty_folders")

    @create_empty_folders.setter
    def create_empty_folders(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "create_empty_folders", value)

    @property
    @pulumi.getter(name="deleteEmptyFolders")
    def delete_empty_folders(self) -> Optional[pulumi.Input[bool]]:
        """
        Delete empty series directories.
        """
        return pulumi.get(self, "delete_empty_folders")

    @delete_empty_folders.setter
    def delete_empty_folders(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_empty_folders", value)

    @property
    @pulumi.getter(name="downloadPropersRepacks")
    def download_propers_repacks(self) -> Optional[pulumi.Input[str]]:
        """
        Download proper and repack policy. valid inputs are: 'preferAndUpgrade', 'doNotUpgrade', and 'doNotPrefer'.
        """
        return pulumi.get(self, "download_propers_repacks")

    @download_propers_repacks.setter
    def download_propers_repacks(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "download_propers_repacks", value)

    @property
    @pulumi.getter(name="extraFileExtensions")
    def extra_file_extensions(self) -> Optional[pulumi.Input[str]]:
        """
        Comma separated list of extra files to import (.nfo will be imported as .nfo-orig).
        """
        return pulumi.get(self, "extra_file_extensions")

    @extra_file_extensions.setter
    def extra_file_extensions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "extra_file_extensions", value)

    @property
    @pulumi.getter(name="fileDate")
    def file_date(self) -> Optional[pulumi.Input[str]]:
        """
        Define the file date modification. valid inputs are: 'none', 'localAirDate, and 'utcAirDate'.
        """
        return pulumi.get(self, "file_date")

    @file_date.setter
    def file_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_date", value)

    @property
    @pulumi.getter(name="hardlinksCopy")
    def hardlinks_copy(self) -> Optional[pulumi.Input[bool]]:
        """
        Use hardlinks instead of copy.
        """
        return pulumi.get(self, "hardlinks_copy")

    @hardlinks_copy.setter
    def hardlinks_copy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hardlinks_copy", value)

    @property
    @pulumi.getter(name="importExtraFiles")
    def import_extra_files(self) -> Optional[pulumi.Input[bool]]:
        """
        Import extra files. If enabled it will leverage 'extra*file*extensions'.
        """
        return pulumi.get(self, "import_extra_files")

    @import_extra_files.setter
    def import_extra_files(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "import_extra_files", value)

    @property
    @pulumi.getter(name="minimumFreeSpace")
    def minimum_free_space(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum free space in MB to allow import.
        """
        return pulumi.get(self, "minimum_free_space")

    @minimum_free_space.setter
    def minimum_free_space(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minimum_free_space", value)

    @property
    @pulumi.getter(name="recycleBinDays")
    def recycle_bin_days(self) -> Optional[pulumi.Input[int]]:
        """
        Recyle bin days of retention.
        """
        return pulumi.get(self, "recycle_bin_days")

    @recycle_bin_days.setter
    def recycle_bin_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recycle_bin_days", value)

    @property
    @pulumi.getter(name="recycleBinPath")
    def recycle_bin_path(self) -> Optional[pulumi.Input[str]]:
        """
        Recycle bin absolute path.
        """
        return pulumi.get(self, "recycle_bin_path")

    @recycle_bin_path.setter
    def recycle_bin_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recycle_bin_path", value)

    @property
    @pulumi.getter(name="rescanAfterRefresh")
    def rescan_after_refresh(self) -> Optional[pulumi.Input[str]]:
        """
        Rescan after refresh policy. valid inputs are: 'always', 'afterManual' and 'never'.
        """
        return pulumi.get(self, "rescan_after_refresh")

    @rescan_after_refresh.setter
    def rescan_after_refresh(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rescan_after_refresh", value)

    @property
    @pulumi.getter(name="setPermissions")
    def set_permissions(self) -> Optional[pulumi.Input[bool]]:
        """
        Set permission for imported files.
        """
        return pulumi.get(self, "set_permissions")

    @set_permissions.setter
    def set_permissions(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "set_permissions", value)

    @property
    @pulumi.getter(name="skipFreeSpaceCheck")
    def skip_free_space_check(self) -> Optional[pulumi.Input[bool]]:
        """
        Skip free space check before importing.
        """
        return pulumi.get(self, "skip_free_space_check")

    @skip_free_space_check.setter
    def skip_free_space_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_free_space_check", value)

    @property
    @pulumi.getter(name="unmonitorPreviousTracks")
    def unmonitor_previous_tracks(self) -> Optional[pulumi.Input[bool]]:
        """
        Unmonitor deleted files.
        """
        return pulumi.get(self, "unmonitor_previous_tracks")

    @unmonitor_previous_tracks.setter
    def unmonitor_previous_tracks(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "unmonitor_previous_tracks", value)

    @property
    @pulumi.getter(name="watchLibraryForChanges")
    def watch_library_for_changes(self) -> Optional[pulumi.Input[bool]]:
        """
        Whatch library for changes.
        """
        return pulumi.get(self, "watch_library_for_changes")

    @watch_library_for_changes.setter
    def watch_library_for_changes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "watch_library_for_changes", value)


class MediaManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_fingerprinting: Optional[pulumi.Input[str]] = None,
                 chmod_folder: Optional[pulumi.Input[str]] = None,
                 chown_group: Optional[pulumi.Input[str]] = None,
                 create_empty_folders: Optional[pulumi.Input[bool]] = None,
                 delete_empty_folders: Optional[pulumi.Input[bool]] = None,
                 download_propers_repacks: Optional[pulumi.Input[str]] = None,
                 extra_file_extensions: Optional[pulumi.Input[str]] = None,
                 file_date: Optional[pulumi.Input[str]] = None,
                 hardlinks_copy: Optional[pulumi.Input[bool]] = None,
                 import_extra_files: Optional[pulumi.Input[bool]] = None,
                 minimum_free_space: Optional[pulumi.Input[int]] = None,
                 recycle_bin_days: Optional[pulumi.Input[int]] = None,
                 recycle_bin_path: Optional[pulumi.Input[str]] = None,
                 rescan_after_refresh: Optional[pulumi.Input[str]] = None,
                 set_permissions: Optional[pulumi.Input[bool]] = None,
                 skip_free_space_check: Optional[pulumi.Input[bool]] = None,
                 unmonitor_previous_tracks: Optional[pulumi.Input[bool]] = None,
                 watch_library_for_changes: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        <!-- subcategory:Media Management -->Media Management resource.
        For more information refer to [Naming](https://wiki.servarr.com/lidarr/settings#file-management) documentation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.media_management.MediaManagement("example",
            allow_fingerprinting="never",
            chmod_folder="755",
            chown_group="arrs",
            create_empty_folders=True,
            delete_empty_folders=True,
            download_propers_repacks="preferAndUpgrade",
            extra_file_extensions="info",
            file_date="none",
            hardlinks_copy=True,
            import_extra_files=True,
            minimum_free_space=100,
            recycle_bin_days=7,
            recycle_bin_path="",
            rescan_after_refresh="always",
            set_permissions=True,
            skip_free_space_check=True,
            unmonitor_previous_tracks=True,
            watch_library_for_changes=True)
        ```

        ## Import

        import

        ```sh
         $ pulumi import lidarr:MediaManagement/mediaManagement:MediaManagement example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] allow_fingerprinting: Allow fingerprinting.
        :param pulumi.Input[str] chmod_folder: Permission in linux format.
        :param pulumi.Input[str] chown_group: Group used for permission.
        :param pulumi.Input[bool] create_empty_folders: Create empty series directories.
        :param pulumi.Input[bool] delete_empty_folders: Delete empty series directories.
        :param pulumi.Input[str] download_propers_repacks: Download proper and repack policy. valid inputs are: 'preferAndUpgrade', 'doNotUpgrade', and 'doNotPrefer'.
        :param pulumi.Input[str] extra_file_extensions: Comma separated list of extra files to import (.nfo will be imported as .nfo-orig).
        :param pulumi.Input[str] file_date: Define the file date modification. valid inputs are: 'none', 'localAirDate, and 'utcAirDate'.
        :param pulumi.Input[bool] hardlinks_copy: Use hardlinks instead of copy.
        :param pulumi.Input[bool] import_extra_files: Import extra files. If enabled it will leverage 'extra*file*extensions'.
        :param pulumi.Input[int] minimum_free_space: Minimum free space in MB to allow import.
        :param pulumi.Input[int] recycle_bin_days: Recyle bin days of retention.
        :param pulumi.Input[str] recycle_bin_path: Recycle bin absolute path.
        :param pulumi.Input[str] rescan_after_refresh: Rescan after refresh policy. valid inputs are: 'always', 'afterManual' and 'never'.
        :param pulumi.Input[bool] set_permissions: Set permission for imported files.
        :param pulumi.Input[bool] skip_free_space_check: Skip free space check before importing.
        :param pulumi.Input[bool] unmonitor_previous_tracks: Unmonitor deleted files.
        :param pulumi.Input[bool] watch_library_for_changes: Whatch library for changes.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MediaManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        <!-- subcategory:Media Management -->Media Management resource.
        For more information refer to [Naming](https://wiki.servarr.com/lidarr/settings#file-management) documentation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.media_management.MediaManagement("example",
            allow_fingerprinting="never",
            chmod_folder="755",
            chown_group="arrs",
            create_empty_folders=True,
            delete_empty_folders=True,
            download_propers_repacks="preferAndUpgrade",
            extra_file_extensions="info",
            file_date="none",
            hardlinks_copy=True,
            import_extra_files=True,
            minimum_free_space=100,
            recycle_bin_days=7,
            recycle_bin_path="",
            rescan_after_refresh="always",
            set_permissions=True,
            skip_free_space_check=True,
            unmonitor_previous_tracks=True,
            watch_library_for_changes=True)
        ```

        ## Import

        import

        ```sh
         $ pulumi import lidarr:MediaManagement/mediaManagement:MediaManagement example
        ```

        :param str resource_name: The name of the resource.
        :param MediaManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MediaManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_fingerprinting: Optional[pulumi.Input[str]] = None,
                 chmod_folder: Optional[pulumi.Input[str]] = None,
                 chown_group: Optional[pulumi.Input[str]] = None,
                 create_empty_folders: Optional[pulumi.Input[bool]] = None,
                 delete_empty_folders: Optional[pulumi.Input[bool]] = None,
                 download_propers_repacks: Optional[pulumi.Input[str]] = None,
                 extra_file_extensions: Optional[pulumi.Input[str]] = None,
                 file_date: Optional[pulumi.Input[str]] = None,
                 hardlinks_copy: Optional[pulumi.Input[bool]] = None,
                 import_extra_files: Optional[pulumi.Input[bool]] = None,
                 minimum_free_space: Optional[pulumi.Input[int]] = None,
                 recycle_bin_days: Optional[pulumi.Input[int]] = None,
                 recycle_bin_path: Optional[pulumi.Input[str]] = None,
                 rescan_after_refresh: Optional[pulumi.Input[str]] = None,
                 set_permissions: Optional[pulumi.Input[bool]] = None,
                 skip_free_space_check: Optional[pulumi.Input[bool]] = None,
                 unmonitor_previous_tracks: Optional[pulumi.Input[bool]] = None,
                 watch_library_for_changes: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MediaManagementArgs.__new__(MediaManagementArgs)

            if allow_fingerprinting is None and not opts.urn:
                raise TypeError("Missing required property 'allow_fingerprinting'")
            __props__.__dict__["allow_fingerprinting"] = allow_fingerprinting
            if chmod_folder is None and not opts.urn:
                raise TypeError("Missing required property 'chmod_folder'")
            __props__.__dict__["chmod_folder"] = chmod_folder
            if chown_group is None and not opts.urn:
                raise TypeError("Missing required property 'chown_group'")
            __props__.__dict__["chown_group"] = chown_group
            if create_empty_folders is None and not opts.urn:
                raise TypeError("Missing required property 'create_empty_folders'")
            __props__.__dict__["create_empty_folders"] = create_empty_folders
            if delete_empty_folders is None and not opts.urn:
                raise TypeError("Missing required property 'delete_empty_folders'")
            __props__.__dict__["delete_empty_folders"] = delete_empty_folders
            if download_propers_repacks is None and not opts.urn:
                raise TypeError("Missing required property 'download_propers_repacks'")
            __props__.__dict__["download_propers_repacks"] = download_propers_repacks
            if extra_file_extensions is None and not opts.urn:
                raise TypeError("Missing required property 'extra_file_extensions'")
            __props__.__dict__["extra_file_extensions"] = extra_file_extensions
            if file_date is None and not opts.urn:
                raise TypeError("Missing required property 'file_date'")
            __props__.__dict__["file_date"] = file_date
            if hardlinks_copy is None and not opts.urn:
                raise TypeError("Missing required property 'hardlinks_copy'")
            __props__.__dict__["hardlinks_copy"] = hardlinks_copy
            if import_extra_files is None and not opts.urn:
                raise TypeError("Missing required property 'import_extra_files'")
            __props__.__dict__["import_extra_files"] = import_extra_files
            if minimum_free_space is None and not opts.urn:
                raise TypeError("Missing required property 'minimum_free_space'")
            __props__.__dict__["minimum_free_space"] = minimum_free_space
            if recycle_bin_days is None and not opts.urn:
                raise TypeError("Missing required property 'recycle_bin_days'")
            __props__.__dict__["recycle_bin_days"] = recycle_bin_days
            if recycle_bin_path is None and not opts.urn:
                raise TypeError("Missing required property 'recycle_bin_path'")
            __props__.__dict__["recycle_bin_path"] = recycle_bin_path
            if rescan_after_refresh is None and not opts.urn:
                raise TypeError("Missing required property 'rescan_after_refresh'")
            __props__.__dict__["rescan_after_refresh"] = rescan_after_refresh
            if set_permissions is None and not opts.urn:
                raise TypeError("Missing required property 'set_permissions'")
            __props__.__dict__["set_permissions"] = set_permissions
            if skip_free_space_check is None and not opts.urn:
                raise TypeError("Missing required property 'skip_free_space_check'")
            __props__.__dict__["skip_free_space_check"] = skip_free_space_check
            if unmonitor_previous_tracks is None and not opts.urn:
                raise TypeError("Missing required property 'unmonitor_previous_tracks'")
            __props__.__dict__["unmonitor_previous_tracks"] = unmonitor_previous_tracks
            if watch_library_for_changes is None and not opts.urn:
                raise TypeError("Missing required property 'watch_library_for_changes'")
            __props__.__dict__["watch_library_for_changes"] = watch_library_for_changes
        super(MediaManagement, __self__).__init__(
            'lidarr:MediaManagement/mediaManagement:MediaManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_fingerprinting: Optional[pulumi.Input[str]] = None,
            chmod_folder: Optional[pulumi.Input[str]] = None,
            chown_group: Optional[pulumi.Input[str]] = None,
            create_empty_folders: Optional[pulumi.Input[bool]] = None,
            delete_empty_folders: Optional[pulumi.Input[bool]] = None,
            download_propers_repacks: Optional[pulumi.Input[str]] = None,
            extra_file_extensions: Optional[pulumi.Input[str]] = None,
            file_date: Optional[pulumi.Input[str]] = None,
            hardlinks_copy: Optional[pulumi.Input[bool]] = None,
            import_extra_files: Optional[pulumi.Input[bool]] = None,
            minimum_free_space: Optional[pulumi.Input[int]] = None,
            recycle_bin_days: Optional[pulumi.Input[int]] = None,
            recycle_bin_path: Optional[pulumi.Input[str]] = None,
            rescan_after_refresh: Optional[pulumi.Input[str]] = None,
            set_permissions: Optional[pulumi.Input[bool]] = None,
            skip_free_space_check: Optional[pulumi.Input[bool]] = None,
            unmonitor_previous_tracks: Optional[pulumi.Input[bool]] = None,
            watch_library_for_changes: Optional[pulumi.Input[bool]] = None) -> 'MediaManagement':
        """
        Get an existing MediaManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] allow_fingerprinting: Allow fingerprinting.
        :param pulumi.Input[str] chmod_folder: Permission in linux format.
        :param pulumi.Input[str] chown_group: Group used for permission.
        :param pulumi.Input[bool] create_empty_folders: Create empty series directories.
        :param pulumi.Input[bool] delete_empty_folders: Delete empty series directories.
        :param pulumi.Input[str] download_propers_repacks: Download proper and repack policy. valid inputs are: 'preferAndUpgrade', 'doNotUpgrade', and 'doNotPrefer'.
        :param pulumi.Input[str] extra_file_extensions: Comma separated list of extra files to import (.nfo will be imported as .nfo-orig).
        :param pulumi.Input[str] file_date: Define the file date modification. valid inputs are: 'none', 'localAirDate, and 'utcAirDate'.
        :param pulumi.Input[bool] hardlinks_copy: Use hardlinks instead of copy.
        :param pulumi.Input[bool] import_extra_files: Import extra files. If enabled it will leverage 'extra*file*extensions'.
        :param pulumi.Input[int] minimum_free_space: Minimum free space in MB to allow import.
        :param pulumi.Input[int] recycle_bin_days: Recyle bin days of retention.
        :param pulumi.Input[str] recycle_bin_path: Recycle bin absolute path.
        :param pulumi.Input[str] rescan_after_refresh: Rescan after refresh policy. valid inputs are: 'always', 'afterManual' and 'never'.
        :param pulumi.Input[bool] set_permissions: Set permission for imported files.
        :param pulumi.Input[bool] skip_free_space_check: Skip free space check before importing.
        :param pulumi.Input[bool] unmonitor_previous_tracks: Unmonitor deleted files.
        :param pulumi.Input[bool] watch_library_for_changes: Whatch library for changes.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MediaManagementState.__new__(_MediaManagementState)

        __props__.__dict__["allow_fingerprinting"] = allow_fingerprinting
        __props__.__dict__["chmod_folder"] = chmod_folder
        __props__.__dict__["chown_group"] = chown_group
        __props__.__dict__["create_empty_folders"] = create_empty_folders
        __props__.__dict__["delete_empty_folders"] = delete_empty_folders
        __props__.__dict__["download_propers_repacks"] = download_propers_repacks
        __props__.__dict__["extra_file_extensions"] = extra_file_extensions
        __props__.__dict__["file_date"] = file_date
        __props__.__dict__["hardlinks_copy"] = hardlinks_copy
        __props__.__dict__["import_extra_files"] = import_extra_files
        __props__.__dict__["minimum_free_space"] = minimum_free_space
        __props__.__dict__["recycle_bin_days"] = recycle_bin_days
        __props__.__dict__["recycle_bin_path"] = recycle_bin_path
        __props__.__dict__["rescan_after_refresh"] = rescan_after_refresh
        __props__.__dict__["set_permissions"] = set_permissions
        __props__.__dict__["skip_free_space_check"] = skip_free_space_check
        __props__.__dict__["unmonitor_previous_tracks"] = unmonitor_previous_tracks
        __props__.__dict__["watch_library_for_changes"] = watch_library_for_changes
        return MediaManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowFingerprinting")
    def allow_fingerprinting(self) -> pulumi.Output[str]:
        """
        Allow fingerprinting.
        """
        return pulumi.get(self, "allow_fingerprinting")

    @property
    @pulumi.getter(name="chmodFolder")
    def chmod_folder(self) -> pulumi.Output[str]:
        """
        Permission in linux format.
        """
        return pulumi.get(self, "chmod_folder")

    @property
    @pulumi.getter(name="chownGroup")
    def chown_group(self) -> pulumi.Output[str]:
        """
        Group used for permission.
        """
        return pulumi.get(self, "chown_group")

    @property
    @pulumi.getter(name="createEmptyFolders")
    def create_empty_folders(self) -> pulumi.Output[bool]:
        """
        Create empty series directories.
        """
        return pulumi.get(self, "create_empty_folders")

    @property
    @pulumi.getter(name="deleteEmptyFolders")
    def delete_empty_folders(self) -> pulumi.Output[bool]:
        """
        Delete empty series directories.
        """
        return pulumi.get(self, "delete_empty_folders")

    @property
    @pulumi.getter(name="downloadPropersRepacks")
    def download_propers_repacks(self) -> pulumi.Output[str]:
        """
        Download proper and repack policy. valid inputs are: 'preferAndUpgrade', 'doNotUpgrade', and 'doNotPrefer'.
        """
        return pulumi.get(self, "download_propers_repacks")

    @property
    @pulumi.getter(name="extraFileExtensions")
    def extra_file_extensions(self) -> pulumi.Output[str]:
        """
        Comma separated list of extra files to import (.nfo will be imported as .nfo-orig).
        """
        return pulumi.get(self, "extra_file_extensions")

    @property
    @pulumi.getter(name="fileDate")
    def file_date(self) -> pulumi.Output[str]:
        """
        Define the file date modification. valid inputs are: 'none', 'localAirDate, and 'utcAirDate'.
        """
        return pulumi.get(self, "file_date")

    @property
    @pulumi.getter(name="hardlinksCopy")
    def hardlinks_copy(self) -> pulumi.Output[bool]:
        """
        Use hardlinks instead of copy.
        """
        return pulumi.get(self, "hardlinks_copy")

    @property
    @pulumi.getter(name="importExtraFiles")
    def import_extra_files(self) -> pulumi.Output[bool]:
        """
        Import extra files. If enabled it will leverage 'extra*file*extensions'.
        """
        return pulumi.get(self, "import_extra_files")

    @property
    @pulumi.getter(name="minimumFreeSpace")
    def minimum_free_space(self) -> pulumi.Output[int]:
        """
        Minimum free space in MB to allow import.
        """
        return pulumi.get(self, "minimum_free_space")

    @property
    @pulumi.getter(name="recycleBinDays")
    def recycle_bin_days(self) -> pulumi.Output[int]:
        """
        Recyle bin days of retention.
        """
        return pulumi.get(self, "recycle_bin_days")

    @property
    @pulumi.getter(name="recycleBinPath")
    def recycle_bin_path(self) -> pulumi.Output[str]:
        """
        Recycle bin absolute path.
        """
        return pulumi.get(self, "recycle_bin_path")

    @property
    @pulumi.getter(name="rescanAfterRefresh")
    def rescan_after_refresh(self) -> pulumi.Output[str]:
        """
        Rescan after refresh policy. valid inputs are: 'always', 'afterManual' and 'never'.
        """
        return pulumi.get(self, "rescan_after_refresh")

    @property
    @pulumi.getter(name="setPermissions")
    def set_permissions(self) -> pulumi.Output[bool]:
        """
        Set permission for imported files.
        """
        return pulumi.get(self, "set_permissions")

    @property
    @pulumi.getter(name="skipFreeSpaceCheck")
    def skip_free_space_check(self) -> pulumi.Output[bool]:
        """
        Skip free space check before importing.
        """
        return pulumi.get(self, "skip_free_space_check")

    @property
    @pulumi.getter(name="unmonitorPreviousTracks")
    def unmonitor_previous_tracks(self) -> pulumi.Output[bool]:
        """
        Unmonitor deleted files.
        """
        return pulumi.get(self, "unmonitor_previous_tracks")

    @property
    @pulumi.getter(name="watchLibraryForChanges")
    def watch_library_for_changes(self) -> pulumi.Output[bool]:
        """
        Whatch library for changes.
        """
        return pulumi.get(self, "watch_library_for_changes")

