# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['IndexerArgs', 'Indexer']

@pulumi.input_type
class IndexerArgs:
    def __init__(__self__, *,
                 config_contract: pulumi.Input[str],
                 implementation: pulumi.Input[str],
                 protocol: pulumi.Input[str],
                 additional_parameters: Optional[pulumi.Input[str]] = None,
                 allow_zero_size: Optional[pulumi.Input[bool]] = None,
                 api_key: Optional[pulumi.Input[str]] = None,
                 api_path: Optional[pulumi.Input[str]] = None,
                 api_user: Optional[pulumi.Input[str]] = None,
                 base_url: Optional[pulumi.Input[str]] = None,
                 captcha_token: Optional[pulumi.Input[str]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 cookie: Optional[pulumi.Input[str]] = None,
                 delay: Optional[pulumi.Input[int]] = None,
                 discography_seed_time: Optional[pulumi.Input[int]] = None,
                 early_release_limit: Optional[pulumi.Input[int]] = None,
                 enable_automatic_search: Optional[pulumi.Input[bool]] = None,
                 enable_interactive_search: Optional[pulumi.Input[bool]] = None,
                 enable_rss: Optional[pulumi.Input[bool]] = None,
                 minimum_seeders: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 passkey: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 ranked_only: Optional[pulumi.Input[bool]] = None,
                 rss_passkey: Optional[pulumi.Input[str]] = None,
                 seed_ratio: Optional[pulumi.Input[float]] = None,
                 seed_time: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 use_freeleech_token: Optional[pulumi.Input[bool]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Indexer resource.
        :param pulumi.Input[str] config_contract: Indexer configuration template.
        :param pulumi.Input[str] implementation: Indexer implementation name.
        :param pulumi.Input[str] protocol: Protocol. Valid values are 'usenet' and 'torrent'.
        :param pulumi.Input[str] additional_parameters: Additional parameters.
        :param pulumi.Input[bool] allow_zero_size: Allow zero size files.
        :param pulumi.Input[str] api_key: API key.
        :param pulumi.Input[str] api_path: API path.
        :param pulumi.Input[str] api_user: API User.
        :param pulumi.Input[str] base_url: Base URL.
        :param pulumi.Input[str] captcha_token: Captcha token.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] categories: Series list.
        :param pulumi.Input[str] cookie: Cookie.
        :param pulumi.Input[int] delay: Delay before grabbing.
        :param pulumi.Input[int] discography_seed_time: Discography seed time.
        :param pulumi.Input[int] early_release_limit: Early release limit.
        :param pulumi.Input[bool] enable_automatic_search: Enable automatic search flag.
        :param pulumi.Input[bool] enable_interactive_search: Enable interactive search flag.
        :param pulumi.Input[bool] enable_rss: Enable RSS flag.
        :param pulumi.Input[int] minimum_seeders: Minimum seeders.
        :param pulumi.Input[str] name: Indexer name.
        :param pulumi.Input[str] passkey: Passkey.
        :param pulumi.Input[str] password: Password.
        :param pulumi.Input[int] priority: Priority.
        :param pulumi.Input[bool] ranked_only: Allow ranked only.
        :param pulumi.Input[str] rss_passkey: RSS passkey.
        :param pulumi.Input[float] seed_ratio: Seed ratio.
        :param pulumi.Input[int] seed_time: Seed time.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        :param pulumi.Input[bool] use_freeleech_token: Use freeleech token flag.
        :param pulumi.Input[str] user_id: User ID.
        :param pulumi.Input[str] username: Username.
        """
        pulumi.set(__self__, "config_contract", config_contract)
        pulumi.set(__self__, "implementation", implementation)
        pulumi.set(__self__, "protocol", protocol)
        if additional_parameters is not None:
            pulumi.set(__self__, "additional_parameters", additional_parameters)
        if allow_zero_size is not None:
            pulumi.set(__self__, "allow_zero_size", allow_zero_size)
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if api_path is not None:
            pulumi.set(__self__, "api_path", api_path)
        if api_user is not None:
            pulumi.set(__self__, "api_user", api_user)
        if base_url is not None:
            pulumi.set(__self__, "base_url", base_url)
        if captcha_token is not None:
            pulumi.set(__self__, "captcha_token", captcha_token)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if cookie is not None:
            pulumi.set(__self__, "cookie", cookie)
        if delay is not None:
            pulumi.set(__self__, "delay", delay)
        if discography_seed_time is not None:
            pulumi.set(__self__, "discography_seed_time", discography_seed_time)
        if early_release_limit is not None:
            pulumi.set(__self__, "early_release_limit", early_release_limit)
        if enable_automatic_search is not None:
            pulumi.set(__self__, "enable_automatic_search", enable_automatic_search)
        if enable_interactive_search is not None:
            pulumi.set(__self__, "enable_interactive_search", enable_interactive_search)
        if enable_rss is not None:
            pulumi.set(__self__, "enable_rss", enable_rss)
        if minimum_seeders is not None:
            pulumi.set(__self__, "minimum_seeders", minimum_seeders)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if passkey is not None:
            pulumi.set(__self__, "passkey", passkey)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if ranked_only is not None:
            pulumi.set(__self__, "ranked_only", ranked_only)
        if rss_passkey is not None:
            pulumi.set(__self__, "rss_passkey", rss_passkey)
        if seed_ratio is not None:
            pulumi.set(__self__, "seed_ratio", seed_ratio)
        if seed_time is not None:
            pulumi.set(__self__, "seed_time", seed_time)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if use_freeleech_token is not None:
            pulumi.set(__self__, "use_freeleech_token", use_freeleech_token)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="configContract")
    def config_contract(self) -> pulumi.Input[str]:
        """
        Indexer configuration template.
        """
        return pulumi.get(self, "config_contract")

    @config_contract.setter
    def config_contract(self, value: pulumi.Input[str]):
        pulumi.set(self, "config_contract", value)

    @property
    @pulumi.getter
    def implementation(self) -> pulumi.Input[str]:
        """
        Indexer implementation name.
        """
        return pulumi.get(self, "implementation")

    @implementation.setter
    def implementation(self, value: pulumi.Input[str]):
        pulumi.set(self, "implementation", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        Protocol. Valid values are 'usenet' and 'torrent'.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="additionalParameters")
    def additional_parameters(self) -> Optional[pulumi.Input[str]]:
        """
        Additional parameters.
        """
        return pulumi.get(self, "additional_parameters")

    @additional_parameters.setter
    def additional_parameters(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "additional_parameters", value)

    @property
    @pulumi.getter(name="allowZeroSize")
    def allow_zero_size(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow zero size files.
        """
        return pulumi.get(self, "allow_zero_size")

    @allow_zero_size.setter
    def allow_zero_size(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_zero_size", value)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[str]]:
        """
        API key.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter(name="apiPath")
    def api_path(self) -> Optional[pulumi.Input[str]]:
        """
        API path.
        """
        return pulumi.get(self, "api_path")

    @api_path.setter
    def api_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_path", value)

    @property
    @pulumi.getter(name="apiUser")
    def api_user(self) -> Optional[pulumi.Input[str]]:
        """
        API User.
        """
        return pulumi.get(self, "api_user")

    @api_user.setter
    def api_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_user", value)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> Optional[pulumi.Input[str]]:
        """
        Base URL.
        """
        return pulumi.get(self, "base_url")

    @base_url.setter
    def base_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_url", value)

    @property
    @pulumi.getter(name="captchaToken")
    def captcha_token(self) -> Optional[pulumi.Input[str]]:
        """
        Captcha token.
        """
        return pulumi.get(self, "captcha_token")

    @captcha_token.setter
    def captcha_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "captcha_token", value)

    @property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Series list.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "categories", value)

    @property
    @pulumi.getter
    def cookie(self) -> Optional[pulumi.Input[str]]:
        """
        Cookie.
        """
        return pulumi.get(self, "cookie")

    @cookie.setter
    def cookie(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cookie", value)

    @property
    @pulumi.getter
    def delay(self) -> Optional[pulumi.Input[int]]:
        """
        Delay before grabbing.
        """
        return pulumi.get(self, "delay")

    @delay.setter
    def delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "delay", value)

    @property
    @pulumi.getter(name="discographySeedTime")
    def discography_seed_time(self) -> Optional[pulumi.Input[int]]:
        """
        Discography seed time.
        """
        return pulumi.get(self, "discography_seed_time")

    @discography_seed_time.setter
    def discography_seed_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "discography_seed_time", value)

    @property
    @pulumi.getter(name="earlyReleaseLimit")
    def early_release_limit(self) -> Optional[pulumi.Input[int]]:
        """
        Early release limit.
        """
        return pulumi.get(self, "early_release_limit")

    @early_release_limit.setter
    def early_release_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "early_release_limit", value)

    @property
    @pulumi.getter(name="enableAutomaticSearch")
    def enable_automatic_search(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable automatic search flag.
        """
        return pulumi.get(self, "enable_automatic_search")

    @enable_automatic_search.setter
    def enable_automatic_search(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_automatic_search", value)

    @property
    @pulumi.getter(name="enableInteractiveSearch")
    def enable_interactive_search(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable interactive search flag.
        """
        return pulumi.get(self, "enable_interactive_search")

    @enable_interactive_search.setter
    def enable_interactive_search(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_interactive_search", value)

    @property
    @pulumi.getter(name="enableRss")
    def enable_rss(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable RSS flag.
        """
        return pulumi.get(self, "enable_rss")

    @enable_rss.setter
    def enable_rss(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_rss", value)

    @property
    @pulumi.getter(name="minimumSeeders")
    def minimum_seeders(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum seeders.
        """
        return pulumi.get(self, "minimum_seeders")

    @minimum_seeders.setter
    def minimum_seeders(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minimum_seeders", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Indexer name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def passkey(self) -> Optional[pulumi.Input[str]]:
        """
        Passkey.
        """
        return pulumi.get(self, "passkey")

    @passkey.setter
    def passkey(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "passkey", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="rankedOnly")
    def ranked_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow ranked only.
        """
        return pulumi.get(self, "ranked_only")

    @ranked_only.setter
    def ranked_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ranked_only", value)

    @property
    @pulumi.getter(name="rssPasskey")
    def rss_passkey(self) -> Optional[pulumi.Input[str]]:
        """
        RSS passkey.
        """
        return pulumi.get(self, "rss_passkey")

    @rss_passkey.setter
    def rss_passkey(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rss_passkey", value)

    @property
    @pulumi.getter(name="seedRatio")
    def seed_ratio(self) -> Optional[pulumi.Input[float]]:
        """
        Seed ratio.
        """
        return pulumi.get(self, "seed_ratio")

    @seed_ratio.setter
    def seed_ratio(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "seed_ratio", value)

    @property
    @pulumi.getter(name="seedTime")
    def seed_time(self) -> Optional[pulumi.Input[int]]:
        """
        Seed time.
        """
        return pulumi.get(self, "seed_time")

    @seed_time.setter
    def seed_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "seed_time", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        List of associated tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="useFreeleechToken")
    def use_freeleech_token(self) -> Optional[pulumi.Input[bool]]:
        """
        Use freeleech token flag.
        """
        return pulumi.get(self, "use_freeleech_token")

    @use_freeleech_token.setter
    def use_freeleech_token(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_freeleech_token", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        User ID.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class _IndexerState:
    def __init__(__self__, *,
                 additional_parameters: Optional[pulumi.Input[str]] = None,
                 allow_zero_size: Optional[pulumi.Input[bool]] = None,
                 api_key: Optional[pulumi.Input[str]] = None,
                 api_path: Optional[pulumi.Input[str]] = None,
                 api_user: Optional[pulumi.Input[str]] = None,
                 base_url: Optional[pulumi.Input[str]] = None,
                 captcha_token: Optional[pulumi.Input[str]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 config_contract: Optional[pulumi.Input[str]] = None,
                 cookie: Optional[pulumi.Input[str]] = None,
                 delay: Optional[pulumi.Input[int]] = None,
                 discography_seed_time: Optional[pulumi.Input[int]] = None,
                 early_release_limit: Optional[pulumi.Input[int]] = None,
                 enable_automatic_search: Optional[pulumi.Input[bool]] = None,
                 enable_interactive_search: Optional[pulumi.Input[bool]] = None,
                 enable_rss: Optional[pulumi.Input[bool]] = None,
                 implementation: Optional[pulumi.Input[str]] = None,
                 minimum_seeders: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 passkey: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 ranked_only: Optional[pulumi.Input[bool]] = None,
                 rss_passkey: Optional[pulumi.Input[str]] = None,
                 seed_ratio: Optional[pulumi.Input[float]] = None,
                 seed_time: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 use_freeleech_token: Optional[pulumi.Input[bool]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Indexer resources.
        :param pulumi.Input[str] additional_parameters: Additional parameters.
        :param pulumi.Input[bool] allow_zero_size: Allow zero size files.
        :param pulumi.Input[str] api_key: API key.
        :param pulumi.Input[str] api_path: API path.
        :param pulumi.Input[str] api_user: API User.
        :param pulumi.Input[str] base_url: Base URL.
        :param pulumi.Input[str] captcha_token: Captcha token.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] categories: Series list.
        :param pulumi.Input[str] config_contract: Indexer configuration template.
        :param pulumi.Input[str] cookie: Cookie.
        :param pulumi.Input[int] delay: Delay before grabbing.
        :param pulumi.Input[int] discography_seed_time: Discography seed time.
        :param pulumi.Input[int] early_release_limit: Early release limit.
        :param pulumi.Input[bool] enable_automatic_search: Enable automatic search flag.
        :param pulumi.Input[bool] enable_interactive_search: Enable interactive search flag.
        :param pulumi.Input[bool] enable_rss: Enable RSS flag.
        :param pulumi.Input[str] implementation: Indexer implementation name.
        :param pulumi.Input[int] minimum_seeders: Minimum seeders.
        :param pulumi.Input[str] name: Indexer name.
        :param pulumi.Input[str] passkey: Passkey.
        :param pulumi.Input[str] password: Password.
        :param pulumi.Input[int] priority: Priority.
        :param pulumi.Input[str] protocol: Protocol. Valid values are 'usenet' and 'torrent'.
        :param pulumi.Input[bool] ranked_only: Allow ranked only.
        :param pulumi.Input[str] rss_passkey: RSS passkey.
        :param pulumi.Input[float] seed_ratio: Seed ratio.
        :param pulumi.Input[int] seed_time: Seed time.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        :param pulumi.Input[bool] use_freeleech_token: Use freeleech token flag.
        :param pulumi.Input[str] user_id: User ID.
        :param pulumi.Input[str] username: Username.
        """
        if additional_parameters is not None:
            pulumi.set(__self__, "additional_parameters", additional_parameters)
        if allow_zero_size is not None:
            pulumi.set(__self__, "allow_zero_size", allow_zero_size)
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if api_path is not None:
            pulumi.set(__self__, "api_path", api_path)
        if api_user is not None:
            pulumi.set(__self__, "api_user", api_user)
        if base_url is not None:
            pulumi.set(__self__, "base_url", base_url)
        if captcha_token is not None:
            pulumi.set(__self__, "captcha_token", captcha_token)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if config_contract is not None:
            pulumi.set(__self__, "config_contract", config_contract)
        if cookie is not None:
            pulumi.set(__self__, "cookie", cookie)
        if delay is not None:
            pulumi.set(__self__, "delay", delay)
        if discography_seed_time is not None:
            pulumi.set(__self__, "discography_seed_time", discography_seed_time)
        if early_release_limit is not None:
            pulumi.set(__self__, "early_release_limit", early_release_limit)
        if enable_automatic_search is not None:
            pulumi.set(__self__, "enable_automatic_search", enable_automatic_search)
        if enable_interactive_search is not None:
            pulumi.set(__self__, "enable_interactive_search", enable_interactive_search)
        if enable_rss is not None:
            pulumi.set(__self__, "enable_rss", enable_rss)
        if implementation is not None:
            pulumi.set(__self__, "implementation", implementation)
        if minimum_seeders is not None:
            pulumi.set(__self__, "minimum_seeders", minimum_seeders)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if passkey is not None:
            pulumi.set(__self__, "passkey", passkey)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if ranked_only is not None:
            pulumi.set(__self__, "ranked_only", ranked_only)
        if rss_passkey is not None:
            pulumi.set(__self__, "rss_passkey", rss_passkey)
        if seed_ratio is not None:
            pulumi.set(__self__, "seed_ratio", seed_ratio)
        if seed_time is not None:
            pulumi.set(__self__, "seed_time", seed_time)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if use_freeleech_token is not None:
            pulumi.set(__self__, "use_freeleech_token", use_freeleech_token)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="additionalParameters")
    def additional_parameters(self) -> Optional[pulumi.Input[str]]:
        """
        Additional parameters.
        """
        return pulumi.get(self, "additional_parameters")

    @additional_parameters.setter
    def additional_parameters(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "additional_parameters", value)

    @property
    @pulumi.getter(name="allowZeroSize")
    def allow_zero_size(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow zero size files.
        """
        return pulumi.get(self, "allow_zero_size")

    @allow_zero_size.setter
    def allow_zero_size(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_zero_size", value)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[str]]:
        """
        API key.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter(name="apiPath")
    def api_path(self) -> Optional[pulumi.Input[str]]:
        """
        API path.
        """
        return pulumi.get(self, "api_path")

    @api_path.setter
    def api_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_path", value)

    @property
    @pulumi.getter(name="apiUser")
    def api_user(self) -> Optional[pulumi.Input[str]]:
        """
        API User.
        """
        return pulumi.get(self, "api_user")

    @api_user.setter
    def api_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_user", value)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> Optional[pulumi.Input[str]]:
        """
        Base URL.
        """
        return pulumi.get(self, "base_url")

    @base_url.setter
    def base_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_url", value)

    @property
    @pulumi.getter(name="captchaToken")
    def captcha_token(self) -> Optional[pulumi.Input[str]]:
        """
        Captcha token.
        """
        return pulumi.get(self, "captcha_token")

    @captcha_token.setter
    def captcha_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "captcha_token", value)

    @property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Series list.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "categories", value)

    @property
    @pulumi.getter(name="configContract")
    def config_contract(self) -> Optional[pulumi.Input[str]]:
        """
        Indexer configuration template.
        """
        return pulumi.get(self, "config_contract")

    @config_contract.setter
    def config_contract(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_contract", value)

    @property
    @pulumi.getter
    def cookie(self) -> Optional[pulumi.Input[str]]:
        """
        Cookie.
        """
        return pulumi.get(self, "cookie")

    @cookie.setter
    def cookie(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cookie", value)

    @property
    @pulumi.getter
    def delay(self) -> Optional[pulumi.Input[int]]:
        """
        Delay before grabbing.
        """
        return pulumi.get(self, "delay")

    @delay.setter
    def delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "delay", value)

    @property
    @pulumi.getter(name="discographySeedTime")
    def discography_seed_time(self) -> Optional[pulumi.Input[int]]:
        """
        Discography seed time.
        """
        return pulumi.get(self, "discography_seed_time")

    @discography_seed_time.setter
    def discography_seed_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "discography_seed_time", value)

    @property
    @pulumi.getter(name="earlyReleaseLimit")
    def early_release_limit(self) -> Optional[pulumi.Input[int]]:
        """
        Early release limit.
        """
        return pulumi.get(self, "early_release_limit")

    @early_release_limit.setter
    def early_release_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "early_release_limit", value)

    @property
    @pulumi.getter(name="enableAutomaticSearch")
    def enable_automatic_search(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable automatic search flag.
        """
        return pulumi.get(self, "enable_automatic_search")

    @enable_automatic_search.setter
    def enable_automatic_search(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_automatic_search", value)

    @property
    @pulumi.getter(name="enableInteractiveSearch")
    def enable_interactive_search(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable interactive search flag.
        """
        return pulumi.get(self, "enable_interactive_search")

    @enable_interactive_search.setter
    def enable_interactive_search(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_interactive_search", value)

    @property
    @pulumi.getter(name="enableRss")
    def enable_rss(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable RSS flag.
        """
        return pulumi.get(self, "enable_rss")

    @enable_rss.setter
    def enable_rss(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_rss", value)

    @property
    @pulumi.getter
    def implementation(self) -> Optional[pulumi.Input[str]]:
        """
        Indexer implementation name.
        """
        return pulumi.get(self, "implementation")

    @implementation.setter
    def implementation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "implementation", value)

    @property
    @pulumi.getter(name="minimumSeeders")
    def minimum_seeders(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum seeders.
        """
        return pulumi.get(self, "minimum_seeders")

    @minimum_seeders.setter
    def minimum_seeders(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minimum_seeders", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Indexer name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def passkey(self) -> Optional[pulumi.Input[str]]:
        """
        Passkey.
        """
        return pulumi.get(self, "passkey")

    @passkey.setter
    def passkey(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "passkey", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Protocol. Valid values are 'usenet' and 'torrent'.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="rankedOnly")
    def ranked_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow ranked only.
        """
        return pulumi.get(self, "ranked_only")

    @ranked_only.setter
    def ranked_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ranked_only", value)

    @property
    @pulumi.getter(name="rssPasskey")
    def rss_passkey(self) -> Optional[pulumi.Input[str]]:
        """
        RSS passkey.
        """
        return pulumi.get(self, "rss_passkey")

    @rss_passkey.setter
    def rss_passkey(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rss_passkey", value)

    @property
    @pulumi.getter(name="seedRatio")
    def seed_ratio(self) -> Optional[pulumi.Input[float]]:
        """
        Seed ratio.
        """
        return pulumi.get(self, "seed_ratio")

    @seed_ratio.setter
    def seed_ratio(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "seed_ratio", value)

    @property
    @pulumi.getter(name="seedTime")
    def seed_time(self) -> Optional[pulumi.Input[int]]:
        """
        Seed time.
        """
        return pulumi.get(self, "seed_time")

    @seed_time.setter
    def seed_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "seed_time", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        List of associated tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="useFreeleechToken")
    def use_freeleech_token(self) -> Optional[pulumi.Input[bool]]:
        """
        Use freeleech token flag.
        """
        return pulumi.get(self, "use_freeleech_token")

    @use_freeleech_token.setter
    def use_freeleech_token(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_freeleech_token", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        User ID.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


class Indexer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_parameters: Optional[pulumi.Input[str]] = None,
                 allow_zero_size: Optional[pulumi.Input[bool]] = None,
                 api_key: Optional[pulumi.Input[str]] = None,
                 api_path: Optional[pulumi.Input[str]] = None,
                 api_user: Optional[pulumi.Input[str]] = None,
                 base_url: Optional[pulumi.Input[str]] = None,
                 captcha_token: Optional[pulumi.Input[str]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 config_contract: Optional[pulumi.Input[str]] = None,
                 cookie: Optional[pulumi.Input[str]] = None,
                 delay: Optional[pulumi.Input[int]] = None,
                 discography_seed_time: Optional[pulumi.Input[int]] = None,
                 early_release_limit: Optional[pulumi.Input[int]] = None,
                 enable_automatic_search: Optional[pulumi.Input[bool]] = None,
                 enable_interactive_search: Optional[pulumi.Input[bool]] = None,
                 enable_rss: Optional[pulumi.Input[bool]] = None,
                 implementation: Optional[pulumi.Input[str]] = None,
                 minimum_seeders: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 passkey: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 ranked_only: Optional[pulumi.Input[bool]] = None,
                 rss_passkey: Optional[pulumi.Input[str]] = None,
                 seed_ratio: Optional[pulumi.Input[float]] = None,
                 seed_time: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 use_freeleech_token: Optional[pulumi.Input[bool]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        <!-- subcategory:Indexers -->Generic Indexer resource. When possible use a specific resource instead.
        For more information refer to [Indexer](https://wiki.servarr.com/lidarr/settings#indexers) documentation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.indexers.Indexer("example",
            api_path="/api",
            base_url="https://lolo.sickbeard.com",
            categories=[
                8000,
                5000,
            ],
            config_contract="NewznabSettings",
            enable_automatic_search=True,
            implementation="Newznab",
            protocol="usenet",
            tags=[
                1,
                2,
            ])
        ```

        ## Import

        import using the API/UI ID

        ```sh
         $ pulumi import lidarr:Indexers/indexer:Indexer example 1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] additional_parameters: Additional parameters.
        :param pulumi.Input[bool] allow_zero_size: Allow zero size files.
        :param pulumi.Input[str] api_key: API key.
        :param pulumi.Input[str] api_path: API path.
        :param pulumi.Input[str] api_user: API User.
        :param pulumi.Input[str] base_url: Base URL.
        :param pulumi.Input[str] captcha_token: Captcha token.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] categories: Series list.
        :param pulumi.Input[str] config_contract: Indexer configuration template.
        :param pulumi.Input[str] cookie: Cookie.
        :param pulumi.Input[int] delay: Delay before grabbing.
        :param pulumi.Input[int] discography_seed_time: Discography seed time.
        :param pulumi.Input[int] early_release_limit: Early release limit.
        :param pulumi.Input[bool] enable_automatic_search: Enable automatic search flag.
        :param pulumi.Input[bool] enable_interactive_search: Enable interactive search flag.
        :param pulumi.Input[bool] enable_rss: Enable RSS flag.
        :param pulumi.Input[str] implementation: Indexer implementation name.
        :param pulumi.Input[int] minimum_seeders: Minimum seeders.
        :param pulumi.Input[str] name: Indexer name.
        :param pulumi.Input[str] passkey: Passkey.
        :param pulumi.Input[str] password: Password.
        :param pulumi.Input[int] priority: Priority.
        :param pulumi.Input[str] protocol: Protocol. Valid values are 'usenet' and 'torrent'.
        :param pulumi.Input[bool] ranked_only: Allow ranked only.
        :param pulumi.Input[str] rss_passkey: RSS passkey.
        :param pulumi.Input[float] seed_ratio: Seed ratio.
        :param pulumi.Input[int] seed_time: Seed time.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        :param pulumi.Input[bool] use_freeleech_token: Use freeleech token flag.
        :param pulumi.Input[str] user_id: User ID.
        :param pulumi.Input[str] username: Username.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IndexerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        <!-- subcategory:Indexers -->Generic Indexer resource. When possible use a specific resource instead.
        For more information refer to [Indexer](https://wiki.servarr.com/lidarr/settings#indexers) documentation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.indexers.Indexer("example",
            api_path="/api",
            base_url="https://lolo.sickbeard.com",
            categories=[
                8000,
                5000,
            ],
            config_contract="NewznabSettings",
            enable_automatic_search=True,
            implementation="Newznab",
            protocol="usenet",
            tags=[
                1,
                2,
            ])
        ```

        ## Import

        import using the API/UI ID

        ```sh
         $ pulumi import lidarr:Indexers/indexer:Indexer example 1
        ```

        :param str resource_name: The name of the resource.
        :param IndexerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IndexerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_parameters: Optional[pulumi.Input[str]] = None,
                 allow_zero_size: Optional[pulumi.Input[bool]] = None,
                 api_key: Optional[pulumi.Input[str]] = None,
                 api_path: Optional[pulumi.Input[str]] = None,
                 api_user: Optional[pulumi.Input[str]] = None,
                 base_url: Optional[pulumi.Input[str]] = None,
                 captcha_token: Optional[pulumi.Input[str]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 config_contract: Optional[pulumi.Input[str]] = None,
                 cookie: Optional[pulumi.Input[str]] = None,
                 delay: Optional[pulumi.Input[int]] = None,
                 discography_seed_time: Optional[pulumi.Input[int]] = None,
                 early_release_limit: Optional[pulumi.Input[int]] = None,
                 enable_automatic_search: Optional[pulumi.Input[bool]] = None,
                 enable_interactive_search: Optional[pulumi.Input[bool]] = None,
                 enable_rss: Optional[pulumi.Input[bool]] = None,
                 implementation: Optional[pulumi.Input[str]] = None,
                 minimum_seeders: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 passkey: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 ranked_only: Optional[pulumi.Input[bool]] = None,
                 rss_passkey: Optional[pulumi.Input[str]] = None,
                 seed_ratio: Optional[pulumi.Input[float]] = None,
                 seed_time: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 use_freeleech_token: Optional[pulumi.Input[bool]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IndexerArgs.__new__(IndexerArgs)

            __props__.__dict__["additional_parameters"] = additional_parameters
            __props__.__dict__["allow_zero_size"] = allow_zero_size
            __props__.__dict__["api_key"] = None if api_key is None else pulumi.Output.secret(api_key)
            __props__.__dict__["api_path"] = api_path
            __props__.__dict__["api_user"] = api_user
            __props__.__dict__["base_url"] = base_url
            __props__.__dict__["captcha_token"] = captcha_token
            __props__.__dict__["categories"] = categories
            if config_contract is None and not opts.urn:
                raise TypeError("Missing required property 'config_contract'")
            __props__.__dict__["config_contract"] = config_contract
            __props__.__dict__["cookie"] = cookie
            __props__.__dict__["delay"] = delay
            __props__.__dict__["discography_seed_time"] = discography_seed_time
            __props__.__dict__["early_release_limit"] = early_release_limit
            __props__.__dict__["enable_automatic_search"] = enable_automatic_search
            __props__.__dict__["enable_interactive_search"] = enable_interactive_search
            __props__.__dict__["enable_rss"] = enable_rss
            if implementation is None and not opts.urn:
                raise TypeError("Missing required property 'implementation'")
            __props__.__dict__["implementation"] = implementation
            __props__.__dict__["minimum_seeders"] = minimum_seeders
            __props__.__dict__["name"] = name
            __props__.__dict__["passkey"] = None if passkey is None else pulumi.Output.secret(passkey)
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["priority"] = priority
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["ranked_only"] = ranked_only
            __props__.__dict__["rss_passkey"] = rss_passkey
            __props__.__dict__["seed_ratio"] = seed_ratio
            __props__.__dict__["seed_time"] = seed_time
            __props__.__dict__["tags"] = tags
            __props__.__dict__["use_freeleech_token"] = use_freeleech_token
            __props__.__dict__["user_id"] = user_id
            __props__.__dict__["username"] = username
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["apiKey", "passkey", "password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Indexer, __self__).__init__(
            'lidarr:Indexers/indexer:Indexer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_parameters: Optional[pulumi.Input[str]] = None,
            allow_zero_size: Optional[pulumi.Input[bool]] = None,
            api_key: Optional[pulumi.Input[str]] = None,
            api_path: Optional[pulumi.Input[str]] = None,
            api_user: Optional[pulumi.Input[str]] = None,
            base_url: Optional[pulumi.Input[str]] = None,
            captcha_token: Optional[pulumi.Input[str]] = None,
            categories: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            config_contract: Optional[pulumi.Input[str]] = None,
            cookie: Optional[pulumi.Input[str]] = None,
            delay: Optional[pulumi.Input[int]] = None,
            discography_seed_time: Optional[pulumi.Input[int]] = None,
            early_release_limit: Optional[pulumi.Input[int]] = None,
            enable_automatic_search: Optional[pulumi.Input[bool]] = None,
            enable_interactive_search: Optional[pulumi.Input[bool]] = None,
            enable_rss: Optional[pulumi.Input[bool]] = None,
            implementation: Optional[pulumi.Input[str]] = None,
            minimum_seeders: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            passkey: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            protocol: Optional[pulumi.Input[str]] = None,
            ranked_only: Optional[pulumi.Input[bool]] = None,
            rss_passkey: Optional[pulumi.Input[str]] = None,
            seed_ratio: Optional[pulumi.Input[float]] = None,
            seed_time: Optional[pulumi.Input[int]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            use_freeleech_token: Optional[pulumi.Input[bool]] = None,
            user_id: Optional[pulumi.Input[str]] = None,
            username: Optional[pulumi.Input[str]] = None) -> 'Indexer':
        """
        Get an existing Indexer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] additional_parameters: Additional parameters.
        :param pulumi.Input[bool] allow_zero_size: Allow zero size files.
        :param pulumi.Input[str] api_key: API key.
        :param pulumi.Input[str] api_path: API path.
        :param pulumi.Input[str] api_user: API User.
        :param pulumi.Input[str] base_url: Base URL.
        :param pulumi.Input[str] captcha_token: Captcha token.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] categories: Series list.
        :param pulumi.Input[str] config_contract: Indexer configuration template.
        :param pulumi.Input[str] cookie: Cookie.
        :param pulumi.Input[int] delay: Delay before grabbing.
        :param pulumi.Input[int] discography_seed_time: Discography seed time.
        :param pulumi.Input[int] early_release_limit: Early release limit.
        :param pulumi.Input[bool] enable_automatic_search: Enable automatic search flag.
        :param pulumi.Input[bool] enable_interactive_search: Enable interactive search flag.
        :param pulumi.Input[bool] enable_rss: Enable RSS flag.
        :param pulumi.Input[str] implementation: Indexer implementation name.
        :param pulumi.Input[int] minimum_seeders: Minimum seeders.
        :param pulumi.Input[str] name: Indexer name.
        :param pulumi.Input[str] passkey: Passkey.
        :param pulumi.Input[str] password: Password.
        :param pulumi.Input[int] priority: Priority.
        :param pulumi.Input[str] protocol: Protocol. Valid values are 'usenet' and 'torrent'.
        :param pulumi.Input[bool] ranked_only: Allow ranked only.
        :param pulumi.Input[str] rss_passkey: RSS passkey.
        :param pulumi.Input[float] seed_ratio: Seed ratio.
        :param pulumi.Input[int] seed_time: Seed time.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        :param pulumi.Input[bool] use_freeleech_token: Use freeleech token flag.
        :param pulumi.Input[str] user_id: User ID.
        :param pulumi.Input[str] username: Username.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IndexerState.__new__(_IndexerState)

        __props__.__dict__["additional_parameters"] = additional_parameters
        __props__.__dict__["allow_zero_size"] = allow_zero_size
        __props__.__dict__["api_key"] = api_key
        __props__.__dict__["api_path"] = api_path
        __props__.__dict__["api_user"] = api_user
        __props__.__dict__["base_url"] = base_url
        __props__.__dict__["captcha_token"] = captcha_token
        __props__.__dict__["categories"] = categories
        __props__.__dict__["config_contract"] = config_contract
        __props__.__dict__["cookie"] = cookie
        __props__.__dict__["delay"] = delay
        __props__.__dict__["discography_seed_time"] = discography_seed_time
        __props__.__dict__["early_release_limit"] = early_release_limit
        __props__.__dict__["enable_automatic_search"] = enable_automatic_search
        __props__.__dict__["enable_interactive_search"] = enable_interactive_search
        __props__.__dict__["enable_rss"] = enable_rss
        __props__.__dict__["implementation"] = implementation
        __props__.__dict__["minimum_seeders"] = minimum_seeders
        __props__.__dict__["name"] = name
        __props__.__dict__["passkey"] = passkey
        __props__.__dict__["password"] = password
        __props__.__dict__["priority"] = priority
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["ranked_only"] = ranked_only
        __props__.__dict__["rss_passkey"] = rss_passkey
        __props__.__dict__["seed_ratio"] = seed_ratio
        __props__.__dict__["seed_time"] = seed_time
        __props__.__dict__["tags"] = tags
        __props__.__dict__["use_freeleech_token"] = use_freeleech_token
        __props__.__dict__["user_id"] = user_id
        __props__.__dict__["username"] = username
        return Indexer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalParameters")
    def additional_parameters(self) -> pulumi.Output[str]:
        """
        Additional parameters.
        """
        return pulumi.get(self, "additional_parameters")

    @property
    @pulumi.getter(name="allowZeroSize")
    def allow_zero_size(self) -> pulumi.Output[bool]:
        """
        Allow zero size files.
        """
        return pulumi.get(self, "allow_zero_size")

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Output[str]:
        """
        API key.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="apiPath")
    def api_path(self) -> pulumi.Output[str]:
        """
        API path.
        """
        return pulumi.get(self, "api_path")

    @property
    @pulumi.getter(name="apiUser")
    def api_user(self) -> pulumi.Output[str]:
        """
        API User.
        """
        return pulumi.get(self, "api_user")

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> pulumi.Output[str]:
        """
        Base URL.
        """
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter(name="captchaToken")
    def captcha_token(self) -> pulumi.Output[str]:
        """
        Captcha token.
        """
        return pulumi.get(self, "captcha_token")

    @property
    @pulumi.getter
    def categories(self) -> pulumi.Output[Sequence[int]]:
        """
        Series list.
        """
        return pulumi.get(self, "categories")

    @property
    @pulumi.getter(name="configContract")
    def config_contract(self) -> pulumi.Output[str]:
        """
        Indexer configuration template.
        """
        return pulumi.get(self, "config_contract")

    @property
    @pulumi.getter
    def cookie(self) -> pulumi.Output[str]:
        """
        Cookie.
        """
        return pulumi.get(self, "cookie")

    @property
    @pulumi.getter
    def delay(self) -> pulumi.Output[int]:
        """
        Delay before grabbing.
        """
        return pulumi.get(self, "delay")

    @property
    @pulumi.getter(name="discographySeedTime")
    def discography_seed_time(self) -> pulumi.Output[int]:
        """
        Discography seed time.
        """
        return pulumi.get(self, "discography_seed_time")

    @property
    @pulumi.getter(name="earlyReleaseLimit")
    def early_release_limit(self) -> pulumi.Output[int]:
        """
        Early release limit.
        """
        return pulumi.get(self, "early_release_limit")

    @property
    @pulumi.getter(name="enableAutomaticSearch")
    def enable_automatic_search(self) -> pulumi.Output[bool]:
        """
        Enable automatic search flag.
        """
        return pulumi.get(self, "enable_automatic_search")

    @property
    @pulumi.getter(name="enableInteractiveSearch")
    def enable_interactive_search(self) -> pulumi.Output[bool]:
        """
        Enable interactive search flag.
        """
        return pulumi.get(self, "enable_interactive_search")

    @property
    @pulumi.getter(name="enableRss")
    def enable_rss(self) -> pulumi.Output[bool]:
        """
        Enable RSS flag.
        """
        return pulumi.get(self, "enable_rss")

    @property
    @pulumi.getter
    def implementation(self) -> pulumi.Output[str]:
        """
        Indexer implementation name.
        """
        return pulumi.get(self, "implementation")

    @property
    @pulumi.getter(name="minimumSeeders")
    def minimum_seeders(self) -> pulumi.Output[int]:
        """
        Minimum seeders.
        """
        return pulumi.get(self, "minimum_seeders")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Indexer name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def passkey(self) -> pulumi.Output[str]:
        """
        Passkey.
        """
        return pulumi.get(self, "passkey")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        Password.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[int]:
        """
        Priority.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[str]:
        """
        Protocol. Valid values are 'usenet' and 'torrent'.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="rankedOnly")
    def ranked_only(self) -> pulumi.Output[bool]:
        """
        Allow ranked only.
        """
        return pulumi.get(self, "ranked_only")

    @property
    @pulumi.getter(name="rssPasskey")
    def rss_passkey(self) -> pulumi.Output[str]:
        """
        RSS passkey.
        """
        return pulumi.get(self, "rss_passkey")

    @property
    @pulumi.getter(name="seedRatio")
    def seed_ratio(self) -> pulumi.Output[float]:
        """
        Seed ratio.
        """
        return pulumi.get(self, "seed_ratio")

    @property
    @pulumi.getter(name="seedTime")
    def seed_time(self) -> pulumi.Output[int]:
        """
        Seed time.
        """
        return pulumi.get(self, "seed_time")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[int]]:
        """
        List of associated tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="useFreeleechToken")
    def use_freeleech_token(self) -> pulumi.Output[bool]:
        """
        Use freeleech token flag.
        """
        return pulumi.get(self, "use_freeleech_token")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[str]:
        """
        User ID.
        """
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        Username.
        """
        return pulumi.get(self, "username")

