# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['HeadphonesArgs', 'Headphones']

@pulumi.input_type
class HeadphonesArgs:
    def __init__(__self__, *,
                 categories: pulumi.Input[Sequence[pulumi.Input[int]]],
                 password: pulumi.Input[str],
                 username: pulumi.Input[str],
                 early_release_limit: Optional[pulumi.Input[int]] = None,
                 enable_automatic_search: Optional[pulumi.Input[bool]] = None,
                 enable_interactive_search: Optional[pulumi.Input[bool]] = None,
                 enable_rss: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None):
        """
        The set of arguments for constructing a Headphones resource.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] categories: Series list.
        :param pulumi.Input[str] password: Password.
        :param pulumi.Input[str] username: Username.
        :param pulumi.Input[int] early_release_limit: Early release limit.
        :param pulumi.Input[bool] enable_automatic_search: Enable automatic search flag.
        :param pulumi.Input[bool] enable_interactive_search: Enable interactive search flag.
        :param pulumi.Input[bool] enable_rss: Enable RSS flag.
        :param pulumi.Input[str] name: IndexerHeadphones name.
        :param pulumi.Input[int] priority: Priority.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        """
        pulumi.set(__self__, "categories", categories)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if early_release_limit is not None:
            pulumi.set(__self__, "early_release_limit", early_release_limit)
        if enable_automatic_search is not None:
            pulumi.set(__self__, "enable_automatic_search", enable_automatic_search)
        if enable_interactive_search is not None:
            pulumi.set(__self__, "enable_interactive_search", enable_interactive_search)
        if enable_rss is not None:
            pulumi.set(__self__, "enable_rss", enable_rss)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def categories(self) -> pulumi.Input[Sequence[pulumi.Input[int]]]:
        """
        Series list.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: pulumi.Input[Sequence[pulumi.Input[int]]]):
        pulumi.set(self, "categories", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        Password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        Username.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="earlyReleaseLimit")
    def early_release_limit(self) -> Optional[pulumi.Input[int]]:
        """
        Early release limit.
        """
        return pulumi.get(self, "early_release_limit")

    @early_release_limit.setter
    def early_release_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "early_release_limit", value)

    @property
    @pulumi.getter(name="enableAutomaticSearch")
    def enable_automatic_search(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable automatic search flag.
        """
        return pulumi.get(self, "enable_automatic_search")

    @enable_automatic_search.setter
    def enable_automatic_search(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_automatic_search", value)

    @property
    @pulumi.getter(name="enableInteractiveSearch")
    def enable_interactive_search(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable interactive search flag.
        """
        return pulumi.get(self, "enable_interactive_search")

    @enable_interactive_search.setter
    def enable_interactive_search(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_interactive_search", value)

    @property
    @pulumi.getter(name="enableRss")
    def enable_rss(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable RSS flag.
        """
        return pulumi.get(self, "enable_rss")

    @enable_rss.setter
    def enable_rss(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_rss", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        IndexerHeadphones name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        List of associated tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _HeadphonesState:
    def __init__(__self__, *,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 early_release_limit: Optional[pulumi.Input[int]] = None,
                 enable_automatic_search: Optional[pulumi.Input[bool]] = None,
                 enable_interactive_search: Optional[pulumi.Input[bool]] = None,
                 enable_rss: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Headphones resources.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] categories: Series list.
        :param pulumi.Input[int] early_release_limit: Early release limit.
        :param pulumi.Input[bool] enable_automatic_search: Enable automatic search flag.
        :param pulumi.Input[bool] enable_interactive_search: Enable interactive search flag.
        :param pulumi.Input[bool] enable_rss: Enable RSS flag.
        :param pulumi.Input[str] name: IndexerHeadphones name.
        :param pulumi.Input[str] password: Password.
        :param pulumi.Input[int] priority: Priority.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        :param pulumi.Input[str] username: Username.
        """
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if early_release_limit is not None:
            pulumi.set(__self__, "early_release_limit", early_release_limit)
        if enable_automatic_search is not None:
            pulumi.set(__self__, "enable_automatic_search", enable_automatic_search)
        if enable_interactive_search is not None:
            pulumi.set(__self__, "enable_interactive_search", enable_interactive_search)
        if enable_rss is not None:
            pulumi.set(__self__, "enable_rss", enable_rss)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Series list.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "categories", value)

    @property
    @pulumi.getter(name="earlyReleaseLimit")
    def early_release_limit(self) -> Optional[pulumi.Input[int]]:
        """
        Early release limit.
        """
        return pulumi.get(self, "early_release_limit")

    @early_release_limit.setter
    def early_release_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "early_release_limit", value)

    @property
    @pulumi.getter(name="enableAutomaticSearch")
    def enable_automatic_search(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable automatic search flag.
        """
        return pulumi.get(self, "enable_automatic_search")

    @enable_automatic_search.setter
    def enable_automatic_search(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_automatic_search", value)

    @property
    @pulumi.getter(name="enableInteractiveSearch")
    def enable_interactive_search(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable interactive search flag.
        """
        return pulumi.get(self, "enable_interactive_search")

    @enable_interactive_search.setter
    def enable_interactive_search(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_interactive_search", value)

    @property
    @pulumi.getter(name="enableRss")
    def enable_rss(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable RSS flag.
        """
        return pulumi.get(self, "enable_rss")

    @enable_rss.setter
    def enable_rss(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_rss", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        IndexerHeadphones name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        List of associated tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


class Headphones(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 early_release_limit: Optional[pulumi.Input[int]] = None,
                 enable_automatic_search: Optional[pulumi.Input[bool]] = None,
                 enable_interactive_search: Optional[pulumi.Input[bool]] = None,
                 enable_rss: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        <!-- subcategory:Indexers -->Indexer Headphones resource.
        For more information refer to [Indexer](https://wiki.servarr.com/lidarr/settings#indexers) and [Headphones](https://wiki.servarr.com/lidarr/supported#headphones).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.indexers.Headphones("example",
            categories=[
                3000,
                3010,
                3020,
                3030,
                3040,
            ],
            enable_automatic_search=True,
            password="Pass",
            tags=[
                1,
                2,
            ],
            username="User")
        ```

        ## Import

        import using the API/UI ID

        ```sh
         $ pulumi import lidarr:Indexers/headphones:Headphones example 1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] categories: Series list.
        :param pulumi.Input[int] early_release_limit: Early release limit.
        :param pulumi.Input[bool] enable_automatic_search: Enable automatic search flag.
        :param pulumi.Input[bool] enable_interactive_search: Enable interactive search flag.
        :param pulumi.Input[bool] enable_rss: Enable RSS flag.
        :param pulumi.Input[str] name: IndexerHeadphones name.
        :param pulumi.Input[str] password: Password.
        :param pulumi.Input[int] priority: Priority.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        :param pulumi.Input[str] username: Username.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HeadphonesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        <!-- subcategory:Indexers -->Indexer Headphones resource.
        For more information refer to [Indexer](https://wiki.servarr.com/lidarr/settings#indexers) and [Headphones](https://wiki.servarr.com/lidarr/supported#headphones).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.indexers.Headphones("example",
            categories=[
                3000,
                3010,
                3020,
                3030,
                3040,
            ],
            enable_automatic_search=True,
            password="Pass",
            tags=[
                1,
                2,
            ],
            username="User")
        ```

        ## Import

        import using the API/UI ID

        ```sh
         $ pulumi import lidarr:Indexers/headphones:Headphones example 1
        ```

        :param str resource_name: The name of the resource.
        :param HeadphonesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HeadphonesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 early_release_limit: Optional[pulumi.Input[int]] = None,
                 enable_automatic_search: Optional[pulumi.Input[bool]] = None,
                 enable_interactive_search: Optional[pulumi.Input[bool]] = None,
                 enable_rss: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HeadphonesArgs.__new__(HeadphonesArgs)

            if categories is None and not opts.urn:
                raise TypeError("Missing required property 'categories'")
            __props__.__dict__["categories"] = categories
            __props__.__dict__["early_release_limit"] = early_release_limit
            __props__.__dict__["enable_automatic_search"] = enable_automatic_search
            __props__.__dict__["enable_interactive_search"] = enable_interactive_search
            __props__.__dict__["enable_rss"] = enable_rss
            __props__.__dict__["name"] = name
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["priority"] = priority
            __props__.__dict__["tags"] = tags
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Headphones, __self__).__init__(
            'lidarr:Indexers/headphones:Headphones',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            categories: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            early_release_limit: Optional[pulumi.Input[int]] = None,
            enable_automatic_search: Optional[pulumi.Input[bool]] = None,
            enable_interactive_search: Optional[pulumi.Input[bool]] = None,
            enable_rss: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            username: Optional[pulumi.Input[str]] = None) -> 'Headphones':
        """
        Get an existing Headphones resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] categories: Series list.
        :param pulumi.Input[int] early_release_limit: Early release limit.
        :param pulumi.Input[bool] enable_automatic_search: Enable automatic search flag.
        :param pulumi.Input[bool] enable_interactive_search: Enable interactive search flag.
        :param pulumi.Input[bool] enable_rss: Enable RSS flag.
        :param pulumi.Input[str] name: IndexerHeadphones name.
        :param pulumi.Input[str] password: Password.
        :param pulumi.Input[int] priority: Priority.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        :param pulumi.Input[str] username: Username.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HeadphonesState.__new__(_HeadphonesState)

        __props__.__dict__["categories"] = categories
        __props__.__dict__["early_release_limit"] = early_release_limit
        __props__.__dict__["enable_automatic_search"] = enable_automatic_search
        __props__.__dict__["enable_interactive_search"] = enable_interactive_search
        __props__.__dict__["enable_rss"] = enable_rss
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["priority"] = priority
        __props__.__dict__["tags"] = tags
        __props__.__dict__["username"] = username
        return Headphones(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def categories(self) -> pulumi.Output[Sequence[int]]:
        """
        Series list.
        """
        return pulumi.get(self, "categories")

    @property
    @pulumi.getter(name="earlyReleaseLimit")
    def early_release_limit(self) -> pulumi.Output[int]:
        """
        Early release limit.
        """
        return pulumi.get(self, "early_release_limit")

    @property
    @pulumi.getter(name="enableAutomaticSearch")
    def enable_automatic_search(self) -> pulumi.Output[bool]:
        """
        Enable automatic search flag.
        """
        return pulumi.get(self, "enable_automatic_search")

    @property
    @pulumi.getter(name="enableInteractiveSearch")
    def enable_interactive_search(self) -> pulumi.Output[bool]:
        """
        Enable interactive search flag.
        """
        return pulumi.get(self, "enable_interactive_search")

    @property
    @pulumi.getter(name="enableRss")
    def enable_rss(self) -> pulumi.Output[bool]:
        """
        Enable RSS flag.
        """
        return pulumi.get(self, "enable_rss")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        IndexerHeadphones name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        Password.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[int]:
        """
        Priority.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[int]]:
        """
        List of associated tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        Username.
        """
        return pulumi.get(self, "username")

