# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ConfigArgs', 'Config']

@pulumi.input_type
class ConfigArgs:
    def __init__(__self__, *,
                 maximum_size: pulumi.Input[int],
                 minimum_age: pulumi.Input[int],
                 retention: pulumi.Input[int],
                 rss_sync_interval: pulumi.Input[int]):
        """
        The set of arguments for constructing a Config resource.
        :param pulumi.Input[int] maximum_size: Maximum size.
        :param pulumi.Input[int] minimum_age: Minimum age.
        :param pulumi.Input[int] retention: Retention.
        :param pulumi.Input[int] rss_sync_interval: RSS sync interval.
        """
        pulumi.set(__self__, "maximum_size", maximum_size)
        pulumi.set(__self__, "minimum_age", minimum_age)
        pulumi.set(__self__, "retention", retention)
        pulumi.set(__self__, "rss_sync_interval", rss_sync_interval)

    @property
    @pulumi.getter(name="maximumSize")
    def maximum_size(self) -> pulumi.Input[int]:
        """
        Maximum size.
        """
        return pulumi.get(self, "maximum_size")

    @maximum_size.setter
    def maximum_size(self, value: pulumi.Input[int]):
        pulumi.set(self, "maximum_size", value)

    @property
    @pulumi.getter(name="minimumAge")
    def minimum_age(self) -> pulumi.Input[int]:
        """
        Minimum age.
        """
        return pulumi.get(self, "minimum_age")

    @minimum_age.setter
    def minimum_age(self, value: pulumi.Input[int]):
        pulumi.set(self, "minimum_age", value)

    @property
    @pulumi.getter
    def retention(self) -> pulumi.Input[int]:
        """
        Retention.
        """
        return pulumi.get(self, "retention")

    @retention.setter
    def retention(self, value: pulumi.Input[int]):
        pulumi.set(self, "retention", value)

    @property
    @pulumi.getter(name="rssSyncInterval")
    def rss_sync_interval(self) -> pulumi.Input[int]:
        """
        RSS sync interval.
        """
        return pulumi.get(self, "rss_sync_interval")

    @rss_sync_interval.setter
    def rss_sync_interval(self, value: pulumi.Input[int]):
        pulumi.set(self, "rss_sync_interval", value)


@pulumi.input_type
class _ConfigState:
    def __init__(__self__, *,
                 maximum_size: Optional[pulumi.Input[int]] = None,
                 minimum_age: Optional[pulumi.Input[int]] = None,
                 retention: Optional[pulumi.Input[int]] = None,
                 rss_sync_interval: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Config resources.
        :param pulumi.Input[int] maximum_size: Maximum size.
        :param pulumi.Input[int] minimum_age: Minimum age.
        :param pulumi.Input[int] retention: Retention.
        :param pulumi.Input[int] rss_sync_interval: RSS sync interval.
        """
        if maximum_size is not None:
            pulumi.set(__self__, "maximum_size", maximum_size)
        if minimum_age is not None:
            pulumi.set(__self__, "minimum_age", minimum_age)
        if retention is not None:
            pulumi.set(__self__, "retention", retention)
        if rss_sync_interval is not None:
            pulumi.set(__self__, "rss_sync_interval", rss_sync_interval)

    @property
    @pulumi.getter(name="maximumSize")
    def maximum_size(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum size.
        """
        return pulumi.get(self, "maximum_size")

    @maximum_size.setter
    def maximum_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maximum_size", value)

    @property
    @pulumi.getter(name="minimumAge")
    def minimum_age(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum age.
        """
        return pulumi.get(self, "minimum_age")

    @minimum_age.setter
    def minimum_age(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minimum_age", value)

    @property
    @pulumi.getter
    def retention(self) -> Optional[pulumi.Input[int]]:
        """
        Retention.
        """
        return pulumi.get(self, "retention")

    @retention.setter
    def retention(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention", value)

    @property
    @pulumi.getter(name="rssSyncInterval")
    def rss_sync_interval(self) -> Optional[pulumi.Input[int]]:
        """
        RSS sync interval.
        """
        return pulumi.get(self, "rss_sync_interval")

    @rss_sync_interval.setter
    def rss_sync_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "rss_sync_interval", value)


class Config(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 maximum_size: Optional[pulumi.Input[int]] = None,
                 minimum_age: Optional[pulumi.Input[int]] = None,
                 retention: Optional[pulumi.Input[int]] = None,
                 rss_sync_interval: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        <!-- subcategory:Indexers -->Indexer Config resource.
        For more information refer to [Indexer](https://wiki.servarr.com/lidarr/settings#options) documentation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.indexers.Config("example",
            maximum_size=0,
            minimum_age=0,
            retention=0,
            rss_sync_interval=25)
        ```

        ## Import

        import does not need parameters

        ```sh
         $ pulumi import lidarr:Indexers/config:Config example ""
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] maximum_size: Maximum size.
        :param pulumi.Input[int] minimum_age: Minimum age.
        :param pulumi.Input[int] retention: Retention.
        :param pulumi.Input[int] rss_sync_interval: RSS sync interval.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        <!-- subcategory:Indexers -->Indexer Config resource.
        For more information refer to [Indexer](https://wiki.servarr.com/lidarr/settings#options) documentation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.indexers.Config("example",
            maximum_size=0,
            minimum_age=0,
            retention=0,
            rss_sync_interval=25)
        ```

        ## Import

        import does not need parameters

        ```sh
         $ pulumi import lidarr:Indexers/config:Config example ""
        ```

        :param str resource_name: The name of the resource.
        :param ConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 maximum_size: Optional[pulumi.Input[int]] = None,
                 minimum_age: Optional[pulumi.Input[int]] = None,
                 retention: Optional[pulumi.Input[int]] = None,
                 rss_sync_interval: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConfigArgs.__new__(ConfigArgs)

            if maximum_size is None and not opts.urn:
                raise TypeError("Missing required property 'maximum_size'")
            __props__.__dict__["maximum_size"] = maximum_size
            if minimum_age is None and not opts.urn:
                raise TypeError("Missing required property 'minimum_age'")
            __props__.__dict__["minimum_age"] = minimum_age
            if retention is None and not opts.urn:
                raise TypeError("Missing required property 'retention'")
            __props__.__dict__["retention"] = retention
            if rss_sync_interval is None and not opts.urn:
                raise TypeError("Missing required property 'rss_sync_interval'")
            __props__.__dict__["rss_sync_interval"] = rss_sync_interval
        super(Config, __self__).__init__(
            'lidarr:Indexers/config:Config',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            maximum_size: Optional[pulumi.Input[int]] = None,
            minimum_age: Optional[pulumi.Input[int]] = None,
            retention: Optional[pulumi.Input[int]] = None,
            rss_sync_interval: Optional[pulumi.Input[int]] = None) -> 'Config':
        """
        Get an existing Config resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] maximum_size: Maximum size.
        :param pulumi.Input[int] minimum_age: Minimum age.
        :param pulumi.Input[int] retention: Retention.
        :param pulumi.Input[int] rss_sync_interval: RSS sync interval.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConfigState.__new__(_ConfigState)

        __props__.__dict__["maximum_size"] = maximum_size
        __props__.__dict__["minimum_age"] = minimum_age
        __props__.__dict__["retention"] = retention
        __props__.__dict__["rss_sync_interval"] = rss_sync_interval
        return Config(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="maximumSize")
    def maximum_size(self) -> pulumi.Output[int]:
        """
        Maximum size.
        """
        return pulumi.get(self, "maximum_size")

    @property
    @pulumi.getter(name="minimumAge")
    def minimum_age(self) -> pulumi.Output[int]:
        """
        Minimum age.
        """
        return pulumi.get(self, "minimum_age")

    @property
    @pulumi.getter
    def retention(self) -> pulumi.Output[int]:
        """
        Retention.
        """
        return pulumi.get(self, "retention")

    @property
    @pulumi.getter(name="rssSyncInterval")
    def rss_sync_interval(self) -> pulumi.Output[int]:
        """
        RSS sync interval.
        """
        return pulumi.get(self, "rss_sync_interval")

