# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ImportListArgs', 'ImportList']

@pulumi.input_type
class ImportListArgs:
    def __init__(__self__, *,
                 config_contract: pulumi.Input[str],
                 list_type: pulumi.Input[str],
                 access_token: Optional[pulumi.Input[str]] = None,
                 api_key: Optional[pulumi.Input[str]] = None,
                 base_url: Optional[pulumi.Input[str]] = None,
                 count_list: Optional[pulumi.Input[int]] = None,
                 enable_automatic_add: Optional[pulumi.Input[bool]] = None,
                 expires: Optional[pulumi.Input[str]] = None,
                 implementation: Optional[pulumi.Input[str]] = None,
                 list_id: Optional[pulumi.Input[str]] = None,
                 list_order: Optional[pulumi.Input[int]] = None,
                 metadata_profile_id: Optional[pulumi.Input[int]] = None,
                 monitor_new_items: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 playlist_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 profile_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 quality_profile_id: Optional[pulumi.Input[int]] = None,
                 refresh_token: Optional[pulumi.Input[str]] = None,
                 root_folder_path: Optional[pulumi.Input[str]] = None,
                 series_id: Optional[pulumi.Input[str]] = None,
                 should_monitor: Optional[pulumi.Input[str]] = None,
                 should_monitor_existing: Optional[pulumi.Input[bool]] = None,
                 should_search: Optional[pulumi.Input[bool]] = None,
                 tag_id: Optional[pulumi.Input[str]] = None,
                 tag_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 user_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ImportList resource.
        :param pulumi.Input[str] config_contract: ImportList configuration template.
        :param pulumi.Input[str] list_type: List type.
        :param pulumi.Input[str] access_token: Access token.
        :param pulumi.Input[str] api_key: API key.
        :param pulumi.Input[str] base_url: Base URL.
        :param pulumi.Input[int] count_list: Elements to pull from list.
        :param pulumi.Input[bool] enable_automatic_add: Enable automatic add flag.
        :param pulumi.Input[str] expires: Expires.
        :param pulumi.Input[str] implementation: ImportList implementation name.
        :param pulumi.Input[str] list_id: List ID.
        :param pulumi.Input[int] list_order: List order.
        :param pulumi.Input[int] metadata_profile_id: Metadata profile ID.
        :param pulumi.Input[str] monitor_new_items: Monitor new items.
        :param pulumi.Input[str] name: Import List name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] playlist_ids: Playlist IDs.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] profile_ids: Profile IDs.
        :param pulumi.Input[int] quality_profile_id: Quality profile ID.
        :param pulumi.Input[str] refresh_token: Refresh token.
        :param pulumi.Input[str] root_folder_path: Root folder path.
        :param pulumi.Input[str] series_id: Series ID.
        :param pulumi.Input[str] should_monitor: Should monitor.
        :param pulumi.Input[bool] should_monitor_existing: Should monitor existing flag.
        :param pulumi.Input[bool] should_search: Should search flag.
        :param pulumi.Input[str] tag_id: Tag ID.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tag_ids: Tag IDs.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        :param pulumi.Input[str] user_id: User ID.
        """
        pulumi.set(__self__, "config_contract", config_contract)
        pulumi.set(__self__, "list_type", list_type)
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if base_url is not None:
            pulumi.set(__self__, "base_url", base_url)
        if count_list is not None:
            pulumi.set(__self__, "count_list", count_list)
        if enable_automatic_add is not None:
            pulumi.set(__self__, "enable_automatic_add", enable_automatic_add)
        if expires is not None:
            pulumi.set(__self__, "expires", expires)
        if implementation is not None:
            pulumi.set(__self__, "implementation", implementation)
        if list_id is not None:
            pulumi.set(__self__, "list_id", list_id)
        if list_order is not None:
            pulumi.set(__self__, "list_order", list_order)
        if metadata_profile_id is not None:
            pulumi.set(__self__, "metadata_profile_id", metadata_profile_id)
        if monitor_new_items is not None:
            pulumi.set(__self__, "monitor_new_items", monitor_new_items)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if playlist_ids is not None:
            pulumi.set(__self__, "playlist_ids", playlist_ids)
        if profile_ids is not None:
            pulumi.set(__self__, "profile_ids", profile_ids)
        if quality_profile_id is not None:
            pulumi.set(__self__, "quality_profile_id", quality_profile_id)
        if refresh_token is not None:
            pulumi.set(__self__, "refresh_token", refresh_token)
        if root_folder_path is not None:
            pulumi.set(__self__, "root_folder_path", root_folder_path)
        if series_id is not None:
            pulumi.set(__self__, "series_id", series_id)
        if should_monitor is not None:
            pulumi.set(__self__, "should_monitor", should_monitor)
        if should_monitor_existing is not None:
            pulumi.set(__self__, "should_monitor_existing", should_monitor_existing)
        if should_search is not None:
            pulumi.set(__self__, "should_search", should_search)
        if tag_id is not None:
            pulumi.set(__self__, "tag_id", tag_id)
        if tag_ids is not None:
            pulumi.set(__self__, "tag_ids", tag_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="configContract")
    def config_contract(self) -> pulumi.Input[str]:
        """
        ImportList configuration template.
        """
        return pulumi.get(self, "config_contract")

    @config_contract.setter
    def config_contract(self, value: pulumi.Input[str]):
        pulumi.set(self, "config_contract", value)

    @property
    @pulumi.getter(name="listType")
    def list_type(self) -> pulumi.Input[str]:
        """
        List type.
        """
        return pulumi.get(self, "list_type")

    @list_type.setter
    def list_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "list_type", value)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[pulumi.Input[str]]:
        """
        Access token.
        """
        return pulumi.get(self, "access_token")

    @access_token.setter
    def access_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_token", value)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[str]]:
        """
        API key.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> Optional[pulumi.Input[str]]:
        """
        Base URL.
        """
        return pulumi.get(self, "base_url")

    @base_url.setter
    def base_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_url", value)

    @property
    @pulumi.getter(name="countList")
    def count_list(self) -> Optional[pulumi.Input[int]]:
        """
        Elements to pull from list.
        """
        return pulumi.get(self, "count_list")

    @count_list.setter
    def count_list(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count_list", value)

    @property
    @pulumi.getter(name="enableAutomaticAdd")
    def enable_automatic_add(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable automatic add flag.
        """
        return pulumi.get(self, "enable_automatic_add")

    @enable_automatic_add.setter
    def enable_automatic_add(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_automatic_add", value)

    @property
    @pulumi.getter
    def expires(self) -> Optional[pulumi.Input[str]]:
        """
        Expires.
        """
        return pulumi.get(self, "expires")

    @expires.setter
    def expires(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expires", value)

    @property
    @pulumi.getter
    def implementation(self) -> Optional[pulumi.Input[str]]:
        """
        ImportList implementation name.
        """
        return pulumi.get(self, "implementation")

    @implementation.setter
    def implementation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "implementation", value)

    @property
    @pulumi.getter(name="listId")
    def list_id(self) -> Optional[pulumi.Input[str]]:
        """
        List ID.
        """
        return pulumi.get(self, "list_id")

    @list_id.setter
    def list_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "list_id", value)

    @property
    @pulumi.getter(name="listOrder")
    def list_order(self) -> Optional[pulumi.Input[int]]:
        """
        List order.
        """
        return pulumi.get(self, "list_order")

    @list_order.setter
    def list_order(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "list_order", value)

    @property
    @pulumi.getter(name="metadataProfileId")
    def metadata_profile_id(self) -> Optional[pulumi.Input[int]]:
        """
        Metadata profile ID.
        """
        return pulumi.get(self, "metadata_profile_id")

    @metadata_profile_id.setter
    def metadata_profile_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "metadata_profile_id", value)

    @property
    @pulumi.getter(name="monitorNewItems")
    def monitor_new_items(self) -> Optional[pulumi.Input[str]]:
        """
        Monitor new items.
        """
        return pulumi.get(self, "monitor_new_items")

    @monitor_new_items.setter
    def monitor_new_items(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "monitor_new_items", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Import List name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="playlistIds")
    def playlist_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Playlist IDs.
        """
        return pulumi.get(self, "playlist_ids")

    @playlist_ids.setter
    def playlist_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "playlist_ids", value)

    @property
    @pulumi.getter(name="profileIds")
    def profile_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Profile IDs.
        """
        return pulumi.get(self, "profile_ids")

    @profile_ids.setter
    def profile_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "profile_ids", value)

    @property
    @pulumi.getter(name="qualityProfileId")
    def quality_profile_id(self) -> Optional[pulumi.Input[int]]:
        """
        Quality profile ID.
        """
        return pulumi.get(self, "quality_profile_id")

    @quality_profile_id.setter
    def quality_profile_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "quality_profile_id", value)

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> Optional[pulumi.Input[str]]:
        """
        Refresh token.
        """
        return pulumi.get(self, "refresh_token")

    @refresh_token.setter
    def refresh_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "refresh_token", value)

    @property
    @pulumi.getter(name="rootFolderPath")
    def root_folder_path(self) -> Optional[pulumi.Input[str]]:
        """
        Root folder path.
        """
        return pulumi.get(self, "root_folder_path")

    @root_folder_path.setter
    def root_folder_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "root_folder_path", value)

    @property
    @pulumi.getter(name="seriesId")
    def series_id(self) -> Optional[pulumi.Input[str]]:
        """
        Series ID.
        """
        return pulumi.get(self, "series_id")

    @series_id.setter
    def series_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "series_id", value)

    @property
    @pulumi.getter(name="shouldMonitor")
    def should_monitor(self) -> Optional[pulumi.Input[str]]:
        """
        Should monitor.
        """
        return pulumi.get(self, "should_monitor")

    @should_monitor.setter
    def should_monitor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "should_monitor", value)

    @property
    @pulumi.getter(name="shouldMonitorExisting")
    def should_monitor_existing(self) -> Optional[pulumi.Input[bool]]:
        """
        Should monitor existing flag.
        """
        return pulumi.get(self, "should_monitor_existing")

    @should_monitor_existing.setter
    def should_monitor_existing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "should_monitor_existing", value)

    @property
    @pulumi.getter(name="shouldSearch")
    def should_search(self) -> Optional[pulumi.Input[bool]]:
        """
        Should search flag.
        """
        return pulumi.get(self, "should_search")

    @should_search.setter
    def should_search(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "should_search", value)

    @property
    @pulumi.getter(name="tagId")
    def tag_id(self) -> Optional[pulumi.Input[str]]:
        """
        Tag ID.
        """
        return pulumi.get(self, "tag_id")

    @tag_id.setter
    def tag_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag_id", value)

    @property
    @pulumi.getter(name="tagIds")
    def tag_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Tag IDs.
        """
        return pulumi.get(self, "tag_ids")

    @tag_ids.setter
    def tag_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "tag_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        List of associated tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        User ID.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class _ImportListState:
    def __init__(__self__, *,
                 access_token: Optional[pulumi.Input[str]] = None,
                 api_key: Optional[pulumi.Input[str]] = None,
                 base_url: Optional[pulumi.Input[str]] = None,
                 config_contract: Optional[pulumi.Input[str]] = None,
                 count_list: Optional[pulumi.Input[int]] = None,
                 enable_automatic_add: Optional[pulumi.Input[bool]] = None,
                 expires: Optional[pulumi.Input[str]] = None,
                 implementation: Optional[pulumi.Input[str]] = None,
                 list_id: Optional[pulumi.Input[str]] = None,
                 list_order: Optional[pulumi.Input[int]] = None,
                 list_type: Optional[pulumi.Input[str]] = None,
                 metadata_profile_id: Optional[pulumi.Input[int]] = None,
                 monitor_new_items: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 playlist_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 profile_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 quality_profile_id: Optional[pulumi.Input[int]] = None,
                 refresh_token: Optional[pulumi.Input[str]] = None,
                 root_folder_path: Optional[pulumi.Input[str]] = None,
                 series_id: Optional[pulumi.Input[str]] = None,
                 should_monitor: Optional[pulumi.Input[str]] = None,
                 should_monitor_existing: Optional[pulumi.Input[bool]] = None,
                 should_search: Optional[pulumi.Input[bool]] = None,
                 tag_id: Optional[pulumi.Input[str]] = None,
                 tag_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 user_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ImportList resources.
        :param pulumi.Input[str] access_token: Access token.
        :param pulumi.Input[str] api_key: API key.
        :param pulumi.Input[str] base_url: Base URL.
        :param pulumi.Input[str] config_contract: ImportList configuration template.
        :param pulumi.Input[int] count_list: Elements to pull from list.
        :param pulumi.Input[bool] enable_automatic_add: Enable automatic add flag.
        :param pulumi.Input[str] expires: Expires.
        :param pulumi.Input[str] implementation: ImportList implementation name.
        :param pulumi.Input[str] list_id: List ID.
        :param pulumi.Input[int] list_order: List order.
        :param pulumi.Input[str] list_type: List type.
        :param pulumi.Input[int] metadata_profile_id: Metadata profile ID.
        :param pulumi.Input[str] monitor_new_items: Monitor new items.
        :param pulumi.Input[str] name: Import List name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] playlist_ids: Playlist IDs.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] profile_ids: Profile IDs.
        :param pulumi.Input[int] quality_profile_id: Quality profile ID.
        :param pulumi.Input[str] refresh_token: Refresh token.
        :param pulumi.Input[str] root_folder_path: Root folder path.
        :param pulumi.Input[str] series_id: Series ID.
        :param pulumi.Input[str] should_monitor: Should monitor.
        :param pulumi.Input[bool] should_monitor_existing: Should monitor existing flag.
        :param pulumi.Input[bool] should_search: Should search flag.
        :param pulumi.Input[str] tag_id: Tag ID.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tag_ids: Tag IDs.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        :param pulumi.Input[str] user_id: User ID.
        """
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if base_url is not None:
            pulumi.set(__self__, "base_url", base_url)
        if config_contract is not None:
            pulumi.set(__self__, "config_contract", config_contract)
        if count_list is not None:
            pulumi.set(__self__, "count_list", count_list)
        if enable_automatic_add is not None:
            pulumi.set(__self__, "enable_automatic_add", enable_automatic_add)
        if expires is not None:
            pulumi.set(__self__, "expires", expires)
        if implementation is not None:
            pulumi.set(__self__, "implementation", implementation)
        if list_id is not None:
            pulumi.set(__self__, "list_id", list_id)
        if list_order is not None:
            pulumi.set(__self__, "list_order", list_order)
        if list_type is not None:
            pulumi.set(__self__, "list_type", list_type)
        if metadata_profile_id is not None:
            pulumi.set(__self__, "metadata_profile_id", metadata_profile_id)
        if monitor_new_items is not None:
            pulumi.set(__self__, "monitor_new_items", monitor_new_items)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if playlist_ids is not None:
            pulumi.set(__self__, "playlist_ids", playlist_ids)
        if profile_ids is not None:
            pulumi.set(__self__, "profile_ids", profile_ids)
        if quality_profile_id is not None:
            pulumi.set(__self__, "quality_profile_id", quality_profile_id)
        if refresh_token is not None:
            pulumi.set(__self__, "refresh_token", refresh_token)
        if root_folder_path is not None:
            pulumi.set(__self__, "root_folder_path", root_folder_path)
        if series_id is not None:
            pulumi.set(__self__, "series_id", series_id)
        if should_monitor is not None:
            pulumi.set(__self__, "should_monitor", should_monitor)
        if should_monitor_existing is not None:
            pulumi.set(__self__, "should_monitor_existing", should_monitor_existing)
        if should_search is not None:
            pulumi.set(__self__, "should_search", should_search)
        if tag_id is not None:
            pulumi.set(__self__, "tag_id", tag_id)
        if tag_ids is not None:
            pulumi.set(__self__, "tag_ids", tag_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[pulumi.Input[str]]:
        """
        Access token.
        """
        return pulumi.get(self, "access_token")

    @access_token.setter
    def access_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_token", value)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[str]]:
        """
        API key.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> Optional[pulumi.Input[str]]:
        """
        Base URL.
        """
        return pulumi.get(self, "base_url")

    @base_url.setter
    def base_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_url", value)

    @property
    @pulumi.getter(name="configContract")
    def config_contract(self) -> Optional[pulumi.Input[str]]:
        """
        ImportList configuration template.
        """
        return pulumi.get(self, "config_contract")

    @config_contract.setter
    def config_contract(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_contract", value)

    @property
    @pulumi.getter(name="countList")
    def count_list(self) -> Optional[pulumi.Input[int]]:
        """
        Elements to pull from list.
        """
        return pulumi.get(self, "count_list")

    @count_list.setter
    def count_list(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count_list", value)

    @property
    @pulumi.getter(name="enableAutomaticAdd")
    def enable_automatic_add(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable automatic add flag.
        """
        return pulumi.get(self, "enable_automatic_add")

    @enable_automatic_add.setter
    def enable_automatic_add(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_automatic_add", value)

    @property
    @pulumi.getter
    def expires(self) -> Optional[pulumi.Input[str]]:
        """
        Expires.
        """
        return pulumi.get(self, "expires")

    @expires.setter
    def expires(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expires", value)

    @property
    @pulumi.getter
    def implementation(self) -> Optional[pulumi.Input[str]]:
        """
        ImportList implementation name.
        """
        return pulumi.get(self, "implementation")

    @implementation.setter
    def implementation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "implementation", value)

    @property
    @pulumi.getter(name="listId")
    def list_id(self) -> Optional[pulumi.Input[str]]:
        """
        List ID.
        """
        return pulumi.get(self, "list_id")

    @list_id.setter
    def list_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "list_id", value)

    @property
    @pulumi.getter(name="listOrder")
    def list_order(self) -> Optional[pulumi.Input[int]]:
        """
        List order.
        """
        return pulumi.get(self, "list_order")

    @list_order.setter
    def list_order(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "list_order", value)

    @property
    @pulumi.getter(name="listType")
    def list_type(self) -> Optional[pulumi.Input[str]]:
        """
        List type.
        """
        return pulumi.get(self, "list_type")

    @list_type.setter
    def list_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "list_type", value)

    @property
    @pulumi.getter(name="metadataProfileId")
    def metadata_profile_id(self) -> Optional[pulumi.Input[int]]:
        """
        Metadata profile ID.
        """
        return pulumi.get(self, "metadata_profile_id")

    @metadata_profile_id.setter
    def metadata_profile_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "metadata_profile_id", value)

    @property
    @pulumi.getter(name="monitorNewItems")
    def monitor_new_items(self) -> Optional[pulumi.Input[str]]:
        """
        Monitor new items.
        """
        return pulumi.get(self, "monitor_new_items")

    @monitor_new_items.setter
    def monitor_new_items(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "monitor_new_items", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Import List name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="playlistIds")
    def playlist_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Playlist IDs.
        """
        return pulumi.get(self, "playlist_ids")

    @playlist_ids.setter
    def playlist_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "playlist_ids", value)

    @property
    @pulumi.getter(name="profileIds")
    def profile_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Profile IDs.
        """
        return pulumi.get(self, "profile_ids")

    @profile_ids.setter
    def profile_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "profile_ids", value)

    @property
    @pulumi.getter(name="qualityProfileId")
    def quality_profile_id(self) -> Optional[pulumi.Input[int]]:
        """
        Quality profile ID.
        """
        return pulumi.get(self, "quality_profile_id")

    @quality_profile_id.setter
    def quality_profile_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "quality_profile_id", value)

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> Optional[pulumi.Input[str]]:
        """
        Refresh token.
        """
        return pulumi.get(self, "refresh_token")

    @refresh_token.setter
    def refresh_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "refresh_token", value)

    @property
    @pulumi.getter(name="rootFolderPath")
    def root_folder_path(self) -> Optional[pulumi.Input[str]]:
        """
        Root folder path.
        """
        return pulumi.get(self, "root_folder_path")

    @root_folder_path.setter
    def root_folder_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "root_folder_path", value)

    @property
    @pulumi.getter(name="seriesId")
    def series_id(self) -> Optional[pulumi.Input[str]]:
        """
        Series ID.
        """
        return pulumi.get(self, "series_id")

    @series_id.setter
    def series_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "series_id", value)

    @property
    @pulumi.getter(name="shouldMonitor")
    def should_monitor(self) -> Optional[pulumi.Input[str]]:
        """
        Should monitor.
        """
        return pulumi.get(self, "should_monitor")

    @should_monitor.setter
    def should_monitor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "should_monitor", value)

    @property
    @pulumi.getter(name="shouldMonitorExisting")
    def should_monitor_existing(self) -> Optional[pulumi.Input[bool]]:
        """
        Should monitor existing flag.
        """
        return pulumi.get(self, "should_monitor_existing")

    @should_monitor_existing.setter
    def should_monitor_existing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "should_monitor_existing", value)

    @property
    @pulumi.getter(name="shouldSearch")
    def should_search(self) -> Optional[pulumi.Input[bool]]:
        """
        Should search flag.
        """
        return pulumi.get(self, "should_search")

    @should_search.setter
    def should_search(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "should_search", value)

    @property
    @pulumi.getter(name="tagId")
    def tag_id(self) -> Optional[pulumi.Input[str]]:
        """
        Tag ID.
        """
        return pulumi.get(self, "tag_id")

    @tag_id.setter
    def tag_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag_id", value)

    @property
    @pulumi.getter(name="tagIds")
    def tag_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Tag IDs.
        """
        return pulumi.get(self, "tag_ids")

    @tag_ids.setter
    def tag_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "tag_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        List of associated tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        User ID.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)


class ImportList(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token: Optional[pulumi.Input[str]] = None,
                 api_key: Optional[pulumi.Input[str]] = None,
                 base_url: Optional[pulumi.Input[str]] = None,
                 config_contract: Optional[pulumi.Input[str]] = None,
                 count_list: Optional[pulumi.Input[int]] = None,
                 enable_automatic_add: Optional[pulumi.Input[bool]] = None,
                 expires: Optional[pulumi.Input[str]] = None,
                 implementation: Optional[pulumi.Input[str]] = None,
                 list_id: Optional[pulumi.Input[str]] = None,
                 list_order: Optional[pulumi.Input[int]] = None,
                 list_type: Optional[pulumi.Input[str]] = None,
                 metadata_profile_id: Optional[pulumi.Input[int]] = None,
                 monitor_new_items: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 playlist_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 profile_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 quality_profile_id: Optional[pulumi.Input[int]] = None,
                 refresh_token: Optional[pulumi.Input[str]] = None,
                 root_folder_path: Optional[pulumi.Input[str]] = None,
                 series_id: Optional[pulumi.Input[str]] = None,
                 should_monitor: Optional[pulumi.Input[str]] = None,
                 should_monitor_existing: Optional[pulumi.Input[bool]] = None,
                 should_search: Optional[pulumi.Input[bool]] = None,
                 tag_id: Optional[pulumi.Input[str]] = None,
                 tag_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        <!-- subcategory:Import Lists -->Generic Import List resource. When possible use a specific resource instead.
        For more information refer to [Import List](https://wiki.servarr.com/lidarr/settings#import-lists).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.import_lists.ImportList("example",
            enable_automatic_add=False,
            should_monitor="entireArtist",
            should_search=False,
            list_type="program",
            monitor_new_items="all",
            root_folder_path=lidarr_root_folder["example"]["path"],
            quality_profile_id=lidarr_quality_profile["example"]["id"],
            metadata_profile_id=lidarr_metadata_profile["example"]["id"],
            implementation="LidarrImport",
            config_contract="LidarrSettings",
            tags=[
                1,
                2,
            ],
            tag_ids=[
                1,
                2,
            ],
            profile_ids=[1],
            base_url="http://127.0.0.1:8686",
            api_key="APIKey")
        ```

        ## Import

        import using the API/UI ID

        ```sh
         $ pulumi import lidarr:ImportLists/importList:ImportList example 1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_token: Access token.
        :param pulumi.Input[str] api_key: API key.
        :param pulumi.Input[str] base_url: Base URL.
        :param pulumi.Input[str] config_contract: ImportList configuration template.
        :param pulumi.Input[int] count_list: Elements to pull from list.
        :param pulumi.Input[bool] enable_automatic_add: Enable automatic add flag.
        :param pulumi.Input[str] expires: Expires.
        :param pulumi.Input[str] implementation: ImportList implementation name.
        :param pulumi.Input[str] list_id: List ID.
        :param pulumi.Input[int] list_order: List order.
        :param pulumi.Input[str] list_type: List type.
        :param pulumi.Input[int] metadata_profile_id: Metadata profile ID.
        :param pulumi.Input[str] monitor_new_items: Monitor new items.
        :param pulumi.Input[str] name: Import List name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] playlist_ids: Playlist IDs.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] profile_ids: Profile IDs.
        :param pulumi.Input[int] quality_profile_id: Quality profile ID.
        :param pulumi.Input[str] refresh_token: Refresh token.
        :param pulumi.Input[str] root_folder_path: Root folder path.
        :param pulumi.Input[str] series_id: Series ID.
        :param pulumi.Input[str] should_monitor: Should monitor.
        :param pulumi.Input[bool] should_monitor_existing: Should monitor existing flag.
        :param pulumi.Input[bool] should_search: Should search flag.
        :param pulumi.Input[str] tag_id: Tag ID.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tag_ids: Tag IDs.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        :param pulumi.Input[str] user_id: User ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ImportListArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        <!-- subcategory:Import Lists -->Generic Import List resource. When possible use a specific resource instead.
        For more information refer to [Import List](https://wiki.servarr.com/lidarr/settings#import-lists).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.import_lists.ImportList("example",
            enable_automatic_add=False,
            should_monitor="entireArtist",
            should_search=False,
            list_type="program",
            monitor_new_items="all",
            root_folder_path=lidarr_root_folder["example"]["path"],
            quality_profile_id=lidarr_quality_profile["example"]["id"],
            metadata_profile_id=lidarr_metadata_profile["example"]["id"],
            implementation="LidarrImport",
            config_contract="LidarrSettings",
            tags=[
                1,
                2,
            ],
            tag_ids=[
                1,
                2,
            ],
            profile_ids=[1],
            base_url="http://127.0.0.1:8686",
            api_key="APIKey")
        ```

        ## Import

        import using the API/UI ID

        ```sh
         $ pulumi import lidarr:ImportLists/importList:ImportList example 1
        ```

        :param str resource_name: The name of the resource.
        :param ImportListArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ImportListArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token: Optional[pulumi.Input[str]] = None,
                 api_key: Optional[pulumi.Input[str]] = None,
                 base_url: Optional[pulumi.Input[str]] = None,
                 config_contract: Optional[pulumi.Input[str]] = None,
                 count_list: Optional[pulumi.Input[int]] = None,
                 enable_automatic_add: Optional[pulumi.Input[bool]] = None,
                 expires: Optional[pulumi.Input[str]] = None,
                 implementation: Optional[pulumi.Input[str]] = None,
                 list_id: Optional[pulumi.Input[str]] = None,
                 list_order: Optional[pulumi.Input[int]] = None,
                 list_type: Optional[pulumi.Input[str]] = None,
                 metadata_profile_id: Optional[pulumi.Input[int]] = None,
                 monitor_new_items: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 playlist_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 profile_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 quality_profile_id: Optional[pulumi.Input[int]] = None,
                 refresh_token: Optional[pulumi.Input[str]] = None,
                 root_folder_path: Optional[pulumi.Input[str]] = None,
                 series_id: Optional[pulumi.Input[str]] = None,
                 should_monitor: Optional[pulumi.Input[str]] = None,
                 should_monitor_existing: Optional[pulumi.Input[bool]] = None,
                 should_search: Optional[pulumi.Input[bool]] = None,
                 tag_id: Optional[pulumi.Input[str]] = None,
                 tag_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ImportListArgs.__new__(ImportListArgs)

            __props__.__dict__["access_token"] = None if access_token is None else pulumi.Output.secret(access_token)
            __props__.__dict__["api_key"] = None if api_key is None else pulumi.Output.secret(api_key)
            __props__.__dict__["base_url"] = base_url
            if config_contract is None and not opts.urn:
                raise TypeError("Missing required property 'config_contract'")
            __props__.__dict__["config_contract"] = config_contract
            __props__.__dict__["count_list"] = count_list
            __props__.__dict__["enable_automatic_add"] = enable_automatic_add
            __props__.__dict__["expires"] = expires
            __props__.__dict__["implementation"] = implementation
            __props__.__dict__["list_id"] = list_id
            __props__.__dict__["list_order"] = list_order
            if list_type is None and not opts.urn:
                raise TypeError("Missing required property 'list_type'")
            __props__.__dict__["list_type"] = list_type
            __props__.__dict__["metadata_profile_id"] = metadata_profile_id
            __props__.__dict__["monitor_new_items"] = monitor_new_items
            __props__.__dict__["name"] = name
            __props__.__dict__["playlist_ids"] = playlist_ids
            __props__.__dict__["profile_ids"] = profile_ids
            __props__.__dict__["quality_profile_id"] = quality_profile_id
            __props__.__dict__["refresh_token"] = None if refresh_token is None else pulumi.Output.secret(refresh_token)
            __props__.__dict__["root_folder_path"] = root_folder_path
            __props__.__dict__["series_id"] = series_id
            __props__.__dict__["should_monitor"] = should_monitor
            __props__.__dict__["should_monitor_existing"] = should_monitor_existing
            __props__.__dict__["should_search"] = should_search
            __props__.__dict__["tag_id"] = tag_id
            __props__.__dict__["tag_ids"] = tag_ids
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_id"] = user_id
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["accessToken", "apiKey", "refreshToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ImportList, __self__).__init__(
            'lidarr:ImportLists/importList:ImportList',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_token: Optional[pulumi.Input[str]] = None,
            api_key: Optional[pulumi.Input[str]] = None,
            base_url: Optional[pulumi.Input[str]] = None,
            config_contract: Optional[pulumi.Input[str]] = None,
            count_list: Optional[pulumi.Input[int]] = None,
            enable_automatic_add: Optional[pulumi.Input[bool]] = None,
            expires: Optional[pulumi.Input[str]] = None,
            implementation: Optional[pulumi.Input[str]] = None,
            list_id: Optional[pulumi.Input[str]] = None,
            list_order: Optional[pulumi.Input[int]] = None,
            list_type: Optional[pulumi.Input[str]] = None,
            metadata_profile_id: Optional[pulumi.Input[int]] = None,
            monitor_new_items: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            playlist_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            profile_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            quality_profile_id: Optional[pulumi.Input[int]] = None,
            refresh_token: Optional[pulumi.Input[str]] = None,
            root_folder_path: Optional[pulumi.Input[str]] = None,
            series_id: Optional[pulumi.Input[str]] = None,
            should_monitor: Optional[pulumi.Input[str]] = None,
            should_monitor_existing: Optional[pulumi.Input[bool]] = None,
            should_search: Optional[pulumi.Input[bool]] = None,
            tag_id: Optional[pulumi.Input[str]] = None,
            tag_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            user_id: Optional[pulumi.Input[str]] = None) -> 'ImportList':
        """
        Get an existing ImportList resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_token: Access token.
        :param pulumi.Input[str] api_key: API key.
        :param pulumi.Input[str] base_url: Base URL.
        :param pulumi.Input[str] config_contract: ImportList configuration template.
        :param pulumi.Input[int] count_list: Elements to pull from list.
        :param pulumi.Input[bool] enable_automatic_add: Enable automatic add flag.
        :param pulumi.Input[str] expires: Expires.
        :param pulumi.Input[str] implementation: ImportList implementation name.
        :param pulumi.Input[str] list_id: List ID.
        :param pulumi.Input[int] list_order: List order.
        :param pulumi.Input[str] list_type: List type.
        :param pulumi.Input[int] metadata_profile_id: Metadata profile ID.
        :param pulumi.Input[str] monitor_new_items: Monitor new items.
        :param pulumi.Input[str] name: Import List name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] playlist_ids: Playlist IDs.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] profile_ids: Profile IDs.
        :param pulumi.Input[int] quality_profile_id: Quality profile ID.
        :param pulumi.Input[str] refresh_token: Refresh token.
        :param pulumi.Input[str] root_folder_path: Root folder path.
        :param pulumi.Input[str] series_id: Series ID.
        :param pulumi.Input[str] should_monitor: Should monitor.
        :param pulumi.Input[bool] should_monitor_existing: Should monitor existing flag.
        :param pulumi.Input[bool] should_search: Should search flag.
        :param pulumi.Input[str] tag_id: Tag ID.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tag_ids: Tag IDs.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        :param pulumi.Input[str] user_id: User ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ImportListState.__new__(_ImportListState)

        __props__.__dict__["access_token"] = access_token
        __props__.__dict__["api_key"] = api_key
        __props__.__dict__["base_url"] = base_url
        __props__.__dict__["config_contract"] = config_contract
        __props__.__dict__["count_list"] = count_list
        __props__.__dict__["enable_automatic_add"] = enable_automatic_add
        __props__.__dict__["expires"] = expires
        __props__.__dict__["implementation"] = implementation
        __props__.__dict__["list_id"] = list_id
        __props__.__dict__["list_order"] = list_order
        __props__.__dict__["list_type"] = list_type
        __props__.__dict__["metadata_profile_id"] = metadata_profile_id
        __props__.__dict__["monitor_new_items"] = monitor_new_items
        __props__.__dict__["name"] = name
        __props__.__dict__["playlist_ids"] = playlist_ids
        __props__.__dict__["profile_ids"] = profile_ids
        __props__.__dict__["quality_profile_id"] = quality_profile_id
        __props__.__dict__["refresh_token"] = refresh_token
        __props__.__dict__["root_folder_path"] = root_folder_path
        __props__.__dict__["series_id"] = series_id
        __props__.__dict__["should_monitor"] = should_monitor
        __props__.__dict__["should_monitor_existing"] = should_monitor_existing
        __props__.__dict__["should_search"] = should_search
        __props__.__dict__["tag_id"] = tag_id
        __props__.__dict__["tag_ids"] = tag_ids
        __props__.__dict__["tags"] = tags
        __props__.__dict__["user_id"] = user_id
        return ImportList(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> pulumi.Output[str]:
        """
        Access token.
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Output[str]:
        """
        API key.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> pulumi.Output[str]:
        """
        Base URL.
        """
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter(name="configContract")
    def config_contract(self) -> pulumi.Output[str]:
        """
        ImportList configuration template.
        """
        return pulumi.get(self, "config_contract")

    @property
    @pulumi.getter(name="countList")
    def count_list(self) -> pulumi.Output[int]:
        """
        Elements to pull from list.
        """
        return pulumi.get(self, "count_list")

    @property
    @pulumi.getter(name="enableAutomaticAdd")
    def enable_automatic_add(self) -> pulumi.Output[bool]:
        """
        Enable automatic add flag.
        """
        return pulumi.get(self, "enable_automatic_add")

    @property
    @pulumi.getter
    def expires(self) -> pulumi.Output[str]:
        """
        Expires.
        """
        return pulumi.get(self, "expires")

    @property
    @pulumi.getter
    def implementation(self) -> pulumi.Output[str]:
        """
        ImportList implementation name.
        """
        return pulumi.get(self, "implementation")

    @property
    @pulumi.getter(name="listId")
    def list_id(self) -> pulumi.Output[str]:
        """
        List ID.
        """
        return pulumi.get(self, "list_id")

    @property
    @pulumi.getter(name="listOrder")
    def list_order(self) -> pulumi.Output[int]:
        """
        List order.
        """
        return pulumi.get(self, "list_order")

    @property
    @pulumi.getter(name="listType")
    def list_type(self) -> pulumi.Output[str]:
        """
        List type.
        """
        return pulumi.get(self, "list_type")

    @property
    @pulumi.getter(name="metadataProfileId")
    def metadata_profile_id(self) -> pulumi.Output[int]:
        """
        Metadata profile ID.
        """
        return pulumi.get(self, "metadata_profile_id")

    @property
    @pulumi.getter(name="monitorNewItems")
    def monitor_new_items(self) -> pulumi.Output[str]:
        """
        Monitor new items.
        """
        return pulumi.get(self, "monitor_new_items")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Import List name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="playlistIds")
    def playlist_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        Playlist IDs.
        """
        return pulumi.get(self, "playlist_ids")

    @property
    @pulumi.getter(name="profileIds")
    def profile_ids(self) -> pulumi.Output[Sequence[int]]:
        """
        Profile IDs.
        """
        return pulumi.get(self, "profile_ids")

    @property
    @pulumi.getter(name="qualityProfileId")
    def quality_profile_id(self) -> pulumi.Output[int]:
        """
        Quality profile ID.
        """
        return pulumi.get(self, "quality_profile_id")

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> pulumi.Output[str]:
        """
        Refresh token.
        """
        return pulumi.get(self, "refresh_token")

    @property
    @pulumi.getter(name="rootFolderPath")
    def root_folder_path(self) -> pulumi.Output[str]:
        """
        Root folder path.
        """
        return pulumi.get(self, "root_folder_path")

    @property
    @pulumi.getter(name="seriesId")
    def series_id(self) -> pulumi.Output[str]:
        """
        Series ID.
        """
        return pulumi.get(self, "series_id")

    @property
    @pulumi.getter(name="shouldMonitor")
    def should_monitor(self) -> pulumi.Output[str]:
        """
        Should monitor.
        """
        return pulumi.get(self, "should_monitor")

    @property
    @pulumi.getter(name="shouldMonitorExisting")
    def should_monitor_existing(self) -> pulumi.Output[bool]:
        """
        Should monitor existing flag.
        """
        return pulumi.get(self, "should_monitor_existing")

    @property
    @pulumi.getter(name="shouldSearch")
    def should_search(self) -> pulumi.Output[bool]:
        """
        Should search flag.
        """
        return pulumi.get(self, "should_search")

    @property
    @pulumi.getter(name="tagId")
    def tag_id(self) -> pulumi.Output[str]:
        """
        Tag ID.
        """
        return pulumi.get(self, "tag_id")

    @property
    @pulumi.getter(name="tagIds")
    def tag_ids(self) -> pulumi.Output[Sequence[int]]:
        """
        Tag IDs.
        """
        return pulumi.get(self, "tag_ids")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[int]]:
        """
        List of associated tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[str]:
        """
        User ID.
        """
        return pulumi.get(self, "user_id")

