# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ExclusionArgs', 'Exclusion']

@pulumi.input_type
class ExclusionArgs:
    def __init__(__self__, *,
                 artist_name: pulumi.Input[str],
                 foreign_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a Exclusion resource.
        :param pulumi.Input[str] artist_name: Artist to be excluded.
        :param pulumi.Input[str] foreign_id: Musicbrainz ID.
        """
        pulumi.set(__self__, "artist_name", artist_name)
        pulumi.set(__self__, "foreign_id", foreign_id)

    @property
    @pulumi.getter(name="artistName")
    def artist_name(self) -> pulumi.Input[str]:
        """
        Artist to be excluded.
        """
        return pulumi.get(self, "artist_name")

    @artist_name.setter
    def artist_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "artist_name", value)

    @property
    @pulumi.getter(name="foreignId")
    def foreign_id(self) -> pulumi.Input[str]:
        """
        Musicbrainz ID.
        """
        return pulumi.get(self, "foreign_id")

    @foreign_id.setter
    def foreign_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "foreign_id", value)


@pulumi.input_type
class _ExclusionState:
    def __init__(__self__, *,
                 artist_name: Optional[pulumi.Input[str]] = None,
                 foreign_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Exclusion resources.
        :param pulumi.Input[str] artist_name: Artist to be excluded.
        :param pulumi.Input[str] foreign_id: Musicbrainz ID.
        """
        if artist_name is not None:
            pulumi.set(__self__, "artist_name", artist_name)
        if foreign_id is not None:
            pulumi.set(__self__, "foreign_id", foreign_id)

    @property
    @pulumi.getter(name="artistName")
    def artist_name(self) -> Optional[pulumi.Input[str]]:
        """
        Artist to be excluded.
        """
        return pulumi.get(self, "artist_name")

    @artist_name.setter
    def artist_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "artist_name", value)

    @property
    @pulumi.getter(name="foreignId")
    def foreign_id(self) -> Optional[pulumi.Input[str]]:
        """
        Musicbrainz ID.
        """
        return pulumi.get(self, "foreign_id")

    @foreign_id.setter
    def foreign_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "foreign_id", value)


class Exclusion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artist_name: Optional[pulumi.Input[str]] = None,
                 foreign_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        <!-- subcategory:Import Lists -->Import List Exclusion resource.
        For more information refer to [ImportListExclusions](https://wiki.servarr.com/lidarr/settings#list-exclusions) documentation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.import_lists.Exclusion("example",
            artist_name="Queen",
            foreign_id="0383dadf-2a4e-4d10-a46a-e9e041da8eb3")
        ```

        ## Import

        import using the API/UI ID

        ```sh
         $ pulumi import lidarr:ImportLists/exclusion:Exclusion example 10
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] artist_name: Artist to be excluded.
        :param pulumi.Input[str] foreign_id: Musicbrainz ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExclusionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        <!-- subcategory:Import Lists -->Import List Exclusion resource.
        For more information refer to [ImportListExclusions](https://wiki.servarr.com/lidarr/settings#list-exclusions) documentation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.import_lists.Exclusion("example",
            artist_name="Queen",
            foreign_id="0383dadf-2a4e-4d10-a46a-e9e041da8eb3")
        ```

        ## Import

        import using the API/UI ID

        ```sh
         $ pulumi import lidarr:ImportLists/exclusion:Exclusion example 10
        ```

        :param str resource_name: The name of the resource.
        :param ExclusionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExclusionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artist_name: Optional[pulumi.Input[str]] = None,
                 foreign_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExclusionArgs.__new__(ExclusionArgs)

            if artist_name is None and not opts.urn:
                raise TypeError("Missing required property 'artist_name'")
            __props__.__dict__["artist_name"] = artist_name
            if foreign_id is None and not opts.urn:
                raise TypeError("Missing required property 'foreign_id'")
            __props__.__dict__["foreign_id"] = foreign_id
        super(Exclusion, __self__).__init__(
            'lidarr:ImportLists/exclusion:Exclusion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            artist_name: Optional[pulumi.Input[str]] = None,
            foreign_id: Optional[pulumi.Input[str]] = None) -> 'Exclusion':
        """
        Get an existing Exclusion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] artist_name: Artist to be excluded.
        :param pulumi.Input[str] foreign_id: Musicbrainz ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExclusionState.__new__(_ExclusionState)

        __props__.__dict__["artist_name"] = artist_name
        __props__.__dict__["foreign_id"] = foreign_id
        return Exclusion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="artistName")
    def artist_name(self) -> pulumi.Output[str]:
        """
        Artist to be excluded.
        """
        return pulumi.get(self, "artist_name")

    @property
    @pulumi.getter(name="foreignId")
    def foreign_id(self) -> pulumi.Output[str]:
        """
        Musicbrainz ID.
        """
        return pulumi.get(self, "foreign_id")

