# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['RemotePathMappingArgs', 'RemotePathMapping']

@pulumi.input_type
class RemotePathMappingArgs:
    def __init__(__self__, *,
                 host: pulumi.Input[str],
                 local_path: pulumi.Input[str],
                 remote_path: pulumi.Input[str]):
        """
        The set of arguments for constructing a RemotePathMapping resource.
        :param pulumi.Input[str] host: Download Client host.
        :param pulumi.Input[str] local_path: Local path.
        :param pulumi.Input[str] remote_path: Download Client remote path.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "local_path", local_path)
        pulumi.set(__self__, "remote_path", remote_path)

    @property
    @pulumi.getter
    def host(self) -> pulumi.Input[str]:
        """
        Download Client host.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: pulumi.Input[str]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> pulumi.Input[str]:
        """
        Local path.
        """
        return pulumi.get(self, "local_path")

    @local_path.setter
    def local_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "local_path", value)

    @property
    @pulumi.getter(name="remotePath")
    def remote_path(self) -> pulumi.Input[str]:
        """
        Download Client remote path.
        """
        return pulumi.get(self, "remote_path")

    @remote_path.setter
    def remote_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "remote_path", value)


@pulumi.input_type
class _RemotePathMappingState:
    def __init__(__self__, *,
                 host: Optional[pulumi.Input[str]] = None,
                 local_path: Optional[pulumi.Input[str]] = None,
                 remote_path: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering RemotePathMapping resources.
        :param pulumi.Input[str] host: Download Client host.
        :param pulumi.Input[str] local_path: Local path.
        :param pulumi.Input[str] remote_path: Download Client remote path.
        """
        if host is not None:
            pulumi.set(__self__, "host", host)
        if local_path is not None:
            pulumi.set(__self__, "local_path", local_path)
        if remote_path is not None:
            pulumi.set(__self__, "remote_path", remote_path)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        Download Client host.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> Optional[pulumi.Input[str]]:
        """
        Local path.
        """
        return pulumi.get(self, "local_path")

    @local_path.setter
    def local_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_path", value)

    @property
    @pulumi.getter(name="remotePath")
    def remote_path(self) -> Optional[pulumi.Input[str]]:
        """
        Download Client remote path.
        """
        return pulumi.get(self, "remote_path")

    @remote_path.setter
    def remote_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_path", value)


class RemotePathMapping(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 local_path: Optional[pulumi.Input[str]] = None,
                 remote_path: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        <!-- subcategory:Download Clients -->Remote Path Mapping resource.
        For more information refer to [Remote Path Mapping](https://wiki.servarr.com/lidarr/settings#remote-path-mappings) documentation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.download_clients.RemotePathMapping("example",
            host="www.transmission.com",
            local_path="/transmission-download/",
            remote_path="/download/")
        ```

        ## Import

        import using the API/UI ID

        ```sh
         $ pulumi import lidarr:DownloadClients/remotePathMapping:RemotePathMapping example 10
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] host: Download Client host.
        :param pulumi.Input[str] local_path: Local path.
        :param pulumi.Input[str] remote_path: Download Client remote path.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RemotePathMappingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        <!-- subcategory:Download Clients -->Remote Path Mapping resource.
        For more information refer to [Remote Path Mapping](https://wiki.servarr.com/lidarr/settings#remote-path-mappings) documentation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.download_clients.RemotePathMapping("example",
            host="www.transmission.com",
            local_path="/transmission-download/",
            remote_path="/download/")
        ```

        ## Import

        import using the API/UI ID

        ```sh
         $ pulumi import lidarr:DownloadClients/remotePathMapping:RemotePathMapping example 10
        ```

        :param str resource_name: The name of the resource.
        :param RemotePathMappingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RemotePathMappingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 local_path: Optional[pulumi.Input[str]] = None,
                 remote_path: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RemotePathMappingArgs.__new__(RemotePathMappingArgs)

            if host is None and not opts.urn:
                raise TypeError("Missing required property 'host'")
            __props__.__dict__["host"] = host
            if local_path is None and not opts.urn:
                raise TypeError("Missing required property 'local_path'")
            __props__.__dict__["local_path"] = local_path
            if remote_path is None and not opts.urn:
                raise TypeError("Missing required property 'remote_path'")
            __props__.__dict__["remote_path"] = remote_path
        super(RemotePathMapping, __self__).__init__(
            'lidarr:DownloadClients/remotePathMapping:RemotePathMapping',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            host: Optional[pulumi.Input[str]] = None,
            local_path: Optional[pulumi.Input[str]] = None,
            remote_path: Optional[pulumi.Input[str]] = None) -> 'RemotePathMapping':
        """
        Get an existing RemotePathMapping resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] host: Download Client host.
        :param pulumi.Input[str] local_path: Local path.
        :param pulumi.Input[str] remote_path: Download Client remote path.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RemotePathMappingState.__new__(_RemotePathMappingState)

        __props__.__dict__["host"] = host
        __props__.__dict__["local_path"] = local_path
        __props__.__dict__["remote_path"] = remote_path
        return RemotePathMapping(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def host(self) -> pulumi.Output[str]:
        """
        Download Client host.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> pulumi.Output[str]:
        """
        Local path.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter(name="remotePath")
    def remote_path(self) -> pulumi.Output[str]:
        """
        Download Client remote path.
        """
        return pulumi.get(self, "remote_path")

