# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetRemotePathMappingResult',
    'AwaitableGetRemotePathMappingResult',
    'get_remote_path_mapping',
    'get_remote_path_mapping_output',
]

@pulumi.output_type
class GetRemotePathMappingResult:
    """
    A collection of values returned by getRemotePathMapping.
    """
    def __init__(__self__, host=None, id=None, local_path=None, remote_path=None):
        if host and not isinstance(host, str):
            raise TypeError("Expected argument 'host' to be a str")
        pulumi.set(__self__, "host", host)
        if id and not isinstance(id, int):
            raise TypeError("Expected argument 'id' to be a int")
        pulumi.set(__self__, "id", id)
        if local_path and not isinstance(local_path, str):
            raise TypeError("Expected argument 'local_path' to be a str")
        pulumi.set(__self__, "local_path", local_path)
        if remote_path and not isinstance(remote_path, str):
            raise TypeError("Expected argument 'remote_path' to be a str")
        pulumi.set(__self__, "remote_path", remote_path)

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        Download Client host.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        Remote Path Mapping ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> str:
        """
        Local path.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter(name="remotePath")
    def remote_path(self) -> str:
        """
        Download Client remote path.
        """
        return pulumi.get(self, "remote_path")


class AwaitableGetRemotePathMappingResult(GetRemotePathMappingResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRemotePathMappingResult(
            host=self.host,
            id=self.id,
            local_path=self.local_path,
            remote_path=self.remote_path)


def get_remote_path_mapping(id: Optional[int] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRemotePathMappingResult:
    """
    <!-- subcategory:Download Clients -->Single Remote Path Mapping.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_lidarr as lidarr

    example = lidarr.DownloadClients.get_remote_path_mapping(id=1)
    ```


    :param int id: Remote Path Mapping ID.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('lidarr:DownloadClients/getRemotePathMapping:getRemotePathMapping', __args__, opts=opts, typ=GetRemotePathMappingResult).value

    return AwaitableGetRemotePathMappingResult(
        host=pulumi.get(__ret__, 'host'),
        id=pulumi.get(__ret__, 'id'),
        local_path=pulumi.get(__ret__, 'local_path'),
        remote_path=pulumi.get(__ret__, 'remote_path'))


@_utilities.lift_output_func(get_remote_path_mapping)
def get_remote_path_mapping_output(id: Optional[pulumi.Input[int]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRemotePathMappingResult]:
    """
    <!-- subcategory:Download Clients -->Single Remote Path Mapping.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_lidarr as lidarr

    example = lidarr.DownloadClients.get_remote_path_mapping(id=1)
    ```


    :param int id: Remote Path Mapping ID.
    """
    ...
