# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['DownloadClientArgs', 'DownloadClient']

@pulumi.input_type
class DownloadClientArgs:
    def __init__(__self__, *,
                 config_contract: pulumi.Input[str],
                 implementation: pulumi.Input[str],
                 protocol: pulumi.Input[str],
                 add_paused: Optional[pulumi.Input[bool]] = None,
                 add_stopped: Optional[pulumi.Input[bool]] = None,
                 additional_tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 api_key: Optional[pulumi.Input[str]] = None,
                 category: Optional[pulumi.Input[str]] = None,
                 destination: Optional[pulumi.Input[str]] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 field_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 first_and_last: Optional[pulumi.Input[bool]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 initial_state: Optional[pulumi.Input[int]] = None,
                 intial_state: Optional[pulumi.Input[int]] = None,
                 magnet_file_extension: Optional[pulumi.Input[str]] = None,
                 music_category: Optional[pulumi.Input[str]] = None,
                 music_directory: Optional[pulumi.Input[str]] = None,
                 music_imported_category: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nzb_folder: Optional[pulumi.Input[str]] = None,
                 older_music_priority: Optional[pulumi.Input[int]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 post_import_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 recent_music_priority: Optional[pulumi.Input[int]] = None,
                 remove_completed_downloads: Optional[pulumi.Input[bool]] = None,
                 remove_failed_downloads: Optional[pulumi.Input[bool]] = None,
                 rpc_path: Optional[pulumi.Input[str]] = None,
                 save_magnet_files: Optional[pulumi.Input[bool]] = None,
                 secret_token: Optional[pulumi.Input[str]] = None,
                 sequential_order: Optional[pulumi.Input[bool]] = None,
                 start_on_add: Optional[pulumi.Input[bool]] = None,
                 strm_folder: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 torrent_folder: Optional[pulumi.Input[str]] = None,
                 url_base: Optional[pulumi.Input[str]] = None,
                 use_ssl: Optional[pulumi.Input[bool]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 watch_folder: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DownloadClient resource.
        :param pulumi.Input[str] config_contract: DownloadClient configuration template.
        :param pulumi.Input[str] implementation: DownloadClient implementation name.
        :param pulumi.Input[str] protocol: Protocol. Valid values are 'usenet' and 'torrent'.
        :param pulumi.Input[bool] add_paused: Add paused flag.
        :param pulumi.Input[bool] add_stopped: Add stopped flag.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] additional_tags: Additional tags, `0` TitleSlug, `1` Quality, `2` Language, `3` ReleaseGroup, `4` Year, `5` Indexer, `6` Network.
        :param pulumi.Input[str] api_key: API key.
        :param pulumi.Input[str] category: Category.
        :param pulumi.Input[str] destination: Destination.
        :param pulumi.Input[bool] enable: Enable flag.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] field_tags: Field tags.
        :param pulumi.Input[bool] first_and_last: First and last flag.
        :param pulumi.Input[str] host: host.
        :param pulumi.Input[int] initial_state: Initial state. `0` Start, `1` ForceStart, `2` Pause.
        :param pulumi.Input[int] intial_state: Initial state, with Stop support. `0` Start, `1` ForceStart, `2` Pause, `3` Stop.
        :param pulumi.Input[str] magnet_file_extension: Magnet file extension.
        :param pulumi.Input[str] music_category: Music category.
        :param pulumi.Input[str] music_directory: Music directory.
        :param pulumi.Input[str] music_imported_category: Music imported category.
        :param pulumi.Input[str] name: Download Client name.
        :param pulumi.Input[str] nzb_folder: NZB folder.
        :param pulumi.Input[int] older_music_priority: Older Music priority. `0` Last, `1` First.
        :param pulumi.Input[str] password: Password.
        :param pulumi.Input[int] port: Port.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] post_import_tags: Post import tags.
        :param pulumi.Input[int] priority: Priority.
        :param pulumi.Input[bool] read_only: Read only flag.
        :param pulumi.Input[int] recent_music_priority: Recent Music priority. `0` Last, `1` First.
        :param pulumi.Input[bool] remove_completed_downloads: Remove completed downloads flag.
        :param pulumi.Input[bool] remove_failed_downloads: Remove failed downloads flag.
        :param pulumi.Input[str] rpc_path: RPC path.
        :param pulumi.Input[bool] save_magnet_files: Save magnet files flag.
        :param pulumi.Input[str] secret_token: Secret token.
        :param pulumi.Input[bool] sequential_order: Sequential order flag.
        :param pulumi.Input[bool] start_on_add: Start on add flag.
        :param pulumi.Input[str] strm_folder: STRM folder.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        :param pulumi.Input[str] torrent_folder: Torrent folder.
        :param pulumi.Input[str] url_base: Base URL.
        :param pulumi.Input[bool] use_ssl: Use SSL flag.
        :param pulumi.Input[str] username: Username.
        :param pulumi.Input[str] watch_folder: Watch folder flag.
        """
        pulumi.set(__self__, "config_contract", config_contract)
        pulumi.set(__self__, "implementation", implementation)
        pulumi.set(__self__, "protocol", protocol)
        if add_paused is not None:
            pulumi.set(__self__, "add_paused", add_paused)
        if add_stopped is not None:
            pulumi.set(__self__, "add_stopped", add_stopped)
        if additional_tags is not None:
            pulumi.set(__self__, "additional_tags", additional_tags)
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if field_tags is not None:
            pulumi.set(__self__, "field_tags", field_tags)
        if first_and_last is not None:
            pulumi.set(__self__, "first_and_last", first_and_last)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if initial_state is not None:
            pulumi.set(__self__, "initial_state", initial_state)
        if intial_state is not None:
            pulumi.set(__self__, "intial_state", intial_state)
        if magnet_file_extension is not None:
            pulumi.set(__self__, "magnet_file_extension", magnet_file_extension)
        if music_category is not None:
            pulumi.set(__self__, "music_category", music_category)
        if music_directory is not None:
            pulumi.set(__self__, "music_directory", music_directory)
        if music_imported_category is not None:
            pulumi.set(__self__, "music_imported_category", music_imported_category)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nzb_folder is not None:
            pulumi.set(__self__, "nzb_folder", nzb_folder)
        if older_music_priority is not None:
            pulumi.set(__self__, "older_music_priority", older_music_priority)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if post_import_tags is not None:
            pulumi.set(__self__, "post_import_tags", post_import_tags)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if recent_music_priority is not None:
            pulumi.set(__self__, "recent_music_priority", recent_music_priority)
        if remove_completed_downloads is not None:
            pulumi.set(__self__, "remove_completed_downloads", remove_completed_downloads)
        if remove_failed_downloads is not None:
            pulumi.set(__self__, "remove_failed_downloads", remove_failed_downloads)
        if rpc_path is not None:
            pulumi.set(__self__, "rpc_path", rpc_path)
        if save_magnet_files is not None:
            pulumi.set(__self__, "save_magnet_files", save_magnet_files)
        if secret_token is not None:
            pulumi.set(__self__, "secret_token", secret_token)
        if sequential_order is not None:
            pulumi.set(__self__, "sequential_order", sequential_order)
        if start_on_add is not None:
            pulumi.set(__self__, "start_on_add", start_on_add)
        if strm_folder is not None:
            pulumi.set(__self__, "strm_folder", strm_folder)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if torrent_folder is not None:
            pulumi.set(__self__, "torrent_folder", torrent_folder)
        if url_base is not None:
            pulumi.set(__self__, "url_base", url_base)
        if use_ssl is not None:
            pulumi.set(__self__, "use_ssl", use_ssl)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if watch_folder is not None:
            pulumi.set(__self__, "watch_folder", watch_folder)

    @property
    @pulumi.getter(name="configContract")
    def config_contract(self) -> pulumi.Input[str]:
        """
        DownloadClient configuration template.
        """
        return pulumi.get(self, "config_contract")

    @config_contract.setter
    def config_contract(self, value: pulumi.Input[str]):
        pulumi.set(self, "config_contract", value)

    @property
    @pulumi.getter
    def implementation(self) -> pulumi.Input[str]:
        """
        DownloadClient implementation name.
        """
        return pulumi.get(self, "implementation")

    @implementation.setter
    def implementation(self, value: pulumi.Input[str]):
        pulumi.set(self, "implementation", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        Protocol. Valid values are 'usenet' and 'torrent'.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="addPaused")
    def add_paused(self) -> Optional[pulumi.Input[bool]]:
        """
        Add paused flag.
        """
        return pulumi.get(self, "add_paused")

    @add_paused.setter
    def add_paused(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "add_paused", value)

    @property
    @pulumi.getter(name="addStopped")
    def add_stopped(self) -> Optional[pulumi.Input[bool]]:
        """
        Add stopped flag.
        """
        return pulumi.get(self, "add_stopped")

    @add_stopped.setter
    def add_stopped(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "add_stopped", value)

    @property
    @pulumi.getter(name="additionalTags")
    def additional_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Additional tags, `0` TitleSlug, `1` Quality, `2` Language, `3` ReleaseGroup, `4` Year, `5` Indexer, `6` Network.
        """
        return pulumi.get(self, "additional_tags")

    @additional_tags.setter
    def additional_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "additional_tags", value)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[str]]:
        """
        API key.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[str]]:
        """
        Category.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[str]]:
        """
        Destination.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable flag.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter(name="fieldTags")
    def field_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Field tags.
        """
        return pulumi.get(self, "field_tags")

    @field_tags.setter
    def field_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "field_tags", value)

    @property
    @pulumi.getter(name="firstAndLast")
    def first_and_last(self) -> Optional[pulumi.Input[bool]]:
        """
        First and last flag.
        """
        return pulumi.get(self, "first_and_last")

    @first_and_last.setter
    def first_and_last(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "first_and_last", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        host.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="initialState")
    def initial_state(self) -> Optional[pulumi.Input[int]]:
        """
        Initial state. `0` Start, `1` ForceStart, `2` Pause.
        """
        return pulumi.get(self, "initial_state")

    @initial_state.setter
    def initial_state(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "initial_state", value)

    @property
    @pulumi.getter(name="intialState")
    def intial_state(self) -> Optional[pulumi.Input[int]]:
        """
        Initial state, with Stop support. `0` Start, `1` ForceStart, `2` Pause, `3` Stop.
        """
        return pulumi.get(self, "intial_state")

    @intial_state.setter
    def intial_state(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "intial_state", value)

    @property
    @pulumi.getter(name="magnetFileExtension")
    def magnet_file_extension(self) -> Optional[pulumi.Input[str]]:
        """
        Magnet file extension.
        """
        return pulumi.get(self, "magnet_file_extension")

    @magnet_file_extension.setter
    def magnet_file_extension(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "magnet_file_extension", value)

    @property
    @pulumi.getter(name="musicCategory")
    def music_category(self) -> Optional[pulumi.Input[str]]:
        """
        Music category.
        """
        return pulumi.get(self, "music_category")

    @music_category.setter
    def music_category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "music_category", value)

    @property
    @pulumi.getter(name="musicDirectory")
    def music_directory(self) -> Optional[pulumi.Input[str]]:
        """
        Music directory.
        """
        return pulumi.get(self, "music_directory")

    @music_directory.setter
    def music_directory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "music_directory", value)

    @property
    @pulumi.getter(name="musicImportedCategory")
    def music_imported_category(self) -> Optional[pulumi.Input[str]]:
        """
        Music imported category.
        """
        return pulumi.get(self, "music_imported_category")

    @music_imported_category.setter
    def music_imported_category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "music_imported_category", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Download Client name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nzbFolder")
    def nzb_folder(self) -> Optional[pulumi.Input[str]]:
        """
        NZB folder.
        """
        return pulumi.get(self, "nzb_folder")

    @nzb_folder.setter
    def nzb_folder(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nzb_folder", value)

    @property
    @pulumi.getter(name="olderMusicPriority")
    def older_music_priority(self) -> Optional[pulumi.Input[int]]:
        """
        Older Music priority. `0` Last, `1` First.
        """
        return pulumi.get(self, "older_music_priority")

    @older_music_priority.setter
    def older_music_priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "older_music_priority", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="postImportTags")
    def post_import_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Post import tags.
        """
        return pulumi.get(self, "post_import_tags")

    @post_import_tags.setter
    def post_import_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "post_import_tags", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Read only flag.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="recentMusicPriority")
    def recent_music_priority(self) -> Optional[pulumi.Input[int]]:
        """
        Recent Music priority. `0` Last, `1` First.
        """
        return pulumi.get(self, "recent_music_priority")

    @recent_music_priority.setter
    def recent_music_priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recent_music_priority", value)

    @property
    @pulumi.getter(name="removeCompletedDownloads")
    def remove_completed_downloads(self) -> Optional[pulumi.Input[bool]]:
        """
        Remove completed downloads flag.
        """
        return pulumi.get(self, "remove_completed_downloads")

    @remove_completed_downloads.setter
    def remove_completed_downloads(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remove_completed_downloads", value)

    @property
    @pulumi.getter(name="removeFailedDownloads")
    def remove_failed_downloads(self) -> Optional[pulumi.Input[bool]]:
        """
        Remove failed downloads flag.
        """
        return pulumi.get(self, "remove_failed_downloads")

    @remove_failed_downloads.setter
    def remove_failed_downloads(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remove_failed_downloads", value)

    @property
    @pulumi.getter(name="rpcPath")
    def rpc_path(self) -> Optional[pulumi.Input[str]]:
        """
        RPC path.
        """
        return pulumi.get(self, "rpc_path")

    @rpc_path.setter
    def rpc_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rpc_path", value)

    @property
    @pulumi.getter(name="saveMagnetFiles")
    def save_magnet_files(self) -> Optional[pulumi.Input[bool]]:
        """
        Save magnet files flag.
        """
        return pulumi.get(self, "save_magnet_files")

    @save_magnet_files.setter
    def save_magnet_files(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "save_magnet_files", value)

    @property
    @pulumi.getter(name="secretToken")
    def secret_token(self) -> Optional[pulumi.Input[str]]:
        """
        Secret token.
        """
        return pulumi.get(self, "secret_token")

    @secret_token.setter
    def secret_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_token", value)

    @property
    @pulumi.getter(name="sequentialOrder")
    def sequential_order(self) -> Optional[pulumi.Input[bool]]:
        """
        Sequential order flag.
        """
        return pulumi.get(self, "sequential_order")

    @sequential_order.setter
    def sequential_order(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sequential_order", value)

    @property
    @pulumi.getter(name="startOnAdd")
    def start_on_add(self) -> Optional[pulumi.Input[bool]]:
        """
        Start on add flag.
        """
        return pulumi.get(self, "start_on_add")

    @start_on_add.setter
    def start_on_add(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "start_on_add", value)

    @property
    @pulumi.getter(name="strmFolder")
    def strm_folder(self) -> Optional[pulumi.Input[str]]:
        """
        STRM folder.
        """
        return pulumi.get(self, "strm_folder")

    @strm_folder.setter
    def strm_folder(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "strm_folder", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        List of associated tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="torrentFolder")
    def torrent_folder(self) -> Optional[pulumi.Input[str]]:
        """
        Torrent folder.
        """
        return pulumi.get(self, "torrent_folder")

    @torrent_folder.setter
    def torrent_folder(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "torrent_folder", value)

    @property
    @pulumi.getter(name="urlBase")
    def url_base(self) -> Optional[pulumi.Input[str]]:
        """
        Base URL.
        """
        return pulumi.get(self, "url_base")

    @url_base.setter
    def url_base(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url_base", value)

    @property
    @pulumi.getter(name="useSsl")
    def use_ssl(self) -> Optional[pulumi.Input[bool]]:
        """
        Use SSL flag.
        """
        return pulumi.get(self, "use_ssl")

    @use_ssl.setter
    def use_ssl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_ssl", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="watchFolder")
    def watch_folder(self) -> Optional[pulumi.Input[str]]:
        """
        Watch folder flag.
        """
        return pulumi.get(self, "watch_folder")

    @watch_folder.setter
    def watch_folder(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "watch_folder", value)


@pulumi.input_type
class _DownloadClientState:
    def __init__(__self__, *,
                 add_paused: Optional[pulumi.Input[bool]] = None,
                 add_stopped: Optional[pulumi.Input[bool]] = None,
                 additional_tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 api_key: Optional[pulumi.Input[str]] = None,
                 category: Optional[pulumi.Input[str]] = None,
                 config_contract: Optional[pulumi.Input[str]] = None,
                 destination: Optional[pulumi.Input[str]] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 field_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 first_and_last: Optional[pulumi.Input[bool]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 implementation: Optional[pulumi.Input[str]] = None,
                 initial_state: Optional[pulumi.Input[int]] = None,
                 intial_state: Optional[pulumi.Input[int]] = None,
                 magnet_file_extension: Optional[pulumi.Input[str]] = None,
                 music_category: Optional[pulumi.Input[str]] = None,
                 music_directory: Optional[pulumi.Input[str]] = None,
                 music_imported_category: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nzb_folder: Optional[pulumi.Input[str]] = None,
                 older_music_priority: Optional[pulumi.Input[int]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 post_import_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 recent_music_priority: Optional[pulumi.Input[int]] = None,
                 remove_completed_downloads: Optional[pulumi.Input[bool]] = None,
                 remove_failed_downloads: Optional[pulumi.Input[bool]] = None,
                 rpc_path: Optional[pulumi.Input[str]] = None,
                 save_magnet_files: Optional[pulumi.Input[bool]] = None,
                 secret_token: Optional[pulumi.Input[str]] = None,
                 sequential_order: Optional[pulumi.Input[bool]] = None,
                 start_on_add: Optional[pulumi.Input[bool]] = None,
                 strm_folder: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 torrent_folder: Optional[pulumi.Input[str]] = None,
                 url_base: Optional[pulumi.Input[str]] = None,
                 use_ssl: Optional[pulumi.Input[bool]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 watch_folder: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DownloadClient resources.
        :param pulumi.Input[bool] add_paused: Add paused flag.
        :param pulumi.Input[bool] add_stopped: Add stopped flag.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] additional_tags: Additional tags, `0` TitleSlug, `1` Quality, `2` Language, `3` ReleaseGroup, `4` Year, `5` Indexer, `6` Network.
        :param pulumi.Input[str] api_key: API key.
        :param pulumi.Input[str] category: Category.
        :param pulumi.Input[str] config_contract: DownloadClient configuration template.
        :param pulumi.Input[str] destination: Destination.
        :param pulumi.Input[bool] enable: Enable flag.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] field_tags: Field tags.
        :param pulumi.Input[bool] first_and_last: First and last flag.
        :param pulumi.Input[str] host: host.
        :param pulumi.Input[str] implementation: DownloadClient implementation name.
        :param pulumi.Input[int] initial_state: Initial state. `0` Start, `1` ForceStart, `2` Pause.
        :param pulumi.Input[int] intial_state: Initial state, with Stop support. `0` Start, `1` ForceStart, `2` Pause, `3` Stop.
        :param pulumi.Input[str] magnet_file_extension: Magnet file extension.
        :param pulumi.Input[str] music_category: Music category.
        :param pulumi.Input[str] music_directory: Music directory.
        :param pulumi.Input[str] music_imported_category: Music imported category.
        :param pulumi.Input[str] name: Download Client name.
        :param pulumi.Input[str] nzb_folder: NZB folder.
        :param pulumi.Input[int] older_music_priority: Older Music priority. `0` Last, `1` First.
        :param pulumi.Input[str] password: Password.
        :param pulumi.Input[int] port: Port.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] post_import_tags: Post import tags.
        :param pulumi.Input[int] priority: Priority.
        :param pulumi.Input[str] protocol: Protocol. Valid values are 'usenet' and 'torrent'.
        :param pulumi.Input[bool] read_only: Read only flag.
        :param pulumi.Input[int] recent_music_priority: Recent Music priority. `0` Last, `1` First.
        :param pulumi.Input[bool] remove_completed_downloads: Remove completed downloads flag.
        :param pulumi.Input[bool] remove_failed_downloads: Remove failed downloads flag.
        :param pulumi.Input[str] rpc_path: RPC path.
        :param pulumi.Input[bool] save_magnet_files: Save magnet files flag.
        :param pulumi.Input[str] secret_token: Secret token.
        :param pulumi.Input[bool] sequential_order: Sequential order flag.
        :param pulumi.Input[bool] start_on_add: Start on add flag.
        :param pulumi.Input[str] strm_folder: STRM folder.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        :param pulumi.Input[str] torrent_folder: Torrent folder.
        :param pulumi.Input[str] url_base: Base URL.
        :param pulumi.Input[bool] use_ssl: Use SSL flag.
        :param pulumi.Input[str] username: Username.
        :param pulumi.Input[str] watch_folder: Watch folder flag.
        """
        if add_paused is not None:
            pulumi.set(__self__, "add_paused", add_paused)
        if add_stopped is not None:
            pulumi.set(__self__, "add_stopped", add_stopped)
        if additional_tags is not None:
            pulumi.set(__self__, "additional_tags", additional_tags)
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if config_contract is not None:
            pulumi.set(__self__, "config_contract", config_contract)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if field_tags is not None:
            pulumi.set(__self__, "field_tags", field_tags)
        if first_and_last is not None:
            pulumi.set(__self__, "first_and_last", first_and_last)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if implementation is not None:
            pulumi.set(__self__, "implementation", implementation)
        if initial_state is not None:
            pulumi.set(__self__, "initial_state", initial_state)
        if intial_state is not None:
            pulumi.set(__self__, "intial_state", intial_state)
        if magnet_file_extension is not None:
            pulumi.set(__self__, "magnet_file_extension", magnet_file_extension)
        if music_category is not None:
            pulumi.set(__self__, "music_category", music_category)
        if music_directory is not None:
            pulumi.set(__self__, "music_directory", music_directory)
        if music_imported_category is not None:
            pulumi.set(__self__, "music_imported_category", music_imported_category)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nzb_folder is not None:
            pulumi.set(__self__, "nzb_folder", nzb_folder)
        if older_music_priority is not None:
            pulumi.set(__self__, "older_music_priority", older_music_priority)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if post_import_tags is not None:
            pulumi.set(__self__, "post_import_tags", post_import_tags)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if recent_music_priority is not None:
            pulumi.set(__self__, "recent_music_priority", recent_music_priority)
        if remove_completed_downloads is not None:
            pulumi.set(__self__, "remove_completed_downloads", remove_completed_downloads)
        if remove_failed_downloads is not None:
            pulumi.set(__self__, "remove_failed_downloads", remove_failed_downloads)
        if rpc_path is not None:
            pulumi.set(__self__, "rpc_path", rpc_path)
        if save_magnet_files is not None:
            pulumi.set(__self__, "save_magnet_files", save_magnet_files)
        if secret_token is not None:
            pulumi.set(__self__, "secret_token", secret_token)
        if sequential_order is not None:
            pulumi.set(__self__, "sequential_order", sequential_order)
        if start_on_add is not None:
            pulumi.set(__self__, "start_on_add", start_on_add)
        if strm_folder is not None:
            pulumi.set(__self__, "strm_folder", strm_folder)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if torrent_folder is not None:
            pulumi.set(__self__, "torrent_folder", torrent_folder)
        if url_base is not None:
            pulumi.set(__self__, "url_base", url_base)
        if use_ssl is not None:
            pulumi.set(__self__, "use_ssl", use_ssl)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if watch_folder is not None:
            pulumi.set(__self__, "watch_folder", watch_folder)

    @property
    @pulumi.getter(name="addPaused")
    def add_paused(self) -> Optional[pulumi.Input[bool]]:
        """
        Add paused flag.
        """
        return pulumi.get(self, "add_paused")

    @add_paused.setter
    def add_paused(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "add_paused", value)

    @property
    @pulumi.getter(name="addStopped")
    def add_stopped(self) -> Optional[pulumi.Input[bool]]:
        """
        Add stopped flag.
        """
        return pulumi.get(self, "add_stopped")

    @add_stopped.setter
    def add_stopped(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "add_stopped", value)

    @property
    @pulumi.getter(name="additionalTags")
    def additional_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Additional tags, `0` TitleSlug, `1` Quality, `2` Language, `3` ReleaseGroup, `4` Year, `5` Indexer, `6` Network.
        """
        return pulumi.get(self, "additional_tags")

    @additional_tags.setter
    def additional_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "additional_tags", value)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[str]]:
        """
        API key.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[str]]:
        """
        Category.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter(name="configContract")
    def config_contract(self) -> Optional[pulumi.Input[str]]:
        """
        DownloadClient configuration template.
        """
        return pulumi.get(self, "config_contract")

    @config_contract.setter
    def config_contract(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_contract", value)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[str]]:
        """
        Destination.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable flag.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter(name="fieldTags")
    def field_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Field tags.
        """
        return pulumi.get(self, "field_tags")

    @field_tags.setter
    def field_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "field_tags", value)

    @property
    @pulumi.getter(name="firstAndLast")
    def first_and_last(self) -> Optional[pulumi.Input[bool]]:
        """
        First and last flag.
        """
        return pulumi.get(self, "first_and_last")

    @first_and_last.setter
    def first_and_last(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "first_and_last", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        host.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def implementation(self) -> Optional[pulumi.Input[str]]:
        """
        DownloadClient implementation name.
        """
        return pulumi.get(self, "implementation")

    @implementation.setter
    def implementation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "implementation", value)

    @property
    @pulumi.getter(name="initialState")
    def initial_state(self) -> Optional[pulumi.Input[int]]:
        """
        Initial state. `0` Start, `1` ForceStart, `2` Pause.
        """
        return pulumi.get(self, "initial_state")

    @initial_state.setter
    def initial_state(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "initial_state", value)

    @property
    @pulumi.getter(name="intialState")
    def intial_state(self) -> Optional[pulumi.Input[int]]:
        """
        Initial state, with Stop support. `0` Start, `1` ForceStart, `2` Pause, `3` Stop.
        """
        return pulumi.get(self, "intial_state")

    @intial_state.setter
    def intial_state(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "intial_state", value)

    @property
    @pulumi.getter(name="magnetFileExtension")
    def magnet_file_extension(self) -> Optional[pulumi.Input[str]]:
        """
        Magnet file extension.
        """
        return pulumi.get(self, "magnet_file_extension")

    @magnet_file_extension.setter
    def magnet_file_extension(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "magnet_file_extension", value)

    @property
    @pulumi.getter(name="musicCategory")
    def music_category(self) -> Optional[pulumi.Input[str]]:
        """
        Music category.
        """
        return pulumi.get(self, "music_category")

    @music_category.setter
    def music_category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "music_category", value)

    @property
    @pulumi.getter(name="musicDirectory")
    def music_directory(self) -> Optional[pulumi.Input[str]]:
        """
        Music directory.
        """
        return pulumi.get(self, "music_directory")

    @music_directory.setter
    def music_directory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "music_directory", value)

    @property
    @pulumi.getter(name="musicImportedCategory")
    def music_imported_category(self) -> Optional[pulumi.Input[str]]:
        """
        Music imported category.
        """
        return pulumi.get(self, "music_imported_category")

    @music_imported_category.setter
    def music_imported_category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "music_imported_category", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Download Client name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nzbFolder")
    def nzb_folder(self) -> Optional[pulumi.Input[str]]:
        """
        NZB folder.
        """
        return pulumi.get(self, "nzb_folder")

    @nzb_folder.setter
    def nzb_folder(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nzb_folder", value)

    @property
    @pulumi.getter(name="olderMusicPriority")
    def older_music_priority(self) -> Optional[pulumi.Input[int]]:
        """
        Older Music priority. `0` Last, `1` First.
        """
        return pulumi.get(self, "older_music_priority")

    @older_music_priority.setter
    def older_music_priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "older_music_priority", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="postImportTags")
    def post_import_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Post import tags.
        """
        return pulumi.get(self, "post_import_tags")

    @post_import_tags.setter
    def post_import_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "post_import_tags", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Protocol. Valid values are 'usenet' and 'torrent'.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Read only flag.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="recentMusicPriority")
    def recent_music_priority(self) -> Optional[pulumi.Input[int]]:
        """
        Recent Music priority. `0` Last, `1` First.
        """
        return pulumi.get(self, "recent_music_priority")

    @recent_music_priority.setter
    def recent_music_priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recent_music_priority", value)

    @property
    @pulumi.getter(name="removeCompletedDownloads")
    def remove_completed_downloads(self) -> Optional[pulumi.Input[bool]]:
        """
        Remove completed downloads flag.
        """
        return pulumi.get(self, "remove_completed_downloads")

    @remove_completed_downloads.setter
    def remove_completed_downloads(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remove_completed_downloads", value)

    @property
    @pulumi.getter(name="removeFailedDownloads")
    def remove_failed_downloads(self) -> Optional[pulumi.Input[bool]]:
        """
        Remove failed downloads flag.
        """
        return pulumi.get(self, "remove_failed_downloads")

    @remove_failed_downloads.setter
    def remove_failed_downloads(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remove_failed_downloads", value)

    @property
    @pulumi.getter(name="rpcPath")
    def rpc_path(self) -> Optional[pulumi.Input[str]]:
        """
        RPC path.
        """
        return pulumi.get(self, "rpc_path")

    @rpc_path.setter
    def rpc_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rpc_path", value)

    @property
    @pulumi.getter(name="saveMagnetFiles")
    def save_magnet_files(self) -> Optional[pulumi.Input[bool]]:
        """
        Save magnet files flag.
        """
        return pulumi.get(self, "save_magnet_files")

    @save_magnet_files.setter
    def save_magnet_files(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "save_magnet_files", value)

    @property
    @pulumi.getter(name="secretToken")
    def secret_token(self) -> Optional[pulumi.Input[str]]:
        """
        Secret token.
        """
        return pulumi.get(self, "secret_token")

    @secret_token.setter
    def secret_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_token", value)

    @property
    @pulumi.getter(name="sequentialOrder")
    def sequential_order(self) -> Optional[pulumi.Input[bool]]:
        """
        Sequential order flag.
        """
        return pulumi.get(self, "sequential_order")

    @sequential_order.setter
    def sequential_order(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sequential_order", value)

    @property
    @pulumi.getter(name="startOnAdd")
    def start_on_add(self) -> Optional[pulumi.Input[bool]]:
        """
        Start on add flag.
        """
        return pulumi.get(self, "start_on_add")

    @start_on_add.setter
    def start_on_add(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "start_on_add", value)

    @property
    @pulumi.getter(name="strmFolder")
    def strm_folder(self) -> Optional[pulumi.Input[str]]:
        """
        STRM folder.
        """
        return pulumi.get(self, "strm_folder")

    @strm_folder.setter
    def strm_folder(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "strm_folder", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        List of associated tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="torrentFolder")
    def torrent_folder(self) -> Optional[pulumi.Input[str]]:
        """
        Torrent folder.
        """
        return pulumi.get(self, "torrent_folder")

    @torrent_folder.setter
    def torrent_folder(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "torrent_folder", value)

    @property
    @pulumi.getter(name="urlBase")
    def url_base(self) -> Optional[pulumi.Input[str]]:
        """
        Base URL.
        """
        return pulumi.get(self, "url_base")

    @url_base.setter
    def url_base(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url_base", value)

    @property
    @pulumi.getter(name="useSsl")
    def use_ssl(self) -> Optional[pulumi.Input[bool]]:
        """
        Use SSL flag.
        """
        return pulumi.get(self, "use_ssl")

    @use_ssl.setter
    def use_ssl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_ssl", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="watchFolder")
    def watch_folder(self) -> Optional[pulumi.Input[str]]:
        """
        Watch folder flag.
        """
        return pulumi.get(self, "watch_folder")

    @watch_folder.setter
    def watch_folder(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "watch_folder", value)


class DownloadClient(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 add_paused: Optional[pulumi.Input[bool]] = None,
                 add_stopped: Optional[pulumi.Input[bool]] = None,
                 additional_tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 api_key: Optional[pulumi.Input[str]] = None,
                 category: Optional[pulumi.Input[str]] = None,
                 config_contract: Optional[pulumi.Input[str]] = None,
                 destination: Optional[pulumi.Input[str]] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 field_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 first_and_last: Optional[pulumi.Input[bool]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 implementation: Optional[pulumi.Input[str]] = None,
                 initial_state: Optional[pulumi.Input[int]] = None,
                 intial_state: Optional[pulumi.Input[int]] = None,
                 magnet_file_extension: Optional[pulumi.Input[str]] = None,
                 music_category: Optional[pulumi.Input[str]] = None,
                 music_directory: Optional[pulumi.Input[str]] = None,
                 music_imported_category: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nzb_folder: Optional[pulumi.Input[str]] = None,
                 older_music_priority: Optional[pulumi.Input[int]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 post_import_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 recent_music_priority: Optional[pulumi.Input[int]] = None,
                 remove_completed_downloads: Optional[pulumi.Input[bool]] = None,
                 remove_failed_downloads: Optional[pulumi.Input[bool]] = None,
                 rpc_path: Optional[pulumi.Input[str]] = None,
                 save_magnet_files: Optional[pulumi.Input[bool]] = None,
                 secret_token: Optional[pulumi.Input[str]] = None,
                 sequential_order: Optional[pulumi.Input[bool]] = None,
                 start_on_add: Optional[pulumi.Input[bool]] = None,
                 strm_folder: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 torrent_folder: Optional[pulumi.Input[str]] = None,
                 url_base: Optional[pulumi.Input[str]] = None,
                 use_ssl: Optional[pulumi.Input[bool]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 watch_folder: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        <!-- subcategory:Download Clients -->Generic Download Client resource. When possible use a specific resource instead.
        For more information refer to [Download Client](https://wiki.servarr.com/lidarr/settings#download-clients).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.download_clients.DownloadClient("example",
            config_contract="TransmissionSettings",
            enable=True,
            host="transmission",
            implementation="Transmission",
            port=9091,
            priority=1,
            protocol="torrent",
            url_base="/transmission/")
        ```

        ## Import

        import using the API/UI ID

        ```sh
         $ pulumi import lidarr:DownloadClients/downloadClient:DownloadClient example 1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] add_paused: Add paused flag.
        :param pulumi.Input[bool] add_stopped: Add stopped flag.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] additional_tags: Additional tags, `0` TitleSlug, `1` Quality, `2` Language, `3` ReleaseGroup, `4` Year, `5` Indexer, `6` Network.
        :param pulumi.Input[str] api_key: API key.
        :param pulumi.Input[str] category: Category.
        :param pulumi.Input[str] config_contract: DownloadClient configuration template.
        :param pulumi.Input[str] destination: Destination.
        :param pulumi.Input[bool] enable: Enable flag.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] field_tags: Field tags.
        :param pulumi.Input[bool] first_and_last: First and last flag.
        :param pulumi.Input[str] host: host.
        :param pulumi.Input[str] implementation: DownloadClient implementation name.
        :param pulumi.Input[int] initial_state: Initial state. `0` Start, `1` ForceStart, `2` Pause.
        :param pulumi.Input[int] intial_state: Initial state, with Stop support. `0` Start, `1` ForceStart, `2` Pause, `3` Stop.
        :param pulumi.Input[str] magnet_file_extension: Magnet file extension.
        :param pulumi.Input[str] music_category: Music category.
        :param pulumi.Input[str] music_directory: Music directory.
        :param pulumi.Input[str] music_imported_category: Music imported category.
        :param pulumi.Input[str] name: Download Client name.
        :param pulumi.Input[str] nzb_folder: NZB folder.
        :param pulumi.Input[int] older_music_priority: Older Music priority. `0` Last, `1` First.
        :param pulumi.Input[str] password: Password.
        :param pulumi.Input[int] port: Port.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] post_import_tags: Post import tags.
        :param pulumi.Input[int] priority: Priority.
        :param pulumi.Input[str] protocol: Protocol. Valid values are 'usenet' and 'torrent'.
        :param pulumi.Input[bool] read_only: Read only flag.
        :param pulumi.Input[int] recent_music_priority: Recent Music priority. `0` Last, `1` First.
        :param pulumi.Input[bool] remove_completed_downloads: Remove completed downloads flag.
        :param pulumi.Input[bool] remove_failed_downloads: Remove failed downloads flag.
        :param pulumi.Input[str] rpc_path: RPC path.
        :param pulumi.Input[bool] save_magnet_files: Save magnet files flag.
        :param pulumi.Input[str] secret_token: Secret token.
        :param pulumi.Input[bool] sequential_order: Sequential order flag.
        :param pulumi.Input[bool] start_on_add: Start on add flag.
        :param pulumi.Input[str] strm_folder: STRM folder.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        :param pulumi.Input[str] torrent_folder: Torrent folder.
        :param pulumi.Input[str] url_base: Base URL.
        :param pulumi.Input[bool] use_ssl: Use SSL flag.
        :param pulumi.Input[str] username: Username.
        :param pulumi.Input[str] watch_folder: Watch folder flag.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DownloadClientArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        <!-- subcategory:Download Clients -->Generic Download Client resource. When possible use a specific resource instead.
        For more information refer to [Download Client](https://wiki.servarr.com/lidarr/settings#download-clients).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.download_clients.DownloadClient("example",
            config_contract="TransmissionSettings",
            enable=True,
            host="transmission",
            implementation="Transmission",
            port=9091,
            priority=1,
            protocol="torrent",
            url_base="/transmission/")
        ```

        ## Import

        import using the API/UI ID

        ```sh
         $ pulumi import lidarr:DownloadClients/downloadClient:DownloadClient example 1
        ```

        :param str resource_name: The name of the resource.
        :param DownloadClientArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DownloadClientArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 add_paused: Optional[pulumi.Input[bool]] = None,
                 add_stopped: Optional[pulumi.Input[bool]] = None,
                 additional_tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 api_key: Optional[pulumi.Input[str]] = None,
                 category: Optional[pulumi.Input[str]] = None,
                 config_contract: Optional[pulumi.Input[str]] = None,
                 destination: Optional[pulumi.Input[str]] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 field_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 first_and_last: Optional[pulumi.Input[bool]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 implementation: Optional[pulumi.Input[str]] = None,
                 initial_state: Optional[pulumi.Input[int]] = None,
                 intial_state: Optional[pulumi.Input[int]] = None,
                 magnet_file_extension: Optional[pulumi.Input[str]] = None,
                 music_category: Optional[pulumi.Input[str]] = None,
                 music_directory: Optional[pulumi.Input[str]] = None,
                 music_imported_category: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nzb_folder: Optional[pulumi.Input[str]] = None,
                 older_music_priority: Optional[pulumi.Input[int]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 post_import_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 recent_music_priority: Optional[pulumi.Input[int]] = None,
                 remove_completed_downloads: Optional[pulumi.Input[bool]] = None,
                 remove_failed_downloads: Optional[pulumi.Input[bool]] = None,
                 rpc_path: Optional[pulumi.Input[str]] = None,
                 save_magnet_files: Optional[pulumi.Input[bool]] = None,
                 secret_token: Optional[pulumi.Input[str]] = None,
                 sequential_order: Optional[pulumi.Input[bool]] = None,
                 start_on_add: Optional[pulumi.Input[bool]] = None,
                 strm_folder: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 torrent_folder: Optional[pulumi.Input[str]] = None,
                 url_base: Optional[pulumi.Input[str]] = None,
                 use_ssl: Optional[pulumi.Input[bool]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 watch_folder: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DownloadClientArgs.__new__(DownloadClientArgs)

            __props__.__dict__["add_paused"] = add_paused
            __props__.__dict__["add_stopped"] = add_stopped
            __props__.__dict__["additional_tags"] = additional_tags
            __props__.__dict__["api_key"] = None if api_key is None else pulumi.Output.secret(api_key)
            __props__.__dict__["category"] = category
            if config_contract is None and not opts.urn:
                raise TypeError("Missing required property 'config_contract'")
            __props__.__dict__["config_contract"] = config_contract
            __props__.__dict__["destination"] = destination
            __props__.__dict__["enable"] = enable
            __props__.__dict__["field_tags"] = field_tags
            __props__.__dict__["first_and_last"] = first_and_last
            __props__.__dict__["host"] = host
            if implementation is None and not opts.urn:
                raise TypeError("Missing required property 'implementation'")
            __props__.__dict__["implementation"] = implementation
            __props__.__dict__["initial_state"] = initial_state
            __props__.__dict__["intial_state"] = intial_state
            __props__.__dict__["magnet_file_extension"] = magnet_file_extension
            __props__.__dict__["music_category"] = music_category
            __props__.__dict__["music_directory"] = music_directory
            __props__.__dict__["music_imported_category"] = music_imported_category
            __props__.__dict__["name"] = name
            __props__.__dict__["nzb_folder"] = nzb_folder
            __props__.__dict__["older_music_priority"] = older_music_priority
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["port"] = port
            __props__.__dict__["post_import_tags"] = post_import_tags
            __props__.__dict__["priority"] = priority
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["read_only"] = read_only
            __props__.__dict__["recent_music_priority"] = recent_music_priority
            __props__.__dict__["remove_completed_downloads"] = remove_completed_downloads
            __props__.__dict__["remove_failed_downloads"] = remove_failed_downloads
            __props__.__dict__["rpc_path"] = rpc_path
            __props__.__dict__["save_magnet_files"] = save_magnet_files
            __props__.__dict__["secret_token"] = None if secret_token is None else pulumi.Output.secret(secret_token)
            __props__.__dict__["sequential_order"] = sequential_order
            __props__.__dict__["start_on_add"] = start_on_add
            __props__.__dict__["strm_folder"] = strm_folder
            __props__.__dict__["tags"] = tags
            __props__.__dict__["torrent_folder"] = torrent_folder
            __props__.__dict__["url_base"] = url_base
            __props__.__dict__["use_ssl"] = use_ssl
            __props__.__dict__["username"] = username
            __props__.__dict__["watch_folder"] = watch_folder
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["apiKey", "password", "secretToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(DownloadClient, __self__).__init__(
            'lidarr:DownloadClients/downloadClient:DownloadClient',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            add_paused: Optional[pulumi.Input[bool]] = None,
            add_stopped: Optional[pulumi.Input[bool]] = None,
            additional_tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            api_key: Optional[pulumi.Input[str]] = None,
            category: Optional[pulumi.Input[str]] = None,
            config_contract: Optional[pulumi.Input[str]] = None,
            destination: Optional[pulumi.Input[str]] = None,
            enable: Optional[pulumi.Input[bool]] = None,
            field_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            first_and_last: Optional[pulumi.Input[bool]] = None,
            host: Optional[pulumi.Input[str]] = None,
            implementation: Optional[pulumi.Input[str]] = None,
            initial_state: Optional[pulumi.Input[int]] = None,
            intial_state: Optional[pulumi.Input[int]] = None,
            magnet_file_extension: Optional[pulumi.Input[str]] = None,
            music_category: Optional[pulumi.Input[str]] = None,
            music_directory: Optional[pulumi.Input[str]] = None,
            music_imported_category: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            nzb_folder: Optional[pulumi.Input[str]] = None,
            older_music_priority: Optional[pulumi.Input[int]] = None,
            password: Optional[pulumi.Input[str]] = None,
            port: Optional[pulumi.Input[int]] = None,
            post_import_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            protocol: Optional[pulumi.Input[str]] = None,
            read_only: Optional[pulumi.Input[bool]] = None,
            recent_music_priority: Optional[pulumi.Input[int]] = None,
            remove_completed_downloads: Optional[pulumi.Input[bool]] = None,
            remove_failed_downloads: Optional[pulumi.Input[bool]] = None,
            rpc_path: Optional[pulumi.Input[str]] = None,
            save_magnet_files: Optional[pulumi.Input[bool]] = None,
            secret_token: Optional[pulumi.Input[str]] = None,
            sequential_order: Optional[pulumi.Input[bool]] = None,
            start_on_add: Optional[pulumi.Input[bool]] = None,
            strm_folder: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            torrent_folder: Optional[pulumi.Input[str]] = None,
            url_base: Optional[pulumi.Input[str]] = None,
            use_ssl: Optional[pulumi.Input[bool]] = None,
            username: Optional[pulumi.Input[str]] = None,
            watch_folder: Optional[pulumi.Input[str]] = None) -> 'DownloadClient':
        """
        Get an existing DownloadClient resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] add_paused: Add paused flag.
        :param pulumi.Input[bool] add_stopped: Add stopped flag.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] additional_tags: Additional tags, `0` TitleSlug, `1` Quality, `2` Language, `3` ReleaseGroup, `4` Year, `5` Indexer, `6` Network.
        :param pulumi.Input[str] api_key: API key.
        :param pulumi.Input[str] category: Category.
        :param pulumi.Input[str] config_contract: DownloadClient configuration template.
        :param pulumi.Input[str] destination: Destination.
        :param pulumi.Input[bool] enable: Enable flag.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] field_tags: Field tags.
        :param pulumi.Input[bool] first_and_last: First and last flag.
        :param pulumi.Input[str] host: host.
        :param pulumi.Input[str] implementation: DownloadClient implementation name.
        :param pulumi.Input[int] initial_state: Initial state. `0` Start, `1` ForceStart, `2` Pause.
        :param pulumi.Input[int] intial_state: Initial state, with Stop support. `0` Start, `1` ForceStart, `2` Pause, `3` Stop.
        :param pulumi.Input[str] magnet_file_extension: Magnet file extension.
        :param pulumi.Input[str] music_category: Music category.
        :param pulumi.Input[str] music_directory: Music directory.
        :param pulumi.Input[str] music_imported_category: Music imported category.
        :param pulumi.Input[str] name: Download Client name.
        :param pulumi.Input[str] nzb_folder: NZB folder.
        :param pulumi.Input[int] older_music_priority: Older Music priority. `0` Last, `1` First.
        :param pulumi.Input[str] password: Password.
        :param pulumi.Input[int] port: Port.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] post_import_tags: Post import tags.
        :param pulumi.Input[int] priority: Priority.
        :param pulumi.Input[str] protocol: Protocol. Valid values are 'usenet' and 'torrent'.
        :param pulumi.Input[bool] read_only: Read only flag.
        :param pulumi.Input[int] recent_music_priority: Recent Music priority. `0` Last, `1` First.
        :param pulumi.Input[bool] remove_completed_downloads: Remove completed downloads flag.
        :param pulumi.Input[bool] remove_failed_downloads: Remove failed downloads flag.
        :param pulumi.Input[str] rpc_path: RPC path.
        :param pulumi.Input[bool] save_magnet_files: Save magnet files flag.
        :param pulumi.Input[str] secret_token: Secret token.
        :param pulumi.Input[bool] sequential_order: Sequential order flag.
        :param pulumi.Input[bool] start_on_add: Start on add flag.
        :param pulumi.Input[str] strm_folder: STRM folder.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        :param pulumi.Input[str] torrent_folder: Torrent folder.
        :param pulumi.Input[str] url_base: Base URL.
        :param pulumi.Input[bool] use_ssl: Use SSL flag.
        :param pulumi.Input[str] username: Username.
        :param pulumi.Input[str] watch_folder: Watch folder flag.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DownloadClientState.__new__(_DownloadClientState)

        __props__.__dict__["add_paused"] = add_paused
        __props__.__dict__["add_stopped"] = add_stopped
        __props__.__dict__["additional_tags"] = additional_tags
        __props__.__dict__["api_key"] = api_key
        __props__.__dict__["category"] = category
        __props__.__dict__["config_contract"] = config_contract
        __props__.__dict__["destination"] = destination
        __props__.__dict__["enable"] = enable
        __props__.__dict__["field_tags"] = field_tags
        __props__.__dict__["first_and_last"] = first_and_last
        __props__.__dict__["host"] = host
        __props__.__dict__["implementation"] = implementation
        __props__.__dict__["initial_state"] = initial_state
        __props__.__dict__["intial_state"] = intial_state
        __props__.__dict__["magnet_file_extension"] = magnet_file_extension
        __props__.__dict__["music_category"] = music_category
        __props__.__dict__["music_directory"] = music_directory
        __props__.__dict__["music_imported_category"] = music_imported_category
        __props__.__dict__["name"] = name
        __props__.__dict__["nzb_folder"] = nzb_folder
        __props__.__dict__["older_music_priority"] = older_music_priority
        __props__.__dict__["password"] = password
        __props__.__dict__["port"] = port
        __props__.__dict__["post_import_tags"] = post_import_tags
        __props__.__dict__["priority"] = priority
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["read_only"] = read_only
        __props__.__dict__["recent_music_priority"] = recent_music_priority
        __props__.__dict__["remove_completed_downloads"] = remove_completed_downloads
        __props__.__dict__["remove_failed_downloads"] = remove_failed_downloads
        __props__.__dict__["rpc_path"] = rpc_path
        __props__.__dict__["save_magnet_files"] = save_magnet_files
        __props__.__dict__["secret_token"] = secret_token
        __props__.__dict__["sequential_order"] = sequential_order
        __props__.__dict__["start_on_add"] = start_on_add
        __props__.__dict__["strm_folder"] = strm_folder
        __props__.__dict__["tags"] = tags
        __props__.__dict__["torrent_folder"] = torrent_folder
        __props__.__dict__["url_base"] = url_base
        __props__.__dict__["use_ssl"] = use_ssl
        __props__.__dict__["username"] = username
        __props__.__dict__["watch_folder"] = watch_folder
        return DownloadClient(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="addPaused")
    def add_paused(self) -> pulumi.Output[bool]:
        """
        Add paused flag.
        """
        return pulumi.get(self, "add_paused")

    @property
    @pulumi.getter(name="addStopped")
    def add_stopped(self) -> pulumi.Output[bool]:
        """
        Add stopped flag.
        """
        return pulumi.get(self, "add_stopped")

    @property
    @pulumi.getter(name="additionalTags")
    def additional_tags(self) -> pulumi.Output[Sequence[int]]:
        """
        Additional tags, `0` TitleSlug, `1` Quality, `2` Language, `3` ReleaseGroup, `4` Year, `5` Indexer, `6` Network.
        """
        return pulumi.get(self, "additional_tags")

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Output[str]:
        """
        API key.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter
    def category(self) -> pulumi.Output[str]:
        """
        Category.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="configContract")
    def config_contract(self) -> pulumi.Output[str]:
        """
        DownloadClient configuration template.
        """
        return pulumi.get(self, "config_contract")

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Output[str]:
        """
        Destination.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def enable(self) -> pulumi.Output[bool]:
        """
        Enable flag.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter(name="fieldTags")
    def field_tags(self) -> pulumi.Output[Sequence[str]]:
        """
        Field tags.
        """
        return pulumi.get(self, "field_tags")

    @property
    @pulumi.getter(name="firstAndLast")
    def first_and_last(self) -> pulumi.Output[bool]:
        """
        First and last flag.
        """
        return pulumi.get(self, "first_and_last")

    @property
    @pulumi.getter
    def host(self) -> pulumi.Output[str]:
        """
        host.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def implementation(self) -> pulumi.Output[str]:
        """
        DownloadClient implementation name.
        """
        return pulumi.get(self, "implementation")

    @property
    @pulumi.getter(name="initialState")
    def initial_state(self) -> pulumi.Output[int]:
        """
        Initial state. `0` Start, `1` ForceStart, `2` Pause.
        """
        return pulumi.get(self, "initial_state")

    @property
    @pulumi.getter(name="intialState")
    def intial_state(self) -> pulumi.Output[int]:
        """
        Initial state, with Stop support. `0` Start, `1` ForceStart, `2` Pause, `3` Stop.
        """
        return pulumi.get(self, "intial_state")

    @property
    @pulumi.getter(name="magnetFileExtension")
    def magnet_file_extension(self) -> pulumi.Output[str]:
        """
        Magnet file extension.
        """
        return pulumi.get(self, "magnet_file_extension")

    @property
    @pulumi.getter(name="musicCategory")
    def music_category(self) -> pulumi.Output[str]:
        """
        Music category.
        """
        return pulumi.get(self, "music_category")

    @property
    @pulumi.getter(name="musicDirectory")
    def music_directory(self) -> pulumi.Output[str]:
        """
        Music directory.
        """
        return pulumi.get(self, "music_directory")

    @property
    @pulumi.getter(name="musicImportedCategory")
    def music_imported_category(self) -> pulumi.Output[str]:
        """
        Music imported category.
        """
        return pulumi.get(self, "music_imported_category")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Download Client name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nzbFolder")
    def nzb_folder(self) -> pulumi.Output[str]:
        """
        NZB folder.
        """
        return pulumi.get(self, "nzb_folder")

    @property
    @pulumi.getter(name="olderMusicPriority")
    def older_music_priority(self) -> pulumi.Output[int]:
        """
        Older Music priority. `0` Last, `1` First.
        """
        return pulumi.get(self, "older_music_priority")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        Password.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        Port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="postImportTags")
    def post_import_tags(self) -> pulumi.Output[Sequence[str]]:
        """
        Post import tags.
        """
        return pulumi.get(self, "post_import_tags")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[int]:
        """
        Priority.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[str]:
        """
        Protocol. Valid values are 'usenet' and 'torrent'.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> pulumi.Output[bool]:
        """
        Read only flag.
        """
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter(name="recentMusicPriority")
    def recent_music_priority(self) -> pulumi.Output[int]:
        """
        Recent Music priority. `0` Last, `1` First.
        """
        return pulumi.get(self, "recent_music_priority")

    @property
    @pulumi.getter(name="removeCompletedDownloads")
    def remove_completed_downloads(self) -> pulumi.Output[bool]:
        """
        Remove completed downloads flag.
        """
        return pulumi.get(self, "remove_completed_downloads")

    @property
    @pulumi.getter(name="removeFailedDownloads")
    def remove_failed_downloads(self) -> pulumi.Output[bool]:
        """
        Remove failed downloads flag.
        """
        return pulumi.get(self, "remove_failed_downloads")

    @property
    @pulumi.getter(name="rpcPath")
    def rpc_path(self) -> pulumi.Output[str]:
        """
        RPC path.
        """
        return pulumi.get(self, "rpc_path")

    @property
    @pulumi.getter(name="saveMagnetFiles")
    def save_magnet_files(self) -> pulumi.Output[bool]:
        """
        Save magnet files flag.
        """
        return pulumi.get(self, "save_magnet_files")

    @property
    @pulumi.getter(name="secretToken")
    def secret_token(self) -> pulumi.Output[str]:
        """
        Secret token.
        """
        return pulumi.get(self, "secret_token")

    @property
    @pulumi.getter(name="sequentialOrder")
    def sequential_order(self) -> pulumi.Output[bool]:
        """
        Sequential order flag.
        """
        return pulumi.get(self, "sequential_order")

    @property
    @pulumi.getter(name="startOnAdd")
    def start_on_add(self) -> pulumi.Output[bool]:
        """
        Start on add flag.
        """
        return pulumi.get(self, "start_on_add")

    @property
    @pulumi.getter(name="strmFolder")
    def strm_folder(self) -> pulumi.Output[str]:
        """
        STRM folder.
        """
        return pulumi.get(self, "strm_folder")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[int]]:
        """
        List of associated tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="torrentFolder")
    def torrent_folder(self) -> pulumi.Output[str]:
        """
        Torrent folder.
        """
        return pulumi.get(self, "torrent_folder")

    @property
    @pulumi.getter(name="urlBase")
    def url_base(self) -> pulumi.Output[str]:
        """
        Base URL.
        """
        return pulumi.get(self, "url_base")

    @property
    @pulumi.getter(name="useSsl")
    def use_ssl(self) -> pulumi.Output[bool]:
        """
        Use SSL flag.
        """
        return pulumi.get(self, "use_ssl")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        Username.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="watchFolder")
    def watch_folder(self) -> pulumi.Output[str]:
        """
        Watch folder flag.
        """
        return pulumi.get(self, "watch_folder")

