# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ConfigArgs', 'Config']

@pulumi.input_type
class ConfigArgs:
    def __init__(__self__, *,
                 auto_redownload_failed: pulumi.Input[bool],
                 enable_completed_download_handling: pulumi.Input[bool]):
        """
        The set of arguments for constructing a Config resource.
        :param pulumi.Input[bool] auto_redownload_failed: Auto Redownload Failed flag.
        :param pulumi.Input[bool] enable_completed_download_handling: Enable Completed Download Handling flag.
        """
        pulumi.set(__self__, "auto_redownload_failed", auto_redownload_failed)
        pulumi.set(__self__, "enable_completed_download_handling", enable_completed_download_handling)

    @property
    @pulumi.getter(name="autoRedownloadFailed")
    def auto_redownload_failed(self) -> pulumi.Input[bool]:
        """
        Auto Redownload Failed flag.
        """
        return pulumi.get(self, "auto_redownload_failed")

    @auto_redownload_failed.setter
    def auto_redownload_failed(self, value: pulumi.Input[bool]):
        pulumi.set(self, "auto_redownload_failed", value)

    @property
    @pulumi.getter(name="enableCompletedDownloadHandling")
    def enable_completed_download_handling(self) -> pulumi.Input[bool]:
        """
        Enable Completed Download Handling flag.
        """
        return pulumi.get(self, "enable_completed_download_handling")

    @enable_completed_download_handling.setter
    def enable_completed_download_handling(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable_completed_download_handling", value)


@pulumi.input_type
class _ConfigState:
    def __init__(__self__, *,
                 auto_redownload_failed: Optional[pulumi.Input[bool]] = None,
                 download_client_working_folders: Optional[pulumi.Input[str]] = None,
                 enable_completed_download_handling: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering Config resources.
        :param pulumi.Input[bool] auto_redownload_failed: Auto Redownload Failed flag.
        :param pulumi.Input[str] download_client_working_folders: Download Client Working Folders.
        :param pulumi.Input[bool] enable_completed_download_handling: Enable Completed Download Handling flag.
        """
        if auto_redownload_failed is not None:
            pulumi.set(__self__, "auto_redownload_failed", auto_redownload_failed)
        if download_client_working_folders is not None:
            pulumi.set(__self__, "download_client_working_folders", download_client_working_folders)
        if enable_completed_download_handling is not None:
            pulumi.set(__self__, "enable_completed_download_handling", enable_completed_download_handling)

    @property
    @pulumi.getter(name="autoRedownloadFailed")
    def auto_redownload_failed(self) -> Optional[pulumi.Input[bool]]:
        """
        Auto Redownload Failed flag.
        """
        return pulumi.get(self, "auto_redownload_failed")

    @auto_redownload_failed.setter
    def auto_redownload_failed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_redownload_failed", value)

    @property
    @pulumi.getter(name="downloadClientWorkingFolders")
    def download_client_working_folders(self) -> Optional[pulumi.Input[str]]:
        """
        Download Client Working Folders.
        """
        return pulumi.get(self, "download_client_working_folders")

    @download_client_working_folders.setter
    def download_client_working_folders(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "download_client_working_folders", value)

    @property
    @pulumi.getter(name="enableCompletedDownloadHandling")
    def enable_completed_download_handling(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Completed Download Handling flag.
        """
        return pulumi.get(self, "enable_completed_download_handling")

    @enable_completed_download_handling.setter
    def enable_completed_download_handling(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_completed_download_handling", value)


class Config(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_redownload_failed: Optional[pulumi.Input[bool]] = None,
                 enable_completed_download_handling: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        <!-- subcategory:Download Clients -->Download Client Config resource.
        For more information refer to [Download Client](https://wiki.servarr.com/lidarr/settings#completed-download-handling) documentation.

        ## Import

        import does not need parameters

        ```sh
         $ pulumi import lidarr:DownloadClients/config:Config example ""
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_redownload_failed: Auto Redownload Failed flag.
        :param pulumi.Input[bool] enable_completed_download_handling: Enable Completed Download Handling flag.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        <!-- subcategory:Download Clients -->Download Client Config resource.
        For more information refer to [Download Client](https://wiki.servarr.com/lidarr/settings#completed-download-handling) documentation.

        ## Import

        import does not need parameters

        ```sh
         $ pulumi import lidarr:DownloadClients/config:Config example ""
        ```

        :param str resource_name: The name of the resource.
        :param ConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_redownload_failed: Optional[pulumi.Input[bool]] = None,
                 enable_completed_download_handling: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConfigArgs.__new__(ConfigArgs)

            if auto_redownload_failed is None and not opts.urn:
                raise TypeError("Missing required property 'auto_redownload_failed'")
            __props__.__dict__["auto_redownload_failed"] = auto_redownload_failed
            if enable_completed_download_handling is None and not opts.urn:
                raise TypeError("Missing required property 'enable_completed_download_handling'")
            __props__.__dict__["enable_completed_download_handling"] = enable_completed_download_handling
            __props__.__dict__["download_client_working_folders"] = None
        super(Config, __self__).__init__(
            'lidarr:DownloadClients/config:Config',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_redownload_failed: Optional[pulumi.Input[bool]] = None,
            download_client_working_folders: Optional[pulumi.Input[str]] = None,
            enable_completed_download_handling: Optional[pulumi.Input[bool]] = None) -> 'Config':
        """
        Get an existing Config resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_redownload_failed: Auto Redownload Failed flag.
        :param pulumi.Input[str] download_client_working_folders: Download Client Working Folders.
        :param pulumi.Input[bool] enable_completed_download_handling: Enable Completed Download Handling flag.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConfigState.__new__(_ConfigState)

        __props__.__dict__["auto_redownload_failed"] = auto_redownload_failed
        __props__.__dict__["download_client_working_folders"] = download_client_working_folders
        __props__.__dict__["enable_completed_download_handling"] = enable_completed_download_handling
        return Config(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoRedownloadFailed")
    def auto_redownload_failed(self) -> pulumi.Output[bool]:
        """
        Auto Redownload Failed flag.
        """
        return pulumi.get(self, "auto_redownload_failed")

    @property
    @pulumi.getter(name="downloadClientWorkingFolders")
    def download_client_working_folders(self) -> pulumi.Output[str]:
        """
        Download Client Working Folders.
        """
        return pulumi.get(self, "download_client_working_folders")

    @property
    @pulumi.getter(name="enableCompletedDownloadHandling")
    def enable_completed_download_handling(self) -> pulumi.Output[bool]:
        """
        Enable Completed Download Handling flag.
        """
        return pulumi.get(self, "enable_completed_download_handling")

