# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['Aria2Args', 'Aria2']

@pulumi.input_type
class Aria2Args:
    def __init__(__self__, *,
                 enable: Optional[pulumi.Input[bool]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 remove_completed_downloads: Optional[pulumi.Input[bool]] = None,
                 remove_failed_downloads: Optional[pulumi.Input[bool]] = None,
                 rpc_path: Optional[pulumi.Input[str]] = None,
                 secret_token: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 use_ssl: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Aria2 resource.
        :param pulumi.Input[bool] enable: Enable flag.
        :param pulumi.Input[str] host: host.
        :param pulumi.Input[str] name: Download Client name.
        :param pulumi.Input[int] port: Port.
        :param pulumi.Input[int] priority: Priority.
        :param pulumi.Input[bool] remove_completed_downloads: Remove completed downloads flag.
        :param pulumi.Input[bool] remove_failed_downloads: Remove failed downloads flag.
        :param pulumi.Input[str] rpc_path: RPC path.
        :param pulumi.Input[str] secret_token: Secret token.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        :param pulumi.Input[bool] use_ssl: Use SSL flag.
        """
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if remove_completed_downloads is not None:
            pulumi.set(__self__, "remove_completed_downloads", remove_completed_downloads)
        if remove_failed_downloads is not None:
            pulumi.set(__self__, "remove_failed_downloads", remove_failed_downloads)
        if rpc_path is not None:
            pulumi.set(__self__, "rpc_path", rpc_path)
        if secret_token is not None:
            pulumi.set(__self__, "secret_token", secret_token)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if use_ssl is not None:
            pulumi.set(__self__, "use_ssl", use_ssl)

    @property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable flag.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        host.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Download Client name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="removeCompletedDownloads")
    def remove_completed_downloads(self) -> Optional[pulumi.Input[bool]]:
        """
        Remove completed downloads flag.
        """
        return pulumi.get(self, "remove_completed_downloads")

    @remove_completed_downloads.setter
    def remove_completed_downloads(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remove_completed_downloads", value)

    @property
    @pulumi.getter(name="removeFailedDownloads")
    def remove_failed_downloads(self) -> Optional[pulumi.Input[bool]]:
        """
        Remove failed downloads flag.
        """
        return pulumi.get(self, "remove_failed_downloads")

    @remove_failed_downloads.setter
    def remove_failed_downloads(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remove_failed_downloads", value)

    @property
    @pulumi.getter(name="rpcPath")
    def rpc_path(self) -> Optional[pulumi.Input[str]]:
        """
        RPC path.
        """
        return pulumi.get(self, "rpc_path")

    @rpc_path.setter
    def rpc_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rpc_path", value)

    @property
    @pulumi.getter(name="secretToken")
    def secret_token(self) -> Optional[pulumi.Input[str]]:
        """
        Secret token.
        """
        return pulumi.get(self, "secret_token")

    @secret_token.setter
    def secret_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_token", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        List of associated tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="useSsl")
    def use_ssl(self) -> Optional[pulumi.Input[bool]]:
        """
        Use SSL flag.
        """
        return pulumi.get(self, "use_ssl")

    @use_ssl.setter
    def use_ssl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_ssl", value)


@pulumi.input_type
class _Aria2State:
    def __init__(__self__, *,
                 enable: Optional[pulumi.Input[bool]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 remove_completed_downloads: Optional[pulumi.Input[bool]] = None,
                 remove_failed_downloads: Optional[pulumi.Input[bool]] = None,
                 rpc_path: Optional[pulumi.Input[str]] = None,
                 secret_token: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 use_ssl: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering Aria2 resources.
        :param pulumi.Input[bool] enable: Enable flag.
        :param pulumi.Input[str] host: host.
        :param pulumi.Input[str] name: Download Client name.
        :param pulumi.Input[int] port: Port.
        :param pulumi.Input[int] priority: Priority.
        :param pulumi.Input[bool] remove_completed_downloads: Remove completed downloads flag.
        :param pulumi.Input[bool] remove_failed_downloads: Remove failed downloads flag.
        :param pulumi.Input[str] rpc_path: RPC path.
        :param pulumi.Input[str] secret_token: Secret token.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        :param pulumi.Input[bool] use_ssl: Use SSL flag.
        """
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if remove_completed_downloads is not None:
            pulumi.set(__self__, "remove_completed_downloads", remove_completed_downloads)
        if remove_failed_downloads is not None:
            pulumi.set(__self__, "remove_failed_downloads", remove_failed_downloads)
        if rpc_path is not None:
            pulumi.set(__self__, "rpc_path", rpc_path)
        if secret_token is not None:
            pulumi.set(__self__, "secret_token", secret_token)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if use_ssl is not None:
            pulumi.set(__self__, "use_ssl", use_ssl)

    @property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable flag.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        host.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Download Client name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="removeCompletedDownloads")
    def remove_completed_downloads(self) -> Optional[pulumi.Input[bool]]:
        """
        Remove completed downloads flag.
        """
        return pulumi.get(self, "remove_completed_downloads")

    @remove_completed_downloads.setter
    def remove_completed_downloads(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remove_completed_downloads", value)

    @property
    @pulumi.getter(name="removeFailedDownloads")
    def remove_failed_downloads(self) -> Optional[pulumi.Input[bool]]:
        """
        Remove failed downloads flag.
        """
        return pulumi.get(self, "remove_failed_downloads")

    @remove_failed_downloads.setter
    def remove_failed_downloads(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remove_failed_downloads", value)

    @property
    @pulumi.getter(name="rpcPath")
    def rpc_path(self) -> Optional[pulumi.Input[str]]:
        """
        RPC path.
        """
        return pulumi.get(self, "rpc_path")

    @rpc_path.setter
    def rpc_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rpc_path", value)

    @property
    @pulumi.getter(name="secretToken")
    def secret_token(self) -> Optional[pulumi.Input[str]]:
        """
        Secret token.
        """
        return pulumi.get(self, "secret_token")

    @secret_token.setter
    def secret_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_token", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        List of associated tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="useSsl")
    def use_ssl(self) -> Optional[pulumi.Input[bool]]:
        """
        Use SSL flag.
        """
        return pulumi.get(self, "use_ssl")

    @use_ssl.setter
    def use_ssl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_ssl", value)


class Aria2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 remove_completed_downloads: Optional[pulumi.Input[bool]] = None,
                 remove_failed_downloads: Optional[pulumi.Input[bool]] = None,
                 rpc_path: Optional[pulumi.Input[str]] = None,
                 secret_token: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 use_ssl: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        <!-- subcategory:Download Clients -->Download Client Aria2 resource.
        For more information refer to [Download Client](https://wiki.servarr.com/lidarr/settings#download-clients) and [Aria2](https://wiki.servarr.com/lidarr/supported#aria2).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.download_clients.Aria2("example",
            enable=True,
            host="aria2",
            port=6800,
            priority=1,
            rpc_path="/aria2/")
        ```

        ## Import

        import using the API/UI ID

        ```sh
         $ pulumi import lidarr:DownloadClients/aria2:Aria2 example 1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enable: Enable flag.
        :param pulumi.Input[str] host: host.
        :param pulumi.Input[str] name: Download Client name.
        :param pulumi.Input[int] port: Port.
        :param pulumi.Input[int] priority: Priority.
        :param pulumi.Input[bool] remove_completed_downloads: Remove completed downloads flag.
        :param pulumi.Input[bool] remove_failed_downloads: Remove failed downloads flag.
        :param pulumi.Input[str] rpc_path: RPC path.
        :param pulumi.Input[str] secret_token: Secret token.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        :param pulumi.Input[bool] use_ssl: Use SSL flag.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[Aria2Args] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        <!-- subcategory:Download Clients -->Download Client Aria2 resource.
        For more information refer to [Download Client](https://wiki.servarr.com/lidarr/settings#download-clients) and [Aria2](https://wiki.servarr.com/lidarr/supported#aria2).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.download_clients.Aria2("example",
            enable=True,
            host="aria2",
            port=6800,
            priority=1,
            rpc_path="/aria2/")
        ```

        ## Import

        import using the API/UI ID

        ```sh
         $ pulumi import lidarr:DownloadClients/aria2:Aria2 example 1
        ```

        :param str resource_name: The name of the resource.
        :param Aria2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(Aria2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 remove_completed_downloads: Optional[pulumi.Input[bool]] = None,
                 remove_failed_downloads: Optional[pulumi.Input[bool]] = None,
                 rpc_path: Optional[pulumi.Input[str]] = None,
                 secret_token: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 use_ssl: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = Aria2Args.__new__(Aria2Args)

            __props__.__dict__["enable"] = enable
            __props__.__dict__["host"] = host
            __props__.__dict__["name"] = name
            __props__.__dict__["port"] = port
            __props__.__dict__["priority"] = priority
            __props__.__dict__["remove_completed_downloads"] = remove_completed_downloads
            __props__.__dict__["remove_failed_downloads"] = remove_failed_downloads
            __props__.__dict__["rpc_path"] = rpc_path
            __props__.__dict__["secret_token"] = secret_token
            __props__.__dict__["tags"] = tags
            __props__.__dict__["use_ssl"] = use_ssl
        super(Aria2, __self__).__init__(
            'lidarr:DownloadClients/aria2:Aria2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enable: Optional[pulumi.Input[bool]] = None,
            host: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            port: Optional[pulumi.Input[int]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            remove_completed_downloads: Optional[pulumi.Input[bool]] = None,
            remove_failed_downloads: Optional[pulumi.Input[bool]] = None,
            rpc_path: Optional[pulumi.Input[str]] = None,
            secret_token: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            use_ssl: Optional[pulumi.Input[bool]] = None) -> 'Aria2':
        """
        Get an existing Aria2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enable: Enable flag.
        :param pulumi.Input[str] host: host.
        :param pulumi.Input[str] name: Download Client name.
        :param pulumi.Input[int] port: Port.
        :param pulumi.Input[int] priority: Priority.
        :param pulumi.Input[bool] remove_completed_downloads: Remove completed downloads flag.
        :param pulumi.Input[bool] remove_failed_downloads: Remove failed downloads flag.
        :param pulumi.Input[str] rpc_path: RPC path.
        :param pulumi.Input[str] secret_token: Secret token.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        :param pulumi.Input[bool] use_ssl: Use SSL flag.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _Aria2State.__new__(_Aria2State)

        __props__.__dict__["enable"] = enable
        __props__.__dict__["host"] = host
        __props__.__dict__["name"] = name
        __props__.__dict__["port"] = port
        __props__.__dict__["priority"] = priority
        __props__.__dict__["remove_completed_downloads"] = remove_completed_downloads
        __props__.__dict__["remove_failed_downloads"] = remove_failed_downloads
        __props__.__dict__["rpc_path"] = rpc_path
        __props__.__dict__["secret_token"] = secret_token
        __props__.__dict__["tags"] = tags
        __props__.__dict__["use_ssl"] = use_ssl
        return Aria2(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def enable(self) -> pulumi.Output[bool]:
        """
        Enable flag.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def host(self) -> pulumi.Output[str]:
        """
        host.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Download Client name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        Port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[int]:
        """
        Priority.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="removeCompletedDownloads")
    def remove_completed_downloads(self) -> pulumi.Output[bool]:
        """
        Remove completed downloads flag.
        """
        return pulumi.get(self, "remove_completed_downloads")

    @property
    @pulumi.getter(name="removeFailedDownloads")
    def remove_failed_downloads(self) -> pulumi.Output[bool]:
        """
        Remove failed downloads flag.
        """
        return pulumi.get(self, "remove_failed_downloads")

    @property
    @pulumi.getter(name="rpcPath")
    def rpc_path(self) -> pulumi.Output[str]:
        """
        RPC path.
        """
        return pulumi.get(self, "rpc_path")

    @property
    @pulumi.getter(name="secretToken")
    def secret_token(self) -> pulumi.Output[str]:
        """
        Secret token.
        """
        return pulumi.get(self, "secret_token")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[int]]:
        """
        List of associated tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="useSsl")
    def use_ssl(self) -> pulumi.Output[bool]:
        """
        Use SSL flag.
        """
        return pulumi.get(self, "use_ssl")

