# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetArtistResult',
    'AwaitableGetArtistResult',
    'get_artist',
    'get_artist_output',
]

@pulumi.output_type
class GetArtistResult:
    """
    A collection of values returned by getArtist.
    """
    def __init__(__self__, artist_name=None, foreign_artist_id=None, genres=None, id=None, metadata_profile_id=None, monitored=None, overview=None, path=None, quality_profile_id=None, status=None, tags=None):
        if artist_name and not isinstance(artist_name, str):
            raise TypeError("Expected argument 'artist_name' to be a str")
        pulumi.set(__self__, "artist_name", artist_name)
        if foreign_artist_id and not isinstance(foreign_artist_id, str):
            raise TypeError("Expected argument 'foreign_artist_id' to be a str")
        pulumi.set(__self__, "foreign_artist_id", foreign_artist_id)
        if genres and not isinstance(genres, list):
            raise TypeError("Expected argument 'genres' to be a list")
        pulumi.set(__self__, "genres", genres)
        if id and not isinstance(id, int):
            raise TypeError("Expected argument 'id' to be a int")
        pulumi.set(__self__, "id", id)
        if metadata_profile_id and not isinstance(metadata_profile_id, int):
            raise TypeError("Expected argument 'metadata_profile_id' to be a int")
        pulumi.set(__self__, "metadata_profile_id", metadata_profile_id)
        if monitored and not isinstance(monitored, bool):
            raise TypeError("Expected argument 'monitored' to be a bool")
        pulumi.set(__self__, "monitored", monitored)
        if overview and not isinstance(overview, str):
            raise TypeError("Expected argument 'overview' to be a str")
        pulumi.set(__self__, "overview", overview)
        if path and not isinstance(path, str):
            raise TypeError("Expected argument 'path' to be a str")
        pulumi.set(__self__, "path", path)
        if quality_profile_id and not isinstance(quality_profile_id, int):
            raise TypeError("Expected argument 'quality_profile_id' to be a int")
        pulumi.set(__self__, "quality_profile_id", quality_profile_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="artistName")
    def artist_name(self) -> str:
        """
        Artist name.
        """
        return pulumi.get(self, "artist_name")

    @property
    @pulumi.getter(name="foreignArtistId")
    def foreign_artist_id(self) -> str:
        """
        Foreign artist ID.
        """
        return pulumi.get(self, "foreign_artist_id")

    @property
    @pulumi.getter
    def genres(self) -> Sequence[str]:
        """
        List genres.
        """
        return pulumi.get(self, "genres")

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        Artist ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="metadataProfileId")
    def metadata_profile_id(self) -> int:
        """
        Metadata profile ID.
        """
        return pulumi.get(self, "metadata_profile_id")

    @property
    @pulumi.getter
    def monitored(self) -> bool:
        """
        Monitored flag.
        """
        return pulumi.get(self, "monitored")

    @property
    @pulumi.getter
    def overview(self) -> str:
        """
        Overview.
        """
        return pulumi.get(self, "overview")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Full artist path.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="qualityProfileId")
    def quality_profile_id(self) -> int:
        """
        Quality profile ID.
        """
        return pulumi.get(self, "quality_profile_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Artist status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[int]:
        """
        List of associated tags.
        """
        return pulumi.get(self, "tags")


class AwaitableGetArtistResult(GetArtistResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetArtistResult(
            artist_name=self.artist_name,
            foreign_artist_id=self.foreign_artist_id,
            genres=self.genres,
            id=self.id,
            metadata_profile_id=self.metadata_profile_id,
            monitored=self.monitored,
            overview=self.overview,
            path=self.path,
            quality_profile_id=self.quality_profile_id,
            status=self.status,
            tags=self.tags)


def get_artist(foreign_artist_id: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetArtistResult:
    """
    <!-- subcategory:Artists -->Single Artist.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_lidarr as lidarr

    example = lidarr.Artists.get_artist(foreign_artist_id="1f9df192-a621-4f54-8850-2c5373b7eac9")
    ```


    :param str foreign_artist_id: Foreign artist ID.
    """
    __args__ = dict()
    __args__['foreignArtistId'] = foreign_artist_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('lidarr:Artists/getArtist:getArtist', __args__, opts=opts, typ=GetArtistResult).value

    return AwaitableGetArtistResult(
        artist_name=pulumi.get(__ret__, 'artist_name'),
        foreign_artist_id=pulumi.get(__ret__, 'foreign_artist_id'),
        genres=pulumi.get(__ret__, 'genres'),
        id=pulumi.get(__ret__, 'id'),
        metadata_profile_id=pulumi.get(__ret__, 'metadata_profile_id'),
        monitored=pulumi.get(__ret__, 'monitored'),
        overview=pulumi.get(__ret__, 'overview'),
        path=pulumi.get(__ret__, 'path'),
        quality_profile_id=pulumi.get(__ret__, 'quality_profile_id'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'))


@_utilities.lift_output_func(get_artist)
def get_artist_output(foreign_artist_id: Optional[pulumi.Input[str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetArtistResult]:
    """
    <!-- subcategory:Artists -->Single Artist.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_lidarr as lidarr

    example = lidarr.Artists.get_artist(foreign_artist_id="1f9df192-a621-4f54-8850-2c5373b7eac9")
    ```


    :param str foreign_artist_id: Foreign artist ID.
    """
    ...
