# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ArtistArgs', 'Artist']

@pulumi.input_type
class ArtistArgs:
    def __init__(__self__, *,
                 artist_name: pulumi.Input[str],
                 foreign_artist_id: pulumi.Input[str],
                 metadata_profile_id: pulumi.Input[int],
                 monitored: pulumi.Input[bool],
                 path: pulumi.Input[str],
                 quality_profile_id: pulumi.Input[int],
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None):
        """
        The set of arguments for constructing a Artist resource.
        :param pulumi.Input[str] artist_name: Artist name.
        :param pulumi.Input[str] foreign_artist_id: Foreign artist ID.
        :param pulumi.Input[int] metadata_profile_id: Metadata profile ID.
        :param pulumi.Input[bool] monitored: Monitored flag.
        :param pulumi.Input[str] path: Full artist path.
        :param pulumi.Input[int] quality_profile_id: Quality profile ID.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        """
        pulumi.set(__self__, "artist_name", artist_name)
        pulumi.set(__self__, "foreign_artist_id", foreign_artist_id)
        pulumi.set(__self__, "metadata_profile_id", metadata_profile_id)
        pulumi.set(__self__, "monitored", monitored)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "quality_profile_id", quality_profile_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="artistName")
    def artist_name(self) -> pulumi.Input[str]:
        """
        Artist name.
        """
        return pulumi.get(self, "artist_name")

    @artist_name.setter
    def artist_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "artist_name", value)

    @property
    @pulumi.getter(name="foreignArtistId")
    def foreign_artist_id(self) -> pulumi.Input[str]:
        """
        Foreign artist ID.
        """
        return pulumi.get(self, "foreign_artist_id")

    @foreign_artist_id.setter
    def foreign_artist_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "foreign_artist_id", value)

    @property
    @pulumi.getter(name="metadataProfileId")
    def metadata_profile_id(self) -> pulumi.Input[int]:
        """
        Metadata profile ID.
        """
        return pulumi.get(self, "metadata_profile_id")

    @metadata_profile_id.setter
    def metadata_profile_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "metadata_profile_id", value)

    @property
    @pulumi.getter
    def monitored(self) -> pulumi.Input[bool]:
        """
        Monitored flag.
        """
        return pulumi.get(self, "monitored")

    @monitored.setter
    def monitored(self, value: pulumi.Input[bool]):
        pulumi.set(self, "monitored", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        Full artist path.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="qualityProfileId")
    def quality_profile_id(self) -> pulumi.Input[int]:
        """
        Quality profile ID.
        """
        return pulumi.get(self, "quality_profile_id")

    @quality_profile_id.setter
    def quality_profile_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "quality_profile_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        List of associated tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ArtistState:
    def __init__(__self__, *,
                 artist_name: Optional[pulumi.Input[str]] = None,
                 foreign_artist_id: Optional[pulumi.Input[str]] = None,
                 genres: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 metadata_profile_id: Optional[pulumi.Input[int]] = None,
                 monitored: Optional[pulumi.Input[bool]] = None,
                 overview: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 quality_profile_id: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None):
        """
        Input properties used for looking up and filtering Artist resources.
        :param pulumi.Input[str] artist_name: Artist name.
        :param pulumi.Input[str] foreign_artist_id: Foreign artist ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] genres: List genres.
        :param pulumi.Input[int] metadata_profile_id: Metadata profile ID.
        :param pulumi.Input[bool] monitored: Monitored flag.
        :param pulumi.Input[str] overview: Overview.
        :param pulumi.Input[str] path: Full artist path.
        :param pulumi.Input[int] quality_profile_id: Quality profile ID.
        :param pulumi.Input[str] status: Artist status.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        """
        if artist_name is not None:
            pulumi.set(__self__, "artist_name", artist_name)
        if foreign_artist_id is not None:
            pulumi.set(__self__, "foreign_artist_id", foreign_artist_id)
        if genres is not None:
            pulumi.set(__self__, "genres", genres)
        if metadata_profile_id is not None:
            pulumi.set(__self__, "metadata_profile_id", metadata_profile_id)
        if monitored is not None:
            pulumi.set(__self__, "monitored", monitored)
        if overview is not None:
            pulumi.set(__self__, "overview", overview)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if quality_profile_id is not None:
            pulumi.set(__self__, "quality_profile_id", quality_profile_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="artistName")
    def artist_name(self) -> Optional[pulumi.Input[str]]:
        """
        Artist name.
        """
        return pulumi.get(self, "artist_name")

    @artist_name.setter
    def artist_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "artist_name", value)

    @property
    @pulumi.getter(name="foreignArtistId")
    def foreign_artist_id(self) -> Optional[pulumi.Input[str]]:
        """
        Foreign artist ID.
        """
        return pulumi.get(self, "foreign_artist_id")

    @foreign_artist_id.setter
    def foreign_artist_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "foreign_artist_id", value)

    @property
    @pulumi.getter
    def genres(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List genres.
        """
        return pulumi.get(self, "genres")

    @genres.setter
    def genres(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "genres", value)

    @property
    @pulumi.getter(name="metadataProfileId")
    def metadata_profile_id(self) -> Optional[pulumi.Input[int]]:
        """
        Metadata profile ID.
        """
        return pulumi.get(self, "metadata_profile_id")

    @metadata_profile_id.setter
    def metadata_profile_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "metadata_profile_id", value)

    @property
    @pulumi.getter
    def monitored(self) -> Optional[pulumi.Input[bool]]:
        """
        Monitored flag.
        """
        return pulumi.get(self, "monitored")

    @monitored.setter
    def monitored(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "monitored", value)

    @property
    @pulumi.getter
    def overview(self) -> Optional[pulumi.Input[str]]:
        """
        Overview.
        """
        return pulumi.get(self, "overview")

    @overview.setter
    def overview(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "overview", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Full artist path.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="qualityProfileId")
    def quality_profile_id(self) -> Optional[pulumi.Input[int]]:
        """
        Quality profile ID.
        """
        return pulumi.get(self, "quality_profile_id")

    @quality_profile_id.setter
    def quality_profile_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "quality_profile_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Artist status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        List of associated tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "tags", value)


class Artist(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artist_name: Optional[pulumi.Input[str]] = None,
                 foreign_artist_id: Optional[pulumi.Input[str]] = None,
                 metadata_profile_id: Optional[pulumi.Input[int]] = None,
                 monitored: Optional[pulumi.Input[bool]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 quality_profile_id: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 __props__=None):
        """
        <!-- subcategory:Artists -->Artist resource.
        For more information refer to [Artists](https://wiki.servarr.com/lidarr/library#artists) documentation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.artists.Artist("example",
            artist_name="Queen",
            foreign_artist_id="0383dadf-2a4e-4d10-a46a-e9e041da8eb3",
            metadata_profile_id=1,
            monitored=True,
            path="/music/Queen",
            quality_profile_id=1)
        ```

        ## Import

        import using the API/UI ID

        ```sh
         $ pulumi import lidarr:Artists/artist:Artist example 10
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] artist_name: Artist name.
        :param pulumi.Input[str] foreign_artist_id: Foreign artist ID.
        :param pulumi.Input[int] metadata_profile_id: Metadata profile ID.
        :param pulumi.Input[bool] monitored: Monitored flag.
        :param pulumi.Input[str] path: Full artist path.
        :param pulumi.Input[int] quality_profile_id: Quality profile ID.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ArtistArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        <!-- subcategory:Artists -->Artist resource.
        For more information refer to [Artists](https://wiki.servarr.com/lidarr/library#artists) documentation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_lidarr as lidarr

        example = lidarr.artists.Artist("example",
            artist_name="Queen",
            foreign_artist_id="0383dadf-2a4e-4d10-a46a-e9e041da8eb3",
            metadata_profile_id=1,
            monitored=True,
            path="/music/Queen",
            quality_profile_id=1)
        ```

        ## Import

        import using the API/UI ID

        ```sh
         $ pulumi import lidarr:Artists/artist:Artist example 10
        ```

        :param str resource_name: The name of the resource.
        :param ArtistArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ArtistArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artist_name: Optional[pulumi.Input[str]] = None,
                 foreign_artist_id: Optional[pulumi.Input[str]] = None,
                 metadata_profile_id: Optional[pulumi.Input[int]] = None,
                 monitored: Optional[pulumi.Input[bool]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 quality_profile_id: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ArtistArgs.__new__(ArtistArgs)

            if artist_name is None and not opts.urn:
                raise TypeError("Missing required property 'artist_name'")
            __props__.__dict__["artist_name"] = artist_name
            if foreign_artist_id is None and not opts.urn:
                raise TypeError("Missing required property 'foreign_artist_id'")
            __props__.__dict__["foreign_artist_id"] = foreign_artist_id
            if metadata_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'metadata_profile_id'")
            __props__.__dict__["metadata_profile_id"] = metadata_profile_id
            if monitored is None and not opts.urn:
                raise TypeError("Missing required property 'monitored'")
            __props__.__dict__["monitored"] = monitored
            if path is None and not opts.urn:
                raise TypeError("Missing required property 'path'")
            __props__.__dict__["path"] = path
            if quality_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'quality_profile_id'")
            __props__.__dict__["quality_profile_id"] = quality_profile_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["genres"] = None
            __props__.__dict__["overview"] = None
            __props__.__dict__["status"] = None
        super(Artist, __self__).__init__(
            'lidarr:Artists/artist:Artist',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            artist_name: Optional[pulumi.Input[str]] = None,
            foreign_artist_id: Optional[pulumi.Input[str]] = None,
            genres: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            metadata_profile_id: Optional[pulumi.Input[int]] = None,
            monitored: Optional[pulumi.Input[bool]] = None,
            overview: Optional[pulumi.Input[str]] = None,
            path: Optional[pulumi.Input[str]] = None,
            quality_profile_id: Optional[pulumi.Input[int]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None) -> 'Artist':
        """
        Get an existing Artist resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] artist_name: Artist name.
        :param pulumi.Input[str] foreign_artist_id: Foreign artist ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] genres: List genres.
        :param pulumi.Input[int] metadata_profile_id: Metadata profile ID.
        :param pulumi.Input[bool] monitored: Monitored flag.
        :param pulumi.Input[str] overview: Overview.
        :param pulumi.Input[str] path: Full artist path.
        :param pulumi.Input[int] quality_profile_id: Quality profile ID.
        :param pulumi.Input[str] status: Artist status.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] tags: List of associated tags.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ArtistState.__new__(_ArtistState)

        __props__.__dict__["artist_name"] = artist_name
        __props__.__dict__["foreign_artist_id"] = foreign_artist_id
        __props__.__dict__["genres"] = genres
        __props__.__dict__["metadata_profile_id"] = metadata_profile_id
        __props__.__dict__["monitored"] = monitored
        __props__.__dict__["overview"] = overview
        __props__.__dict__["path"] = path
        __props__.__dict__["quality_profile_id"] = quality_profile_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        return Artist(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="artistName")
    def artist_name(self) -> pulumi.Output[str]:
        """
        Artist name.
        """
        return pulumi.get(self, "artist_name")

    @property
    @pulumi.getter(name="foreignArtistId")
    def foreign_artist_id(self) -> pulumi.Output[str]:
        """
        Foreign artist ID.
        """
        return pulumi.get(self, "foreign_artist_id")

    @property
    @pulumi.getter
    def genres(self) -> pulumi.Output[Sequence[str]]:
        """
        List genres.
        """
        return pulumi.get(self, "genres")

    @property
    @pulumi.getter(name="metadataProfileId")
    def metadata_profile_id(self) -> pulumi.Output[int]:
        """
        Metadata profile ID.
        """
        return pulumi.get(self, "metadata_profile_id")

    @property
    @pulumi.getter
    def monitored(self) -> pulumi.Output[bool]:
        """
        Monitored flag.
        """
        return pulumi.get(self, "monitored")

    @property
    @pulumi.getter
    def overview(self) -> pulumi.Output[str]:
        """
        Overview.
        """
        return pulumi.get(self, "overview")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[str]:
        """
        Full artist path.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="qualityProfileId")
    def quality_profile_id(self) -> pulumi.Output[int]:
        """
        Quality profile ID.
        """
        return pulumi.get(self, "quality_profile_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Artist status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[int]]:
        """
        List of associated tags.
        """
        return pulumi.get(self, "tags")

