# coding: utf-8

"""
    convertapi

    Convert API lets you effortlessly convert file formats and types.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from cloudmersive_convert_api_client.models.docx_text import DocxText  # noqa: F401,E501


class DocxRun(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'run_index': 'int',
        'path': 'str',
        'text_items': 'list[DocxText]',
        'bold': 'bool',
        'italic': 'bool',
        'underline': 'str',
        'font_family': 'str',
        'font_size': 'str'
    }

    attribute_map = {
        'run_index': 'RunIndex',
        'path': 'Path',
        'text_items': 'TextItems',
        'bold': 'Bold',
        'italic': 'Italic',
        'underline': 'Underline',
        'font_family': 'FontFamily',
        'font_size': 'FontSize'
    }

    def __init__(self, run_index=None, path=None, text_items=None, bold=None, italic=None, underline=None, font_family=None, font_size=None):  # noqa: E501
        """DocxRun - a model defined in Swagger"""  # noqa: E501

        self._run_index = None
        self._path = None
        self._text_items = None
        self._bold = None
        self._italic = None
        self._underline = None
        self._font_family = None
        self._font_size = None
        self.discriminator = None

        if run_index is not None:
            self.run_index = run_index
        if path is not None:
            self.path = path
        if text_items is not None:
            self.text_items = text_items
        if bold is not None:
            self.bold = bold
        if italic is not None:
            self.italic = italic
        if underline is not None:
            self.underline = underline
        if font_family is not None:
            self.font_family = font_family
        if font_size is not None:
            self.font_size = font_size

    @property
    def run_index(self):
        """Gets the run_index of this DocxRun.  # noqa: E501

        Index of the run, 0-based  # noqa: E501

        :return: The run_index of this DocxRun.  # noqa: E501
        :rtype: int
        """
        return self._run_index

    @run_index.setter
    def run_index(self, run_index):
        """Sets the run_index of this DocxRun.

        Index of the run, 0-based  # noqa: E501

        :param run_index: The run_index of this DocxRun.  # noqa: E501
        :type: int
        """

        self._run_index = run_index

    @property
    def path(self):
        """Gets the path of this DocxRun.  # noqa: E501

        The Path of the location of this Run object; leave blank for creation  # noqa: E501

        :return: The path of this DocxRun.  # noqa: E501
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this DocxRun.

        The Path of the location of this Run object; leave blank for creation  # noqa: E501

        :param path: The path of this DocxRun.  # noqa: E501
        :type: str
        """

        self._path = path

    @property
    def text_items(self):
        """Gets the text_items of this DocxRun.  # noqa: E501

        Text items inside the run; this is where the actual text content is stored  # noqa: E501

        :return: The text_items of this DocxRun.  # noqa: E501
        :rtype: list[DocxText]
        """
        return self._text_items

    @text_items.setter
    def text_items(self, text_items):
        """Sets the text_items of this DocxRun.

        Text items inside the run; this is where the actual text content is stored  # noqa: E501

        :param text_items: The text_items of this DocxRun.  # noqa: E501
        :type: list[DocxText]
        """

        self._text_items = text_items

    @property
    def bold(self):
        """Gets the bold of this DocxRun.  # noqa: E501

        True to make the text bold, false otherwise  # noqa: E501

        :return: The bold of this DocxRun.  # noqa: E501
        :rtype: bool
        """
        return self._bold

    @bold.setter
    def bold(self, bold):
        """Sets the bold of this DocxRun.

        True to make the text bold, false otherwise  # noqa: E501

        :param bold: The bold of this DocxRun.  # noqa: E501
        :type: bool
        """

        self._bold = bold

    @property
    def italic(self):
        """Gets the italic of this DocxRun.  # noqa: E501

        True to make the text italic, false otherwise  # noqa: E501

        :return: The italic of this DocxRun.  # noqa: E501
        :rtype: bool
        """
        return self._italic

    @italic.setter
    def italic(self, italic):
        """Sets the italic of this DocxRun.

        True to make the text italic, false otherwise  # noqa: E501

        :param italic: The italic of this DocxRun.  # noqa: E501
        :type: bool
        """

        self._italic = italic

    @property
    def underline(self):
        """Gets the underline of this DocxRun.  # noqa: E501

        Underline mode for the text; possible values are: Words, Double, Thick, Dotted, DottedHeavy, Dash, DashedHeavy, DashLong, DashLongHeavy, DotDash, DashDotHeavy, DotDotDash, DashDotDotHeavy, Wave, WavyHeavy, WavyDouble, None  # noqa: E501

        :return: The underline of this DocxRun.  # noqa: E501
        :rtype: str
        """
        return self._underline

    @underline.setter
    def underline(self, underline):
        """Sets the underline of this DocxRun.

        Underline mode for the text; possible values are: Words, Double, Thick, Dotted, DottedHeavy, Dash, DashedHeavy, DashLong, DashLongHeavy, DotDash, DashDotHeavy, DotDotDash, DashDotDotHeavy, Wave, WavyHeavy, WavyDouble, None  # noqa: E501

        :param underline: The underline of this DocxRun.  # noqa: E501
        :type: str
        """

        self._underline = underline

    @property
    def font_family(self):
        """Gets the font_family of this DocxRun.  # noqa: E501

        Font Family name for the text, e.g. \"Arial\" or \"Times New Roman\"  # noqa: E501

        :return: The font_family of this DocxRun.  # noqa: E501
        :rtype: str
        """
        return self._font_family

    @font_family.setter
    def font_family(self, font_family):
        """Sets the font_family of this DocxRun.

        Font Family name for the text, e.g. \"Arial\" or \"Times New Roman\"  # noqa: E501

        :param font_family: The font_family of this DocxRun.  # noqa: E501
        :type: str
        """

        self._font_family = font_family

    @property
    def font_size(self):
        """Gets the font_size of this DocxRun.  # noqa: E501

        Font size in font points (e.g. \"24\")  # noqa: E501

        :return: The font_size of this DocxRun.  # noqa: E501
        :rtype: str
        """
        return self._font_size

    @font_size.setter
    def font_size(self, font_size):
        """Sets the font_size of this DocxRun.

        Font size in font points (e.g. \"24\")  # noqa: E501

        :param font_size: The font_size of this DocxRun.  # noqa: E501
        :type: str
        """

        self._font_size = font_size

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DocxRun, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DocxRun):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
