# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class WorkspaceUser(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, account_id=None, account_name=None, active_since=None, created=None, created_by_id=None, email=None, error_details=None, last_modified=None, last_modified_by_id=None, status=None, type=None, user_id=None, user_name=None, workspace_id=None, workspace_user_base_url=None, workspace_user_id=None):
        """
        WorkspaceUser - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'account_id': 'str',
            'account_name': 'str',
            'active_since': 'str',
            'created': 'str',
            'created_by_id': 'str',
            'email': 'str',
            'error_details': 'ErrorDetails',
            'last_modified': 'str',
            'last_modified_by_id': 'str',
            'status': 'str',
            'type': 'str',
            'user_id': 'str',
            'user_name': 'str',
            'workspace_id': 'str',
            'workspace_user_base_url': 'str',
            'workspace_user_id': 'str'
        }

        self.attribute_map = {
            'account_id': 'accountId',
            'account_name': 'accountName',
            'active_since': 'activeSince',
            'created': 'created',
            'created_by_id': 'createdById',
            'email': 'email',
            'error_details': 'errorDetails',
            'last_modified': 'lastModified',
            'last_modified_by_id': 'lastModifiedById',
            'status': 'status',
            'type': 'type',
            'user_id': 'userId',
            'user_name': 'userName',
            'workspace_id': 'workspaceId',
            'workspace_user_base_url': 'workspaceUserBaseUrl',
            'workspace_user_id': 'workspaceUserId'
        }

        self._account_id = account_id
        self._account_name = account_name
        self._active_since = active_since
        self._created = created
        self._created_by_id = created_by_id
        self._email = email
        self._error_details = error_details
        self._last_modified = last_modified
        self._last_modified_by_id = last_modified_by_id
        self._status = status
        self._type = type
        self._user_id = user_id
        self._user_name = user_name
        self._workspace_id = workspace_id
        self._workspace_user_base_url = workspace_user_base_url
        self._workspace_user_id = workspace_user_id

    @property
    def account_id(self):
        """
        Gets the account_id of this WorkspaceUser.
        The account ID associated with the envelope.

        :return: The account_id of this WorkspaceUser.
        :rtype: str
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """
        Sets the account_id of this WorkspaceUser.
        The account ID associated with the envelope.

        :param account_id: The account_id of this WorkspaceUser.
        :type: str
        """

        self._account_id = account_id

    @property
    def account_name(self):
        """
        Gets the account_name of this WorkspaceUser.
        The name of the account that the workspace user belongs to.

        :return: The account_name of this WorkspaceUser.
        :rtype: str
        """
        return self._account_name

    @account_name.setter
    def account_name(self, account_name):
        """
        Sets the account_name of this WorkspaceUser.
        The name of the account that the workspace user belongs to.

        :param account_name: The account_name of this WorkspaceUser.
        :type: str
        """

        self._account_name = account_name

    @property
    def active_since(self):
        """
        Gets the active_since of this WorkspaceUser.
        

        :return: The active_since of this WorkspaceUser.
        :rtype: str
        """
        return self._active_since

    @active_since.setter
    def active_since(self, active_since):
        """
        Sets the active_since of this WorkspaceUser.
        

        :param active_since: The active_since of this WorkspaceUser.
        :type: str
        """

        self._active_since = active_since

    @property
    def created(self):
        """
        Gets the created of this WorkspaceUser.
        The UTC DateTime when the workspace user was created.

        :return: The created of this WorkspaceUser.
        :rtype: str
        """
        return self._created

    @created.setter
    def created(self, created):
        """
        Sets the created of this WorkspaceUser.
        The UTC DateTime when the workspace user was created.

        :param created: The created of this WorkspaceUser.
        :type: str
        """

        self._created = created

    @property
    def created_by_id(self):
        """
        Gets the created_by_id of this WorkspaceUser.
        

        :return: The created_by_id of this WorkspaceUser.
        :rtype: str
        """
        return self._created_by_id

    @created_by_id.setter
    def created_by_id(self, created_by_id):
        """
        Sets the created_by_id of this WorkspaceUser.
        

        :param created_by_id: The created_by_id of this WorkspaceUser.
        :type: str
        """

        self._created_by_id = created_by_id

    @property
    def email(self):
        """
        Gets the email of this WorkspaceUser.
        

        :return: The email of this WorkspaceUser.
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """
        Sets the email of this WorkspaceUser.
        

        :param email: The email of this WorkspaceUser.
        :type: str
        """

        self._email = email

    @property
    def error_details(self):
        """
        Gets the error_details of this WorkspaceUser.

        :return: The error_details of this WorkspaceUser.
        :rtype: ErrorDetails
        """
        return self._error_details

    @error_details.setter
    def error_details(self, error_details):
        """
        Sets the error_details of this WorkspaceUser.

        :param error_details: The error_details of this WorkspaceUser.
        :type: ErrorDetails
        """

        self._error_details = error_details

    @property
    def last_modified(self):
        """
        Gets the last_modified of this WorkspaceUser.
        Utc date and time the comment was last updated (can only be done by creator.)

        :return: The last_modified of this WorkspaceUser.
        :rtype: str
        """
        return self._last_modified

    @last_modified.setter
    def last_modified(self, last_modified):
        """
        Sets the last_modified of this WorkspaceUser.
        Utc date and time the comment was last updated (can only be done by creator.)

        :param last_modified: The last_modified of this WorkspaceUser.
        :type: str
        """

        self._last_modified = last_modified

    @property
    def last_modified_by_id(self):
        """
        Gets the last_modified_by_id of this WorkspaceUser.
        

        :return: The last_modified_by_id of this WorkspaceUser.
        :rtype: str
        """
        return self._last_modified_by_id

    @last_modified_by_id.setter
    def last_modified_by_id(self, last_modified_by_id):
        """
        Sets the last_modified_by_id of this WorkspaceUser.
        

        :param last_modified_by_id: The last_modified_by_id of this WorkspaceUser.
        :type: str
        """

        self._last_modified_by_id = last_modified_by_id

    @property
    def status(self):
        """
        Gets the status of this WorkspaceUser.
        Indicates the envelope status. Valid values are:  * sent - The envelope is sent to the recipients.  * created - The envelope is saved as a draft and can be modified and sent later.

        :return: The status of this WorkspaceUser.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this WorkspaceUser.
        Indicates the envelope status. Valid values are:  * sent - The envelope is sent to the recipients.  * created - The envelope is saved as a draft and can be modified and sent later.

        :param status: The status of this WorkspaceUser.
        :type: str
        """

        self._status = status

    @property
    def type(self):
        """
        Gets the type of this WorkspaceUser.
        Type of the user. Valid values: type_owner, type_participant.

        :return: The type of this WorkspaceUser.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this WorkspaceUser.
        Type of the user. Valid values: type_owner, type_participant.

        :param type: The type of this WorkspaceUser.
        :type: str
        """

        self._type = type

    @property
    def user_id(self):
        """
        Gets the user_id of this WorkspaceUser.
        

        :return: The user_id of this WorkspaceUser.
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """
        Sets the user_id of this WorkspaceUser.
        

        :param user_id: The user_id of this WorkspaceUser.
        :type: str
        """

        self._user_id = user_id

    @property
    def user_name(self):
        """
        Gets the user_name of this WorkspaceUser.
        

        :return: The user_name of this WorkspaceUser.
        :rtype: str
        """
        return self._user_name

    @user_name.setter
    def user_name(self, user_name):
        """
        Sets the user_name of this WorkspaceUser.
        

        :param user_name: The user_name of this WorkspaceUser.
        :type: str
        """

        self._user_name = user_name

    @property
    def workspace_id(self):
        """
        Gets the workspace_id of this WorkspaceUser.
        

        :return: The workspace_id of this WorkspaceUser.
        :rtype: str
        """
        return self._workspace_id

    @workspace_id.setter
    def workspace_id(self, workspace_id):
        """
        Sets the workspace_id of this WorkspaceUser.
        

        :param workspace_id: The workspace_id of this WorkspaceUser.
        :type: str
        """

        self._workspace_id = workspace_id

    @property
    def workspace_user_base_url(self):
        """
        Gets the workspace_user_base_url of this WorkspaceUser.
        The relative URI that may be used to access a workspace user.

        :return: The workspace_user_base_url of this WorkspaceUser.
        :rtype: str
        """
        return self._workspace_user_base_url

    @workspace_user_base_url.setter
    def workspace_user_base_url(self, workspace_user_base_url):
        """
        Sets the workspace_user_base_url of this WorkspaceUser.
        The relative URI that may be used to access a workspace user.

        :param workspace_user_base_url: The workspace_user_base_url of this WorkspaceUser.
        :type: str
        """

        self._workspace_user_base_url = workspace_user_base_url

    @property
    def workspace_user_id(self):
        """
        Gets the workspace_user_id of this WorkspaceUser.
        

        :return: The workspace_user_id of this WorkspaceUser.
        :rtype: str
        """
        return self._workspace_user_id

    @workspace_user_id.setter
    def workspace_user_id(self, workspace_user_id):
        """
        Sets the workspace_user_id of this WorkspaceUser.
        

        :param workspace_user_id: The workspace_user_id of this WorkspaceUser.
        :type: str
        """

        self._workspace_user_id = workspace_user_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
