# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Signer(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, access_code=None, add_access_code_to_email=None, agent_can_edit_email=None, agent_can_edit_name=None, auto_navigation=None, bulk_recipients_uri=None, can_sign_offline=None, client_user_id=None, creation_reason=None, custom_fields=None, declined_date_time=None, declined_reason=None, default_recipient=None, delivered_date_time=None, delivery_method=None, document_visibility=None, email=None, email_notification=None, email_recipient_post_signing_url=None, embedded_recipient_start_url=None, error_details=None, excluded_documents=None, fax_number=None, first_name=None, full_name=None, id_check_configuration_name=None, id_check_information_input=None, identity_verification=None, inherit_email_notification_configuration=None, is_bulk_recipient=None, last_name=None, name=None, note=None, offline_attributes=None, phone_authentication=None, proof_file=None, recipient_attachments=None, recipient_authentication_status=None, recipient_id=None, recipient_id_guid=None, recipient_signature_providers=None, recipient_supplies_tabs=None, require_id_lookup=None, require_signer_certificate=None, require_sign_on_paper=None, role_name=None, routing_order=None, saml_authentication=None, sent_date_time=None, signature_info=None, signed_date_time=None, sign_in_each_location=None, signing_group_id=None, signing_group_name=None, signing_group_users=None, sms_authentication=None, social_authentications=None, status=None, tabs=None, template_locked=None, template_required=None, total_tab_count=None, user_id=None):
        """
        Signer - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'access_code': 'str',
            'add_access_code_to_email': 'str',
            'agent_can_edit_email': 'str',
            'agent_can_edit_name': 'str',
            'auto_navigation': 'str',
            'bulk_recipients_uri': 'str',
            'can_sign_offline': 'str',
            'client_user_id': 'str',
            'creation_reason': 'str',
            'custom_fields': 'list[str]',
            'declined_date_time': 'str',
            'declined_reason': 'str',
            'default_recipient': 'str',
            'delivered_date_time': 'str',
            'delivery_method': 'str',
            'document_visibility': 'list[DocumentVisibility]',
            'email': 'str',
            'email_notification': 'RecipientEmailNotification',
            'email_recipient_post_signing_url': 'str',
            'embedded_recipient_start_url': 'str',
            'error_details': 'ErrorDetails',
            'excluded_documents': 'list[str]',
            'fax_number': 'str',
            'first_name': 'str',
            'full_name': 'str',
            'id_check_configuration_name': 'str',
            'id_check_information_input': 'IdCheckInformationInput',
            'identity_verification': 'RecipientIdentityVerification',
            'inherit_email_notification_configuration': 'str',
            'is_bulk_recipient': 'str',
            'last_name': 'str',
            'name': 'str',
            'note': 'str',
            'offline_attributes': 'OfflineAttributes',
            'phone_authentication': 'RecipientPhoneAuthentication',
            'proof_file': 'RecipientProofFile',
            'recipient_attachments': 'list[RecipientAttachment]',
            'recipient_authentication_status': 'AuthenticationStatus',
            'recipient_id': 'str',
            'recipient_id_guid': 'str',
            'recipient_signature_providers': 'list[RecipientSignatureProvider]',
            'recipient_supplies_tabs': 'str',
            'require_id_lookup': 'str',
            'require_signer_certificate': 'str',
            'require_sign_on_paper': 'str',
            'role_name': 'str',
            'routing_order': 'str',
            'saml_authentication': 'RecipientSAMLAuthentication',
            'sent_date_time': 'str',
            'signature_info': 'RecipientSignatureInformation',
            'signed_date_time': 'str',
            'sign_in_each_location': 'str',
            'signing_group_id': 'str',
            'signing_group_name': 'str',
            'signing_group_users': 'list[UserInfo]',
            'sms_authentication': 'RecipientSMSAuthentication',
            'social_authentications': 'list[SocialAuthentication]',
            'status': 'str',
            'tabs': 'Tabs',
            'template_locked': 'str',
            'template_required': 'str',
            'total_tab_count': 'str',
            'user_id': 'str'
        }

        self.attribute_map = {
            'access_code': 'accessCode',
            'add_access_code_to_email': 'addAccessCodeToEmail',
            'agent_can_edit_email': 'agentCanEditEmail',
            'agent_can_edit_name': 'agentCanEditName',
            'auto_navigation': 'autoNavigation',
            'bulk_recipients_uri': 'bulkRecipientsUri',
            'can_sign_offline': 'canSignOffline',
            'client_user_id': 'clientUserId',
            'creation_reason': 'creationReason',
            'custom_fields': 'customFields',
            'declined_date_time': 'declinedDateTime',
            'declined_reason': 'declinedReason',
            'default_recipient': 'defaultRecipient',
            'delivered_date_time': 'deliveredDateTime',
            'delivery_method': 'deliveryMethod',
            'document_visibility': 'documentVisibility',
            'email': 'email',
            'email_notification': 'emailNotification',
            'email_recipient_post_signing_url': 'emailRecipientPostSigningURL',
            'embedded_recipient_start_url': 'embeddedRecipientStartURL',
            'error_details': 'errorDetails',
            'excluded_documents': 'excludedDocuments',
            'fax_number': 'faxNumber',
            'first_name': 'firstName',
            'full_name': 'fullName',
            'id_check_configuration_name': 'idCheckConfigurationName',
            'id_check_information_input': 'idCheckInformationInput',
            'identity_verification': 'identityVerification',
            'inherit_email_notification_configuration': 'inheritEmailNotificationConfiguration',
            'is_bulk_recipient': 'isBulkRecipient',
            'last_name': 'lastName',
            'name': 'name',
            'note': 'note',
            'offline_attributes': 'offlineAttributes',
            'phone_authentication': 'phoneAuthentication',
            'proof_file': 'proofFile',
            'recipient_attachments': 'recipientAttachments',
            'recipient_authentication_status': 'recipientAuthenticationStatus',
            'recipient_id': 'recipientId',
            'recipient_id_guid': 'recipientIdGuid',
            'recipient_signature_providers': 'recipientSignatureProviders',
            'recipient_supplies_tabs': 'recipientSuppliesTabs',
            'require_id_lookup': 'requireIdLookup',
            'require_signer_certificate': 'requireSignerCertificate',
            'require_sign_on_paper': 'requireSignOnPaper',
            'role_name': 'roleName',
            'routing_order': 'routingOrder',
            'saml_authentication': 'samlAuthentication',
            'sent_date_time': 'sentDateTime',
            'signature_info': 'signatureInfo',
            'signed_date_time': 'signedDateTime',
            'sign_in_each_location': 'signInEachLocation',
            'signing_group_id': 'signingGroupId',
            'signing_group_name': 'signingGroupName',
            'signing_group_users': 'signingGroupUsers',
            'sms_authentication': 'smsAuthentication',
            'social_authentications': 'socialAuthentications',
            'status': 'status',
            'tabs': 'tabs',
            'template_locked': 'templateLocked',
            'template_required': 'templateRequired',
            'total_tab_count': 'totalTabCount',
            'user_id': 'userId'
        }

        self._access_code = access_code
        self._add_access_code_to_email = add_access_code_to_email
        self._agent_can_edit_email = agent_can_edit_email
        self._agent_can_edit_name = agent_can_edit_name
        self._auto_navigation = auto_navigation
        self._bulk_recipients_uri = bulk_recipients_uri
        self._can_sign_offline = can_sign_offline
        self._client_user_id = client_user_id
        self._creation_reason = creation_reason
        self._custom_fields = custom_fields
        self._declined_date_time = declined_date_time
        self._declined_reason = declined_reason
        self._default_recipient = default_recipient
        self._delivered_date_time = delivered_date_time
        self._delivery_method = delivery_method
        self._document_visibility = document_visibility
        self._email = email
        self._email_notification = email_notification
        self._email_recipient_post_signing_url = email_recipient_post_signing_url
        self._embedded_recipient_start_url = embedded_recipient_start_url
        self._error_details = error_details
        self._excluded_documents = excluded_documents
        self._fax_number = fax_number
        self._first_name = first_name
        self._full_name = full_name
        self._id_check_configuration_name = id_check_configuration_name
        self._id_check_information_input = id_check_information_input
        self._identity_verification = identity_verification
        self._inherit_email_notification_configuration = inherit_email_notification_configuration
        self._is_bulk_recipient = is_bulk_recipient
        self._last_name = last_name
        self._name = name
        self._note = note
        self._offline_attributes = offline_attributes
        self._phone_authentication = phone_authentication
        self._proof_file = proof_file
        self._recipient_attachments = recipient_attachments
        self._recipient_authentication_status = recipient_authentication_status
        self._recipient_id = recipient_id
        self._recipient_id_guid = recipient_id_guid
        self._recipient_signature_providers = recipient_signature_providers
        self._recipient_supplies_tabs = recipient_supplies_tabs
        self._require_id_lookup = require_id_lookup
        self._require_signer_certificate = require_signer_certificate
        self._require_sign_on_paper = require_sign_on_paper
        self._role_name = role_name
        self._routing_order = routing_order
        self._saml_authentication = saml_authentication
        self._sent_date_time = sent_date_time
        self._signature_info = signature_info
        self._signed_date_time = signed_date_time
        self._sign_in_each_location = sign_in_each_location
        self._signing_group_id = signing_group_id
        self._signing_group_name = signing_group_name
        self._signing_group_users = signing_group_users
        self._sms_authentication = sms_authentication
        self._social_authentications = social_authentications
        self._status = status
        self._tabs = tabs
        self._template_locked = template_locked
        self._template_required = template_required
        self._total_tab_count = total_tab_count
        self._user_id = user_id

    @property
    def access_code(self):
        """
        Gets the access_code of this Signer.
        If a value is provided, the recipient must enter the value as the access code to view and sign the envelope.   Maximum Length: 50 characters and it must conform to the account's access code format setting.  If blank, but the signer `accessCode` property is set in the envelope, then that value is used.  If blank and the signer `accessCode` property is not set, then the access code is not required.

        :return: The access_code of this Signer.
        :rtype: str
        """
        return self._access_code

    @access_code.setter
    def access_code(self, access_code):
        """
        Sets the access_code of this Signer.
        If a value is provided, the recipient must enter the value as the access code to view and sign the envelope.   Maximum Length: 50 characters and it must conform to the account's access code format setting.  If blank, but the signer `accessCode` property is set in the envelope, then that value is used.  If blank and the signer `accessCode` property is not set, then the access code is not required.

        :param access_code: The access_code of this Signer.
        :type: str
        """

        self._access_code = access_code

    @property
    def add_access_code_to_email(self):
        """
        Gets the add_access_code_to_email of this Signer.
        This Optional attribute indicates that the access code will be added to the email sent to the recipient; this nullifies the Security measure of Access Code on the recipient.

        :return: The add_access_code_to_email of this Signer.
        :rtype: str
        """
        return self._add_access_code_to_email

    @add_access_code_to_email.setter
    def add_access_code_to_email(self, add_access_code_to_email):
        """
        Sets the add_access_code_to_email of this Signer.
        This Optional attribute indicates that the access code will be added to the email sent to the recipient; this nullifies the Security measure of Access Code on the recipient.

        :param add_access_code_to_email: The add_access_code_to_email of this Signer.
        :type: str
        """

        self._add_access_code_to_email = add_access_code_to_email

    @property
    def agent_can_edit_email(self):
        """
        Gets the agent_can_edit_email of this Signer.
        

        :return: The agent_can_edit_email of this Signer.
        :rtype: str
        """
        return self._agent_can_edit_email

    @agent_can_edit_email.setter
    def agent_can_edit_email(self, agent_can_edit_email):
        """
        Sets the agent_can_edit_email of this Signer.
        

        :param agent_can_edit_email: The agent_can_edit_email of this Signer.
        :type: str
        """

        self._agent_can_edit_email = agent_can_edit_email

    @property
    def agent_can_edit_name(self):
        """
        Gets the agent_can_edit_name of this Signer.
        

        :return: The agent_can_edit_name of this Signer.
        :rtype: str
        """
        return self._agent_can_edit_name

    @agent_can_edit_name.setter
    def agent_can_edit_name(self, agent_can_edit_name):
        """
        Sets the agent_can_edit_name of this Signer.
        

        :param agent_can_edit_name: The agent_can_edit_name of this Signer.
        :type: str
        """

        self._agent_can_edit_name = agent_can_edit_name

    @property
    def auto_navigation(self):
        """
        Gets the auto_navigation of this Signer.
        

        :return: The auto_navigation of this Signer.
        :rtype: str
        """
        return self._auto_navigation

    @auto_navigation.setter
    def auto_navigation(self, auto_navigation):
        """
        Sets the auto_navigation of this Signer.
        

        :param auto_navigation: The auto_navigation of this Signer.
        :type: str
        """

        self._auto_navigation = auto_navigation

    @property
    def bulk_recipients_uri(self):
        """
        Gets the bulk_recipients_uri of this Signer.
        Contains a URI for an endpoint that allows you to easily retrieve bulk recipient information.

        :return: The bulk_recipients_uri of this Signer.
        :rtype: str
        """
        return self._bulk_recipients_uri

    @bulk_recipients_uri.setter
    def bulk_recipients_uri(self, bulk_recipients_uri):
        """
        Sets the bulk_recipients_uri of this Signer.
        Contains a URI for an endpoint that allows you to easily retrieve bulk recipient information.

        :param bulk_recipients_uri: The bulk_recipients_uri of this Signer.
        :type: str
        """

        self._bulk_recipients_uri = bulk_recipients_uri

    @property
    def can_sign_offline(self):
        """
        Gets the can_sign_offline of this Signer.
        When set to **true**, specifies that the signer can perform the signing ceremony offline.

        :return: The can_sign_offline of this Signer.
        :rtype: str
        """
        return self._can_sign_offline

    @can_sign_offline.setter
    def can_sign_offline(self, can_sign_offline):
        """
        Sets the can_sign_offline of this Signer.
        When set to **true**, specifies that the signer can perform the signing ceremony offline.

        :param can_sign_offline: The can_sign_offline of this Signer.
        :type: str
        """

        self._can_sign_offline = can_sign_offline

    @property
    def client_user_id(self):
        """
        Gets the client_user_id of this Signer.
        Specifies whether the recipient is embedded or remote.   If the `clientUserId` property is not null then the recipient is embedded. Note that if the `ClientUserId` property is set and either `SignerMustHaveAccount` or `SignerMustLoginToSign` property of the account settings is set to  **true**, an error is generated on sending.ng.   Maximum length: 100 characters. 

        :return: The client_user_id of this Signer.
        :rtype: str
        """
        return self._client_user_id

    @client_user_id.setter
    def client_user_id(self, client_user_id):
        """
        Sets the client_user_id of this Signer.
        Specifies whether the recipient is embedded or remote.   If the `clientUserId` property is not null then the recipient is embedded. Note that if the `ClientUserId` property is set and either `SignerMustHaveAccount` or `SignerMustLoginToSign` property of the account settings is set to  **true**, an error is generated on sending.ng.   Maximum length: 100 characters. 

        :param client_user_id: The client_user_id of this Signer.
        :type: str
        """

        self._client_user_id = client_user_id

    @property
    def creation_reason(self):
        """
        Gets the creation_reason of this Signer.
        

        :return: The creation_reason of this Signer.
        :rtype: str
        """
        return self._creation_reason

    @creation_reason.setter
    def creation_reason(self, creation_reason):
        """
        Sets the creation_reason of this Signer.
        

        :param creation_reason: The creation_reason of this Signer.
        :type: str
        """

        self._creation_reason = creation_reason

    @property
    def custom_fields(self):
        """
        Gets the custom_fields of this Signer.
        An optional array of strings that allows the sender to provide custom data about the recipient. This information is returned in the envelope status but otherwise not used by DocuSign. Each customField string can be a maximum of 100 characters.

        :return: The custom_fields of this Signer.
        :rtype: list[str]
        """
        return self._custom_fields

    @custom_fields.setter
    def custom_fields(self, custom_fields):
        """
        Sets the custom_fields of this Signer.
        An optional array of strings that allows the sender to provide custom data about the recipient. This information is returned in the envelope status but otherwise not used by DocuSign. Each customField string can be a maximum of 100 characters.

        :param custom_fields: The custom_fields of this Signer.
        :type: list[str]
        """

        self._custom_fields = custom_fields

    @property
    def declined_date_time(self):
        """
        Gets the declined_date_time of this Signer.
        The date and time the recipient declined the document.

        :return: The declined_date_time of this Signer.
        :rtype: str
        """
        return self._declined_date_time

    @declined_date_time.setter
    def declined_date_time(self, declined_date_time):
        """
        Sets the declined_date_time of this Signer.
        The date and time the recipient declined the document.

        :param declined_date_time: The declined_date_time of this Signer.
        :type: str
        """

        self._declined_date_time = declined_date_time

    @property
    def declined_reason(self):
        """
        Gets the declined_reason of this Signer.
        The reason the recipient declined the document.

        :return: The declined_reason of this Signer.
        :rtype: str
        """
        return self._declined_reason

    @declined_reason.setter
    def declined_reason(self, declined_reason):
        """
        Sets the declined_reason of this Signer.
        The reason the recipient declined the document.

        :param declined_reason: The declined_reason of this Signer.
        :type: str
        """

        self._declined_reason = declined_reason

    @property
    def default_recipient(self):
        """
        Gets the default_recipient of this Signer.
        

        :return: The default_recipient of this Signer.
        :rtype: str
        """
        return self._default_recipient

    @default_recipient.setter
    def default_recipient(self, default_recipient):
        """
        Sets the default_recipient of this Signer.
        

        :param default_recipient: The default_recipient of this Signer.
        :type: str
        """

        self._default_recipient = default_recipient

    @property
    def delivered_date_time(self):
        """
        Gets the delivered_date_time of this Signer.
        Reserved: For DocuSign use only.

        :return: The delivered_date_time of this Signer.
        :rtype: str
        """
        return self._delivered_date_time

    @delivered_date_time.setter
    def delivered_date_time(self, delivered_date_time):
        """
        Sets the delivered_date_time of this Signer.
        Reserved: For DocuSign use only.

        :param delivered_date_time: The delivered_date_time of this Signer.
        :type: str
        """

        self._delivered_date_time = delivered_date_time

    @property
    def delivery_method(self):
        """
        Gets the delivery_method of this Signer.
        Reserved: For DocuSign use only.

        :return: The delivery_method of this Signer.
        :rtype: str
        """
        return self._delivery_method

    @delivery_method.setter
    def delivery_method(self, delivery_method):
        """
        Sets the delivery_method of this Signer.
        Reserved: For DocuSign use only.

        :param delivery_method: The delivery_method of this Signer.
        :type: str
        """

        self._delivery_method = delivery_method

    @property
    def document_visibility(self):
        """
        Gets the document_visibility of this Signer.
        

        :return: The document_visibility of this Signer.
        :rtype: list[DocumentVisibility]
        """
        return self._document_visibility

    @document_visibility.setter
    def document_visibility(self, document_visibility):
        """
        Sets the document_visibility of this Signer.
        

        :param document_visibility: The document_visibility of this Signer.
        :type: list[DocumentVisibility]
        """

        self._document_visibility = document_visibility

    @property
    def email(self):
        """
        Gets the email of this Signer.
        Email id of the recipient. Notification of the document to sign is sent to this email id.   Maximum length: 100 characters. 

        :return: The email of this Signer.
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """
        Sets the email of this Signer.
        Email id of the recipient. Notification of the document to sign is sent to this email id.   Maximum length: 100 characters. 

        :param email: The email of this Signer.
        :type: str
        """

        self._email = email

    @property
    def email_notification(self):
        """
        Gets the email_notification of this Signer.

        :return: The email_notification of this Signer.
        :rtype: RecipientEmailNotification
        """
        return self._email_notification

    @email_notification.setter
    def email_notification(self, email_notification):
        """
        Sets the email_notification of this Signer.

        :param email_notification: The email_notification of this Signer.
        :type: RecipientEmailNotification
        """

        self._email_notification = email_notification

    @property
    def email_recipient_post_signing_url(self):
        """
        Gets the email_recipient_post_signing_url of this Signer.
        

        :return: The email_recipient_post_signing_url of this Signer.
        :rtype: str
        """
        return self._email_recipient_post_signing_url

    @email_recipient_post_signing_url.setter
    def email_recipient_post_signing_url(self, email_recipient_post_signing_url):
        """
        Sets the email_recipient_post_signing_url of this Signer.
        

        :param email_recipient_post_signing_url: The email_recipient_post_signing_url of this Signer.
        :type: str
        """

        self._email_recipient_post_signing_url = email_recipient_post_signing_url

    @property
    def embedded_recipient_start_url(self):
        """
        Gets the embedded_recipient_start_url of this Signer.
        Specifies a sender provided valid URL string for redirecting an embedded recipient. When using this option, the embedded recipient still receives an email from DocuSign, just as a remote recipient would. When the document link in the email is clicked the recipient is redirected, through DocuSign, to the supplied URL to complete their actions. When routing to the URL, the sender's system (the server responding to the URL) must request a recipient token to launch a signing session.   If set to `SIGN_AT_DOCUSIGN`, the recipient is directed to an embedded signing or viewing process directly at DocuSign. The signing or viewing action is initiated by the DocuSign system and the transaction activity and Certificate of Completion records will reflect this. In all other ways the process is identical to an embedded signing or viewing operation that is launched by any partner.  It is important to remember that in a typical embedded workflow the authentication of an embedded recipient is the responsibility of the sending application, DocuSign expects that senders will follow their own process for establishing the recipient's identity. In this workflow the recipient goes through the sending application before the embedded signing or viewing process in initiated. However, when the sending application sets `EmbeddedRecipientStartURL=SIGN_AT_DOCUSIGN`, the recipient goes directly to the embedded signing or viewing process bypassing the sending application and any authentication steps the sending application would use. In this case, DocuSign recommends that you use one of the normal DocuSign authentication features (Access Code, Phone Authentication, SMS Authentication, etc.) to verify the identity of the recipient.  If the `clientUserId` property is NOT set, and the `embeddedRecipientStartURL` is set, DocuSign will ignore the redirect URL and launch the standard signing process for the email recipient. Information can be appended to the embedded recipient start URL using merge fields. The available merge fields items are: envelopeId, recipientId, recipientName, recipientEmail, and customFields. The `customFields` property must be set fort the recipient or envelope. The merge fields are enclosed in double brackets.   *Example*:   `http://senderHost/[[mergeField1]]/ beginSigningSession? [[mergeField2]]&[[mergeField3]]` 

        :return: The embedded_recipient_start_url of this Signer.
        :rtype: str
        """
        return self._embedded_recipient_start_url

    @embedded_recipient_start_url.setter
    def embedded_recipient_start_url(self, embedded_recipient_start_url):
        """
        Sets the embedded_recipient_start_url of this Signer.
        Specifies a sender provided valid URL string for redirecting an embedded recipient. When using this option, the embedded recipient still receives an email from DocuSign, just as a remote recipient would. When the document link in the email is clicked the recipient is redirected, through DocuSign, to the supplied URL to complete their actions. When routing to the URL, the sender's system (the server responding to the URL) must request a recipient token to launch a signing session.   If set to `SIGN_AT_DOCUSIGN`, the recipient is directed to an embedded signing or viewing process directly at DocuSign. The signing or viewing action is initiated by the DocuSign system and the transaction activity and Certificate of Completion records will reflect this. In all other ways the process is identical to an embedded signing or viewing operation that is launched by any partner.  It is important to remember that in a typical embedded workflow the authentication of an embedded recipient is the responsibility of the sending application, DocuSign expects that senders will follow their own process for establishing the recipient's identity. In this workflow the recipient goes through the sending application before the embedded signing or viewing process in initiated. However, when the sending application sets `EmbeddedRecipientStartURL=SIGN_AT_DOCUSIGN`, the recipient goes directly to the embedded signing or viewing process bypassing the sending application and any authentication steps the sending application would use. In this case, DocuSign recommends that you use one of the normal DocuSign authentication features (Access Code, Phone Authentication, SMS Authentication, etc.) to verify the identity of the recipient.  If the `clientUserId` property is NOT set, and the `embeddedRecipientStartURL` is set, DocuSign will ignore the redirect URL and launch the standard signing process for the email recipient. Information can be appended to the embedded recipient start URL using merge fields. The available merge fields items are: envelopeId, recipientId, recipientName, recipientEmail, and customFields. The `customFields` property must be set fort the recipient or envelope. The merge fields are enclosed in double brackets.   *Example*:   `http://senderHost/[[mergeField1]]/ beginSigningSession? [[mergeField2]]&[[mergeField3]]` 

        :param embedded_recipient_start_url: The embedded_recipient_start_url of this Signer.
        :type: str
        """

        self._embedded_recipient_start_url = embedded_recipient_start_url

    @property
    def error_details(self):
        """
        Gets the error_details of this Signer.

        :return: The error_details of this Signer.
        :rtype: ErrorDetails
        """
        return self._error_details

    @error_details.setter
    def error_details(self, error_details):
        """
        Sets the error_details of this Signer.

        :param error_details: The error_details of this Signer.
        :type: ErrorDetails
        """

        self._error_details = error_details

    @property
    def excluded_documents(self):
        """
        Gets the excluded_documents of this Signer.
        Specifies the documents that are not visible to this recipient. Document Visibility must be enabled for the account and the `enforceSignerVisibility` property must be set to **true** for the envelope to use this.  When enforce signer visibility is enabled, documents with tabs can only be viewed by signers that have a tab on that document. Recipients that have an administrative role (Agent, Editor, or Intermediaries) or informational role (Certified Deliveries or Carbon Copies) can always see all the documents in an envelope, unless they are specifically excluded using this setting when an envelope is sent. Documents that do not have tabs are always visible to all recipients, unless they are specifically excluded using this setting when an envelope is sent.

        :return: The excluded_documents of this Signer.
        :rtype: list[str]
        """
        return self._excluded_documents

    @excluded_documents.setter
    def excluded_documents(self, excluded_documents):
        """
        Sets the excluded_documents of this Signer.
        Specifies the documents that are not visible to this recipient. Document Visibility must be enabled for the account and the `enforceSignerVisibility` property must be set to **true** for the envelope to use this.  When enforce signer visibility is enabled, documents with tabs can only be viewed by signers that have a tab on that document. Recipients that have an administrative role (Agent, Editor, or Intermediaries) or informational role (Certified Deliveries or Carbon Copies) can always see all the documents in an envelope, unless they are specifically excluded using this setting when an envelope is sent. Documents that do not have tabs are always visible to all recipients, unless they are specifically excluded using this setting when an envelope is sent.

        :param excluded_documents: The excluded_documents of this Signer.
        :type: list[str]
        """

        self._excluded_documents = excluded_documents

    @property
    def fax_number(self):
        """
        Gets the fax_number of this Signer.
        Reserved:

        :return: The fax_number of this Signer.
        :rtype: str
        """
        return self._fax_number

    @fax_number.setter
    def fax_number(self, fax_number):
        """
        Sets the fax_number of this Signer.
        Reserved:

        :param fax_number: The fax_number of this Signer.
        :type: str
        """

        self._fax_number = fax_number

    @property
    def first_name(self):
        """
        Gets the first_name of this Signer.
        The user's first name.  Maximum Length: 50 characters.

        :return: The first_name of this Signer.
        :rtype: str
        """
        return self._first_name

    @first_name.setter
    def first_name(self, first_name):
        """
        Sets the first_name of this Signer.
        The user's first name.  Maximum Length: 50 characters.

        :param first_name: The first_name of this Signer.
        :type: str
        """

        self._first_name = first_name

    @property
    def full_name(self):
        """
        Gets the full_name of this Signer.
        

        :return: The full_name of this Signer.
        :rtype: str
        """
        return self._full_name

    @full_name.setter
    def full_name(self, full_name):
        """
        Sets the full_name of this Signer.
        

        :param full_name: The full_name of this Signer.
        :type: str
        """

        self._full_name = full_name

    @property
    def id_check_configuration_name(self):
        """
        Gets the id_check_configuration_name of this Signer.
        Specifies authentication check by name. The names used here must be the same as the authentication type names used by the account (these name can also be found in the web console sending interface in the Identify list for a recipient,) This overrides any default authentication setting.  *Example*: Your account has ID Check and SMS Authentication available and in the web console Identify list these appear as 'ID Check $' and 'SMS Auth $'. To use ID check in an envelope, the idCheckConfigurationName should be 'ID Check '. If you wanted to use SMS, it would be 'SMS Auth $' and you would need to add you would need to add phone number information to the `smsAuthentication` node.

        :return: The id_check_configuration_name of this Signer.
        :rtype: str
        """
        return self._id_check_configuration_name

    @id_check_configuration_name.setter
    def id_check_configuration_name(self, id_check_configuration_name):
        """
        Sets the id_check_configuration_name of this Signer.
        Specifies authentication check by name. The names used here must be the same as the authentication type names used by the account (these name can also be found in the web console sending interface in the Identify list for a recipient,) This overrides any default authentication setting.  *Example*: Your account has ID Check and SMS Authentication available and in the web console Identify list these appear as 'ID Check $' and 'SMS Auth $'. To use ID check in an envelope, the idCheckConfigurationName should be 'ID Check '. If you wanted to use SMS, it would be 'SMS Auth $' and you would need to add you would need to add phone number information to the `smsAuthentication` node.

        :param id_check_configuration_name: The id_check_configuration_name of this Signer.
        :type: str
        """

        self._id_check_configuration_name = id_check_configuration_name

    @property
    def id_check_information_input(self):
        """
        Gets the id_check_information_input of this Signer.

        :return: The id_check_information_input of this Signer.
        :rtype: IdCheckInformationInput
        """
        return self._id_check_information_input

    @id_check_information_input.setter
    def id_check_information_input(self, id_check_information_input):
        """
        Sets the id_check_information_input of this Signer.

        :param id_check_information_input: The id_check_information_input of this Signer.
        :type: IdCheckInformationInput
        """

        self._id_check_information_input = id_check_information_input

    @property
    def identity_verification(self):
        """
        Gets the identity_verification of this Signer.

        :return: The identity_verification of this Signer.
        :rtype: RecipientIdentityVerification
        """
        return self._identity_verification

    @identity_verification.setter
    def identity_verification(self, identity_verification):
        """
        Sets the identity_verification of this Signer.

        :param identity_verification: The identity_verification of this Signer.
        :type: RecipientIdentityVerification
        """

        self._identity_verification = identity_verification

    @property
    def inherit_email_notification_configuration(self):
        """
        Gets the inherit_email_notification_configuration of this Signer.
        When set to **true** and the envelope recipient creates a DocuSign account after signing, the Manage Account Email Notification settings are used as the default settings for the recipient's account. 

        :return: The inherit_email_notification_configuration of this Signer.
        :rtype: str
        """
        return self._inherit_email_notification_configuration

    @inherit_email_notification_configuration.setter
    def inherit_email_notification_configuration(self, inherit_email_notification_configuration):
        """
        Sets the inherit_email_notification_configuration of this Signer.
        When set to **true** and the envelope recipient creates a DocuSign account after signing, the Manage Account Email Notification settings are used as the default settings for the recipient's account. 

        :param inherit_email_notification_configuration: The inherit_email_notification_configuration of this Signer.
        :type: str
        """

        self._inherit_email_notification_configuration = inherit_email_notification_configuration

    @property
    def is_bulk_recipient(self):
        """
        Gets the is_bulk_recipient of this Signer.
        When set to **true**, this signer is a bulk recipient and the recipient information is contained in a bulk recipient file.   Note that when this is true the email and name for the recipient becomes bulk@recipient.com and \"Bulk Recipient\". These fields can not be changed for the bulk recipient.  

        :return: The is_bulk_recipient of this Signer.
        :rtype: str
        """
        return self._is_bulk_recipient

    @is_bulk_recipient.setter
    def is_bulk_recipient(self, is_bulk_recipient):
        """
        Sets the is_bulk_recipient of this Signer.
        When set to **true**, this signer is a bulk recipient and the recipient information is contained in a bulk recipient file.   Note that when this is true the email and name for the recipient becomes bulk@recipient.com and \"Bulk Recipient\". These fields can not be changed for the bulk recipient.  

        :param is_bulk_recipient: The is_bulk_recipient of this Signer.
        :type: str
        """

        self._is_bulk_recipient = is_bulk_recipient

    @property
    def last_name(self):
        """
        Gets the last_name of this Signer.
        

        :return: The last_name of this Signer.
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name):
        """
        Sets the last_name of this Signer.
        

        :param last_name: The last_name of this Signer.
        :type: str
        """

        self._last_name = last_name

    @property
    def name(self):
        """
        Gets the name of this Signer.
        

        :return: The name of this Signer.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Signer.
        

        :param name: The name of this Signer.
        :type: str
        """

        self._name = name

    @property
    def note(self):
        """
        Gets the note of this Signer.
        Specifies a note that is unique to this recipient. This note is sent to the recipient via the signing email. The note displays in the signing UI near the upper left corner of the document on the signing screen.  Maximum Length: 1000 characters.

        :return: The note of this Signer.
        :rtype: str
        """
        return self._note

    @note.setter
    def note(self, note):
        """
        Sets the note of this Signer.
        Specifies a note that is unique to this recipient. This note is sent to the recipient via the signing email. The note displays in the signing UI near the upper left corner of the document on the signing screen.  Maximum Length: 1000 characters.

        :param note: The note of this Signer.
        :type: str
        """

        self._note = note

    @property
    def offline_attributes(self):
        """
        Gets the offline_attributes of this Signer.

        :return: The offline_attributes of this Signer.
        :rtype: OfflineAttributes
        """
        return self._offline_attributes

    @offline_attributes.setter
    def offline_attributes(self, offline_attributes):
        """
        Sets the offline_attributes of this Signer.

        :param offline_attributes: The offline_attributes of this Signer.
        :type: OfflineAttributes
        """

        self._offline_attributes = offline_attributes

    @property
    def phone_authentication(self):
        """
        Gets the phone_authentication of this Signer.

        :return: The phone_authentication of this Signer.
        :rtype: RecipientPhoneAuthentication
        """
        return self._phone_authentication

    @phone_authentication.setter
    def phone_authentication(self, phone_authentication):
        """
        Sets the phone_authentication of this Signer.

        :param phone_authentication: The phone_authentication of this Signer.
        :type: RecipientPhoneAuthentication
        """

        self._phone_authentication = phone_authentication

    @property
    def proof_file(self):
        """
        Gets the proof_file of this Signer.

        :return: The proof_file of this Signer.
        :rtype: RecipientProofFile
        """
        return self._proof_file

    @proof_file.setter
    def proof_file(self, proof_file):
        """
        Sets the proof_file of this Signer.

        :param proof_file: The proof_file of this Signer.
        :type: RecipientProofFile
        """

        self._proof_file = proof_file

    @property
    def recipient_attachments(self):
        """
        Gets the recipient_attachments of this Signer.
        Reserved:

        :return: The recipient_attachments of this Signer.
        :rtype: list[RecipientAttachment]
        """
        return self._recipient_attachments

    @recipient_attachments.setter
    def recipient_attachments(self, recipient_attachments):
        """
        Sets the recipient_attachments of this Signer.
        Reserved:

        :param recipient_attachments: The recipient_attachments of this Signer.
        :type: list[RecipientAttachment]
        """

        self._recipient_attachments = recipient_attachments

    @property
    def recipient_authentication_status(self):
        """
        Gets the recipient_authentication_status of this Signer.

        :return: The recipient_authentication_status of this Signer.
        :rtype: AuthenticationStatus
        """
        return self._recipient_authentication_status

    @recipient_authentication_status.setter
    def recipient_authentication_status(self, recipient_authentication_status):
        """
        Sets the recipient_authentication_status of this Signer.

        :param recipient_authentication_status: The recipient_authentication_status of this Signer.
        :type: AuthenticationStatus
        """

        self._recipient_authentication_status = recipient_authentication_status

    @property
    def recipient_id(self):
        """
        Gets the recipient_id of this Signer.
        Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.

        :return: The recipient_id of this Signer.
        :rtype: str
        """
        return self._recipient_id

    @recipient_id.setter
    def recipient_id(self, recipient_id):
        """
        Sets the recipient_id of this Signer.
        Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.

        :param recipient_id: The recipient_id of this Signer.
        :type: str
        """

        self._recipient_id = recipient_id

    @property
    def recipient_id_guid(self):
        """
        Gets the recipient_id_guid of this Signer.
        

        :return: The recipient_id_guid of this Signer.
        :rtype: str
        """
        return self._recipient_id_guid

    @recipient_id_guid.setter
    def recipient_id_guid(self, recipient_id_guid):
        """
        Sets the recipient_id_guid of this Signer.
        

        :param recipient_id_guid: The recipient_id_guid of this Signer.
        :type: str
        """

        self._recipient_id_guid = recipient_id_guid

    @property
    def recipient_signature_providers(self):
        """
        Gets the recipient_signature_providers of this Signer.
        

        :return: The recipient_signature_providers of this Signer.
        :rtype: list[RecipientSignatureProvider]
        """
        return self._recipient_signature_providers

    @recipient_signature_providers.setter
    def recipient_signature_providers(self, recipient_signature_providers):
        """
        Sets the recipient_signature_providers of this Signer.
        

        :param recipient_signature_providers: The recipient_signature_providers of this Signer.
        :type: list[RecipientSignatureProvider]
        """

        self._recipient_signature_providers = recipient_signature_providers

    @property
    def recipient_supplies_tabs(self):
        """
        Gets the recipient_supplies_tabs of this Signer.
        

        :return: The recipient_supplies_tabs of this Signer.
        :rtype: str
        """
        return self._recipient_supplies_tabs

    @recipient_supplies_tabs.setter
    def recipient_supplies_tabs(self, recipient_supplies_tabs):
        """
        Sets the recipient_supplies_tabs of this Signer.
        

        :param recipient_supplies_tabs: The recipient_supplies_tabs of this Signer.
        :type: str
        """

        self._recipient_supplies_tabs = recipient_supplies_tabs

    @property
    def require_id_lookup(self):
        """
        Gets the require_id_lookup of this Signer.
        When set to **true**, the recipient is required to use the specified ID check method (including Phone and SMS authentication) to validate their identity. 

        :return: The require_id_lookup of this Signer.
        :rtype: str
        """
        return self._require_id_lookup

    @require_id_lookup.setter
    def require_id_lookup(self, require_id_lookup):
        """
        Sets the require_id_lookup of this Signer.
        When set to **true**, the recipient is required to use the specified ID check method (including Phone and SMS authentication) to validate their identity. 

        :param require_id_lookup: The require_id_lookup of this Signer.
        :type: str
        """

        self._require_id_lookup = require_id_lookup

    @property
    def require_signer_certificate(self):
        """
        Gets the require_signer_certificate of this Signer.
        Sets the type of signer certificate required for signing. If left blank, no certificate is required. Only one type of certificate can be set for a signer. The possible values are:  * docusign_express - Requires a DocuSign Express certificate. * safe - Requires a SAFE-BioPharma certificate. * open_trust - Requires an OpenTrust certificate.   **Important**: There are certain rules and restrictions that must be followed when requiring OpenTrust digital signatures. See [ML:OpenTrust Rules and Restrictions] for more information.   

        :return: The require_signer_certificate of this Signer.
        :rtype: str
        """
        return self._require_signer_certificate

    @require_signer_certificate.setter
    def require_signer_certificate(self, require_signer_certificate):
        """
        Sets the require_signer_certificate of this Signer.
        Sets the type of signer certificate required for signing. If left blank, no certificate is required. Only one type of certificate can be set for a signer. The possible values are:  * docusign_express - Requires a DocuSign Express certificate. * safe - Requires a SAFE-BioPharma certificate. * open_trust - Requires an OpenTrust certificate.   **Important**: There are certain rules and restrictions that must be followed when requiring OpenTrust digital signatures. See [ML:OpenTrust Rules and Restrictions] for more information.   

        :param require_signer_certificate: The require_signer_certificate of this Signer.
        :type: str
        """

        self._require_signer_certificate = require_signer_certificate

    @property
    def require_sign_on_paper(self):
        """
        Gets the require_sign_on_paper of this Signer.
        When set to **true**, the signer must print, sign, and upload or fax the signed documents to DocuSign.

        :return: The require_sign_on_paper of this Signer.
        :rtype: str
        """
        return self._require_sign_on_paper

    @require_sign_on_paper.setter
    def require_sign_on_paper(self, require_sign_on_paper):
        """
        Sets the require_sign_on_paper of this Signer.
        When set to **true**, the signer must print, sign, and upload or fax the signed documents to DocuSign.

        :param require_sign_on_paper: The require_sign_on_paper of this Signer.
        :type: str
        """

        self._require_sign_on_paper = require_sign_on_paper

    @property
    def role_name(self):
        """
        Gets the role_name of this Signer.
        Optional element. Specifies the role name associated with the recipient.<br/><br/>This is required when working with template recipients.

        :return: The role_name of this Signer.
        :rtype: str
        """
        return self._role_name

    @role_name.setter
    def role_name(self, role_name):
        """
        Sets the role_name of this Signer.
        Optional element. Specifies the role name associated with the recipient.<br/><br/>This is required when working with template recipients.

        :param role_name: The role_name of this Signer.
        :type: str
        """

        self._role_name = role_name

    @property
    def routing_order(self):
        """
        Gets the routing_order of this Signer.
        Specifies the routing order of the recipient in the envelope. 

        :return: The routing_order of this Signer.
        :rtype: str
        """
        return self._routing_order

    @routing_order.setter
    def routing_order(self, routing_order):
        """
        Sets the routing_order of this Signer.
        Specifies the routing order of the recipient in the envelope. 

        :param routing_order: The routing_order of this Signer.
        :type: str
        """

        self._routing_order = routing_order

    @property
    def saml_authentication(self):
        """
        Gets the saml_authentication of this Signer.

        :return: The saml_authentication of this Signer.
        :rtype: RecipientSAMLAuthentication
        """
        return self._saml_authentication

    @saml_authentication.setter
    def saml_authentication(self, saml_authentication):
        """
        Sets the saml_authentication of this Signer.

        :param saml_authentication: The saml_authentication of this Signer.
        :type: RecipientSAMLAuthentication
        """

        self._saml_authentication = saml_authentication

    @property
    def sent_date_time(self):
        """
        Gets the sent_date_time of this Signer.
        The date and time the envelope was sent.

        :return: The sent_date_time of this Signer.
        :rtype: str
        """
        return self._sent_date_time

    @sent_date_time.setter
    def sent_date_time(self, sent_date_time):
        """
        Sets the sent_date_time of this Signer.
        The date and time the envelope was sent.

        :param sent_date_time: The sent_date_time of this Signer.
        :type: str
        """

        self._sent_date_time = sent_date_time

    @property
    def signature_info(self):
        """
        Gets the signature_info of this Signer.

        :return: The signature_info of this Signer.
        :rtype: RecipientSignatureInformation
        """
        return self._signature_info

    @signature_info.setter
    def signature_info(self, signature_info):
        """
        Sets the signature_info of this Signer.

        :param signature_info: The signature_info of this Signer.
        :type: RecipientSignatureInformation
        """

        self._signature_info = signature_info

    @property
    def signed_date_time(self):
        """
        Gets the signed_date_time of this Signer.
        Reserved: For DocuSign use only. 

        :return: The signed_date_time of this Signer.
        :rtype: str
        """
        return self._signed_date_time

    @signed_date_time.setter
    def signed_date_time(self, signed_date_time):
        """
        Sets the signed_date_time of this Signer.
        Reserved: For DocuSign use only. 

        :param signed_date_time: The signed_date_time of this Signer.
        :type: str
        """

        self._signed_date_time = signed_date_time

    @property
    def sign_in_each_location(self):
        """
        Gets the sign_in_each_location of this Signer.
        When set to **true**, specifies that the signer must sign in all locations.

        :return: The sign_in_each_location of this Signer.
        :rtype: str
        """
        return self._sign_in_each_location

    @sign_in_each_location.setter
    def sign_in_each_location(self, sign_in_each_location):
        """
        Sets the sign_in_each_location of this Signer.
        When set to **true**, specifies that the signer must sign in all locations.

        :param sign_in_each_location: The sign_in_each_location of this Signer.
        :type: str
        """

        self._sign_in_each_location = sign_in_each_location

    @property
    def signing_group_id(self):
        """
        Gets the signing_group_id of this Signer.
        When set to **true** and the feature is enabled in the sender's account, the signing recipient is required to draw signatures and initials at each signature/initial tab ( instead of adopting a signature/initial style or only drawing a signature/initial once).

        :return: The signing_group_id of this Signer.
        :rtype: str
        """
        return self._signing_group_id

    @signing_group_id.setter
    def signing_group_id(self, signing_group_id):
        """
        Sets the signing_group_id of this Signer.
        When set to **true** and the feature is enabled in the sender's account, the signing recipient is required to draw signatures and initials at each signature/initial tab ( instead of adopting a signature/initial style or only drawing a signature/initial once).

        :param signing_group_id: The signing_group_id of this Signer.
        :type: str
        """

        self._signing_group_id = signing_group_id

    @property
    def signing_group_name(self):
        """
        Gets the signing_group_name of this Signer.
        The display name for the signing group.   Maximum Length: 100 characters. 

        :return: The signing_group_name of this Signer.
        :rtype: str
        """
        return self._signing_group_name

    @signing_group_name.setter
    def signing_group_name(self, signing_group_name):
        """
        Sets the signing_group_name of this Signer.
        The display name for the signing group.   Maximum Length: 100 characters. 

        :param signing_group_name: The signing_group_name of this Signer.
        :type: str
        """

        self._signing_group_name = signing_group_name

    @property
    def signing_group_users(self):
        """
        Gets the signing_group_users of this Signer.
        A complex type that contains information about users in the signing group.

        :return: The signing_group_users of this Signer.
        :rtype: list[UserInfo]
        """
        return self._signing_group_users

    @signing_group_users.setter
    def signing_group_users(self, signing_group_users):
        """
        Sets the signing_group_users of this Signer.
        A complex type that contains information about users in the signing group.

        :param signing_group_users: The signing_group_users of this Signer.
        :type: list[UserInfo]
        """

        self._signing_group_users = signing_group_users

    @property
    def sms_authentication(self):
        """
        Gets the sms_authentication of this Signer.

        :return: The sms_authentication of this Signer.
        :rtype: RecipientSMSAuthentication
        """
        return self._sms_authentication

    @sms_authentication.setter
    def sms_authentication(self, sms_authentication):
        """
        Sets the sms_authentication of this Signer.

        :param sms_authentication: The sms_authentication of this Signer.
        :type: RecipientSMSAuthentication
        """

        self._sms_authentication = sms_authentication

    @property
    def social_authentications(self):
        """
        Gets the social_authentications of this Signer.
         Lists the social ID type that can be used for recipient authentication.

        :return: The social_authentications of this Signer.
        :rtype: list[SocialAuthentication]
        """
        return self._social_authentications

    @social_authentications.setter
    def social_authentications(self, social_authentications):
        """
        Sets the social_authentications of this Signer.
         Lists the social ID type that can be used for recipient authentication.

        :param social_authentications: The social_authentications of this Signer.
        :type: list[SocialAuthentication]
        """

        self._social_authentications = social_authentications

    @property
    def status(self):
        """
        Gets the status of this Signer.
        Indicates the envelope status. Valid values are:  * sent - The envelope is sent to the recipients.  * created - The envelope is saved as a draft and can be modified and sent later.

        :return: The status of this Signer.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this Signer.
        Indicates the envelope status. Valid values are:  * sent - The envelope is sent to the recipients.  * created - The envelope is saved as a draft and can be modified and sent later.

        :param status: The status of this Signer.
        :type: str
        """

        self._status = status

    @property
    def tabs(self):
        """
        Gets the tabs of this Signer.

        :return: The tabs of this Signer.
        :rtype: Tabs
        """
        return self._tabs

    @tabs.setter
    def tabs(self, tabs):
        """
        Sets the tabs of this Signer.

        :param tabs: The tabs of this Signer.
        :type: Tabs
        """

        self._tabs = tabs

    @property
    def template_locked(self):
        """
        Gets the template_locked of this Signer.
        When set to **true**, the sender cannot change any attributes of the recipient. Used only when working with template recipients. 

        :return: The template_locked of this Signer.
        :rtype: str
        """
        return self._template_locked

    @template_locked.setter
    def template_locked(self, template_locked):
        """
        Sets the template_locked of this Signer.
        When set to **true**, the sender cannot change any attributes of the recipient. Used only when working with template recipients. 

        :param template_locked: The template_locked of this Signer.
        :type: str
        """

        self._template_locked = template_locked

    @property
    def template_required(self):
        """
        Gets the template_required of this Signer.
        When set to **true**, the sender may not remove the recipient. Used only when working with template recipients.

        :return: The template_required of this Signer.
        :rtype: str
        """
        return self._template_required

    @template_required.setter
    def template_required(self, template_required):
        """
        Sets the template_required of this Signer.
        When set to **true**, the sender may not remove the recipient. Used only when working with template recipients.

        :param template_required: The template_required of this Signer.
        :type: str
        """

        self._template_required = template_required

    @property
    def total_tab_count(self):
        """
        Gets the total_tab_count of this Signer.
        

        :return: The total_tab_count of this Signer.
        :rtype: str
        """
        return self._total_tab_count

    @total_tab_count.setter
    def total_tab_count(self, total_tab_count):
        """
        Sets the total_tab_count of this Signer.
        

        :param total_tab_count: The total_tab_count of this Signer.
        :type: str
        """

        self._total_tab_count = total_tab_count

    @property
    def user_id(self):
        """
        Gets the user_id of this Signer.
        

        :return: The user_id of this Signer.
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """
        Sets the user_id of this Signer.
        

        :param user_id: The user_id of this Signer.
        :type: str
        """

        self._user_id = user_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
