# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class RecipientEvent(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, include_documents=None, recipient_event_status_code=None):
        """
        RecipientEvent - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'include_documents': 'str',
            'recipient_event_status_code': 'str'
        }

        self.attribute_map = {
            'include_documents': 'includeDocuments',
            'recipient_event_status_code': 'recipientEventStatusCode'
        }

        self._include_documents = include_documents
        self._recipient_event_status_code = recipient_event_status_code

    @property
    def include_documents(self):
        """
        Gets the include_documents of this RecipientEvent.
        When set to **true**, the PDF documents are included in the message along with the updated XML. 

        :return: The include_documents of this RecipientEvent.
        :rtype: str
        """
        return self._include_documents

    @include_documents.setter
    def include_documents(self, include_documents):
        """
        Sets the include_documents of this RecipientEvent.
        When set to **true**, the PDF documents are included in the message along with the updated XML. 

        :param include_documents: The include_documents of this RecipientEvent.
        :type: str
        """

        self._include_documents = include_documents

    @property
    def recipient_event_status_code(self):
        """
        Gets the recipient_event_status_code of this RecipientEvent.
        The recipient status, this can be Sent, Delivered, Completed, Declined, AuthenticationFailed, and AutoResponded.

        :return: The recipient_event_status_code of this RecipientEvent.
        :rtype: str
        """
        return self._recipient_event_status_code

    @recipient_event_status_code.setter
    def recipient_event_status_code(self, recipient_event_status_code):
        """
        Sets the recipient_event_status_code of this RecipientEvent.
        The recipient status, this can be Sent, Delivered, Completed, Declined, AuthenticationFailed, and AutoResponded.

        :param recipient_event_status_code: The recipient_event_status_code of this RecipientEvent.
        :type: str
        """

        self._recipient_event_status_code = recipient_event_status_code

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
