# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class RadioGroup(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, conditional_parent_label=None, conditional_parent_value=None, document_id=None, group_name=None, radios=None, recipient_id=None, require_all=None, require_initial_on_shared_change=None, shared=None, template_locked=None, template_required=None, tooltip=None):
        """
        RadioGroup - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'conditional_parent_label': 'str',
            'conditional_parent_value': 'str',
            'document_id': 'str',
            'group_name': 'str',
            'radios': 'list[Radio]',
            'recipient_id': 'str',
            'require_all': 'str',
            'require_initial_on_shared_change': 'str',
            'shared': 'str',
            'template_locked': 'str',
            'template_required': 'str',
            'tooltip': 'str'
        }

        self.attribute_map = {
            'conditional_parent_label': 'conditionalParentLabel',
            'conditional_parent_value': 'conditionalParentValue',
            'document_id': 'documentId',
            'group_name': 'groupName',
            'radios': 'radios',
            'recipient_id': 'recipientId',
            'require_all': 'requireAll',
            'require_initial_on_shared_change': 'requireInitialOnSharedChange',
            'shared': 'shared',
            'template_locked': 'templateLocked',
            'template_required': 'templateRequired',
            'tooltip': 'tooltip'
        }

        self._conditional_parent_label = conditional_parent_label
        self._conditional_parent_value = conditional_parent_value
        self._document_id = document_id
        self._group_name = group_name
        self._radios = radios
        self._recipient_id = recipient_id
        self._require_all = require_all
        self._require_initial_on_shared_change = require_initial_on_shared_change
        self._shared = shared
        self._template_locked = template_locked
        self._template_required = template_required
        self._tooltip = tooltip

    @property
    def conditional_parent_label(self):
        """
        Gets the conditional_parent_label of this RadioGroup.
        For conditional fields this is the TabLabel of the parent tab that controls this tab's visibility.

        :return: The conditional_parent_label of this RadioGroup.
        :rtype: str
        """
        return self._conditional_parent_label

    @conditional_parent_label.setter
    def conditional_parent_label(self, conditional_parent_label):
        """
        Sets the conditional_parent_label of this RadioGroup.
        For conditional fields this is the TabLabel of the parent tab that controls this tab's visibility.

        :param conditional_parent_label: The conditional_parent_label of this RadioGroup.
        :type: str
        """

        self._conditional_parent_label = conditional_parent_label

    @property
    def conditional_parent_value(self):
        """
        Gets the conditional_parent_value of this RadioGroup.
        For conditional fields, this is the value of the parent tab that controls the tab's visibility.  If the parent tab is a Checkbox, Radio button, Optional Signature, or Optional Initial use \"on\" as the value to show that the parent tab is active. 

        :return: The conditional_parent_value of this RadioGroup.
        :rtype: str
        """
        return self._conditional_parent_value

    @conditional_parent_value.setter
    def conditional_parent_value(self, conditional_parent_value):
        """
        Sets the conditional_parent_value of this RadioGroup.
        For conditional fields, this is the value of the parent tab that controls the tab's visibility.  If the parent tab is a Checkbox, Radio button, Optional Signature, or Optional Initial use \"on\" as the value to show that the parent tab is active. 

        :param conditional_parent_value: The conditional_parent_value of this RadioGroup.
        :type: str
        """

        self._conditional_parent_value = conditional_parent_value

    @property
    def document_id(self):
        """
        Gets the document_id of this RadioGroup.
        Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.

        :return: The document_id of this RadioGroup.
        :rtype: str
        """
        return self._document_id

    @document_id.setter
    def document_id(self, document_id):
        """
        Sets the document_id of this RadioGroup.
        Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.

        :param document_id: The document_id of this RadioGroup.
        :type: str
        """

        self._document_id = document_id

    @property
    def group_name(self):
        """
        Gets the group_name of this RadioGroup.
        The name of the group.

        :return: The group_name of this RadioGroup.
        :rtype: str
        """
        return self._group_name

    @group_name.setter
    def group_name(self, group_name):
        """
        Sets the group_name of this RadioGroup.
        The name of the group.

        :param group_name: The group_name of this RadioGroup.
        :type: str
        """

        self._group_name = group_name

    @property
    def radios(self):
        """
        Gets the radios of this RadioGroup.
        Specifies the locations and status for radio buttons that are grouped together.

        :return: The radios of this RadioGroup.
        :rtype: list[Radio]
        """
        return self._radios

    @radios.setter
    def radios(self, radios):
        """
        Sets the radios of this RadioGroup.
        Specifies the locations and status for radio buttons that are grouped together.

        :param radios: The radios of this RadioGroup.
        :type: list[Radio]
        """

        self._radios = radios

    @property
    def recipient_id(self):
        """
        Gets the recipient_id of this RadioGroup.
        Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.

        :return: The recipient_id of this RadioGroup.
        :rtype: str
        """
        return self._recipient_id

    @recipient_id.setter
    def recipient_id(self, recipient_id):
        """
        Sets the recipient_id of this RadioGroup.
        Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.

        :param recipient_id: The recipient_id of this RadioGroup.
        :type: str
        """

        self._recipient_id = recipient_id

    @property
    def require_all(self):
        """
        Gets the require_all of this RadioGroup.
        When set to **true** and shared is true, information must be entered in this field to complete the envelope. 

        :return: The require_all of this RadioGroup.
        :rtype: str
        """
        return self._require_all

    @require_all.setter
    def require_all(self, require_all):
        """
        Sets the require_all of this RadioGroup.
        When set to **true** and shared is true, information must be entered in this field to complete the envelope. 

        :param require_all: The require_all of this RadioGroup.
        :type: str
        """

        self._require_all = require_all

    @property
    def require_initial_on_shared_change(self):
        """
        Gets the require_initial_on_shared_change of this RadioGroup.
        Optional element for field markup. When set to **true**, the signer is required to initial when they modify a shared field.

        :return: The require_initial_on_shared_change of this RadioGroup.
        :rtype: str
        """
        return self._require_initial_on_shared_change

    @require_initial_on_shared_change.setter
    def require_initial_on_shared_change(self, require_initial_on_shared_change):
        """
        Sets the require_initial_on_shared_change of this RadioGroup.
        Optional element for field markup. When set to **true**, the signer is required to initial when they modify a shared field.

        :param require_initial_on_shared_change: The require_initial_on_shared_change of this RadioGroup.
        :type: str
        """

        self._require_initial_on_shared_change = require_initial_on_shared_change

    @property
    def shared(self):
        """
        Gets the shared of this RadioGroup.
        When set to **true**, this custom tab is shared.

        :return: The shared of this RadioGroup.
        :rtype: str
        """
        return self._shared

    @shared.setter
    def shared(self, shared):
        """
        Sets the shared of this RadioGroup.
        When set to **true**, this custom tab is shared.

        :param shared: The shared of this RadioGroup.
        :type: str
        """

        self._shared = shared

    @property
    def template_locked(self):
        """
        Gets the template_locked of this RadioGroup.
        When set to **true**, the sender cannot change any attributes of the recipient. Used only when working with template recipients. 

        :return: The template_locked of this RadioGroup.
        :rtype: str
        """
        return self._template_locked

    @template_locked.setter
    def template_locked(self, template_locked):
        """
        Sets the template_locked of this RadioGroup.
        When set to **true**, the sender cannot change any attributes of the recipient. Used only when working with template recipients. 

        :param template_locked: The template_locked of this RadioGroup.
        :type: str
        """

        self._template_locked = template_locked

    @property
    def template_required(self):
        """
        Gets the template_required of this RadioGroup.
        When set to **true**, the sender may not remove the recipient. Used only when working with template recipients.

        :return: The template_required of this RadioGroup.
        :rtype: str
        """
        return self._template_required

    @template_required.setter
    def template_required(self, template_required):
        """
        Sets the template_required of this RadioGroup.
        When set to **true**, the sender may not remove the recipient. Used only when working with template recipients.

        :param template_required: The template_required of this RadioGroup.
        :type: str
        """

        self._template_required = template_required

    @property
    def tooltip(self):
        """
        Gets the tooltip of this RadioGroup.
        

        :return: The tooltip of this RadioGroup.
        :rtype: str
        """
        return self._tooltip

    @tooltip.setter
    def tooltip(self, tooltip):
        """
        Sets the tooltip of this RadioGroup.
        

        :param tooltip: The tooltip of this RadioGroup.
        :type: str
        """

        self._tooltip = tooltip

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
