# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Envelope(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, allow_markup=None, allow_reassign=None, allow_view_history=None, asynchronous=None, attachments_uri=None, authoritative_copy=None, authoritative_copy_default=None, auto_navigation=None, brand_id=None, brand_lock=None, certificate_uri=None, completed_date_time=None, copy_recipient_data=None, created_date_time=None, custom_fields=None, custom_fields_uri=None, declined_date_time=None, deleted_date_time=None, delivered_date_time=None, disable_responsive_document=None, documents_combined_uri=None, documents_uri=None, email_blurb=None, email_settings=None, email_subject=None, enable_wet_sign=None, enforce_signer_visibility=None, envelope_id=None, envelope_id_stamping=None, envelope_uri=None, initial_sent_date_time=None, is21_cfr_part11=None, is_signature_provider_envelope=None, last_modified_date_time=None, lock_information=None, message_lock=None, notification=None, notification_uri=None, purge_state=None, recipients=None, recipients_lock=None, recipients_uri=None, sent_date_time=None, signer_can_sign_on_mobile=None, signing_location=None, status=None, status_changed_date_time=None, templates_uri=None, transaction_id=None, use_disclosure=None, voided_date_time=None, voided_reason=None):
        """
        Envelope - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'allow_markup': 'str',
            'allow_reassign': 'str',
            'allow_view_history': 'str',
            'asynchronous': 'str',
            'attachments_uri': 'str',
            'authoritative_copy': 'str',
            'authoritative_copy_default': 'str',
            'auto_navigation': 'str',
            'brand_id': 'str',
            'brand_lock': 'str',
            'certificate_uri': 'str',
            'completed_date_time': 'str',
            'copy_recipient_data': 'str',
            'created_date_time': 'str',
            'custom_fields': 'CustomFields',
            'custom_fields_uri': 'str',
            'declined_date_time': 'str',
            'deleted_date_time': 'str',
            'delivered_date_time': 'str',
            'disable_responsive_document': 'str',
            'documents_combined_uri': 'str',
            'documents_uri': 'str',
            'email_blurb': 'str',
            'email_settings': 'EmailSettings',
            'email_subject': 'str',
            'enable_wet_sign': 'str',
            'enforce_signer_visibility': 'str',
            'envelope_id': 'str',
            'envelope_id_stamping': 'str',
            'envelope_uri': 'str',
            'initial_sent_date_time': 'str',
            'is21_cfr_part11': 'str',
            'is_signature_provider_envelope': 'str',
            'last_modified_date_time': 'str',
            'lock_information': 'LockInformation',
            'message_lock': 'str',
            'notification': 'Notification',
            'notification_uri': 'str',
            'purge_state': 'str',
            'recipients': 'Recipients',
            'recipients_lock': 'str',
            'recipients_uri': 'str',
            'sent_date_time': 'str',
            'signer_can_sign_on_mobile': 'str',
            'signing_location': 'str',
            'status': 'str',
            'status_changed_date_time': 'str',
            'templates_uri': 'str',
            'transaction_id': 'str',
            'use_disclosure': 'str',
            'voided_date_time': 'str',
            'voided_reason': 'str'
        }

        self.attribute_map = {
            'allow_markup': 'allowMarkup',
            'allow_reassign': 'allowReassign',
            'allow_view_history': 'allowViewHistory',
            'asynchronous': 'asynchronous',
            'attachments_uri': 'attachmentsUri',
            'authoritative_copy': 'authoritativeCopy',
            'authoritative_copy_default': 'authoritativeCopyDefault',
            'auto_navigation': 'autoNavigation',
            'brand_id': 'brandId',
            'brand_lock': 'brandLock',
            'certificate_uri': 'certificateUri',
            'completed_date_time': 'completedDateTime',
            'copy_recipient_data': 'copyRecipientData',
            'created_date_time': 'createdDateTime',
            'custom_fields': 'customFields',
            'custom_fields_uri': 'customFieldsUri',
            'declined_date_time': 'declinedDateTime',
            'deleted_date_time': 'deletedDateTime',
            'delivered_date_time': 'deliveredDateTime',
            'disable_responsive_document': 'disableResponsiveDocument',
            'documents_combined_uri': 'documentsCombinedUri',
            'documents_uri': 'documentsUri',
            'email_blurb': 'emailBlurb',
            'email_settings': 'emailSettings',
            'email_subject': 'emailSubject',
            'enable_wet_sign': 'enableWetSign',
            'enforce_signer_visibility': 'enforceSignerVisibility',
            'envelope_id': 'envelopeId',
            'envelope_id_stamping': 'envelopeIdStamping',
            'envelope_uri': 'envelopeUri',
            'initial_sent_date_time': 'initialSentDateTime',
            'is21_cfr_part11': 'is21CFRPart11',
            'is_signature_provider_envelope': 'isSignatureProviderEnvelope',
            'last_modified_date_time': 'lastModifiedDateTime',
            'lock_information': 'lockInformation',
            'message_lock': 'messageLock',
            'notification': 'notification',
            'notification_uri': 'notificationUri',
            'purge_state': 'purgeState',
            'recipients': 'recipients',
            'recipients_lock': 'recipientsLock',
            'recipients_uri': 'recipientsUri',
            'sent_date_time': 'sentDateTime',
            'signer_can_sign_on_mobile': 'signerCanSignOnMobile',
            'signing_location': 'signingLocation',
            'status': 'status',
            'status_changed_date_time': 'statusChangedDateTime',
            'templates_uri': 'templatesUri',
            'transaction_id': 'transactionId',
            'use_disclosure': 'useDisclosure',
            'voided_date_time': 'voidedDateTime',
            'voided_reason': 'voidedReason'
        }

        self._allow_markup = allow_markup
        self._allow_reassign = allow_reassign
        self._allow_view_history = allow_view_history
        self._asynchronous = asynchronous
        self._attachments_uri = attachments_uri
        self._authoritative_copy = authoritative_copy
        self._authoritative_copy_default = authoritative_copy_default
        self._auto_navigation = auto_navigation
        self._brand_id = brand_id
        self._brand_lock = brand_lock
        self._certificate_uri = certificate_uri
        self._completed_date_time = completed_date_time
        self._copy_recipient_data = copy_recipient_data
        self._created_date_time = created_date_time
        self._custom_fields = custom_fields
        self._custom_fields_uri = custom_fields_uri
        self._declined_date_time = declined_date_time
        self._deleted_date_time = deleted_date_time
        self._delivered_date_time = delivered_date_time
        self._disable_responsive_document = disable_responsive_document
        self._documents_combined_uri = documents_combined_uri
        self._documents_uri = documents_uri
        self._email_blurb = email_blurb
        self._email_settings = email_settings
        self._email_subject = email_subject
        self._enable_wet_sign = enable_wet_sign
        self._enforce_signer_visibility = enforce_signer_visibility
        self._envelope_id = envelope_id
        self._envelope_id_stamping = envelope_id_stamping
        self._envelope_uri = envelope_uri
        self._initial_sent_date_time = initial_sent_date_time
        self._is21_cfr_part11 = is21_cfr_part11
        self._is_signature_provider_envelope = is_signature_provider_envelope
        self._last_modified_date_time = last_modified_date_time
        self._lock_information = lock_information
        self._message_lock = message_lock
        self._notification = notification
        self._notification_uri = notification_uri
        self._purge_state = purge_state
        self._recipients = recipients
        self._recipients_lock = recipients_lock
        self._recipients_uri = recipients_uri
        self._sent_date_time = sent_date_time
        self._signer_can_sign_on_mobile = signer_can_sign_on_mobile
        self._signing_location = signing_location
        self._status = status
        self._status_changed_date_time = status_changed_date_time
        self._templates_uri = templates_uri
        self._transaction_id = transaction_id
        self._use_disclosure = use_disclosure
        self._voided_date_time = voided_date_time
        self._voided_reason = voided_reason

    @property
    def allow_markup(self):
        """
        Gets the allow_markup of this Envelope.
        When set to **true**, Document Markup is enabled for envelope. Account must have Document Markup enabled to use this

        :return: The allow_markup of this Envelope.
        :rtype: str
        """
        return self._allow_markup

    @allow_markup.setter
    def allow_markup(self, allow_markup):
        """
        Sets the allow_markup of this Envelope.
        When set to **true**, Document Markup is enabled for envelope. Account must have Document Markup enabled to use this

        :param allow_markup: The allow_markup of this Envelope.
        :type: str
        """

        self._allow_markup = allow_markup

    @property
    def allow_reassign(self):
        """
        Gets the allow_reassign of this Envelope.
        When set to **true**, the recipient can redirect an envelope to a more appropriate recipient.

        :return: The allow_reassign of this Envelope.
        :rtype: str
        """
        return self._allow_reassign

    @allow_reassign.setter
    def allow_reassign(self, allow_reassign):
        """
        Sets the allow_reassign of this Envelope.
        When set to **true**, the recipient can redirect an envelope to a more appropriate recipient.

        :param allow_reassign: The allow_reassign of this Envelope.
        :type: str
        """

        self._allow_reassign = allow_reassign

    @property
    def allow_view_history(self):
        """
        Gets the allow_view_history of this Envelope.
        

        :return: The allow_view_history of this Envelope.
        :rtype: str
        """
        return self._allow_view_history

    @allow_view_history.setter
    def allow_view_history(self, allow_view_history):
        """
        Sets the allow_view_history of this Envelope.
        

        :param allow_view_history: The allow_view_history of this Envelope.
        :type: str
        """

        self._allow_view_history = allow_view_history

    @property
    def asynchronous(self):
        """
        Gets the asynchronous of this Envelope.
        When set to **true**, the envelope is queued for processing and the value of the `status` property is set to 'Processing'. Additionally, get status calls return 'Processing' until completed.

        :return: The asynchronous of this Envelope.
        :rtype: str
        """
        return self._asynchronous

    @asynchronous.setter
    def asynchronous(self, asynchronous):
        """
        Sets the asynchronous of this Envelope.
        When set to **true**, the envelope is queued for processing and the value of the `status` property is set to 'Processing'. Additionally, get status calls return 'Processing' until completed.

        :param asynchronous: The asynchronous of this Envelope.
        :type: str
        """

        self._asynchronous = asynchronous

    @property
    def attachments_uri(self):
        """
        Gets the attachments_uri of this Envelope.
        

        :return: The attachments_uri of this Envelope.
        :rtype: str
        """
        return self._attachments_uri

    @attachments_uri.setter
    def attachments_uri(self, attachments_uri):
        """
        Sets the attachments_uri of this Envelope.
        

        :param attachments_uri: The attachments_uri of this Envelope.
        :type: str
        """

        self._attachments_uri = attachments_uri

    @property
    def authoritative_copy(self):
        """
        Gets the authoritative_copy of this Envelope.
        Specifies the Authoritative copy feature. If set to true the Authoritative copy feature is enabled.

        :return: The authoritative_copy of this Envelope.
        :rtype: str
        """
        return self._authoritative_copy

    @authoritative_copy.setter
    def authoritative_copy(self, authoritative_copy):
        """
        Sets the authoritative_copy of this Envelope.
        Specifies the Authoritative copy feature. If set to true the Authoritative copy feature is enabled.

        :param authoritative_copy: The authoritative_copy of this Envelope.
        :type: str
        """

        self._authoritative_copy = authoritative_copy

    @property
    def authoritative_copy_default(self):
        """
        Gets the authoritative_copy_default of this Envelope.
        

        :return: The authoritative_copy_default of this Envelope.
        :rtype: str
        """
        return self._authoritative_copy_default

    @authoritative_copy_default.setter
    def authoritative_copy_default(self, authoritative_copy_default):
        """
        Sets the authoritative_copy_default of this Envelope.
        

        :param authoritative_copy_default: The authoritative_copy_default of this Envelope.
        :type: str
        """

        self._authoritative_copy_default = authoritative_copy_default

    @property
    def auto_navigation(self):
        """
        Gets the auto_navigation of this Envelope.
        

        :return: The auto_navigation of this Envelope.
        :rtype: str
        """
        return self._auto_navigation

    @auto_navigation.setter
    def auto_navigation(self, auto_navigation):
        """
        Sets the auto_navigation of this Envelope.
        

        :param auto_navigation: The auto_navigation of this Envelope.
        :type: str
        """

        self._auto_navigation = auto_navigation

    @property
    def brand_id(self):
        """
        Gets the brand_id of this Envelope.
        

        :return: The brand_id of this Envelope.
        :rtype: str
        """
        return self._brand_id

    @brand_id.setter
    def brand_id(self, brand_id):
        """
        Sets the brand_id of this Envelope.
        

        :param brand_id: The brand_id of this Envelope.
        :type: str
        """

        self._brand_id = brand_id

    @property
    def brand_lock(self):
        """
        Gets the brand_lock of this Envelope.
        

        :return: The brand_lock of this Envelope.
        :rtype: str
        """
        return self._brand_lock

    @brand_lock.setter
    def brand_lock(self, brand_lock):
        """
        Sets the brand_lock of this Envelope.
        

        :param brand_lock: The brand_lock of this Envelope.
        :type: str
        """

        self._brand_lock = brand_lock

    @property
    def certificate_uri(self):
        """
        Gets the certificate_uri of this Envelope.
        Retrieves a URI for an endpoint that allows you to easily retrieve certificate information.

        :return: The certificate_uri of this Envelope.
        :rtype: str
        """
        return self._certificate_uri

    @certificate_uri.setter
    def certificate_uri(self, certificate_uri):
        """
        Sets the certificate_uri of this Envelope.
        Retrieves a URI for an endpoint that allows you to easily retrieve certificate information.

        :param certificate_uri: The certificate_uri of this Envelope.
        :type: str
        """

        self._certificate_uri = certificate_uri

    @property
    def completed_date_time(self):
        """
        Gets the completed_date_time of this Envelope.
        Specifies the date and time this item was completed.

        :return: The completed_date_time of this Envelope.
        :rtype: str
        """
        return self._completed_date_time

    @completed_date_time.setter
    def completed_date_time(self, completed_date_time):
        """
        Sets the completed_date_time of this Envelope.
        Specifies the date and time this item was completed.

        :param completed_date_time: The completed_date_time of this Envelope.
        :type: str
        """

        self._completed_date_time = completed_date_time

    @property
    def copy_recipient_data(self):
        """
        Gets the copy_recipient_data of this Envelope.
        

        :return: The copy_recipient_data of this Envelope.
        :rtype: str
        """
        return self._copy_recipient_data

    @copy_recipient_data.setter
    def copy_recipient_data(self, copy_recipient_data):
        """
        Sets the copy_recipient_data of this Envelope.
        

        :param copy_recipient_data: The copy_recipient_data of this Envelope.
        :type: str
        """

        self._copy_recipient_data = copy_recipient_data

    @property
    def created_date_time(self):
        """
        Gets the created_date_time of this Envelope.
        Indicates the date and time the item was created.

        :return: The created_date_time of this Envelope.
        :rtype: str
        """
        return self._created_date_time

    @created_date_time.setter
    def created_date_time(self, created_date_time):
        """
        Sets the created_date_time of this Envelope.
        Indicates the date and time the item was created.

        :param created_date_time: The created_date_time of this Envelope.
        :type: str
        """

        self._created_date_time = created_date_time

    @property
    def custom_fields(self):
        """
        Gets the custom_fields of this Envelope.

        :return: The custom_fields of this Envelope.
        :rtype: CustomFields
        """
        return self._custom_fields

    @custom_fields.setter
    def custom_fields(self, custom_fields):
        """
        Sets the custom_fields of this Envelope.

        :param custom_fields: The custom_fields of this Envelope.
        :type: CustomFields
        """

        self._custom_fields = custom_fields

    @property
    def custom_fields_uri(self):
        """
        Gets the custom_fields_uri of this Envelope.
        Contains a URI for an endpoint that you can use to retrieve the custom fields.

        :return: The custom_fields_uri of this Envelope.
        :rtype: str
        """
        return self._custom_fields_uri

    @custom_fields_uri.setter
    def custom_fields_uri(self, custom_fields_uri):
        """
        Sets the custom_fields_uri of this Envelope.
        Contains a URI for an endpoint that you can use to retrieve the custom fields.

        :param custom_fields_uri: The custom_fields_uri of this Envelope.
        :type: str
        """

        self._custom_fields_uri = custom_fields_uri

    @property
    def declined_date_time(self):
        """
        Gets the declined_date_time of this Envelope.
        The date and time the recipient declined the document.

        :return: The declined_date_time of this Envelope.
        :rtype: str
        """
        return self._declined_date_time

    @declined_date_time.setter
    def declined_date_time(self, declined_date_time):
        """
        Sets the declined_date_time of this Envelope.
        The date and time the recipient declined the document.

        :param declined_date_time: The declined_date_time of this Envelope.
        :type: str
        """

        self._declined_date_time = declined_date_time

    @property
    def deleted_date_time(self):
        """
        Gets the deleted_date_time of this Envelope.
        Specifies the data and time the item was deleted.

        :return: The deleted_date_time of this Envelope.
        :rtype: str
        """
        return self._deleted_date_time

    @deleted_date_time.setter
    def deleted_date_time(self, deleted_date_time):
        """
        Sets the deleted_date_time of this Envelope.
        Specifies the data and time the item was deleted.

        :param deleted_date_time: The deleted_date_time of this Envelope.
        :type: str
        """

        self._deleted_date_time = deleted_date_time

    @property
    def delivered_date_time(self):
        """
        Gets the delivered_date_time of this Envelope.
        Reserved: For DocuSign use only.

        :return: The delivered_date_time of this Envelope.
        :rtype: str
        """
        return self._delivered_date_time

    @delivered_date_time.setter
    def delivered_date_time(self, delivered_date_time):
        """
        Sets the delivered_date_time of this Envelope.
        Reserved: For DocuSign use only.

        :param delivered_date_time: The delivered_date_time of this Envelope.
        :type: str
        """

        self._delivered_date_time = delivered_date_time

    @property
    def disable_responsive_document(self):
        """
        Gets the disable_responsive_document of this Envelope.
        

        :return: The disable_responsive_document of this Envelope.
        :rtype: str
        """
        return self._disable_responsive_document

    @disable_responsive_document.setter
    def disable_responsive_document(self, disable_responsive_document):
        """
        Sets the disable_responsive_document of this Envelope.
        

        :param disable_responsive_document: The disable_responsive_document of this Envelope.
        :type: str
        """

        self._disable_responsive_document = disable_responsive_document

    @property
    def documents_combined_uri(self):
        """
        Gets the documents_combined_uri of this Envelope.
        

        :return: The documents_combined_uri of this Envelope.
        :rtype: str
        """
        return self._documents_combined_uri

    @documents_combined_uri.setter
    def documents_combined_uri(self, documents_combined_uri):
        """
        Sets the documents_combined_uri of this Envelope.
        

        :param documents_combined_uri: The documents_combined_uri of this Envelope.
        :type: str
        """

        self._documents_combined_uri = documents_combined_uri

    @property
    def documents_uri(self):
        """
        Gets the documents_uri of this Envelope.
        Contains a URI for an endpoint that you can use to retrieve the documents.

        :return: The documents_uri of this Envelope.
        :rtype: str
        """
        return self._documents_uri

    @documents_uri.setter
    def documents_uri(self, documents_uri):
        """
        Sets the documents_uri of this Envelope.
        Contains a URI for an endpoint that you can use to retrieve the documents.

        :param documents_uri: The documents_uri of this Envelope.
        :type: str
        """

        self._documents_uri = documents_uri

    @property
    def email_blurb(self):
        """
        Gets the email_blurb of this Envelope.
        This is the same as the email body. If specified it is included in email body for all envelope recipients.

        :return: The email_blurb of this Envelope.
        :rtype: str
        """
        return self._email_blurb

    @email_blurb.setter
    def email_blurb(self, email_blurb):
        """
        Sets the email_blurb of this Envelope.
        This is the same as the email body. If specified it is included in email body for all envelope recipients.

        :param email_blurb: The email_blurb of this Envelope.
        :type: str
        """

        self._email_blurb = email_blurb

    @property
    def email_settings(self):
        """
        Gets the email_settings of this Envelope.

        :return: The email_settings of this Envelope.
        :rtype: EmailSettings
        """
        return self._email_settings

    @email_settings.setter
    def email_settings(self, email_settings):
        """
        Sets the email_settings of this Envelope.

        :param email_settings: The email_settings of this Envelope.
        :type: EmailSettings
        """

        self._email_settings = email_settings

    @property
    def email_subject(self):
        """
        Gets the email_subject of this Envelope.
        Specifies the subject of the email that is sent to all recipients.  See [ML:Template Email Subject Merge Fields] for information about adding merge field information to the email subject.

        :return: The email_subject of this Envelope.
        :rtype: str
        """
        return self._email_subject

    @email_subject.setter
    def email_subject(self, email_subject):
        """
        Sets the email_subject of this Envelope.
        Specifies the subject of the email that is sent to all recipients.  See [ML:Template Email Subject Merge Fields] for information about adding merge field information to the email subject.

        :param email_subject: The email_subject of this Envelope.
        :type: str
        """

        self._email_subject = email_subject

    @property
    def enable_wet_sign(self):
        """
        Gets the enable_wet_sign of this Envelope.
        When set to **true**, the signer is allowed to print the document and sign it on paper.

        :return: The enable_wet_sign of this Envelope.
        :rtype: str
        """
        return self._enable_wet_sign

    @enable_wet_sign.setter
    def enable_wet_sign(self, enable_wet_sign):
        """
        Sets the enable_wet_sign of this Envelope.
        When set to **true**, the signer is allowed to print the document and sign it on paper.

        :param enable_wet_sign: The enable_wet_sign of this Envelope.
        :type: str
        """

        self._enable_wet_sign = enable_wet_sign

    @property
    def enforce_signer_visibility(self):
        """
        Gets the enforce_signer_visibility of this Envelope.
        When set to **true**, documents with tabs can only be viewed by signers that have a tab on that document. Recipients that have an administrative role (Agent, Editor, or Intermediaries) or informational role (Certified Deliveries or Carbon Copies) can always see all the documents in an envelope, unless they are specifically excluded using this setting when an envelope is sent. Documents that do not have tabs are always visible to all recipients, unless they are specifically excluded using this setting when an envelope is sent.  Your account must have Document Visibility enabled to use this.

        :return: The enforce_signer_visibility of this Envelope.
        :rtype: str
        """
        return self._enforce_signer_visibility

    @enforce_signer_visibility.setter
    def enforce_signer_visibility(self, enforce_signer_visibility):
        """
        Sets the enforce_signer_visibility of this Envelope.
        When set to **true**, documents with tabs can only be viewed by signers that have a tab on that document. Recipients that have an administrative role (Agent, Editor, or Intermediaries) or informational role (Certified Deliveries or Carbon Copies) can always see all the documents in an envelope, unless they are specifically excluded using this setting when an envelope is sent. Documents that do not have tabs are always visible to all recipients, unless they are specifically excluded using this setting when an envelope is sent.  Your account must have Document Visibility enabled to use this.

        :param enforce_signer_visibility: The enforce_signer_visibility of this Envelope.
        :type: str
        """

        self._enforce_signer_visibility = enforce_signer_visibility

    @property
    def envelope_id(self):
        """
        Gets the envelope_id of this Envelope.
        The envelope ID of the envelope status that failed to post.

        :return: The envelope_id of this Envelope.
        :rtype: str
        """
        return self._envelope_id

    @envelope_id.setter
    def envelope_id(self, envelope_id):
        """
        Sets the envelope_id of this Envelope.
        The envelope ID of the envelope status that failed to post.

        :param envelope_id: The envelope_id of this Envelope.
        :type: str
        """

        self._envelope_id = envelope_id

    @property
    def envelope_id_stamping(self):
        """
        Gets the envelope_id_stamping of this Envelope.
        When set to **true**, Envelope ID Stamping is enabled.

        :return: The envelope_id_stamping of this Envelope.
        :rtype: str
        """
        return self._envelope_id_stamping

    @envelope_id_stamping.setter
    def envelope_id_stamping(self, envelope_id_stamping):
        """
        Sets the envelope_id_stamping of this Envelope.
        When set to **true**, Envelope ID Stamping is enabled.

        :param envelope_id_stamping: The envelope_id_stamping of this Envelope.
        :type: str
        """

        self._envelope_id_stamping = envelope_id_stamping

    @property
    def envelope_uri(self):
        """
        Gets the envelope_uri of this Envelope.
        Contains a URI for an endpoint that you can use to retrieve the envelope or envelopes.

        :return: The envelope_uri of this Envelope.
        :rtype: str
        """
        return self._envelope_uri

    @envelope_uri.setter
    def envelope_uri(self, envelope_uri):
        """
        Sets the envelope_uri of this Envelope.
        Contains a URI for an endpoint that you can use to retrieve the envelope or envelopes.

        :param envelope_uri: The envelope_uri of this Envelope.
        :type: str
        """

        self._envelope_uri = envelope_uri

    @property
    def initial_sent_date_time(self):
        """
        Gets the initial_sent_date_time of this Envelope.
        

        :return: The initial_sent_date_time of this Envelope.
        :rtype: str
        """
        return self._initial_sent_date_time

    @initial_sent_date_time.setter
    def initial_sent_date_time(self, initial_sent_date_time):
        """
        Sets the initial_sent_date_time of this Envelope.
        

        :param initial_sent_date_time: The initial_sent_date_time of this Envelope.
        :type: str
        """

        self._initial_sent_date_time = initial_sent_date_time

    @property
    def is21_cfr_part11(self):
        """
        Gets the is21_cfr_part11 of this Envelope.
        When set to **true**, indicates that this module is enabled on the account.

        :return: The is21_cfr_part11 of this Envelope.
        :rtype: str
        """
        return self._is21_cfr_part11

    @is21_cfr_part11.setter
    def is21_cfr_part11(self, is21_cfr_part11):
        """
        Sets the is21_cfr_part11 of this Envelope.
        When set to **true**, indicates that this module is enabled on the account.

        :param is21_cfr_part11: The is21_cfr_part11 of this Envelope.
        :type: str
        """

        self._is21_cfr_part11 = is21_cfr_part11

    @property
    def is_signature_provider_envelope(self):
        """
        Gets the is_signature_provider_envelope of this Envelope.
        

        :return: The is_signature_provider_envelope of this Envelope.
        :rtype: str
        """
        return self._is_signature_provider_envelope

    @is_signature_provider_envelope.setter
    def is_signature_provider_envelope(self, is_signature_provider_envelope):
        """
        Sets the is_signature_provider_envelope of this Envelope.
        

        :param is_signature_provider_envelope: The is_signature_provider_envelope of this Envelope.
        :type: str
        """

        self._is_signature_provider_envelope = is_signature_provider_envelope

    @property
    def last_modified_date_time(self):
        """
        Gets the last_modified_date_time of this Envelope.
        The date and time the item was last modified.

        :return: The last_modified_date_time of this Envelope.
        :rtype: str
        """
        return self._last_modified_date_time

    @last_modified_date_time.setter
    def last_modified_date_time(self, last_modified_date_time):
        """
        Sets the last_modified_date_time of this Envelope.
        The date and time the item was last modified.

        :param last_modified_date_time: The last_modified_date_time of this Envelope.
        :type: str
        """

        self._last_modified_date_time = last_modified_date_time

    @property
    def lock_information(self):
        """
        Gets the lock_information of this Envelope.

        :return: The lock_information of this Envelope.
        :rtype: LockInformation
        """
        return self._lock_information

    @lock_information.setter
    def lock_information(self, lock_information):
        """
        Sets the lock_information of this Envelope.

        :param lock_information: The lock_information of this Envelope.
        :type: LockInformation
        """

        self._lock_information = lock_information

    @property
    def message_lock(self):
        """
        Gets the message_lock of this Envelope.
        When set to **true**, prevents senders from changing the contents of `emailBlurb` and `emailSubject` properties for the envelope.   Additionally, this prevents users from making changes to the contents of `emailBlurb` and `emailSubject` properties when correcting envelopes.   However, if the `messageLock` node is set to true**** and the `emailSubject` property is empty, senders and correctors are able to add a subject to the envelope.

        :return: The message_lock of this Envelope.
        :rtype: str
        """
        return self._message_lock

    @message_lock.setter
    def message_lock(self, message_lock):
        """
        Sets the message_lock of this Envelope.
        When set to **true**, prevents senders from changing the contents of `emailBlurb` and `emailSubject` properties for the envelope.   Additionally, this prevents users from making changes to the contents of `emailBlurb` and `emailSubject` properties when correcting envelopes.   However, if the `messageLock` node is set to true**** and the `emailSubject` property is empty, senders and correctors are able to add a subject to the envelope.

        :param message_lock: The message_lock of this Envelope.
        :type: str
        """

        self._message_lock = message_lock

    @property
    def notification(self):
        """
        Gets the notification of this Envelope.

        :return: The notification of this Envelope.
        :rtype: Notification
        """
        return self._notification

    @notification.setter
    def notification(self, notification):
        """
        Sets the notification of this Envelope.

        :param notification: The notification of this Envelope.
        :type: Notification
        """

        self._notification = notification

    @property
    def notification_uri(self):
        """
        Gets the notification_uri of this Envelope.
        Contains a URI for an endpoint that you can use to retrieve the notifications.

        :return: The notification_uri of this Envelope.
        :rtype: str
        """
        return self._notification_uri

    @notification_uri.setter
    def notification_uri(self, notification_uri):
        """
        Sets the notification_uri of this Envelope.
        Contains a URI for an endpoint that you can use to retrieve the notifications.

        :param notification_uri: The notification_uri of this Envelope.
        :type: str
        """

        self._notification_uri = notification_uri

    @property
    def purge_state(self):
        """
        Gets the purge_state of this Envelope.
        

        :return: The purge_state of this Envelope.
        :rtype: str
        """
        return self._purge_state

    @purge_state.setter
    def purge_state(self, purge_state):
        """
        Sets the purge_state of this Envelope.
        

        :param purge_state: The purge_state of this Envelope.
        :type: str
        """

        self._purge_state = purge_state

    @property
    def recipients(self):
        """
        Gets the recipients of this Envelope.

        :return: The recipients of this Envelope.
        :rtype: Recipients
        """
        return self._recipients

    @recipients.setter
    def recipients(self, recipients):
        """
        Sets the recipients of this Envelope.

        :param recipients: The recipients of this Envelope.
        :type: Recipients
        """

        self._recipients = recipients

    @property
    def recipients_lock(self):
        """
        Gets the recipients_lock of this Envelope.
        When set to **true**, prevents senders from changing, correcting, or deleting the recipient information for the envelope.

        :return: The recipients_lock of this Envelope.
        :rtype: str
        """
        return self._recipients_lock

    @recipients_lock.setter
    def recipients_lock(self, recipients_lock):
        """
        Sets the recipients_lock of this Envelope.
        When set to **true**, prevents senders from changing, correcting, or deleting the recipient information for the envelope.

        :param recipients_lock: The recipients_lock of this Envelope.
        :type: str
        """

        self._recipients_lock = recipients_lock

    @property
    def recipients_uri(self):
        """
        Gets the recipients_uri of this Envelope.
        Contains a URI for an endpoint that you can use to retrieve the recipients.

        :return: The recipients_uri of this Envelope.
        :rtype: str
        """
        return self._recipients_uri

    @recipients_uri.setter
    def recipients_uri(self, recipients_uri):
        """
        Sets the recipients_uri of this Envelope.
        Contains a URI for an endpoint that you can use to retrieve the recipients.

        :param recipients_uri: The recipients_uri of this Envelope.
        :type: str
        """

        self._recipients_uri = recipients_uri

    @property
    def sent_date_time(self):
        """
        Gets the sent_date_time of this Envelope.
        The date and time the envelope was sent.

        :return: The sent_date_time of this Envelope.
        :rtype: str
        """
        return self._sent_date_time

    @sent_date_time.setter
    def sent_date_time(self, sent_date_time):
        """
        Sets the sent_date_time of this Envelope.
        The date and time the envelope was sent.

        :param sent_date_time: The sent_date_time of this Envelope.
        :type: str
        """

        self._sent_date_time = sent_date_time

    @property
    def signer_can_sign_on_mobile(self):
        """
        Gets the signer_can_sign_on_mobile of this Envelope.
        

        :return: The signer_can_sign_on_mobile of this Envelope.
        :rtype: str
        """
        return self._signer_can_sign_on_mobile

    @signer_can_sign_on_mobile.setter
    def signer_can_sign_on_mobile(self, signer_can_sign_on_mobile):
        """
        Sets the signer_can_sign_on_mobile of this Envelope.
        

        :param signer_can_sign_on_mobile: The signer_can_sign_on_mobile of this Envelope.
        :type: str
        """

        self._signer_can_sign_on_mobile = signer_can_sign_on_mobile

    @property
    def signing_location(self):
        """
        Gets the signing_location of this Envelope.
        Specifies the physical location where the signing takes place. It can have two enumeration values; InPerson and Online. The default value is Online.

        :return: The signing_location of this Envelope.
        :rtype: str
        """
        return self._signing_location

    @signing_location.setter
    def signing_location(self, signing_location):
        """
        Sets the signing_location of this Envelope.
        Specifies the physical location where the signing takes place. It can have two enumeration values; InPerson and Online. The default value is Online.

        :param signing_location: The signing_location of this Envelope.
        :type: str
        """

        self._signing_location = signing_location

    @property
    def status(self):
        """
        Gets the status of this Envelope.
        Indicates the envelope status. Valid values are:  * sent - The envelope is sent to the recipients.  *created - The envelope is saved as a draft and can be modified and sent later.

        :return: The status of this Envelope.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this Envelope.
        Indicates the envelope status. Valid values are:  * sent - The envelope is sent to the recipients.  *created - The envelope is saved as a draft and can be modified and sent later.

        :param status: The status of this Envelope.
        :type: str
        """

        self._status = status

    @property
    def status_changed_date_time(self):
        """
        Gets the status_changed_date_time of this Envelope.
        The data and time the status changed.

        :return: The status_changed_date_time of this Envelope.
        :rtype: str
        """
        return self._status_changed_date_time

    @status_changed_date_time.setter
    def status_changed_date_time(self, status_changed_date_time):
        """
        Sets the status_changed_date_time of this Envelope.
        The data and time the status changed.

        :param status_changed_date_time: The status_changed_date_time of this Envelope.
        :type: str
        """

        self._status_changed_date_time = status_changed_date_time

    @property
    def templates_uri(self):
        """
        Gets the templates_uri of this Envelope.
        Contains a URI for an endpoint which you can use to retrieve the templates.

        :return: The templates_uri of this Envelope.
        :rtype: str
        """
        return self._templates_uri

    @templates_uri.setter
    def templates_uri(self, templates_uri):
        """
        Sets the templates_uri of this Envelope.
        Contains a URI for an endpoint which you can use to retrieve the templates.

        :param templates_uri: The templates_uri of this Envelope.
        :type: str
        """

        self._templates_uri = templates_uri

    @property
    def transaction_id(self):
        """
        Gets the transaction_id of this Envelope.
         Used to identify an envelope. The id is a sender-generated value and is valid in the DocuSign system for 7 days. It is recommended that a transaction ID is used for offline signing to ensure that an envelope is not sent multiple times. The `transactionId` property can be used determine an envelope's status (i.e. was it created or not) in cases where the internet connection was lost before the envelope status was returned.

        :return: The transaction_id of this Envelope.
        :rtype: str
        """
        return self._transaction_id

    @transaction_id.setter
    def transaction_id(self, transaction_id):
        """
        Sets the transaction_id of this Envelope.
         Used to identify an envelope. The id is a sender-generated value and is valid in the DocuSign system for 7 days. It is recommended that a transaction ID is used for offline signing to ensure that an envelope is not sent multiple times. The `transactionId` property can be used determine an envelope's status (i.e. was it created or not) in cases where the internet connection was lost before the envelope status was returned.

        :param transaction_id: The transaction_id of this Envelope.
        :type: str
        """

        self._transaction_id = transaction_id

    @property
    def use_disclosure(self):
        """
        Gets the use_disclosure of this Envelope.
        When set to **true**, the disclosure is shown to recipients in accordance with the account's Electronic Record and Signature Disclosure frequency setting. When set to **false**, the Electronic Record and Signature Disclosure is not shown to any envelope recipients.   If the `useDisclosure` property is not set, then the account's normal disclosure setting is used and the value of the `useDisclosure` property is not returned in responses when getting envelope information.

        :return: The use_disclosure of this Envelope.
        :rtype: str
        """
        return self._use_disclosure

    @use_disclosure.setter
    def use_disclosure(self, use_disclosure):
        """
        Sets the use_disclosure of this Envelope.
        When set to **true**, the disclosure is shown to recipients in accordance with the account's Electronic Record and Signature Disclosure frequency setting. When set to **false**, the Electronic Record and Signature Disclosure is not shown to any envelope recipients.   If the `useDisclosure` property is not set, then the account's normal disclosure setting is used and the value of the `useDisclosure` property is not returned in responses when getting envelope information.

        :param use_disclosure: The use_disclosure of this Envelope.
        :type: str
        """

        self._use_disclosure = use_disclosure

    @property
    def voided_date_time(self):
        """
        Gets the voided_date_time of this Envelope.
        The date and time the envelope or template was voided.

        :return: The voided_date_time of this Envelope.
        :rtype: str
        """
        return self._voided_date_time

    @voided_date_time.setter
    def voided_date_time(self, voided_date_time):
        """
        Sets the voided_date_time of this Envelope.
        The date and time the envelope or template was voided.

        :param voided_date_time: The voided_date_time of this Envelope.
        :type: str
        """

        self._voided_date_time = voided_date_time

    @property
    def voided_reason(self):
        """
        Gets the voided_reason of this Envelope.
        The reason the envelope or template was voided.

        :return: The voided_reason of this Envelope.
        :rtype: str
        """
        return self._voided_reason

    @voided_reason.setter
    def voided_reason(self, voided_reason):
        """
        Sets the voided_reason of this Envelope.
        The reason the envelope or template was voided.

        :param voided_reason: The voided_reason of this Envelope.
        :type: str
        """

        self._voided_reason = voided_reason

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
