# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class DocumentTemplate(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, document_end_page=None, document_id=None, document_start_page=None, error_details=None, template_id=None):
        """
        DocumentTemplate - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'document_end_page': 'str',
            'document_id': 'str',
            'document_start_page': 'str',
            'error_details': 'ErrorDetails',
            'template_id': 'str'
        }

        self.attribute_map = {
            'document_end_page': 'documentEndPage',
            'document_id': 'documentId',
            'document_start_page': 'documentStartPage',
            'error_details': 'errorDetails',
            'template_id': 'templateId'
        }

        self._document_end_page = document_end_page
        self._document_id = document_id
        self._document_start_page = document_start_page
        self._error_details = error_details
        self._template_id = template_id

    @property
    def document_end_page(self):
        """
        Gets the document_end_page of this DocumentTemplate.
        

        :return: The document_end_page of this DocumentTemplate.
        :rtype: str
        """
        return self._document_end_page

    @document_end_page.setter
    def document_end_page(self, document_end_page):
        """
        Sets the document_end_page of this DocumentTemplate.
        

        :param document_end_page: The document_end_page of this DocumentTemplate.
        :type: str
        """

        self._document_end_page = document_end_page

    @property
    def document_id(self):
        """
        Gets the document_id of this DocumentTemplate.
        Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.

        :return: The document_id of this DocumentTemplate.
        :rtype: str
        """
        return self._document_id

    @document_id.setter
    def document_id(self, document_id):
        """
        Sets the document_id of this DocumentTemplate.
        Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.

        :param document_id: The document_id of this DocumentTemplate.
        :type: str
        """

        self._document_id = document_id

    @property
    def document_start_page(self):
        """
        Gets the document_start_page of this DocumentTemplate.
        

        :return: The document_start_page of this DocumentTemplate.
        :rtype: str
        """
        return self._document_start_page

    @document_start_page.setter
    def document_start_page(self, document_start_page):
        """
        Sets the document_start_page of this DocumentTemplate.
        

        :param document_start_page: The document_start_page of this DocumentTemplate.
        :type: str
        """

        self._document_start_page = document_start_page

    @property
    def error_details(self):
        """
        Gets the error_details of this DocumentTemplate.

        :return: The error_details of this DocumentTemplate.
        :rtype: ErrorDetails
        """
        return self._error_details

    @error_details.setter
    def error_details(self, error_details):
        """
        Sets the error_details of this DocumentTemplate.

        :param error_details: The error_details of this DocumentTemplate.
        :type: ErrorDetails
        """

        self._error_details = error_details

    @property
    def template_id(self):
        """
        Gets the template_id of this DocumentTemplate.
        The unique identifier of the template. If this is not provided, DocuSign will generate a value. 

        :return: The template_id of this DocumentTemplate.
        :rtype: str
        """
        return self._template_id

    @template_id.setter
    def template_id(self, template_id):
        """
        Sets the template_id of this DocumentTemplate.
        The unique identifier of the template. If this is not provided, DocuSign will generate a value. 

        :param template_id: The template_id of this DocumentTemplate.
        :type: str
        """

        self._template_id = template_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
